/** @fileoverview Auto-generated Externs files
 * @externs
 */
/**
 * EventDispatcher provides methods for managing queues of event listeners and dispatching events.
 * 
 * You can either extend EventDispatcher or mix its methods into an existing prototype or instance by using the
 * EventDispatcher {{#crossLink "EventDispatcher/initialize"}}{{/crossLink}} method.
 * 
 * Together with the CreateJS Event class, EventDispatcher provides an extended event model that is based on the
 * DOM Level 2 event model, including addEventListener, removeEventListener, and dispatchEvent. It supports
 * bubbling / capture, preventDefault, stopPropagation, stopImmediatePropagation, and handleEvent.
 * 
 * EventDispatcher also exposes a {{#crossLink "EventDispatcher/on"}}{{/crossLink}} method, which makes it easier
 * to create scoped listeners, listeners that only run once, and listeners with associated arbitrary data. The
 * {{#crossLink "EventDispatcher/off"}}{{/crossLink}} method is merely an alias to
 * {{#crossLink "EventDispatcher/removeEventListener"}}{{/crossLink}}.
 * 
 * Another addition to the DOM Level 2 model is the {{#crossLink "EventDispatcher/removeAllEventListeners"}}{{/crossLink}}
 * method, which can be used to listeners for all events, or listeners for a specific event. The Event object also
 * includes a {{#crossLink "Event/remove"}}{{/crossLink}} method which removes the active listener.
 * 
 * <h4>Example</h4>
 * Add EventDispatcher capabilities to the "MyClass" class.
 * 
 * createjs.EventDispatcher.initialize(MyClass.prototype);
 * 
 * Add an event (see {{#crossLink "EventDispatcher/addEventListener"}}{{/crossLink}}).
 * 
 * instance.addEventListener("eventName", handlerMethod);
 * function handlerMethod(event) {
 * console.log(event.target + " Was Clicked");
 * }
 * 
 * <b>Maintaining proper scope</b><br />
 * Scope (ie. "this") can be be a challenge with events. Using the {{#crossLink "EventDispatcher/on"}}{{/crossLink}}
 * method to subscribe to events simplifies this.
 * 
 * instance.addEventListener("click", function(event) {
 * console.log(instance == this); // false, scope is ambiguous.
 * });
 * 
 * instance.on("click", function(event) {
 * console.log(instance == this); // true, "on" uses dispatcher scope by default.
 * });
 * 
 * If you want to use addEventListener instead, you may want to use function.bind() or a similar proxy to manage scope.
 *
 * @see [EventDispatcher]
 * @constructor
 */
createjs.EventDispatcher = function () {}

    /**
     * Static initializer to mix EventDispatcher methods into a target object or prototype.
     * 
     * createjs.EventDispatcher.initialize(MyClass.prototype); // add to the prototype of the class
     * createjs.EventDispatcher.initialize(myObject); // add to a specific instance
     *
     * @param {(Object|null)} target The target object to inject EventDispatcher methods into. This can be an instance or a prototype.
     * @see [EventDispatcher]
     */
createjs.EventDispatcher.initialize = function (target) {  }

    /**
     * Indicates whether there is at least one listener for the specified event type on this object or any of its
     * ancestors (parent, parent's parent, etc). A return value of true indicates that if a bubbling event of the
     * specified type is dispatched from this object, it will trigger at least one listener.
     * 
     * This is similar to {{#crossLink "EventDispatcher/hasEventListener"}}{{/crossLink}}, but it searches the entire
     * event flow for a listener, not just this object.
     *
     * @param {string} type The string type of the event.
     * @see [EventDispatcher]
     * @returns {(boolean|null)} Returns `true` if there is at least one listener for the specified event.
     */
createjs.EventDispatcher.prototype.willTrigger = function (type) {  return null; }

    /**
     * Removes all listeners for the specified type, or all listeners of all types.
     * 
     * <h4>Example</h4>
     * 
     * // Remove all listeners
     * displayObject.removeAllEventListeners();
     * 
     * // Remove all click listeners
     * displayObject.removeAllEventListeners("click");
     *
     * @param {string=} opt_type The string type of the event. If omitted, all listeners for all types will be removed.
     * @see [EventDispatcher]
     */
createjs.EventDispatcher.prototype.removeAllEventListeners = function (opt_type) {  }

    /**
     * Adds the specified event listener. Note that adding multiple listeners to the same function will result in
     * multiple callbacks getting fired.
     * 
     * <h4>Example</h4>
     * 
     * displayObject.addEventListener("click", handleClick);
     * function handleClick(event) {
     * // Click happened.
     * }
     *
     * @param {string} type The string type of the event.
     * @param {(Object|null)} listener An object with a handleEvent method, or a function that will be called when the event is dispatched.
     * @param {boolean=} opt_useCapture For events that bubble, indicates whether to listen for the event in the capture or bubbling/target phase.
     * @see [EventDispatcher]
     * @returns {(Object|null)} Returns the listener for chaining or assignment.
     */
createjs.EventDispatcher.prototype.addEventListener = function (type, listener, opt_useCapture) {  return null; }

    /**
     * @param {(Event|Object|null)} eventObj 
     * @param {(Object|null)} eventPhase 
     * @see [EventDispatcher]
     */
createjs.EventDispatcher.prototype._dispatchEvent = function (eventObj, eventPhase) {  }

    /**
     * Dispatches the specified event to all listeners.
     * 
     * <h4>Example</h4>
     * 
     * // Use a string event
     * this.dispatchEvent("complete");
     * 
     * // Use an Event instance
     * var event = new createjs.Event("progress");
     * this.dispatchEvent(event);
     *
     * @param {(Event|Object|null)} eventObj An object with a "type" property, or a string type. While a generic object will work, it is recommended to use a CreateJS Event instance. If a string is used, dispatchEvent will construct an Event instance with the specified type.
     * @see [EventDispatcher]
     * @returns {(boolean|null)} Returns the value of eventObj.defaultPrevented.
     */
createjs.EventDispatcher.prototype.dispatchEvent = function (eventObj) {  return null; }

    /**
     * Removes the specified event listener.
     * 
     * <b>Important Note:</b> that you must pass the exact function reference used when the event was added. If a proxy
     * function, or function closure is used as the callback, the proxy/closure reference must be used - a new proxy or
     * closure will not work.
     * 
     * <h4>Example</h4>
     * 
     * displayObject.removeEventListener("click", handleClick);
     *
     * @param {string} type The string type of the event.
     * @param {(Object|null)} listener The listener function or object.
     * @param {boolean=} opt_useCapture For events that bubble, indicates whether to listen for the event in the capture or bubbling/target phase.
     * @see [EventDispatcher]
     */
createjs.EventDispatcher.prototype.removeEventListener = function (type, listener, opt_useCapture) {  }

    /**
     * A shortcut method for using addEventListener that makes it easier to specify an execution scope, have a listener
     * only run once, associate arbitrary data with the listener, and remove the listener.
     * 
     * This method works by creating an anonymous wrapper function and subscribing it with addEventListener.
     * The created anonymous function is returned for use with .removeEventListener (or .off).
     * 
     * <h4>Example</h4>
     * 
     * var listener = myBtn.on("click", handleClick, null, false, {count:3});
     * function handleClick(evt, data) {
     * data.count -= 1;
     * console.log(this == myBtn); // true - scope defaults to the dispatcher
     * if (data.count == 0) {
     * alert("clicked 3 times!");
     * myBtn.off("click", listener);
     * // alternately: evt.remove();
     * }
     * }
     *
     * @param {string} type The string type of the event.
     * @param {(Object|null)} listener An object with a handleEvent method, or a function that will be called when the event is dispatched.
     * @param {Object=} opt_scope The scope to execute the listener in. Defaults to the dispatcher/currentTarget for function listeners, and to the listener itself for object listeners (ie. using handleEvent).
     * @param {boolean=} opt_once If true, the listener will remove itself after the first time it is triggered.
     * @param {*=} opt_data Arbitrary data that will be included as the second parameter when the listener is called.
     * @param {boolean=} opt_useCapture For events that bubble, indicates whether to listen for the event in the capture or bubbling/target phase.
     * @see [EventDispatcher]
     * @returns {(Function|null)} Returns the anonymous function that was created and assigned as the listener. This is needed to remove the listener later using .removeEventListener.
     */
createjs.EventDispatcher.prototype.on = function (type, listener, opt_scope, opt_once, opt_data, opt_useCapture) {  return null; }

    /**
     * @see [EventDispatcher]
     * @returns {string} a string representation of the instance.
     */
createjs.EventDispatcher.prototype.toString = function () { return ''; }

    /**
     * Indicates whether there is at least one listener for the specified event type.
     *
     * @param {string} type The string type of the event.
     * @see [EventDispatcher]
     * @returns {(boolean|null)} Returns true if there is at least one listener for the specified event.
     */
createjs.EventDispatcher.prototype.hasEventListener = function (type) {  return null; }

