/** @fileoverview Auto-generated Externs files
 * @externs
 */
/**
 * Contains properties and methods shared by all events for use with
 * {{#crossLink "EventDispatcher"}}{{/crossLink}}.
 * 
 * Note that Event objects are often reused, so you should never
 * rely on an event object's state outside of the call stack it was received in.
 *
 * @see [Event]
 * @param {string} type The event type.
 * @param {(boolean|null)} bubbles Indicates whether the event will bubble through the display list.
 * @param {(boolean|null)} cancelable Indicates whether the default behaviour of this event can be cancelled.
 * @constructor
 */
createjs.Event = function (type, bubbles, cancelable) {}

    /**
     * Returns a clone of the Event instance.
     *
     * @see [Event]
     * @returns {(Event|null)} a clone of the Event instance.
     */
createjs.Event.prototype.clone = function () {  return null; }

    /**
     * Causes the active listener to be removed via removeEventListener();
     * 
     * myBtn.addEventListener("click", function(evt) {
     * // do stuff...
     * evt.remove(); // removes this listener.
     * });
     *
     * @see [Event]
     */
createjs.Event.prototype.remove = function () {  }

    /**
     * Provides a chainable shortcut method for setting a number of properties on the instance.
     *
     * @param {(Object|null)} props A generic object containing properties to copy to the instance.
     * @see [Event]
     * @returns {(Event|null)} Returns the instance the method is called on (useful for chaining calls.)
     */
createjs.Event.prototype.set = function (props) {  return null; }

    /**
     * Sets {{#crossLink "Event/propagationStopped"}}{{/crossLink}} to true.
     * Mirrors the DOM event standard.
     *
     * @see [Event]
     */
createjs.Event.prototype.stopPropagation = function () {  }

    /**
     * Sets {{#crossLink "Event/propagationStopped"}}{{/crossLink}} and
     * {{#crossLink "Event/immediatePropagationStopped"}}{{/crossLink}} to true.
     * Mirrors the DOM event standard.
     *
     * @see [Event]
     */
createjs.Event.prototype.stopImmediatePropagation = function () {  }

    /**
     * Returns a string representation of this object.
     *
     * @see [Event]
     * @returns {string} a string representation of the instance.
     */
createjs.Event.prototype.toString = function () { return ''; }

    /**
     * Sets {{#crossLink "Event/defaultPrevented"}}{{/crossLink}} to true.
     * Mirrors the DOM event standard.
     *
     * @see [Event]
     */
createjs.Event.prototype.preventDefault = function () {  }

