/* The following code was generated by JFlex 1.6.0 */

/*
 *
 *  Licensed to the Apache Software Foundation (ASF) under one or more
 *  contributor license agreements.  See the NOTICE file distributed with
 *  this work for additional information regarding copyright ownership.
 *  The ASF licenses this file to You under the Apache License, Version 2.0
 *  (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 */

package org.apache.flex.compiler.internal.parsing.mxml;

/*
 * RawMXMLTokenizer.java is generated from RawMXMLTokenizer.lex.
 * DO NOT MAKE EDITS DIRECTLY TO RawMXMLTokenizer.java.
 * THEY WILL BE LOST WHEN THE FILE IS GENERATED AGAIN.
 */

import antlr.Token;
import antlr.CommonToken;
import org.apache.flex.compiler.internal.parsing.mxml.BaseRawMXMLTokenizer;
import static org.apache.flex.compiler.parsing.MXMLTokenTypes.*;

@SuppressWarnings("all")


/**
 * This class is a scanner generated by 
 * <a href="http://www.jflex.de/">JFlex</a> 1.6.0
 * from the specification file <tt>/Users/aharui/git/flex/master/flex-falcon/compiler/src/main/jflex/org/apache/flex/compiler/internal/parsing/mxml/RawMXMLTokenizer.lex</tt>
 */
class RawMXMLTokenizer extends BaseRawMXMLTokenizer {
/*
 *
 *  Licensed to the Apache Software Foundation (ASF) under one or more
 *  contributor license agreements.  See the NOTICE file distributed with
 *  this work for additional information regarding copyright ownership.
 *  The ASF licenses this file to You under the Apache License, Version 2.0
 *  (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 */

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** initial size of the lookahead buffer */
  private static final int ZZ_BUFFERSIZE = 16384;

  /** lexical states */
  public static final int YYINITIAL = 0;
  public static final int CDATA = 2;
  public static final int COMMENT = 4;
  public static final int ASDOC_COMMENT = 6;
  public static final int DIRECTIVE = 8;
  public static final int MARKUP = 10;
  public static final int STRING1 = 12;
  public static final int STRING2 = 14;
  public static final int MARKUP_IGNORE = 16;
  public static final int STRING1_IGNORE = 18;
  public static final int STRING2_IGNORE = 20;
  public static final int WHITESPACE = 22;

  /**
   * ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l
   * ZZ_LEXSTATE[l+1] is the state in the DFA for the lexical state l
   *                  at the beginning of a line
   * l is of the form l = 2*k, k a non negative integer
   */
  private static final int ZZ_LEXSTATE[] = { 
     0,  0,  1,  1,  2,  2,  3,  3,  4,  4,  5,  5,  6,  6,  7,  7, 
     8,  8,  9,  9, 10, 10, 11, 11
  };

  /** 
   * Translates characters to character classes
   */
  private static final String ZZ_CMAP_PACKED = 
    "\10\0\2\4\1\4\1\33\1\33\1\4\22\0\1\4\1\7\1\35"+
    "\4\0\1\34\5\0\1\10\1\2\1\30\12\2\1\3\1\0\1\5"+
    "\1\37\1\32\1\6\1\0\1\25\1\1\1\13\1\11\1\17\3\1"+
    "\1\22\2\1\1\23\1\24\1\20\1\12\1\16\2\1\1\27\1\14"+
    "\3\1\1\36\1\15\1\1\1\31\1\0\1\40\1\0\1\1\1\0"+
    "\1\25\1\1\1\13\1\11\1\17\3\1\1\22\2\1\1\23\1\24"+
    "\1\20\1\12\1\16\2\1\1\27\1\14\3\1\1\36\1\15\1\1"+
    "\12\0\1\33\252\0\2\21\115\0\1\26\u1ea8\0\1\33\1\33\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\udfe6\0";

  /** 
   * Translates characters to character classes
   */
  private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

  /** 
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\1\0\4\1\1\2\2\1\3\3\1\0\1\4\1\5"+
    "\1\3\6\1\1\3\1\1\1\3\1\6\1\2\1\3"+
    "\1\7\1\3\1\10\1\11\1\12\1\6\1\13\1\1"+
    "\1\14\1\15\1\1\1\3\1\16\1\17\1\20\1\21"+
    "\1\3\1\22\1\23\1\3\1\24\1\25\1\26\2\0"+
    "\1\1\4\0\1\27\1\30\1\6\6\0\1\31\1\32"+
    "\1\33\1\34\1\6\1\35\6\0\1\6\1\36\6\0"+
    "\2\2\15\0\1\37\4\0\1\40";

  private static int [] zzUnpackAction() {
    int [] result = new int[107];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** 
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\41\0\102\0\143\0\204\0\245\0\306\0\347"+
    "\0\u0108\0\u0129\0\u014a\0\u016b\0\u018c\0\u01ad\0\u01ce\0\u01ef"+
    "\0\u0210\0\u0231\0\u0252\0\u0273\0\u0294\0\u02b5\0\u02d6\0\u02f7"+
    "\0\u0318\0\u0339\0\u035a\0\u02f7\0\u037b\0\u02f7\0\u02f7\0\u02f7"+
    "\0\u039c\0\u02f7\0\u03bd\0\u02f7\0\u02f7\0\u03de\0\u03ff\0\u02f7"+
    "\0\u02f7\0\u02f7\0\u02f7\0\u0420\0\u02f7\0\u02f7\0\u0441\0\u02f7"+
    "\0\u0462\0\u02f7\0\u0483\0\u04a4\0\u02f7\0\u04c5\0\u04e6\0\u0507"+
    "\0\u02d6\0\u02f7\0\u02f7\0\u0528\0\u0549\0\u056a\0\u058b\0\u05ac"+
    "\0\u05cd\0\u05ee\0\u060f\0\u02f7\0\u02f7\0\u02f7\0\u0630\0\u0651"+
    "\0\u0672\0\u0693\0\u06b4\0\u06d5\0\u06f6\0\u0717\0\u0738\0\u02f7"+
    "\0\u0759\0\u077a\0\u079b\0\u07bc\0\u07dd\0\u07fe\0\u081f\0\u0840"+
    "\0\u0861\0\u0882\0\u08a3\0\u08c4\0\u08e5\0\u0906\0\u0927\0\u0948"+
    "\0\u0969\0\u098a\0\u09ab\0\u09cc\0\u09ed\0\u02f7\0\u0a0e\0\u0a2f"+
    "\0\u0a50\0\u0a71\0\u02f7";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[107];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /** 
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\4\15\1\16\1\17\33\15\40\20\1\21\10\22\1\23"+
    "\40\22\1\24\30\22\4\25\1\26\1\25\1\27\32\25"+
    "\1\30\1\31\1\30\1\32\1\33\1\34\3\30\10\31"+
    "\1\30\4\31\1\30\1\31\1\35\1\30\1\36\1\0"+
    "\1\37\1\40\1\41\1\42\1\30\5\43\1\44\27\43"+
    "\1\45\3\43\5\46\1\44\26\46\1\45\4\46\5\47"+
    "\1\50\24\47\1\51\1\47\1\52\1\53\3\47\5\54"+
    "\1\55\27\54\1\56\3\54\5\57\1\55\26\57\1\56"+
    "\4\57\5\0\1\60\33\0\5\15\1\0\37\15\1\16"+
    "\1\0\33\15\1\0\1\61\1\0\1\61\2\0\1\62"+
    "\1\63\1\0\10\61\1\0\4\61\1\0\1\61\1\64"+
    "\5\0\1\61\2\0\40\20\1\0\32\65\1\0\5\65"+
    "\1\66\10\22\1\0\30\22\10\65\1\67\21\65\1\0"+
    "\16\65\1\70\21\65\1\0\6\65\6\25\1\0\36\25"+
    "\1\26\1\25\1\0\32\25\6\65\1\71\23\65\1\72"+
    "\6\65\42\0\3\31\5\0\10\31\1\0\4\31\1\0"+
    "\1\31\6\0\1\31\3\0\3\32\5\0\10\32\1\0"+
    "\4\32\1\0\1\32\6\0\1\32\6\0\1\33\66\0"+
    "\1\73\7\0\3\31\5\0\10\31\1\0\2\31\1\74"+
    "\1\31\1\0\1\31\6\0\1\31\2\0\5\43\1\0"+
    "\27\43\1\0\3\43\5\46\1\0\26\46\1\0\4\46"+
    "\5\47\1\0\24\47\1\0\1\47\2\0\3\47\5\54"+
    "\1\0\27\54\1\0\3\54\5\57\1\0\26\57\1\0"+
    "\4\57\1\0\3\61\5\0\10\61\1\0\4\61\1\0"+
    "\1\61\6\0\1\61\12\0\1\75\1\76\5\0\1\77"+
    "\1\100\4\0\1\101\3\0\1\102\10\0\1\103\1\0"+
    "\1\103\5\0\10\103\1\0\4\103\1\0\1\103\6\0"+
    "\1\103\2\0\32\65\1\104\5\65\1\66\10\65\1\67"+
    "\21\65\1\105\16\65\1\70\21\65\1\106\6\65\1\0"+
    "\3\31\5\0\10\31\1\0\1\31\1\107\2\31\1\0"+
    "\1\31\6\0\1\31\12\0\1\110\42\0\1\111\46\0"+
    "\1\112\2\0\1\113\27\0\1\114\42\0\1\115\37\0"+
    "\1\116\26\0\3\103\5\0\10\103\1\0\4\103\1\0"+
    "\1\103\6\0\1\103\3\0\3\31\5\0\7\31\1\117"+
    "\1\0\4\31\1\0\1\31\6\0\1\31\12\0\1\120"+
    "\43\0\1\121\41\0\1\122\43\0\1\123\35\0\1\124"+
    "\40\0\1\125\35\0\1\126\30\0\3\31\5\0\10\31"+
    "\1\0\4\31\1\127\1\130\6\0\1\31\16\0\1\131"+
    "\45\0\2\132\42\0\1\133\41\0\1\134\36\0\1\135"+
    "\42\0\1\136\16\0\1\32\36\0\2\31\1\32\5\0"+
    "\10\31\1\0\4\31\1\0\1\31\6\0\1\31\17\0"+
    "\1\137\37\0\1\140\43\0\1\141\35\0\1\142\45\0"+
    "\2\143\32\0\1\144\42\0\1\145\37\0\1\146\43\0"+
    "\1\147\41\0\2\150\44\0\2\147\36\0\1\151\32\0"+
    "\1\146\35\0\1\146\36\0\1\152\57\0\1\153\27\0"+
    "\1\146\20\0";

  private static int [] zzUnpackTrans() {
    int [] result = new int[2706];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String ZZ_ERROR_MSG[] = {
    "Unkown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\1\0\12\1\1\0\13\1\1\11\3\1\1\11\1\1"+
    "\3\11\1\1\1\11\1\1\2\11\2\1\4\11\1\1"+
    "\2\11\1\1\1\11\1\1\1\11\2\0\1\11\4\0"+
    "\2\11\1\1\6\0\1\1\3\11\2\1\6\0\1\1"+
    "\1\11\6\0\2\1\15\0\1\11\4\0\1\11";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[107];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char zzBuffer[] = new char[ZZ_BUFFERSIZE];

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /** number of newlines encountered up to the start of the matched text */
  private int yyline;

  /** the number of characters up to the start of the matched text */
  private int yychar;

  /**
   * the number of characters from the last newline up to the start of the 
   * matched text
   */
  private int yycolumn;

  /** 
   * zzAtBOL == true <=> the scanner is currently at the beginning of a line
   */
  private boolean zzAtBOL = true;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /** denotes if the user-EOF-code has already been executed */
  private boolean zzEOFDone;

  /* user code: */

/**
 * Nested '<' bracket level (for <!DOCTYPE et al)
 */
protected int bracketLevel;

/**
 * Get the current column of the tokenizer.
 */
public final int getColumn()
{
	return yycolumn;
}

/**
 * Unget one character
 */
protected final void unget()
{
	zzMarkedPos--;
}

public final int getLine()
{
	return yyline;
}

/**
 * Setter for the start offset from where the token's offsets will start
 */
public final void setOffset(int offset)
{
    yychar = offset;
}

public final int getOffset()
{
	return yychar;
}

public RawMXMLTokenizer()
{
}

protected final Token buildToken(int type, int start, int end, int line, int column, String text)
{
	return new MXMLToken(type, start, end, line, column, text);
}

public void reset()
{
	super.reset();
	bracketLevel = 0;
}

protected final void fillBuffer(StringBuilder builder)
{
	builder.append(zzBuffer, zzStartRead, zzMarkedPos - zzStartRead);
}



  /**
   * Creates a new scanner
   * There is also a java.io.InputStream version of this constructor.
   *
   * @param   in  the java.io.Reader to read input from.
   */
  /**
   * Creates a new scanner
   *
   * @param   in  the java.io.Reader to read input from.
   */
  RawMXMLTokenizer(java.io.Reader in) {
    this.zzReader = in;
  }


  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    char [] map = new char[0x110000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 192) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


  /**
   * Refills the input buffer.
   *
   * @return      <code>false</code>, iff there was new input.
   * 
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {

    /* first: make room (if you can) */
    if (zzStartRead > 0) {
      System.arraycopy(zzBuffer, zzStartRead,
                       zzBuffer, 0,
                       zzEndRead-zzStartRead);

      /* translate stored positions */
      zzEndRead-= zzStartRead;
      zzCurrentPos-= zzStartRead;
      zzMarkedPos-= zzStartRead;
      zzStartRead = 0;
    }

    /* is the buffer big enough? */
    if (zzCurrentPos >= zzBuffer.length) {
      /* if not: blow it up */
      char newBuffer[] = new char[zzCurrentPos*2];
      System.arraycopy(zzBuffer, 0, newBuffer, 0, zzBuffer.length);
      zzBuffer = newBuffer;
    }

    /* finally: fill the buffer with new input */
    int numRead = zzReader.read(zzBuffer, zzEndRead,
                                            zzBuffer.length-zzEndRead);

    if (numRead > 0) {
      zzEndRead+= numRead;
      return false;
    }
    // unlikely but not impossible: read 0 characters, but not at end of stream    
    if (numRead == 0) {
      int c = zzReader.read();
      if (c == -1) {
        return true;
      } else {
        zzBuffer[zzEndRead++] = (char) c;
        return false;
      }     
    }

	// numRead < 0
    return true;
  }

    
  /**
   * Closes the input stream.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true;            /* indicate end of file */
    zzEndRead = zzStartRead;  /* invalidate buffer    */

    if (zzReader != null)
      zzReader.close();
  }


  /**
   * Resets the scanner to read from a new input stream.
   * Does not close the old reader.
   *
   * All internal variables are reset, the old input stream 
   * <b>cannot</b> be reused (internal buffer is discarded and lost).
   * Lexical state is set to <tt>ZZ_INITIAL</tt>.
   *
   * Internal scan buffer is resized down to its initial length, if it has grown.
   *
   * @param reader   the new input stream 
   */
  public final void yyreset(java.io.Reader reader) {
    zzReader = reader;
    zzAtBOL  = true;
    zzAtEOF  = false;
    zzEOFDone = false;
    zzEndRead = zzStartRead = 0;
    zzCurrentPos = zzMarkedPos = 0;
    yyline = yychar = yycolumn = 0;
    zzLexicalState = YYINITIAL;
    if (zzBuffer.length > ZZ_BUFFERSIZE)
      zzBuffer = new char[ZZ_BUFFERSIZE];
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final String yytext() {
    return new String( zzBuffer, zzStartRead, zzMarkedPos-zzStartRead );
  }


  /**
   * Returns the character at position <tt>pos</tt> from the 
   * matched text. 
   * 
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch. 
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer[zzStartRead+pos];
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of 
   * yypushback(int) and a match-all fallback rule) this method 
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  } 


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public Token nextToken() throws java.io.IOException {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char [] zzBufferL = zzBuffer;
    char [] zzCMapL = ZZ_CMAP;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      yychar+= zzMarkedPosL-zzStartRead;

      boolean zzR = false;
      int zzCh;
      int zzCharCount;
      for (zzCurrentPosL = zzStartRead  ;
           zzCurrentPosL < zzMarkedPosL ;
           zzCurrentPosL += zzCharCount ) {
        zzCh = Character.codePointAt(zzBufferL, zzCurrentPosL, zzMarkedPosL);
        zzCharCount = Character.charCount(zzCh);
        switch (zzCh) {
        case '\u000B':
        case '\u000C':
        case '\u0085':
        case '\u2028':
        case '\u2029':
          yyline++;
          yycolumn = 0;
          zzR = false;
          break;
        case '\r':
          yyline++;
          yycolumn = 0;
          zzR = true;
          break;
        case '\n':
          if (zzR)
            zzR = false;
          else {
            yyline++;
            yycolumn = 0;
          }
          break;
        default:
          zzR = false;
          yycolumn += zzCharCount;
        }
      }

      if (zzR) {
        // peek one character ahead if it is \n (if we have counted one line too much)
        boolean zzPeek;
        if (zzMarkedPosL < zzEndReadL)
          zzPeek = zzBufferL[zzMarkedPosL] == '\n';
        else if (zzAtEOF)
          zzPeek = false;
        else {
          boolean eof = zzRefill();
          zzEndReadL = zzEndRead;
          zzMarkedPosL = zzMarkedPos;
          zzBufferL = zzBuffer;
          if (eof) 
            zzPeek = false;
          else 
            zzPeek = zzBufferL[zzMarkedPosL] == '\n';
        }
        if (zzPeek) yyline--;
      }
      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;
  
      zzState = ZZ_LEXSTATE[zzLexicalState];

      // set up zzAction for empty match case:
      int zzAttributes = zzAttrL[zzState];
      if ( (zzAttributes & 1) == 1 ) {
        zzAction = zzState;
      }


      zzForAction: {
        while (true) {
    
          if (zzCurrentPosL < zzEndReadL) {
            zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);
            zzCurrentPosL += Character.charCount(zzInput);
          }
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);
              zzCurrentPosL += Character.charCount(zzInput);
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMapL[zzInput] ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
        case 1: 
          { continueAggregate();
          }
        case 33: break;
        case 2: 
          { return buildToken(TOKEN_XMLNS);
          }
        case 34: break;
        case 3: 
          { 
          }
        case 35: break;
        case 4: 
          { return buildToken(TOKEN_TEXT);
          }
        case 36: break;
        case 5: 
          { startAggregate();
	yybegin(WHITESPACE);
          }
        case 37: break;
        case 6: 
          { return buildToken(TOKEN_NAME);
          }
        case 38: break;
        case 7: 
          { unget();
	yybegin(YYINITIAL);
          }
        case 39: break;
        case 8: 
          { yybegin(YYINITIAL);
	return buildToken(TOKEN_TAG_END);
          }
        case 40: break;
        case 9: 
          { startAggregate();
	yybegin(STRING2);
          }
        case 41: break;
        case 10: 
          { startAggregate();
	yybegin(STRING1);
          }
        case 42: break;
        case 11: 
          { return buildToken(TOKEN_EQUALS);
          }
        case 43: break;
        case 12: 
          { yybegin(MARKUP);
	unget();
	return buildAggregateToken(TOKEN_STRING);
          }
        case 44: break;
        case 13: 
          { yybegin(MARKUP);
	continueAggregate();
	return buildAggregateToken(TOKEN_STRING);
          }
        case 45: break;
        case 14: 
          { bracketLevel++;
          }
        case 46: break;
        case 15: 
          { bracketLevel--;
	if (bracketLevel == 0)
		yybegin(YYINITIAL);
          }
        case 47: break;
        case 16: 
          { yybegin(STRING2_IGNORE);
          }
        case 48: break;
        case 17: 
          { yybegin(STRING1_IGNORE);
          }
        case 49: break;
        case 18: 
          { yybegin(MARKUP_IGNORE);
	unget();
          }
        case 50: break;
        case 19: 
          { yybegin(MARKUP_IGNORE);
          }
        case 51: break;
        case 20: 
          { yybegin(YYINITIAL);
	unget();
	return buildAggregateToken(TOKEN_WHITESPACE);
          }
        case 52: break;
        case 21: 
          { Token token = buildToken(TOKEN_OPEN_TAG_START); 
    yybegin(MARKUP); 
	return token;
          }
        case 53: break;
        case 22: 
          { startAggregate();
	yybegin(DIRECTIVE);
          }
        case 54: break;
        case 23: 
          { continueAggregate();
	yybegin(YYINITIAL);
	return buildAggregateToken(TOKEN_PROCESSING_INSTRUCTION);
          }
        case 55: break;
        case 24: 
          { yybegin(YYINITIAL);
	return buildToken(TOKEN_EMPTY_TAG_END);
          }
        case 56: break;
        case 25: 
          { yybegin(MARKUP);
	return buildToken(TOKEN_CLOSE_TAG_START);
          }
        case 57: break;
        case 26: 
          { continueAggregate();
	yybegin(YYINITIAL);
	return buildAggregateToken(TOKEN_CDATA);
          }
        case 58: break;
        case 27: 
          { continueAggregate();
	yybegin(YYINITIAL);
	return buildAggregateToken(TOKEN_COMMENT);
          }
        case 59: break;
        case 28: 
          { continueAggregate();
	yybegin(YYINITIAL);
	return buildAggregateToken(TOKEN_ASDOC_COMMENT);
          }
        case 60: break;
        case 29: 
          { startAggregate();
	yybegin(COMMENT);
          }
        case 61: break;
        case 30: 
          { startAggregate();
	yybegin(ASDOC_COMMENT);
          }
        case 62: break;
        case 31: 
          { yybegin(MARKUP_IGNORE);
	bracketLevel = 1;
          }
        case 63: break;
        case 32: 
          { startAggregate();
	yybegin(CDATA);
          }
        case 64: break;
        default: 
          if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
            zzAtEOF = true;
            switch (zzLexicalState) {
            case CDATA: {
              continueAggregate();
	yybegin(YYINITIAL);
	return buildAggregateToken(TOKEN_CDATA);
            }
            case 108: break;
            case COMMENT: {
              continueAggregate();
	yybegin(YYINITIAL);
	return buildAggregateToken(TOKEN_COMMENT);
            }
            case 109: break;
            case ASDOC_COMMENT: {
              continueAggregate();
	yybegin(YYINITIAL);
	return buildAggregateToken(TOKEN_ASDOC_COMMENT);
            }
            case 110: break;
            case DIRECTIVE: {
              continueAggregate();
	yybegin(YYINITIAL);
	return buildAggregateToken(TOKEN_PROCESSING_INSTRUCTION);
            }
            case 111: break;
            case STRING1: {
              yybegin(MARKUP);
	continueAggregate();
	return buildAggregateToken(TOKEN_STRING);
            }
            case 112: break;
            case STRING2: {
              yybegin(MARKUP);
	continueAggregate();
	return buildAggregateToken(TOKEN_STRING);
            }
            case 113: break;
            case WHITESPACE: {
              yybegin(YYINITIAL);
	return buildAggregateToken(TOKEN_WHITESPACE);
            }
            case 114: break;
            default:
            return null;
            }
          } 
          else {
            zzScanError(ZZ_NO_MATCH);
          }
      }
    }
  }


}
