// $ANTLR 3.5.2 /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g 2016-09-05 07:02:32

/*
 *
 *  Licensed to the Apache Software Foundation (ASF) under one or more
 *  contributor license agreements.  See the NOTICE file distributed with
 *  this work for additional information regarding copyright ownership.
 *  The ASF licenses this file to You under the Apache License, Version 2.0
 *  (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 */
	
package org.apache.flex.compiler.internal.css;

import java.util.Map;
import java.util.HashMap;
import org.apache.flex.compiler.css.*;
import org.apache.flex.compiler.problems.CSSParserProblem;



import org.antlr.runtime.*;
import org.antlr.runtime.tree.*;
import java.util.Stack;
import java.util.List;
import java.util.ArrayList;

/**
 * This is a tree grammar for advanced CSS in Flex. It walks the AST generated 
 * by the CSS parser and builds CSS DOM objects.
 */
@SuppressWarnings("all")
public class CSSTree extends TreeParser {
	public static final String[] tokenNames = new String[] {
		"<invalid>", "<EOR>", "<DOWN>", "<UP>", "ALPHA_VALUE", "ARGUMENTS", "AT_FONT_FACE", 
		"AT_KEYFRAMES", "AT_MEDIA", "AT_NAMESPACE", "AT_WEBKIT_KEYFRAMES", "BEGINS_WITH", 
		"BLOCK_END", "BLOCK_OPEN", "CLASS_REFERENCE", "COLON", "COMMA", "COMMENT", 
		"CONTAINS", "DIGIT", "DOT", "DOUBLE_COLON", "EMBED", "ENDS_WITH", "EQUALS", 
		"ESCAPED_HEX", "FORMAT", "HASH_WORD", "HEX_DIGIT", "HREFLANG_MATCH", "ID", 
		"IMPORTANT", "I_ARRAY", "I_DECL", "I_MEDIUM_CONDITIONS", "I_RULE", "I_RULES", 
		"I_SELECTOR", "I_SELECTOR_GROUP", "I_SIMPLE_SELECTOR", "LETTER", "LIST_MATCH", 
		"LOCAL", "NOT", "NULL", "NUMBER", "NUMBER_WITH_PERCENT", "NUMBER_WITH_UNIT", 
		"ONLY", "OPERATOR", "PERCENT", "PIPE", "PROPERTY_REFERENCE", "RECT_VALUE", 
		"RGB", "RGBA", "ROTATE_VALUE", "SCALE", "SCALE_VALUE", "SEMI_COLONS", 
		"SQUARE_END", "SQUARE_OPEN", "STAR", "STRING", "STRING_QUOTE", "TILDE", 
		"TRANSLATE3D_VALUE", "URL", "WS", "'+'", "'>'", "'and'"
	};
	public static final int EOF=-1;
	public static final int T__69=69;
	public static final int T__70=70;
	public static final int T__71=71;
	public static final int ALPHA_VALUE=4;
	public static final int ARGUMENTS=5;
	public static final int AT_FONT_FACE=6;
	public static final int AT_KEYFRAMES=7;
	public static final int AT_MEDIA=8;
	public static final int AT_NAMESPACE=9;
	public static final int AT_WEBKIT_KEYFRAMES=10;
	public static final int BEGINS_WITH=11;
	public static final int BLOCK_END=12;
	public static final int BLOCK_OPEN=13;
	public static final int CLASS_REFERENCE=14;
	public static final int COLON=15;
	public static final int COMMA=16;
	public static final int COMMENT=17;
	public static final int CONTAINS=18;
	public static final int DIGIT=19;
	public static final int DOT=20;
	public static final int DOUBLE_COLON=21;
	public static final int EMBED=22;
	public static final int ENDS_WITH=23;
	public static final int EQUALS=24;
	public static final int ESCAPED_HEX=25;
	public static final int FORMAT=26;
	public static final int HASH_WORD=27;
	public static final int HEX_DIGIT=28;
	public static final int HREFLANG_MATCH=29;
	public static final int ID=30;
	public static final int IMPORTANT=31;
	public static final int I_ARRAY=32;
	public static final int I_DECL=33;
	public static final int I_MEDIUM_CONDITIONS=34;
	public static final int I_RULE=35;
	public static final int I_RULES=36;
	public static final int I_SELECTOR=37;
	public static final int I_SELECTOR_GROUP=38;
	public static final int I_SIMPLE_SELECTOR=39;
	public static final int LETTER=40;
	public static final int LIST_MATCH=41;
	public static final int LOCAL=42;
	public static final int NOT=43;
	public static final int NULL=44;
	public static final int NUMBER=45;
	public static final int NUMBER_WITH_PERCENT=46;
	public static final int NUMBER_WITH_UNIT=47;
	public static final int ONLY=48;
	public static final int OPERATOR=49;
	public static final int PERCENT=50;
	public static final int PIPE=51;
	public static final int PROPERTY_REFERENCE=52;
	public static final int RECT_VALUE=53;
	public static final int RGB=54;
	public static final int RGBA=55;
	public static final int ROTATE_VALUE=56;
	public static final int SCALE=57;
	public static final int SCALE_VALUE=58;
	public static final int SEMI_COLONS=59;
	public static final int SQUARE_END=60;
	public static final int SQUARE_OPEN=61;
	public static final int STAR=62;
	public static final int STRING=63;
	public static final int STRING_QUOTE=64;
	public static final int TILDE=65;
	public static final int TRANSLATE3D_VALUE=66;
	public static final int URL=67;
	public static final int WS=68;

	// delegates
	public TreeParser[] getDelegates() {
		return new TreeParser[] {};
	}

	// delegators


	public CSSTree(TreeNodeStream input) {
		this(input, new RecognizerSharedState());
	}
	public CSSTree(TreeNodeStream input, RecognizerSharedState state) {
		super(input, state);
	}

	@Override public String[] getTokenNames() { return CSSTree.tokenNames; }
	@Override public String getGrammarFileName() { return "/Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g"; }



	/**
	 * CSS DOM object.
	 */
	protected CSSDocument model;

	/**
	 * Every definition object needs the token stream to compute source location.
	 */
	private final TokenStream tokenStream = getTreeNodeStream().getTokenStream();

	/**
	 * Tree walker problems.
	 */
	protected List<CSSParserProblem> problems = new ArrayList<CSSParserProblem>();

	/**
	 * Used for building up attribute selector strings until we implement a data
	 * structure for it.
	 */
	protected String curAttribute;


	/**
	 * Collect problems.
	 */
	@Override
	public void displayRecognitionError(String[] tokenNames, RecognitionException e)
	{
	    problems.add(CSSParserProblem.create(this, tokenNames, e));
	}


	protected static class stylesheet_scope {
		List<CSSNamespaceDefinition> namespaces;
		List<CSSRule> rules;
		List<CSSFontFace> fontFaces;
		List<CSSKeyFrames> keyFrames;
	}
	protected Stack<stylesheet_scope> stylesheet_stack = new Stack<stylesheet_scope>();

	public static class stylesheet_return extends TreeRuleReturnScope {
	};


	// $ANTLR start "stylesheet"
	// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:98:1: stylesheet : ( namespaceStatement | fontFace | keyframes | mediaQuery | ruleset )* ;
	public final CSSTree.stylesheet_return stylesheet() throws RecognitionException {
		stylesheet_stack.push(new stylesheet_scope());
		CSSTree.stylesheet_return retval = new CSSTree.stylesheet_return();
		retval.start = input.LT(1);


		    stylesheet_stack.peek().rules = new ArrayList<CSSRule>();
		    stylesheet_stack.peek().namespaces = new ArrayList<CSSNamespaceDefinition>();
		    stylesheet_stack.peek().fontFaces = new ArrayList<CSSFontFace>();
		    stylesheet_stack.peek().keyFrames = new ArrayList<CSSKeyFrames>();

		try {
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:125:5: ( ( namespaceStatement | fontFace | keyframes | mediaQuery | ruleset )* )
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:125:9: ( namespaceStatement | fontFace | keyframes | mediaQuery | ruleset )*
			{
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:125:9: ( namespaceStatement | fontFace | keyframes | mediaQuery | ruleset )*
			loop1:
			while (true) {
				int alt1=6;
				switch ( input.LA(1) ) {
				case AT_NAMESPACE:
					{
					alt1=1;
					}
					break;
				case AT_FONT_FACE:
					{
					alt1=2;
					}
					break;
				case AT_KEYFRAMES:
				case AT_WEBKIT_KEYFRAMES:
					{
					alt1=3;
					}
					break;
				case AT_MEDIA:
					{
					alt1=4;
					}
					break;
				case I_RULE:
					{
					alt1=5;
					}
					break;
				}
				switch (alt1) {
				case 1 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:125:11: namespaceStatement
					{
					pushFollow(FOLLOW_namespaceStatement_in_stylesheet94);
					namespaceStatement();
					state._fsp--;

					}
					break;
				case 2 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:125:32: fontFace
					{
					pushFollow(FOLLOW_fontFace_in_stylesheet98);
					fontFace();
					state._fsp--;

					}
					break;
				case 3 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:125:43: keyframes
					{
					pushFollow(FOLLOW_keyframes_in_stylesheet102);
					keyframes();
					state._fsp--;

					}
					break;
				case 4 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:125:55: mediaQuery
					{
					pushFollow(FOLLOW_mediaQuery_in_stylesheet106);
					mediaQuery();
					state._fsp--;

					}
					break;
				case 5 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:125:68: ruleset
					{
					pushFollow(FOLLOW_ruleset_in_stylesheet110);
					ruleset();
					state._fsp--;

					}
					break;

				default :
					break loop1;
				}
			}

			}


			    model = new CSSDocument(stylesheet_stack.peek().rules, 
			                            stylesheet_stack.peek().namespaces, 
			                            stylesheet_stack.peek().fontFaces,
			                            ((CommonTree)retval.start),
			                            tokenStream);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
			stylesheet_stack.pop();
		}
		return retval;
	}
	// $ANTLR end "stylesheet"


	public static class namespaceStatement_return extends TreeRuleReturnScope {
	};


	// $ANTLR start "namespaceStatement"
	// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:128:1: namespaceStatement : ^( AT_NAMESPACE (id= ID )? uri= STRING ) ;
	public final CSSTree.namespaceStatement_return namespaceStatement() throws RecognitionException {
		CSSTree.namespaceStatement_return retval = new CSSTree.namespaceStatement_return();
		retval.start = input.LT(1);

		CommonTree id=null;
		CommonTree uri=null;

		try {
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:135:5: ( ^( AT_NAMESPACE (id= ID )? uri= STRING ) )
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:135:9: ^( AT_NAMESPACE (id= ID )? uri= STRING )
			{
			match(input,AT_NAMESPACE,FOLLOW_AT_NAMESPACE_in_namespaceStatement146); 
			match(input, Token.DOWN, null); 
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:135:26: (id= ID )?
			int alt2=2;
			int LA2_0 = input.LA(1);
			if ( (LA2_0==ID) ) {
				alt2=1;
			}
			switch (alt2) {
				case 1 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:135:26: id= ID
					{
					id=(CommonTree)match(input,ID,FOLLOW_ID_in_namespaceStatement150); 
					}
					break;

			}

			uri=(CommonTree)match(input,STRING,FOLLOW_STRING_in_namespaceStatement155); 
			match(input, Token.UP, null); 

			}

			 
			    final CSSNamespaceDefinition ns = new CSSNamespaceDefinition(
			            (id!=null?id.getText():null), (uri!=null?uri.getText():null), ((CommonTree)retval.start), tokenStream);
			    stylesheet_stack.peek().namespaces.add(ns); 

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "namespaceStatement"


	public static class keyframes_return extends TreeRuleReturnScope {
	};


	// $ANTLR start "keyframes"
	// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:138:1: keyframes : ( ^( AT_KEYFRAMES id= ID ( ruleset )* ) | ^( AT_WEBKIT_KEYFRAMES id= ID ( ruleset )* ) );
	public final CSSTree.keyframes_return keyframes() throws RecognitionException {
		CSSTree.keyframes_return retval = new CSSTree.keyframes_return();
		retval.start = input.LT(1);

		CommonTree id=null;

		try {
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:139:5: ( ^( AT_KEYFRAMES id= ID ( ruleset )* ) | ^( AT_WEBKIT_KEYFRAMES id= ID ( ruleset )* ) )
			int alt5=2;
			int LA5_0 = input.LA(1);
			if ( (LA5_0==AT_KEYFRAMES) ) {
				alt5=1;
			}
			else if ( (LA5_0==AT_WEBKIT_KEYFRAMES) ) {
				alt5=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 5, 0, input);
				throw nvae;
			}

			switch (alt5) {
				case 1 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:139:9: ^( AT_KEYFRAMES id= ID ( ruleset )* )
					{
					match(input,AT_KEYFRAMES,FOLLOW_AT_KEYFRAMES_in_keyframes178); 
					match(input, Token.DOWN, null); 
					id=(CommonTree)match(input,ID,FOLLOW_ID_in_keyframes182); 
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:139:30: ( ruleset )*
					loop3:
					while (true) {
						int alt3=2;
						int LA3_0 = input.LA(1);
						if ( (LA3_0==I_RULE) ) {
							alt3=1;
						}

						switch (alt3) {
						case 1 :
							// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:139:30: ruleset
							{
							pushFollow(FOLLOW_ruleset_in_keyframes184);
							ruleset();
							state._fsp--;

							}
							break;

						default :
							break loop3;
						}
					}

					match(input, Token.UP, null); 

					 stylesheet_stack.peek().keyFrames.add(new CSSKeyFrames((id!=null?id.getText():null), CSSModelTreeType.KEYFRAMES, ((CommonTree)retval.start), tokenStream)); 
					}
					break;
				case 2 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:141:9: ^( AT_WEBKIT_KEYFRAMES id= ID ( ruleset )* )
					{
					match(input,AT_WEBKIT_KEYFRAMES,FOLLOW_AT_WEBKIT_KEYFRAMES_in_keyframes208); 
					match(input, Token.DOWN, null); 
					id=(CommonTree)match(input,ID,FOLLOW_ID_in_keyframes212); 
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:141:37: ( ruleset )*
					loop4:
					while (true) {
						int alt4=2;
						int LA4_0 = input.LA(1);
						if ( (LA4_0==I_RULE) ) {
							alt4=1;
						}

						switch (alt4) {
						case 1 :
							// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:141:37: ruleset
							{
							pushFollow(FOLLOW_ruleset_in_keyframes214);
							ruleset();
							state._fsp--;

							}
							break;

						default :
							break loop4;
						}
					}

					match(input, Token.UP, null); 

					 stylesheet_stack.peek().keyFrames.add(new CSSKeyFrames((id!=null?id.getText():null), CSSModelTreeType.KEYFRAMES_WEBKIT, ((CommonTree)retval.start), tokenStream)); 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "keyframes"


	protected static class mediaQuery_scope {
		List<CSSMediaQueryCondition> conditions;
	}
	protected Stack<mediaQuery_scope> mediaQuery_stack = new Stack<mediaQuery_scope>();


	// $ANTLR start "mediaQuery"
	// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:146:1: mediaQuery : ^( AT_MEDIA medium ( ruleset )* ) ;
	public final void mediaQuery() throws RecognitionException {
		mediaQuery_stack.push(new mediaQuery_scope());
		 
		    mediaQuery_stack.peek().conditions = new ArrayList<CSSMediaQueryCondition>(); 

		try {
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:156:5: ( ^( AT_MEDIA medium ( ruleset )* ) )
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:156:9: ^( AT_MEDIA medium ( ruleset )* )
			{
			match(input,AT_MEDIA,FOLLOW_AT_MEDIA_in_mediaQuery261); 
			match(input, Token.DOWN, null); 
			pushFollow(FOLLOW_medium_in_mediaQuery263);
			medium();
			state._fsp--;

			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:156:27: ( ruleset )*
			loop6:
			while (true) {
				int alt6=2;
				int LA6_0 = input.LA(1);
				if ( (LA6_0==I_RULE) ) {
					alt6=1;
				}

				switch (alt6) {
				case 1 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:156:27: ruleset
					{
					pushFollow(FOLLOW_ruleset_in_mediaQuery265);
					ruleset();
					state._fsp--;

					}
					break;

				default :
					break loop6;
				}
			}

			match(input, Token.UP, null); 

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
			mediaQuery_stack.pop();
		}
	}
	// $ANTLR end "mediaQuery"



	// $ANTLR start "medium"
	// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:159:1: medium : ^( I_MEDIUM_CONDITIONS ( mediumCondition )* ) ;
	public final void medium() throws RecognitionException {
		try {
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:160:5: ( ^( I_MEDIUM_CONDITIONS ( mediumCondition )* ) )
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:160:9: ^( I_MEDIUM_CONDITIONS ( mediumCondition )* )
			{
			match(input,I_MEDIUM_CONDITIONS,FOLLOW_I_MEDIUM_CONDITIONS_in_medium290); 
			if ( input.LA(1)==Token.DOWN ) {
				match(input, Token.DOWN, null); 
				// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:160:31: ( mediumCondition )*
				loop7:
				while (true) {
					int alt7=2;
					int LA7_0 = input.LA(1);
					if ( (LA7_0==ARGUMENTS||LA7_0==COMMA||LA7_0==ID||LA7_0==ONLY) ) {
						alt7=1;
					}

					switch (alt7) {
					case 1 :
						// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:160:31: mediumCondition
						{
						pushFollow(FOLLOW_mediumCondition_in_medium292);
						mediumCondition();
						state._fsp--;

						}
						break;

					default :
						break loop7;
					}
				}

				match(input, Token.UP, null); 
			}

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "medium"


	public static class mediumCondition_return extends TreeRuleReturnScope {
	};


	// $ANTLR start "mediumCondition"
	// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:163:1: mediumCondition : ( ID | ONLY id= ID | ARGUMENTS | COMMA );
	public final CSSTree.mediumCondition_return mediumCondition() throws RecognitionException {
		CSSTree.mediumCondition_return retval = new CSSTree.mediumCondition_return();
		retval.start = input.LT(1);

		CommonTree id=null;

		try {
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:164:5: ( ID | ONLY id= ID | ARGUMENTS | COMMA )
			int alt8=4;
			switch ( input.LA(1) ) {
			case ID:
				{
				alt8=1;
				}
				break;
			case ONLY:
				{
				alt8=2;
				}
				break;
			case ARGUMENTS:
				{
				alt8=3;
				}
				break;
			case COMMA:
				{
				alt8=4;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 8, 0, input);
				throw nvae;
			}
			switch (alt8) {
				case 1 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:164:9: ID
					{
					match(input,ID,FOLLOW_ID_in_mediumCondition315); 
					 
					        mediaQuery_stack.peek().conditions.add(new CSSMediaQueryCondition(((CommonTree)retval.start), tokenStream)); 
					    
					}
					break;
				case 2 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:168:7: ONLY id= ID
					{
					match(input,ONLY,FOLLOW_ONLY_in_mediumCondition331); 
					id=(CommonTree)match(input,ID,FOLLOW_ID_in_mediumCondition335); 
					 
					        mediaQuery_stack.peek().conditions.add(new CSSMediaQueryCondition(((CommonTree)retval.start), tokenStream)); 
					        mediaQuery_stack.peek().conditions.add(new CSSMediaQueryCondition(id, tokenStream)); 
					    
					}
					break;
				case 3 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:173:7: ARGUMENTS
					{
					match(input,ARGUMENTS,FOLLOW_ARGUMENTS_in_mediumCondition351); 
					 
					        mediaQuery_stack.peek().conditions.add(new CSSMediaQueryCondition(((CommonTree)retval.start), tokenStream)); 
					    
					}
					break;
				case 4 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:177:7: COMMA
					{
					match(input,COMMA,FOLLOW_COMMA_in_mediumCondition366); 
					 
					        mediaQuery_stack.peek().conditions.add(new CSSMediaQueryCondition(((CommonTree)retval.start), tokenStream)); 
					    
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "mediumCondition"


	public static class fontFace_return extends TreeRuleReturnScope {
	};


	// $ANTLR start "fontFace"
	// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:183:1: fontFace : ^( AT_FONT_FACE d= declarationsBlock ) ;
	public final CSSTree.fontFace_return fontFace() throws RecognitionException {
		CSSTree.fontFace_return retval = new CSSTree.fontFace_return();
		retval.start = input.LT(1);

		List<CSSProperty> d =null;

		try {
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:189:5: ( ^( AT_FONT_FACE d= declarationsBlock ) )
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:189:9: ^( AT_FONT_FACE d= declarationsBlock )
			{
			match(input,AT_FONT_FACE,FOLLOW_AT_FONT_FACE_in_fontFace402); 
			match(input, Token.DOWN, null); 
			pushFollow(FOLLOW_declarationsBlock_in_fontFace406);
			d=declarationsBlock();
			state._fsp--;

			match(input, Token.UP, null); 

			}


			    final CSSFontFace fontFace = new CSSFontFace(d, ((CommonTree)retval.start), tokenStream);
			    stylesheet_stack.peek().fontFaces.add(fontFace);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "fontFace"


	protected static class ruleset_scope {
		List<CSSSelector> subjects;
	}
	protected Stack<ruleset_scope> ruleset_stack = new Stack<ruleset_scope>();

	public static class ruleset_return extends TreeRuleReturnScope {
	};


	// $ANTLR start "ruleset"
	// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:192:1: ruleset : ^( I_RULE selectorGroup d= declarationsBlock ) ;
	public final CSSTree.ruleset_return ruleset() throws RecognitionException {
		ruleset_stack.push(new ruleset_scope());
		CSSTree.ruleset_return retval = new CSSTree.ruleset_return();
		retval.start = input.LT(1);

		List<CSSProperty> d =null;


		    ruleset_stack.peek().subjects = new ArrayList<CSSSelector>();

		try {
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:218:5: ( ^( I_RULE selectorGroup d= declarationsBlock ) )
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:218:9: ^( I_RULE selectorGroup d= declarationsBlock )
			{
			match(input,I_RULE,FOLLOW_I_RULE_in_ruleset446); 
			match(input, Token.DOWN, null); 
			pushFollow(FOLLOW_selectorGroup_in_ruleset448);
			selectorGroup();
			state._fsp--;

			pushFollow(FOLLOW_declarationsBlock_in_ruleset452);
			d=declarationsBlock();
			state._fsp--;

			match(input, Token.UP, null); 

			}


			    final List<CSSMediaQueryCondition> mediaQueryConditions;
			    if (mediaQuery_stack.isEmpty())
			        mediaQueryConditions = null;
			    else
			        mediaQueryConditions = mediaQuery_stack.peek().conditions;
			    
			    final CSSRule cssRule = new CSSRule(
			            mediaQueryConditions,
			            ruleset_stack.peek().subjects,
			            d, 
			            ((CommonTree)retval.start), 
			            tokenStream);
			    stylesheet_stack.peek().rules.add(cssRule);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
			ruleset_stack.pop();
		}
		return retval;
	}
	// $ANTLR end "ruleset"



	// $ANTLR start "selectorGroup"
	// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:221:1: selectorGroup : ^( I_SELECTOR_GROUP ( compoundSelector )+ ) ;
	public final void selectorGroup() throws RecognitionException {
		try {
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:222:5: ( ^( I_SELECTOR_GROUP ( compoundSelector )+ ) )
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:222:8: ^( I_SELECTOR_GROUP ( compoundSelector )+ )
			{
			match(input,I_SELECTOR_GROUP,FOLLOW_I_SELECTOR_GROUP_in_selectorGroup472); 
			match(input, Token.DOWN, null); 
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:222:27: ( compoundSelector )+
			int cnt9=0;
			loop9:
			while (true) {
				int alt9=2;
				int LA9_0 = input.LA(1);
				if ( (LA9_0==I_SELECTOR) ) {
					alt9=1;
				}

				switch (alt9) {
				case 1 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:222:27: compoundSelector
					{
					pushFollow(FOLLOW_compoundSelector_in_selectorGroup474);
					compoundSelector();
					state._fsp--;

					}
					break;

				default :
					if ( cnt9 >= 1 ) break loop9;
					EarlyExitException eee = new EarlyExitException(9, input);
					throw eee;
				}
				cnt9++;
			}

			match(input, Token.UP, null); 

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "selectorGroup"



	// $ANTLR start "compoundSelector"
	// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:225:1: compoundSelector : ^( I_SELECTOR ( simpleSelector[simpleSelectorStack] )+ ) ;
	public final void compoundSelector() throws RecognitionException {

		    final Stack<CSSSelector> simpleSelectorStack = new Stack<CSSSelector>();

		try {
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:234:5: ( ^( I_SELECTOR ( simpleSelector[simpleSelectorStack] )+ ) )
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:234:9: ^( I_SELECTOR ( simpleSelector[simpleSelectorStack] )+ )
			{
			match(input,I_SELECTOR,FOLLOW_I_SELECTOR_in_compoundSelector510); 
			match(input, Token.DOWN, null); 
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:234:22: ( simpleSelector[simpleSelectorStack] )+
			int cnt10=0;
			loop10:
			while (true) {
				int alt10=2;
				int LA10_0 = input.LA(1);
				if ( (LA10_0==I_SIMPLE_SELECTOR) ) {
					alt10=1;
				}

				switch (alt10) {
				case 1 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:234:22: simpleSelector[simpleSelectorStack]
					{
					pushFollow(FOLLOW_simpleSelector_in_compoundSelector512);
					simpleSelector(simpleSelectorStack);
					state._fsp--;

					}
					break;

				default :
					if ( cnt10 >= 1 ) break loop10;
					EarlyExitException eee = new EarlyExitException(10, input);
					throw eee;
				}
				cnt10++;
			}

			match(input, Token.UP, null); 

			}


			    ruleset_stack.peek().subjects.add(simpleSelectorStack.peek());

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "compoundSelector"


	protected static class simpleSelector_scope {
		String namespace;
		String element;
		List<CSSSelectorCondition> conditions;
	}
	protected Stack<simpleSelector_scope> simpleSelector_stack = new Stack<simpleSelector_scope>();

	public static class simpleSelector_return extends TreeRuleReturnScope {
	};


	// $ANTLR start "simpleSelector"
	// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:237:1: simpleSelector[Stack<CSSSelector> simpleSelectorStack] : ^( I_SIMPLE_SELECTOR ( simpleSelectorFraction )+ ) ;
	public final CSSTree.simpleSelector_return simpleSelector(Stack<CSSSelector> simpleSelectorStack) throws RecognitionException {
		simpleSelector_stack.push(new simpleSelector_scope());
		CSSTree.simpleSelector_return retval = new CSSTree.simpleSelector_return();
		retval.start = input.LT(1);


		    simpleSelector_stack.peek().conditions = new ArrayList<CSSSelectorCondition>();
		    final CSSCombinator combinator ;
		    if (simpleSelectorStack.isEmpty())
		        combinator = null;
		    else                    
		        combinator = new CSSCombinator(simpleSelectorStack.peek(), CombinatorType.DESCENDANT, ((CommonTree)retval.start), tokenStream);

		try {
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:264:5: ( ^( I_SIMPLE_SELECTOR ( simpleSelectorFraction )+ ) )
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:264:9: ^( I_SIMPLE_SELECTOR ( simpleSelectorFraction )+ )
			{
			match(input,I_SIMPLE_SELECTOR,FOLLOW_I_SIMPLE_SELECTOR_in_simpleSelector558); 
			match(input, Token.DOWN, null); 
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:264:29: ( simpleSelectorFraction )+
			int cnt11=0;
			loop11:
			while (true) {
				int alt11=2;
				int LA11_0 = input.LA(1);
				if ( (LA11_0==COLON||(LA11_0 >= DOT && LA11_0 <= DOUBLE_COLON)||LA11_0==HASH_WORD||LA11_0==ID||LA11_0==NUMBER_WITH_PERCENT||LA11_0==PIPE||(LA11_0 >= SQUARE_OPEN && LA11_0 <= STAR)||LA11_0==TILDE||(LA11_0 >= 69 && LA11_0 <= 70)) ) {
					alt11=1;
				}

				switch (alt11) {
				case 1 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:264:29: simpleSelectorFraction
					{
					pushFollow(FOLLOW_simpleSelectorFraction_in_simpleSelector560);
					simpleSelectorFraction();
					state._fsp--;

					}
					break;

				default :
					if ( cnt11 >= 1 ) break loop11;
					EarlyExitException eee = new EarlyExitException(11, input);
					throw eee;
				}
				cnt11++;
			}

			match(input, Token.UP, null); 

			}


			    final CSSSelector simpleSelector = new CSSSelector(
			        combinator,
			        simpleSelector_stack.peek().element,
			        simpleSelector_stack.peek().namespace,
			        simpleSelector_stack.peek().conditions, 
			        ((CommonTree)retval.start), 
			        tokenStream);
			    simpleSelectorStack.push(simpleSelector);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
			simpleSelector_stack.pop();
		}
		return retval;
	}
	// $ANTLR end "simpleSelector"



	// $ANTLR start "simpleSelectorFraction"
	// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:267:1: simpleSelectorFraction : ( elementSelector | conditionSelector );
	public final void simpleSelectorFraction() throws RecognitionException {
		try {
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:268:5: ( elementSelector | conditionSelector )
			int alt12=2;
			int LA12_0 = input.LA(1);
			if ( (LA12_0==ID||LA12_0==NUMBER_WITH_PERCENT||LA12_0==PIPE||LA12_0==STAR) ) {
				alt12=1;
			}
			else if ( (LA12_0==COLON||(LA12_0 >= DOT && LA12_0 <= DOUBLE_COLON)||LA12_0==HASH_WORD||LA12_0==SQUARE_OPEN||LA12_0==TILDE||(LA12_0 >= 69 && LA12_0 <= 70)) ) {
				alt12=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 12, 0, input);
				throw nvae;
			}

			switch (alt12) {
				case 1 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:268:9: elementSelector
					{
					pushFollow(FOLLOW_elementSelector_in_simpleSelectorFraction589);
					elementSelector();
					state._fsp--;

					}
					break;
				case 2 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:269:9: conditionSelector
					{
					pushFollow(FOLLOW_conditionSelector_in_simpleSelectorFraction599);
					conditionSelector();
					state._fsp--;

					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "simpleSelectorFraction"


	public static class conditionSelector_return extends TreeRuleReturnScope {
	};


	// $ANTLR start "conditionSelector"
	// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:272:1: conditionSelector : ( ^( DOT c= ID ) | HASH_WORD | ^( COLON NOT arg= ARGUMENTS ) | ^( COLON s= ID ) | ^( DOUBLE_COLON dc= ID ) | attributeSelector | childSelector | precededSelector | siblingSelector );
	public final CSSTree.conditionSelector_return conditionSelector() throws RecognitionException {
		CSSTree.conditionSelector_return retval = new CSSTree.conditionSelector_return();
		retval.start = input.LT(1);

		CommonTree c=null;
		CommonTree arg=null;
		CommonTree s=null;
		CommonTree dc=null;
		CommonTree HASH_WORD1=null;


		    ConditionType type = null;
		    String name = null;

		try {
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:283:5: ( ^( DOT c= ID ) | HASH_WORD | ^( COLON NOT arg= ARGUMENTS ) | ^( COLON s= ID ) | ^( DOUBLE_COLON dc= ID ) | attributeSelector | childSelector | precededSelector | siblingSelector )
			int alt13=9;
			switch ( input.LA(1) ) {
			case DOT:
				{
				alt13=1;
				}
				break;
			case HASH_WORD:
				{
				alt13=2;
				}
				break;
			case COLON:
				{
				int LA13_3 = input.LA(2);
				if ( (LA13_3==DOWN) ) {
					int LA13_9 = input.LA(3);
					if ( (LA13_9==NOT) ) {
						alt13=3;
					}
					else if ( (LA13_9==ID) ) {
						alt13=4;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 13, 9, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 13, 3, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case DOUBLE_COLON:
				{
				alt13=5;
				}
				break;
			case SQUARE_OPEN:
				{
				alt13=6;
				}
				break;
			case 70:
				{
				alt13=7;
				}
				break;
			case TILDE:
				{
				alt13=8;
				}
				break;
			case 69:
				{
				alt13=9;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 13, 0, input);
				throw nvae;
			}
			switch (alt13) {
				case 1 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:283:9: ^( DOT c= ID )
					{
					match(input,DOT,FOLLOW_DOT_in_conditionSelector633); 
					match(input, Token.DOWN, null); 
					c=(CommonTree)match(input,ID,FOLLOW_ID_in_conditionSelector637); 
					match(input, Token.UP, null); 

					 type = ConditionType.CLASS; name = (c!=null?c.getText():null); 
					}
					break;
				case 2 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:284:9: HASH_WORD
					{
					HASH_WORD1=(CommonTree)match(input,HASH_WORD,FOLLOW_HASH_WORD_in_conditionSelector654); 
					 type = ConditionType.ID; name = (HASH_WORD1!=null?HASH_WORD1.getText():null).substring(1); 
					}
					break;
				case 3 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:285:9: ^( COLON NOT arg= ARGUMENTS )
					{
					match(input,COLON,FOLLOW_COLON_in_conditionSelector669); 
					match(input, Token.DOWN, null); 
					match(input,NOT,FOLLOW_NOT_in_conditionSelector671); 
					arg=(CommonTree)match(input,ARGUMENTS,FOLLOW_ARGUMENTS_in_conditionSelector675); 
					match(input, Token.UP, null); 

					 type = ConditionType.NOT; name = (arg!=null?arg.getText():null); 
					}
					break;
				case 4 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:286:9: ^( COLON s= ID )
					{
					match(input,COLON,FOLLOW_COLON_in_conditionSelector689); 
					match(input, Token.DOWN, null); 
					s=(CommonTree)match(input,ID,FOLLOW_ID_in_conditionSelector693); 
					match(input, Token.UP, null); 

					 type = ConditionType.PSEUDO; name = (s!=null?s.getText():null); 
					}
					break;
				case 5 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:287:9: ^( DOUBLE_COLON dc= ID )
					{
					match(input,DOUBLE_COLON,FOLLOW_DOUBLE_COLON_in_conditionSelector708); 
					match(input, Token.DOWN, null); 
					dc=(CommonTree)match(input,ID,FOLLOW_ID_in_conditionSelector712); 
					match(input, Token.UP, null); 

					 type = ConditionType.PSEUDO; name = (dc!=null?dc.getText():null); 
					}
					break;
				case 6 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:288:9: attributeSelector
					{
					pushFollow(FOLLOW_attributeSelector_in_conditionSelector726);
					attributeSelector();
					state._fsp--;

					 type = ConditionType.ATTRIBUTE; name = curAttribute.substring(1); 
					}
					break;
				case 7 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:289:9: childSelector
					{
					pushFollow(FOLLOW_childSelector_in_conditionSelector738);
					childSelector();
					state._fsp--;

					 type = ConditionType.CHILD; name = ConditionType.CHILD.toString(); 
					}
					break;
				case 8 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:290:9: precededSelector
					{
					pushFollow(FOLLOW_precededSelector_in_conditionSelector750);
					precededSelector();
					state._fsp--;

					 type = ConditionType.PRECEDED; name = ConditionType.PRECEDED.toString(); 
					}
					break;
				case 9 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:291:9: siblingSelector
					{
					pushFollow(FOLLOW_siblingSelector_in_conditionSelector762);
					siblingSelector();
					state._fsp--;

					 type = ConditionType.SIBLING; name = ConditionType.SIBLING.toString(); 
					}
					break;

			}

			    simpleSelector_stack.peek().conditions.add(
			        new CSSSelectorCondition(name, type, ((CommonTree)retval.start), tokenStream));

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "conditionSelector"



	// $ANTLR start "elementSelector"
	// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:294:1: elementSelector : ( ^( PIPE ns= ID e1= ID ) |e2= ID |np= NUMBER_WITH_PERCENT | STAR );
	public final void elementSelector() throws RecognitionException {
		CommonTree ns=null;
		CommonTree e1=null;
		CommonTree e2=null;
		CommonTree np=null;
		CommonTree STAR2=null;

		try {
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:295:5: ( ^( PIPE ns= ID e1= ID ) |e2= ID |np= NUMBER_WITH_PERCENT | STAR )
			int alt14=4;
			switch ( input.LA(1) ) {
			case PIPE:
				{
				alt14=1;
				}
				break;
			case ID:
				{
				alt14=2;
				}
				break;
			case NUMBER_WITH_PERCENT:
				{
				alt14=3;
				}
				break;
			case STAR:
				{
				alt14=4;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 14, 0, input);
				throw nvae;
			}
			switch (alt14) {
				case 1 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:295:9: ^( PIPE ns= ID e1= ID )
					{
					match(input,PIPE,FOLLOW_PIPE_in_elementSelector786); 
					match(input, Token.DOWN, null); 
					ns=(CommonTree)match(input,ID,FOLLOW_ID_in_elementSelector790); 
					e1=(CommonTree)match(input,ID,FOLLOW_ID_in_elementSelector794); 
					match(input, Token.UP, null); 

					 simpleSelector_stack.peek().element = (e1!=null?e1.getText():null); 
					          simpleSelector_stack.peek().namespace = (ns!=null?ns.getText():null); 
					}
					break;
				case 2 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:298:9: e2= ID
					{
					e2=(CommonTree)match(input,ID,FOLLOW_ID_in_elementSelector819); 
					 simpleSelector_stack.peek().element = (e2!=null?e2.getText():null); 
					}
					break;
				case 3 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:300:9: np= NUMBER_WITH_PERCENT
					{
					np=(CommonTree)match(input,NUMBER_WITH_PERCENT,FOLLOW_NUMBER_WITH_PERCENT_in_elementSelector854); 
					 simpleSelector_stack.peek().element = (np!=null?np.getText():null); 
					}
					break;
				case 4 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:302:9: STAR
					{
					STAR2=(CommonTree)match(input,STAR,FOLLOW_STAR_in_elementSelector887); 
					 simpleSelector_stack.peek().element = (STAR2!=null?STAR2.getText():null); 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "elementSelector"



	// $ANTLR start "childSelector"
	// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:306:1: childSelector : '>' simpleSelectorFraction ;
	public final void childSelector() throws RecognitionException {
		try {
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:307:5: ( '>' simpleSelectorFraction )
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:307:9: '>' simpleSelectorFraction
			{
			match(input,70,FOLLOW_70_in_childSelector931); 
			pushFollow(FOLLOW_simpleSelectorFraction_in_childSelector933);
			simpleSelectorFraction();
			state._fsp--;

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "childSelector"



	// $ANTLR start "precededSelector"
	// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:310:1: precededSelector : TILDE simpleSelectorFraction ;
	public final void precededSelector() throws RecognitionException {
		try {
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:311:5: ( TILDE simpleSelectorFraction )
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:311:9: TILDE simpleSelectorFraction
			{
			match(input,TILDE,FOLLOW_TILDE_in_precededSelector956); 
			pushFollow(FOLLOW_simpleSelectorFraction_in_precededSelector958);
			simpleSelectorFraction();
			state._fsp--;

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "precededSelector"



	// $ANTLR start "siblingSelector"
	// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:314:1: siblingSelector : '+' simpleSelectorFraction ;
	public final void siblingSelector() throws RecognitionException {
		try {
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:315:5: ( '+' simpleSelectorFraction )
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:315:9: '+' simpleSelectorFraction
			{
			match(input,69,FOLLOW_69_in_siblingSelector981); 
			pushFollow(FOLLOW_simpleSelectorFraction_in_siblingSelector983);
			simpleSelectorFraction();
			state._fsp--;

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "siblingSelector"



	// $ANTLR start "attributeSelector"
	// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:318:1: attributeSelector : open= SQUARE_OPEN attributeName ( attributeOperator )* ( attributeValue )* close= SQUARE_END ;
	public final void attributeSelector() throws RecognitionException {
		CommonTree open=null;
		CommonTree close=null;

		try {
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:319:5: (open= SQUARE_OPEN attributeName ( attributeOperator )* ( attributeValue )* close= SQUARE_END )
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:319:9: open= SQUARE_OPEN attributeName ( attributeOperator )* ( attributeValue )* close= SQUARE_END
			{
			open=(CommonTree)match(input,SQUARE_OPEN,FOLLOW_SQUARE_OPEN_in_attributeSelector1006); 
			pushFollow(FOLLOW_attributeName_in_attributeSelector1008);
			attributeName();
			state._fsp--;

			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:319:42: ( attributeOperator )*
			loop15:
			while (true) {
				int alt15=2;
				int LA15_0 = input.LA(1);
				if ( (LA15_0==BEGINS_WITH||LA15_0==CONTAINS||(LA15_0 >= ENDS_WITH && LA15_0 <= EQUALS)||LA15_0==HREFLANG_MATCH||LA15_0==LIST_MATCH) ) {
					alt15=1;
				}

				switch (alt15) {
				case 1 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:319:42: attributeOperator
					{
					pushFollow(FOLLOW_attributeOperator_in_attributeSelector1010);
					attributeOperator();
					state._fsp--;

					}
					break;

				default :
					break loop15;
				}
			}

			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:319:61: ( attributeValue )*
			loop16:
			while (true) {
				int alt16=2;
				int LA16_0 = input.LA(1);
				if ( (LA16_0==STRING) ) {
					alt16=1;
				}

				switch (alt16) {
				case 1 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:319:61: attributeValue
					{
					pushFollow(FOLLOW_attributeValue_in_attributeSelector1013);
					attributeValue();
					state._fsp--;

					}
					break;

				default :
					break loop16;
				}
			}

			close=(CommonTree)match(input,SQUARE_END,FOLLOW_SQUARE_END_in_attributeSelector1020); 
			 curAttribute = (open!=null?open.getText():null) + curAttribute + (close!=null?close.getText():null); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "attributeSelector"



	// $ANTLR start "attributeName"
	// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:323:1: attributeName : n1= ID ;
	public final void attributeName() throws RecognitionException {
		CommonTree n1=null;

		try {
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:324:5: (n1= ID )
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:324:10: n1= ID
			{
			n1=(CommonTree)match(input,ID,FOLLOW_ID_in_attributeName1051); 
			 curAttribute = (n1!=null?n1.getText():null); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "attributeName"



	// $ANTLR start "attributeOperator"
	// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:328:1: attributeOperator : (o1= BEGINS_WITH |o2= ENDS_WITH |o3= CONTAINS |o4= LIST_MATCH |o5= HREFLANG_MATCH |o6= EQUALS );
	public final void attributeOperator() throws RecognitionException {
		CommonTree o1=null;
		CommonTree o2=null;
		CommonTree o3=null;
		CommonTree o4=null;
		CommonTree o5=null;
		CommonTree o6=null;

		try {
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:329:5: (o1= BEGINS_WITH |o2= ENDS_WITH |o3= CONTAINS |o4= LIST_MATCH |o5= HREFLANG_MATCH |o6= EQUALS )
			int alt17=6;
			switch ( input.LA(1) ) {
			case BEGINS_WITH:
				{
				alt17=1;
				}
				break;
			case ENDS_WITH:
				{
				alt17=2;
				}
				break;
			case CONTAINS:
				{
				alt17=3;
				}
				break;
			case LIST_MATCH:
				{
				alt17=4;
				}
				break;
			case HREFLANG_MATCH:
				{
				alt17=5;
				}
				break;
			case EQUALS:
				{
				alt17=6;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 17, 0, input);
				throw nvae;
			}
			switch (alt17) {
				case 1 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:329:10: o1= BEGINS_WITH
					{
					o1=(CommonTree)match(input,BEGINS_WITH,FOLLOW_BEGINS_WITH_in_attributeOperator1090); 
					 curAttribute += (o1!=null?o1.getText():null); 
					}
					break;
				case 2 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:331:10: o2= ENDS_WITH
					{
					o2=(CommonTree)match(input,ENDS_WITH,FOLLOW_ENDS_WITH_in_attributeOperator1116); 
					 curAttribute += (o2!=null?o2.getText():null); 
					}
					break;
				case 3 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:333:10: o3= CONTAINS
					{
					o3=(CommonTree)match(input,CONTAINS,FOLLOW_CONTAINS_in_attributeOperator1142); 
					 curAttribute += (o3!=null?o3.getText():null); 
					}
					break;
				case 4 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:335:10: o4= LIST_MATCH
					{
					o4=(CommonTree)match(input,LIST_MATCH,FOLLOW_LIST_MATCH_in_attributeOperator1168); 
					 curAttribute += (o4!=null?o4.getText():null); 
					}
					break;
				case 5 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:337:10: o5= HREFLANG_MATCH
					{
					o5=(CommonTree)match(input,HREFLANG_MATCH,FOLLOW_HREFLANG_MATCH_in_attributeOperator1194); 
					 curAttribute += (o5!=null?o5.getText():null); 
					}
					break;
				case 6 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:339:10: o6= EQUALS
					{
					o6=(CommonTree)match(input,EQUALS,FOLLOW_EQUALS_in_attributeOperator1220); 
					 curAttribute += (o6!=null?o6.getText():null); 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "attributeOperator"



	// $ANTLR start "attributeValue"
	// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:343:1: attributeValue : s= STRING ;
	public final void attributeValue() throws RecognitionException {
		CommonTree s=null;

		try {
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:344:5: (s= STRING )
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:344:10: s= STRING
			{
			s=(CommonTree)match(input,STRING,FOLLOW_STRING_in_attributeValue1259); 
			 curAttribute += (s!=null?s.getText():null); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "attributeValue"



	// $ANTLR start "declarationsBlock"
	// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:349:1: declarationsBlock returns [List<CSSProperty> properties] : ^( I_DECL ( declaration )* ) ;
	public final List<CSSProperty> declarationsBlock() throws RecognitionException {
		List<CSSProperty> properties = null;


		TreeRuleReturnScope declaration3 =null;


		    properties = new ArrayList<CSSProperty>();

		try {
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:354:5: ( ^( I_DECL ( declaration )* ) )
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:354:9: ^( I_DECL ( declaration )* )
			{
			match(input,I_DECL,FOLLOW_I_DECL_in_declarationsBlock1306); 
			if ( input.LA(1)==Token.DOWN ) {
				match(input, Token.DOWN, null); 
				// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:354:18: ( declaration )*
				loop18:
				while (true) {
					int alt18=2;
					int LA18_0 = input.LA(1);
					if ( (LA18_0==COLON) ) {
						alt18=1;
					}

					switch (alt18) {
					case 1 :
						// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:354:19: declaration
						{
						pushFollow(FOLLOW_declaration_in_declarationsBlock1309);
						declaration3=declaration();
						state._fsp--;

						 
						             if ((declaration3!=null?((CSSTree.declaration_return)declaration3).property:null) != null)
						                 properties.add((declaration3!=null?((CSSTree.declaration_return)declaration3).property:null)); 
						         
						}
						break;

					default :
						break loop18;
					}
				}

				match(input, Token.UP, null); 
			}

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return properties;
	}
	// $ANTLR end "declarationsBlock"


	public static class declaration_return extends TreeRuleReturnScope {
		public CSSProperty property;
	};


	// $ANTLR start "declaration"
	// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:362:1: declaration returns [CSSProperty property] : ^( COLON id= ID v= value ) ;
	public final CSSTree.declaration_return declaration() throws RecognitionException {
		CSSTree.declaration_return retval = new CSSTree.declaration_return();
		retval.start = input.LT(1);

		CommonTree id=null;
		TreeRuleReturnScope v =null;

		try {
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:368:5: ( ^( COLON id= ID v= value ) )
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:368:9: ^( COLON id= ID v= value )
			{
			match(input,COLON,FOLLOW_COLON_in_declaration1363); 
			match(input, Token.DOWN, null); 
			id=(CommonTree)match(input,ID,FOLLOW_ID_in_declaration1367); 
			pushFollow(FOLLOW_value_in_declaration1371);
			v=value();
			state._fsp--;

			match(input, Token.UP, null); 

			}


			    if ((id!=null?id.getText():null) != null && (v!=null?((CSSTree.value_return)v).propertyValue:null) != null)
			        retval.property = new CSSProperty((id!=null?id.getText():null), (v!=null?((CSSTree.value_return)v).propertyValue:null), ((CommonTree)retval.start), tokenStream);  

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "declaration"


	public static class value_return extends TreeRuleReturnScope {
		public CSSPropertyValue propertyValue;
	};


	// $ANTLR start "value"
	// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:371:1: value returns [CSSPropertyValue propertyValue] : ( ^( I_ARRAY (s1= singleValue )+ ) |s2= singleValue );
	public final CSSTree.value_return value() throws RecognitionException {
		CSSTree.value_return retval = new CSSTree.value_return();
		retval.start = input.LT(1);

		TreeRuleReturnScope s1 =null;
		TreeRuleReturnScope s2 =null;

		try {
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:372:5: ( ^( I_ARRAY (s1= singleValue )+ ) |s2= singleValue )
			int alt20=2;
			int LA20_0 = input.LA(1);
			if ( (LA20_0==I_ARRAY) ) {
				alt20=1;
			}
			else if ( (LA20_0==ALPHA_VALUE||LA20_0==CLASS_REFERENCE||LA20_0==EMBED||LA20_0==HASH_WORD||(LA20_0 >= ID && LA20_0 <= IMPORTANT)||LA20_0==LOCAL||(LA20_0 >= NUMBER_WITH_PERCENT && LA20_0 <= NUMBER_WITH_UNIT)||LA20_0==OPERATOR||(LA20_0 >= PROPERTY_REFERENCE && LA20_0 <= ROTATE_VALUE)||LA20_0==SCALE_VALUE||LA20_0==STRING||(LA20_0 >= TRANSLATE3D_VALUE && LA20_0 <= URL)) ) {
				alt20=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 20, 0, input);
				throw nvae;
			}

			switch (alt20) {
				case 1 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:372:9: ^( I_ARRAY (s1= singleValue )+ )
					{
					match(input,I_ARRAY,FOLLOW_I_ARRAY_in_value1401); 
					 final List<CSSPropertyValue> array = new ArrayList<CSSPropertyValue>(); 
					match(input, Token.DOWN, null); 
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:374:12: (s1= singleValue )+
					int cnt19=0;
					loop19:
					while (true) {
						int alt19=2;
						int LA19_0 = input.LA(1);
						if ( (LA19_0==ALPHA_VALUE||LA19_0==CLASS_REFERENCE||LA19_0==EMBED||LA19_0==HASH_WORD||(LA19_0 >= ID && LA19_0 <= IMPORTANT)||LA19_0==LOCAL||(LA19_0 >= NUMBER_WITH_PERCENT && LA19_0 <= NUMBER_WITH_UNIT)||LA19_0==OPERATOR||(LA19_0 >= PROPERTY_REFERENCE && LA19_0 <= ROTATE_VALUE)||LA19_0==SCALE_VALUE||LA19_0==STRING||(LA19_0 >= TRANSLATE3D_VALUE && LA19_0 <= URL)) ) {
							alt19=1;
						}

						switch (alt19) {
						case 1 :
							// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:374:14: s1= singleValue
							{
							pushFollow(FOLLOW_singleValue_in_value1451);
							s1=singleValue();
							state._fsp--;

							 array.add((s1!=null?((CSSTree.singleValue_return)s1).propertyValue:null)); 
							}
							break;

						default :
							if ( cnt19 >= 1 ) break loop19;
							EarlyExitException eee = new EarlyExitException(19, input);
							throw eee;
						}
						cnt19++;
					}

					match(input, Token.UP, null); 

					 retval.propertyValue = new CSSArrayPropertyValue(array, ((CommonTree)retval.start), tokenStream); 
					}
					break;
				case 2 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:376:9: s2= singleValue
					{
					pushFollow(FOLLOW_singleValue_in_value1502);
					s2=singleValue();
					state._fsp--;

					 retval.propertyValue = (s2!=null?((CSSTree.singleValue_return)s2).propertyValue:null); 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "value"


	public static class singleValue_return extends TreeRuleReturnScope {
		public CSSPropertyValue propertyValue;
	};


	// $ANTLR start "singleValue"
	// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:379:1: singleValue returns [CSSPropertyValue propertyValue] : ( NUMBER_WITH_PERCENT | NUMBER_WITH_UNIT | HASH_WORD | ALPHA_VALUE | RECT_VALUE | ROTATE_VALUE | SCALE_VALUE | TRANSLATE3D_VALUE | RGB | RGBA | ^( CLASS_REFERENCE cr= ARGUMENTS ) | ^( PROPERTY_REFERENCE pr= ARGUMENTS ) | ^( EMBED es= ARGUMENTS ) | ^( URL url= ARGUMENTS (format= formatOption )* ) | ^( LOCAL l= ARGUMENTS ) |s= STRING | ID | OPERATOR | IMPORTANT );
	public final CSSTree.singleValue_return singleValue() throws RecognitionException {
		CSSTree.singleValue_return retval = new CSSTree.singleValue_return();
		retval.start = input.LT(1);

		CommonTree cr=null;
		CommonTree pr=null;
		CommonTree es=null;
		CommonTree url=null;
		CommonTree l=null;
		CommonTree s=null;
		CommonTree NUMBER_WITH_PERCENT4=null;
		CommonTree NUMBER_WITH_UNIT5=null;
		CommonTree RGB6=null;
		CommonTree RGBA7=null;
		CommonTree CLASS_REFERENCE8=null;
		CommonTree PROPERTY_REFERENCE9=null;
		CommonTree EMBED10=null;
		CommonTree URL11=null;
		CommonTree LOCAL12=null;
		TreeRuleReturnScope format =null;

		try {
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:380:5: ( NUMBER_WITH_PERCENT | NUMBER_WITH_UNIT | HASH_WORD | ALPHA_VALUE | RECT_VALUE | ROTATE_VALUE | SCALE_VALUE | TRANSLATE3D_VALUE | RGB | RGBA | ^( CLASS_REFERENCE cr= ARGUMENTS ) | ^( PROPERTY_REFERENCE pr= ARGUMENTS ) | ^( EMBED es= ARGUMENTS ) | ^( URL url= ARGUMENTS (format= formatOption )* ) | ^( LOCAL l= ARGUMENTS ) |s= STRING | ID | OPERATOR | IMPORTANT )
			int alt22=19;
			switch ( input.LA(1) ) {
			case NUMBER_WITH_PERCENT:
				{
				alt22=1;
				}
				break;
			case NUMBER_WITH_UNIT:
				{
				alt22=2;
				}
				break;
			case HASH_WORD:
				{
				alt22=3;
				}
				break;
			case ALPHA_VALUE:
				{
				alt22=4;
				}
				break;
			case RECT_VALUE:
				{
				alt22=5;
				}
				break;
			case ROTATE_VALUE:
				{
				alt22=6;
				}
				break;
			case SCALE_VALUE:
				{
				alt22=7;
				}
				break;
			case TRANSLATE3D_VALUE:
				{
				alt22=8;
				}
				break;
			case RGB:
				{
				alt22=9;
				}
				break;
			case RGBA:
				{
				alt22=10;
				}
				break;
			case CLASS_REFERENCE:
				{
				alt22=11;
				}
				break;
			case PROPERTY_REFERENCE:
				{
				alt22=12;
				}
				break;
			case EMBED:
				{
				alt22=13;
				}
				break;
			case URL:
				{
				alt22=14;
				}
				break;
			case LOCAL:
				{
				alt22=15;
				}
				break;
			case STRING:
				{
				alt22=16;
				}
				break;
			case ID:
				{
				alt22=17;
				}
				break;
			case OPERATOR:
				{
				alt22=18;
				}
				break;
			case IMPORTANT:
				{
				alt22=19;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 22, 0, input);
				throw nvae;
			}
			switch (alt22) {
				case 1 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:380:9: NUMBER_WITH_PERCENT
					{
					NUMBER_WITH_PERCENT4=(CommonTree)match(input,NUMBER_WITH_PERCENT,FOLLOW_NUMBER_WITH_PERCENT_in_singleValue1540); 
					 retval.propertyValue = new CSSNumberPropertyValue((NUMBER_WITH_PERCENT4!=null?NUMBER_WITH_PERCENT4.getText():null), ((CommonTree)retval.start), tokenStream); 
					}
					break;
				case 2 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:382:9: NUMBER_WITH_UNIT
					{
					NUMBER_WITH_UNIT5=(CommonTree)match(input,NUMBER_WITH_UNIT,FOLLOW_NUMBER_WITH_UNIT_in_singleValue1563); 
					 retval.propertyValue = new CSSNumberPropertyValue((NUMBER_WITH_UNIT5!=null?NUMBER_WITH_UNIT5.getText():null), ((CommonTree)retval.start), tokenStream); 
					}
					break;
				case 3 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:384:9: HASH_WORD
					{
					match(input,HASH_WORD,FOLLOW_HASH_WORD_in_singleValue1586); 
					 retval.propertyValue = new CSSColorPropertyValue(((CommonTree)retval.start), tokenStream); 
					}
					break;
				case 4 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:386:9: ALPHA_VALUE
					{
					match(input,ALPHA_VALUE,FOLLOW_ALPHA_VALUE_in_singleValue1615); 
					 retval.propertyValue = CSSKeywordPropertyValue.create(((CommonTree)retval.start), tokenStream); 
					}
					break;
				case 5 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:388:9: RECT_VALUE
					{
					match(input,RECT_VALUE,FOLLOW_RECT_VALUE_in_singleValue1635); 
					 retval.propertyValue = CSSKeywordPropertyValue.create(((CommonTree)retval.start), tokenStream); 
					}
					break;
				case 6 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:390:9: ROTATE_VALUE
					{
					match(input,ROTATE_VALUE,FOLLOW_ROTATE_VALUE_in_singleValue1655); 
					 retval.propertyValue = CSSKeywordPropertyValue.create(((CommonTree)retval.start), tokenStream); 
					}
					break;
				case 7 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:392:9: SCALE_VALUE
					{
					match(input,SCALE_VALUE,FOLLOW_SCALE_VALUE_in_singleValue1675); 
					 retval.propertyValue = CSSKeywordPropertyValue.create(((CommonTree)retval.start), tokenStream); 
					}
					break;
				case 8 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:394:9: TRANSLATE3D_VALUE
					{
					match(input,TRANSLATE3D_VALUE,FOLLOW_TRANSLATE3D_VALUE_in_singleValue1695); 
					 retval.propertyValue = CSSKeywordPropertyValue.create(((CommonTree)retval.start), tokenStream); 
					}
					break;
				case 9 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:396:9: RGB
					{
					RGB6=(CommonTree)match(input,RGB,FOLLOW_RGB_in_singleValue1715); 
					 retval.propertyValue = new CSSRgbColorPropertyValue((RGB6!=null?RGB6.getText():null), ((CommonTree)retval.start), tokenStream); 
					}
					break;
				case 10 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:398:9: RGBA
					{
					RGBA7=(CommonTree)match(input,RGBA,FOLLOW_RGBA_in_singleValue1732); 
					 retval.propertyValue = new CSSRgbaColorPropertyValue((RGBA7!=null?RGBA7.getText():null), ((CommonTree)retval.start), tokenStream); 
					}
					break;
				case 11 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:400:9: ^( CLASS_REFERENCE cr= ARGUMENTS )
					{
					CLASS_REFERENCE8=(CommonTree)match(input,CLASS_REFERENCE,FOLLOW_CLASS_REFERENCE_in_singleValue1750); 
					match(input, Token.DOWN, null); 
					cr=(CommonTree)match(input,ARGUMENTS,FOLLOW_ARGUMENTS_in_singleValue1754); 
					match(input, Token.UP, null); 

					 retval.propertyValue = new CSSFunctionCallPropertyValue((CLASS_REFERENCE8!=null?CLASS_REFERENCE8.getText():null), (cr!=null?cr.getText():null), ((CommonTree)retval.start), tokenStream); 
					}
					break;
				case 12 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:402:9: ^( PROPERTY_REFERENCE pr= ARGUMENTS )
					{
					PROPERTY_REFERENCE9=(CommonTree)match(input,PROPERTY_REFERENCE,FOLLOW_PROPERTY_REFERENCE_in_singleValue1776); 
					match(input, Token.DOWN, null); 
					pr=(CommonTree)match(input,ARGUMENTS,FOLLOW_ARGUMENTS_in_singleValue1780); 
					match(input, Token.UP, null); 

					 retval.propertyValue = new CSSFunctionCallPropertyValue((PROPERTY_REFERENCE9!=null?PROPERTY_REFERENCE9.getText():null), (pr!=null?pr.getText():null), ((CommonTree)retval.start), tokenStream); 
					}
					break;
				case 13 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:404:9: ^( EMBED es= ARGUMENTS )
					{
					EMBED10=(CommonTree)match(input,EMBED,FOLLOW_EMBED_in_singleValue1802); 
					match(input, Token.DOWN, null); 
					es=(CommonTree)match(input,ARGUMENTS,FOLLOW_ARGUMENTS_in_singleValue1806); 
					match(input, Token.UP, null); 

					 retval.propertyValue = new CSSFunctionCallPropertyValue((EMBED10!=null?EMBED10.getText():null), (es!=null?es.getText():null), ((CommonTree)retval.start), tokenStream); 
					}
					break;
				case 14 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:406:9: ^( URL url= ARGUMENTS (format= formatOption )* )
					{
					URL11=(CommonTree)match(input,URL,FOLLOW_URL_in_singleValue1828); 
					match(input, Token.DOWN, null); 
					url=(CommonTree)match(input,ARGUMENTS,FOLLOW_ARGUMENTS_in_singleValue1832); 
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:406:35: (format= formatOption )*
					loop21:
					while (true) {
						int alt21=2;
						int LA21_0 = input.LA(1);
						if ( (LA21_0==FORMAT) ) {
							alt21=1;
						}

						switch (alt21) {
						case 1 :
							// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:406:35: format= formatOption
							{
							pushFollow(FOLLOW_formatOption_in_singleValue1836);
							format=formatOption();
							state._fsp--;

							}
							break;

						default :
							break loop21;
						}
					}

					match(input, Token.UP, null); 

					 retval.propertyValue = new CSSURLAndFormatPropertyValue((URL11!=null?URL11.getText():null), (url!=null?url.getText():null), (format!=null?(input.getTokenStream().toString(input.getTreeAdaptor().getTokenStartIndex(format.start),input.getTreeAdaptor().getTokenStopIndex(format.start))):null), ((CommonTree)retval.start), tokenStream); 
					}
					break;
				case 15 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:408:9: ^( LOCAL l= ARGUMENTS )
					{
					LOCAL12=(CommonTree)match(input,LOCAL,FOLLOW_LOCAL_in_singleValue1859); 
					match(input, Token.DOWN, null); 
					l=(CommonTree)match(input,ARGUMENTS,FOLLOW_ARGUMENTS_in_singleValue1863); 
					match(input, Token.UP, null); 

					 retval.propertyValue = new CSSFunctionCallPropertyValue((LOCAL12!=null?LOCAL12.getText():null), (l!=null?l.getText():null), ((CommonTree)retval.start), tokenStream); 
					}
					break;
				case 16 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:410:9: s= STRING
					{
					s=(CommonTree)match(input,STRING,FOLLOW_STRING_in_singleValue1886); 
					 retval.propertyValue = new CSSStringPropertyValue((s!=null?s.getText():null), ((CommonTree)retval.start), tokenStream); 
					}
					break;
				case 17 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:412:9: ID
					{
					match(input,ID,FOLLOW_ID_in_singleValue1928); 
					 retval.propertyValue = CSSKeywordPropertyValue.create(((CommonTree)retval.start), tokenStream); 
					}
					break;
				case 18 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:414:9: OPERATOR
					{
					match(input,OPERATOR,FOLLOW_OPERATOR_in_singleValue1949); 
					 retval.propertyValue = CSSKeywordPropertyValue.create(((CommonTree)retval.start), tokenStream); 
					}
					break;
				case 19 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:416:9: IMPORTANT
					{
					match(input,IMPORTANT,FOLLOW_IMPORTANT_in_singleValue1970); 
					 retval.propertyValue = CSSKeywordPropertyValue.create(((CommonTree)retval.start), tokenStream); 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "singleValue"


	public static class formatOption_return extends TreeRuleReturnScope {
		public CSSPropertyValue propertyValue;
	};


	// $ANTLR start "formatOption"
	// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:420:1: formatOption returns [CSSPropertyValue propertyValue] : ^( FORMAT format= ARGUMENTS ) ;
	public final CSSTree.formatOption_return formatOption() throws RecognitionException {
		CSSTree.formatOption_return retval = new CSSTree.formatOption_return();
		retval.start = input.LT(1);

		CommonTree format=null;
		CommonTree FORMAT13=null;

		try {
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:421:5: ( ^( FORMAT format= ARGUMENTS ) )
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:421:9: ^( FORMAT format= ARGUMENTS )
			{
			FORMAT13=(CommonTree)match(input,FORMAT,FOLLOW_FORMAT_in_formatOption2009); 
			match(input, Token.DOWN, null); 
			format=(CommonTree)match(input,ARGUMENTS,FOLLOW_ARGUMENTS_in_formatOption2013); 
			match(input, Token.UP, null); 

			 retval.propertyValue = new CSSFunctionCallPropertyValue((FORMAT13!=null?FORMAT13.getText():null), (format!=null?format.getText():null), ((CommonTree)retval.start), tokenStream); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "formatOption"


	public static class argumentList_return extends TreeRuleReturnScope {
		public List<String> labels;
		public List<String> values;
	};


	// $ANTLR start "argumentList"
	// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:425:1: argumentList returns [List<String> labels, List<String> values] : ( argument[$labels, $values] )+ ;
	public final CSSTree.argumentList_return argumentList() throws RecognitionException {
		CSSTree.argumentList_return retval = new CSSTree.argumentList_return();
		retval.start = input.LT(1);


		    retval.labels = new ArrayList<String>(3);
		    retval.values = new ArrayList<String>(3);

		try {
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:431:5: ( ( argument[$labels, $values] )+ )
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:431:9: ( argument[$labels, $values] )+
			{
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:431:9: ( argument[$labels, $values] )+
			int cnt23=0;
			loop23:
			while (true) {
				int alt23=2;
				int LA23_0 = input.LA(1);
				if ( (LA23_0==EQUALS) ) {
					alt23=1;
				}

				switch (alt23) {
				case 1 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:431:9: argument[$labels, $values]
					{
					pushFollow(FOLLOW_argument_in_argumentList2054);
					argument(retval.labels, retval.values);
					state._fsp--;

					}
					break;

				default :
					if ( cnt23 >= 1 ) break loop23;
					EarlyExitException eee = new EarlyExitException(23, input);
					throw eee;
				}
				cnt23++;
			}

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "argumentList"



	// $ANTLR start "argument"
	// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:434:1: argument[List<String> labels, List<String> values] : ^( EQUALS (l= ID )? v= STRING ) ;
	public final void argument(List<String> labels, List<String> values) throws RecognitionException {
		CommonTree l=null;
		CommonTree v=null;

		try {
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:441:5: ( ^( EQUALS (l= ID )? v= STRING ) )
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:441:9: ^( EQUALS (l= ID )? v= STRING )
			{
			match(input,EQUALS,FOLLOW_EQUALS_in_argument2087); 
			match(input, Token.DOWN, null); 
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:441:19: (l= ID )?
			int alt24=2;
			int LA24_0 = input.LA(1);
			if ( (LA24_0==ID) ) {
				alt24=1;
			}
			switch (alt24) {
				case 1 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSSTree.g:441:19: l= ID
					{
					l=(CommonTree)match(input,ID,FOLLOW_ID_in_argument2091); 
					}
					break;

			}

			v=(CommonTree)match(input,STRING,FOLLOW_STRING_in_argument2096); 
			match(input, Token.UP, null); 

			}


			    // Use null for argument without label.
			    labels.add((l!=null?l.getText():null));
			    values.add((v!=null?v.getText():null)); 

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "argument"

	// Delegated rules



	public static final BitSet FOLLOW_namespaceStatement_in_stylesheet94 = new BitSet(new long[]{0x00000008000007C2L});
	public static final BitSet FOLLOW_fontFace_in_stylesheet98 = new BitSet(new long[]{0x00000008000007C2L});
	public static final BitSet FOLLOW_keyframes_in_stylesheet102 = new BitSet(new long[]{0x00000008000007C2L});
	public static final BitSet FOLLOW_mediaQuery_in_stylesheet106 = new BitSet(new long[]{0x00000008000007C2L});
	public static final BitSet FOLLOW_ruleset_in_stylesheet110 = new BitSet(new long[]{0x00000008000007C2L});
	public static final BitSet FOLLOW_AT_NAMESPACE_in_namespaceStatement146 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_ID_in_namespaceStatement150 = new BitSet(new long[]{0x8000000000000000L});
	public static final BitSet FOLLOW_STRING_in_namespaceStatement155 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_AT_KEYFRAMES_in_keyframes178 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_ID_in_keyframes182 = new BitSet(new long[]{0x0000000800000008L});
	public static final BitSet FOLLOW_ruleset_in_keyframes184 = new BitSet(new long[]{0x0000000800000008L});
	public static final BitSet FOLLOW_AT_WEBKIT_KEYFRAMES_in_keyframes208 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_ID_in_keyframes212 = new BitSet(new long[]{0x0000000800000008L});
	public static final BitSet FOLLOW_ruleset_in_keyframes214 = new BitSet(new long[]{0x0000000800000008L});
	public static final BitSet FOLLOW_AT_MEDIA_in_mediaQuery261 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_medium_in_mediaQuery263 = new BitSet(new long[]{0x0000000800000008L});
	public static final BitSet FOLLOW_ruleset_in_mediaQuery265 = new BitSet(new long[]{0x0000000800000008L});
	public static final BitSet FOLLOW_I_MEDIUM_CONDITIONS_in_medium290 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_mediumCondition_in_medium292 = new BitSet(new long[]{0x0001000040010028L});
	public static final BitSet FOLLOW_ID_in_mediumCondition315 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ONLY_in_mediumCondition331 = new BitSet(new long[]{0x0000000040000000L});
	public static final BitSet FOLLOW_ID_in_mediumCondition335 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ARGUMENTS_in_mediumCondition351 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_COMMA_in_mediumCondition366 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_AT_FONT_FACE_in_fontFace402 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_declarationsBlock_in_fontFace406 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_I_RULE_in_ruleset446 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_selectorGroup_in_ruleset448 = new BitSet(new long[]{0x0000000200000000L});
	public static final BitSet FOLLOW_declarationsBlock_in_ruleset452 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_I_SELECTOR_GROUP_in_selectorGroup472 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_compoundSelector_in_selectorGroup474 = new BitSet(new long[]{0x0000002000000008L});
	public static final BitSet FOLLOW_I_SELECTOR_in_compoundSelector510 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_simpleSelector_in_compoundSelector512 = new BitSet(new long[]{0x0000008000000008L});
	public static final BitSet FOLLOW_I_SIMPLE_SELECTOR_in_simpleSelector558 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_simpleSelectorFraction_in_simpleSelector560 = new BitSet(new long[]{0x6008400048308008L,0x0000000000000062L});
	public static final BitSet FOLLOW_elementSelector_in_simpleSelectorFraction589 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_conditionSelector_in_simpleSelectorFraction599 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DOT_in_conditionSelector633 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_ID_in_conditionSelector637 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_HASH_WORD_in_conditionSelector654 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_COLON_in_conditionSelector669 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_NOT_in_conditionSelector671 = new BitSet(new long[]{0x0000000000000020L});
	public static final BitSet FOLLOW_ARGUMENTS_in_conditionSelector675 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_COLON_in_conditionSelector689 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_ID_in_conditionSelector693 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_DOUBLE_COLON_in_conditionSelector708 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_ID_in_conditionSelector712 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_attributeSelector_in_conditionSelector726 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_childSelector_in_conditionSelector738 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_precededSelector_in_conditionSelector750 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_siblingSelector_in_conditionSelector762 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_PIPE_in_elementSelector786 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_ID_in_elementSelector790 = new BitSet(new long[]{0x0000000040000000L});
	public static final BitSet FOLLOW_ID_in_elementSelector794 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_ID_in_elementSelector819 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_NUMBER_WITH_PERCENT_in_elementSelector854 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_STAR_in_elementSelector887 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_70_in_childSelector931 = new BitSet(new long[]{0x6008400048308000L,0x0000000000000062L});
	public static final BitSet FOLLOW_simpleSelectorFraction_in_childSelector933 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_TILDE_in_precededSelector956 = new BitSet(new long[]{0x6008400048308000L,0x0000000000000062L});
	public static final BitSet FOLLOW_simpleSelectorFraction_in_precededSelector958 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_69_in_siblingSelector981 = new BitSet(new long[]{0x6008400048308000L,0x0000000000000062L});
	public static final BitSet FOLLOW_simpleSelectorFraction_in_siblingSelector983 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_SQUARE_OPEN_in_attributeSelector1006 = new BitSet(new long[]{0x0000000040000000L});
	public static final BitSet FOLLOW_attributeName_in_attributeSelector1008 = new BitSet(new long[]{0x9000020021840800L});
	public static final BitSet FOLLOW_attributeOperator_in_attributeSelector1010 = new BitSet(new long[]{0x9000020021840800L});
	public static final BitSet FOLLOW_attributeValue_in_attributeSelector1013 = new BitSet(new long[]{0x9000000000000000L});
	public static final BitSet FOLLOW_SQUARE_END_in_attributeSelector1020 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ID_in_attributeName1051 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_BEGINS_WITH_in_attributeOperator1090 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ENDS_WITH_in_attributeOperator1116 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_CONTAINS_in_attributeOperator1142 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LIST_MATCH_in_attributeOperator1168 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_HREFLANG_MATCH_in_attributeOperator1194 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_EQUALS_in_attributeOperator1220 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_STRING_in_attributeValue1259 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_I_DECL_in_declarationsBlock1306 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_declaration_in_declarationsBlock1309 = new BitSet(new long[]{0x0000000000008008L});
	public static final BitSet FOLLOW_COLON_in_declaration1363 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_ID_in_declaration1367 = new BitSet(new long[]{0x85F2C401C8404010L,0x000000000000000CL});
	public static final BitSet FOLLOW_value_in_declaration1371 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_I_ARRAY_in_value1401 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_singleValue_in_value1451 = new BitSet(new long[]{0x85F2C400C8404018L,0x000000000000000CL});
	public static final BitSet FOLLOW_singleValue_in_value1502 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_NUMBER_WITH_PERCENT_in_singleValue1540 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_NUMBER_WITH_UNIT_in_singleValue1563 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_HASH_WORD_in_singleValue1586 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ALPHA_VALUE_in_singleValue1615 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_RECT_VALUE_in_singleValue1635 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ROTATE_VALUE_in_singleValue1655 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_SCALE_VALUE_in_singleValue1675 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_TRANSLATE3D_VALUE_in_singleValue1695 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_RGB_in_singleValue1715 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_RGBA_in_singleValue1732 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_CLASS_REFERENCE_in_singleValue1750 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_ARGUMENTS_in_singleValue1754 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_PROPERTY_REFERENCE_in_singleValue1776 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_ARGUMENTS_in_singleValue1780 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_EMBED_in_singleValue1802 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_ARGUMENTS_in_singleValue1806 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_URL_in_singleValue1828 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_ARGUMENTS_in_singleValue1832 = new BitSet(new long[]{0x0000000004000008L});
	public static final BitSet FOLLOW_formatOption_in_singleValue1836 = new BitSet(new long[]{0x0000000004000008L});
	public static final BitSet FOLLOW_LOCAL_in_singleValue1859 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_ARGUMENTS_in_singleValue1863 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_STRING_in_singleValue1886 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ID_in_singleValue1928 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_OPERATOR_in_singleValue1949 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_IMPORTANT_in_singleValue1970 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_FORMAT_in_formatOption2009 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_ARGUMENTS_in_formatOption2013 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_argument_in_argumentList2054 = new BitSet(new long[]{0x0000000001000002L});
	public static final BitSet FOLLOW_EQUALS_in_argument2087 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_ID_in_argument2091 = new BitSet(new long[]{0x8000000000000000L});
	public static final BitSet FOLLOW_STRING_in_argument2096 = new BitSet(new long[]{0x0000000000000008L});
}
