// $ANTLR 3.5.2 /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g 2016-09-05 07:02:53

/*
 *
 *  Licensed to the Apache Software Foundation (ASF) under one or more
 *  contributor license agreements.  See the NOTICE file distributed with
 *  this work for additional information regarding copyright ownership.
 *  The ASF licenses this file to You under the Apache License, Version 2.0
 *  (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 */

package org.apache.flex.compiler.internal.css;

import java.util.Map;
import java.util.HashMap;
import org.apache.flex.compiler.problems.CSSParserProblem;


import org.antlr.runtime.*;
import java.util.Stack;
import java.util.List;
import java.util.ArrayList;

import org.antlr.runtime.tree.*;


/**
 * This is a grammar for advanced CSS in Flex. It parses the CSS document and
 * generate DOM objects.
 */
@SuppressWarnings("all")
public class CSSParser extends Parser {
	public static final String[] tokenNames = new String[] {
		"<invalid>", "<EOR>", "<DOWN>", "<UP>", "ALPHA_VALUE", "ARGUMENTS", "AT_FONT_FACE", 
		"AT_KEYFRAMES", "AT_MEDIA", "AT_NAMESPACE", "AT_WEBKIT_KEYFRAMES", "BEGINS_WITH", 
		"BLOCK_END", "BLOCK_OPEN", "CLASS_REFERENCE", "COLON", "COMMA", "COMMENT", 
		"CONTAINS", "DIGIT", "DOT", "DOUBLE_COLON", "EMBED", "ENDS_WITH", "EQUALS", 
		"ESCAPED_HEX", "FORMAT", "HASH_WORD", "HEX_DIGIT", "HREFLANG_MATCH", "ID", 
		"IMPORTANT", "I_ARRAY", "I_DECL", "I_MEDIUM_CONDITIONS", "I_RULE", "I_RULES", 
		"I_SELECTOR", "I_SELECTOR_GROUP", "I_SIMPLE_SELECTOR", "LETTER", "LIST_MATCH", 
		"LOCAL", "NOT", "NULL", "NUMBER", "NUMBER_WITH_PERCENT", "NUMBER_WITH_UNIT", 
		"ONLY", "OPERATOR", "PERCENT", "PIPE", "PROPERTY_REFERENCE", "RECT_VALUE", 
		"RGB", "RGBA", "ROTATE_VALUE", "SCALE", "SCALE_VALUE", "SEMI_COLONS", 
		"SQUARE_END", "SQUARE_OPEN", "STAR", "STRING", "STRING_QUOTE", "TILDE", 
		"TRANSLATE3D_VALUE", "URL", "WS", "'+'", "'>'", "'and'"
	};
	public static final int EOF=-1;
	public static final int T__69=69;
	public static final int T__70=70;
	public static final int T__71=71;
	public static final int ALPHA_VALUE=4;
	public static final int ARGUMENTS=5;
	public static final int AT_FONT_FACE=6;
	public static final int AT_KEYFRAMES=7;
	public static final int AT_MEDIA=8;
	public static final int AT_NAMESPACE=9;
	public static final int AT_WEBKIT_KEYFRAMES=10;
	public static final int BEGINS_WITH=11;
	public static final int BLOCK_END=12;
	public static final int BLOCK_OPEN=13;
	public static final int CLASS_REFERENCE=14;
	public static final int COLON=15;
	public static final int COMMA=16;
	public static final int COMMENT=17;
	public static final int CONTAINS=18;
	public static final int DIGIT=19;
	public static final int DOT=20;
	public static final int DOUBLE_COLON=21;
	public static final int EMBED=22;
	public static final int ENDS_WITH=23;
	public static final int EQUALS=24;
	public static final int ESCAPED_HEX=25;
	public static final int FORMAT=26;
	public static final int HASH_WORD=27;
	public static final int HEX_DIGIT=28;
	public static final int HREFLANG_MATCH=29;
	public static final int ID=30;
	public static final int IMPORTANT=31;
	public static final int I_ARRAY=32;
	public static final int I_DECL=33;
	public static final int I_MEDIUM_CONDITIONS=34;
	public static final int I_RULE=35;
	public static final int I_RULES=36;
	public static final int I_SELECTOR=37;
	public static final int I_SELECTOR_GROUP=38;
	public static final int I_SIMPLE_SELECTOR=39;
	public static final int LETTER=40;
	public static final int LIST_MATCH=41;
	public static final int LOCAL=42;
	public static final int NOT=43;
	public static final int NULL=44;
	public static final int NUMBER=45;
	public static final int NUMBER_WITH_PERCENT=46;
	public static final int NUMBER_WITH_UNIT=47;
	public static final int ONLY=48;
	public static final int OPERATOR=49;
	public static final int PERCENT=50;
	public static final int PIPE=51;
	public static final int PROPERTY_REFERENCE=52;
	public static final int RECT_VALUE=53;
	public static final int RGB=54;
	public static final int RGBA=55;
	public static final int ROTATE_VALUE=56;
	public static final int SCALE=57;
	public static final int SCALE_VALUE=58;
	public static final int SEMI_COLONS=59;
	public static final int SQUARE_END=60;
	public static final int SQUARE_OPEN=61;
	public static final int STAR=62;
	public static final int STRING=63;
	public static final int STRING_QUOTE=64;
	public static final int TILDE=65;
	public static final int TRANSLATE3D_VALUE=66;
	public static final int URL=67;
	public static final int WS=68;

	// delegates
	public Parser[] getDelegates() {
		return new Parser[] {};
	}

	// delegators


	public CSSParser(TokenStream input) {
		this(input, new RecognizerSharedState());
	}
	public CSSParser(TokenStream input, RecognizerSharedState state) {
		super(input, state);
	}

	protected TreeAdaptor adaptor = new CommonTreeAdaptor();

	public void setTreeAdaptor(TreeAdaptor adaptor) {
		this.adaptor = adaptor;
	}
	public TreeAdaptor getTreeAdaptor() {
		return adaptor;
	}
	@Override public String[] getTokenNames() { return CSSParser.tokenNames; }
	@Override public String getGrammarFileName() { return "/Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g"; }



	/**
	 * Parser problems.
	 */
	protected List<CSSParserProblem> problems = new ArrayList<CSSParserProblem>();

	/**
	 * Collect parser problems.
	 */
	@Override
	public void displayRecognitionError(String[] tokenNames, RecognitionException e)
	{
	    problems.add(CSSParserProblem.create(this, tokenNames, e));
	}

	/**
	 * Check if the cursor is at the end of a simple selector.
	 */
	private final boolean endOfSimpleSelector()
	{
	    final CommonToken nextToken = (CommonToken) getTokenStream().LT(1);
	    if (nextToken == null)
	        return true;
	    
	    // Check if there's white space between the previous token and the next token.
	    final CommonToken lastToken = (CommonToken) getTokenStream().LT(-1);
	    if (lastToken != null && nextToken != null)
	    {
	        final int lastStop = lastToken.getStopIndex();
	        final int nextStart = nextToken.getStartIndex();
	        if (lastStop + 1 < nextStart)
	        {
	            return true;
	        }
	    }
	    
	    // If the next token is "{" or ",", it's also end of a selector.
	    final int nextType = nextToken.getType();
	    if (nextType == BLOCK_OPEN || nextType == COMMA)
	    {
	        return true;
	    }
	    
	    return false;
	}



	public static class stylesheet_return extends ParserRuleReturnScope {
		Object tree;
		@Override
		public Object getTree() { return tree; }
	};


	// $ANTLR start "stylesheet"
	// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:145:1: stylesheet : ( namespaceStatement | fontFace | keyframes | mediaQuery | ruleset )* ;
	public final CSSParser.stylesheet_return stylesheet() throws RecognitionException {
		CSSParser.stylesheet_return retval = new CSSParser.stylesheet_return();
		retval.start = input.LT(1);

		Object root_0 = null;

		ParserRuleReturnScope namespaceStatement1 =null;
		ParserRuleReturnScope fontFace2 =null;
		ParserRuleReturnScope keyframes3 =null;
		ParserRuleReturnScope mediaQuery4 =null;
		ParserRuleReturnScope ruleset5 =null;


		try {
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:146:5: ( ( namespaceStatement | fontFace | keyframes | mediaQuery | ruleset )* )
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:146:9: ( namespaceStatement | fontFace | keyframes | mediaQuery | ruleset )*
			{
			root_0 = (Object)adaptor.nil();


			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:146:9: ( namespaceStatement | fontFace | keyframes | mediaQuery | ruleset )*
			loop1:
			while (true) {
				int alt1=6;
				switch ( input.LA(1) ) {
				case AT_NAMESPACE:
					{
					alt1=1;
					}
					break;
				case AT_FONT_FACE:
					{
					alt1=2;
					}
					break;
				case AT_KEYFRAMES:
				case AT_WEBKIT_KEYFRAMES:
					{
					alt1=3;
					}
					break;
				case AT_MEDIA:
					{
					alt1=4;
					}
					break;
				case COLON:
				case DOT:
				case DOUBLE_COLON:
				case HASH_WORD:
				case ID:
				case NUMBER_WITH_PERCENT:
				case SQUARE_OPEN:
				case STAR:
				case TILDE:
				case 69:
				case 70:
					{
					alt1=5;
					}
					break;
				}
				switch (alt1) {
				case 1 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:146:11: namespaceStatement
					{
					pushFollow(FOLLOW_namespaceStatement_in_stylesheet137);
					namespaceStatement1=namespaceStatement();
					state._fsp--;

					adaptor.addChild(root_0, namespaceStatement1.getTree());

					}
					break;
				case 2 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:146:32: fontFace
					{
					pushFollow(FOLLOW_fontFace_in_stylesheet141);
					fontFace2=fontFace();
					state._fsp--;

					adaptor.addChild(root_0, fontFace2.getTree());

					}
					break;
				case 3 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:146:43: keyframes
					{
					pushFollow(FOLLOW_keyframes_in_stylesheet145);
					keyframes3=keyframes();
					state._fsp--;

					adaptor.addChild(root_0, keyframes3.getTree());

					}
					break;
				case 4 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:146:55: mediaQuery
					{
					pushFollow(FOLLOW_mediaQuery_in_stylesheet149);
					mediaQuery4=mediaQuery();
					state._fsp--;

					adaptor.addChild(root_0, mediaQuery4.getTree());

					}
					break;
				case 5 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:146:68: ruleset
					{
					pushFollow(FOLLOW_ruleset_in_stylesheet153);
					ruleset5=ruleset();
					state._fsp--;

					adaptor.addChild(root_0, ruleset5.getTree());

					}
					break;

				default :
					break loop1;
				}
			}

			}

			retval.stop = input.LT(-1);

			retval.tree = (Object)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "stylesheet"


	public static class namespaceStatement_return extends ParserRuleReturnScope {
		Object tree;
		@Override
		public Object getTree() { return tree; }
	};


	// $ANTLR start "namespaceStatement"
	// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:158:1: namespaceStatement : AT_NAMESPACE ( ID )? STRING SEMI_COLONS -> ^( AT_NAMESPACE ( ID )? STRING ) ;
	public final CSSParser.namespaceStatement_return namespaceStatement() throws RecognitionException {
		CSSParser.namespaceStatement_return retval = new CSSParser.namespaceStatement_return();
		retval.start = input.LT(1);

		Object root_0 = null;

		Token AT_NAMESPACE6=null;
		Token ID7=null;
		Token STRING8=null;
		Token SEMI_COLONS9=null;

		Object AT_NAMESPACE6_tree=null;
		Object ID7_tree=null;
		Object STRING8_tree=null;
		Object SEMI_COLONS9_tree=null;
		RewriteRuleTokenStream stream_ID=new RewriteRuleTokenStream(adaptor,"token ID");
		RewriteRuleTokenStream stream_AT_NAMESPACE=new RewriteRuleTokenStream(adaptor,"token AT_NAMESPACE");
		RewriteRuleTokenStream stream_SEMI_COLONS=new RewriteRuleTokenStream(adaptor,"token SEMI_COLONS");
		RewriteRuleTokenStream stream_STRING=new RewriteRuleTokenStream(adaptor,"token STRING");

		try {
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:159:5: ( AT_NAMESPACE ( ID )? STRING SEMI_COLONS -> ^( AT_NAMESPACE ( ID )? STRING ) )
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:159:9: AT_NAMESPACE ( ID )? STRING SEMI_COLONS
			{
			AT_NAMESPACE6=(Token)match(input,AT_NAMESPACE,FOLLOW_AT_NAMESPACE_in_namespaceStatement177);  
			stream_AT_NAMESPACE.add(AT_NAMESPACE6);

			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:159:22: ( ID )?
			int alt2=2;
			int LA2_0 = input.LA(1);
			if ( (LA2_0==ID) ) {
				alt2=1;
			}
			switch (alt2) {
				case 1 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:159:22: ID
					{
					ID7=(Token)match(input,ID,FOLLOW_ID_in_namespaceStatement179);  
					stream_ID.add(ID7);

					}
					break;

			}

			STRING8=(Token)match(input,STRING,FOLLOW_STRING_in_namespaceStatement182);  
			stream_STRING.add(STRING8);

			SEMI_COLONS9=(Token)match(input,SEMI_COLONS,FOLLOW_SEMI_COLONS_in_namespaceStatement184);  
			stream_SEMI_COLONS.add(SEMI_COLONS9);

			// AST REWRITE
			// elements: STRING, ID, AT_NAMESPACE
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (Object)adaptor.nil();
			// 160:6: -> ^( AT_NAMESPACE ( ID )? STRING )
			{
				// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:160:9: ^( AT_NAMESPACE ( ID )? STRING )
				{
				Object root_1 = (Object)adaptor.nil();
				root_1 = (Object)adaptor.becomeRoot(stream_AT_NAMESPACE.nextNode(), root_1);
				// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:160:24: ( ID )?
				if ( stream_ID.hasNext() ) {
					adaptor.addChild(root_1, stream_ID.nextNode());
				}
				stream_ID.reset();

				adaptor.addChild(root_1, stream_STRING.nextNode());
				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (Object)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "namespaceStatement"


	public static class keyframes_return extends ParserRuleReturnScope {
		Object tree;
		@Override
		public Object getTree() { return tree; }
	};


	// $ANTLR start "keyframes"
	// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:171:1: keyframes : ( AT_KEYFRAMES ID BLOCK_OPEN ( ruleset )* BLOCK_END -> ^( AT_KEYFRAMES ID ( ruleset )* ) | AT_WEBKIT_KEYFRAMES ID BLOCK_OPEN ( ruleset )* BLOCK_END -> ^( AT_WEBKIT_KEYFRAMES ID ( ruleset )* ) );
	public final CSSParser.keyframes_return keyframes() throws RecognitionException {
		CSSParser.keyframes_return retval = new CSSParser.keyframes_return();
		retval.start = input.LT(1);

		Object root_0 = null;

		Token AT_KEYFRAMES10=null;
		Token ID11=null;
		Token BLOCK_OPEN12=null;
		Token BLOCK_END14=null;
		Token AT_WEBKIT_KEYFRAMES15=null;
		Token ID16=null;
		Token BLOCK_OPEN17=null;
		Token BLOCK_END19=null;
		ParserRuleReturnScope ruleset13 =null;
		ParserRuleReturnScope ruleset18 =null;

		Object AT_KEYFRAMES10_tree=null;
		Object ID11_tree=null;
		Object BLOCK_OPEN12_tree=null;
		Object BLOCK_END14_tree=null;
		Object AT_WEBKIT_KEYFRAMES15_tree=null;
		Object ID16_tree=null;
		Object BLOCK_OPEN17_tree=null;
		Object BLOCK_END19_tree=null;
		RewriteRuleTokenStream stream_BLOCK_OPEN=new RewriteRuleTokenStream(adaptor,"token BLOCK_OPEN");
		RewriteRuleTokenStream stream_ID=new RewriteRuleTokenStream(adaptor,"token ID");
		RewriteRuleTokenStream stream_AT_WEBKIT_KEYFRAMES=new RewriteRuleTokenStream(adaptor,"token AT_WEBKIT_KEYFRAMES");
		RewriteRuleTokenStream stream_BLOCK_END=new RewriteRuleTokenStream(adaptor,"token BLOCK_END");
		RewriteRuleTokenStream stream_AT_KEYFRAMES=new RewriteRuleTokenStream(adaptor,"token AT_KEYFRAMES");
		RewriteRuleSubtreeStream stream_ruleset=new RewriteRuleSubtreeStream(adaptor,"rule ruleset");

		try {
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:172:5: ( AT_KEYFRAMES ID BLOCK_OPEN ( ruleset )* BLOCK_END -> ^( AT_KEYFRAMES ID ( ruleset )* ) | AT_WEBKIT_KEYFRAMES ID BLOCK_OPEN ( ruleset )* BLOCK_END -> ^( AT_WEBKIT_KEYFRAMES ID ( ruleset )* ) )
			int alt5=2;
			int LA5_0 = input.LA(1);
			if ( (LA5_0==AT_KEYFRAMES) ) {
				alt5=1;
			}
			else if ( (LA5_0==AT_WEBKIT_KEYFRAMES) ) {
				alt5=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 5, 0, input);
				throw nvae;
			}

			switch (alt5) {
				case 1 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:172:9: AT_KEYFRAMES ID BLOCK_OPEN ( ruleset )* BLOCK_END
					{
					AT_KEYFRAMES10=(Token)match(input,AT_KEYFRAMES,FOLLOW_AT_KEYFRAMES_in_keyframes227);  
					stream_AT_KEYFRAMES.add(AT_KEYFRAMES10);

					ID11=(Token)match(input,ID,FOLLOW_ID_in_keyframes229);  
					stream_ID.add(ID11);

					BLOCK_OPEN12=(Token)match(input,BLOCK_OPEN,FOLLOW_BLOCK_OPEN_in_keyframes231);  
					stream_BLOCK_OPEN.add(BLOCK_OPEN12);

					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:172:36: ( ruleset )*
					loop3:
					while (true) {
						int alt3=2;
						int LA3_0 = input.LA(1);
						if ( (LA3_0==COLON||(LA3_0 >= DOT && LA3_0 <= DOUBLE_COLON)||LA3_0==HASH_WORD||LA3_0==ID||LA3_0==NUMBER_WITH_PERCENT||(LA3_0 >= SQUARE_OPEN && LA3_0 <= STAR)||LA3_0==TILDE||(LA3_0 >= 69 && LA3_0 <= 70)) ) {
							alt3=1;
						}

						switch (alt3) {
						case 1 :
							// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:172:36: ruleset
							{
							pushFollow(FOLLOW_ruleset_in_keyframes233);
							ruleset13=ruleset();
							state._fsp--;

							stream_ruleset.add(ruleset13.getTree());
							}
							break;

						default :
							break loop3;
						}
					}

					BLOCK_END14=(Token)match(input,BLOCK_END,FOLLOW_BLOCK_END_in_keyframes236);  
					stream_BLOCK_END.add(BLOCK_END14);

					// AST REWRITE
					// elements: ID, ruleset, AT_KEYFRAMES
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 173:6: -> ^( AT_KEYFRAMES ID ( ruleset )* )
					{
						// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:173:9: ^( AT_KEYFRAMES ID ( ruleset )* )
						{
						Object root_1 = (Object)adaptor.nil();
						root_1 = (Object)adaptor.becomeRoot(stream_AT_KEYFRAMES.nextNode(), root_1);
						adaptor.addChild(root_1, stream_ID.nextNode());
						// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:173:27: ( ruleset )*
						while ( stream_ruleset.hasNext() ) {
							adaptor.addChild(root_1, stream_ruleset.nextTree());
						}
						stream_ruleset.reset();

						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 2 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:174:9: AT_WEBKIT_KEYFRAMES ID BLOCK_OPEN ( ruleset )* BLOCK_END
					{
					AT_WEBKIT_KEYFRAMES15=(Token)match(input,AT_WEBKIT_KEYFRAMES,FOLLOW_AT_WEBKIT_KEYFRAMES_in_keyframes262);  
					stream_AT_WEBKIT_KEYFRAMES.add(AT_WEBKIT_KEYFRAMES15);

					ID16=(Token)match(input,ID,FOLLOW_ID_in_keyframes264);  
					stream_ID.add(ID16);

					BLOCK_OPEN17=(Token)match(input,BLOCK_OPEN,FOLLOW_BLOCK_OPEN_in_keyframes266);  
					stream_BLOCK_OPEN.add(BLOCK_OPEN17);

					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:174:43: ( ruleset )*
					loop4:
					while (true) {
						int alt4=2;
						int LA4_0 = input.LA(1);
						if ( (LA4_0==COLON||(LA4_0 >= DOT && LA4_0 <= DOUBLE_COLON)||LA4_0==HASH_WORD||LA4_0==ID||LA4_0==NUMBER_WITH_PERCENT||(LA4_0 >= SQUARE_OPEN && LA4_0 <= STAR)||LA4_0==TILDE||(LA4_0 >= 69 && LA4_0 <= 70)) ) {
							alt4=1;
						}

						switch (alt4) {
						case 1 :
							// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:174:43: ruleset
							{
							pushFollow(FOLLOW_ruleset_in_keyframes268);
							ruleset18=ruleset();
							state._fsp--;

							stream_ruleset.add(ruleset18.getTree());
							}
							break;

						default :
							break loop4;
						}
					}

					BLOCK_END19=(Token)match(input,BLOCK_END,FOLLOW_BLOCK_END_in_keyframes271);  
					stream_BLOCK_END.add(BLOCK_END19);

					// AST REWRITE
					// elements: ruleset, ID, AT_WEBKIT_KEYFRAMES
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 175:6: -> ^( AT_WEBKIT_KEYFRAMES ID ( ruleset )* )
					{
						// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:175:9: ^( AT_WEBKIT_KEYFRAMES ID ( ruleset )* )
						{
						Object root_1 = (Object)adaptor.nil();
						root_1 = (Object)adaptor.becomeRoot(stream_AT_WEBKIT_KEYFRAMES.nextNode(), root_1);
						adaptor.addChild(root_1, stream_ID.nextNode());
						// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:175:34: ( ruleset )*
						while ( stream_ruleset.hasNext() ) {
							adaptor.addChild(root_1, stream_ruleset.nextTree());
						}
						stream_ruleset.reset();

						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (Object)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "keyframes"


	public static class mediaQuery_return extends ParserRuleReturnScope {
		Object tree;
		@Override
		public Object getTree() { return tree; }
	};


	// $ANTLR start "mediaQuery"
	// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:186:1: mediaQuery : AT_MEDIA medium BLOCK_OPEN ( ruleset )* BLOCK_END -> ^( AT_MEDIA medium ( ruleset )* ) ;
	public final CSSParser.mediaQuery_return mediaQuery() throws RecognitionException {
		CSSParser.mediaQuery_return retval = new CSSParser.mediaQuery_return();
		retval.start = input.LT(1);

		Object root_0 = null;

		Token AT_MEDIA20=null;
		Token BLOCK_OPEN22=null;
		Token BLOCK_END24=null;
		ParserRuleReturnScope medium21 =null;
		ParserRuleReturnScope ruleset23 =null;

		Object AT_MEDIA20_tree=null;
		Object BLOCK_OPEN22_tree=null;
		Object BLOCK_END24_tree=null;
		RewriteRuleTokenStream stream_BLOCK_OPEN=new RewriteRuleTokenStream(adaptor,"token BLOCK_OPEN");
		RewriteRuleTokenStream stream_AT_MEDIA=new RewriteRuleTokenStream(adaptor,"token AT_MEDIA");
		RewriteRuleTokenStream stream_BLOCK_END=new RewriteRuleTokenStream(adaptor,"token BLOCK_END");
		RewriteRuleSubtreeStream stream_ruleset=new RewriteRuleSubtreeStream(adaptor,"rule ruleset");
		RewriteRuleSubtreeStream stream_medium=new RewriteRuleSubtreeStream(adaptor,"rule medium");

		try {
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:187:5: ( AT_MEDIA medium BLOCK_OPEN ( ruleset )* BLOCK_END -> ^( AT_MEDIA medium ( ruleset )* ) )
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:187:9: AT_MEDIA medium BLOCK_OPEN ( ruleset )* BLOCK_END
			{
			AT_MEDIA20=(Token)match(input,AT_MEDIA,FOLLOW_AT_MEDIA_in_mediaQuery310);  
			stream_AT_MEDIA.add(AT_MEDIA20);

			pushFollow(FOLLOW_medium_in_mediaQuery312);
			medium21=medium();
			state._fsp--;

			stream_medium.add(medium21.getTree());
			BLOCK_OPEN22=(Token)match(input,BLOCK_OPEN,FOLLOW_BLOCK_OPEN_in_mediaQuery314);  
			stream_BLOCK_OPEN.add(BLOCK_OPEN22);

			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:187:36: ( ruleset )*
			loop6:
			while (true) {
				int alt6=2;
				int LA6_0 = input.LA(1);
				if ( (LA6_0==COLON||(LA6_0 >= DOT && LA6_0 <= DOUBLE_COLON)||LA6_0==HASH_WORD||LA6_0==ID||LA6_0==NUMBER_WITH_PERCENT||(LA6_0 >= SQUARE_OPEN && LA6_0 <= STAR)||LA6_0==TILDE||(LA6_0 >= 69 && LA6_0 <= 70)) ) {
					alt6=1;
				}

				switch (alt6) {
				case 1 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:187:36: ruleset
					{
					pushFollow(FOLLOW_ruleset_in_mediaQuery316);
					ruleset23=ruleset();
					state._fsp--;

					stream_ruleset.add(ruleset23.getTree());
					}
					break;

				default :
					break loop6;
				}
			}

			BLOCK_END24=(Token)match(input,BLOCK_END,FOLLOW_BLOCK_END_in_mediaQuery319);  
			stream_BLOCK_END.add(BLOCK_END24);

			// AST REWRITE
			// elements: ruleset, medium, AT_MEDIA
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (Object)adaptor.nil();
			// 188:6: -> ^( AT_MEDIA medium ( ruleset )* )
			{
				// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:188:9: ^( AT_MEDIA medium ( ruleset )* )
				{
				Object root_1 = (Object)adaptor.nil();
				root_1 = (Object)adaptor.becomeRoot(stream_AT_MEDIA.nextNode(), root_1);
				adaptor.addChild(root_1, stream_medium.nextTree());
				// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:188:27: ( ruleset )*
				while ( stream_ruleset.hasNext() ) {
					adaptor.addChild(root_1, stream_ruleset.nextTree());
				}
				stream_ruleset.reset();

				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (Object)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "mediaQuery"


	public static class medium_return extends ParserRuleReturnScope {
		Object tree;
		@Override
		public Object getTree() { return tree; }
	};


	// $ANTLR start "medium"
	// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:195:1: medium : mediumCondition ( 'and' mediumCondition | mediumCondition )* -> ^( I_MEDIUM_CONDITIONS ( mediumCondition )* ) ;
	public final CSSParser.medium_return medium() throws RecognitionException {
		CSSParser.medium_return retval = new CSSParser.medium_return();
		retval.start = input.LT(1);

		Object root_0 = null;

		Token string_literal26=null;
		ParserRuleReturnScope mediumCondition25 =null;
		ParserRuleReturnScope mediumCondition27 =null;
		ParserRuleReturnScope mediumCondition28 =null;

		Object string_literal26_tree=null;
		RewriteRuleTokenStream stream_71=new RewriteRuleTokenStream(adaptor,"token 71");
		RewriteRuleSubtreeStream stream_mediumCondition=new RewriteRuleSubtreeStream(adaptor,"rule mediumCondition");

		try {
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:196:5: ( mediumCondition ( 'and' mediumCondition | mediumCondition )* -> ^( I_MEDIUM_CONDITIONS ( mediumCondition )* ) )
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:196:9: mediumCondition ( 'and' mediumCondition | mediumCondition )*
			{
			pushFollow(FOLLOW_mediumCondition_in_medium359);
			mediumCondition25=mediumCondition();
			state._fsp--;

			stream_mediumCondition.add(mediumCondition25.getTree());
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:197:9: ( 'and' mediumCondition | mediumCondition )*
			loop7:
			while (true) {
				int alt7=3;
				int LA7_0 = input.LA(1);
				if ( (LA7_0==71) ) {
					alt7=1;
				}
				else if ( (LA7_0==ARGUMENTS||LA7_0==COMMA||LA7_0==ID||LA7_0==ONLY) ) {
					alt7=2;
				}

				switch (alt7) {
				case 1 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:199:13: 'and' mediumCondition
					{
					string_literal26=(Token)match(input,71,FOLLOW_71_in_medium402);  
					stream_71.add(string_literal26);

					pushFollow(FOLLOW_mediumCondition_in_medium417);
					mediumCondition27=mediumCondition();
					state._fsp--;

					stream_mediumCondition.add(mediumCondition27.getTree());
					}
					break;
				case 2 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:201:15: mediumCondition
					{
					pushFollow(FOLLOW_mediumCondition_in_medium433);
					mediumCondition28=mediumCondition();
					state._fsp--;

					stream_mediumCondition.add(mediumCondition28.getTree());
					}
					break;

				default :
					break loop7;
				}
			}

			// AST REWRITE
			// elements: mediumCondition
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (Object)adaptor.nil();
			// 203:9: -> ^( I_MEDIUM_CONDITIONS ( mediumCondition )* )
			{
				// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:203:12: ^( I_MEDIUM_CONDITIONS ( mediumCondition )* )
				{
				Object root_1 = (Object)adaptor.nil();
				root_1 = (Object)adaptor.becomeRoot((Object)adaptor.create(I_MEDIUM_CONDITIONS, "I_MEDIUM_CONDITIONS"), root_1);
				// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:203:34: ( mediumCondition )*
				while ( stream_mediumCondition.hasNext() ) {
					adaptor.addChild(root_1, stream_mediumCondition.nextTree());
				}
				stream_mediumCondition.reset();

				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (Object)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "medium"


	public static class mediumCondition_return extends ParserRuleReturnScope {
		Object tree;
		@Override
		public Object getTree() { return tree; }
	};


	// $ANTLR start "mediumCondition"
	// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:210:1: mediumCondition : ( ID | ONLY ID | ARGUMENTS | COMMA );
	public final CSSParser.mediumCondition_return mediumCondition() throws RecognitionException {
		CSSParser.mediumCondition_return retval = new CSSParser.mediumCondition_return();
		retval.start = input.LT(1);

		Object root_0 = null;

		Token ID29=null;
		Token ONLY30=null;
		Token ID31=null;
		Token ARGUMENTS32=null;
		Token COMMA33=null;

		Object ID29_tree=null;
		Object ONLY30_tree=null;
		Object ID31_tree=null;
		Object ARGUMENTS32_tree=null;
		Object COMMA33_tree=null;

		try {
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:211:5: ( ID | ONLY ID | ARGUMENTS | COMMA )
			int alt8=4;
			switch ( input.LA(1) ) {
			case ID:
				{
				alt8=1;
				}
				break;
			case ONLY:
				{
				alt8=2;
				}
				break;
			case ARGUMENTS:
				{
				alt8=3;
				}
				break;
			case COMMA:
				{
				alt8=4;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 8, 0, input);
				throw nvae;
			}
			switch (alt8) {
				case 1 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:211:9: ID
					{
					root_0 = (Object)adaptor.nil();


					ID29=(Token)match(input,ID,FOLLOW_ID_in_mediumCondition484); 
					ID29_tree = (Object)adaptor.create(ID29);
					adaptor.addChild(root_0, ID29_tree);

					}
					break;
				case 2 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:212:9: ONLY ID
					{
					root_0 = (Object)adaptor.nil();


					ONLY30=(Token)match(input,ONLY,FOLLOW_ONLY_in_mediumCondition494); 
					ONLY30_tree = (Object)adaptor.create(ONLY30);
					adaptor.addChild(root_0, ONLY30_tree);

					ID31=(Token)match(input,ID,FOLLOW_ID_in_mediumCondition496); 
					ID31_tree = (Object)adaptor.create(ID31);
					adaptor.addChild(root_0, ID31_tree);

					}
					break;
				case 3 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:213:9: ARGUMENTS
					{
					root_0 = (Object)adaptor.nil();


					ARGUMENTS32=(Token)match(input,ARGUMENTS,FOLLOW_ARGUMENTS_in_mediumCondition510); 
					ARGUMENTS32_tree = (Object)adaptor.create(ARGUMENTS32);
					adaptor.addChild(root_0, ARGUMENTS32_tree);

					}
					break;
				case 4 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:214:9: COMMA
					{
					root_0 = (Object)adaptor.nil();


					COMMA33=(Token)match(input,COMMA,FOLLOW_COMMA_in_mediumCondition520); 
					COMMA33_tree = (Object)adaptor.create(COMMA33);
					adaptor.addChild(root_0, COMMA33_tree);

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (Object)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "mediumCondition"


	public static class fontFace_return extends ParserRuleReturnScope {
		Object tree;
		@Override
		public Object getTree() { return tree; }
	};


	// $ANTLR start "fontFace"
	// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:228:1: fontFace : AT_FONT_FACE declarationsBlock -> ^( AT_FONT_FACE declarationsBlock ) ;
	public final CSSParser.fontFace_return fontFace() throws RecognitionException {
		CSSParser.fontFace_return retval = new CSSParser.fontFace_return();
		retval.start = input.LT(1);

		Object root_0 = null;

		Token AT_FONT_FACE34=null;
		ParserRuleReturnScope declarationsBlock35 =null;

		Object AT_FONT_FACE34_tree=null;
		RewriteRuleTokenStream stream_AT_FONT_FACE=new RewriteRuleTokenStream(adaptor,"token AT_FONT_FACE");
		RewriteRuleSubtreeStream stream_declarationsBlock=new RewriteRuleSubtreeStream(adaptor,"rule declarationsBlock");

		try {
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:229:5: ( AT_FONT_FACE declarationsBlock -> ^( AT_FONT_FACE declarationsBlock ) )
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:229:9: AT_FONT_FACE declarationsBlock
			{
			AT_FONT_FACE34=(Token)match(input,AT_FONT_FACE,FOLLOW_AT_FONT_FACE_in_fontFace549);  
			stream_AT_FONT_FACE.add(AT_FONT_FACE34);

			pushFollow(FOLLOW_declarationsBlock_in_fontFace551);
			declarationsBlock35=declarationsBlock();
			state._fsp--;

			stream_declarationsBlock.add(declarationsBlock35.getTree());
			// AST REWRITE
			// elements: AT_FONT_FACE, declarationsBlock
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (Object)adaptor.nil();
			// 229:40: -> ^( AT_FONT_FACE declarationsBlock )
			{
				// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:229:43: ^( AT_FONT_FACE declarationsBlock )
				{
				Object root_1 = (Object)adaptor.nil();
				root_1 = (Object)adaptor.becomeRoot(stream_AT_FONT_FACE.nextNode(), root_1);
				adaptor.addChild(root_1, stream_declarationsBlock.nextTree());
				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (Object)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "fontFace"


	public static class ruleset_return extends ParserRuleReturnScope {
		Object tree;
		@Override
		public Object getTree() { return tree; }
	};


	// $ANTLR start "ruleset"
	// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:235:1: ruleset : selectorGroup declarationsBlock -> ^( I_RULE selectorGroup declarationsBlock ) ;
	public final CSSParser.ruleset_return ruleset() throws RecognitionException {
		CSSParser.ruleset_return retval = new CSSParser.ruleset_return();
		retval.start = input.LT(1);

		Object root_0 = null;

		ParserRuleReturnScope selectorGroup36 =null;
		ParserRuleReturnScope declarationsBlock37 =null;

		RewriteRuleSubtreeStream stream_declarationsBlock=new RewriteRuleSubtreeStream(adaptor,"rule declarationsBlock");
		RewriteRuleSubtreeStream stream_selectorGroup=new RewriteRuleSubtreeStream(adaptor,"rule selectorGroup");

		try {
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:236:5: ( selectorGroup declarationsBlock -> ^( I_RULE selectorGroup declarationsBlock ) )
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:236:9: selectorGroup declarationsBlock
			{
			pushFollow(FOLLOW_selectorGroup_in_ruleset582);
			selectorGroup36=selectorGroup();
			state._fsp--;

			stream_selectorGroup.add(selectorGroup36.getTree());
			pushFollow(FOLLOW_declarationsBlock_in_ruleset584);
			declarationsBlock37=declarationsBlock();
			state._fsp--;

			stream_declarationsBlock.add(declarationsBlock37.getTree());
			// AST REWRITE
			// elements: selectorGroup, declarationsBlock
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (Object)adaptor.nil();
			// 237:9: -> ^( I_RULE selectorGroup declarationsBlock )
			{
				// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:237:12: ^( I_RULE selectorGroup declarationsBlock )
				{
				Object root_1 = (Object)adaptor.nil();
				root_1 = (Object)adaptor.becomeRoot((Object)adaptor.create(I_RULE, "I_RULE"), root_1);
				adaptor.addChild(root_1, stream_selectorGroup.nextTree());
				adaptor.addChild(root_1, stream_declarationsBlock.nextTree());
				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (Object)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "ruleset"


	public static class selectorGroup_return extends ParserRuleReturnScope {
		Object tree;
		@Override
		public Object getTree() { return tree; }
	};


	// $ANTLR start "selectorGroup"
	// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:243:1: selectorGroup : compoundSelector ( COMMA compoundSelector )* -> ^( I_SELECTOR_GROUP ( compoundSelector )+ ) ;
	public final CSSParser.selectorGroup_return selectorGroup() throws RecognitionException {
		CSSParser.selectorGroup_return retval = new CSSParser.selectorGroup_return();
		retval.start = input.LT(1);

		Object root_0 = null;

		Token COMMA39=null;
		ParserRuleReturnScope compoundSelector38 =null;
		ParserRuleReturnScope compoundSelector40 =null;

		Object COMMA39_tree=null;
		RewriteRuleTokenStream stream_COMMA=new RewriteRuleTokenStream(adaptor,"token COMMA");
		RewriteRuleSubtreeStream stream_compoundSelector=new RewriteRuleSubtreeStream(adaptor,"rule compoundSelector");

		try {
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:244:2: ( compoundSelector ( COMMA compoundSelector )* -> ^( I_SELECTOR_GROUP ( compoundSelector )+ ) )
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:244:4: compoundSelector ( COMMA compoundSelector )*
			{
			pushFollow(FOLLOW_compoundSelector_in_selectorGroup618);
			compoundSelector38=compoundSelector();
			state._fsp--;

			stream_compoundSelector.add(compoundSelector38.getTree());
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:244:21: ( COMMA compoundSelector )*
			loop9:
			while (true) {
				int alt9=2;
				int LA9_0 = input.LA(1);
				if ( (LA9_0==COMMA) ) {
					alt9=1;
				}

				switch (alt9) {
				case 1 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:244:23: COMMA compoundSelector
					{
					COMMA39=(Token)match(input,COMMA,FOLLOW_COMMA_in_selectorGroup622);  
					stream_COMMA.add(COMMA39);

					pushFollow(FOLLOW_compoundSelector_in_selectorGroup624);
					compoundSelector40=compoundSelector();
					state._fsp--;

					stream_compoundSelector.add(compoundSelector40.getTree());
					}
					break;

				default :
					break loop9;
				}
			}

			// AST REWRITE
			// elements: compoundSelector
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (Object)adaptor.nil();
			// 245:9: -> ^( I_SELECTOR_GROUP ( compoundSelector )+ )
			{
				// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:245:12: ^( I_SELECTOR_GROUP ( compoundSelector )+ )
				{
				Object root_1 = (Object)adaptor.nil();
				root_1 = (Object)adaptor.becomeRoot((Object)adaptor.create(I_SELECTOR_GROUP, "I_SELECTOR_GROUP"), root_1);
				if ( !(stream_compoundSelector.hasNext()) ) {
					throw new RewriteEarlyExitException();
				}
				while ( stream_compoundSelector.hasNext() ) {
					adaptor.addChild(root_1, stream_compoundSelector.nextTree());
				}
				stream_compoundSelector.reset();

				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (Object)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "selectorGroup"


	public static class compoundSelector_return extends ParserRuleReturnScope {
		Object tree;
		@Override
		public Object getTree() { return tree; }
	};


	// $ANTLR start "compoundSelector"
	// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:259:1: compoundSelector : (l= simpleSelectorFraction )+ -> ^( I_SELECTOR ) ;
	public final CSSParser.compoundSelector_return compoundSelector() throws RecognitionException {
		CSSParser.compoundSelector_return retval = new CSSParser.compoundSelector_return();
		retval.start = input.LT(1);

		Object root_0 = null;

		ParserRuleReturnScope l =null;

		RewriteRuleSubtreeStream stream_simpleSelectorFraction=new RewriteRuleSubtreeStream(adaptor,"rule simpleSelectorFraction");


			final List<Object> simpleSelectorNodeList = new ArrayList<Object>();
			Object currentSimpleSelectorNode = adaptor.create(I_SIMPLE_SELECTOR, "I_SIMPLE_SELECTOR");
			Token simpleSelectorStartToken = null;
		    Token simpleSelectorStopToken = null;

		try {
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:272:5: ( (l= simpleSelectorFraction )+ -> ^( I_SELECTOR ) )
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:272:9: (l= simpleSelectorFraction )+
			{
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:272:9: (l= simpleSelectorFraction )+
			int cnt10=0;
			loop10:
			while (true) {
				int alt10=2;
				int LA10_0 = input.LA(1);
				if ( (LA10_0==COLON||(LA10_0 >= DOT && LA10_0 <= DOUBLE_COLON)||LA10_0==HASH_WORD||LA10_0==ID||LA10_0==NUMBER_WITH_PERCENT||(LA10_0 >= SQUARE_OPEN && LA10_0 <= STAR)||LA10_0==TILDE||(LA10_0 >= 69 && LA10_0 <= 70)) ) {
					alt10=1;
				}

				switch (alt10) {
				case 1 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:272:13: l= simpleSelectorFraction
					{
					pushFollow(FOLLOW_simpleSelectorFraction_in_compoundSelector689);
					l=simpleSelectorFraction();
					state._fsp--;

					stream_simpleSelectorFraction.add(l.getTree());
					 
								    // expand token range of the current simple selector
									if (simpleSelectorStartToken == null)
									    simpleSelectorStartToken = (l!=null?(l.start):null);
									simpleSelectorStopToken = (l!=null?(l.stop):null);
									
									adaptor.addChild(currentSimpleSelectorNode, (l!=null?((Object)l.getTree()):null));
									
								    if (endOfSimpleSelector()) 
								    {
								        adaptor.setTokenBoundaries(
					                        currentSimpleSelectorNode,
					                        simpleSelectorStartToken,
					                        simpleSelectorStopToken);
								    	simpleSelectorNodeList.add(currentSimpleSelectorNode);
					                        
					                    simpleSelectorStartToken = null;
					                    simpleSelectorStopToken = null;
					                    
								    	currentSimpleSelectorNode = adaptor.create(I_SIMPLE_SELECTOR, "I_SIMPLE_SELECTOR");			   
								    }
								
					}
					break;

				default :
					if ( cnt10 >= 1 ) break loop10;
					EarlyExitException eee = new EarlyExitException(10, input);
					throw eee;
				}
				cnt10++;
			}

			// AST REWRITE
			// elements: 
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (Object)adaptor.nil();
			// 296:9: -> ^( I_SELECTOR )
			{
				// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:296:12: ^( I_SELECTOR )
				{
				Object root_1 = (Object)adaptor.nil();
				root_1 = (Object)adaptor.becomeRoot((Object)adaptor.create(I_SELECTOR, "I_SELECTOR"), root_1);
				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (Object)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);


				for(final Object simpleSelectorNode : simpleSelectorNodeList)
					adaptor.addChild(retval.tree, simpleSelectorNode);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "compoundSelector"


	public static class simpleSelectorFraction_return extends ParserRuleReturnScope {
		Object tree;
		@Override
		public Object getTree() { return tree; }
	};


	// $ANTLR start "simpleSelectorFraction"
	// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:323:1: simpleSelectorFraction : ( condition | element );
	public final CSSParser.simpleSelectorFraction_return simpleSelectorFraction() throws RecognitionException {
		CSSParser.simpleSelectorFraction_return retval = new CSSParser.simpleSelectorFraction_return();
		retval.start = input.LT(1);

		Object root_0 = null;

		ParserRuleReturnScope condition41 =null;
		ParserRuleReturnScope element42 =null;


		try {
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:324:5: ( condition | element )
			int alt11=2;
			int LA11_0 = input.LA(1);
			if ( (LA11_0==COLON||(LA11_0 >= DOT && LA11_0 <= DOUBLE_COLON)||LA11_0==HASH_WORD||LA11_0==SQUARE_OPEN||LA11_0==TILDE||(LA11_0 >= 69 && LA11_0 <= 70)) ) {
				alt11=1;
			}
			else if ( (LA11_0==ID||LA11_0==NUMBER_WITH_PERCENT||LA11_0==STAR) ) {
				alt11=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 11, 0, input);
				throw nvae;
			}

			switch (alt11) {
				case 1 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:324:9: condition
					{
					root_0 = (Object)adaptor.nil();


					pushFollow(FOLLOW_condition_in_simpleSelectorFraction759);
					condition41=condition();
					state._fsp--;

					adaptor.addChild(root_0, condition41.getTree());

					}
					break;
				case 2 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:325:9: element
					{
					root_0 = (Object)adaptor.nil();


					pushFollow(FOLLOW_element_in_simpleSelectorFraction770);
					element42=element();
					state._fsp--;

					adaptor.addChild(root_0, element42.getTree());

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (Object)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "simpleSelectorFraction"


	public static class condition_return extends ParserRuleReturnScope {
		Object tree;
		@Override
		public Object getTree() { return tree; }
	};


	// $ANTLR start "condition"
	// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:332:1: condition : ( DOT ^ ID | HASH_WORD | COLON ^ NOT ARGUMENTS | COLON ^ ID | DOUBLE_COLON ^ ID | attributeSelector | childSelector | precededSelector | siblingSelector ) ;
	public final CSSParser.condition_return condition() throws RecognitionException {
		CSSParser.condition_return retval = new CSSParser.condition_return();
		retval.start = input.LT(1);

		Object root_0 = null;

		Token DOT43=null;
		Token ID44=null;
		Token HASH_WORD45=null;
		Token COLON46=null;
		Token NOT47=null;
		Token ARGUMENTS48=null;
		Token COLON49=null;
		Token ID50=null;
		Token DOUBLE_COLON51=null;
		Token ID52=null;
		ParserRuleReturnScope attributeSelector53 =null;
		ParserRuleReturnScope childSelector54 =null;
		ParserRuleReturnScope precededSelector55 =null;
		ParserRuleReturnScope siblingSelector56 =null;

		Object DOT43_tree=null;
		Object ID44_tree=null;
		Object HASH_WORD45_tree=null;
		Object COLON46_tree=null;
		Object NOT47_tree=null;
		Object ARGUMENTS48_tree=null;
		Object COLON49_tree=null;
		Object ID50_tree=null;
		Object DOUBLE_COLON51_tree=null;
		Object ID52_tree=null;

		try {
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:333:5: ( ( DOT ^ ID | HASH_WORD | COLON ^ NOT ARGUMENTS | COLON ^ ID | DOUBLE_COLON ^ ID | attributeSelector | childSelector | precededSelector | siblingSelector ) )
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:333:9: ( DOT ^ ID | HASH_WORD | COLON ^ NOT ARGUMENTS | COLON ^ ID | DOUBLE_COLON ^ ID | attributeSelector | childSelector | precededSelector | siblingSelector )
			{
			root_0 = (Object)adaptor.nil();


			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:333:9: ( DOT ^ ID | HASH_WORD | COLON ^ NOT ARGUMENTS | COLON ^ ID | DOUBLE_COLON ^ ID | attributeSelector | childSelector | precededSelector | siblingSelector )
			int alt12=9;
			switch ( input.LA(1) ) {
			case DOT:
				{
				alt12=1;
				}
				break;
			case HASH_WORD:
				{
				alt12=2;
				}
				break;
			case COLON:
				{
				int LA12_3 = input.LA(2);
				if ( (LA12_3==NOT) ) {
					alt12=3;
				}
				else if ( (LA12_3==ID) ) {
					alt12=4;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 12, 3, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case DOUBLE_COLON:
				{
				alt12=5;
				}
				break;
			case SQUARE_OPEN:
				{
				alt12=6;
				}
				break;
			case 70:
				{
				alt12=7;
				}
				break;
			case TILDE:
				{
				alt12=8;
				}
				break;
			case 69:
				{
				alt12=9;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 12, 0, input);
				throw nvae;
			}
			switch (alt12) {
				case 1 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:333:11: DOT ^ ID
					{
					DOT43=(Token)match(input,DOT,FOLLOW_DOT_in_condition796); 
					DOT43_tree = (Object)adaptor.create(DOT43);
					root_0 = (Object)adaptor.becomeRoot(DOT43_tree, root_0);

					ID44=(Token)match(input,ID,FOLLOW_ID_in_condition799); 
					ID44_tree = (Object)adaptor.create(ID44);
					adaptor.addChild(root_0, ID44_tree);

					}
					break;
				case 2 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:334:11: HASH_WORD
					{
					HASH_WORD45=(Token)match(input,HASH_WORD,FOLLOW_HASH_WORD_in_condition811); 
					HASH_WORD45_tree = (Object)adaptor.create(HASH_WORD45);
					adaptor.addChild(root_0, HASH_WORD45_tree);

					}
					break;
				case 3 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:335:11: COLON ^ NOT ARGUMENTS
					{
					COLON46=(Token)match(input,COLON,FOLLOW_COLON_in_condition824); 
					COLON46_tree = (Object)adaptor.create(COLON46);
					root_0 = (Object)adaptor.becomeRoot(COLON46_tree, root_0);

					NOT47=(Token)match(input,NOT,FOLLOW_NOT_in_condition827); 
					NOT47_tree = (Object)adaptor.create(NOT47);
					adaptor.addChild(root_0, NOT47_tree);

					ARGUMENTS48=(Token)match(input,ARGUMENTS,FOLLOW_ARGUMENTS_in_condition829); 
					ARGUMENTS48_tree = (Object)adaptor.create(ARGUMENTS48);
					adaptor.addChild(root_0, ARGUMENTS48_tree);

					}
					break;
				case 4 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:336:11: COLON ^ ID
					{
					COLON49=(Token)match(input,COLON,FOLLOW_COLON_in_condition842); 
					COLON49_tree = (Object)adaptor.create(COLON49);
					root_0 = (Object)adaptor.becomeRoot(COLON49_tree, root_0);

					ID50=(Token)match(input,ID,FOLLOW_ID_in_condition845); 
					ID50_tree = (Object)adaptor.create(ID50);
					adaptor.addChild(root_0, ID50_tree);

					}
					break;
				case 5 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:337:11: DOUBLE_COLON ^ ID
					{
					DOUBLE_COLON51=(Token)match(input,DOUBLE_COLON,FOLLOW_DOUBLE_COLON_in_condition858); 
					DOUBLE_COLON51_tree = (Object)adaptor.create(DOUBLE_COLON51);
					root_0 = (Object)adaptor.becomeRoot(DOUBLE_COLON51_tree, root_0);

					ID52=(Token)match(input,ID,FOLLOW_ID_in_condition861); 
					ID52_tree = (Object)adaptor.create(ID52);
					adaptor.addChild(root_0, ID52_tree);

					}
					break;
				case 6 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:338:11: attributeSelector
					{
					pushFollow(FOLLOW_attributeSelector_in_condition874);
					attributeSelector53=attributeSelector();
					state._fsp--;

					adaptor.addChild(root_0, attributeSelector53.getTree());

					}
					break;
				case 7 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:339:11: childSelector
					{
					pushFollow(FOLLOW_childSelector_in_condition886);
					childSelector54=childSelector();
					state._fsp--;

					adaptor.addChild(root_0, childSelector54.getTree());

					}
					break;
				case 8 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:340:11: precededSelector
					{
					pushFollow(FOLLOW_precededSelector_in_condition898);
					precededSelector55=precededSelector();
					state._fsp--;

					adaptor.addChild(root_0, precededSelector55.getTree());

					}
					break;
				case 9 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:341:11: siblingSelector
					{
					pushFollow(FOLLOW_siblingSelector_in_condition910);
					siblingSelector56=siblingSelector();
					state._fsp--;

					adaptor.addChild(root_0, siblingSelector56.getTree());

					}
					break;

			}

			}

			retval.stop = input.LT(-1);

			retval.tree = (Object)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "condition"


	public static class element_return extends ParserRuleReturnScope {
		Object tree;
		@Override
		public Object getTree() { return tree; }
	};


	// $ANTLR start "element"
	// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:350:1: element : ( ID PIPE ^ ID | NUMBER_WITH_PERCENT | ID | STAR );
	public final CSSParser.element_return element() throws RecognitionException {
		CSSParser.element_return retval = new CSSParser.element_return();
		retval.start = input.LT(1);

		Object root_0 = null;

		Token ID57=null;
		Token PIPE58=null;
		Token ID59=null;
		Token NUMBER_WITH_PERCENT60=null;
		Token ID61=null;
		Token STAR62=null;

		Object ID57_tree=null;
		Object PIPE58_tree=null;
		Object ID59_tree=null;
		Object NUMBER_WITH_PERCENT60_tree=null;
		Object ID61_tree=null;
		Object STAR62_tree=null;

		try {
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:351:5: ( ID PIPE ^ ID | NUMBER_WITH_PERCENT | ID | STAR )
			int alt13=4;
			switch ( input.LA(1) ) {
			case ID:
				{
				int LA13_1 = input.LA(2);
				if ( (LA13_1==PIPE) ) {
					alt13=1;
				}
				else if ( (LA13_1==BLOCK_OPEN||(LA13_1 >= COLON && LA13_1 <= COMMA)||(LA13_1 >= DOT && LA13_1 <= DOUBLE_COLON)||LA13_1==HASH_WORD||LA13_1==ID||LA13_1==NUMBER_WITH_PERCENT||(LA13_1 >= SQUARE_OPEN && LA13_1 <= STAR)||LA13_1==TILDE||(LA13_1 >= 69 && LA13_1 <= 70)) ) {
					alt13=3;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 13, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case NUMBER_WITH_PERCENT:
				{
				alt13=2;
				}
				break;
			case STAR:
				{
				alt13=4;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 13, 0, input);
				throw nvae;
			}
			switch (alt13) {
				case 1 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:351:9: ID PIPE ^ ID
					{
					root_0 = (Object)adaptor.nil();


					ID57=(Token)match(input,ID,FOLLOW_ID_in_element944); 
					ID57_tree = (Object)adaptor.create(ID57);
					adaptor.addChild(root_0, ID57_tree);

					PIPE58=(Token)match(input,PIPE,FOLLOW_PIPE_in_element946); 
					PIPE58_tree = (Object)adaptor.create(PIPE58);
					root_0 = (Object)adaptor.becomeRoot(PIPE58_tree, root_0);

					ID59=(Token)match(input,ID,FOLLOW_ID_in_element949); 
					ID59_tree = (Object)adaptor.create(ID59);
					adaptor.addChild(root_0, ID59_tree);

					}
					break;
				case 2 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:352:9: NUMBER_WITH_PERCENT
					{
					root_0 = (Object)adaptor.nil();


					NUMBER_WITH_PERCENT60=(Token)match(input,NUMBER_WITH_PERCENT,FOLLOW_NUMBER_WITH_PERCENT_in_element959); 
					NUMBER_WITH_PERCENT60_tree = (Object)adaptor.create(NUMBER_WITH_PERCENT60);
					adaptor.addChild(root_0, NUMBER_WITH_PERCENT60_tree);

					}
					break;
				case 3 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:353:9: ID
					{
					root_0 = (Object)adaptor.nil();


					ID61=(Token)match(input,ID,FOLLOW_ID_in_element981); 
					ID61_tree = (Object)adaptor.create(ID61);
					adaptor.addChild(root_0, ID61_tree);

					}
					break;
				case 4 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:354:9: STAR
					{
					root_0 = (Object)adaptor.nil();


					STAR62=(Token)match(input,STAR,FOLLOW_STAR_in_element1001); 
					STAR62_tree = (Object)adaptor.create(STAR62);
					adaptor.addChild(root_0, STAR62_tree);

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (Object)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "element"


	public static class declarationsBlock_return extends ParserRuleReturnScope {
		Object tree;
		@Override
		public Object getTree() { return tree; }
	};


	// $ANTLR start "declarationsBlock"
	// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:362:1: declarationsBlock : BLOCK_OPEN ( ( SEMI_COLONS )? declaration ( SEMI_COLONS declaration )* ( SEMI_COLONS )? )? BLOCK_END -> ^( I_DECL ( declaration )* ) ;
	public final CSSParser.declarationsBlock_return declarationsBlock() throws RecognitionException {
		CSSParser.declarationsBlock_return retval = new CSSParser.declarationsBlock_return();
		retval.start = input.LT(1);

		Object root_0 = null;

		Token BLOCK_OPEN63=null;
		Token SEMI_COLONS64=null;
		Token SEMI_COLONS66=null;
		Token SEMI_COLONS68=null;
		Token BLOCK_END69=null;
		ParserRuleReturnScope declaration65 =null;
		ParserRuleReturnScope declaration67 =null;

		Object BLOCK_OPEN63_tree=null;
		Object SEMI_COLONS64_tree=null;
		Object SEMI_COLONS66_tree=null;
		Object SEMI_COLONS68_tree=null;
		Object BLOCK_END69_tree=null;
		RewriteRuleTokenStream stream_BLOCK_OPEN=new RewriteRuleTokenStream(adaptor,"token BLOCK_OPEN");
		RewriteRuleTokenStream stream_SEMI_COLONS=new RewriteRuleTokenStream(adaptor,"token SEMI_COLONS");
		RewriteRuleTokenStream stream_BLOCK_END=new RewriteRuleTokenStream(adaptor,"token BLOCK_END");
		RewriteRuleSubtreeStream stream_declaration=new RewriteRuleSubtreeStream(adaptor,"rule declaration");

		try {
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:363:5: ( BLOCK_OPEN ( ( SEMI_COLONS )? declaration ( SEMI_COLONS declaration )* ( SEMI_COLONS )? )? BLOCK_END -> ^( I_DECL ( declaration )* ) )
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:363:9: BLOCK_OPEN ( ( SEMI_COLONS )? declaration ( SEMI_COLONS declaration )* ( SEMI_COLONS )? )? BLOCK_END
			{
			BLOCK_OPEN63=(Token)match(input,BLOCK_OPEN,FOLLOW_BLOCK_OPEN_in_declarationsBlock1030);  
			stream_BLOCK_OPEN.add(BLOCK_OPEN63);

			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:364:9: ( ( SEMI_COLONS )? declaration ( SEMI_COLONS declaration )* ( SEMI_COLONS )? )?
			int alt17=2;
			int LA17_0 = input.LA(1);
			if ( (LA17_0==ID||LA17_0==SEMI_COLONS) ) {
				alt17=1;
			}
			switch (alt17) {
				case 1 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:365:13: ( SEMI_COLONS )? declaration ( SEMI_COLONS declaration )* ( SEMI_COLONS )?
					{
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:365:13: ( SEMI_COLONS )?
					int alt14=2;
					int LA14_0 = input.LA(1);
					if ( (LA14_0==SEMI_COLONS) ) {
						alt14=1;
					}
					switch (alt14) {
						case 1 :
							// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:365:13: SEMI_COLONS
							{
							SEMI_COLONS64=(Token)match(input,SEMI_COLONS,FOLLOW_SEMI_COLONS_in_declarationsBlock1058);  
							stream_SEMI_COLONS.add(SEMI_COLONS64);

							}
							break;

					}

					pushFollow(FOLLOW_declaration_in_declarationsBlock1076);
					declaration65=declaration();
					state._fsp--;

					stream_declaration.add(declaration65.getTree());
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:367:13: ( SEMI_COLONS declaration )*
					loop15:
					while (true) {
						int alt15=2;
						int LA15_0 = input.LA(1);
						if ( (LA15_0==SEMI_COLONS) ) {
							int LA15_1 = input.LA(2);
							if ( (LA15_1==ID) ) {
								alt15=1;
							}

						}

						switch (alt15) {
						case 1 :
							// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:368:17: SEMI_COLONS declaration
							{
							SEMI_COLONS66=(Token)match(input,SEMI_COLONS,FOLLOW_SEMI_COLONS_in_declarationsBlock1110);  
							stream_SEMI_COLONS.add(SEMI_COLONS66);

							pushFollow(FOLLOW_declaration_in_declarationsBlock1129);
							declaration67=declaration();
							state._fsp--;

							stream_declaration.add(declaration67.getTree());
							}
							break;

						default :
							break loop15;
						}
					}

					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:371:13: ( SEMI_COLONS )?
					int alt16=2;
					int LA16_0 = input.LA(1);
					if ( (LA16_0==SEMI_COLONS) ) {
						alt16=1;
					}
					switch (alt16) {
						case 1 :
							// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:371:13: SEMI_COLONS
							{
							SEMI_COLONS68=(Token)match(input,SEMI_COLONS,FOLLOW_SEMI_COLONS_in_declarationsBlock1159);  
							stream_SEMI_COLONS.add(SEMI_COLONS68);

							}
							break;

					}

					}
					break;

			}

			BLOCK_END69=(Token)match(input,BLOCK_END,FOLLOW_BLOCK_END_in_declarationsBlock1182);  
			stream_BLOCK_END.add(BLOCK_END69);

			// AST REWRITE
			// elements: declaration
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (Object)adaptor.nil();
			// 374:9: -> ^( I_DECL ( declaration )* )
			{
				// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:374:12: ^( I_DECL ( declaration )* )
				{
				Object root_1 = (Object)adaptor.nil();
				root_1 = (Object)adaptor.becomeRoot((Object)adaptor.create(I_DECL, "I_DECL"), root_1);
				// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:374:21: ( declaration )*
				while ( stream_declaration.hasNext() ) {
					adaptor.addChild(root_1, stream_declaration.nextTree());
				}
				stream_declaration.reset();

				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (Object)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "declarationsBlock"


	public static class declaration_return extends ParserRuleReturnScope {
		Object tree;
		@Override
		public Object getTree() { return tree; }
	};


	// $ANTLR start "declaration"
	// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:382:1: declaration : ID COLON value -> ^( COLON ID value ) ;
	public final CSSParser.declaration_return declaration() throws RecognitionException {
		CSSParser.declaration_return retval = new CSSParser.declaration_return();
		retval.start = input.LT(1);

		Object root_0 = null;

		Token ID70=null;
		Token COLON71=null;
		ParserRuleReturnScope value72 =null;

		Object ID70_tree=null;
		Object COLON71_tree=null;
		RewriteRuleTokenStream stream_COLON=new RewriteRuleTokenStream(adaptor,"token COLON");
		RewriteRuleTokenStream stream_ID=new RewriteRuleTokenStream(adaptor,"token ID");
		RewriteRuleSubtreeStream stream_value=new RewriteRuleSubtreeStream(adaptor,"rule value");

		try {
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:383:5: ( ID COLON value -> ^( COLON ID value ) )
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:383:9: ID COLON value
			{
			ID70=(Token)match(input,ID,FOLLOW_ID_in_declaration1222);  
			stream_ID.add(ID70);

			COLON71=(Token)match(input,COLON,FOLLOW_COLON_in_declaration1224);  
			stream_COLON.add(COLON71);

			pushFollow(FOLLOW_value_in_declaration1226);
			value72=value();
			state._fsp--;

			stream_value.add(value72.getTree());
			// AST REWRITE
			// elements: COLON, ID, value
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (Object)adaptor.nil();
			// 383:24: -> ^( COLON ID value )
			{
				// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:383:27: ^( COLON ID value )
				{
				Object root_1 = (Object)adaptor.nil();
				root_1 = (Object)adaptor.becomeRoot(stream_COLON.nextNode(), root_1);
				adaptor.addChild(root_1, stream_ID.nextNode());
				adaptor.addChild(root_1, stream_value.nextTree());
				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (Object)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "declaration"


	public static class value_return extends ParserRuleReturnScope {
		Object tree;
		@Override
		public Object getTree() { return tree; }
	};


	// $ANTLR start "value"
	// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:399:1: value : singleValue ( ( COMMA )? singleValue )* -> {count > 1}? ^( I_ARRAY ( singleValue )+ ) -> singleValue ;
	public final CSSParser.value_return value() throws RecognitionException {
		CSSParser.value_return retval = new CSSParser.value_return();
		retval.start = input.LT(1);

		Object root_0 = null;

		Token COMMA74=null;
		ParserRuleReturnScope singleValue73 =null;
		ParserRuleReturnScope singleValue75 =null;

		Object COMMA74_tree=null;
		RewriteRuleTokenStream stream_COMMA=new RewriteRuleTokenStream(adaptor,"token COMMA");
		RewriteRuleSubtreeStream stream_singleValue=new RewriteRuleSubtreeStream(adaptor,"rule singleValue");

		 int count = 1; 
		try {
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:401:5: ( singleValue ( ( COMMA )? singleValue )* -> {count > 1}? ^( I_ARRAY ( singleValue )+ ) -> singleValue )
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:401:9: singleValue ( ( COMMA )? singleValue )*
			{
			pushFollow(FOLLOW_singleValue_in_value1272);
			singleValue73=singleValue();
			state._fsp--;

			stream_singleValue.add(singleValue73.getTree());
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:401:21: ( ( COMMA )? singleValue )*
			loop19:
			while (true) {
				int alt19=2;
				int LA19_0 = input.LA(1);
				if ( (LA19_0==ALPHA_VALUE||LA19_0==CLASS_REFERENCE||LA19_0==COMMA||LA19_0==EMBED||LA19_0==HASH_WORD||(LA19_0 >= ID && LA19_0 <= IMPORTANT)||LA19_0==LOCAL||(LA19_0 >= NUMBER_WITH_PERCENT && LA19_0 <= NUMBER_WITH_UNIT)||LA19_0==OPERATOR||(LA19_0 >= PROPERTY_REFERENCE && LA19_0 <= ROTATE_VALUE)||LA19_0==SCALE_VALUE||LA19_0==STRING||(LA19_0 >= TRANSLATE3D_VALUE && LA19_0 <= URL)) ) {
					alt19=1;
				}

				switch (alt19) {
				case 1 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:401:23: ( COMMA )? singleValue
					{
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:401:23: ( COMMA )?
					int alt18=2;
					int LA18_0 = input.LA(1);
					if ( (LA18_0==COMMA) ) {
						alt18=1;
					}
					switch (alt18) {
						case 1 :
							// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:401:23: COMMA
							{
							COMMA74=(Token)match(input,COMMA,FOLLOW_COMMA_in_value1276);  
							stream_COMMA.add(COMMA74);

							}
							break;

					}

					pushFollow(FOLLOW_singleValue_in_value1279);
					singleValue75=singleValue();
					state._fsp--;

					stream_singleValue.add(singleValue75.getTree());
					 count++; 
					}
					break;

				default :
					break loop19;
				}
			}

			// AST REWRITE
			// elements: singleValue, singleValue
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (Object)adaptor.nil();
			// 402:9: -> {count > 1}? ^( I_ARRAY ( singleValue )+ )
			if (count > 1) {
				// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:402:25: ^( I_ARRAY ( singleValue )+ )
				{
				Object root_1 = (Object)adaptor.nil();
				root_1 = (Object)adaptor.becomeRoot((Object)adaptor.create(I_ARRAY, "I_ARRAY"), root_1);
				if ( !(stream_singleValue.hasNext()) ) {
					throw new RewriteEarlyExitException();
				}
				while ( stream_singleValue.hasNext() ) {
					adaptor.addChild(root_1, stream_singleValue.nextTree());
				}
				stream_singleValue.reset();

				adaptor.addChild(root_0, root_1);
				}

			}

			else // 403:9: -> singleValue
			{
				adaptor.addChild(root_0, stream_singleValue.nextTree());
			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (Object)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "value"


	public static class singleValue_return extends ParserRuleReturnScope {
		Object tree;
		@Override
		public Object getTree() { return tree; }
	};


	// $ANTLR start "singleValue"
	// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:421:1: singleValue : ( NUMBER_WITH_PERCENT | NUMBER_WITH_UNIT | HASH_WORD | CLASS_REFERENCE ARGUMENTS -> ^( CLASS_REFERENCE ARGUMENTS ) | PROPERTY_REFERENCE ARGUMENTS -> ^( PROPERTY_REFERENCE ARGUMENTS ) | EMBED ARGUMENTS -> ^( EMBED ARGUMENTS ) | URL ARGUMENTS ( formatOption )* -> ^( URL ARGUMENTS ( formatOption )* ) | LOCAL ARGUMENTS -> ^( LOCAL ARGUMENTS ) | ALPHA_VALUE | SCALE_VALUE | RECT_VALUE | ROTATE_VALUE | TRANSLATE3D_VALUE | RGB | RGBA | STRING | ID | OPERATOR | IMPORTANT );
	public final CSSParser.singleValue_return singleValue() throws RecognitionException {
		CSSParser.singleValue_return retval = new CSSParser.singleValue_return();
		retval.start = input.LT(1);

		Object root_0 = null;

		Token NUMBER_WITH_PERCENT76=null;
		Token NUMBER_WITH_UNIT77=null;
		Token HASH_WORD78=null;
		Token CLASS_REFERENCE79=null;
		Token ARGUMENTS80=null;
		Token PROPERTY_REFERENCE81=null;
		Token ARGUMENTS82=null;
		Token EMBED83=null;
		Token ARGUMENTS84=null;
		Token URL85=null;
		Token ARGUMENTS86=null;
		Token LOCAL88=null;
		Token ARGUMENTS89=null;
		Token ALPHA_VALUE90=null;
		Token SCALE_VALUE91=null;
		Token RECT_VALUE92=null;
		Token ROTATE_VALUE93=null;
		Token TRANSLATE3D_VALUE94=null;
		Token RGB95=null;
		Token RGBA96=null;
		Token STRING97=null;
		Token ID98=null;
		Token OPERATOR99=null;
		Token IMPORTANT100=null;
		ParserRuleReturnScope formatOption87 =null;

		Object NUMBER_WITH_PERCENT76_tree=null;
		Object NUMBER_WITH_UNIT77_tree=null;
		Object HASH_WORD78_tree=null;
		Object CLASS_REFERENCE79_tree=null;
		Object ARGUMENTS80_tree=null;
		Object PROPERTY_REFERENCE81_tree=null;
		Object ARGUMENTS82_tree=null;
		Object EMBED83_tree=null;
		Object ARGUMENTS84_tree=null;
		Object URL85_tree=null;
		Object ARGUMENTS86_tree=null;
		Object LOCAL88_tree=null;
		Object ARGUMENTS89_tree=null;
		Object ALPHA_VALUE90_tree=null;
		Object SCALE_VALUE91_tree=null;
		Object RECT_VALUE92_tree=null;
		Object ROTATE_VALUE93_tree=null;
		Object TRANSLATE3D_VALUE94_tree=null;
		Object RGB95_tree=null;
		Object RGBA96_tree=null;
		Object STRING97_tree=null;
		Object ID98_tree=null;
		Object OPERATOR99_tree=null;
		Object IMPORTANT100_tree=null;
		RewriteRuleTokenStream stream_ARGUMENTS=new RewriteRuleTokenStream(adaptor,"token ARGUMENTS");
		RewriteRuleTokenStream stream_LOCAL=new RewriteRuleTokenStream(adaptor,"token LOCAL");
		RewriteRuleTokenStream stream_EMBED=new RewriteRuleTokenStream(adaptor,"token EMBED");
		RewriteRuleTokenStream stream_CLASS_REFERENCE=new RewriteRuleTokenStream(adaptor,"token CLASS_REFERENCE");
		RewriteRuleTokenStream stream_URL=new RewriteRuleTokenStream(adaptor,"token URL");
		RewriteRuleTokenStream stream_PROPERTY_REFERENCE=new RewriteRuleTokenStream(adaptor,"token PROPERTY_REFERENCE");
		RewriteRuleSubtreeStream stream_formatOption=new RewriteRuleSubtreeStream(adaptor,"rule formatOption");

		try {
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:422:5: ( NUMBER_WITH_PERCENT | NUMBER_WITH_UNIT | HASH_WORD | CLASS_REFERENCE ARGUMENTS -> ^( CLASS_REFERENCE ARGUMENTS ) | PROPERTY_REFERENCE ARGUMENTS -> ^( PROPERTY_REFERENCE ARGUMENTS ) | EMBED ARGUMENTS -> ^( EMBED ARGUMENTS ) | URL ARGUMENTS ( formatOption )* -> ^( URL ARGUMENTS ( formatOption )* ) | LOCAL ARGUMENTS -> ^( LOCAL ARGUMENTS ) | ALPHA_VALUE | SCALE_VALUE | RECT_VALUE | ROTATE_VALUE | TRANSLATE3D_VALUE | RGB | RGBA | STRING | ID | OPERATOR | IMPORTANT )
			int alt21=19;
			switch ( input.LA(1) ) {
			case NUMBER_WITH_PERCENT:
				{
				alt21=1;
				}
				break;
			case NUMBER_WITH_UNIT:
				{
				alt21=2;
				}
				break;
			case HASH_WORD:
				{
				alt21=3;
				}
				break;
			case CLASS_REFERENCE:
				{
				alt21=4;
				}
				break;
			case PROPERTY_REFERENCE:
				{
				alt21=5;
				}
				break;
			case EMBED:
				{
				alt21=6;
				}
				break;
			case URL:
				{
				alt21=7;
				}
				break;
			case LOCAL:
				{
				alt21=8;
				}
				break;
			case ALPHA_VALUE:
				{
				alt21=9;
				}
				break;
			case SCALE_VALUE:
				{
				alt21=10;
				}
				break;
			case RECT_VALUE:
				{
				alt21=11;
				}
				break;
			case ROTATE_VALUE:
				{
				alt21=12;
				}
				break;
			case TRANSLATE3D_VALUE:
				{
				alt21=13;
				}
				break;
			case RGB:
				{
				alt21=14;
				}
				break;
			case RGBA:
				{
				alt21=15;
				}
				break;
			case STRING:
				{
				alt21=16;
				}
				break;
			case ID:
				{
				alt21=17;
				}
				break;
			case OPERATOR:
				{
				alt21=18;
				}
				break;
			case IMPORTANT:
				{
				alt21=19;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 21, 0, input);
				throw nvae;
			}
			switch (alt21) {
				case 1 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:422:9: NUMBER_WITH_PERCENT
					{
					root_0 = (Object)adaptor.nil();


					NUMBER_WITH_PERCENT76=(Token)match(input,NUMBER_WITH_PERCENT,FOLLOW_NUMBER_WITH_PERCENT_in_singleValue1353); 
					NUMBER_WITH_PERCENT76_tree = (Object)adaptor.create(NUMBER_WITH_PERCENT76);
					adaptor.addChild(root_0, NUMBER_WITH_PERCENT76_tree);

					}
					break;
				case 2 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:423:9: NUMBER_WITH_UNIT
					{
					root_0 = (Object)adaptor.nil();


					NUMBER_WITH_UNIT77=(Token)match(input,NUMBER_WITH_UNIT,FOLLOW_NUMBER_WITH_UNIT_in_singleValue1363); 
					NUMBER_WITH_UNIT77_tree = (Object)adaptor.create(NUMBER_WITH_UNIT77);
					adaptor.addChild(root_0, NUMBER_WITH_UNIT77_tree);

					}
					break;
				case 3 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:424:9: HASH_WORD
					{
					root_0 = (Object)adaptor.nil();


					HASH_WORD78=(Token)match(input,HASH_WORD,FOLLOW_HASH_WORD_in_singleValue1373); 
					HASH_WORD78_tree = (Object)adaptor.create(HASH_WORD78);
					adaptor.addChild(root_0, HASH_WORD78_tree);

					}
					break;
				case 4 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:425:9: CLASS_REFERENCE ARGUMENTS
					{
					CLASS_REFERENCE79=(Token)match(input,CLASS_REFERENCE,FOLLOW_CLASS_REFERENCE_in_singleValue1383);  
					stream_CLASS_REFERENCE.add(CLASS_REFERENCE79);

					ARGUMENTS80=(Token)match(input,ARGUMENTS,FOLLOW_ARGUMENTS_in_singleValue1385);  
					stream_ARGUMENTS.add(ARGUMENTS80);

					// AST REWRITE
					// elements: CLASS_REFERENCE, ARGUMENTS
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 426:13: -> ^( CLASS_REFERENCE ARGUMENTS )
					{
						// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:426:16: ^( CLASS_REFERENCE ARGUMENTS )
						{
						Object root_1 = (Object)adaptor.nil();
						root_1 = (Object)adaptor.becomeRoot(stream_CLASS_REFERENCE.nextNode(), root_1);
						adaptor.addChild(root_1, stream_ARGUMENTS.nextNode());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 5 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:427:9: PROPERTY_REFERENCE ARGUMENTS
					{
					PROPERTY_REFERENCE81=(Token)match(input,PROPERTY_REFERENCE,FOLLOW_PROPERTY_REFERENCE_in_singleValue1415);  
					stream_PROPERTY_REFERENCE.add(PROPERTY_REFERENCE81);

					ARGUMENTS82=(Token)match(input,ARGUMENTS,FOLLOW_ARGUMENTS_in_singleValue1417);  
					stream_ARGUMENTS.add(ARGUMENTS82);

					// AST REWRITE
					// elements: ARGUMENTS, PROPERTY_REFERENCE
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 428:13: -> ^( PROPERTY_REFERENCE ARGUMENTS )
					{
						// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:428:16: ^( PROPERTY_REFERENCE ARGUMENTS )
						{
						Object root_1 = (Object)adaptor.nil();
						root_1 = (Object)adaptor.becomeRoot(stream_PROPERTY_REFERENCE.nextNode(), root_1);
						adaptor.addChild(root_1, stream_ARGUMENTS.nextNode());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 6 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:429:9: EMBED ARGUMENTS
					{
					EMBED83=(Token)match(input,EMBED,FOLLOW_EMBED_in_singleValue1447);  
					stream_EMBED.add(EMBED83);

					ARGUMENTS84=(Token)match(input,ARGUMENTS,FOLLOW_ARGUMENTS_in_singleValue1449);  
					stream_ARGUMENTS.add(ARGUMENTS84);

					// AST REWRITE
					// elements: ARGUMENTS, EMBED
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 430:13: -> ^( EMBED ARGUMENTS )
					{
						// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:430:16: ^( EMBED ARGUMENTS )
						{
						Object root_1 = (Object)adaptor.nil();
						root_1 = (Object)adaptor.becomeRoot(stream_EMBED.nextNode(), root_1);
						adaptor.addChild(root_1, stream_ARGUMENTS.nextNode());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 7 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:431:9: URL ARGUMENTS ( formatOption )*
					{
					URL85=(Token)match(input,URL,FOLLOW_URL_in_singleValue1479);  
					stream_URL.add(URL85);

					ARGUMENTS86=(Token)match(input,ARGUMENTS,FOLLOW_ARGUMENTS_in_singleValue1481);  
					stream_ARGUMENTS.add(ARGUMENTS86);

					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:431:23: ( formatOption )*
					loop20:
					while (true) {
						int alt20=2;
						int LA20_0 = input.LA(1);
						if ( (LA20_0==FORMAT) ) {
							alt20=1;
						}

						switch (alt20) {
						case 1 :
							// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:431:23: formatOption
							{
							pushFollow(FOLLOW_formatOption_in_singleValue1483);
							formatOption87=formatOption();
							state._fsp--;

							stream_formatOption.add(formatOption87.getTree());
							}
							break;

						default :
							break loop20;
						}
					}

					// AST REWRITE
					// elements: formatOption, ARGUMENTS, URL
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 431:39: -> ^( URL ARGUMENTS ( formatOption )* )
					{
						// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:431:42: ^( URL ARGUMENTS ( formatOption )* )
						{
						Object root_1 = (Object)adaptor.nil();
						root_1 = (Object)adaptor.becomeRoot(stream_URL.nextNode(), root_1);
						adaptor.addChild(root_1, stream_ARGUMENTS.nextNode());
						// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:431:58: ( formatOption )*
						while ( stream_formatOption.hasNext() ) {
							adaptor.addChild(root_1, stream_formatOption.nextTree());
						}
						stream_formatOption.reset();

						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 8 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:432:9: LOCAL ARGUMENTS
					{
					LOCAL88=(Token)match(input,LOCAL,FOLLOW_LOCAL_in_singleValue1507);  
					stream_LOCAL.add(LOCAL88);

					ARGUMENTS89=(Token)match(input,ARGUMENTS,FOLLOW_ARGUMENTS_in_singleValue1509);  
					stream_ARGUMENTS.add(ARGUMENTS89);

					// AST REWRITE
					// elements: ARGUMENTS, LOCAL
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (Object)adaptor.nil();
					// 432:34: -> ^( LOCAL ARGUMENTS )
					{
						// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:432:37: ^( LOCAL ARGUMENTS )
						{
						Object root_1 = (Object)adaptor.nil();
						root_1 = (Object)adaptor.becomeRoot(stream_LOCAL.nextNode(), root_1);
						adaptor.addChild(root_1, stream_ARGUMENTS.nextNode());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 9 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:433:9: ALPHA_VALUE
					{
					root_0 = (Object)adaptor.nil();


					ALPHA_VALUE90=(Token)match(input,ALPHA_VALUE,FOLLOW_ALPHA_VALUE_in_singleValue1536); 
					ALPHA_VALUE90_tree = (Object)adaptor.create(ALPHA_VALUE90);
					adaptor.addChild(root_0, ALPHA_VALUE90_tree);

					}
					break;
				case 10 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:434:9: SCALE_VALUE
					{
					root_0 = (Object)adaptor.nil();


					SCALE_VALUE91=(Token)match(input,SCALE_VALUE,FOLLOW_SCALE_VALUE_in_singleValue1546); 
					SCALE_VALUE91_tree = (Object)adaptor.create(SCALE_VALUE91);
					adaptor.addChild(root_0, SCALE_VALUE91_tree);

					}
					break;
				case 11 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:435:9: RECT_VALUE
					{
					root_0 = (Object)adaptor.nil();


					RECT_VALUE92=(Token)match(input,RECT_VALUE,FOLLOW_RECT_VALUE_in_singleValue1556); 
					RECT_VALUE92_tree = (Object)adaptor.create(RECT_VALUE92);
					adaptor.addChild(root_0, RECT_VALUE92_tree);

					}
					break;
				case 12 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:436:9: ROTATE_VALUE
					{
					root_0 = (Object)adaptor.nil();


					ROTATE_VALUE93=(Token)match(input,ROTATE_VALUE,FOLLOW_ROTATE_VALUE_in_singleValue1566); 
					ROTATE_VALUE93_tree = (Object)adaptor.create(ROTATE_VALUE93);
					adaptor.addChild(root_0, ROTATE_VALUE93_tree);

					}
					break;
				case 13 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:437:9: TRANSLATE3D_VALUE
					{
					root_0 = (Object)adaptor.nil();


					TRANSLATE3D_VALUE94=(Token)match(input,TRANSLATE3D_VALUE,FOLLOW_TRANSLATE3D_VALUE_in_singleValue1576); 
					TRANSLATE3D_VALUE94_tree = (Object)adaptor.create(TRANSLATE3D_VALUE94);
					adaptor.addChild(root_0, TRANSLATE3D_VALUE94_tree);

					}
					break;
				case 14 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:438:9: RGB
					{
					root_0 = (Object)adaptor.nil();


					RGB95=(Token)match(input,RGB,FOLLOW_RGB_in_singleValue1586); 
					RGB95_tree = (Object)adaptor.create(RGB95);
					adaptor.addChild(root_0, RGB95_tree);

					}
					break;
				case 15 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:439:9: RGBA
					{
					root_0 = (Object)adaptor.nil();


					RGBA96=(Token)match(input,RGBA,FOLLOW_RGBA_in_singleValue1596); 
					RGBA96_tree = (Object)adaptor.create(RGBA96);
					adaptor.addChild(root_0, RGBA96_tree);

					}
					break;
				case 16 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:440:9: STRING
					{
					root_0 = (Object)adaptor.nil();


					STRING97=(Token)match(input,STRING,FOLLOW_STRING_in_singleValue1606); 
					STRING97_tree = (Object)adaptor.create(STRING97);
					adaptor.addChild(root_0, STRING97_tree);

					}
					break;
				case 17 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:441:9: ID
					{
					root_0 = (Object)adaptor.nil();


					ID98=(Token)match(input,ID,FOLLOW_ID_in_singleValue1622); 
					ID98_tree = (Object)adaptor.create(ID98);
					adaptor.addChild(root_0, ID98_tree);

					}
					break;
				case 18 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:442:9: OPERATOR
					{
					root_0 = (Object)adaptor.nil();


					OPERATOR99=(Token)match(input,OPERATOR,FOLLOW_OPERATOR_in_singleValue1632); 
					OPERATOR99_tree = (Object)adaptor.create(OPERATOR99);
					adaptor.addChild(root_0, OPERATOR99_tree);

					}
					break;
				case 19 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:443:9: IMPORTANT
					{
					root_0 = (Object)adaptor.nil();


					IMPORTANT100=(Token)match(input,IMPORTANT,FOLLOW_IMPORTANT_in_singleValue1642); 
					IMPORTANT100_tree = (Object)adaptor.create(IMPORTANT100);
					adaptor.addChild(root_0, IMPORTANT100_tree);

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (Object)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "singleValue"


	public static class formatOption_return extends ParserRuleReturnScope {
		Object tree;
		@Override
		public Object getTree() { return tree; }
	};


	// $ANTLR start "formatOption"
	// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:446:1: formatOption : FORMAT ARGUMENTS -> ^( FORMAT ARGUMENTS ) ;
	public final CSSParser.formatOption_return formatOption() throws RecognitionException {
		CSSParser.formatOption_return retval = new CSSParser.formatOption_return();
		retval.start = input.LT(1);

		Object root_0 = null;

		Token FORMAT101=null;
		Token ARGUMENTS102=null;

		Object FORMAT101_tree=null;
		Object ARGUMENTS102_tree=null;
		RewriteRuleTokenStream stream_FORMAT=new RewriteRuleTokenStream(adaptor,"token FORMAT");
		RewriteRuleTokenStream stream_ARGUMENTS=new RewriteRuleTokenStream(adaptor,"token ARGUMENTS");

		try {
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:447:5: ( FORMAT ARGUMENTS -> ^( FORMAT ARGUMENTS ) )
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:447:9: FORMAT ARGUMENTS
			{
			FORMAT101=(Token)match(input,FORMAT,FOLLOW_FORMAT_in_formatOption1662);  
			stream_FORMAT.add(FORMAT101);

			ARGUMENTS102=(Token)match(input,ARGUMENTS,FOLLOW_ARGUMENTS_in_formatOption1664);  
			stream_ARGUMENTS.add(ARGUMENTS102);

			// AST REWRITE
			// elements: FORMAT, ARGUMENTS
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (Object)adaptor.nil();
			// 447:26: -> ^( FORMAT ARGUMENTS )
			{
				// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:447:29: ^( FORMAT ARGUMENTS )
				{
				Object root_1 = (Object)adaptor.nil();
				root_1 = (Object)adaptor.becomeRoot(stream_FORMAT.nextNode(), root_1);
				adaptor.addChild(root_1, stream_ARGUMENTS.nextNode());
				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (Object)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "formatOption"


	public static class childSelector_return extends ParserRuleReturnScope {
		Object tree;
		@Override
		public Object getTree() { return tree; }
	};


	// $ANTLR start "childSelector"
	// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:450:1: childSelector : '>' simpleSelectorFraction ;
	public final CSSParser.childSelector_return childSelector() throws RecognitionException {
		CSSParser.childSelector_return retval = new CSSParser.childSelector_return();
		retval.start = input.LT(1);

		Object root_0 = null;

		Token char_literal103=null;
		ParserRuleReturnScope simpleSelectorFraction104 =null;

		Object char_literal103_tree=null;

		try {
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:451:5: ( '>' simpleSelectorFraction )
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:451:9: '>' simpleSelectorFraction
			{
			root_0 = (Object)adaptor.nil();


			char_literal103=(Token)match(input,70,FOLLOW_70_in_childSelector1688); 
			char_literal103_tree = (Object)adaptor.create(char_literal103);
			adaptor.addChild(root_0, char_literal103_tree);

			pushFollow(FOLLOW_simpleSelectorFraction_in_childSelector1690);
			simpleSelectorFraction104=simpleSelectorFraction();
			state._fsp--;

			adaptor.addChild(root_0, simpleSelectorFraction104.getTree());

			}

			retval.stop = input.LT(-1);

			retval.tree = (Object)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "childSelector"


	public static class precededSelector_return extends ParserRuleReturnScope {
		Object tree;
		@Override
		public Object getTree() { return tree; }
	};


	// $ANTLR start "precededSelector"
	// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:454:1: precededSelector : TILDE simpleSelectorFraction ;
	public final CSSParser.precededSelector_return precededSelector() throws RecognitionException {
		CSSParser.precededSelector_return retval = new CSSParser.precededSelector_return();
		retval.start = input.LT(1);

		Object root_0 = null;

		Token TILDE105=null;
		ParserRuleReturnScope simpleSelectorFraction106 =null;

		Object TILDE105_tree=null;

		try {
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:455:5: ( TILDE simpleSelectorFraction )
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:455:9: TILDE simpleSelectorFraction
			{
			root_0 = (Object)adaptor.nil();


			TILDE105=(Token)match(input,TILDE,FOLLOW_TILDE_in_precededSelector1713); 
			TILDE105_tree = (Object)adaptor.create(TILDE105);
			adaptor.addChild(root_0, TILDE105_tree);

			pushFollow(FOLLOW_simpleSelectorFraction_in_precededSelector1715);
			simpleSelectorFraction106=simpleSelectorFraction();
			state._fsp--;

			adaptor.addChild(root_0, simpleSelectorFraction106.getTree());

			}

			retval.stop = input.LT(-1);

			retval.tree = (Object)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "precededSelector"


	public static class siblingSelector_return extends ParserRuleReturnScope {
		Object tree;
		@Override
		public Object getTree() { return tree; }
	};


	// $ANTLR start "siblingSelector"
	// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:458:1: siblingSelector : '+' simpleSelectorFraction ;
	public final CSSParser.siblingSelector_return siblingSelector() throws RecognitionException {
		CSSParser.siblingSelector_return retval = new CSSParser.siblingSelector_return();
		retval.start = input.LT(1);

		Object root_0 = null;

		Token char_literal107=null;
		ParserRuleReturnScope simpleSelectorFraction108 =null;

		Object char_literal107_tree=null;

		try {
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:459:5: ( '+' simpleSelectorFraction )
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:459:9: '+' simpleSelectorFraction
			{
			root_0 = (Object)adaptor.nil();


			char_literal107=(Token)match(input,69,FOLLOW_69_in_siblingSelector1738); 
			char_literal107_tree = (Object)adaptor.create(char_literal107);
			adaptor.addChild(root_0, char_literal107_tree);

			pushFollow(FOLLOW_simpleSelectorFraction_in_siblingSelector1740);
			simpleSelectorFraction108=simpleSelectorFraction();
			state._fsp--;

			adaptor.addChild(root_0, simpleSelectorFraction108.getTree());

			}

			retval.stop = input.LT(-1);

			retval.tree = (Object)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "siblingSelector"


	public static class attributeSelector_return extends ParserRuleReturnScope {
		Object tree;
		@Override
		public Object getTree() { return tree; }
	};


	// $ANTLR start "attributeSelector"
	// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:462:1: attributeSelector : SQUARE_OPEN attributeName ( attributeOperator )* ( attributeValue )* SQUARE_END ;
	public final CSSParser.attributeSelector_return attributeSelector() throws RecognitionException {
		CSSParser.attributeSelector_return retval = new CSSParser.attributeSelector_return();
		retval.start = input.LT(1);

		Object root_0 = null;

		Token SQUARE_OPEN109=null;
		Token SQUARE_END113=null;
		ParserRuleReturnScope attributeName110 =null;
		ParserRuleReturnScope attributeOperator111 =null;
		ParserRuleReturnScope attributeValue112 =null;

		Object SQUARE_OPEN109_tree=null;
		Object SQUARE_END113_tree=null;

		try {
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:463:5: ( SQUARE_OPEN attributeName ( attributeOperator )* ( attributeValue )* SQUARE_END )
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:463:9: SQUARE_OPEN attributeName ( attributeOperator )* ( attributeValue )* SQUARE_END
			{
			root_0 = (Object)adaptor.nil();


			SQUARE_OPEN109=(Token)match(input,SQUARE_OPEN,FOLLOW_SQUARE_OPEN_in_attributeSelector1763); 
			SQUARE_OPEN109_tree = (Object)adaptor.create(SQUARE_OPEN109);
			adaptor.addChild(root_0, SQUARE_OPEN109_tree);

			pushFollow(FOLLOW_attributeName_in_attributeSelector1765);
			attributeName110=attributeName();
			state._fsp--;

			adaptor.addChild(root_0, attributeName110.getTree());

			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:463:35: ( attributeOperator )*
			loop22:
			while (true) {
				int alt22=2;
				int LA22_0 = input.LA(1);
				if ( (LA22_0==BEGINS_WITH||LA22_0==CONTAINS||(LA22_0 >= ENDS_WITH && LA22_0 <= EQUALS)||LA22_0==HREFLANG_MATCH||LA22_0==LIST_MATCH) ) {
					alt22=1;
				}

				switch (alt22) {
				case 1 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:463:35: attributeOperator
					{
					pushFollow(FOLLOW_attributeOperator_in_attributeSelector1767);
					attributeOperator111=attributeOperator();
					state._fsp--;

					adaptor.addChild(root_0, attributeOperator111.getTree());

					}
					break;

				default :
					break loop22;
				}
			}

			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:463:54: ( attributeValue )*
			loop23:
			while (true) {
				int alt23=2;
				int LA23_0 = input.LA(1);
				if ( (LA23_0==STRING) ) {
					alt23=1;
				}

				switch (alt23) {
				case 1 :
					// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:463:54: attributeValue
					{
					pushFollow(FOLLOW_attributeValue_in_attributeSelector1770);
					attributeValue112=attributeValue();
					state._fsp--;

					adaptor.addChild(root_0, attributeValue112.getTree());

					}
					break;

				default :
					break loop23;
				}
			}

			SQUARE_END113=(Token)match(input,SQUARE_END,FOLLOW_SQUARE_END_in_attributeSelector1773); 
			SQUARE_END113_tree = (Object)adaptor.create(SQUARE_END113);
			adaptor.addChild(root_0, SQUARE_END113_tree);

			}

			retval.stop = input.LT(-1);

			retval.tree = (Object)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "attributeSelector"


	public static class attributeName_return extends ParserRuleReturnScope {
		Object tree;
		@Override
		public Object getTree() { return tree; }
	};


	// $ANTLR start "attributeName"
	// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:466:1: attributeName : ID ;
	public final CSSParser.attributeName_return attributeName() throws RecognitionException {
		CSSParser.attributeName_return retval = new CSSParser.attributeName_return();
		retval.start = input.LT(1);

		Object root_0 = null;

		Token ID114=null;

		Object ID114_tree=null;

		try {
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:467:5: ( ID )
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:467:10: ID
			{
			root_0 = (Object)adaptor.nil();


			ID114=(Token)match(input,ID,FOLLOW_ID_in_attributeName1797); 
			ID114_tree = (Object)adaptor.create(ID114);
			adaptor.addChild(root_0, ID114_tree);

			}

			retval.stop = input.LT(-1);

			retval.tree = (Object)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "attributeName"


	public static class attributeOperator_return extends ParserRuleReturnScope {
		Object tree;
		@Override
		public Object getTree() { return tree; }
	};


	// $ANTLR start "attributeOperator"
	// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:470:1: attributeOperator : ( BEGINS_WITH | ENDS_WITH | CONTAINS | LIST_MATCH | HREFLANG_MATCH | EQUALS );
	public final CSSParser.attributeOperator_return attributeOperator() throws RecognitionException {
		CSSParser.attributeOperator_return retval = new CSSParser.attributeOperator_return();
		retval.start = input.LT(1);

		Object root_0 = null;

		Token set115=null;

		Object set115_tree=null;

		try {
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:471:5: ( BEGINS_WITH | ENDS_WITH | CONTAINS | LIST_MATCH | HREFLANG_MATCH | EQUALS )
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:
			{
			root_0 = (Object)adaptor.nil();


			set115=input.LT(1);
			if ( input.LA(1)==BEGINS_WITH||input.LA(1)==CONTAINS||(input.LA(1) >= ENDS_WITH && input.LA(1) <= EQUALS)||input.LA(1)==HREFLANG_MATCH||input.LA(1)==LIST_MATCH ) {
				input.consume();
				adaptor.addChild(root_0, (Object)adaptor.create(set115));
				state.errorRecovery=false;
			}
			else {
				MismatchedSetException mse = new MismatchedSetException(null,input);
				throw mse;
			}
			}

			retval.stop = input.LT(-1);

			retval.tree = (Object)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "attributeOperator"


	public static class attributeValue_return extends ParserRuleReturnScope {
		Object tree;
		@Override
		public Object getTree() { return tree; }
	};


	// $ANTLR start "attributeValue"
	// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:479:1: attributeValue : STRING ;
	public final CSSParser.attributeValue_return attributeValue() throws RecognitionException {
		CSSParser.attributeValue_return retval = new CSSParser.attributeValue_return();
		retval.start = input.LT(1);

		Object root_0 = null;

		Token STRING116=null;

		Object STRING116_tree=null;

		try {
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:480:5: ( STRING )
			// /Users/aharui/git/flex/master/flex-falcon/compiler/src/main/antlr3/org/apache/flex/compiler/internal/css/CSS.g:480:10: STRING
			{
			root_0 = (Object)adaptor.nil();


			STRING116=(Token)match(input,STRING,FOLLOW_STRING_in_attributeValue1900); 
			STRING116_tree = (Object)adaptor.create(STRING116);
			adaptor.addChild(root_0, STRING116_tree);

			}

			retval.stop = input.LT(-1);

			retval.tree = (Object)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "attributeValue"

	// Delegated rules



	public static final BitSet FOLLOW_namespaceStatement_in_stylesheet137 = new BitSet(new long[]{0x60004000483087C2L,0x0000000000000062L});
	public static final BitSet FOLLOW_fontFace_in_stylesheet141 = new BitSet(new long[]{0x60004000483087C2L,0x0000000000000062L});
	public static final BitSet FOLLOW_keyframes_in_stylesheet145 = new BitSet(new long[]{0x60004000483087C2L,0x0000000000000062L});
	public static final BitSet FOLLOW_mediaQuery_in_stylesheet149 = new BitSet(new long[]{0x60004000483087C2L,0x0000000000000062L});
	public static final BitSet FOLLOW_ruleset_in_stylesheet153 = new BitSet(new long[]{0x60004000483087C2L,0x0000000000000062L});
	public static final BitSet FOLLOW_AT_NAMESPACE_in_namespaceStatement177 = new BitSet(new long[]{0x8000000040000000L});
	public static final BitSet FOLLOW_ID_in_namespaceStatement179 = new BitSet(new long[]{0x8000000000000000L});
	public static final BitSet FOLLOW_STRING_in_namespaceStatement182 = new BitSet(new long[]{0x0800000000000000L});
	public static final BitSet FOLLOW_SEMI_COLONS_in_namespaceStatement184 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_AT_KEYFRAMES_in_keyframes227 = new BitSet(new long[]{0x0000000040000000L});
	public static final BitSet FOLLOW_ID_in_keyframes229 = new BitSet(new long[]{0x0000000000002000L});
	public static final BitSet FOLLOW_BLOCK_OPEN_in_keyframes231 = new BitSet(new long[]{0x6000400048309000L,0x0000000000000062L});
	public static final BitSet FOLLOW_ruleset_in_keyframes233 = new BitSet(new long[]{0x6000400048309000L,0x0000000000000062L});
	public static final BitSet FOLLOW_BLOCK_END_in_keyframes236 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_AT_WEBKIT_KEYFRAMES_in_keyframes262 = new BitSet(new long[]{0x0000000040000000L});
	public static final BitSet FOLLOW_ID_in_keyframes264 = new BitSet(new long[]{0x0000000000002000L});
	public static final BitSet FOLLOW_BLOCK_OPEN_in_keyframes266 = new BitSet(new long[]{0x6000400048309000L,0x0000000000000062L});
	public static final BitSet FOLLOW_ruleset_in_keyframes268 = new BitSet(new long[]{0x6000400048309000L,0x0000000000000062L});
	public static final BitSet FOLLOW_BLOCK_END_in_keyframes271 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_AT_MEDIA_in_mediaQuery310 = new BitSet(new long[]{0x0001000040010020L});
	public static final BitSet FOLLOW_medium_in_mediaQuery312 = new BitSet(new long[]{0x0000000000002000L});
	public static final BitSet FOLLOW_BLOCK_OPEN_in_mediaQuery314 = new BitSet(new long[]{0x6000400048309000L,0x0000000000000062L});
	public static final BitSet FOLLOW_ruleset_in_mediaQuery316 = new BitSet(new long[]{0x6000400048309000L,0x0000000000000062L});
	public static final BitSet FOLLOW_BLOCK_END_in_mediaQuery319 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_mediumCondition_in_medium359 = new BitSet(new long[]{0x0001000040010022L,0x0000000000000080L});
	public static final BitSet FOLLOW_71_in_medium402 = new BitSet(new long[]{0x0001000040010020L});
	public static final BitSet FOLLOW_mediumCondition_in_medium417 = new BitSet(new long[]{0x0001000040010022L,0x0000000000000080L});
	public static final BitSet FOLLOW_mediumCondition_in_medium433 = new BitSet(new long[]{0x0001000040010022L,0x0000000000000080L});
	public static final BitSet FOLLOW_ID_in_mediumCondition484 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ONLY_in_mediumCondition494 = new BitSet(new long[]{0x0000000040000000L});
	public static final BitSet FOLLOW_ID_in_mediumCondition496 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ARGUMENTS_in_mediumCondition510 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_COMMA_in_mediumCondition520 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_AT_FONT_FACE_in_fontFace549 = new BitSet(new long[]{0x0000000000002000L});
	public static final BitSet FOLLOW_declarationsBlock_in_fontFace551 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_selectorGroup_in_ruleset582 = new BitSet(new long[]{0x0000000000002000L});
	public static final BitSet FOLLOW_declarationsBlock_in_ruleset584 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_compoundSelector_in_selectorGroup618 = new BitSet(new long[]{0x0000000000010002L});
	public static final BitSet FOLLOW_COMMA_in_selectorGroup622 = new BitSet(new long[]{0x6000400048308000L,0x0000000000000062L});
	public static final BitSet FOLLOW_compoundSelector_in_selectorGroup624 = new BitSet(new long[]{0x0000000000010002L});
	public static final BitSet FOLLOW_simpleSelectorFraction_in_compoundSelector689 = new BitSet(new long[]{0x6000400048308002L,0x0000000000000062L});
	public static final BitSet FOLLOW_condition_in_simpleSelectorFraction759 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_element_in_simpleSelectorFraction770 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DOT_in_condition796 = new BitSet(new long[]{0x0000000040000000L});
	public static final BitSet FOLLOW_ID_in_condition799 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_HASH_WORD_in_condition811 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_COLON_in_condition824 = new BitSet(new long[]{0x0000080000000000L});
	public static final BitSet FOLLOW_NOT_in_condition827 = new BitSet(new long[]{0x0000000000000020L});
	public static final BitSet FOLLOW_ARGUMENTS_in_condition829 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_COLON_in_condition842 = new BitSet(new long[]{0x0000000040000000L});
	public static final BitSet FOLLOW_ID_in_condition845 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DOUBLE_COLON_in_condition858 = new BitSet(new long[]{0x0000000040000000L});
	public static final BitSet FOLLOW_ID_in_condition861 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_attributeSelector_in_condition874 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_childSelector_in_condition886 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_precededSelector_in_condition898 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_siblingSelector_in_condition910 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ID_in_element944 = new BitSet(new long[]{0x0008000000000000L});
	public static final BitSet FOLLOW_PIPE_in_element946 = new BitSet(new long[]{0x0000000040000000L});
	public static final BitSet FOLLOW_ID_in_element949 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_NUMBER_WITH_PERCENT_in_element959 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ID_in_element981 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_STAR_in_element1001 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_BLOCK_OPEN_in_declarationsBlock1030 = new BitSet(new long[]{0x0800000040001000L});
	public static final BitSet FOLLOW_SEMI_COLONS_in_declarationsBlock1058 = new BitSet(new long[]{0x0000000040000000L});
	public static final BitSet FOLLOW_declaration_in_declarationsBlock1076 = new BitSet(new long[]{0x0800000000001000L});
	public static final BitSet FOLLOW_SEMI_COLONS_in_declarationsBlock1110 = new BitSet(new long[]{0x0000000040000000L});
	public static final BitSet FOLLOW_declaration_in_declarationsBlock1129 = new BitSet(new long[]{0x0800000000001000L});
	public static final BitSet FOLLOW_SEMI_COLONS_in_declarationsBlock1159 = new BitSet(new long[]{0x0000000000001000L});
	public static final BitSet FOLLOW_BLOCK_END_in_declarationsBlock1182 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ID_in_declaration1222 = new BitSet(new long[]{0x0000000000008000L});
	public static final BitSet FOLLOW_COLON_in_declaration1224 = new BitSet(new long[]{0x85F2C400C8404010L,0x000000000000000CL});
	public static final BitSet FOLLOW_value_in_declaration1226 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_singleValue_in_value1272 = new BitSet(new long[]{0x85F2C400C8414012L,0x000000000000000CL});
	public static final BitSet FOLLOW_COMMA_in_value1276 = new BitSet(new long[]{0x85F2C400C8404010L,0x000000000000000CL});
	public static final BitSet FOLLOW_singleValue_in_value1279 = new BitSet(new long[]{0x85F2C400C8414012L,0x000000000000000CL});
	public static final BitSet FOLLOW_NUMBER_WITH_PERCENT_in_singleValue1353 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_NUMBER_WITH_UNIT_in_singleValue1363 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_HASH_WORD_in_singleValue1373 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_CLASS_REFERENCE_in_singleValue1383 = new BitSet(new long[]{0x0000000000000020L});
	public static final BitSet FOLLOW_ARGUMENTS_in_singleValue1385 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_PROPERTY_REFERENCE_in_singleValue1415 = new BitSet(new long[]{0x0000000000000020L});
	public static final BitSet FOLLOW_ARGUMENTS_in_singleValue1417 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_EMBED_in_singleValue1447 = new BitSet(new long[]{0x0000000000000020L});
	public static final BitSet FOLLOW_ARGUMENTS_in_singleValue1449 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_URL_in_singleValue1479 = new BitSet(new long[]{0x0000000000000020L});
	public static final BitSet FOLLOW_ARGUMENTS_in_singleValue1481 = new BitSet(new long[]{0x0000000004000002L});
	public static final BitSet FOLLOW_formatOption_in_singleValue1483 = new BitSet(new long[]{0x0000000004000002L});
	public static final BitSet FOLLOW_LOCAL_in_singleValue1507 = new BitSet(new long[]{0x0000000000000020L});
	public static final BitSet FOLLOW_ARGUMENTS_in_singleValue1509 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ALPHA_VALUE_in_singleValue1536 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_SCALE_VALUE_in_singleValue1546 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_RECT_VALUE_in_singleValue1556 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ROTATE_VALUE_in_singleValue1566 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_TRANSLATE3D_VALUE_in_singleValue1576 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_RGB_in_singleValue1586 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_RGBA_in_singleValue1596 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_STRING_in_singleValue1606 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ID_in_singleValue1622 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_OPERATOR_in_singleValue1632 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_IMPORTANT_in_singleValue1642 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_FORMAT_in_formatOption1662 = new BitSet(new long[]{0x0000000000000020L});
	public static final BitSet FOLLOW_ARGUMENTS_in_formatOption1664 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_70_in_childSelector1688 = new BitSet(new long[]{0x6000400048308000L,0x0000000000000062L});
	public static final BitSet FOLLOW_simpleSelectorFraction_in_childSelector1690 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_TILDE_in_precededSelector1713 = new BitSet(new long[]{0x6000400048308000L,0x0000000000000062L});
	public static final BitSet FOLLOW_simpleSelectorFraction_in_precededSelector1715 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_69_in_siblingSelector1738 = new BitSet(new long[]{0x6000400048308000L,0x0000000000000062L});
	public static final BitSet FOLLOW_simpleSelectorFraction_in_siblingSelector1740 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_SQUARE_OPEN_in_attributeSelector1763 = new BitSet(new long[]{0x0000000040000000L});
	public static final BitSet FOLLOW_attributeName_in_attributeSelector1765 = new BitSet(new long[]{0x9000020021840800L});
	public static final BitSet FOLLOW_attributeOperator_in_attributeSelector1767 = new BitSet(new long[]{0x9000020021840800L});
	public static final BitSet FOLLOW_attributeValue_in_attributeSelector1770 = new BitSet(new long[]{0x9000000000000000L});
	public static final BitSet FOLLOW_SQUARE_END_in_attributeSelector1773 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ID_in_attributeName1797 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_STRING_in_attributeValue1900 = new BitSet(new long[]{0x0000000000000002L});
}
