/*
 * Decompiled with CFR 0.152.
 */
package flash.swf;

import flash.swf.DebugHandler;
import flash.swf.SwfDecoder;
import flash.swf.SwfFormatException;
import flash.swf.debug.DebugModule;
import flash.swf.debug.LineRecord;
import flash.swf.debug.RegisterRecord;
import flash.swf.types.FlashUUID;
import flash.util.FileUtils;
import flash.util.IntMap;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;

public class DebugDecoder {
    public static final int kDebugScript = 0;
    public static final int kDebugOffset = 1;
    public static final int kDebugBreakpoint = 2;
    public static final int kDebugID = 3;
    public static final int kDebugRegisters = 5;
    private SwfDecoder in;
    private IntMap modules = new IntMap();

    public DebugDecoder(byte[] byArray) {
        this(new ByteArrayInputStream(byArray));
    }

    public DebugDecoder(InputStream inputStream) {
        this.in = new SwfDecoder(inputStream, 0);
    }

    public void readSwd(DebugHandler debugHandler) throws IOException {
        this.readHeader(debugHandler);
        this.readTags(debugHandler);
    }

    void readHeader(DebugHandler debugHandler) throws IOException {
        byte[] byArray = new byte[4];
        this.in.readFully(byArray);
        if (byArray[0] != 70 || byArray[1] != 87 || byArray[2] != 68 || byArray[3] < 6) {
            throw new SwfFormatException("not a Flash 6 or later SWD file");
        }
        this.in.swfVersion = byArray[3];
        debugHandler.header(this.in.swfVersion);
    }

    public void setTagData(byte[] byArray) throws IOException {
        this.in = new SwfDecoder(byArray, 0);
    }

    public void readTags(DebugHandler debugHandler) throws IOException {
        Object object;
        int n;
        int n2;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        do {
            n2 = (int)this.in.readUI32();
            switch (n2) {
                case 0: {
                    DebugModule debugModule = new DebugModule();
                    n = (int)this.in.readUI32();
                    debugModule.id = n;
                    debugModule.bitmap = (int)this.in.readUI32();
                    debugModule.name = this.in.readString();
                    debugModule.setText(this.in.readString());
                    DebugDecoder.adjustModuleName(debugModule);
                    if (this.modules.contains(n) && !debugModule.equals(object = (DebugModule)this.modules.get(n))) {
                        debugHandler.error("Module '" + ((DebugModule)object).name + "' has the same ID as Module '" + debugModule.name + "'");
                        debugHandler.error("Let's check for kDebugOffset that came before Module '" + ((DebugModule)object).name + "'");
                        debugHandler.error("Before: Number of accumulated line records: " + arrayList.size());
                        arrayList = this.purgeLineRecords(arrayList, n, debugHandler);
                        debugHandler.error("After: Number of accumulated line records: " + arrayList.size());
                    }
                    this.modules.put(n, debugModule);
                    debugHandler.module(debugModule);
                    break;
                }
                case 1: {
                    n = (int)this.in.readUI32();
                    int n3 = (int)this.in.readUI32();
                    DebugModule debugModule = (DebugModule)this.modules.get(n);
                    LineRecord lineRecord = new LineRecord(n3, debugModule);
                    int n4 = (int)this.in.readUI32();
                    if (debugModule != null) {
                        boolean bl = debugModule.corrupt;
                        if (!debugModule.addOffset(lineRecord, n4) && !bl) {
                            debugHandler.error(debugModule.name + ":" + n3 + " does not exist for offset " + n4 + ", module marked for exclusion from debugging");
                        }
                        debugHandler.offset(n4, lineRecord);
                        break;
                    }
                    arrayList.add(new Integer(n));
                    arrayList.add(lineRecord);
                    arrayList.add(new Integer(n4));
                    break;
                }
                case 2: {
                    debugHandler.breakpoint((int)this.in.readUI32());
                    break;
                }
                case 5: {
                    int n4 = (int)this.in.readUI32();
                    int n5 = this.in.readUI8();
                    RegisterRecord registerRecord = new RegisterRecord(n4, n5);
                    for (int i = 0; i < n5; ++i) {
                        int n6 = this.in.readUI8();
                        String string = this.in.readString();
                        registerRecord.addRegister(n6, string);
                    }
                    debugHandler.registers(n4, registerRecord);
                    break;
                }
                case 3: {
                    FlashUUID flashUUID = new FlashUUID();
                    this.in.readFully(flashUUID.bytes);
                    debugHandler.uuid(flashUUID);
                    break;
                }
                case -1: {
                    break;
                }
                default: {
                    throw new SwfFormatException("Unexpected tag id " + n2);
                }
            }
        } while (n2 != -1);
        int n7 = arrayList.size();
        for (n2 = 0; n2 < n7; n2 += 3) {
            n = (Integer)arrayList.get(n2);
            object = (LineRecord)arrayList.get(n2 + 1);
            int n8 = (Integer)arrayList.get(n2 + 2);
            ((LineRecord)object).module = (DebugModule)this.modules.get(n);
            if (((LineRecord)object).module != null) {
                boolean bl = ((LineRecord)object).module.corrupt;
                if (!((LineRecord)object).module.addOffset((LineRecord)object, n8) && !bl) {
                    debugHandler.error(((LineRecord)object).module.name + ":" + ((LineRecord)object).lineno + " does not exist for offset " + n8 + ", module marked for exclusion from debugging");
                }
                debugHandler.offset(n8, (LineRecord)object);
                continue;
            }
            debugHandler.error("Could not find debug module (id = " + n + ") for offset = " + n8);
        }
    }

    private ArrayList<Object> purgeLineRecords(ArrayList<Object> arrayList, int n, DebugHandler debugHandler) {
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        DebugModule debugModule = (DebugModule)this.modules.get(n);
        int n2 = arrayList.size();
        for (int i = 0; i < n2; i += 3) {
            Integer n3 = (Integer)arrayList.get(i);
            LineRecord lineRecord = (LineRecord)arrayList.get(i + 1);
            Integer n4 = (Integer)arrayList.get(i + 2);
            if (n3 == n) {
                lineRecord.module = debugModule;
                if (lineRecord.module != null) {
                    lineRecord.module.addOffset(lineRecord, n4);
                    debugHandler.offset(n4, lineRecord);
                    continue;
                }
                debugHandler.error("Could not find kDebugScript with module ID = " + n3);
                continue;
            }
            arrayList2.add(n3);
            arrayList2.add(lineRecord);
            arrayList2.add(n4);
        }
        return arrayList2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws IOException {
        for (int i = 0; i < stringArray.length; ++i) {
            try (FileInputStream fileInputStream = new FileInputStream(stringArray[i]);){
                new DebugDecoder(fileInputStream).readSwd(new DebugHandler(){

                    @Override
                    public void header(int n) {
                        System.out.println("FWD" + n);
                    }

                    @Override
                    public void uuid(FlashUUID flashUUID) {
                        System.out.println("DebugID " + flashUUID);
                    }

                    @Override
                    public void module(DebugModule debugModule) {
                        System.out.println("DebugScript #" + debugModule.id + " " + debugModule.bitmap + " " + debugModule.name + " (nlines = " + (debugModule.offsets.length - 1) + ")");
                    }

                    @Override
                    public void offset(int n, LineRecord lineRecord) {
                        System.out.println("DebugOffset #" + lineRecord.module.id + ":" + lineRecord.lineno + " " + n);
                    }

                    @Override
                    public void breakpoint(int n) {
                        System.out.println("DebugBreakpoint " + n);
                    }

                    @Override
                    public void registers(int n, RegisterRecord registerRecord) {
                        System.out.println("DebugRegisters " + registerRecord.toString());
                    }

                    @Override
                    public void error(String string) {
                        System.err.println("***ERROR: " + string);
                    }
                });
                System.out.println();
                continue;
            }
        }
    }

    protected static final void adjustModuleName(DebugModule debugModule) {
        debugModule.name = DebugDecoder.adjustModuleName(debugModule.name);
    }

    public static final String adjustModuleName(String string) {
        if (string.startsWith("<") && string.endsWith(">")) {
            return string;
        }
        try {
            URL uRL = new URL(string);
            return string;
        }
        catch (MalformedURLException malformedURLException) {
            String string2;
            String string3;
            File file;
            try {
                file = new File(string);
            }
            catch (Error error) {
                file = null;
            }
            if (file == null || !file.isFile()) {
                int n = string.indexOf(58);
                if (n != -1) {
                    string3 = string.substring(0, n).trim();
                    string2 = string.substring(n + 1).trim();
                } else {
                    string3 = "";
                    string2 = string;
                }
            } else {
                string3 = "";
                string2 = string;
            }
            try {
                file = new File(string2);
            }
            catch (Error error) {
                file = null;
            }
            if (file != null && file.isFile()) {
                try {
                    if (string2.indexOf("..") != -1 || string2.indexOf(".") != -1) {
                        file = FileUtils.getCanonicalFile(file);
                    }
                    string2 = FileUtils.toURL(file).toString();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            string = string3.length() == 0 ? string2 : string3.trim() + ": " + string2.trim();
            return string;
        }
    }
}

