/*
 * Decompiled with CFR 0.152.
 */
package flex2.tools.oem;

import flex2.compiler.common.CompilerConfiguration;
import flex2.compiler.config.ConfigurationException;
import flex2.compiler.io.FileUtil;
import flex2.compiler.io.LocalFile;
import flex2.compiler.io.VirtualFile;
import flex2.compiler.util.Benchmark;
import flex2.compiler.util.CompilerControl;
import flex2.compiler.util.CompilerMessage;
import flex2.compiler.util.MimeMappings;
import flex2.compiler.util.PerformanceData;
import flex2.compiler.util.ThreadLocalToolkit;
import flex2.tools.oem.ApplicationCache;
import flex2.tools.oem.Builder;
import flex2.tools.oem.Configuration;
import flex2.tools.oem.LibraryCache;
import flex2.tools.oem.Logger;
import flex2.tools.oem.Message;
import flex2.tools.oem.PathResolver;
import flex2.tools.oem.ProgressMeter;
import flex2.tools.oem.Report;
import flex2.tools.oem.VirtualLocalFile;
import flex2.tools.oem.internal.OEMConfiguration;
import flex2.tools.oem.internal.OEMReport;
import flex2.tools.oem.internal.OEMUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.flex.compiler.clients.COMPC;
import org.apache.flex.compiler.clients.problems.ProblemQuery;
import org.apache.flex.compiler.problems.CompilerProblemSeverity;
import org.apache.flex.compiler.problems.ICompilerProblem;
import org.apache.flex.compiler.problems.annotations.DefaultSeverity;

public class Library
implements Builder,
Cloneable {
    private Set<VirtualFile> sources = new TreeSet<VirtualFile>(new Comparator<VirtualFile>(){

        @Override
        public int compare(VirtualFile f0, VirtualFile f1) {
            return f0.getName().compareTo(f1.getName());
        }
    });
    private Set<String> classes = new TreeSet<String>();
    private Set<String> resourceBundles;
    private Set<URI> namespaces = new TreeSet<URI>();
    private Map<String, VirtualFile> files;
    private Map<String, VirtualFile> stylesheets;
    private OEMConfiguration oemConfiguration = null;
    private Logger logger = null;
    private File output = null;
    private File directory = null;
    private MimeMappings mimeMappings;
    private ProgressMeter meter = null;
    protected PathResolver resolver = null;
    private CompilerControl cc;
    private ApplicationCache applicationCache;
    private LibraryCache libraryCache;
    private String cacheName = null;
    private String configurationReport = null;
    private List<Message> messages;
    private HashMap<String, PerformanceData[]> compilerBenchmarks;
    private Benchmark benchmark;

    public Library() {
        this.resourceBundles = new TreeSet<String>();
        this.files = new TreeMap<String, VirtualFile>();
        this.stylesheets = new TreeMap<String, VirtualFile>();
        this.mimeMappings = new MimeMappings();
        this.cc = new CompilerControl();
        this.messages = new ArrayList<Message>();
    }

    public void addComponent(String includeClass) {
        this.classes.add(includeClass);
    }

    public void addComponent(File includeSource) {
        this.sources.add(new LocalFile(includeSource));
    }

    public void addComponent(VirtualLocalFile includeSource) {
        this.sources.add(includeSource);
    }

    public void addComponent(URI includeNamespace) {
        this.namespaces.add(includeNamespace);
    }

    public void removeComponent(String includeClass) {
        this.classes.remove(includeClass);
    }

    public void removeComponent(File includeSource) {
        this.sources.remove(new LocalFile(includeSource));
    }

    public void removeComponent(VirtualLocalFile includeSource) {
        this.sources.remove(includeSource);
    }

    public void removeComponent(URI includeNamespace) {
        this.namespaces.remove(includeNamespace);
    }

    public void removeAllComponents() {
        this.sources.clear();
        this.classes.clear();
        this.namespaces.clear();
    }

    public void addResourceBundle(String resourceBundle) {
        this.resourceBundles.add(resourceBundle);
    }

    public void removeResourceBundle(String resourceBundle) {
        this.resourceBundles.remove(resourceBundle);
    }

    public void removeAllResourceBundles() {
        this.resourceBundles.clear();
    }

    public void addArchiveFile(String name, File file) {
        this.files.put(name, new LocalFile(file));
    }

    public void addArchiveFile(String name, VirtualLocalFile file) {
        this.files.put(name, file);
    }

    public void removeArchiveFile(String name) {
        this.files.remove(name);
    }

    public void removeAllArchiveFiles() {
        this.files.clear();
    }

    public void addStyleSheet(String name, File file) {
        this.stylesheets.put(name, new LocalFile(file));
    }

    public void addStyleSheet(String name, VirtualLocalFile file) {
        this.stylesheets.put(name, file);
    }

    public void removeStyleSheet(String name) {
        this.stylesheets.remove(name);
    }

    public void removeAllStyleSheets() {
        this.stylesheets.clear();
    }

    @Override
    public void setConfiguration(Configuration configuration) {
        this.oemConfiguration = (OEMConfiguration)configuration;
    }

    @Override
    public Configuration getDefaultConfiguration() {
        return this.getDefaultConfiguration(false);
    }

    private Configuration getDefaultConfiguration(boolean processDefaults) {
        return OEMUtil.getLibraryConfiguration(this.constructCommandLine(null), false, false, OEMUtil.getLogger(this.logger, this.messages), this.resolver, this.mimeMappings, processDefaults);
    }

    public HashMap<String, PerformanceData[]> getCompilerBenchmarks() {
        return this.compilerBenchmarks;
    }

    @Override
    public Benchmark getBenchmark() {
        return this.benchmark;
    }

    @Override
    public Configuration getConfiguration() {
        return this.oemConfiguration;
    }

    @Override
    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    @Override
    public void setSupportedFileExtensions(String mimeType, String[] extensions) {
        this.mimeMappings.set(mimeType, extensions);
    }

    public void setOutput(File output) {
        this.output = output;
    }

    @Override
    public File getOutput() {
        return this.output;
    }

    public void setDirectory(File directory) {
        this.directory = directory;
    }

    public File getDirectory() {
        return this.directory;
    }

    @Override
    public void setProgressMeter(ProgressMeter meter) {
        this.meter = meter;
    }

    @Override
    public void setPathResolver(PathResolver resolver) {
        this.resolver = resolver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long build(boolean incremental) throws IOException {
        if (this.output != null || this.directory != null) {
            long size = 0L;
            try {
                int result = this.compile(incremental);
                long l = size;
                return l;
            }
            finally {
                this.clean(false, false, false, true, false, true);
            }
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long build(OutputStream out, boolean incremental) throws IOException {
        try {
            int result = this.compile(incremental);
            long l = 0L;
            return l;
        }
        finally {
            this.clean(false, false, false, true, false, true);
        }
    }

    @Override
    public void stop() {
        this.cc.stop();
    }

    @Override
    public void clean() {
        this.clean(true, true, true, true, true, true);
    }

    @Override
    public void load(InputStream in) throws IOException {
    }

    @Override
    public long save(OutputStream out) throws IOException {
        return 1L;
    }

    @Override
    public Report getReport() {
        return new OEMReport(null, null, null, null, this.configurationReport, this.messages, this.files);
    }

    private String[] constructCommandLine(OEMConfiguration localOEMConfiguration) {
        StringBuilder buffer;
        String[] commandLine;
        String[] stringArray = commandLine = localOEMConfiguration != null ? localOEMConfiguration.getCompilerOptions() : new String[]{};
        if (this.output != null) {
            String[] outputCommandLine = new String[commandLine.length + 1];
            System.arraycopy(commandLine, 0, outputCommandLine, 0, commandLine.length);
            outputCommandLine[commandLine.length] = "-output=" + this.output.getAbsolutePath();
            commandLine = outputCommandLine;
        }
        if (this.classes.size() > 0) {
            buffer = new StringBuilder("-include-classes=");
            Iterator<String> iter = this.classes.iterator();
            while (iter.hasNext()) {
                String className = iter.next();
                buffer.append(className);
                if (!iter.hasNext()) continue;
                buffer.append(",");
            }
            String[] newCommandLine = new String[commandLine.length + 1];
            System.arraycopy(commandLine, 0, newCommandLine, 0, commandLine.length);
            newCommandLine[commandLine.length] = buffer.toString();
            return newCommandLine;
        }
        if (this.sources.size() > 0) {
            buffer = new StringBuilder("-include-sources=");
            Iterator<VirtualFile> iter = this.sources.iterator();
            while (iter.hasNext()) {
                String className = iter.next().getName();
                buffer.append(className);
                if (!iter.hasNext()) continue;
                buffer.append(",");
            }
            String[] newCommandLine = new String[commandLine.length + 1];
            System.arraycopy(commandLine, 0, newCommandLine, 0, commandLine.length);
            newCommandLine[commandLine.length] = buffer.toString();
            return newCommandLine;
        }
        return commandLine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int compile(boolean incremental) {
        try {
            VirtualFile[] includeLibs;
            this.messages.clear();
            OEMConfiguration tempOEMConfiguration = this.oemConfiguration == null ? (OEMConfiguration)this.getDefaultConfiguration(true) : OEMUtil.getLibraryConfiguration(this.constructCommandLine(this.oemConfiguration), this.oemConfiguration.keepLinkReport(), this.oemConfiguration.keepSizeReport(), OEMUtil.getLogger(this.logger, this.messages), this.resolver, this.mimeMappings);
            if (tempOEMConfiguration == null) {
                this.clean(false, false, false);
                int n = -1;
                return n;
            }
            if (this.oemConfiguration != null && this.oemConfiguration.keepConfigurationReport()) {
                this.configurationReport = OEMUtil.formatConfigurationBuffer(tempOEMConfiguration.cfgbuf);
            }
            if (this.oemConfiguration != null) {
                this.oemConfiguration.cfgbuf = tempOEMConfiguration.cfgbuf;
            }
            for (Map.Entry<String, VirtualFile> entry : this.files.entrySet()) {
                tempOEMConfiguration.cfgbuf.calculateLinkChecksum(entry.getKey(), entry.getValue().getLastModified());
            }
            this.cc.run();
            OEMUtil.init(OEMUtil.getLogger(this.logger, this.messages), this.mimeMappings, this.meter, this.resolver, this.cc);
            VirtualFile[] virtualFileArray = includeLibs = tempOEMConfiguration.configuration == null ? null : tempOEMConfiguration.configuration.getCompilerConfiguration().getIncludeLibraries();
            if (this.sources.size() == 0 && this.classes.size() == 0 && this.namespaces.size() == 0 && this.resourceBundles.size() == 0 && this.files.size() == 0 && this.stylesheets.size() == 0 && (includeLibs == null || includeLibs.length == 0)) {
                ThreadLocalToolkit.log(new ConfigurationException.NoSwcInputs(null, null, -1));
                this.clean(false, false, false);
                int entry = -1;
                return entry;
            }
            CompilerConfiguration compilerConfig = tempOEMConfiguration.configuration.getCompilerConfiguration();
            compilerConfig.setMetadataExport(true);
            this.clean(true, false, false, true, false, false);
            COMPC compc = new COMPC();
            int returnValue = compc.mainNoExit(this.constructCommandLine(this.oemConfiguration));
            returnValue = returnValue == 0 ? 1 : -1;
            this.convertMessages(compc.getProblems());
            this.clean(returnValue != 1, false, false);
            int n = returnValue;
            return n;
        }
        finally {
            OEMUtil.clean();
        }
    }

    public long link(OutputStream output) {
        try {
            FileInputStream inStream = new FileInputStream(this.output);
            byte[] b = new byte[(int)this.output.length()];
            inStream.read(b);
            output.write(b);
            inStream.close();
            return this.output.length();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return -1L;
    }

    private void clean(boolean cleanData, boolean cleanCache, boolean cleanOutput) {
        this.clean(cleanData, cleanCache, cleanOutput, true, false, false);
    }

    private void clean(boolean cleanData, boolean cleanCache, boolean cleanOutput, boolean cleanConfig, boolean cleanMessages, boolean cleanThreadLocals) {
        if (cleanThreadLocals) {
            OEMUtil.clean();
        }
        if (this.oemConfiguration != null && cleanConfig) {
            this.oemConfiguration.reset();
        }
        if (cleanData) {
            this.configurationReport = null;
        }
        if (cleanCache && this.cacheName != null) {
            File dead = FileUtil.openFile(this.cacheName);
            if (dead != null && dead.exists()) {
                dead.delete();
            }
            this.cacheName = null;
        }
        if (cleanOutput && this.output != null && this.output.exists()) {
            this.output.delete();
        }
        if (cleanMessages) {
            this.messages.clear();
        }
    }

    public ApplicationCache getApplicationCache() {
        return this.applicationCache;
    }

    @Override
    public void setApplicationCache(ApplicationCache applicationCache) {
        this.applicationCache = applicationCache;
    }

    public LibraryCache getSwcCache() {
        return this.libraryCache;
    }

    @Override
    public void setSwcCache(LibraryCache libraryCache) {
        this.libraryCache = libraryCache;
    }

    public Library clone() {
        Library clone;
        try {
            clone = (Library)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        clone.oemConfiguration = this.oemConfiguration.clone();
        return clone;
    }

    public void refreshLastModified() {
    }

    public void convertMessages(ProblemQuery pq) {
        List<ICompilerProblem> probs = pq.getProblems();
        block10: for (ICompilerProblem prob : probs) {
            Annotation[] annotations;
            Class<?> aClass = prob.getClass();
            for (Annotation annotation : annotations = aClass.getAnnotations()) {
                String level;
                if (!(annotation instanceof DefaultSeverity)) continue;
                DefaultSeverity myAnnotation = (DefaultSeverity)annotation;
                CompilerProblemSeverity cps = myAnnotation.value();
                if (cps.equals((Object)CompilerProblemSeverity.ERROR)) {
                    level = "error";
                } else {
                    if (!cps.equals((Object)CompilerProblemSeverity.WARNING)) continue block10;
                    level = "warning";
                }
                CompilerMessage msg = new CompilerMessage(level, prob.getSourcePath(), prob.getLine() + 1, prob.getColumn());
                try {
                    String errText = (String)aClass.getField("DESCRIPTION").get(aClass);
                    while (errText.contains("${")) {
                        int start = errText.indexOf("${");
                        int end = errText.indexOf("}", start);
                        String token = errText.substring(start + 2, end);
                        String value = (String)aClass.getField(token).get(prob);
                        token = "${" + token + "}";
                        errText = errText.replace(token, value);
                    }
                    msg.setMessage(errText);
                }
                catch (IllegalArgumentException e1) {
                    e1.printStackTrace();
                }
                catch (SecurityException e1) {
                    e1.printStackTrace();
                }
                catch (IllegalAccessException e1) {
                    e1.printStackTrace();
                }
                catch (NoSuchFieldException e1) {
                    e1.printStackTrace();
                }
                this.messages.add(msg);
                try {
                    this.logger.log(msg, aClass.getField("errorCode").getInt(null), prob.getSourcePath());
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (SecurityException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (NoSuchFieldException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    static {
        block2: {
            try {
                Class.forName("flex2.tools.oem.Application");
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
    }
}

