/*
 * Decompiled with CFR 0.152.
 */
package flex2.tools;

import flash.localization.LocalizationManager;
import flex2.compiler.Logger;
import flex2.compiler.config.ConfigurationException;
import flex2.compiler.util.CompilerMessage;
import flex2.compiler.util.ConsoleLogger;
import flex2.compiler.util.ThreadLocalToolkit;
import flex2.tools.MxmlJSC;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.flex.compiler.clients.COMPC;
import org.apache.flex.compiler.clients.MXMLC;
import org.apache.flex.compiler.clients.MXMLJSC;
import org.apache.flex.compiler.clients.problems.ProblemQuery;
import org.apache.flex.compiler.clients.problems.ProblemQueryProvider;
import org.apache.flex.compiler.config.Configuration;
import org.apache.flex.compiler.config.ConfigurationBuffer;
import org.apache.flex.compiler.config.ConfigurationValue;
import org.apache.flex.compiler.filespecs.FileSpecification;
import org.apache.flex.compiler.internal.config.FileConfigurator;
import org.apache.flex.compiler.problems.CompilerProblemSeverity;
import org.apache.flex.compiler.problems.ICompilerProblem;
import org.apache.flex.compiler.problems.annotations.DefaultSeverity;
import org.apache.flex.utils.ArgumentUtil;

public class Tool {
    protected static Class<? extends MXMLC> COMPILER;
    protected static Class<? extends MxmlJSC> JS_COMPILER;

    protected static int compile(String[] args) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        int exitCode;
        String value = ArgumentUtil.getValue(args, "-js-output-type");
        MXMLJSC.JSOutputType jsOutputType = null;
        if (value != null) {
            jsOutputType = MXMLJSC.JSOutputType.fromString((String)value);
        }
        if (jsOutputType != null) {
            ArgumentBag bag = Tool.prepareJs(new ArgumentBag(args));
            MxmlJSC mxmlJSC = JS_COMPILER.newInstance();
            exitCode = mxmlJSC.execute(bag.args);
            if (!mxmlJSC.getProblemQuery().hasErrors()) {
                if (jsOutputType.equals((Object)MXMLJSC.JSOutputType.FLEXJS_DUAL)) {
                    Tool.prepareAs3(bag);
                    exitCode = Tool.flexCompile(bag.args);
                }
            } else {
                Tool.processProblemReport(mxmlJSC);
            }
        } else {
            exitCode = Tool.flexCompile(args);
        }
        return exitCode;
    }

    protected static ArgumentBag prepareJs(ArgumentBag bag) {
        Tool.SwitchDefineToCompileJs(bag);
        Tool.prepareJsOutput(bag);
        return bag;
    }

    protected static ArgumentBag prepareAs3(ArgumentBag bag) {
        Tool.SwitchDefineToCompileAs3(bag);
        Tool.prepareAs3Output(bag);
        Tool.removeNativeJSLibraries(bag);
        return bag;
    }

    private static void removeNativeJSLibraries(ArgumentBag bag) {
        ArrayList<String> argList = new ArrayList<String>(Arrays.asList(bag.args));
        argList.add("--exclude-native-js-libraries=true");
        bag.args = argList.toArray(new String[argList.size()]);
    }

    private static void prepareJsOutput(ArgumentBag bag) {
        int lastIndexOf;
        bag.isCommandLineOutput = true;
        bag.oldOutputPath = ArgumentUtil.getValue(bag.args, "-output");
        if (bag.oldOutputPath == null) {
            bag.oldOutputPath = ArgumentUtil.getValue(bag.args, "-o");
            if (bag.oldOutputPath != null) {
                bag.outputAlias = "-o";
            }
        } else {
            bag.outputAlias = "-output";
        }
        if (bag.oldOutputPath == null) {
            bag.isCommandLineOutput = false;
            List<ConfigurationBuffer> flexConfigs = null;
            try {
                flexConfigs = Tool.loadConfig(bag.args);
                for (ConfigurationBuffer flexConfig : flexConfigs) {
                    if (bag.oldOutputPath != null) continue;
                    List<ConfigurationValue> output = flexConfig != null ? flexConfig.getVar("output") : null;
                    ConfigurationValue configurationValue = output != null ? output.get(0) : null;
                    bag.oldOutputPath = configurationValue != null ? configurationValue.getArgs().get(0) : bag.oldOutputPath;
                }
            }
            catch (org.apache.flex.compiler.exceptions.ConfigurationException configurationException) {
                // empty catch block
            }
        }
        if (bag.oldOutputPath != null && (lastIndexOf = Math.max(bag.oldOutputPath.lastIndexOf("/"), bag.oldOutputPath.lastIndexOf("\\"))) > -1) {
            bag.newOutputPath = bag.oldOutputPath.substring(0, lastIndexOf) + File.separator + "js" + File.separator + "out";
            if (bag.isCommandLineOutput) {
                ArgumentUtil.setValue(bag.args, bag.outputAlias, bag.newOutputPath);
            } else {
                bag.args = ArgumentUtil.addValue(bag.args, "-output", bag.newOutputPath);
            }
        }
    }

    private static void SwitchDefineToCompileJs(ArgumentBag bag) {
        Collection<String> defines = ArgumentUtil.getValues(bag.args, "-define");
        if (defines.contains("COMPILE::AS3,AUTO") && defines.contains("COMPILE::JS,AUTO")) {
            bag.args = ArgumentUtil.removeElementWithValue(bag.args, "-define", "COMPILE::JS,AUTO");
            bag.args = ArgumentUtil.removeElementWithValue(bag.args, "-define", "COMPILE::AS3,AUTO");
            bag.args = ArgumentUtil.addValue(bag.args, "-define", "COMPILE::JS,true", true);
            bag.args = ArgumentUtil.addValue(bag.args, "-define", "COMPILE::AS3,false", true);
            bag.args = ArgumentUtil.addValue(bag.args, "-keep-asdoc", null);
        }
    }

    private static void prepareAs3Output(ArgumentBag bag) {
        if (bag.oldOutputPath != null) {
            if (bag.isCommandLineOutput) {
                ArgumentUtil.setValue(bag.args, bag.outputAlias, bag.oldOutputPath);
            } else {
                bag.args = ArgumentUtil.removeElement(bag.args, "-output");
            }
        }
        if (COMPILER.getName().equals(COMPC.class.getName())) {
            bag.args = ArgumentUtil.addValue(bag.args, "-include-file", "js" + File.separator + "out" + File.separator + "*," + bag.newOutputPath);
        }
    }

    private static void SwitchDefineToCompileAs3(ArgumentBag bag) {
        Collection<String> defines = ArgumentUtil.getValues(bag.args, "-define");
        if (defines.contains("COMPILE::AS3,false") && defines.contains("COMPILE::JS,true")) {
            bag.args = ArgumentUtil.removeElement(bag.args, "-keep-asdoc");
            bag.args = ArgumentUtil.removeElementWithValue(bag.args, "-define", "COMPILE::AS3,false");
            bag.args = ArgumentUtil.removeElementWithValue(bag.args, "-define", "COMPILE::JS,true");
            bag.args = ArgumentUtil.addValue(bag.args, "-define", "COMPILE::JS,false", true);
            bag.args = ArgumentUtil.addValue(bag.args, "-define", "COMPILE::AS3,true", true);
        }
        bag.args = ArgumentUtil.removeElement(bag.args, "-js-output-type");
    }

    private static List<ConfigurationBuffer> loadConfig(String[] args) throws org.apache.flex.compiler.exceptions.ConfigurationException {
        ArrayList<ConfigurationBuffer> configurationBuffers = null;
        Collection<String> configFilePaths = ArgumentUtil.getValues(args, "-load-config");
        if (configFilePaths != null) {
            for (String configFilePath : configFilePaths) {
                File configFile = new File(configFilePath);
                FileSpecification fileSpecification = new FileSpecification(configFile.getAbsolutePath());
                ConfigurationBuffer cfgbuf = Tool.createConfigurationBuffer(Configuration.class);
                FileConfigurator.load(cfgbuf, fileSpecification, new File(configFile.getPath()).getParent(), "flex-config", false);
                if (configurationBuffers == null) {
                    configurationBuffers = new ArrayList<ConfigurationBuffer>(0);
                }
                configurationBuffers.add(cfgbuf);
            }
        }
        return configurationBuffers;
    }

    private static ConfigurationBuffer createConfigurationBuffer(Class<? extends Configuration> configurationClass) {
        return new ConfigurationBuffer(configurationClass, Configuration.getAliases());
    }

    protected static int flexCompile(String[] args) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        MXMLC mxmlc = COMPILER.newInstance();
        int exitCode = mxmlc.execute(args);
        Tool.processProblemReport(new CompilerRequestableProblems(mxmlc));
        return exitCode;
    }

    public static Map<String, String> getLicenseMapFromFile(String fileName) throws ConfigurationException {
        HashMap<String, String> result = null;
        FileInputStream in = null;
        try {
            in = new FileInputStream(fileName);
            Properties properties = new Properties();
            properties.load(in);
            Enumeration<?> enumeration = properties.propertyNames();
            if (enumeration.hasMoreElements()) {
                result = new HashMap<String, String>();
                while (enumeration.hasMoreElements()) {
                    String propertyName = (String)enumeration.nextElement();
                    result.put(propertyName, properties.getProperty(propertyName));
                }
            }
        }
        catch (IOException ioException) {
            LocalizationManager l10n = ThreadLocalToolkit.getLocalizationManager();
            throw new ConfigurationException(l10n.getLocalizedTextString(new FailedToLoadLicenseFile(fileName)));
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ioe) {}
            }
        }
        return result;
    }

    public static void processProblemReport(ProblemQueryProvider requestableProblems) {
        block5: for (ICompilerProblem problem : requestableProblems.getProblemQuery().getProblems()) {
            Annotation[] annotations;
            Class<?> aClass = problem.getClass();
            for (Annotation annotation : annotations = aClass.getAnnotations()) {
                String level;
                if (!(annotation instanceof DefaultSeverity)) continue;
                DefaultSeverity myAnnotation = (DefaultSeverity)annotation;
                CompilerProblemSeverity cps = myAnnotation.value();
                if (cps.equals((Object)CompilerProblemSeverity.ERROR)) {
                    level = "error";
                } else {
                    if (!cps.equals((Object)CompilerProblemSeverity.WARNING)) continue block5;
                    level = "warning";
                }
                CompilerMessage msg = new CompilerMessage(level, problem.getSourcePath(), problem.getLine() + 1, problem.getColumn());
                try {
                    String errText = (String)aClass.getField("DESCRIPTION").get(aClass);
                    while (errText.contains("${")) {
                        int start = errText.indexOf("${");
                        int end = errText.indexOf("}", start);
                        String token = errText.substring(start + 2, end);
                        String value = (String)aClass.getField(token).get(problem);
                        token = "${" + token + "}";
                        errText = errText.replace(token, value);
                    }
                    msg.setMessage(errText);
                    Tool.logMessage(msg);
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (SecurityException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (NoSuchFieldException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static void logMessage(CompilerMessage msg) {
        Logger logger = ThreadLocalToolkit.getLogger() != null ? ThreadLocalToolkit.getLogger() : new ConsoleLogger();
        try {
            if (msg.getLevel().equals("info")) {
                logger.logInfo(msg.getPath(), msg.getLine(), msg.getColumn(), msg.getMessage());
            } else if (msg.getLevel().equals("warning")) {
                logger.logWarning(msg.getPath(), msg.getLine(), msg.getColumn(), msg.getMessage());
            } else if (msg.getLevel().equals("error")) {
                logger.logError(msg.getPath(), msg.getLine(), msg.getColumn(), msg.getMessage());
            }
        }
        catch (Exception e) {
            System.out.println(msg.getMessage());
        }
    }

    protected static class ArgumentBag {
        public String[] args;
        public String outputAlias;
        public String oldOutputPath;
        public String newOutputPath;
        public boolean isCommandLineOutput;

        public ArgumentBag(String[] args) {
            this.args = args;
        }
    }

    static class CompilerRequestableProblems
    implements ProblemQueryProvider {
        private MXMLC mxmlc;

        public CompilerRequestableProblems(MXMLC mxmlc) {
            this.mxmlc = mxmlc;
        }

        @Override
        public ProblemQuery getProblemQuery() {
            return this.mxmlc.getProblems();
        }
    }

    public static class NoUpdateMessage
    extends CompilerMessage.CompilerInfo {
        private static final long serialVersionUID = 6943388392279226490L;
        public String name;

        public NoUpdateMessage(String name) {
            this.name = name;
        }
    }

    public static class FailedToLoadLicenseFile
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = -2980033917773108328L;
        public String fileName;

        public FailedToLoadLicenseFile(String fileName) {
            this.fileName = fileName;
        }
    }
}

