/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.utils;

import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.CommandLineRunner;
import com.google.javascript.jscomp.CompilationLevel;
import com.google.javascript.jscomp.Compiler;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.DiagnosticGroups;
import com.google.javascript.jscomp.SourceFile;
import com.google.javascript.jscomp.SourceMap;
import com.google.javascript.jscomp.WarningLevel;
import com.google.javascript.rhino.Node;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;

public class VF2JSClosureCompilerWrapper {
    private Compiler compiler_;
    private CompilerOptions options_;
    private List<SourceFile> jsExternsFiles_;
    private List<SourceFile> jsSourceFiles_;
    public String targetFilePath;

    public VF2JSClosureCompilerWrapper() {
        Compiler.setLoggingLevel((Level)Level.ALL);
        this.compiler_ = new Compiler();
        this.options_ = new CompilerOptions();
        this.initOptions();
        this.jsExternsFiles_ = new ArrayList<SourceFile>();
        this.initExterns();
        this.jsSourceFiles_ = new ArrayList<SourceFile>();
    }

    public void addJSExternsFile(String fileName) {
        this.addJSExternsFile(SourceFile.fromFile((String)fileName));
    }

    public void addJSExternsFile(SourceFile file) {
        this.jsExternsFiles_.add(file);
    }

    public void addJSSourceFile(String fileName) {
        this.jsSourceFiles_.add(SourceFile.fromFile((String)fileName));
    }

    public void compile() {
        this.compiler_.compile(this.jsExternsFiles_, this.jsSourceFiles_, this.options_);
        try {
            FileWriter targetFile = new FileWriter(this.targetFilePath);
            targetFile.write(this.compiler_.toSource());
            targetFile.close();
            FileWriter sourceMapFile = new FileWriter(this.options_.sourceMapOutputPath);
            this.compiler_.getSourceMap().appendTo((Appendable)sourceMapFile, "");
            sourceMapFile.close();
        }
        catch (IOException error) {
            System.out.println(error);
        }
    }

    private void initExterns() {
        try {
            List defaultExterns = CommandLineRunner.getDefaultExterns();
            for (SourceFile defaultExtern : defaultExterns) {
                this.addJSExternsFile(defaultExtern);
            }
        }
        catch (IOException error) {
            System.out.println(error);
        }
    }

    private void initOptions() {
        CompilationLevel.ADVANCED_OPTIMIZATIONS.setOptionsForCompilationLevel(this.options_);
        WarningLevel.VERBOSE.setOptionsForWarningLevel(this.options_);
        String[] asdocTags = new String[]{"productversion", "playerversion", "langversion", "copy"};
        this.options_.setExtraAnnotationNames(Arrays.asList(asdocTags));
    }

    public void setOptions(String sourceMapPath, boolean useStrictPublishing) {
        if (useStrictPublishing) {
            this.options_.getDefineReplacements().put("goog.DEBUG", new Node(44));
            this.options_.setPreferSingleQuotes(true);
            this.options_.setFoldConstants(true);
            this.options_.setDeadAssignmentElimination(true);
            this.options_.setInlineConstantVars(true);
            this.options_.setInlineFunctions(true);
            this.options_.setInlineLocalFunctions(true);
            this.options_.setCrossModuleCodeMotion(true);
            this.options_.setCoalesceVariableNames(true);
            this.options_.setCrossModuleMethodMotion(true);
            this.options_.setInlineGetters(true);
            this.options_.setInlineVariables(true);
            this.options_.setSmartNameRemoval(true);
            this.options_.setRemoveDeadCode(true);
            this.options_.setCheckMissingReturn(CheckLevel.WARNING);
            this.options_.setExtractPrototypeMemberDeclarations(true);
            this.options_.setRemoveUnusedPrototypeProperties(true);
            this.options_.setRemoveUnusedPrototypePropertiesInExterns(true);
            this.options_.setRemoveUnusedClassProperties(true);
            this.options_.setRemoveUnusedVars(true);
            this.options_.setRemoveUnusedLocalVars(true);
            this.options_.setCollapseVariableDeclarations(true);
            this.options_.setCollapseAnonymousFunctions(true);
            this.options_.setAliasAllStrings(true);
            this.options_.setConvertToDottedProperties(true);
            this.options_.setRewriteFunctionExpressions(true);
            this.options_.setOptimizeParameters(true);
            this.options_.setOptimizeReturns(true);
            this.options_.setOptimizeCalls(true);
            this.options_.setOptimizeArgumentsArray(true);
            this.options_.setWarningLevel(DiagnosticGroups.ACCESS_CONTROLS, CheckLevel.WARNING);
            this.options_.setWarningLevel(DiagnosticGroups.CONST, CheckLevel.WARNING);
            this.options_.setWarningLevel(DiagnosticGroups.CONSTANT_PROPERTY, CheckLevel.WARNING);
            this.options_.setWarningLevel(DiagnosticGroups.STRICT_MODULE_DEP_CHECK, CheckLevel.WARNING);
            this.options_.setWarningLevel(DiagnosticGroups.VISIBILITY, CheckLevel.WARNING);
            this.options_.setWarningLevel(DiagnosticGroups.DEPRECATED, CheckLevel.OFF);
            this.options_.setWarningLevel(DiagnosticGroups.AMBIGUOUS_FUNCTION_DECL, CheckLevel.WARNING);
            this.options_.setWarningLevel(DiagnosticGroups.CHECK_EVENTFUL_OBJECT_DISPOSAL, CheckLevel.WARNING);
            this.options_.setWarningLevel(DiagnosticGroups.MISSING_PROVIDE, CheckLevel.WARNING);
            this.options_.setWarningLevel(DiagnosticGroups.CHECK_REGEXP, CheckLevel.WARNING);
            this.options_.setWarningLevel(DiagnosticGroups.CHECK_TYPES, CheckLevel.WARNING);
            this.options_.setWarningLevel(DiagnosticGroups.CHECK_USELESS_CODE, CheckLevel.WARNING);
            this.options_.setWarningLevel(DiagnosticGroups.CHECK_VARIABLES, CheckLevel.WARNING);
            this.options_.setWarningLevel(DiagnosticGroups.DEBUGGER_STATEMENT_PRESENT, CheckLevel.WARNING);
            this.options_.setWarningLevel(DiagnosticGroups.DUPLICATE_MESSAGE, CheckLevel.WARNING);
            this.options_.setWarningLevel(DiagnosticGroups.DUPLICATE_VARS, CheckLevel.WARNING);
            this.options_.setWarningLevel(DiagnosticGroups.ES3, CheckLevel.WARNING);
            this.options_.setWarningLevel(DiagnosticGroups.ES5_STRICT, CheckLevel.WARNING);
            this.options_.setWarningLevel(DiagnosticGroups.EXTERNS_VALIDATION, CheckLevel.WARNING);
            this.options_.setWarningLevel(DiagnosticGroups.GLOBAL_THIS, CheckLevel.WARNING);
            this.options_.setWarningLevel(DiagnosticGroups.FILEOVERVIEW_JSDOC, CheckLevel.WARNING);
            this.options_.setWarningLevel(DiagnosticGroups.INTERNET_EXPLORER_CHECKS, CheckLevel.WARNING);
            this.options_.setWarningLevel(DiagnosticGroups.INVALID_CASTS, CheckLevel.WARNING);
            this.options_.setWarningLevel(DiagnosticGroups.LINT_CHECKS, CheckLevel.OFF);
            this.options_.setWarningLevel(DiagnosticGroups.MISPLACED_TYPE_ANNOTATION, CheckLevel.WARNING);
            this.options_.setWarningLevel(DiagnosticGroups.MISSING_PROPERTIES, CheckLevel.WARNING);
            this.options_.setWarningLevel(DiagnosticGroups.MISSING_PROVIDE, CheckLevel.WARNING);
            this.options_.setWarningLevel(DiagnosticGroups.MISSING_REQUIRE, CheckLevel.WARNING);
            this.options_.setWarningLevel(DiagnosticGroups.MISSING_RETURN, CheckLevel.WARNING);
            this.options_.setWarningLevel(DiagnosticGroups.NEW_CHECK_TYPES, CheckLevel.WARNING);
            this.options_.setWarningLevel(DiagnosticGroups.NON_STANDARD_JSDOC, CheckLevel.WARNING);
            this.options_.setWarningLevel(DiagnosticGroups.REPORT_UNKNOWN_TYPES, CheckLevel.OFF);
            this.options_.setWarningLevel(DiagnosticGroups.SUSPICIOUS_CODE, CheckLevel.WARNING);
            this.options_.setWarningLevel(DiagnosticGroups.TWEAKS, CheckLevel.WARNING);
            this.options_.setWarningLevel(DiagnosticGroups.TYPE_INVALIDATION, CheckLevel.WARNING);
            this.options_.setWarningLevel(DiagnosticGroups.UNDEFINED_NAMES, CheckLevel.WARNING);
            this.options_.setWarningLevel(DiagnosticGroups.UNDEFINED_VARIABLES, CheckLevel.WARNING);
            this.options_.setWarningLevel(DiagnosticGroups.UNKNOWN_DEFINES, CheckLevel.WARNING);
            this.options_.setWarningLevel(DiagnosticGroups.UNNECESSARY_CASTS, CheckLevel.OFF);
            this.options_.setWarningLevel(DiagnosticGroups.USE_OF_GOOG_BASE, CheckLevel.WARNING);
            this.options_.setWarningLevel(DiagnosticGroups.VIOLATED_MODULE_DEP, CheckLevel.WARNING);
        }
        this.options_.sourceMapFormat = SourceMap.Format.V3;
        this.options_.sourceMapOutputPath = sourceMapPath + ".map";
    }
}

