/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.targets;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.flex.compiler.driver.js.IJSApplication;
import org.apache.flex.compiler.exceptions.BuildCanceledException;
import org.apache.flex.compiler.internal.codegen.js.JSSharedData;
import org.apache.flex.compiler.internal.driver.js.JSApplication;
import org.apache.flex.compiler.internal.projects.CompilerProject;
import org.apache.flex.compiler.internal.targets.Target;
import org.apache.flex.compiler.problems.ICompilerProblem;
import org.apache.flex.compiler.projects.IASProject;
import org.apache.flex.compiler.targets.IJSTarget;
import org.apache.flex.compiler.targets.ITarget;
import org.apache.flex.compiler.targets.ITargetProgressMonitor;
import org.apache.flex.compiler.targets.ITargetReport;
import org.apache.flex.compiler.targets.ITargetSettings;
import org.apache.flex.compiler.units.ICompilationUnit;

public class JSTarget
extends Target
implements IJSTarget {
    protected ICompilationUnit mainCU;
    protected Target.RootedCompilationUnits rootedCompilationUnits;

    public JSTarget(IASProject project, ITargetSettings targetSettings, ITargetProgressMonitor progressMonitor) {
        super((CompilerProject)project, targetSettings, progressMonitor);
    }

    public ITarget.TargetType getTargetType() {
        return null;
    }

    protected ITargetReport computeTargetReport() throws InterruptedException {
        return null;
    }

    protected Target.RootedCompilationUnits computeRootedCompilationUnits() throws InterruptedException {
        if (this.mainCU != null) {
            return new Target.RootedCompilationUnits((Set)ImmutableSet.of((Object)this.mainCU), Collections.emptyList());
        }
        return new Target.RootedCompilationUnits(Collections.emptySet(), Collections.emptyList());
    }

    public Target.RootedCompilationUnits getRootedCompilationUnits() throws InterruptedException {
        if (this.rootedCompilationUnits == null) {
            this.rootedCompilationUnits = this.computeRootedCompilationUnits();
        }
        return this.rootedCompilationUnits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IJSApplication build(Collection<ICompilerProblem> problems) {
        this.buildStarted();
        try {
            IJSApplication application;
            Iterable fatalProblems = this.getFatalProblems();
            if (!Iterables.isEmpty((Iterable)fatalProblems)) {
                Iterables.addAll(problems, (Iterable)fatalProblems);
                IJSApplication iJSApplication = null;
                return iJSApplication;
            }
            HashSet<ICompilationUnit> compilationUnitSet = new HashSet<ICompilationUnit>();
            Target.RootedCompilationUnits rootedCompilationUnits = this.getRootedCompilationUnits();
            Iterables.addAll(problems, (Iterable)rootedCompilationUnits.getProblems());
            compilationUnitSet.addAll(rootedCompilationUnits.getUnits());
            this.buildAndCollectProblems(compilationUnitSet, problems);
            List reachableCompilationUnits = this.project.getReachableCompilationUnitsInSWFOrder((Collection)rootedCompilationUnits.getUnits());
            IJSApplication iJSApplication = application = this.initializeApplication(reachableCompilationUnits);
            return iJSApplication;
        }
        catch (BuildCanceledException bce) {
            IJSApplication iJSApplication = null;
            return iJSApplication;
        }
        catch (InterruptedException ie) {
            IJSApplication iJSApplication = null;
            return iJSApplication;
        }
        finally {
            this.buildFinished();
        }
    }

    protected IJSApplication initializeApplication(List<ICompilationUnit> reachableCompilationUnits) {
        JSApplication result = new JSApplication();
        return result;
    }

    protected void buildAndCollectProblems(Set<ICompilationUnit> compilationUnits, Collection<ICompilerProblem> problems) throws InterruptedException {
        JSSharedData sharedData = JSSharedData.instance;
        sharedData.beginCodeGen();
        Target.BuiltCompilationUnitSet builtCompilationUnits = this.getBuiltCompilationUnitSet();
        ICompilationUnit rootCU = this.getRootClassCompilationUnit();
        compilationUnits.clear();
        compilationUnits.add(rootCU);
        Iterables.addAll(problems, (Iterable)builtCompilationUnits.problems);
        sharedData.endCodeGen();
    }

    private ICompilationUnit getRootClassCompilationUnit() {
        String rootClassFileName = this.targetSettings.getRootSourceFileName();
        if (rootClassFileName == null) {
            return null;
        }
        Collection rootClassCompilationUnits = this.project.getCompilationUnits(rootClassFileName);
        assert (rootClassCompilationUnits.size() == 1) : "There must only be a single compilation unit for the root source file!";
        return (ICompilationUnit)Iterables.getOnlyElement((Iterable)rootClassCompilationUnits);
    }

    public IJSApplication build(ICompilationUnit unit, Collection<ICompilerProblem> problems) {
        this.mainCU = unit;
        return this.build(problems);
    }
}

