/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.targets;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.flex.compiler.css.ICSSDocument;
import org.apache.flex.compiler.css.ICSSManager;
import org.apache.flex.compiler.internal.css.codegen.CSSCompilationSession;
import org.apache.flex.compiler.internal.css.semantics.ActivatedStyleSheets;
import org.apache.flex.compiler.internal.driver.js.flexjs.JSCSSCompilationSession;
import org.apache.flex.compiler.internal.projects.FlexJSProject;
import org.apache.flex.compiler.internal.targets.JSTarget;
import org.apache.flex.compiler.internal.targets.Target;
import org.apache.flex.compiler.problems.FileNotFoundProblem;
import org.apache.flex.compiler.problems.ICompilerProblem;
import org.apache.flex.compiler.projects.IASProject;
import org.apache.flex.compiler.targets.IJSTarget;
import org.apache.flex.compiler.targets.ITargetProgressMonitor;
import org.apache.flex.compiler.targets.ITargetSettings;
import org.apache.flex.compiler.units.ICompilationUnit;

public class FlexJSTarget
extends JSTarget
implements IJSTarget {
    private final FlexJSProject flexProject;

    public FlexJSTarget(IASProject project, ITargetSettings targetSettings, ITargetProgressMonitor progressMonitor) {
        super(project, targetSettings, progressMonitor);
        this.flexProject = (FlexJSProject)project;
    }

    protected Set<ICompilationUnit> findAllCompilationUnitsToLink(Collection<ICompilationUnit> compilationUnits, Collection<ICompilerProblem> problems) throws InterruptedException {
        JSCSSCompilationSession cssCompilationSession = (JSCSSCompilationSession)this.flexProject.getCSSCompilationSession();
        cssCompilationSession.setKeepAllTypeSelectors(this.targetSettings.keepAllTypeSelectors());
        for (ICompilationUnit cu : compilationUnits) {
            cu.startBuildAsync(this.getTargetType());
        }
        assert (compilationUnits != null) : "compilation units can't be null";
        assert (problems != null) : "problems can't be null";
        HashSet<ICompilationUnit> allCompilationUnitsInTarget = new HashSet<ICompilationUnit>(compilationUnits);
        ActivatedStyleSheets activatedStyleSheets = new ActivatedStyleSheets();
        ICSSManager cssManager = this.flexProject.getCSSManager();
        this.collectThemes(cssManager, activatedStyleSheets, problems);
        this.collectDefaultCSS(cssManager, activatedStyleSheets, problems);
        boolean done = false;
        while (!done) {
            Set dependencies = this.getDependentCompilationUnits(allCompilationUnitsInTarget, problems);
            allCompilationUnitsInTarget.addAll(dependencies);
            Map<ICSSDocument, File> activatedDefaultCSSList = FlexJSTarget.getAllDefaultCSS(cssManager, allCompilationUnitsInTarget);
            for (Map.Entry<ICSSDocument, File> entry : activatedDefaultCSSList.entrySet()) {
                activatedStyleSheets.addLibraryCSS(entry.getKey(), entry.getValue().getAbsolutePath());
            }
            ImmutableList definitions = Target.getAllExternallyVisibleDefinitions(allCompilationUnitsInTarget);
            HashSet cssDependencies = new HashSet();
            for (ICSSDocument cssDocument : activatedStyleSheets.all()) {
                Collection dependentCUListFromCSS = cssManager.getDependentCompilationUnitsFromCSS((CSSCompilationSession)cssCompilationSession, cssDocument, (Collection)definitions, problems);
                cssDependencies.addAll(dependentCUListFromCSS);
            }
            done = !allCompilationUnitsInTarget.addAll(cssDependencies);
        }
        cssCompilationSession.cssDocuments.addAll(0, activatedStyleSheets.sort());
        return super.findAllCompilationUnitsToLink(compilationUnits, problems);
    }

    private void collectThemes(ICSSManager cssManager, ActivatedStyleSheets activatedStyleSheets, Collection<ICompilerProblem> problems) {
        Collection cssFromThemes = cssManager.getCSSFromThemes(problems);
        for (ICSSDocument themeCSS : cssFromThemes) {
            activatedStyleSheets.addThemeCSS(themeCSS);
        }
    }

    private void collectDefaultCSS(ICSSManager cssManager, ActivatedStyleSheets activatedStyleSheets, Collection<ICompilerProblem> problems) {
        for (String defaultsCSSPath : this.getTargetSettings().getDefaultsCSSFiles()) {
            ICSSDocument defaultsCSSModel = cssManager.getCSS(defaultsCSSPath);
            if (defaultsCSSModel == null) {
                problems.add((ICompilerProblem)new FileNotFoundProblem(defaultsCSSPath));
                continue;
            }
            activatedStyleSheets.addDefaultCSS(defaultsCSSModel);
        }
    }

    private static Map<ICSSDocument, File> getAllDefaultCSS(ICSSManager cssManager, Collection<ICompilationUnit> compilationUnits) {
        assert (cssManager != null) : "Expected CSS manager.";
        assert (compilationUnits != null) : "Expected collection of compilation units.";
        HashMap<ICSSDocument, File> result = new HashMap<ICSSDocument, File>();
        for (ICompilationUnit compilationUnit : compilationUnits) {
            File swcFile;
            ICSSDocument defaultCSS;
            if (compilationUnit.getCompilationUnitType() != ICompilationUnit.UnitType.SWC_UNIT || (defaultCSS = cssManager.getDefaultCSS(swcFile = new File(compilationUnit.getAbsoluteFilename()))) == null) continue;
            result.put(defaultCSS, swcFile);
        }
        return result;
    }
}

