/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.targets;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.flex.compiler.common.XMLName;
import org.apache.flex.compiler.definitions.IDefinition;
import org.apache.flex.compiler.definitions.references.IResolvedQualifiersReference;
import org.apache.flex.compiler.definitions.references.ReferenceFactory;
import org.apache.flex.compiler.internal.projects.FlexJSProject;
import org.apache.flex.compiler.internal.projects.SourcePathManager;
import org.apache.flex.compiler.internal.targets.JSTarget;
import org.apache.flex.compiler.internal.targets.Target;
import org.apache.flex.compiler.problems.ICompilerProblem;
import org.apache.flex.compiler.problems.NoCompilationUnitForDefinitionProblem;
import org.apache.flex.compiler.problems.NoSourceForClassInNamespaceProblem;
import org.apache.flex.compiler.problems.NoSourceForClassProblem;
import org.apache.flex.compiler.projects.IASProject;
import org.apache.flex.compiler.projects.ICompilerProject;
import org.apache.flex.compiler.targets.IJSTarget;
import org.apache.flex.compiler.targets.ITargetProgressMonitor;
import org.apache.flex.compiler.targets.ITargetSettings;
import org.apache.flex.compiler.units.ICompilationUnit;
import org.apache.flex.compiler.workspaces.IWorkspace;

public class FlexJSSWCTarget
extends JSTarget
implements IJSTarget {
    protected ICompilationUnit mainCU;
    protected Target.RootedCompilationUnits rootedCompilationUnits;
    private FlexJSProject flexProject;

    public FlexJSSWCTarget(IASProject project, ITargetSettings targetSettings, ITargetProgressMonitor progressMonitor) {
        super(project, targetSettings, progressMonitor);
        this.flexProject = (FlexJSProject)project;
    }

    @Override
    protected Target.RootedCompilationUnits computeRootedCompilationUnits() throws InterruptedException {
        HashSet<ICompilationUnit> rootCompilationUnits = new HashSet<ICompilationUnit>();
        Collection includedSourceFiles = this.targetSettings.getIncludeSources();
        ImmutableSet includeClassNameSet = ImmutableSet.copyOf((Collection)this.targetSettings.getIncludeClasses());
        ImmutableSet includedNamespaces = ImmutableSet.copyOf((Collection)this.targetSettings.getIncludeNamespaces());
        ArrayList<ICompilerProblem> problems = new ArrayList<ICompilerProblem>();
        Collection<ICompilationUnit> includeNamespaceUnits = this.getCompilationUnitsForIncludedNamespaces((Collection<String>)includedNamespaces, problems);
        rootCompilationUnits.addAll(includeNamespaceUnits);
        rootCompilationUnits.addAll(this.getCompilationUnitsFromClassNames(null, (Collection<String>)includeClassNameSet, problems));
        for (File includedSourceFileName : includedSourceFiles) {
            Collection<ICompilationUnit> compilationUnitsForFile = this.project.getWorkspace().getCompilationUnits(includedSourceFileName.getAbsolutePath(), (ICompilerProject)this.project);
            if (compilationUnitsForFile.size() > 1) {
                compilationUnitsForFile = this.filterUnitsBasedOnSourcePath(compilationUnitsForFile);
            }
            for (ICompilationUnit cu : compilationUnitsForFile) {
                if (!cu.getAbsoluteFilename().equals(includedSourceFileName.getAbsolutePath())) continue;
                rootCompilationUnits.add(cu);
            }
        }
        for (ICompilationUnit rbCompUnit : this.getIncludedResourceBundlesCompilationUnits(problems)) {
            rootCompilationUnits.add(rbCompUnit);
        }
        rootCompilationUnits.addAll(this.getIncludesCompilationUnits());
        rootCompilationUnits.addAll(this.getIncludeLibrariesCompilationUnits());
        return new Target.RootedCompilationUnits(rootCompilationUnits, problems);
    }

    private Collection<ICompilationUnit> filterUnitsBasedOnSourcePath(Collection<ICompilationUnit> compilationUnitsForFile) throws InterruptedException {
        ArrayList<ICompilationUnit> sourcePathUnits = new ArrayList<ICompilationUnit>(compilationUnitsForFile);
        boolean foundHighestPriorityUnit = false;
        block0: for (File sourcePath : this.flexProject.getSourcePath()) {
            for (ICompilationUnit unit : sourcePathUnits) {
                String computedQname;
                String unitQname;
                List qnames;
                ICompilationUnit.UnitType unitType = unit.getCompilationUnitType();
                if (unitType != ICompilationUnit.UnitType.AS_UNIT && unitType != ICompilationUnit.UnitType.FXG_UNIT && unitType != ICompilationUnit.UnitType.MXML_UNIT && unitType != ICompilationUnit.UnitType.CSS_UNIT || (qnames = unit.getQualifiedNames()).size() > 1 || !(unitQname = qnames.isEmpty() ? "" : (String)qnames.iterator().next()).equals(computedQname = SourcePathManager.computeQName((File)sourcePath, (File)new File(unit.getAbsoluteFilename())))) continue;
                if (foundHighestPriorityUnit) {
                    compilationUnitsForFile.remove(unit);
                }
                foundHighestPriorityUnit = true;
                continue block0;
            }
        }
        return compilationUnitsForFile;
    }

    private Collection<ICompilationUnit> getCompilationUnitsForIncludedNamespaces(Collection<String> namespaces, Collection<ICompilerProblem> problems) throws InterruptedException {
        HashSet<ICompilationUnit> allUnits = new HashSet<ICompilationUnit>();
        for (String namespace : namespaces) {
            Collection includeNamespaceQualifiedNames = this.flexProject.getQualifiedClassNamesForManifestNamespaces(Collections.singleton(namespace));
            Collection<ICompilationUnit> units = this.getCompilationUnitsFromClassNames(namespace, includeNamespaceQualifiedNames, problems);
            this.validateIncludeNamespaceEntries(namespace, units, problems);
            allUnits.addAll(units);
        }
        return allUnits;
    }

    private void validateIncludeNamespaceEntries(String namespace, Collection<ICompilationUnit> units, Collection<ICompilerProblem> problems) throws InterruptedException {
        block0: for (ICompilationUnit unit : units) {
            List classNames = unit.getQualifiedNames();
            String className = (String)classNames.get(classNames.size() - 1);
            Collection xmlNames = this.flexProject.getTagNamesForClass(className);
            for (XMLName xmlName : xmlNames) {
                if (!namespace.equals(xmlName.getXMLNamespace())) continue;
                if (this.flexProject.isManifestComponentLookupOnly(xmlName) || unit.getCompilationUnitType() != ICompilationUnit.UnitType.SWC_UNIT) continue block0;
                problems.add((ICompilerProblem)new NoSourceForClassInNamespaceProblem(namespace, className));
                continue block0;
            }
        }
    }

    private Collection<ICompilationUnit> getCompilationUnitsFromClassNames(String namespace, Collection<String> classNames, Collection<ICompilerProblem> problems) {
        ArrayList<String> compilableClassNames = new ArrayList<String>();
        for (String className : classNames) {
            Collection tagNames = this.flexProject.getTagNamesForClass(className);
            boolean okToAdd = true;
            for (XMLName tagName : tagNames) {
                if (!this.flexProject.isManifestComponentLookupOnly(tagName)) continue;
                okToAdd = false;
            }
            if (!okToAdd) continue;
            compilableClassNames.add(className);
        }
        Iterable references = Iterables.transform(compilableClassNames, (Function)new Function<String, IResolvedQualifiersReference>(){

            public IResolvedQualifiersReference apply(String qualifiedName) {
                return ReferenceFactory.packageQualifiedReference((IWorkspace)FlexJSSWCTarget.this.project.getWorkspace(), (String)qualifiedName, (boolean)true);
            }
        });
        LinkedList<ICompilationUnit> units = new LinkedList<ICompilationUnit>();
        for (IResolvedQualifiersReference reference : references) {
            IDefinition def = reference.resolve((ICompilerProject)this.flexProject);
            if (def == null) {
                if (namespace == null) {
                    problems.add((ICompilerProblem)new NoSourceForClassProblem(reference.getDisplayString()));
                    continue;
                }
                problems.add((ICompilerProblem)new NoSourceForClassInNamespaceProblem(namespace, reference.getDisplayString()));
                continue;
            }
            ICompilationUnit defCU = this.project.getScope().getCompilationUnitForDefinition(def);
            if (defCU == null) {
                problems.add((ICompilerProblem)new NoCompilationUnitForDefinitionProblem(def.getBaseName()));
                continue;
            }
            units.add(defCU);
        }
        return units;
    }
}

