/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.graph;

import com.google.common.io.Files;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Scanner;
import org.apache.commons.io.FileUtils;
import org.apache.flex.compiler.clients.problems.ProblemQuery;
import org.apache.flex.compiler.internal.codegen.js.goog.JSGoogEmitterTokens;
import org.apache.flex.compiler.internal.driver.js.goog.JSGoogConfiguration;
import org.apache.flex.compiler.problems.FileNotFoundProblem;
import org.apache.flex.compiler.problems.ICompilerProblem;

public class VF2JSDepsWriter {
    private ProblemQuery problems;
    private String outputFolderPath;
    private String mainName;
    private List<String> otherPaths;
    private boolean problemsFound = false;
    private HashMap<String, GoogDep> depMap = new HashMap();
    public ArrayList<String> filePathsInOrder = new ArrayList();
    public ArrayList<String> additionalHTML = new ArrayList();
    private HashMap<String, GoogDep> visited = new HashMap();

    public VF2JSDepsWriter(File outputFolder, String mainClassName, JSGoogConfiguration config) {
        this.outputFolderPath = outputFolder.getAbsolutePath();
        this.mainName = mainClassName;
        this.otherPaths = config.getSDKJSLib();
    }

    public ArrayList<String> getListOfFiles() throws InterruptedException {
        this.buildDB();
        ArrayList<GoogDep> dps = this.sort(this.mainName);
        ArrayList<String> files = new ArrayList<String>();
        for (GoogDep gd : dps) {
            files.add(gd.filePath);
        }
        return files;
    }

    public boolean generateDeps(ProblemQuery problems, StringBuilder depsFileData) throws InterruptedException, FileNotFoundException {
        this.problemsFound = false;
        this.problems = problems;
        this.buildDB();
        ArrayList<GoogDep> dps = this.sort(this.mainName);
        String outString = "// generated by FalconJS\n";
        int n = dps.size();
        for (int i = n - 1; i >= 0; --i) {
            GoogDep gd = dps.get(i);
            if (this.isGoogClass(gd.className)) continue;
            String s = "goog.addDependency('";
            s = s + this.relativePath(gd.filePath);
            s = s + "', ['";
            s = s + gd.className;
            s = s + "'], [";
            s = s + this.getDependencies(gd.deps);
            s = s + "]);\n";
            outString = outString + s;
        }
        depsFileData.append(outString);
        return !this.problemsFound;
    }

    private boolean isGoogClass(String className) {
        return className.startsWith("goog.");
    }

    private void buildDB() {
        this.addDeps(this.mainName);
    }

    private ArrayList<GoogDep> sort(String rootClassName) {
        ArrayList<GoogDep> arr = new ArrayList<GoogDep>();
        GoogDep current = this.depMap.get(rootClassName);
        this.sortFunction(current, arr);
        return arr;
    }

    private void sortFunction(GoogDep current, ArrayList<GoogDep> arr) {
        this.visited.put(current.className, current);
        this.filePathsInOrder.add(current.filePath);
        System.out.println("Dependencies calculated for '" + current.filePath + "'");
        ArrayList<String> deps = current.deps;
        for (String className : deps) {
            if (this.visited.containsKey(className) || this.isGoogClass(className)) continue;
            GoogDep gd = this.depMap.get(className);
            this.sortFunction(gd, arr);
        }
        arr.add(current);
    }

    private void addDeps(String className) {
        if (this.depMap.containsKey(className) || this.isGoogClass(className)) {
            return;
        }
        GoogDep gd = new GoogDep();
        gd.className = className;
        gd.filePath = this.getFilePath(className);
        this.depMap.put(gd.className, gd);
        ArrayList<String> deps = this.getDirectDependencies(gd.filePath);
        gd.deps = new ArrayList();
        ArrayList<String> circulars = new ArrayList<String>();
        for (String dep : deps) {
            if (this.depMap.containsKey(dep) && !this.isGoogClass(dep)) {
                circulars.add(dep);
                continue;
            }
            gd.deps.add(dep);
        }
        for (String dep : deps) {
            this.addDeps(dep);
        }
        if (circulars.size() > 0) {
            try {
                List fileLines = Files.readLines((File)new File(gd.filePath), (Charset)Charset.defaultCharset());
                ArrayList<String> finalLines = new ArrayList<String>();
                for (String line : fileLines) {
                    int c2;
                    String s;
                    int c = line.indexOf("goog.require");
                    if (c > -1 && circulars.contains(s = line.substring(c + 14, (c2 = line.indexOf(")")) - 1))) continue;
                    finalLines.add(line);
                }
                File file = new File(gd.filePath);
                PrintWriter out = new PrintWriter(new FileWriter(file));
                for (String s : finalLines) {
                    out.println(s);
                }
                out.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    String getBaseClass(List<String> lines, String className) {
        int n = lines.size();
        for (int i = 0; i < n; ++i) {
            int c2;
            String line = lines.get(i);
            int c = line.indexOf("goog.inherits");
            if (c <= -1) continue;
            String inheritLine = "";
            while (true) {
                inheritLine = inheritLine + line;
                c2 = line.indexOf(")");
                if (c2 > -1) break;
                line = lines.get(++i);
            }
            c = inheritLine.indexOf(",");
            c2 = inheritLine.indexOf(")");
            return inheritLine.substring(c + 1, c2).trim();
        }
        return null;
    }

    String getFilePath(String className) {
        String classPath = className.replace(".", File.separator);
        String fn = this.outputFolderPath + File.separator + classPath + ".js";
        File f = new File(fn);
        if (f.exists()) {
            return fn;
        }
        for (String otherPath : this.otherPaths) {
            fn = otherPath + File.separator + classPath + ".js";
            f = new File(fn);
            if (!f.exists()) continue;
            fn = this.outputFolderPath + File.separator + classPath + ".js";
            File destFile = new File(fn);
            try {
                File assetsDir;
                FileUtils.copyFile((File)f, (File)destFile);
                if (className.indexOf("org.apache.flex") > -1 && (assetsDir = new File(f.getParentFile(), "assets")).exists()) {
                    String nameOfClass = className.substring(className.lastIndexOf(46) + 1);
                    File[] assetsList = assetsDir.listFiles();
                    for (int i = 0; i < assetsList.length; ++i) {
                        File assetFile = assetsList[i];
                        String assetFileName = assetFile.getName();
                        if (!assetFile.isFile() || assetFileName.indexOf(nameOfClass) != 0) continue;
                        String pathOfClass = "";
                        pathOfClass = className.substring(0, className.lastIndexOf(46));
                        pathOfClass = pathOfClass.replace(".", File.separator);
                        destFile = new File(this.outputFolderPath + File.separator + pathOfClass + File.separator + "assets" + File.separator + assetFileName);
                        FileUtils.copyFile((File)assetFile, (File)destFile);
                        destFile = new File(this.outputFolderPath.replace("js-debug", "js-release") + File.separator + pathOfClass + File.separator + "assets" + File.separator + assetFileName);
                        FileUtils.copyFile((File)assetFile, (File)destFile);
                        System.out.println("Copied assets of the '" + nameOfClass + "' class");
                    }
                }
            }
            catch (IOException e) {
                System.out.println("Error copying file for class: " + className);
            }
            return fn;
        }
        System.out.println("Could not find file for class: " + className);
        this.problems.add((ICompilerProblem)new FileNotFoundProblem(className));
        this.problemsFound = true;
        return "";
    }

    private ArrayList<String> getDirectDependencies(String fn) {
        ArrayList<String> deps = new ArrayList<String>();
        try {
            String s;
            FileInputStream fis = new FileInputStream(fn);
            Scanner scanner = new Scanner((InputStream)fis, "UTF-8");
            boolean inInjectHTML = false;
            while (scanner.hasNextLine() && (s = scanner.nextLine()).indexOf("goog.inherits") <= -1) {
                int c;
                if (inInjectHTML && (c = s.indexOf("</inject_html>")) > -1) {
                    inInjectHTML = false;
                    continue;
                }
                if (inInjectHTML) {
                    this.additionalHTML.add(s);
                    continue;
                }
                c = s.indexOf(JSGoogEmitterTokens.GOOG_REQUIRE.getToken());
                if (c > -1) {
                    int c2 = s.indexOf(")");
                    s = s.substring(c + 14, c2 - 1);
                    deps.add(s);
                }
                if ((c = s.indexOf("<inject_html>")) <= -1) continue;
                inInjectHTML = true;
            }
            scanner.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        return deps;
    }

    private String getDependencies(ArrayList<String> deps) {
        String s = "";
        for (String dep : deps) {
            if (s.length() > 0) {
                s = s + ", ";
            }
            s = s + "'" + dep + "'";
        }
        return s;
    }

    String relativePath(String path) {
        if (path.indexOf(this.outputFolderPath) == 0) {
            path = path.replace(this.outputFolderPath, "../../..");
        } else {
            for (String otherPath : this.otherPaths) {
                if (path.indexOf(otherPath) != 0) continue;
                path = path.replace(otherPath, "../../..");
            }
        }
        path = path.replace('\\', '/');
        return path;
    }

    private class GoogDep {
        public String filePath;
        public String className;
        public ArrayList<String> deps;

        private GoogDep() {
        }
    }
}

