/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.graph;

import com.google.common.io.Files;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.flex.compiler.clients.problems.ProblemQuery;
import org.apache.flex.compiler.internal.codegen.js.goog.JSGoogEmitterTokens;
import org.apache.flex.compiler.internal.driver.js.goog.JSGoogConfiguration;
import org.apache.flex.compiler.problems.FileNotFoundProblem;
import org.apache.flex.compiler.problems.ICompilerProblem;
import org.apache.flex.swc.ISWC;
import org.apache.flex.swc.ISWCFileEntry;

public class GoogDepsWriter {
    private ProblemQuery problems;
    private String outputFolderPath;
    private String mainName;
    private List<String> otherPaths;
    private List<ISWC> swcs;
    private boolean removeCirculars = false;
    private boolean problemsFound = false;
    private ArrayList<GoogDep> dps;
    private HashMap<String, GoogDep> depMap = new HashMap();
    private HashMap<String, String> requireMap = new HashMap();
    public ArrayList<String> filePathsInOrder = new ArrayList();
    public ArrayList<String> additionalHTML = new ArrayList();
    private HashMap<String, GoogDep> visited = new HashMap();

    public GoogDepsWriter(File outputFolder, String mainClassName, JSGoogConfiguration config, List<ISWC> swcs) {
        this.outputFolderPath = outputFolder.getAbsolutePath();
        this.mainName = mainClassName;
        this.removeCirculars = config.getRemoveCirculars();
        this.otherPaths = config.getSDKJSLib();
        this.otherPaths.add(new File(outputFolder.getParent(), "flexjs/FlexJS/src").getPath());
        this.swcs = swcs;
        for (ISWC swc : swcs) {
            System.out.println("using SWC: " + swc.getSWCFile().getAbsolutePath());
        }
    }

    public ArrayList<String> getListOfFiles(ProblemQuery problems) throws InterruptedException {
        this.problemsFound = false;
        this.problems = problems;
        if (this.dps == null) {
            this.buildDB();
            this.dps = this.sort(this.mainName);
        }
        ArrayList<String> files = new ArrayList<String>();
        for (GoogDep gd : this.dps) {
            files.add(gd.filePath);
        }
        return files;
    }

    public boolean generateDeps(ProblemQuery problems, StringBuilder depsFileData) throws InterruptedException, FileNotFoundException {
        this.problemsFound = false;
        this.problems = problems;
        if (this.dps == null) {
            this.buildDB();
            this.dps = this.sort(this.mainName);
        }
        String outString = "// generated by FalconJX\n";
        int n = this.dps.size();
        for (int i = n - 1; i >= 0; --i) {
            GoogDep gd = this.dps.get(i);
            if (this.isGoogClass(gd.className)) continue;
            String s = "goog.addDependency('";
            s = s + this.relativePath(gd.filePath);
            s = s + "', ['";
            s = s + gd.className;
            s = s + "'], [";
            s = s + this.getDependencies(gd.deps);
            s = s + "]);\n";
            outString = outString + s;
        }
        depsFileData.append(outString);
        return !this.problemsFound;
    }

    private boolean isGoogClass(String className) {
        return className.startsWith("goog.");
    }

    private void buildDB() {
        this.addDeps(this.mainName);
    }

    private ArrayList<GoogDep> sort(String rootClassName) {
        ArrayList<GoogDep> arr = new ArrayList<GoogDep>();
        GoogDep current = this.depMap.get(rootClassName);
        this.sortFunction(current, arr);
        return arr;
    }

    private void sortFunction(GoogDep current, ArrayList<GoogDep> arr) {
        this.visited.put(current.className, current);
        this.filePathsInOrder.add(current.filePath);
        if (this.removeCirculars) {
            this.removeCirculars(current);
        }
        System.out.println("Dependencies calculated for '" + current.filePath + "'");
        ArrayList<String> deps = current.deps;
        for (String className : deps) {
            if (this.visited.containsKey(className) || this.isGoogClass(className)) continue;
            GoogDep gd = this.depMap.get(className);
            this.sortFunction(gd, arr);
        }
        arr.add(current);
    }

    private void addDeps(String className) {
        if (this.depMap.containsKey(className) || this.isGoogClass(className)) {
            return;
        }
        GoogDep gd = new GoogDep();
        gd.className = className;
        gd.filePath = this.getFilePath(className);
        if (gd.filePath.isEmpty()) {
            throw new RuntimeException("Unable to find JavaScript filePath for class: " + className);
        }
        this.depMap.put(gd.className, gd);
        try {
            FileInfo fi;
            List fileLines = Files.readLines((File)new File(gd.filePath), (Charset)Charset.defaultCharset());
            gd.fileInfo = fi = this.getFileInfo(fileLines, className);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ArrayList<String> deps = this.getDirectDependencies(gd.filePath);
        gd.deps = new ArrayList();
        for (String dep : deps) {
            if (gd.fileInfo.impls != null && gd.fileInfo.impls.contains(dep)) {
                if (!this.requireMap.containsKey(dep)) {
                    this.requireMap.put(dep, className);
                }
            } else if (this.depMap.containsKey(dep) && !this.isGoogClass(dep)) continue;
            gd.deps.add(dep);
        }
        for (String dep : deps) {
            this.addDeps(dep);
        }
    }

    void removeCirculars(GoogDep gd) {
        String className = gd.className;
        try {
            List fileLines = Files.readLines((File)new File(gd.filePath), (Charset)Charset.defaultCharset());
            ArrayList<String> finalLines = new ArrayList<String>();
            FileInfo fi = gd.fileInfo;
            int suppressCount = 0;
            int i = 0;
            for (String line : fileLines) {
                int c;
                if (i < fi.constructorLine && (c = line.indexOf(JSGoogEmitterTokens.GOOG_REQUIRE.getToken())) > -1) {
                    int c2 = line.indexOf(")");
                    String s = line.substring(c + 14, c2 - 1);
                    if (gd.fileInfo.impls == null || !gd.fileInfo.impls.contains(s)) {
                        if (this.requireMap.containsKey(s) && this.requireMap.get(s) != className) {
                            ++suppressCount;
                            System.out.println(gd.filePath + " removing circular (static): " + s);
                            continue;
                        }
                        if (!gd.deps.contains(s)) {
                            ++suppressCount;
                            System.out.println(gd.filePath + " removing circular: " + s);
                            continue;
                        }
                    }
                }
                finalLines.add(line);
                ++i;
            }
            if (suppressCount > 0) {
                if (fi.suppressLine > 0) {
                    if (fi.suppressLine < fi.constructorLine) {
                        String line = (String)finalLines.get(fi.suppressLine);
                        int c = line.indexOf("@suppress {");
                        if (c > -1) {
                            if (!line.contains("missingRequire")) {
                                line = line.substring(0, c) + "@suppress {missingRequire|" + line.substring(c + 11);
                                finalLines.remove(fi.suppressLine);
                                finalLines.add(fi.suppressLine, line);
                            }
                        } else {
                            System.out.println("Confused by @suppress in " + className);
                        }
                    } else if (fi.fileoverviewLine > -1) {
                        finalLines.add(fi.fileoverviewLine + 1, " *  @suppress {missingRequire}");
                    } else if (fi.googProvideLine > -1) {
                        finalLines.add(fi.googProvideLine, " */");
                        finalLines.add(fi.googProvideLine, " *  @suppress {missingRequire}");
                        finalLines.add(fi.googProvideLine, " *  @fileoverview");
                        finalLines.add(fi.googProvideLine, "/**");
                    } else {
                        System.out.println("Confused by @suppress in " + className);
                    }
                } else if (fi.fileoverviewLine > -1) {
                    finalLines.add(fi.fileoverviewLine + 1, " *  @suppress {missingRequire}");
                } else if (fi.googProvideLine > -1) {
                    finalLines.add(fi.googProvideLine, " */");
                    finalLines.add(fi.googProvideLine, " *  @suppress {missingRequire}");
                    finalLines.add(fi.googProvideLine, " *  @fileoverview");
                    finalLines.add(fi.googProvideLine, "/**");
                } else {
                    System.out.println("Confused by @suppress in " + className);
                }
            }
            File file = new File(gd.filePath);
            PrintWriter out = new PrintWriter(new FileWriter(file));
            for (String s : finalLines) {
                out.println(s);
            }
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    FileInfo getFileInfo(List<String> lines, String className) {
        int n;
        FileInfo fi = new FileInfo();
        fi.constructorLine = n = lines.size();
        fi.suppressLine = -1;
        fi.fileoverviewLine = -1;
        fi.googProvideLine = -1;
        for (int i = 0; i < n; ++i) {
            String impl;
            int c2;
            String line = lines.get(i);
            int c = line.indexOf("goog.inherits");
            if (c > -1) {
                String inheritLine = "";
                while (true) {
                    inheritLine = inheritLine + line;
                    c2 = line.indexOf(")");
                    if (c2 > -1) break;
                    line = lines.get(++i);
                }
                c = inheritLine.indexOf(",");
                c2 = inheritLine.indexOf(")");
                fi.inherits = inheritLine.substring(c + 1, c2).trim();
                return fi;
            }
            c = line.indexOf("@constructor");
            if (c > -1) {
                fi.constructorLine = i;
                continue;
            }
            c = line.indexOf("@interface");
            if (c > -1) {
                fi.constructorLine = i;
                continue;
            }
            c = line.indexOf("@suppress");
            if (c > -1) {
                fi.suppressLine = i;
                continue;
            }
            c = line.indexOf("@fileoverview");
            if (c > -1) {
                fi.fileoverviewLine = i;
                continue;
            }
            c = line.indexOf("goog.provide");
            if (c > -1) {
                fi.googProvideLine = i;
                continue;
            }
            c = line.indexOf("@implements");
            if (c > -1) {
                if (fi.impls == null) {
                    fi.impls = new ArrayList();
                }
                c2 = line.indexOf("}", c);
                impl = line.substring(c + 13, c2);
                fi.impls.add(impl);
                continue;
            }
            c = line.indexOf("@extends");
            if (c <= -1) continue;
            if (fi.impls == null) {
                fi.impls = new ArrayList();
            }
            c2 = line.indexOf("}", c);
            impl = line.substring(c + 10, c2);
            fi.impls.add(impl);
        }
        return fi;
    }

    String getFilePath(String className) {
        String fn;
        File f;
        String classPath = className.replace(".", File.separator);
        if (className.equals(this.mainName)) {
            classPath = className;
        }
        if ((f = new File(fn = this.outputFolderPath + File.separator + classPath + ".js")).exists()) {
            return fn;
        }
        for (String otherPath : this.otherPaths) {
            fn = otherPath + File.separator + classPath + ".js";
            f = new File(fn);
            if (!f.exists()) continue;
            fn = this.outputFolderPath + File.separator + classPath + ".js";
            File destFile = new File(fn);
            try {
                File assetsDir;
                FileUtils.copyFile((File)f, (File)destFile);
                if (className.contains("org.apache.flex") && (assetsDir = new File(f.getParentFile(), "assets")).exists()) {
                    String nameOfClass = className.substring(className.lastIndexOf(95) + 1);
                    File[] assetsList = assetsDir.listFiles();
                    assert (assetsList != null);
                    for (File assetFile : assetsList) {
                        String assetFileName = assetFile.getName();
                        if (!assetFile.isFile() || assetFileName.indexOf(nameOfClass) != 0) continue;
                        String pathOfClass = className.substring(0, className.lastIndexOf(95));
                        pathOfClass = pathOfClass.replace(".", File.separator);
                        destFile = new File(this.outputFolderPath + File.separator + pathOfClass + File.separator + "assets" + File.separator + assetFileName);
                        FileUtils.copyFile((File)assetFile, (File)destFile);
                        destFile = new File(this.outputFolderPath.replace("js-debug", "js-release") + File.separator + pathOfClass + File.separator + "assets" + File.separator + assetFileName);
                        FileUtils.copyFile((File)assetFile, (File)destFile);
                        System.out.println("Copied assets of the '" + nameOfClass + "' class");
                    }
                }
            }
            catch (IOException e) {
                System.out.println("Error copying file for class: " + className);
            }
            return fn;
        }
        String fwdClassPath = className.replace(".", "/");
        String bckClassPath = className.replace(".", "\\");
        for (ISWC swc : this.swcs) {
            ISWCFileEntry fileEntry = swc.getFile("js/src/" + fwdClassPath + ".js");
            if (fileEntry == null) {
                fileEntry = swc.getFile("js/out/" + fwdClassPath + ".js");
            }
            if (fileEntry == null) {
                fileEntry = swc.getFile("js/src/" + bckClassPath + ".js");
            }
            if (fileEntry == null) {
                fileEntry = swc.getFile("js/out/" + bckClassPath + ".js");
            }
            if (fileEntry == null) {
                fileEntry = swc.getFile("js\\src\\" + bckClassPath + ".js");
            }
            if (fileEntry == null) {
                fileEntry = swc.getFile("js\\out\\" + bckClassPath + ".js");
            }
            if (fileEntry == null) continue;
            fn = this.outputFolderPath + File.separator + classPath + ".js";
            File destFile = new File(fn);
            try {
                int bytes_read;
                InputStream inStream = fileEntry.createInputStream();
                FileOutputStream outStream = FileUtils.openOutputStream((File)destFile);
                byte[] b = new byte[0x100000];
                while ((bytes_read = inStream.read(b)) != -1) {
                    ((OutputStream)outStream).write(b, 0, bytes_read);
                }
                outStream.flush();
                ((OutputStream)outStream).close();
                inStream.close();
                if (className.contains("org.apache.flex")) {
                    Map includedfiles = swc.getFiles();
                    Set includedList = includedfiles.keySet();
                    for (String included : includedList) {
                        if (!included.contains(".png") && !included.contains(".gif") && !included.contains(".jpg") && !included.contains(".json")) continue;
                        fileEntry = (ISWCFileEntry)includedfiles.get(included);
                        String assetName = this.outputFolderPath + File.separator + included;
                        File assetFile = new File(assetName);
                        inStream = fileEntry.createInputStream();
                        outStream = FileUtils.openOutputStream((File)assetFile);
                        b = new byte[inStream.available()];
                        inStream.read(b);
                        ((OutputStream)outStream).write(b);
                        inStream.close();
                        outStream.flush();
                        ((OutputStream)outStream).close();
                        System.out.println("Copied asset " + assetName);
                    }
                }
            }
            catch (IOException e) {
                System.out.println("Error copying file for class: " + className);
            }
            return fn;
        }
        System.out.println("Could not find file for class: " + className);
        this.problems.add((ICompilerProblem)new FileNotFoundProblem(className));
        this.problemsFound = true;
        return "";
    }

    private ArrayList<String> getDirectDependencies(String fn) {
        ArrayList<String> deps = new ArrayList<String>();
        try {
            String s;
            FileInputStream fis = new FileInputStream(fn);
            Scanner scanner = new Scanner((InputStream)fis, "UTF-8");
            boolean inInjectHTML = false;
            while (scanner.hasNextLine() && !(s = scanner.nextLine()).contains("goog.inherits")) {
                int c;
                if (inInjectHTML && (c = s.indexOf("</inject_html>")) > -1) {
                    inInjectHTML = false;
                    continue;
                }
                if (inInjectHTML) {
                    if ((s = s.trim()).startsWith("*")) {
                        s = s.substring(1);
                    }
                    this.additionalHTML.add(s);
                    continue;
                }
                c = s.indexOf(JSGoogEmitterTokens.GOOG_REQUIRE.getToken());
                if (c > -1) {
                    int c2 = s.indexOf(")");
                    s = s.substring(c + 14, c2 - 1);
                    deps.add(s);
                }
                if ((c = s.indexOf("<inject_html>")) <= -1) continue;
                inInjectHTML = true;
            }
            scanner.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        return deps;
    }

    private String getDependencies(ArrayList<String> deps) {
        String s = "";
        for (String dep : deps) {
            if (s.length() > 0) {
                s = s + ", ";
            }
            s = s + "'" + dep + "'";
        }
        return s;
    }

    String relativePath(String path) {
        if (path.indexOf(this.outputFolderPath) == 0) {
            path = path.replace(this.outputFolderPath, "../../..");
        } else {
            for (String otherPath : this.otherPaths) {
                if (path.indexOf(otherPath) != 0) continue;
                path = path.replace(otherPath, "../../..");
            }
        }
        path = path.replace('\\', '/');
        return path;
    }

    private class FileInfo {
        public String inherits;
        public ArrayList<String> impls;
        public int constructorLine;
        public int suppressLine;
        public int fileoverviewLine;
        public int googProvideLine;

        private FileInfo() {
        }
    }

    private class GoogDep {
        public String filePath;
        public String className;
        public ArrayList<String> deps;
        public FileInfo fileInfo;

        private GoogDep() {
        }
    }
}

