/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.driver.js.goog;

import java.io.File;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import org.apache.flex.compiler.clients.JSConfiguration;
import org.apache.flex.compiler.clients.MXMLJSC;
import org.apache.flex.compiler.config.ConfigurationValue;
import org.apache.flex.compiler.exceptions.ConfigurationException;
import org.apache.flex.compiler.internal.config.annotations.Config;
import org.apache.flex.compiler.internal.config.annotations.FlexOnly;
import org.apache.flex.compiler.internal.config.annotations.InfiniteArguments;
import org.apache.flex.compiler.internal.config.annotations.Mapping;

public class JSGoogConfiguration
extends JSConfiguration {
    protected String closureLib = "";
    private String bindingValueChangeEventType = "valueChange";
    private Boolean childrenAsData = true;
    private String marmotinni;
    protected List<String> sdkJSLib = new ArrayList<String>();
    private List<String> externalJSLib = new ArrayList<String>();
    private boolean strictPublish = true;
    private boolean keepASDoc = true;
    private boolean removeCirculars = false;
    private boolean skipTranspile = false;
    protected List<String> jsCompilerOptions = new ArrayList<String>();
    protected List<String> jsOutputOptimizations = new ArrayList<String>();

    public boolean isClosureLibSet() {
        return !this.closureLib.isEmpty();
    }

    public String getClosureLib() {
        try {
            if (this.closureLib.equals("")) {
                return this.getAbsolutePathFromPathRelativeToMXMLC("../../js/lib/google/closure-library");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.closureLib;
    }

    @Config
    @Mapping(value={"closure-lib"})
    public void setClosureLib(ConfigurationValue cv, String value) throws ConfigurationException {
        if (value != null) {
            this.closureLib = value;
        }
    }

    public String getBindingValueChangeEventType() {
        return this.bindingValueChangeEventType;
    }

    @Config(advanced=true)
    public void setCompilerBindingValueChangeEventType(ConfigurationValue cv, String b) {
        this.bindingValueChangeEventType = b;
    }

    public Boolean getCompilerMxmlChildrenAsData() {
        return this.childrenAsData;
    }

    @Config
    @Mapping(value={"compiler", "mxml", "children-as-data"})
    @FlexOnly
    public void setCompilerMxmlChildrenAsData(ConfigurationValue cv, Boolean asData) throws ConfigurationException {
        this.childrenAsData = asData;
    }

    public String getMarmotinni() {
        return this.marmotinni;
    }

    @Config
    @Mapping(value={"marmotinni"})
    public void setMarmotinni(ConfigurationValue cv, String value) throws ConfigurationException {
        this.marmotinni = value;
    }

    public List<String> getSDKJSLib() {
        if (this.sdkJSLib.size() == 0) {
            try {
                String path = this.getAbsolutePathFromPathRelativeToMXMLC("../../frameworks/js/FlexJS/src");
                this.sdkJSLib.add(path);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.sdkJSLib;
    }

    @Config(allowMultiple=true)
    @Mapping(value={"sdk-js-lib"})
    @InfiniteArguments
    public void setSDKJSLib(ConfigurationValue cv, List<String> value) throws ConfigurationException {
        this.sdkJSLib.addAll(value);
    }

    public List<String> getExternalJSLib() {
        return this.externalJSLib;
    }

    @Config(allowMultiple=true)
    @Mapping(value={"external-js-lib"})
    @InfiniteArguments
    public void setExternalJSLib(ConfigurationValue cv, List<String> value) throws ConfigurationException {
        this.externalJSLib.addAll(value);
    }

    public boolean getStrictPublish() {
        return this.strictPublish;
    }

    @Config
    @Mapping(value={"strict-publish"})
    public void setStrictPublish(ConfigurationValue cv, boolean value) throws ConfigurationException {
        this.strictPublish = value;
    }

    public boolean getKeepASDoc() {
        return this.keepASDoc;
    }

    @Config
    @Mapping(value={"keep-asdoc"})
    public void setKeepASDoc(ConfigurationValue cv, boolean value) throws ConfigurationException {
        this.keepASDoc = value;
    }

    public boolean getRemoveCirculars() {
        return this.removeCirculars;
    }

    @Config
    @Mapping(value={"remove-circulars"})
    public void setRemoveCirculars(ConfigurationValue cv, boolean value) throws ConfigurationException {
        this.removeCirculars = value;
    }

    public boolean getSkipTranspile() {
        return this.skipTranspile;
    }

    @Config
    @Mapping(value={"skip-transpile"})
    public void setSkipTranspile(ConfigurationValue cv, boolean value) throws ConfigurationException {
        this.skipTranspile = value;
    }

    protected String getAbsolutePathFromPathRelativeToMXMLC(String relativePath) throws IOException {
        String mxmlcURL = MXMLJSC.class.getProtectionDomain().getCodeSource().getLocation().getPath();
        File mxmlc = new File(URLDecoder.decode(mxmlcURL, "utf-8"));
        return new File(mxmlc.getParent() + File.separator + relativePath).getCanonicalPath();
    }

    public List<String> getJSCompilerOptions() {
        return this.jsCompilerOptions;
    }

    @Config(allowMultiple=true)
    @Mapping(value={"js-compiler-option"})
    @InfiniteArguments
    public void setJSCompilerOptions(ConfigurationValue cv, List<String> value) throws ConfigurationException {
        this.jsCompilerOptions.addAll(value);
    }

    public List<String> getJSOutputOptimizations() {
        return this.jsOutputOptimizations;
    }

    @Config(allowMultiple=true)
    @Mapping(value={"js-output-optimization"})
    @InfiniteArguments
    public void setJSOutputOptimizations(ConfigurationValue cv, List<String> value) throws ConfigurationException {
        this.jsOutputOptimizations.addAll(value);
    }
}

