/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.codegen.mxml.vf2js;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Scanner;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.FileFileFilter;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.RegexFileFilter;
import org.apache.flex.compiler.clients.problems.ProblemQuery;
import org.apache.flex.compiler.codegen.js.IJSPublisher;
import org.apache.flex.compiler.config.Configuration;
import org.apache.flex.compiler.internal.codegen.js.JSSharedData;
import org.apache.flex.compiler.internal.codegen.js.goog.JSGoogPublisher;
import org.apache.flex.compiler.internal.driver.js.flexjs.JSCSSCompilationSession;
import org.apache.flex.compiler.internal.driver.js.goog.JSGoogConfiguration;
import org.apache.flex.compiler.internal.graph.VF2JSDepsWriter;
import org.apache.flex.compiler.internal.projects.FlexJSProject;
import org.apache.flex.compiler.utils.VF2JSClosureCompilerWrapper;

public class MXMLVF2JSPublisher
extends JSGoogPublisher
implements IJSPublisher {
    public static final String FLEXJS_OUTPUT_DIR_NAME = "bin";
    public static final String FLEXJS_INTERMEDIATE_DIR_NAME = "js-debug";
    public static final String FLEXJS_RELEASE_DIR_NAME = "js-release";
    private FlexJSProject project;
    private boolean isMarmotinniRun;
    private String outputPathParameter;
    private boolean useStrictPublishing;

    public MXMLVF2JSPublisher(Configuration config, FlexJSProject project) {
        super(config);
        this.isMarmotinniRun = ((JSGoogConfiguration)this.configuration).getMarmotinni() != null;
        this.outputPathParameter = this.configuration.getOutput();
        this.useStrictPublishing = ((JSGoogConfiguration)this.configuration).getStrictPublish();
        this.project = project;
    }

    @Override
    public File getOutputFolder() {
        if (this.isMarmotinniRun) {
            this.outputParentFolder = new File(((JSGoogConfiguration)this.configuration).getMarmotinni());
        } else if (this.outputPathParameter != null) {
            this.outputParentFolder = new File(this.outputPathParameter);
            if (this.outputPathParameter.contains(".swf")) {
                this.outputParentFolder = this.outputParentFolder.getParentFile().getParentFile();
            }
        } else {
            this.outputParentFolder = new File(this.configuration.getTargetFileDirectory()).getParentFile();
        }
        this.outputParentFolder = new File(this.outputParentFolder, FLEXJS_OUTPUT_DIR_NAME);
        this.outputFolder = new File(this.outputParentFolder, File.separator + FLEXJS_INTERMEDIATE_DIR_NAME);
        if (!this.isMarmotinniRun) {
            this.setupOutputFolder();
        }
        return this.outputFolder;
    }

    @Override
    public boolean publish(ProblemQuery problems) throws IOException {
        boolean ok;
        String closureLibDirPath;
        boolean subsetGoog = true;
        String intermediateDirPath = this.outputFolder.getPath();
        File intermediateDir = new File(intermediateDirPath);
        File srcDir = new File(this.configuration.getTargetFile());
        srcDir = srcDir.getParentFile();
        String projectName = FilenameUtils.getBaseName((String)this.configuration.getTargetFile());
        String outputFileName = projectName + "." + JSSharedData.OUTPUT_EXTENSION;
        File releaseDir = new File(this.outputParentFolder, FLEXJS_RELEASE_DIR_NAME);
        String releaseDirPath = releaseDir.getPath();
        if (!this.isMarmotinniRun) {
            if (releaseDir.exists()) {
                FileUtils.deleteQuietly((File)releaseDir);
            }
            releaseDir.mkdirs();
        }
        if (((JSGoogConfiguration)this.configuration).isClosureLibSet()) {
            closureLibDirPath = ((JSGoogConfiguration)this.configuration).getClosureLib();
        } else {
            URL resource = Thread.currentThread().getContextClassLoader().getResource("goog/deps.js");
            if (resource != null) {
                File closureLibDir = new File(intermediateDir.getParent(), "closure");
                if (!closureLibDir.exists()) {
                    if (!closureLibDir.mkdirs()) {
                        throw new IOException("Unable to create directory for closure-lib at " + closureLibDir.getAbsolutePath());
                    }
                    String resourceJarPath = resource.getFile();
                    if (resourceJarPath.contains(":")) {
                        resourceJarPath = resourceJarPath.substring(resourceJarPath.lastIndexOf(":") + 1);
                    }
                    if (resourceJarPath.contains("!")) {
                        resourceJarPath = resourceJarPath.substring(0, resourceJarPath.indexOf("!"));
                    }
                    File resourceJar = new File(resourceJarPath);
                    this.dumpJar(resourceJar, closureLibDir);
                }
                closureLibDirPath = intermediateDir.getParentFile().getPath();
            } else {
                closureLibDirPath = ((JSGoogConfiguration)this.configuration).getClosureLib();
            }
        }
        String closureGoogSrcLibDirPath = closureLibDirPath + "/closure/goog/";
        String closureGoogTgtLibDirPath = intermediateDirPath + "/library/closure/goog";
        String depsSrcFilePath = intermediateDirPath + "/library/closure/goog/deps.js";
        String depsTgtFilePath = intermediateDirPath + "/deps.js";
        String projectIntermediateJSFilePath = intermediateDirPath + File.separator + outputFileName;
        String projectReleaseJSFilePath = releaseDirPath + File.separator + outputFileName;
        this.appendExportSymbol(projectIntermediateJSFilePath, projectName);
        this.appendEncodedCSS(projectIntermediateJSFilePath, projectName);
        if (!subsetGoog) {
            FileUtils.copyDirectory((File)new File(closureGoogSrcLibDirPath), (File)new File(closureGoogTgtLibDirPath));
        }
        VF2JSClosureCompilerWrapper compilerWrapper = new VF2JSClosureCompilerWrapper();
        VF2JSDepsWriter gdw = new VF2JSDepsWriter(intermediateDir, projectName, (JSGoogConfiguration)this.configuration);
        try {
            StringBuilder depsFileData = new StringBuilder();
            ok = gdw.generateDeps(problems, depsFileData);
            if (!subsetGoog) {
                this.writeFile(depsTgtFilePath, depsFileData.toString(), false);
            } else {
                String s = depsFileData.toString();
                int c = s.indexOf("'goog.");
                ArrayList<String> googreqs = new ArrayList<String>();
                while (c != -1) {
                    int c2 = s.indexOf("'", c + 1);
                    String googreq = s.substring(c, c2 + 1);
                    googreqs.add(googreq);
                    c = s.indexOf("'goog.", c2);
                }
                HashMap<String, DependencyRecord> defmap = new HashMap<String, DependencyRecord>();
                FileInputStream fis = new FileInputStream(closureGoogSrcLibDirPath + "/deps.js");
                Scanner scanner = new Scanner((InputStream)fis, "UTF-8");
                String addDependency = "goog.addDependency('";
                int currentLine = 0;
                while (scanner.hasNextLine()) {
                    String googline = scanner.nextLine();
                    if (googline.indexOf(addDependency) == 0) {
                        int c1 = googline.indexOf("'", addDependency.length() + 1);
                        String googpath = googline.substring(addDependency.length(), c1);
                        String googdefs = googline.substring(googline.indexOf("[") + 1, googline.indexOf("]"));
                        String googdeps = googline.substring(googline.lastIndexOf("[") + 1, googline.lastIndexOf("]"));
                        String[] thedefs = googdefs.split(",");
                        DependencyRecord deprec = new DependencyRecord();
                        deprec.path = googpath;
                        deprec.deps = googdeps;
                        deprec.line = googline;
                        deprec.lineNumber = currentLine;
                        for (String def : thedefs) {
                            def = def.trim();
                            defmap.put(def, deprec);
                        }
                    }
                    ++currentLine;
                }
                scanner.close();
                ArrayList<DependencyRecord> subsetdeps = new ArrayList<DependencyRecord>();
                HashMap<String, String> gotgoog = new HashMap<String, String>();
                for (String req : googreqs) {
                    DependencyRecord deprec = (DependencyRecord)defmap.get(req);
                    if (gotgoog.containsKey(deprec.path)) continue;
                    gotgoog.put(deprec.path, null);
                    subsetdeps.add(deprec);
                    this.addDeps(subsetdeps, gotgoog, defmap, deprec.deps);
                }
                StringBuilder sb = new StringBuilder();
                sb.append("goog.addDependency('base.js', ['goog'], []);\n");
                File file = new File(closureGoogSrcLibDirPath + "/base.js");
                FileUtils.copyFileToDirectory((File)file, (File)new File(closureGoogTgtLibDirPath));
                compilerWrapper.addJSSourceFile(file.getCanonicalPath());
                Collections.sort(subsetdeps, new DependencyLineComparator());
                for (DependencyRecord subsetdeprec : subsetdeps) {
                    sb.append(subsetdeprec.line).append("\n");
                }
                this.writeFile(depsTgtFilePath, sb.toString() + depsFileData.toString(), false);
                for (String googfn : gotgoog.keySet()) {
                    file = new File(closureGoogSrcLibDirPath + File.separator + googfn);
                    String dir = closureGoogTgtLibDirPath;
                    if (googfn.contains("/")) {
                        dir = dir + File.separator + googfn.substring(0, googfn.lastIndexOf("/"));
                    }
                    FileUtils.copyFileToDirectory((File)file, (File)new File(dir));
                    compilerWrapper.addJSSourceFile(file.getCanonicalPath());
                }
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return false;
        }
        IOFileFilter pngSuffixFilter = FileFilterUtils.and((IOFileFilter[])new IOFileFilter[]{FileFileFilter.FILE, FileFilterUtils.suffixFileFilter((String)".png")});
        IOFileFilter gifSuffixFilter = FileFilterUtils.and((IOFileFilter[])new IOFileFilter[]{FileFileFilter.FILE, FileFilterUtils.suffixFileFilter((String)".gif")});
        IOFileFilter jpgSuffixFilter = FileFilterUtils.and((IOFileFilter[])new IOFileFilter[]{FileFileFilter.FILE, FileFilterUtils.suffixFileFilter((String)".jpg")});
        IOFileFilter assetFiles = FileFilterUtils.or((IOFileFilter[])new IOFileFilter[]{pngSuffixFilter, jpgSuffixFilter, gifSuffixFilter});
        FileUtils.copyDirectory((File)srcDir, (File)intermediateDir, (FileFilter)assetFiles);
        FileUtils.copyDirectory((File)srcDir, (File)releaseDir, (FileFilter)assetFiles);
        File srcDeps = new File(depsSrcFilePath);
        File sdkDepsFile = new File("/Users/erik/Documents/ApacheFlex/git/flex-asjs/vf2js/frameworks/js/sdk-deps.js");
        if (sdkDepsFile.exists()) {
            FileUtils.copyFile((File)sdkDepsFile, (File)new File(intermediateDirPath + File.separator + "sdk-deps.js"));
        }
        this.writeHTML("intermediate", projectName, intermediateDirPath, gdw.additionalHTML);
        this.writeHTML("release", projectName, releaseDirPath, gdw.additionalHTML);
        this.writeCSS(projectName, intermediateDirPath);
        this.writeCSS(projectName, releaseDirPath);
        if (!subsetGoog) {
            Collection files = FileUtils.listFiles((File)new File(closureGoogTgtLibDirPath), (IOFileFilter)new RegexFileFilter("^.*(\\.js)"), (IOFileFilter)DirectoryFileFilter.DIRECTORY);
            for (File file : files) {
                compilerWrapper.addJSSourceFile(file.getCanonicalPath());
            }
        }
        for (String filePath : gdw.filePathsInOrder) {
            compilerWrapper.addJSSourceFile(new File(filePath).getCanonicalPath());
        }
        compilerWrapper.setOptions(projectReleaseJSFilePath, this.useStrictPublishing);
        compilerWrapper.addJSSourceFile(closureGoogSrcLibDirPath + File.separator + "deps.js");
        List<String> externs = ((JSGoogConfiguration)this.configuration).getExternalJSLib();
        for (String extern : externs) {
            compilerWrapper.addJSExternsFile(extern);
        }
        compilerWrapper.targetFilePath = projectReleaseJSFilePath;
        compilerWrapper.compile();
        this.appendSourceMapLocation(projectReleaseJSFilePath, projectName);
        if (!this.isMarmotinniRun) {
            String allDeps = "";
            if (!subsetGoog) {
                allDeps = allDeps + FileUtils.readFileToString((File)srcDeps);
            }
            allDeps = allDeps + FileUtils.readFileToString((File)new File(depsTgtFilePath));
            FileUtils.writeStringToFile((File)srcDeps, (String)allDeps);
            FileUtils.deleteQuietly((File)new File(depsTgtFilePath));
        }
        if (ok) {
            System.out.println("The project '" + projectName + "' has been successfully compiled and optimized.");
        }
        return true;
    }

    private void addDeps(ArrayList<DependencyRecord> subsetdeps, HashMap<String, String> gotgoog, HashMap<String, DependencyRecord> defmap, String deps) {
        String[] deplist;
        if (deps.length() == 0) {
            return;
        }
        for (String dep : deplist = deps.split(",")) {
            dep = dep.trim();
            DependencyRecord deprec = defmap.get(dep);
            if (gotgoog.containsKey(deprec.path)) continue;
            gotgoog.put(deprec.path, null);
            subsetdeps.add(deprec);
            this.addDeps(subsetdeps, gotgoog, defmap, deprec.deps);
        }
    }

    private void appendExportSymbol(String path, String projectName) throws IOException {
        StringBuilder appendString = new StringBuilder();
        appendString.append("\n\n// Ensures the symbol will be visible after compiler renaming.\n");
        appendString.append("goog.exportSymbol('");
        appendString.append(projectName);
        appendString.append("', ");
        appendString.append(projectName);
        appendString.append(");\n");
        this.writeFile(path, appendString.toString(), true);
    }

    private void appendEncodedCSS(String path, String projectName) throws IOException {
        StringBuilder appendString = new StringBuilder();
        appendString.append("\n\n");
        appendString.append(projectName);
        appendString.append(".prototype.cssData = [");
        JSCSSCompilationSession cssSession = (JSCSSCompilationSession)this.project.getCSSCompilationSession();
        String s = cssSession.getEncodedCSS();
        int reqidx = s.indexOf("goog.require");
        if (reqidx != -1) {
            String reqs = s.substring(reqidx);
            s = s.substring(0, reqidx - 1);
            String fileData = this.readCode(new File(path));
            reqidx = fileData.indexOf("goog.require");
            String after = fileData.substring(reqidx);
            String before = fileData.substring(0, reqidx - 1);
            s = before + reqs + after + appendString.toString() + s;
            this.writeFile(path, s, false);
        } else {
            appendString.append(s);
            this.writeFile(path, appendString.toString(), true);
        }
    }

    protected String readCode(File file) {
        String code = "";
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF8"));
            String line = in.readLine();
            while (line != null) {
                code = code + line + "\n";
                line = in.readLine();
            }
            code = code.substring(0, code.length() - 1);
            in.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return code;
    }

    private void writeHTML(String type, String projectName, String dirPath, List<String> additionalHTML) throws IOException {
        StringBuilder htmlFile = new StringBuilder();
        htmlFile.append("<!DOCTYPE html>\n");
        htmlFile.append("<html>\n");
        htmlFile.append("<head>\n");
        htmlFile.append("\t<meta http-equiv=\"X-UA-Compatible\" content=\"IE=edge,chrome=1\">\n");
        htmlFile.append("\t<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\">\n");
        htmlFile.append("\t<link rel=\"stylesheet\" type=\"text/css\" href=\"");
        htmlFile.append(projectName);
        htmlFile.append(".css\">\n");
        for (String s : additionalHTML) {
            htmlFile.append(s).append("\n");
        }
        if ("intermediate".equals(type)) {
            htmlFile.append("\t<script type=\"text/javascript\" src=\"./library/closure/goog/base.js\"></script>\n");
            htmlFile.append("\t<script type=\"text/javascript\" src=\"./sdk-deps.js\"></script>\n");
            htmlFile.append("\t<script type=\"text/javascript\">\n");
            htmlFile.append("\t\tgoog.require('mx.managers.SystemManager');\n");
            htmlFile.append("\t\tgoog.require('mx.managers.systemClasses.ChildManager');\n");
            htmlFile.append("\t</script>\n");
        } else {
            htmlFile.append("\t<script type=\"text/javascript\" src=\"./");
            htmlFile.append(projectName);
            htmlFile.append(".js\"></script>\n");
        }
        htmlFile.append("</head>\n");
        htmlFile.append("<body onload=\"init();\">\n");
        htmlFile.append("\t<script type=\"text/javascript\">\n");
        htmlFile.append("\t\t'use strict';\n");
        htmlFile.append("\t\t\n");
        htmlFile.append("\t\tfunction init() {\n");
        htmlFile.append("\t\t\tvar /** @type {flash.display.LoaderInfo} */ loaderInfo,\n");
        htmlFile.append("\t\t\t    /** @type {flash.display.Stage} */ stage,\n");
        htmlFile.append("\t\t\t    /** @type {mx.managers.SystemManager} */ systemManager,\n");
        htmlFile.append("\t\t\t    /** @type {mx.managers.systemClasses.ChildManager} */ childManager;\n");
        htmlFile.append("\t\t\t\n");
        htmlFile.append("\t\t\tstage = new flash.display.Stage();\n");
        htmlFile.append("\t\t\twindow['apache-flex_stage'] = stage;\n");
        htmlFile.append("\t\t\t\n");
        htmlFile.append("\t\t\twindow['apache-flex_loaderInfo'] = new flash.display.LoaderInfo();\n");
        htmlFile.append("\t\t\twindow['apache-flex_loaderInfo'].get_parameters = function () {\n");
        htmlFile.append("\t\t\t\tvar /** @type {Object} */ infoObject;\n");
        htmlFile.append("\t\t\t\n");
        htmlFile.append("\t\t\t\tinfoObject = {};\n");
        htmlFile.append("\t\t\t\tinfoObject[\"resourceModuleURLs\"] = '';\n");
        htmlFile.append("\t\t\t\t\n");
        htmlFile.append("\t\t\t\treturn infoObject;\n");
        htmlFile.append("\t\t\t}\n");
        htmlFile.append("\t\t\t\n");
        htmlFile.append("\t\t\tsystemManager = new mx.managers.SystemManager();\n");
        htmlFile.append("\t\t\tsystemManager.info = function () {\n");
        htmlFile.append("\t\t\t\tvar /** @type {Object} */ infoObject;\n");
        htmlFile.append("\t\t\t\n");
        htmlFile.append("\t\t\t\tinfoObject = {};\n");
        htmlFile.append("\t\t\t\tinfoObject[\"applicationDPI\"] = '';\n");
        htmlFile.append("\t\t\t\tinfoObject[\"backgroundAlpha\"] = '';\n");
        htmlFile.append("\t\t\t\tinfoObject[\"backgroundColor\"] = '';\n");
        htmlFile.append("\t\t\t\tinfoObject[\"backgroundImage\"] = '';\n");
        htmlFile.append("\t\t\t\tinfoObject[\"backgroundSize\"] = '';\n");
        htmlFile.append("\t\t\t\tinfoObject[\"cdRsls\"] = '';\n");
        htmlFile.append("\t\t\t\tinfoObject[\"compiledLocales\"] = '';\n");
        htmlFile.append("\t\t\t\tinfoObject[\"compiledResourceBundleNames\"] = '';\n");
        htmlFile.append("\t\t\t\tinfoObject[\"currentDomain\"] = new flash.system.ApplicationDomain();\n");
        htmlFile.append("\t\t\t\tinfoObject[\"fonts\"] = '';\n");
        htmlFile.append("\t\t\t\tinfoObject[\"frames\"] = '';\n");
        htmlFile.append("\t\t\t\tinfoObject[\"mainClassName\"] = '").append(projectName).append("';\n");
        htmlFile.append("\t\t\t\tinfoObject[\"mixins\"] = '';\n");
        htmlFile.append("\t\t\t\tinfoObject[\"preloader\"] = new mx.preloaders.DownloadProgressBar();\n");
        htmlFile.append("\t\t\t\tinfoObject[\"rsls\"] = '';\n");
        htmlFile.append("\t\t\t\tinfoObject[\"runtimeDPIProvider\"] = new mx.core.RuntimeDPIProvider();\n");
        htmlFile.append("\t\t\t\tinfoObject[\"useNativeDragManager\"] = '';\n");
        htmlFile.append("\t\t\t\tinfoObject[\"usePreloader\"] = false; // we're not showing a preloader in JS\n");
        htmlFile.append("\t\t\t\t\n");
        htmlFile.append("\t\t\t\treturn infoObject;\n");
        htmlFile.append("\t\t\t}\n");
        htmlFile.append("\t\t\t\n");
        htmlFile.append("\t\t\tchildManager = new mx.managers.systemClasses.ChildManager(systemManager);\n");
        htmlFile.append("\t\t\t\n");
        htmlFile.append("\t\t\tmx.managers.DragManagerImpl.sm = window['apache-flex_system-manager'];\n");
        htmlFile.append("\t\t\t\n");
        htmlFile.append("\t\t\tmx.core.FlexGlobals.topLevelApplication = {};\n");
        htmlFile.append("\t\t\t\n");
        htmlFile.append("\t\t\twindow['apache-flex_loaderInfo'].dispatchEvent(new flash.events.Event(flash.events.Event.INIT));\n");
        htmlFile.append("\t\t}\n");
        htmlFile.append("\t</script>\n");
        htmlFile.append("</body>\n");
        htmlFile.append("</html>");
        this.writeFile(dirPath + File.separator + "index.html", htmlFile.toString(), false);
    }

    private void writeCSS(String projectName, String dirPath) throws IOException {
        StringBuilder cssFile = new StringBuilder();
        JSCSSCompilationSession cssSession = (JSCSSCompilationSession)this.project.getCSSCompilationSession();
        cssFile.append(cssSession.emitCSS());
        this.writeFile(dirPath + File.separator + projectName + ".css", cssFile.toString(), false);
    }

    class DependencyLineComparator
    implements Comparator<DependencyRecord> {
        DependencyLineComparator() {
        }

        @Override
        public int compare(DependencyRecord o1, DependencyRecord o2) {
            return new Integer(o1.lineNumber).compareTo(o2.lineNumber);
        }
    }

    class DependencyRecord {
        String path;
        String deps;
        String line;
        int lineNumber;

        DependencyRecord() {
        }
    }
}

