/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.codegen.mxml.vf2js;

import java.io.FilterWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.flex.abc.semantics.Name;
import org.apache.flex.abc.semantics.Namespace;
import org.apache.flex.compiler.codegen.as.IASEmitter;
import org.apache.flex.compiler.codegen.mxml.flexjs.IMXMLFlexJSEmitter;
import org.apache.flex.compiler.definitions.IClassDefinition;
import org.apache.flex.compiler.definitions.IDefinition;
import org.apache.flex.compiler.internal.codegen.as.ASEmitterTokens;
import org.apache.flex.compiler.internal.codegen.databinding.BindingDatabase;
import org.apache.flex.compiler.internal.codegen.databinding.BindingInfo;
import org.apache.flex.compiler.internal.codegen.databinding.FunctionWatcherInfo;
import org.apache.flex.compiler.internal.codegen.databinding.PropertyWatcherInfo;
import org.apache.flex.compiler.internal.codegen.databinding.StaticPropertyWatcherInfo;
import org.apache.flex.compiler.internal.codegen.databinding.WatcherInfoBase;
import org.apache.flex.compiler.internal.codegen.databinding.XMLWatcherInfo;
import org.apache.flex.compiler.internal.codegen.js.flexjs.JSFlexJSEmitterTokens;
import org.apache.flex.compiler.internal.codegen.js.goog.JSGoogEmitterTokens;
import org.apache.flex.compiler.internal.codegen.js.vf2js.JSVF2JSEmitter;
import org.apache.flex.compiler.internal.codegen.mxml.MXMLEmitter;
import org.apache.flex.compiler.internal.codegen.mxml.flexjs.MXMLEventSpecifier;
import org.apache.flex.compiler.internal.codegen.mxml.flexjs.MXMLFlexJSEmitterTokens;
import org.apache.flex.compiler.internal.codegen.mxml.flexjs.MXMLScriptSpecifier;
import org.apache.flex.compiler.internal.codegen.mxml.vf2js.MXMLVF2JSDescriptorSpecifier;
import org.apache.flex.compiler.internal.projects.FlexJSProject;
import org.apache.flex.compiler.internal.projects.FlexProject;
import org.apache.flex.compiler.internal.scopes.ASProjectScope;
import org.apache.flex.compiler.internal.tree.as.FunctionCallNode;
import org.apache.flex.compiler.internal.tree.as.IdentifierNode;
import org.apache.flex.compiler.internal.tree.as.MemberAccessExpressionNode;
import org.apache.flex.compiler.internal.tree.mxml.MXMLDocumentNode;
import org.apache.flex.compiler.tree.ASTNodeID;
import org.apache.flex.compiler.tree.as.IASNode;
import org.apache.flex.compiler.tree.as.IExpressionNode;
import org.apache.flex.compiler.tree.as.IImportNode;
import org.apache.flex.compiler.tree.mxml.IMXMLArrayNode;
import org.apache.flex.compiler.tree.mxml.IMXMLClassDefinitionNode;
import org.apache.flex.compiler.tree.mxml.IMXMLClassNode;
import org.apache.flex.compiler.tree.mxml.IMXMLComponentNode;
import org.apache.flex.compiler.tree.mxml.IMXMLDataBindingNode;
import org.apache.flex.compiler.tree.mxml.IMXMLDocumentNode;
import org.apache.flex.compiler.tree.mxml.IMXMLEventSpecifierNode;
import org.apache.flex.compiler.tree.mxml.IMXMLFactoryNode;
import org.apache.flex.compiler.tree.mxml.IMXMLInstanceNode;
import org.apache.flex.compiler.tree.mxml.IMXMLLiteralNode;
import org.apache.flex.compiler.tree.mxml.IMXMLNode;
import org.apache.flex.compiler.tree.mxml.IMXMLPropertySpecifierNode;
import org.apache.flex.compiler.tree.mxml.IMXMLScriptNode;
import org.apache.flex.compiler.tree.mxml.IMXMLSpecifierNode;
import org.apache.flex.compiler.tree.mxml.IMXMLStateNode;
import org.apache.flex.compiler.tree.mxml.IMXMLStringNode;
import org.apache.flex.compiler.tree.mxml.IMXMLStyleSpecifierNode;
import org.apache.flex.compiler.units.ICompilationUnit;
import org.apache.flex.compiler.utils.NativeUtils;
import org.apache.flex.compiler.visitor.mxml.IMXMLBlockWalker;

public class MXMLVF2JSEmitter
extends MXMLEmitter
implements IMXMLFlexJSEmitter {
    private ArrayList<MXMLVF2JSDescriptorSpecifier> currentInstances;
    private ArrayList<MXMLVF2JSDescriptorSpecifier> currentPropertySpecifiers;
    private ArrayList<MXMLVF2JSDescriptorSpecifier> descriptorTree;
    private MXMLVF2JSDescriptorSpecifier propertiesTree;
    private ArrayList<MXMLEventSpecifier> events;
    private ArrayList<MXMLVF2JSDescriptorSpecifier> instances;
    private ArrayList<MXMLScriptSpecifier> scripts;
    private int eventCounter;
    private int idCounter;
    private boolean inMXMLContent;
    private boolean inStatesOverride;
    private StringBuilder subDocuments = new StringBuilder();
    private ArrayList<String> subDocumentNames = new ArrayList();

    public MXMLVF2JSEmitter(FilterWriter out) {
        super(out);
    }

    @Override
    protected String getIndent(int numIndent) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < numIndent; ++i) {
            sb.append(JSFlexJSEmitterTokens.INDENT.getToken());
        }
        return sb.toString();
    }

    @Override
    public void emitDocument(IMXMLDocumentNode node) {
        this.descriptorTree = new ArrayList();
        this.propertiesTree = new MXMLVF2JSDescriptorSpecifier();
        this.events = new ArrayList();
        this.instances = new ArrayList();
        this.scripts = new ArrayList();
        this.currentInstances = new ArrayList();
        this.currentPropertySpecifiers = new ArrayList();
        this.eventCounter = 0;
        this.idCounter = 0;
        IClassDefinition cdef = node.getClassDefinition();
        IASEmitter asEmitter = ((IMXMLBlockWalker)this.getMXMLWalker()).getASEmitter();
        ((JSVF2JSEmitter)asEmitter).getModel().setCurrentClass(cdef);
        int len = node.getChildCount();
        for (int i = 0; i < len; ++i) {
            this.getMXMLWalker().walk(node.getChild(i));
        }
        String cname = node.getFileNode().getName();
        this.emitHeader(node);
        this.write(this.subDocuments.toString());
        this.writeNewline();
        this.emitClassDeclStart(cname, node.getBaseClassName(), false);
        this.emitPropertyDecls();
        this.emitClassDeclEnd(cname, node.getBaseClassName());
        this.emitMetaData(cdef);
        this.emitScripts();
        this.emitEvents(cname);
        this.emitPropertyGetterSetters(cname);
        this.emitMXMLDescriptorFuncs(cname);
        this.emitBindingData(cname, cdef);
    }

    public void emitSubDocument(IMXMLComponentNode node) {
        ArrayList<MXMLVF2JSDescriptorSpecifier> oldDescriptorTree = this.descriptorTree;
        this.descriptorTree = new ArrayList();
        MXMLVF2JSDescriptorSpecifier oldPropertiesTree = this.propertiesTree;
        this.propertiesTree = new MXMLVF2JSDescriptorSpecifier();
        ArrayList<MXMLEventSpecifier> oldEvents = this.events;
        this.events = new ArrayList();
        this.instances = new ArrayList();
        ArrayList<MXMLScriptSpecifier> oldScripts = this.scripts;
        this.scripts = new ArrayList();
        ArrayList<MXMLVF2JSDescriptorSpecifier> oldCurrentInstances = this.currentInstances;
        this.currentInstances = new ArrayList();
        ArrayList<MXMLVF2JSDescriptorSpecifier> oldCurrentPropertySpecifiers = this.currentPropertySpecifiers;
        this.currentPropertySpecifiers = new ArrayList();
        int oldEventCounter = this.eventCounter;
        this.eventCounter = 0;
        int oldIdCounter = this.idCounter;
        this.idCounter = 0;
        IClassDefinition cdef = node.getContainedClassDefinition();
        IASEmitter asEmitter = ((IMXMLBlockWalker)this.getMXMLWalker()).getASEmitter();
        ((JSVF2JSEmitter)asEmitter).getModel().setCurrentClass(cdef);
        IMXMLClassDefinitionNode classNode = node.getContainedClassDefinitionNode();
        int len = classNode.getChildCount();
        for (int i = 0; i < len; ++i) {
            this.getMXMLWalker().walk(classNode.getChild(i));
        }
        String cname = cdef.getQualifiedName();
        this.subDocumentNames.add(cname);
        String baseClassName = cdef.getBaseClassAsDisplayString();
        this.emitClassDeclStart(cname, baseClassName, false);
        this.emitPropertyDecls();
        this.emitClassDeclEnd(cname, baseClassName);
        this.emitMetaData(cdef);
        this.emitScripts();
        this.emitEvents(cname);
        this.emitPropertyGetterSetters(cname);
        this.emitMXMLDescriptorFuncs(cname);
        this.emitBindingData(cname, cdef);
        this.descriptorTree = oldDescriptorTree;
        this.propertiesTree = oldPropertiesTree;
        this.events = oldEvents;
        this.scripts = oldScripts;
        this.currentInstances = oldCurrentInstances;
        this.currentPropertySpecifiers = oldCurrentPropertySpecifiers;
        this.eventCounter = oldEventCounter;
        this.idCounter = oldIdCounter;
    }

    protected void emitClassDeclStart(String cname, String baseClassName, boolean indent) {
        this.writeNewline();
        this.writeNewline("/**");
        this.writeNewline(" * @constructor");
        this.writeNewline(" * @extends {" + baseClassName + "}");
        this.writeNewline(" */");
        this.writeToken(cname);
        this.writeToken(ASEmitterTokens.EQUAL);
        this.write(ASEmitterTokens.FUNCTION);
        this.write(ASEmitterTokens.PAREN_OPEN);
        this.writeToken(ASEmitterTokens.PAREN_CLOSE);
        if (indent) {
            this.indentPush();
        }
        this.writeNewline(ASEmitterTokens.BLOCK_OPEN, true);
        this.write(cname);
        this.write(ASEmitterTokens.MEMBER_ACCESS);
        this.write(JSGoogEmitterTokens.GOOG_BASE);
        this.write(ASEmitterTokens.PAREN_OPEN);
        this.write(ASEmitterTokens.THIS);
        this.writeToken(ASEmitterTokens.COMMA);
        this.write(ASEmitterTokens.SINGLE_QUOTE);
        this.write(JSGoogEmitterTokens.GOOG_CONSTRUCTOR);
        this.write(ASEmitterTokens.SINGLE_QUOTE);
        this.write(ASEmitterTokens.PAREN_CLOSE);
        this.writeNewline(ASEmitterTokens.SEMICOLON);
    }

    protected void emitClassDeclEnd(String cname, String baseClassName) {
        this.write(ASEmitterTokens.BLOCK_CLOSE);
        this.writeNewline(ASEmitterTokens.SEMICOLON);
        this.write(JSGoogEmitterTokens.GOOG_INHERITS);
        this.write(ASEmitterTokens.PAREN_OPEN);
        this.write(cname);
        this.writeToken(ASEmitterTokens.COMMA);
        this.write(baseClassName);
        this.write(ASEmitterTokens.PAREN_CLOSE);
        this.writeNewline(ASEmitterTokens.SEMICOLON);
        this.writeNewline();
        this.writeNewline();
    }

    protected void emitMetaData(IClassDefinition cdef) {
        String cname = cdef.getQualifiedName();
        this.writeNewline("/**");
        this.writeNewline(" * Metadata");
        this.writeNewline(" *");
        this.writeNewline(" * @type {Object.<string, Array.<Object>>}");
        this.writeNewline(" */");
        this.write(cname + ".prototype.FLEXJS_CLASS_INFO = { names: [{ name: '");
        this.write(cdef.getBaseName());
        this.write("', qName: '");
        this.write(cname);
        this.writeNewline("' }] };");
        this.writeNewline();
        this.writeNewline();
    }

    protected void emitPropertyDecls() {
        this.indentPop();
        for (MXMLVF2JSDescriptorSpecifier instance : this.instances) {
            this.indentPush();
            this.writeNewline();
            this.writeNewline("/**");
            this.writeNewline(" * @private");
            this.writeNewline(" * @type {" + instance.name + "}");
            this.writeNewline(" */");
            this.write(ASEmitterTokens.THIS);
            this.write(ASEmitterTokens.MEMBER_ACCESS);
            this.write(instance.id);
            this.indentPop();
            this.writeNewline(ASEmitterTokens.SEMICOLON);
        }
    }

    protected void emitBindingData(String cname, IClassDefinition cdef) {
        BindingDatabase bd = (BindingDatabase)BindingDatabase.bindingMap.get(cdef);
        if (bd == null) {
            return;
        }
        if (bd.getBindingInfo().isEmpty()) {
            return;
        }
        this.outputBindingInfoAsData(cname, bd);
    }

    private void outputBindingInfoAsData(String cname, BindingDatabase bindingDataBase) {
        IASEmitter asEmitter = ((IMXMLBlockWalker)this.getMXMLWalker()).getASEmitter();
        this.writeNewline("/**");
        this.writeNewline(" * @export");
        this.writeNewline(" */");
        this.writeNewline(cname + ".prototype._bindings = [");
        Set bindingInfo = bindingDataBase.getBindingInfo();
        this.writeNewline(bindingInfo.size() + ",");
        for (BindingInfo bi : bindingInfo) {
            String s = bi.getSourceString();
            if (s == null) {
                s = this.getSourceStringFromGetter(bi.getExpressionNodesForGetter());
            }
            if (s.contains(".")) {
                String[] parts = s.split("\\.");
                this.write(ASEmitterTokens.SQUARE_OPEN.getToken() + ASEmitterTokens.DOUBLE_QUOTE.getToken() + parts[0] + ASEmitterTokens.DOUBLE_QUOTE.getToken());
                int n = parts.length;
                for (int i = 1; i < n; ++i) {
                    String part = parts[i];
                    this.write(", " + ASEmitterTokens.DOUBLE_QUOTE.getToken() + part + ASEmitterTokens.DOUBLE_QUOTE.getToken());
                }
                this.writeNewline(ASEmitterTokens.SQUARE_CLOSE.getToken() + ASEmitterTokens.COMMA.getToken());
            } else if (s == null || s.length() == 0) {
                List getterNodes = bi.getExpressionNodesForGetter();
                StringBuilder sb = new StringBuilder();
                sb.append("function() { return ");
                for (IExpressionNode getterNode : getterNodes) {
                    sb.append(asEmitter.stringifyNode((IASNode)getterNode));
                }
                sb.append("; },");
                this.writeNewline(sb.toString());
            } else {
                this.writeNewline(ASEmitterTokens.DOUBLE_QUOTE.getToken() + s + ASEmitterTokens.DOUBLE_QUOTE.getToken() + ASEmitterTokens.COMMA.getToken());
            }
            IExpressionNode destNode = bi.getExpressionNodeForDestination();
            if (destNode != null) {
                StringBuilder sb = new StringBuilder();
                sb.append(asEmitter.stringifyNode((IASNode)destNode));
                this.writeNewline(sb.toString());
            } else {
                this.writeNewline(ASEmitterTokens.NULL.getToken() + ASEmitterTokens.COMMA.getToken());
            }
            s = bi.getDestinationString();
            if (s.contains(".")) {
                String[] parts = s.split("\\.");
                this.write(ASEmitterTokens.SQUARE_OPEN.getToken() + ASEmitterTokens.DOUBLE_QUOTE.getToken() + parts[0] + ASEmitterTokens.DOUBLE_QUOTE.getToken());
                int n = parts.length;
                for (int i = 1; i < n; ++i) {
                    String part = parts[i];
                    this.write(", " + ASEmitterTokens.DOUBLE_QUOTE.getToken() + part + ASEmitterTokens.DOUBLE_QUOTE.getToken());
                }
                this.writeNewline(ASEmitterTokens.SQUARE_CLOSE.getToken() + ASEmitterTokens.COMMA.getToken());
                continue;
            }
            this.writeNewline(ASEmitterTokens.DOUBLE_QUOTE.getToken() + s + ASEmitterTokens.DOUBLE_QUOTE.getToken() + ASEmitterTokens.COMMA.getToken());
        }
        Set watcherChains = bindingDataBase.getWatcherChains();
        for (Map.Entry entry : watcherChains) {
            WatcherInfoBase watcherInfoBase = (WatcherInfoBase)entry.getValue();
            this.encodeWatcher(watcherInfoBase);
        }
        this.writeNewline("null" + ASEmitterTokens.SQUARE_CLOSE.getToken() + ASEmitterTokens.SEMICOLON.getToken());
    }

    private void encodeWatcher(WatcherInfoBase watcherInfoBase) {
        IASEmitter asEmitter = ((IMXMLBlockWalker)this.getMXMLWalker()).getASEmitter();
        this.writeNewline(watcherInfoBase.getIndex() + ASEmitterTokens.COMMA.getToken());
        WatcherInfoBase.WatcherType type = watcherInfoBase.getType();
        if (type == WatcherInfoBase.WatcherType.FUNCTION) {
            this.writeNewline("0" + ASEmitterTokens.COMMA.getToken());
            FunctionWatcherInfo functionWatcherInfo = (FunctionWatcherInfo)watcherInfoBase;
            this.writeNewline(ASEmitterTokens.DOUBLE_QUOTE.getToken() + functionWatcherInfo.getFunctionName() + ASEmitterTokens.DOUBLE_QUOTE.getToken());
            IExpressionNode[] params = functionWatcherInfo.params;
            StringBuilder sb = new StringBuilder();
            sb.append("function() { return [");
            boolean firstone = true;
            for (IExpressionNode param : params) {
                if (firstone) {
                    firstone = false;
                }
                sb.append(ASEmitterTokens.COMMA.getToken());
                sb.append(asEmitter.stringifyNode((IASNode)param));
            }
            sb.append("]; },");
            this.outputEventNames(functionWatcherInfo.getEventNames());
            this.outputBindings(functionWatcherInfo.getBindings());
        } else if (type == WatcherInfoBase.WatcherType.STATIC_PROPERTY || type == WatcherInfoBase.WatcherType.PROPERTY) {
            this.writeNewline((type == WatcherInfoBase.WatcherType.STATIC_PROPERTY ? "1" : "2") + ASEmitterTokens.COMMA.getToken());
            PropertyWatcherInfo propertyWatcherInfo = (PropertyWatcherInfo)watcherInfoBase;
            boolean makeStaticWatcher = watcherInfoBase.getType() == WatcherInfoBase.WatcherType.STATIC_PROPERTY;
            Object propertyGetterFunction = null;
            if (watcherInfoBase.isRoot && !makeStaticWatcher || !watcherInfoBase.isRoot || makeStaticWatcher) {
                // empty if block
            }
            this.writeNewline(ASEmitterTokens.DOUBLE_QUOTE.getToken() + propertyWatcherInfo.getPropertyName() + ASEmitterTokens.DOUBLE_QUOTE.getToken() + ASEmitterTokens.COMMA.getToken());
            this.outputEventNames(propertyWatcherInfo.getEventNames());
            this.outputBindings(propertyWatcherInfo.getBindings());
            if (propertyGetterFunction == null) {
                this.writeNewline("null" + ASEmitterTokens.COMMA.getToken());
            }
            if (type == WatcherInfoBase.WatcherType.STATIC_PROPERTY) {
                StaticPropertyWatcherInfo pwinfo = (StaticPropertyWatcherInfo)watcherInfoBase;
                Name classMName = pwinfo.getContainingClass(this.getMXMLWalker().getProject());
                this.writeNewline(this.nameToString(classMName));
            }
        } else if (type == WatcherInfoBase.WatcherType.XML) {
            this.writeNewline("3" + ASEmitterTokens.COMMA.getToken());
            XMLWatcherInfo xmlWatcherInfo = (XMLWatcherInfo)watcherInfoBase;
            this.writeNewline(ASEmitterTokens.DOUBLE_QUOTE.getToken() + xmlWatcherInfo.getPropertyName() + ASEmitterTokens.DOUBLE_QUOTE.getToken() + ASEmitterTokens.COMMA.getToken());
            this.outputBindings(xmlWatcherInfo.getBindings());
        } else assert (false);
        Set children = watcherInfoBase.getChildren();
        if (children != null) {
            this.writeNewline(ASEmitterTokens.SQUARE_OPEN.getToken());
            for (Map.Entry ent : children) {
                this.encodeWatcher((WatcherInfoBase)ent.getValue());
            }
            this.writeNewline("null" + ASEmitterTokens.SQUARE_CLOSE.getToken() + ASEmitterTokens.COMMA.getToken());
        } else {
            this.writeNewline("null" + ASEmitterTokens.COMMA.getToken());
        }
    }

    private String getSourceStringFromMemberAccessExpressionNode(MemberAccessExpressionNode node) {
        String s = "";
        IExpressionNode left = node.getLeftOperandNode();
        if (left instanceof FunctionCallNode) {
            IASNode child = ((FunctionCallNode)left).getArgumentsNode().getChild(0);
            if (child instanceof IdentifierNode) {
                s = this.getSourceStringFromIdentifierNode((IdentifierNode)child);
            } else if (child instanceof MemberAccessExpressionNode) {
                s = this.getSourceStringFromMemberAccessExpressionNode((MemberAccessExpressionNode)child);
            }
        } else if (left instanceof MemberAccessExpressionNode) {
            s = this.getSourceStringFromMemberAccessExpressionNode((MemberAccessExpressionNode)left);
        } else if (left instanceof IdentifierNode) {
            s = this.getSourceStringFromIdentifierNode((IdentifierNode)left);
        } else {
            System.out.println("expected binding member access left node" + node.toString());
        }
        s = s + ".";
        IExpressionNode right = node.getRightOperandNode();
        if (right instanceof FunctionCallNode) {
            IASNode child = ((FunctionCallNode)right).getArgumentsNode().getChild(0);
            if (child instanceof IdentifierNode) {
                s = s + this.getSourceStringFromIdentifierNode((IdentifierNode)child);
            } else if (child instanceof MemberAccessExpressionNode) {
                s = s + this.getSourceStringFromMemberAccessExpressionNode((MemberAccessExpressionNode)child);
            }
        } else if (right instanceof MemberAccessExpressionNode) {
            s = s + this.getSourceStringFromMemberAccessExpressionNode((MemberAccessExpressionNode)right);
        } else if (right instanceof IdentifierNode) {
            s = s + this.getSourceStringFromIdentifierNode((IdentifierNode)right);
        } else {
            System.out.println("expected binding member access right node" + node.toString());
        }
        return s;
    }

    private String getSourceStringFromIdentifierNode(IdentifierNode node) {
        return node.getName();
    }

    private String getSourceStringFromGetter(List<IExpressionNode> nodes) {
        String s = "";
        IExpressionNode node = nodes.get(0);
        if (node instanceof MemberAccessExpressionNode) {
            s = this.getSourceStringFromMemberAccessExpressionNode((MemberAccessExpressionNode)node);
        }
        return s;
    }

    private void outputEventNames(List<String> events) {
        if (events.size() > 1) {
            int n = events.size();
            this.write(ASEmitterTokens.SQUARE_OPEN.getToken() + ASEmitterTokens.DOUBLE_QUOTE.getToken() + events.get(0) + ASEmitterTokens.DOUBLE_QUOTE.getToken());
            for (int i = 1; i < n; ++i) {
                String event = events.get(i);
                this.write(ASEmitterTokens.COMMA.getToken() + ASEmitterTokens.DOUBLE_QUOTE.getToken() + event + ASEmitterTokens.DOUBLE_QUOTE.getToken());
            }
            this.writeNewline(ASEmitterTokens.SQUARE_CLOSE.getToken() + ASEmitterTokens.COMMA.getToken());
        } else if (events.size() == 1) {
            this.writeNewline(ASEmitterTokens.DOUBLE_QUOTE.getToken() + events.get(0) + ASEmitterTokens.DOUBLE_QUOTE.getToken() + ASEmitterTokens.COMMA.getToken());
        } else {
            this.writeNewline("null" + ASEmitterTokens.COMMA.getToken());
        }
    }

    private void outputBindings(List<BindingInfo> bindings) {
        if (bindings.size() > 1) {
            int n = bindings.size();
            this.write(ASEmitterTokens.SQUARE_OPEN.getToken() + bindings.get(0).getIndex());
            for (int i = 1; i < n; ++i) {
                BindingInfo binding = bindings.get(i);
                this.write(ASEmitterTokens.COMMA.getToken() + binding.getIndex());
            }
            this.writeNewline(ASEmitterTokens.SQUARE_CLOSE.getToken() + ASEmitterTokens.COMMA.getToken());
        } else if (bindings.size() == 1) {
            this.writeNewline(bindings.get(0).getIndex() + ASEmitterTokens.COMMA.getToken());
        } else {
            this.writeNewline("null" + ASEmitterTokens.COMMA.getToken());
        }
    }

    protected void emitScripts() {
        for (MXMLScriptSpecifier script : this.scripts) {
            String output = script.output();
            if (output.equals("")) continue;
            this.writeNewline(output);
        }
    }

    protected void emitEvents(String cname) {
        for (MXMLEventSpecifier event : this.events) {
            this.writeNewline("/**");
            this.writeNewline(" * @export");
            this.writeNewline(" * @param {" + event.type + "} event");
            this.writeNewline(" */");
            this.writeNewline(cname + ".prototype." + event.eventHandler + " = function(event)");
            this.writeNewline(ASEmitterTokens.BLOCK_OPEN, true);
            this.writeNewline(event.value + ASEmitterTokens.SEMICOLON.getToken(), false);
            this.write(ASEmitterTokens.BLOCK_CLOSE);
            this.writeNewline(";");
            this.writeNewline();
            this.writeNewline();
        }
    }

    protected void emitPropertyGetterSetters(String cname) {
        for (MXMLVF2JSDescriptorSpecifier instance : this.instances) {
            if (instance.id.startsWith(MXMLFlexJSEmitterTokens.ID_PREFIX.getToken())) continue;
            this.writeNewline("/**");
            this.writeNewline(" * @export");
            this.writeNewline(" * @return {" + instance.name + "}");
            this.writeNewline(" */");
            this.writeNewline(cname + ".prototype.get_" + instance.id + " = function()");
            this.indentPush();
            this.writeNewline("{");
            this.indentPop();
            this.writeNewline("return this." + instance.id + ";");
            this.writeNewline("};");
            this.writeNewline();
            this.writeNewline();
            this.writeNewline("/**");
            this.writeNewline(" * @export");
            this.writeNewline(" * @param {" + instance.name + "} value");
            this.writeNewline(" */");
            this.writeNewline(cname + ".prototype.set_" + instance.id + " = function(value)");
            this.indentPush();
            this.writeNewline("{");
            this.indentPush();
            this.writeNewline("if (value != this." + instance.id + ")");
            this.indentPop();
            this.indentPop();
            this.writeNewline("this." + instance.id + " = value;");
            this.writeNewline("};");
            this.writeNewline();
            this.writeNewline();
        }
    }

    protected void emitMXMLDescriptorFuncs(String cname) {
        MXMLVF2JSDescriptorSpecifier root;
        if (this.descriptorTree.size() > 0) {
            root = this.descriptorTree.get(0);
            root.isTopNode = false;
        }
        if (this.propertiesTree.propertySpecifiers.size() > 0 || this.propertiesTree.eventSpecifiers.size() > 0) {
            root = this.propertiesTree;
            root.isTopNode = true;
            this.writeNewline("/**");
            this.writeNewline(" * start");
            this.writeNewline(" *");
            this.writeNewline(" * @export");
            this.writeNewline(" */");
            this.writeNewline(cname + ".prototype.start = function () {");
            this.writeNewline("};");
        }
    }

    @Override
    public void emitEventSpecifier(IMXMLEventSpecifierNode node) {
        IDefinition cdef = node.getDefinition();
        MXMLVF2JSDescriptorSpecifier currentDescriptor = this.getCurrentDescriptor("i");
        MXMLEventSpecifier eventSpecifier = new MXMLEventSpecifier();
        eventSpecifier.eventHandler = MXMLFlexJSEmitterTokens.EVENT_PREFIX.getToken() + this.eventCounter++;
        eventSpecifier.name = cdef.getBaseName();
        eventSpecifier.type = node.getEventParameterDefinition().getTypeAsDisplayString();
        IASEmitter asEmitter = ((IMXMLBlockWalker)this.getMXMLWalker()).getASEmitter();
        StringBuilder sb = null;
        int len = node.getChildCount();
        if (len > 0) {
            sb = new StringBuilder();
            for (int i = 0; i < len; ++i) {
                sb.append(this.getIndent(i > 0 ? 1 : 0) + asEmitter.stringifyNode(node.getChild(i)));
                if (i >= len - 1) continue;
                sb.append(ASEmitterTokens.SEMICOLON.getToken());
                sb.append(ASEmitterTokens.NEW_LINE.getToken());
            }
        }
        eventSpecifier.value = sb.toString();
        if (currentDescriptor != null) {
            currentDescriptor.eventSpecifiers.add(eventSpecifier);
        } else {
            this.propertiesTree.eventSpecifiers.add(eventSpecifier);
        }
        this.events.add(eventSpecifier);
    }

    @Override
    public void emitInstance(IMXMLInstanceNode node) {
        if (this.isStateDependent((IASNode)node) && !this.inStatesOverride) {
            return;
        }
        IClassDefinition cdef = node.getClassReference(this.getMXMLWalker().getProject());
        MXMLVF2JSDescriptorSpecifier currentPropertySpecifier = this.getCurrentDescriptor("ps");
        String id = node.getID();
        if (id == null) {
            id = node.getEffectiveID();
        }
        if (id == null) {
            id = MXMLFlexJSEmitterTokens.ID_PREFIX.getToken() + this.idCounter++;
        }
        MXMLVF2JSDescriptorSpecifier currentInstance = new MXMLVF2JSDescriptorSpecifier();
        currentInstance.isProperty = false;
        currentInstance.id = id;
        currentInstance.name = cdef.getQualifiedName();
        currentInstance.parent = currentPropertySpecifier;
        if (currentPropertySpecifier != null) {
            currentPropertySpecifier.propertySpecifiers.add(currentInstance);
        } else if (this.inMXMLContent) {
            this.descriptorTree.add(currentInstance);
        } else {
            currentInstance.parent = this.propertiesTree;
            this.propertiesTree.propertySpecifiers.add(currentInstance);
        }
        this.instances.add(currentInstance);
        IMXMLPropertySpecifierNode[] pnodes = node.getPropertySpecifierNodes();
        if (pnodes != null) {
            this.moveDown(false, currentInstance, null);
            for (IMXMLPropertySpecifierNode pnode : pnodes) {
                this.getMXMLWalker().walk((IASNode)pnode);
            }
            this.moveUp(false, true);
        } else if (node instanceof IMXMLStateNode) {
            IMXMLStateNode stateNode = (IMXMLStateNode)node;
            String name = stateNode.getStateName();
            if (name != null) {
                MXMLVF2JSDescriptorSpecifier stateName = new MXMLVF2JSDescriptorSpecifier();
                stateName.isProperty = true;
                stateName.id = id;
                stateName.name = "name";
                stateName.value = ASEmitterTokens.SINGLE_QUOTE.getToken() + name + ASEmitterTokens.SINGLE_QUOTE.getToken();
                stateName.parent = currentInstance;
                currentInstance.propertySpecifiers.add(stateName);
            }
            MXMLVF2JSDescriptorSpecifier overrides = new MXMLVF2JSDescriptorSpecifier();
            overrides.isProperty = true;
            overrides.hasArray = true;
            overrides.id = id;
            overrides.name = "overrides";
            overrides.parent = currentInstance;
            currentInstance.propertySpecifiers.add(overrides);
            this.moveDown(false, null, overrides);
            IMXMLClassDefinitionNode classDefinitionNode = stateNode.getClassDefinitionNode();
            List snodes = classDefinitionNode.getNodesDependentOnState(stateNode.getStateName());
            if (snodes != null) {
                for (int i = snodes.size() - 1; i >= 0; --i) {
                    IMXMLNode inode = (IMXMLNode)snodes.get(i);
                    if (inode.getNodeID() != ASTNodeID.MXMLInstanceID) continue;
                    this.emitInstanceOverride((IMXMLInstanceNode)inode);
                }
                for (IMXMLNode anode : snodes) {
                    switch (anode.getNodeID()) {
                        case MXMLPropertySpecifierID: {
                            this.emitPropertyOverride((IMXMLPropertySpecifierNode)anode);
                            break;
                        }
                        case MXMLStyleSpecifierID: {
                            if (!(node instanceof IMXMLStyleSpecifierNode)) break;
                            this.emitStyleOverride((IMXMLStyleSpecifierNode)node);
                            break;
                        }
                        case MXMLEventSpecifierID: {
                            this.emitEventOverride((IMXMLEventSpecifierNode)node);
                            break;
                        }
                    }
                }
            }
            this.moveUp(false, false);
        }
        IMXMLEventSpecifierNode[] enodes = node.getEventSpecifierNodes();
        if (enodes != null) {
            this.moveDown(false, currentInstance, null);
            for (IMXMLEventSpecifierNode enode : enodes) {
                this.getMXMLWalker().walk((IASNode)enode);
            }
            this.moveUp(false, true);
        }
    }

    public void emitPropertyOverride(IMXMLPropertySpecifierNode propertyNode) {
        FlexProject project = (FlexProject)this.getMXMLWalker().getProject();
        Name propertyOverride = project.getPropertyOverrideClassName();
        this.emitPropertyOrStyleOverride(propertyOverride, propertyNode);
    }

    void emitStyleOverride(IMXMLStyleSpecifierNode styleNode) {
        FlexProject project = (FlexProject)this.getMXMLWalker().getProject();
        Name styleOverride = project.getStyleOverrideClassName();
        this.emitPropertyOrStyleOverride(styleOverride, (IMXMLPropertySpecifierNode)styleNode);
    }

    void emitPropertyOrStyleOverride(Name overrideName, IMXMLPropertySpecifierNode propertyOrStyleNode) {
        MXMLVF2JSDescriptorSpecifier currentInstance = this.getCurrentDescriptor("ps");
        IASNode parentNode = propertyOrStyleNode.getParent();
        String id = parentNode instanceof IMXMLInstanceNode ? ((IMXMLInstanceNode)parentNode).getEffectiveID() : "";
        String name = propertyOrStyleNode.getName();
        IMXMLInstanceNode propertyOrStyleValueNode = propertyOrStyleNode.getInstanceNode();
        MXMLVF2JSDescriptorSpecifier setProp = new MXMLVF2JSDescriptorSpecifier();
        setProp.isProperty = false;
        setProp.name = this.nameToString(overrideName);
        setProp.parent = currentInstance;
        currentInstance.propertySpecifiers.add(setProp);
        MXMLVF2JSDescriptorSpecifier target = new MXMLVF2JSDescriptorSpecifier();
        target.isProperty = true;
        target.name = "target";
        target.parent = setProp;
        target.value = ASEmitterTokens.SINGLE_QUOTE.getToken() + id + ASEmitterTokens.SINGLE_QUOTE.getToken();
        setProp.propertySpecifiers.add(target);
        MXMLVF2JSDescriptorSpecifier pname = new MXMLVF2JSDescriptorSpecifier();
        pname.isProperty = true;
        pname.name = "name";
        pname.parent = setProp;
        pname.value = ASEmitterTokens.SINGLE_QUOTE.getToken() + name + ASEmitterTokens.SINGLE_QUOTE.getToken();
        setProp.propertySpecifiers.add(pname);
        MXMLVF2JSDescriptorSpecifier value = new MXMLVF2JSDescriptorSpecifier();
        value.isProperty = true;
        value.name = "value";
        value.parent = setProp;
        setProp.propertySpecifiers.add(value);
        this.moveDown(false, null, value);
        this.getMXMLWalker().walk((IASNode)propertyOrStyleValueNode);
        this.moveUp(false, false);
    }

    void emitEventOverride(IMXMLEventSpecifierNode eventNode) {
        MXMLVF2JSDescriptorSpecifier currentInstance = this.getCurrentDescriptor("ps");
        FlexProject project = (FlexProject)this.getMXMLWalker().getProject();
        Name eventOverride = project.getEventOverrideClassName();
        IASNode parentNode = eventNode.getParent();
        String id = parentNode instanceof IMXMLInstanceNode ? ((IMXMLInstanceNode)parentNode).getEffectiveID() : "";
        String name = eventNode.getName();
        MXMLDocumentNode doc = (MXMLDocumentNode)eventNode.getAncestorOfType(MXMLDocumentNode.class);
        Name eventHandler = doc.cdp.getEventHandlerName(eventNode);
        MXMLVF2JSDescriptorSpecifier setEvent = new MXMLVF2JSDescriptorSpecifier();
        setEvent.isProperty = true;
        setEvent.name = this.nameToString(eventOverride);
        setEvent.parent = currentInstance;
        currentInstance.propertySpecifiers.add(setEvent);
        MXMLVF2JSDescriptorSpecifier target = new MXMLVF2JSDescriptorSpecifier();
        target.isProperty = true;
        target.name = "target";
        target.parent = setEvent;
        target.value = ASEmitterTokens.SINGLE_QUOTE.getToken() + id + ASEmitterTokens.SINGLE_QUOTE.getToken();
        setEvent.propertySpecifiers.add(target);
        MXMLVF2JSDescriptorSpecifier pname = new MXMLVF2JSDescriptorSpecifier();
        pname.isProperty = true;
        pname.name = "name";
        pname.parent = setEvent;
        pname.value = ASEmitterTokens.SINGLE_QUOTE.getToken() + name + ASEmitterTokens.SINGLE_QUOTE.getToken();
        setEvent.propertySpecifiers.add(pname);
        MXMLVF2JSDescriptorSpecifier handler = new MXMLVF2JSDescriptorSpecifier();
        handler.isProperty = false;
        handler.name = "handlerFunction";
        handler.parent = setEvent;
        handler.value = eventHandler.toString();
        setEvent.propertySpecifiers.add(handler);
    }

    public void emitInstanceOverride(IMXMLInstanceNode instanceNode) {
        this.inStatesOverride = true;
        MXMLVF2JSDescriptorSpecifier currentInstance = this.getCurrentDescriptor("ps");
        FlexProject project = (FlexProject)this.getMXMLWalker().getProject();
        Name instanceOverrideName = project.getInstanceOverrideClassName();
        MXMLVF2JSDescriptorSpecifier addItems = new MXMLVF2JSDescriptorSpecifier();
        addItems.isProperty = false;
        addItems.name = this.nameToString(instanceOverrideName);
        addItems.parent = currentInstance;
        currentInstance.propertySpecifiers.add(addItems);
        MXMLVF2JSDescriptorSpecifier itemsDesc = new MXMLVF2JSDescriptorSpecifier();
        itemsDesc.isProperty = true;
        itemsDesc.hasArray = true;
        itemsDesc.name = "itemsDescriptor";
        itemsDesc.parent = addItems;
        addItems.propertySpecifiers.add(itemsDesc);
        boolean oldInMXMLContent = this.inMXMLContent;
        this.moveDown(false, null, itemsDesc);
        this.inMXMLContent = true;
        this.getMXMLWalker().walk((IASNode)instanceNode);
        this.inMXMLContent = oldInMXMLContent;
        this.moveUp(false, false);
        IMXMLPropertySpecifierNode propertySpecifier = (IMXMLPropertySpecifierNode)instanceNode.getAncestorOfType(IMXMLPropertySpecifierNode.class);
        if (propertySpecifier == null) {
            assert (false);
        } else {
            IASNode parent = propertySpecifier.getParent();
            if (parent instanceof IMXMLInstanceNode) {
                IMXMLInstanceNode parentInstance = (IMXMLInstanceNode)parent;
                String parentId = parentInstance.getEffectiveID();
                assert (parentId != null);
                String propName = propertySpecifier.getName();
                MXMLVF2JSDescriptorSpecifier dest = new MXMLVF2JSDescriptorSpecifier();
                dest.isProperty = true;
                dest.name = "destination";
                dest.parent = addItems;
                dest.value = ASEmitterTokens.SINGLE_QUOTE.getToken() + parentId + ASEmitterTokens.SINGLE_QUOTE.getToken();
                addItems.propertySpecifiers.add(dest);
                MXMLVF2JSDescriptorSpecifier prop = new MXMLVF2JSDescriptorSpecifier();
                prop.isProperty = true;
                prop.name = "propertyName";
                prop.parent = addItems;
                prop.value = ASEmitterTokens.SINGLE_QUOTE.getToken() + propName + ASEmitterTokens.SINGLE_QUOTE.getToken();
                addItems.propertySpecifiers.add(prop);
            }
        }
        String positionPropertyValue = null;
        String relativeToPropertyValue = null;
        IASNode instanceParent = instanceNode.getParent();
        IASNode prevStatelessSibling = null;
        for (int i = 0; i < instanceParent.getChildCount(); ++i) {
            IASNode sib = instanceParent.getChild(i);
            assert (sib instanceof IMXMLInstanceNode);
            if (sib == instanceNode) break;
            if (this.isStateDependent(sib)) continue;
            prevStatelessSibling = sib;
        }
        if (prevStatelessSibling == null) {
            positionPropertyValue = "first";
        } else {
            positionPropertyValue = "after";
            relativeToPropertyValue = ((IMXMLInstanceNode)prevStatelessSibling).getEffectiveID();
        }
        MXMLVF2JSDescriptorSpecifier pos = new MXMLVF2JSDescriptorSpecifier();
        pos.isProperty = true;
        pos.name = "position";
        pos.parent = addItems;
        pos.value = ASEmitterTokens.SINGLE_QUOTE.getToken() + positionPropertyValue + ASEmitterTokens.SINGLE_QUOTE.getToken();
        addItems.propertySpecifiers.add(pos);
        if (relativeToPropertyValue != null) {
            MXMLVF2JSDescriptorSpecifier rel = new MXMLVF2JSDescriptorSpecifier();
            rel.isProperty = true;
            rel.name = "relativeTo";
            rel.parent = addItems;
            rel.value = ASEmitterTokens.SINGLE_QUOTE.getToken() + relativeToPropertyValue + ASEmitterTokens.SINGLE_QUOTE.getToken();
            addItems.propertySpecifiers.add(rel);
        }
        this.inStatesOverride = false;
    }

    private String nameToString(Name name) {
        String s = "";
        Namespace ns = name.getSingleQualifier();
        s = ns.getName() + ASEmitterTokens.MEMBER_ACCESS.getToken() + name.getBaseName();
        return s;
    }

    protected boolean isStateDependent(IASNode node) {
        if (node instanceof IMXMLSpecifierNode) {
            String suffix = ((IMXMLSpecifierNode)node).getSuffix();
            return suffix != null && suffix.length() > 0;
        }
        return this.isStateDependentInstance(node);
    }

    protected boolean isStateDependentInstance(IASNode node) {
        if (node instanceof IMXMLInstanceNode) {
            String[] includeIn = ((IMXMLInstanceNode)node).getIncludeIn();
            String[] excludeFrom = ((IMXMLInstanceNode)node).getExcludeFrom();
            return includeIn != null || excludeFrom != null;
        }
        return false;
    }

    public static boolean isDataBindingNode(IASNode node) {
        return node instanceof IMXMLDataBindingNode;
    }

    protected static boolean isDataboundProp(IMXMLPropertySpecifierNode propertyNode) {
        boolean ret = propertyNode.getChildCount() > 0 && MXMLVF2JSEmitter.isDataBindingNode((IASNode)propertyNode.getInstanceNode());
        int n = propertyNode.getChildCount();
        for (int i = 0; i < n; ++i) {
            boolean db = MXMLVF2JSEmitter.isDataBindingNode(propertyNode.getChild(i));
            assert (db == ret);
        }
        return ret;
    }

    @Override
    public void emitPropertySpecifier(IMXMLPropertySpecifierNode node) {
        boolean bypass;
        if (MXMLVF2JSEmitter.isDataboundProp(node)) {
            return;
        }
        IDefinition cdef = node.getDefinition();
        IASNode cnode = node.getChild(0);
        MXMLVF2JSDescriptorSpecifier currentInstance = this.getCurrentDescriptor("i");
        MXMLVF2JSDescriptorSpecifier currentPropertySpecifier = new MXMLVF2JSDescriptorSpecifier();
        currentPropertySpecifier.isProperty = true;
        currentPropertySpecifier.name = cdef.getQualifiedName();
        currentPropertySpecifier.parent = currentInstance;
        boolean oldInMXMLContent = this.inMXMLContent;
        if (currentPropertySpecifier.name.equals("mxmlContent")) {
            this.inMXMLContent = true;
        }
        if (currentInstance != null) {
            currentInstance.propertySpecifiers.add(currentPropertySpecifier);
        } else if (this.inMXMLContent) {
            this.descriptorTree.add(currentPropertySpecifier);
        } else {
            currentPropertySpecifier.parent = this.propertiesTree;
            this.propertiesTree.propertySpecifiers.add(currentPropertySpecifier);
        }
        currentPropertySpecifier.hasArray = bypass = cnode != null && cnode instanceof IMXMLArrayNode;
        this.moveDown(bypass, null, currentPropertySpecifier);
        this.getMXMLWalker().walk(cnode);
        this.moveUp(bypass, false);
        this.inMXMLContent = oldInMXMLContent;
    }

    @Override
    public void emitScript(IMXMLScriptNode node) {
        IASEmitter asEmitter = ((IMXMLBlockWalker)this.getMXMLWalker()).getASEmitter();
        String nl = ASEmitterTokens.NEW_LINE.getToken();
        StringBuilder sb = null;
        MXMLScriptSpecifier scriptSpecifier = null;
        int len = node.getChildCount();
        if (len > 0) {
            for (int i = 0; i < len; ++i) {
                IASNode cnode = node.getChild(i);
                if (cnode instanceof IImportNode) continue;
                sb = new StringBuilder();
                scriptSpecifier = new MXMLScriptSpecifier();
                sb.append(asEmitter.stringifyNode(cnode));
                sb.append(ASEmitterTokens.SEMICOLON.getToken());
                if (i == len - 1) {
                    this.indentPop();
                }
                sb.append(nl);
                sb.append(nl);
                scriptSpecifier.fragment = sb.toString();
                this.scripts.add(scriptSpecifier);
            }
        }
    }

    @Override
    public void emitStyleSpecifier(IMXMLStyleSpecifierNode node) {
    }

    @Override
    public void emitArray(IMXMLArrayNode node) {
        this.moveDown(false, null, null);
        int len = node.getChildCount();
        for (int i = 0; i < len; ++i) {
            this.getMXMLWalker().walk(node.getChild(i));
        }
        this.moveUp(false, false);
    }

    @Override
    public void emitString(IMXMLStringNode node) {
        this.getCurrentDescriptor((String)"ps").valueNeedsQuotes = true;
        this.emitAttributeValue((IASNode)node);
    }

    @Override
    public void emitLiteral(IMXMLLiteralNode node) {
        MXMLVF2JSDescriptorSpecifier ps = this.getCurrentDescriptor("ps");
        ps.value = "";
        if (ps.valueNeedsQuotes) {
            ps.value = ps.value + ASEmitterTokens.SINGLE_QUOTE.getToken();
        }
        String s = node.getValue().toString();
        if (ps.valueNeedsQuotes) {
            s = s.replace(ASEmitterTokens.SINGLE_QUOTE.getToken(), "\\" + ASEmitterTokens.SINGLE_QUOTE.getToken());
        }
        ps.value = ps.value + s;
        if (ps.valueNeedsQuotes) {
            ps.value = ps.value + ASEmitterTokens.SINGLE_QUOTE.getToken();
        }
    }

    @Override
    public void emitFactory(IMXMLFactoryNode node) {
        MXMLVF2JSDescriptorSpecifier ps = this.getCurrentDescriptor("ps");
        ps.value = "new mx.core.ClassFactory(";
        IASNode cnode = node.getChild(0);
        if (cnode instanceof IMXMLClassNode) {
            ps.value = ps.value + ((IMXMLClassNode)cnode).getValue(this.getMXMLWalker().getProject()).getQualifiedName();
        }
        ps.value = ps.value + ")";
    }

    @Override
    public void emitComponent(IMXMLComponentNode node) {
        MXMLVF2JSDescriptorSpecifier ps = this.getCurrentDescriptor("ps");
        ps.value = "new mx.core.ClassFactory(";
        ps.value = ps.value + node.getName();
        ps.value = ps.value + ")";
        this.setBufferWrite(true);
        this.emitSubDocument(node);
        this.subDocuments.append(this.getBuilder().toString());
        this.getBuilder().setLength(0);
        this.setBufferWrite(false);
    }

    private void emitHeader(IMXMLDocumentNode node) {
        IClassDefinition cdef;
        ASProjectScope projectScope;
        ICompilationUnit cu;
        String cname = node.getFileNode().getName();
        String bcname = node.getBaseClassName();
        this.writeNewline("/**");
        this.writeNewline(" * " + cname);
        this.writeNewline(" *");
        this.writeNewline(" * @fileoverview");
        this.writeNewline(" *");
        this.writeNewline(" * @suppress {checkTypes}");
        this.writeNewline(" */");
        this.writeNewline();
        this.emitHeaderLine(cname, true);
        for (String subDocumentName : this.subDocumentNames) {
            this.emitHeaderLine(subDocumentName, true);
        }
        this.writeNewline();
        this.emitHeaderLine(bcname);
        ArrayList<String> writtenInstances = new ArrayList<String>();
        writtenInstances.add(cname);
        writtenInstances.add(bcname);
        for (MXMLVF2JSDescriptorSpecifier instance : this.instances) {
            String name = instance.name;
            if (writtenInstances.indexOf(name) != -1) continue;
            this.emitHeaderLine(name);
            writtenInstances.add(name);
        }
        FlexJSProject project = (FlexJSProject)this.getMXMLWalker().getProject();
        ArrayList<String> deps = project.getRequires(cu = (projectScope = project.getScope()).getCompilationUnitForDefinition((IDefinition)(cdef = node.getDefinition())));
        if (deps != null) {
            for (String imp : deps) {
                if (imp.indexOf(JSGoogEmitterTokens.AS3.getToken()) != -1 || imp.equals(cname) || imp.equals("mx.binding.Binding") || imp.equals("mx.binding.BindingManager") || imp.equals("mx.binding.FunctionReturnWatcher") || imp.equals("mx.binding.PropertyWatcher") || imp.equals("mx.binding.StaticPropertyWatcher") || imp.equals("mx.binding.XMLWatcher") || imp.equals("mx.events.PropertyChangeEvent") || imp.equals("mx.events.PropertyChangeEventKind") || imp.equals("mx.core.DeferredInstanceFromFunction") || NativeUtils.isNative(imp) || writtenInstances.indexOf(imp) != -1) continue;
                this.emitHeaderLine(imp);
                writtenInstances.add(imp);
            }
        }
        if (project.mainCU != null && cu.getName().equals(project.mainCU.getName())) {
            this.emitHeaderLine(JSFlexJSEmitterTokens.LANGUAGE_QNAME.getToken());
        }
        this.writeNewline();
        this.writeNewline();
    }

    private void emitHeaderLine(String qname) {
        this.emitHeaderLine(qname, false);
    }

    private void emitHeaderLine(String qname, boolean isProvide) {
        this.write(isProvide ? JSGoogEmitterTokens.GOOG_PROVIDE : JSGoogEmitterTokens.GOOG_REQUIRE);
        this.write(ASEmitterTokens.PAREN_OPEN);
        this.write(ASEmitterTokens.SINGLE_QUOTE);
        this.write(qname);
        this.write(ASEmitterTokens.SINGLE_QUOTE);
        this.write(ASEmitterTokens.PAREN_CLOSE);
        this.writeNewline(ASEmitterTokens.SEMICOLON);
    }

    @Override
    protected void emitAttributeValue(IASNode node) {
        IMXMLLiteralNode cnode = (IMXMLLiteralNode)node.getChild(0);
        if (cnode.getValue() != null) {
            this.getMXMLWalker().walk((IASNode)cnode);
        }
    }

    private MXMLVF2JSDescriptorSpecifier getCurrentDescriptor(String type) {
        MXMLVF2JSDescriptorSpecifier currentDescriptor = null;
        if (type.equals("i")) {
            int index = this.currentInstances.size() - 1;
            if (index > -1) {
                currentDescriptor = this.currentInstances.get(index);
            }
        } else {
            int index = this.currentPropertySpecifiers.size() - 1;
            if (index > -1) {
                currentDescriptor = this.currentPropertySpecifiers.get(index);
            }
        }
        return currentDescriptor;
    }

    protected void moveDown(boolean byPass, MXMLVF2JSDescriptorSpecifier currentInstance, MXMLVF2JSDescriptorSpecifier currentPropertySpecifier) {
        if (!byPass && currentInstance != null) {
            this.currentInstances.add(currentInstance);
        }
        if (currentPropertySpecifier != null) {
            this.currentPropertySpecifiers.add(currentPropertySpecifier);
        }
    }

    protected void moveUp(boolean byPass, boolean isInstance) {
        if (!byPass) {
            if (isInstance) {
                int index = this.currentInstances.size() - 1;
                if (index > -1) {
                    this.currentInstances.remove(index);
                }
            } else {
                int index = this.currentPropertySpecifiers.size() - 1;
                if (index > -1) {
                    this.currentPropertySpecifiers.remove(index);
                }
            }
        }
    }
}

