/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.codegen.mxml.flexjs;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.FileFileFilter;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.RegexFileFilter;
import org.apache.flex.compiler.clients.problems.ProblemQuery;
import org.apache.flex.compiler.codegen.js.IJSPublisher;
import org.apache.flex.compiler.config.Configuration;
import org.apache.flex.compiler.css.ICSSPropertyValue;
import org.apache.flex.compiler.internal.codegen.js.JSSharedData;
import org.apache.flex.compiler.internal.codegen.js.goog.JSGoogEmitterTokens;
import org.apache.flex.compiler.internal.codegen.js.goog.JSGoogPublisher;
import org.apache.flex.compiler.internal.css.CSSArrayPropertyValue;
import org.apache.flex.compiler.internal.css.CSSFontFace;
import org.apache.flex.compiler.internal.css.CSSFunctionCallPropertyValue;
import org.apache.flex.compiler.internal.driver.js.flexjs.JSCSSCompilationSession;
import org.apache.flex.compiler.internal.driver.js.goog.JSGoogConfiguration;
import org.apache.flex.compiler.internal.graph.GoogDepsWriter;
import org.apache.flex.compiler.internal.projects.FlexJSProject;
import org.apache.flex.compiler.utils.JSClosureCompilerWrapper;
import org.apache.flex.swc.ISWC;
import org.apache.flex.swc.ISWCFileEntry;

public class MXMLFlexJSPublisher
extends JSGoogPublisher
implements IJSPublisher {
    public static final String FLEXJS_OUTPUT_DIR_NAME = "bin";
    public static final String FLEXJS_INTERMEDIATE_DIR_NAME = "js-debug";
    public static final String FLEXJS_RELEASE_DIR_NAME = "js-release";
    private static final String FLEXJS_EXTERNS = "externs";
    private FlexJSProject project;
    private boolean isMarmotinniRun;
    private String outputPathParameter;
    private boolean useStrictPublishing;
    private String closureLibDirPath;

    public MXMLFlexJSPublisher(Configuration config, FlexJSProject project) {
        super(config);
        this.isMarmotinniRun = ((JSGoogConfiguration)this.configuration).getMarmotinni() != null;
        this.outputPathParameter = this.configuration.getOutput();
        this.useStrictPublishing = ((JSGoogConfiguration)this.configuration).getStrictPublish();
        this.project = project;
    }

    @Override
    public File getOutputFolder() {
        if (this.isMarmotinniRun) {
            this.outputParentFolder = new File(((JSGoogConfiguration)this.configuration).getMarmotinni());
        } else if (this.outputPathParameter != null) {
            this.outputParentFolder = new File(this.outputPathParameter);
            if (this.outputPathParameter.contains(".swf")) {
                this.outputParentFolder = this.outputParentFolder.getParentFile().getParentFile();
            }
        } else {
            this.outputParentFolder = new File(this.configuration.getTargetFileDirectory()).getParentFile();
        }
        this.outputParentFolder = new File(this.outputParentFolder, FLEXJS_OUTPUT_DIR_NAME);
        this.outputFolder = new File(this.outputParentFolder, File.separator + FLEXJS_INTERMEDIATE_DIR_NAME);
        if (!this.isMarmotinniRun && !((JSGoogConfiguration)this.configuration).getSkipTranspile()) {
            this.setupOutputFolder();
        }
        return this.outputFolder;
    }

    @Override
    public boolean publish(ProblemQuery problems) throws IOException {
        String intermediateDirPath = this.outputFolder.getPath();
        File intermediateDir = new File(intermediateDirPath);
        File srcDir = new File(this.configuration.getTargetFile());
        srcDir = srcDir.getAbsoluteFile();
        srcDir = srcDir.getParentFile();
        String projectName = FilenameUtils.getBaseName((String)this.configuration.getTargetFile());
        String outputFileName = projectName + "." + JSSharedData.OUTPUT_EXTENSION;
        File releaseDir = new File(this.outputParentFolder, FLEXJS_RELEASE_DIR_NAME);
        String releaseDirPath = releaseDir.getPath();
        if (!this.isMarmotinniRun) {
            if (releaseDir.exists()) {
                FileUtils.deleteQuietly((File)releaseDir);
            }
            if (!this.configuration.debug() && !releaseDir.mkdirs()) {
                throw new IOException("Unable to create release directory at " + releaseDir.getAbsolutePath());
            }
        }
        if (((JSGoogConfiguration)this.configuration).isClosureLibSet()) {
            this.closureLibDirPath = ((JSGoogConfiguration)this.configuration).getClosureLib();
        } else {
            URL resource = Thread.currentThread().getContextClassLoader().getResource("goog/deps.js");
            if (resource != null) {
                File closureLibDir = new File(intermediateDir.getParent(), "closure");
                if (!closureLibDir.exists()) {
                    if (!closureLibDir.mkdirs()) {
                        throw new IOException("Unable to create directory for closure-lib at " + closureLibDir.getAbsolutePath());
                    }
                    String resourceJarPath = resource.getFile();
                    if (resourceJarPath.contains(":")) {
                        resourceJarPath = resourceJarPath.substring(resourceJarPath.lastIndexOf(":") + 1);
                    }
                    if (resourceJarPath.contains("!")) {
                        resourceJarPath = resourceJarPath.substring(0, resourceJarPath.indexOf("!"));
                    }
                    File resourceJar = new File(resourceJarPath);
                    this.dumpJar(resourceJar, closureLibDir);
                }
                this.closureLibDirPath = intermediateDir.getParentFile().getPath();
            } else {
                this.closureLibDirPath = ((JSGoogConfiguration)this.configuration).getClosureLib();
            }
        }
        URL resource = Thread.currentThread().getContextClassLoader().getResource("FlexJS/src/createjs_externals.js");
        if (resource != null) {
            File flexJsLibDir = new File(intermediateDir.getParent(), "flexjs");
            if (!flexJsLibDir.exists()) {
                if (!flexJsLibDir.mkdirs()) {
                    throw new IOException("Unable to create directory for flexjs-lib at " + flexJsLibDir.getAbsolutePath());
                }
                String resourceJarPath = resource.getFile();
                if (resourceJarPath.contains(":")) {
                    resourceJarPath = resourceJarPath.substring(resourceJarPath.lastIndexOf(":") + 1);
                }
                if (resourceJarPath.contains("!")) {
                    resourceJarPath = resourceJarPath.substring(0, resourceJarPath.indexOf("!"));
                }
                File resourceJar = new File(resourceJarPath);
                this.dumpJar(resourceJar, flexJsLibDir);
            }
            String string = intermediateDir.getParentFile().getPath();
        }
        String closureGoogSrcLibDirPath = this.closureLibDirPath + "/closure/goog/";
        String closureGoogTgtLibDirPath = intermediateDirPath + "/library/closure/goog";
        String depsTgtFilePath = intermediateDirPath + "/deps.js";
        String projectIntermediateJSFilePath = intermediateDirPath + File.separator + outputFileName;
        String projectReleaseJSFilePath = releaseDirPath + File.separator + outputFileName;
        if (!((JSGoogConfiguration)this.configuration).getSkipTranspile()) {
            this.appendExportSymbol(projectIntermediateJSFilePath, projectName);
            this.appendEncodedCSS(projectIntermediateJSFilePath, projectName);
            FileUtils.copyDirectory((File)new File(closureGoogSrcLibDirPath), (File)new File(closureGoogTgtLibDirPath));
        }
        JSClosureCompilerWrapper compilerWrapper = new JSClosureCompilerWrapper(((JSGoogConfiguration)this.configuration).getJSCompilerOptions());
        List swcs = this.project.getLibraries();
        for (ISWC swc : swcs) {
            Map files = swc.getFiles();
            for (String key : files.keySet()) {
                int bytes_read;
                ISWCFileEntry fileEntry;
                if (!key.startsWith(FLEXJS_EXTERNS) || (fileEntry = swc.getFile(key)) == null) continue;
                File destFile = new File(intermediateDirPath + File.separator + key);
                InputStream inStream = fileEntry.createInputStream();
                FileOutputStream outStream = FileUtils.openOutputStream((File)destFile);
                byte[] b = new byte[0x100000];
                while ((bytes_read = inStream.read(b)) != -1) {
                    ((OutputStream)outStream).write(b, 0, bytes_read);
                }
                outStream.flush();
                ((OutputStream)outStream).close();
                inStream.close();
                String destPath = destFile.getAbsolutePath();
                System.out.println("using extern: " + destPath);
                compilerWrapper.addJSExternsFile(destPath);
            }
        }
        GoogDepsWriter gdw = new GoogDepsWriter(intermediateDir, projectName, (JSGoogConfiguration)this.configuration, swcs);
        StringBuilder depsFileData = new StringBuilder();
        try {
            ArrayList<String> fileList = gdw.getListOfFiles(problems);
            for (String file : fileList) {
                compilerWrapper.addJSSourceFile(file);
            }
            boolean ok = gdw.generateDeps(problems, depsFileData);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return false;
        }
        IOFileFilter pngSuffixFilter = FileFilterUtils.and((IOFileFilter[])new IOFileFilter[]{FileFileFilter.FILE, FileFilterUtils.suffixFileFilter((String)".png")});
        IOFileFilter gifSuffixFilter = FileFilterUtils.and((IOFileFilter[])new IOFileFilter[]{FileFileFilter.FILE, FileFilterUtils.suffixFileFilter((String)".gif")});
        IOFileFilter jpgSuffixFilter = FileFilterUtils.and((IOFileFilter[])new IOFileFilter[]{FileFileFilter.FILE, FileFilterUtils.suffixFileFilter((String)".jpg")});
        IOFileFilter jsonSuffixFilter = FileFilterUtils.and((IOFileFilter[])new IOFileFilter[]{FileFileFilter.FILE, FileFilterUtils.suffixFileFilter((String)".json")});
        IOFileFilter assetFiles = FileFilterUtils.or((IOFileFilter[])new IOFileFilter[]{pngSuffixFilter, jpgSuffixFilter, gifSuffixFilter, jsonSuffixFilter});
        IOFileFilter subdirs = FileFilterUtils.or((IOFileFilter[])new IOFileFilter[]{DirectoryFileFilter.DIRECTORY, assetFiles});
        FileUtils.copyDirectory((File)srcDir, (File)intermediateDir, (FileFilter)subdirs);
        if (!this.configuration.debug()) {
            FileUtils.copyDirectory((File)srcDir, (File)releaseDir, (FileFilter)subdirs);
        }
        if (!((JSGoogConfiguration)this.configuration).getSkipTranspile()) {
            this.writeHTML("intermediate", projectName, intermediateDirPath, depsFileData.toString(), gdw.additionalHTML);
        }
        if (!this.configuration.debug()) {
            this.writeHTML("release", projectName, releaseDirPath, null, gdw.additionalHTML);
        }
        if (this.project.needCSS || ((JSGoogConfiguration)this.configuration).getSkipTranspile()) {
            if (!((JSGoogConfiguration)this.configuration).getSkipTranspile()) {
                this.writeCSS(projectName, intermediateDirPath);
            }
            if (!this.configuration.debug()) {
                FileUtils.copyFile((File)new File(intermediateDirPath + File.separator + projectName + ".css"), (File)new File(releaseDirPath + File.separator + projectName + ".css"));
            }
        }
        if (!this.configuration.debug()) {
            Collection files = FileUtils.listFiles((File)new File(closureGoogSrcLibDirPath), (IOFileFilter)new RegexFileFilter("^.*(\\.js)"), (IOFileFilter)DirectoryFileFilter.DIRECTORY);
            for (File file : files) {
                compilerWrapper.addJSSourceFile(file.getCanonicalPath());
            }
            compilerWrapper.setOptions(projectReleaseJSFilePath, this.useStrictPublishing, projectName);
            List<String> externs = ((JSGoogConfiguration)this.configuration).getExternalJSLib();
            for (String extern : externs) {
                compilerWrapper.addJSExternsFile(extern);
            }
            compilerWrapper.targetFilePath = projectReleaseJSFilePath;
            compilerWrapper.compile();
            this.appendSourceMapLocation(projectReleaseJSFilePath, projectName);
        }
        System.out.println("The project '" + projectName + "' has been successfully compiled and optimized.");
        return true;
    }

    private void appendExportSymbol(String path, String projectName) throws IOException {
    }

    private void appendEncodedCSS(String path, String projectName) throws IOException {
        if (!this.project.needCSS) {
            return;
        }
        StringBuilder appendString = new StringBuilder();
        appendString.append("\n\n");
        appendString.append(projectName);
        appendString.append(".prototype.cssData = [");
        JSCSSCompilationSession cssSession = (JSCSSCompilationSession)this.project.getCSSCompilationSession();
        String s = cssSession.getEncodedCSS();
        int reqidx = s.indexOf(JSGoogEmitterTokens.GOOG_REQUIRE.getToken());
        if (reqidx != -1) {
            String reqs = s.substring(reqidx);
            s = s.substring(0, reqidx - 1);
            String fileData = this.readCode(new File(path));
            reqidx = fileData.indexOf(JSGoogEmitterTokens.GOOG_REQUIRE.getToken());
            String after = fileData.substring(reqidx);
            String before = fileData.substring(0, reqidx - 1);
            s = before + reqs + after + appendString.toString() + s;
            this.writeFile(path, s, false);
        } else {
            appendString.append(s);
            this.writeFile(path, appendString.toString(), true);
        }
    }

    protected String readCode(File file) {
        String code = "";
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF8"));
            String line = in.readLine();
            while (line != null) {
                code = code + line + "\n";
                line = in.readLine();
            }
            code = code.substring(0, code.length() - 1);
            in.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return code;
    }

    protected void writeHTML(String type, String projectName, String dirPath, String deps, List<String> additionalHTML) throws IOException {
        StringBuilder htmlFile = new StringBuilder();
        htmlFile.append("<!DOCTYPE html>\n");
        htmlFile.append("<html>\n");
        htmlFile.append("<head>\n");
        htmlFile.append("\t<meta http-equiv=\"X-UA-Compatible\" content=\"IE=edge,chrome=1\">\n");
        htmlFile.append("\t<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\">\n");
        htmlFile.append("\t<link rel=\"stylesheet\" type=\"text/css\" href=\"").append(projectName).append(".css\">\n");
        for (String s : additionalHTML) {
            htmlFile.append(s).append("\n");
        }
        if ("intermediate".equals(type)) {
            htmlFile.append("\t<script type=\"text/javascript\" src=\"./library/closure/goog/base.js\"></script>\n");
            htmlFile.append("\t<script type=\"text/javascript\">\n");
            htmlFile.append(deps);
            htmlFile.append("\t\tgoog.require(\"");
            htmlFile.append(projectName);
            htmlFile.append("\");\n");
            htmlFile.append("\t</script>\n");
        } else {
            htmlFile.append("\t<script type=\"text/javascript\" src=\"./");
            htmlFile.append(projectName);
            htmlFile.append(".js\"></script>\n");
        }
        htmlFile.append("</head>\n");
        htmlFile.append("<body>\n");
        htmlFile.append("\t<script type=\"text/javascript\">\n");
        htmlFile.append("\t\tnew ");
        htmlFile.append(projectName);
        htmlFile.append("()");
        htmlFile.append(".start();\n");
        htmlFile.append("\t</script>\n");
        htmlFile.append("</body>\n");
        htmlFile.append("</html>");
        this.writeFile(dirPath + File.separator + "index.html", htmlFile.toString(), false);
    }

    private void writeCSS(String projectName, String dirPath) throws IOException {
        JSCSSCompilationSession cssSession = (JSCSSCompilationSession)this.project.getCSSCompilationSession();
        this.writeFile(dirPath + File.separator + projectName + ".css", cssSession.emitCSS(), false);
        for (CSSFontFace fontFace : cssSession.fontFaces) {
            String configdir = ((JSGoogConfiguration)this.configuration).getLoadConfig();
            File dir = new File(configdir);
            dir = dir.getParentFile();
            for (ICSSPropertyValue prop : fontFace.getSources()) {
                int c;
                if (prop instanceof CSSArrayPropertyValue) {
                    for (ICSSPropertyValue value : ((CSSArrayPropertyValue)prop).getElements()) {
                        int c2;
                        CSSFunctionCallPropertyValue fn = (CSSFunctionCallPropertyValue)value;
                        String fontPath = fn.rawArguments;
                        if (fontPath.startsWith("'")) {
                            fontPath = fontPath.substring(1, fontPath.length() - 1);
                        }
                        if (fontPath.startsWith("\"")) {
                            fontPath = fontPath.substring(1, fontPath.length() - 1);
                        }
                        if ((c2 = fontPath.indexOf("?")) != -1) {
                            fontPath = fontPath.substring(0, c2);
                        }
                        File fontFile = new File(dir.getAbsolutePath() + File.separator + fontPath);
                        File destFile = new File(dirPath + File.separator + fontPath);
                        if (!fontFile.exists() || destFile.exists()) continue;
                        FileUtils.copyFile((File)fontFile, (File)destFile);
                    }
                    continue;
                }
                if (!(prop instanceof CSSFunctionCallPropertyValue)) continue;
                CSSFunctionCallPropertyValue fn = (CSSFunctionCallPropertyValue)prop;
                String fontPath = fn.rawArguments;
                if (fontPath.startsWith("'")) {
                    fontPath = fontPath.substring(1, fontPath.length() - 1);
                }
                if (fontPath.startsWith("\"")) {
                    fontPath = fontPath.substring(1, fontPath.length() - 1);
                }
                if ((c = fontPath.indexOf("?")) != -1) {
                    fontPath = fontPath.substring(0, c);
                }
                File fontFile = new File(dir.getAbsolutePath() + File.separator + fontPath);
                File destFile = new File(dirPath + File.separator + fontPath);
                if (!fontFile.exists() || destFile.exists()) continue;
                FileUtils.copyFile((File)fontFile, (File)destFile);
            }
        }
    }

    class DependencyLineComparator
    implements Comparator<DependencyRecord> {
        DependencyLineComparator() {
        }

        @Override
        public int compare(DependencyRecord o1, DependencyRecord o2) {
            return new Integer(o1.lineNumber).compareTo(o2.lineNumber);
        }
    }

    class DependencyRecord {
        String path;
        String deps;
        String line;
        int lineNumber;

        DependencyRecord() {
        }
    }
}

