/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.codegen.mxml;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.apache.flex.compiler.codegen.js.IJSEmitter;
import org.apache.flex.compiler.codegen.mxml.IMXMLEmitter;
import org.apache.flex.compiler.driver.js.IJSBackend;
import org.apache.flex.compiler.internal.codegen.js.JSFilterWriter;
import org.apache.flex.compiler.internal.codegen.js.JSSharedData;
import org.apache.flex.compiler.internal.codegen.js.JSWriter;
import org.apache.flex.compiler.problems.ICompilerProblem;
import org.apache.flex.compiler.projects.IASProject;
import org.apache.flex.compiler.units.ICompilationUnit;
import org.apache.flex.compiler.visitor.as.IASBlockWalker;
import org.apache.flex.compiler.visitor.mxml.IMXMLBlockWalker;

public class MXMLWriter
extends JSWriter {
    public MXMLWriter(IASProject project, List<ICompilerProblem> problems, ICompilationUnit compilationUnit, boolean enableDebug) {
        super(project, problems, compilationUnit, enableDebug);
    }

    @Override
    public void writeTo(OutputStream out, File sourceMapOut) {
        IJSBackend backend = (IJSBackend)JSSharedData.backend;
        JSFilterWriter writer = (JSFilterWriter)backend.createWriterBuffer(this.project);
        IJSEmitter asEmitter = (IJSEmitter)backend.createEmitter(writer);
        IASBlockWalker asBlockWalker = backend.createWalker(this.project, this.problems, asEmitter);
        IMXMLEmitter mxmlEmitter = backend.createMXMLEmitter(writer);
        IMXMLBlockWalker mxmlBlockWalker = backend.createMXMLWalker(this.project, this.problems, mxmlEmitter, asEmitter, asBlockWalker);
        mxmlBlockWalker.visitCompilationUnit(this.compilationUnit);
        try {
            out.write(mxmlEmitter.postProcess(writer.toString()).getBytes());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (sourceMapOut != null) {
            String fileName = new File(this.compilationUnit.getAbsoluteFilename()).getName();
            System.out.println("Source map cannot be generated for '" + fileName + "'.");
        }
    }
}

