/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.codegen.js.vf2js;

import java.io.FilterWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.flex.compiler.codegen.js.goog.IJSGoogDocEmitter;
import org.apache.flex.compiler.codegen.js.vf2js.IJSVF2JSEmitter;
import org.apache.flex.compiler.common.ASModifier;
import org.apache.flex.compiler.common.ModifiersSet;
import org.apache.flex.compiler.definitions.IClassDefinition;
import org.apache.flex.compiler.definitions.IDefinition;
import org.apache.flex.compiler.definitions.IFunctionDefinition;
import org.apache.flex.compiler.definitions.IPackageDefinition;
import org.apache.flex.compiler.definitions.IParameterDefinition;
import org.apache.flex.compiler.definitions.ITypeDefinition;
import org.apache.flex.compiler.internal.codegen.as.ASEmitterTokens;
import org.apache.flex.compiler.internal.codegen.js.JSEmitterTokens;
import org.apache.flex.compiler.internal.codegen.js.flexjs.JSFlexJSEmitterTokens;
import org.apache.flex.compiler.internal.codegen.js.goog.JSGoogEmitter;
import org.apache.flex.compiler.internal.codegen.js.goog.JSGoogEmitterTokens;
import org.apache.flex.compiler.internal.codegen.js.utils.EmitterUtils;
import org.apache.flex.compiler.internal.codegen.js.vf2js.JSVF2JSDocEmitter;
import org.apache.flex.compiler.internal.definitions.AccessorDefinition;
import org.apache.flex.compiler.internal.definitions.ClassDefinition;
import org.apache.flex.compiler.internal.definitions.FunctionDefinition;
import org.apache.flex.compiler.internal.definitions.InterfaceDefinition;
import org.apache.flex.compiler.internal.definitions.ParameterDefinition;
import org.apache.flex.compiler.internal.definitions.VariableDefinition;
import org.apache.flex.compiler.internal.projects.CompilerProject;
import org.apache.flex.compiler.internal.projects.FlexJSProject;
import org.apache.flex.compiler.internal.scopes.ASProjectScope;
import org.apache.flex.compiler.internal.scopes.PackageScope;
import org.apache.flex.compiler.internal.scopes.TypeScope;
import org.apache.flex.compiler.internal.tree.as.BinaryOperatorAssignmentNode;
import org.apache.flex.compiler.internal.tree.as.ChainedVariableNode;
import org.apache.flex.compiler.internal.tree.as.FunctionCallNode;
import org.apache.flex.compiler.internal.tree.as.FunctionNode;
import org.apache.flex.compiler.internal.tree.as.NonResolvingIdentifierNode;
import org.apache.flex.compiler.internal.tree.as.ParameterNode;
import org.apache.flex.compiler.internal.tree.as.RegExpLiteralNode;
import org.apache.flex.compiler.internal.tree.as.UnaryOperatorAtNode;
import org.apache.flex.compiler.projects.ICompilerProject;
import org.apache.flex.compiler.scopes.IASScope;
import org.apache.flex.compiler.tree.ASTNodeID;
import org.apache.flex.compiler.tree.as.IASNode;
import org.apache.flex.compiler.tree.as.IAccessorNode;
import org.apache.flex.compiler.tree.as.IBinaryOperatorNode;
import org.apache.flex.compiler.tree.as.IClassNode;
import org.apache.flex.compiler.tree.as.IContainerNode;
import org.apache.flex.compiler.tree.as.IDefinitionNode;
import org.apache.flex.compiler.tree.as.IEmbedNode;
import org.apache.flex.compiler.tree.as.IExpressionNode;
import org.apache.flex.compiler.tree.as.IForLoopNode;
import org.apache.flex.compiler.tree.as.IFunctionCallNode;
import org.apache.flex.compiler.tree.as.IFunctionNode;
import org.apache.flex.compiler.tree.as.IGetterNode;
import org.apache.flex.compiler.tree.as.IIdentifierNode;
import org.apache.flex.compiler.tree.as.IInterfaceNode;
import org.apache.flex.compiler.tree.as.IKeywordNode;
import org.apache.flex.compiler.tree.as.ILanguageIdentifierNode;
import org.apache.flex.compiler.tree.as.ILiteralNode;
import org.apache.flex.compiler.tree.as.IMemberAccessExpressionNode;
import org.apache.flex.compiler.tree.as.IOperatorNode;
import org.apache.flex.compiler.tree.as.IParameterNode;
import org.apache.flex.compiler.tree.as.ISetterNode;
import org.apache.flex.compiler.tree.as.ITypeNode;
import org.apache.flex.compiler.tree.as.ITypedExpressionNode;
import org.apache.flex.compiler.tree.as.IVariableExpressionNode;
import org.apache.flex.compiler.tree.as.IVariableNode;
import org.apache.flex.compiler.units.ICompilationUnit;
import org.apache.flex.compiler.utils.ASNodeUtils;
import org.apache.flex.compiler.utils.NativeUtils;

public class JSVF2JSEmitter
extends JSGoogEmitter
implements IJSVF2JSEmitter {
    private int foreachLoopCounter = 0;

    public JSVF2JSEmitter(FilterWriter out) {
        super(out);
    }

    @Override
    protected String getIndent(int numIndent) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < numIndent; ++i) {
            sb.append(JSFlexJSEmitterTokens.INDENT.getToken());
        }
        return sb.toString();
    }

    @Override
    protected void emitMemberName(IDefinitionNode node) {
        this.write(node.getName());
    }

    @Override
    public void emitClass(IClassNode node) {
        IDefinitionNode[] dnodes;
        IClassDefinition definition = node.getDefinition();
        this.getModel().setCurrentClass(definition);
        this.project = this.getWalker().getProject();
        IFunctionDefinition ctorDefinition = definition.getConstructor();
        if (ctorDefinition != null) {
            IFunctionNode ctorNode = (IFunctionNode)ctorDefinition.getNode();
            if (ctorNode != null) {
                this.emitMethod(ctorNode);
                this.write(ASEmitterTokens.SEMICOLON);
            } else {
                String qname = this.parseQualifiedName((IDefinition)definition);
                if (qname != null && !qname.equals("")) {
                    this.write(qname);
                    this.write(ASEmitterTokens.SPACE);
                    this.writeToken(ASEmitterTokens.EQUAL);
                    this.write(ASEmitterTokens.FUNCTION);
                    this.write(ASEmitterTokens.PAREN_OPEN);
                    this.write(ASEmitterTokens.PAREN_CLOSE);
                    this.write(ASEmitterTokens.SPACE);
                    this.write(ASEmitterTokens.BLOCK_OPEN);
                    this.writeNewline();
                    this.write(ASEmitterTokens.BLOCK_CLOSE);
                    this.write(ASEmitterTokens.SEMICOLON);
                }
            }
        }
        for (IDefinitionNode dnode : dnodes = node.getAllMemberNodes()) {
            if (dnode.getNodeID() == ASTNodeID.VariableID) {
                this.writeNewline();
                this.writeNewline();
                this.writeNewline();
                this.emitField((IVariableNode)dnode);
                this.write(ASEmitterTokens.SEMICOLON);
                continue;
            }
            if (dnode.getNodeID() == ASTNodeID.FunctionID) {
                if (((IFunctionNode)dnode).isConstructor()) continue;
                this.writeNewline();
                this.writeNewline();
                this.writeNewline();
                this.emitMethod((IFunctionNode)dnode);
                this.write(ASEmitterTokens.SEMICOLON);
                continue;
            }
            if (dnode.getNodeID() != ASTNodeID.GetterID && dnode.getNodeID() != ASTNodeID.SetterID) continue;
            this.writeNewline();
            this.writeNewline();
            this.writeNewline();
            this.emitAccessors((IAccessorNode)dnode);
            this.write(ASEmitterTokens.SEMICOLON);
        }
    }

    @Override
    public void emitInterface(IInterfaceNode node) {
        IDefinitionNode[] members;
        ICompilerProject project = this.getWalker().getProject();
        this.getDocEmitter().emitInterfaceDoc(node, project);
        String qname = this.parseQualifiedName((IDefinitionNode)node);
        if (qname != null && !qname.equals("")) {
            this.write(qname);
            this.write(ASEmitterTokens.SPACE);
            this.writeToken(ASEmitterTokens.EQUAL);
            this.write(ASEmitterTokens.FUNCTION);
            this.write(ASEmitterTokens.PAREN_OPEN);
            this.write(ASEmitterTokens.PAREN_CLOSE);
            this.write(ASEmitterTokens.SPACE);
            this.write(ASEmitterTokens.BLOCK_OPEN);
            this.writeNewline();
            this.write(ASEmitterTokens.BLOCK_CLOSE);
            this.write(ASEmitterTokens.SEMICOLON);
        }
        for (IDefinitionNode mnode : members = node.getAllMemberDefinitionNodes()) {
            boolean isAccessor = mnode.getNodeID() == ASTNodeID.GetterID || mnode.getNodeID() == ASTNodeID.SetterID;
            this.writeNewline();
            this.writeNewline();
            this.writeNewline();
            this.getDocEmitter().emitInterfaceMemberDoc(mnode, project);
            this.write(qname);
            this.write(ASEmitterTokens.MEMBER_ACCESS);
            this.write(JSEmitterTokens.PROTOTYPE);
            this.write(ASEmitterTokens.MEMBER_ACCESS);
            if (isAccessor) {
                this.writeGetSetPrefix(mnode.getNodeID() == ASTNodeID.GetterID);
            }
            this.write(this.parseQualifiedName(mnode));
            this.write(ASEmitterTokens.SPACE);
            this.writeToken(ASEmitterTokens.EQUAL);
            this.write(ASEmitterTokens.FUNCTION);
            this.emitParameters(((IFunctionNode)mnode).getParametersContainerNode());
            this.write(ASEmitterTokens.SPACE);
            this.write(ASEmitterTokens.BLOCK_OPEN);
            this.write(ASEmitterTokens.BLOCK_CLOSE);
            this.write(ASEmitterTokens.SEMICOLON);
        }
    }

    @Override
    public void emitFunctionBlockHeader(IFunctionNode node) {
        IFunctionDefinition def = node.getDefinition();
        boolean isStatic = false;
        if (def != null && def.isStatic()) {
            isStatic = true;
        }
        boolean isLocal = false;
        if (node.getFunctionClassification() == IFunctionDefinition.FunctionClassification.LOCAL) {
            isLocal = true;
        }
        if (EmitterUtils.hasBody(node) && !isStatic && !isLocal) {
            this.emitSelfReference(node);
        }
        this.emitRestParameterCodeBlock(node);
        this.emitDefaultParameterCodeBlock(node);
        if (node.isConstructor()) {
            this.emitVarNonLiteralAssignments();
        }
        if (node.isConstructor() && this.hasSuperClass((IDefinitionNode)node) && !EmitterUtils.hasSuperCall(node.getScopedNode())) {
            this.emitSuperCall((IASNode)node, "fullConstructor");
        }
    }

    private void emitVarNonLiteralAssignments() {
        IDefinitionNode[] dnodes;
        IClassNode cdnode = (IClassNode)this.getModel().getCurrentClass().getNode();
        for (IDefinitionNode dnode : dnodes = cdnode.getAllMemberNodes()) {
            IVariableNode vnode;
            IExpressionNode avnode;
            if (dnode.getNodeID() != ASTNodeID.VariableID || (avnode = (vnode = (IVariableNode)dnode).getAssignedValueNode()) == null || avnode instanceof ILiteralNode || avnode instanceof IEmbedNode) continue;
            this.writeNewline("", true);
            if (vnode.hasModifier(ASModifier.STATIC)) {
                this.write(this.parseQualifiedName((IDefinitionNode)cdnode));
            } else {
                this.write(ASEmitterTokens.THIS);
            }
            this.write(ASEmitterTokens.MEMBER_ACCESS);
            this.writeToken(vnode.getName());
            this.writeToken(ASEmitterTokens.EQUAL);
            this.getWalker().walk((IASNode)avnode);
            this.indentPop();
            this.writeNewline(ASEmitterTokens.SEMICOLON);
        }
    }

    @Override
    public void emitVarDeclaration(IVariableNode node) {
        IExpressionNode avnode;
        IASNode pnode;
        if (!(node instanceof ChainedVariableNode || (pnode = node.getParent()) instanceof IVariableExpressionNode && !(node.getChild(0) instanceof IKeywordNode))) {
            this.emitMemberKeyword((IDefinitionNode)node);
        }
        if ((avnode = node.getAssignedValueNode()) != null) {
            ITypeDefinition def = avnode.resolveType(this.getWalker().getProject());
            String opcode = avnode.getNodeID().getParaphrase();
            if (opcode != "AnonymousFunction") {
                this.getDocEmitter().emitVarDoc(node, (IDefinition)def, this.getWalker().getProject());
            }
        } else {
            this.getDocEmitter().emitVarDoc(node, null, this.getWalker().getProject());
        }
        this.emitDeclarationName((IDefinitionNode)node);
        if (avnode != null && !(avnode instanceof IEmbedNode)) {
            this.write(ASEmitterTokens.SPACE);
            this.writeToken(ASEmitterTokens.EQUAL);
            this.emitAssignedValue(avnode);
        }
        if (!(node instanceof ChainedVariableNode)) {
            int len = node.getChildCount();
            for (int i = 0; i < len; ++i) {
                IASNode child = node.getChild(i);
                if (!(child instanceof ChainedVariableNode)) continue;
                this.writeToken(ASEmitterTokens.COMMA);
                this.emitVarDeclaration((IVariableNode)child);
            }
        }
    }

    @Override
    public void emitMemberKeyword(IDefinitionNode node) {
        if (node instanceof IFunctionNode) {
            this.writeToken(ASEmitterTokens.FUNCTION);
        } else if (node instanceof IVariableNode) {
            this.writeToken(ASEmitterTokens.VAR);
        }
    }

    @Override
    public void emitField(IVariableNode node) {
        IClassDefinition definition = EmitterUtils.getClassDefinition((IDefinitionNode)node);
        ITypeDefinition def = null;
        IExpressionNode enode = node.getVariableTypeNode();
        if (enode != null) {
            if (this.project == null) {
                this.project = this.getWalker().getProject();
            }
            def = enode.resolveType(this.project);
        }
        this.getDocEmitter().emitFieldDoc(node, (IDefinition)def, this.project);
        IDefinition ndef = node.getDefinition();
        ModifiersSet modifierSet = ndef.getModifiers();
        String root = "";
        if (modifierSet != null && !modifierSet.hasModifier(ASModifier.STATIC)) {
            root = JSEmitterTokens.PROTOTYPE.getToken();
            root = root + ASEmitterTokens.MEMBER_ACCESS.getToken();
        }
        if (definition == null) {
            definition = ndef.getContainingScope().getDefinition();
        }
        this.write(this.parseQualifiedName((IDefinition)definition) + ASEmitterTokens.MEMBER_ACCESS.getToken() + root + node.getName());
        IExpressionNode vnode = node.getAssignedValueNode();
        if (vnode != null && vnode instanceof ILiteralNode) {
            this.write(ASEmitterTokens.SPACE);
            this.writeToken(ASEmitterTokens.EQUAL);
            this.getWalker().walk((IASNode)vnode);
        }
        if (!(node instanceof ChainedVariableNode)) {
            int len = node.getChildCount();
            for (int i = 0; i < len; ++i) {
                IASNode child = node.getChild(i);
                if (!(child instanceof ChainedVariableNode)) continue;
                this.writeNewline(ASEmitterTokens.SEMICOLON);
                this.writeNewline();
                this.emitField((IVariableNode)child);
            }
        }
        if (node.getNodeID() == ASTNodeID.BindableVariableID) {
            this.writeNewline(ASEmitterTokens.SEMICOLON.getToken());
            this.writeNewline();
            this.writeNewline("/**");
            this.writeNewline("@export");
            this.writeNewline(" */");
            this.writeNewline(this.parseQualifiedName((IDefinition)definition) + ASEmitterTokens.MEMBER_ACCESS.getToken() + root + "get_" + node.getName() + ASEmitterTokens.SPACE.getToken() + ASEmitterTokens.EQUAL.getToken() + ASEmitterTokens.SPACE.getToken() + ASEmitterTokens.FUNCTION.getToken() + ASEmitterTokens.PAREN_OPEN.getToken() + ASEmitterTokens.PAREN_CLOSE.getToken() + ASEmitterTokens.SPACE.getToken() + ASEmitterTokens.BLOCK_OPEN.getToken());
            this.writeNewline(ASEmitterTokens.RETURN.getToken() + ASEmitterTokens.SPACE.getToken() + ASEmitterTokens.THIS.getToken() + ASEmitterTokens.MEMBER_ACCESS.getToken() + node.getName() + ASEmitterTokens.SEMICOLON.getToken());
            this.writeNewline(ASEmitterTokens.BLOCK_CLOSE.getToken() + ASEmitterTokens.SEMICOLON.getToken());
            this.writeNewline();
            this.writeNewline("/**");
            this.writeNewline("@export");
            this.writeNewline(" */");
            this.writeNewline(this.parseQualifiedName((IDefinition)definition) + ASEmitterTokens.MEMBER_ACCESS.getToken() + root + "set_" + node.getName() + ASEmitterTokens.SPACE.getToken() + ASEmitterTokens.EQUAL.getToken() + ASEmitterTokens.SPACE.getToken() + ASEmitterTokens.FUNCTION.getToken() + ASEmitterTokens.PAREN_OPEN.getToken() + "value" + ASEmitterTokens.PAREN_CLOSE.getToken() + ASEmitterTokens.SPACE.getToken() + ASEmitterTokens.BLOCK_OPEN.getToken());
            this.writeNewline("if (value != " + ASEmitterTokens.THIS.getToken() + ASEmitterTokens.MEMBER_ACCESS.getToken() + node.getName() + ") {");
            this.writeNewline("    var oldValue = " + ASEmitterTokens.THIS.getToken() + ASEmitterTokens.MEMBER_ACCESS.getToken() + node.getName() + ASEmitterTokens.SEMICOLON.getToken());
            this.writeNewline("    " + ASEmitterTokens.THIS.getToken() + ASEmitterTokens.MEMBER_ACCESS.getToken() + node.getName() + " = value;");
            this.writeNewline("    this.dispatchEvent(org.apache.flex.events.ValueChangeEvent.createUpdateEvent(");
            this.writeNewline("         this, \"" + node.getName() + "\", oldValue, value));");
            this.writeNewline("}");
            this.write(ASEmitterTokens.BLOCK_CLOSE.getToken());
        }
    }

    @Override
    public void emitAccessors(IAccessorNode node) {
        if (node.getNodeID() == ASTNodeID.GetterID) {
            this.emitGetAccessor((IGetterNode)node);
        } else if (node.getNodeID() == ASTNodeID.SetterID) {
            this.emitSetAccessor((ISetterNode)node);
        }
    }

    @Override
    public void emitMethod(IFunctionNode node) {
        FunctionNode fn = (FunctionNode)node;
        fn.parseFunctionBody(this.getProblems());
        ICompilerProject project = this.getWalker().getProject();
        this.getDocEmitter().emitMethodDoc(node, project);
        boolean isConstructor = node.isConstructor();
        String qname = this.parseQualifiedName((IDefinition)JSVF2JSEmitter.getTypeDefinition((IDefinitionNode)node));
        if (qname != null && !qname.equals("")) {
            this.write(qname);
            if (!isConstructor) {
                this.write(ASEmitterTokens.MEMBER_ACCESS);
                if (!fn.hasModifier(ASModifier.STATIC)) {
                    this.write(JSEmitterTokens.PROTOTYPE);
                    this.write(ASEmitterTokens.MEMBER_ACCESS);
                }
            }
        }
        if (!isConstructor) {
            this.emitMemberName((IDefinitionNode)node);
        }
        this.write(ASEmitterTokens.SPACE);
        this.writeToken(ASEmitterTokens.EQUAL);
        this.write(ASEmitterTokens.FUNCTION);
        this.emitParameters(node.getParametersContainerNode());
        boolean hasSuperClass = this.hasSuperClass((IDefinitionNode)node);
        if (isConstructor && node.getScopedNode().getChildCount() == 0) {
            this.write(ASEmitterTokens.SPACE);
            this.write(ASEmitterTokens.BLOCK_OPEN);
            this.emitVarNonLiteralAssignments();
            if (hasSuperClass) {
                this.emitSuperCall((IASNode)node, "emptyConstructor");
                this.writeNewline();
            }
            this.write(ASEmitterTokens.BLOCK_CLOSE);
        }
        if (!isConstructor || node.getScopedNode().getChildCount() > 0) {
            this.emitMethodScope(node.getScopedNode());
        }
        if (isConstructor && hasSuperClass) {
            this.writeNewline(ASEmitterTokens.SEMICOLON);
            this.write(JSGoogEmitterTokens.GOOG_INHERITS);
            this.write(ASEmitterTokens.PAREN_OPEN);
            this.write(qname);
            this.writeToken(ASEmitterTokens.COMMA);
            String sname = this.parseQualifiedName((IDefinition)JSVF2JSEmitter.getSuperClassDefinition((IDefinitionNode)node, project));
            if (sname.equals("Object")) {
                sname = "Class";
            }
            this.write(sname);
            this.write(ASEmitterTokens.PAREN_CLOSE);
        }
    }

    protected boolean hasSuperClass(IDefinitionNode node) {
        boolean useClassAsSuperClass;
        ICompilerProject project = this.getWalker().getProject();
        IClassDefinition superClassDefinition = JSVF2JSEmitter.getSuperClassDefinition(node, project);
        if (superClassDefinition == null) {
            return false;
        }
        String qname = this.parseQualifiedName((IDefinition)superClassDefinition);
        boolean bl = useClassAsSuperClass = !qname.equals("Object");
        if (!useClassAsSuperClass && (this.parseQualifiedName(node).equals("mx.core.EmbeddedFontRegistry") || this.parseQualifiedName(node).equals("mx.managers.HistoryManagerImpl") || this.parseQualifiedName(node).equals("mx.core.TextFieldFactory"))) {
            useClassAsSuperClass = true;
        }
        return superClassDefinition != null && useClassAsSuperClass;
    }

    @Override
    public void emitFunctionCall(IFunctionCallNode node) {
        ASTNodeID id;
        IASNode cnode = node.getChild(0);
        if (cnode.getNodeID() == ASTNodeID.MemberAccessExpressionID) {
            cnode = cnode.getChild(0);
        }
        if ((id = cnode.getNodeID()) != ASTNodeID.SuperID) {
            ICompilerProject project = null;
            IDefinition def = null;
            boolean isClassCast = false;
            if (node.isNewExpression()) {
                this.writeToken(ASEmitterTokens.NEW);
            } else {
                if (project == null) {
                    project = this.getWalker().getProject();
                }
                boolean bl = isClassCast = ((def = node.getNameNode().resolve(project)) instanceof ClassDefinition || def instanceof InterfaceDefinition) && !NativeUtils.isJSNative(def.getBaseName());
            }
            if (node.isNewExpression()) {
                if (project == null) {
                    project = this.getWalker().getProject();
                }
                if ((def = node.resolveCalledExpression(project)) instanceof ClassDefinition) {
                    this.write(this.parseQualifiedName(def));
                } else {
                    this.getWalker().walk((IASNode)node.getNameNode());
                }
                this.emitArguments((IContainerNode)node.getArgumentsNode());
            } else if (!isClassCast) {
                boolean isInt;
                if (def != null && ((isInt = def.getBaseName().equals("int")) || def.getBaseName().equals("trace") || def.getBaseName().equals("uint"))) {
                    this.write(JSFlexJSEmitterTokens.LANGUAGE_QNAME);
                    this.write(ASEmitterTokens.MEMBER_ACCESS);
                    if (isInt) {
                        this.write(JSFlexJSEmitterTokens.UNDERSCORE);
                    }
                }
                this.getWalker().walk((IASNode)node.getNameNode());
                this.emitArguments((IContainerNode)node.getArgumentsNode());
            } else {
                this.emitIsAs(node.getArgumentNodes()[0], node.getNameNode(), ASTNodeID.Op_AsID, true);
            }
        } else {
            this.emitSuperCall((IASNode)node, "replaceSuperFunction");
        }
    }

    @Override
    protected void emitSelfReference(IFunctionNode node) {
    }

    private boolean writeThis(IIdentifierNode node) {
        boolean identifierIsMemberAccess;
        if (node instanceof NonResolvingIdentifierNode) {
            return false;
        }
        IClassNode classNode = (IClassNode)node.getAncestorOfType(IClassNode.class);
        IDefinition nodeDef = node.resolve(this.project);
        IASNode parentNode = node.getParent();
        ASTNodeID parentNodeId = parentNode.getNodeID();
        IASNode firstChild = parentNode.getChild(0);
        IClassDefinition thisClass = this.getModel().getCurrentClass();
        boolean bl = identifierIsMemberAccess = parentNodeId == ASTNodeID.MemberAccessExpressionID;
        if (classNode == null) {
            if (nodeDef instanceof ParameterDefinition) {
                return false;
            }
            if (nodeDef instanceof VariableDefinition) {
                IDefinition pdef = ((VariableDefinition)nodeDef).getParent();
                if (thisClass == null || !this.isSameClass(pdef, (IDefinition)thisClass, this.project)) {
                    return false;
                }
                if (identifierIsMemberAccess) {
                    return node == firstChild;
                }
                return parentNodeId == ASTNodeID.ContainerID || !(parentNode instanceof ParameterNode);
            }
            if (nodeDef instanceof AccessorDefinition) {
                IDefinition pdef = ((AccessorDefinition)nodeDef).getParent();
                if (thisClass == null || !this.isSameClass(pdef, (IDefinition)thisClass, this.project)) {
                    return false;
                }
                if (identifierIsMemberAccess) {
                    return node == firstChild;
                }
                return true;
            }
            if (parentNodeId == ASTNodeID.ContainerID && nodeDef instanceof FunctionDefinition) {
                return ((FunctionDefinition)nodeDef).getFunctionClassification() == IFunctionDefinition.FunctionClassification.CLASS_MEMBER;
            }
            return parentNodeId == ASTNodeID.FunctionCallID && !(nodeDef instanceof AccessorDefinition) && !identifierIsMemberAccess;
        }
        if (nodeDef != null && !nodeDef.isInternal() && this.isClassMember(nodeDef, classNode)) {
            boolean identifierIsLocalFunction;
            if (identifierIsMemberAccess) {
                if (parentNode.getNodeID() == ASTNodeID.MemberAccessExpressionID && parentNode.getChild(0).getNodeID() == ASTNodeID.SuperID && !this.isSuperCallForOverride(node)) {
                    return true;
                }
                return node == firstChild;
            }
            boolean bl2 = identifierIsLocalFunction = nodeDef instanceof FunctionDefinition && !(nodeDef instanceof AccessorDefinition) && ((FunctionDefinition)nodeDef).getFunctionClassification() == IFunctionDefinition.FunctionClassification.LOCAL;
            if (nodeDef instanceof IParameterDefinition) {
                return false;
            }
            return !identifierIsLocalFunction;
        }
        return false;
    }

    private boolean isClassMember(IDefinition nodeDef, IClassNode classNode) {
        TypeScope cscope = (TypeScope)classNode.getDefinition().getContainedScope();
        Set nsSet = cscope.getNamespaceSet(this.project);
        HashSet defs = new HashSet();
        cscope.getAllPropertiesForMemberAccess((CompilerProject)this.project, defs, nsSet);
        Iterator visiblePropertiesIterator = defs.iterator();
        while (visiblePropertiesIterator.hasNext()) {
            if (!this.parseQualifiedName(nodeDef).equals(this.parseQualifiedName((IDefinition)visiblePropertiesIterator.next()))) continue;
            return true;
        }
        return false;
    }

    private boolean isSameClass(IDefinition pdef, IDefinition thisClass, ICompilerProject project) {
        if (pdef == thisClass) {
            return true;
        }
        IClassDefinition cdef = ((ClassDefinition)thisClass).resolveBaseClass(project);
        while (cdef != null) {
            if (cdef == pdef) {
                return true;
            }
            cdef = ((ClassDefinition)cdef).resolveBaseClass(project);
        }
        return false;
    }

    @Override
    public void emitIdentifier(IIdentifierNode node) {
        boolean isNative;
        if (this.project == null) {
            this.project = this.getWalker().getProject();
        }
        IDefinition nodeDef = node.resolve(this.project);
        IASNode parentNode = node.getParent();
        ASTNodeID parentNodeId = parentNode.getNodeID();
        boolean identifierIsAccessorFunction = nodeDef instanceof AccessorDefinition;
        boolean identifierIsPlainFunction = nodeDef instanceof FunctionDefinition && !identifierIsAccessorFunction;
        boolean emitName = true;
        if (nodeDef != null && nodeDef.isStatic() && nodeDef.getParent() != null) {
            String sname = this.parseQualifiedName(nodeDef.getParent());
            if (sname.length() > 0) {
                this.write(sname);
                this.write(ASEmitterTokens.MEMBER_ACCESS);
            }
        } else if (!NativeUtils.isNative(node.getName())) {
            boolean useGoogBind;
            boolean bl = useGoogBind = parentNodeId == ASTNodeID.ContainerID && identifierIsPlainFunction && ((FunctionDefinition)nodeDef).getFunctionClassification() == IFunctionDefinition.FunctionClassification.CLASS_MEMBER || identifierIsPlainFunction && ((FunctionDefinition)nodeDef).getFunctionClassification() == IFunctionDefinition.FunctionClassification.LOCAL;
            if (useGoogBind) {
                this.write(JSGoogEmitterTokens.GOOG_BIND);
                this.write(ASEmitterTokens.PAREN_OPEN);
            }
            if (this.writeThis(node)) {
                this.write(ASEmitterTokens.THIS);
                this.write(ASEmitterTokens.MEMBER_ACCESS);
            }
            if (useGoogBind) {
                this.write(node.getName());
                this.writeToken(ASEmitterTokens.COMMA);
                this.write(ASEmitterTokens.THIS);
                this.write(ASEmitterTokens.PAREN_CLOSE);
                emitName = false;
            }
        }
        IDefinition parentDef = nodeDef != null ? nodeDef.getParent() : null;
        boolean bl = isNative = parentDef != null && NativeUtils.isNative(parentDef.getBaseName());
        if (identifierIsAccessorFunction && !isNative || nodeDef instanceof VariableDefinition && ((VariableDefinition)nodeDef).isBindable()) {
            IASNode anode = node.getAncestorOfType(BinaryOperatorAssignmentNode.class);
            boolean isAssignment = false;
            if (anode != null) {
                String op;
                IASNode leftNode = anode.getChild(0);
                if (anode == parentNode) {
                    if (node == leftNode) {
                        isAssignment = true;
                    }
                } else {
                    IIdentifierNode thisNode = node;
                    for (IASNode pnode = parentNode; !(anode == pnode || pnode instanceof IMemberAccessExpressionNode && thisNode != pnode.getChild(1)); pnode = pnode.getParent()) {
                        if (pnode == leftNode) {
                            isAssignment = true;
                        }
                        thisNode = pnode;
                    }
                }
                if ((op = ((IBinaryOperatorNode)anode).getOperator().getOperatorText()).contains("==") || !op.contains("=")) {
                    isAssignment = false;
                }
            }
            if (parentNode.getNodeID() == ASTNodeID.MemberAccessExpressionID && parentNode.getChild(0).getNodeID() == ASTNodeID.SuperID && this.isSuperCallForOverride(node)) {
                IClassNode cnode = (IClassNode)node.getAncestorOfType(IClassNode.class);
                if (cnode == null) {
                    return;
                }
                this.write(this.parseQualifiedName((IDefinitionNode)cnode));
                this.write(ASEmitterTokens.MEMBER_ACCESS);
                this.write(JSGoogEmitterTokens.GOOG_BASE);
                this.write(ASEmitterTokens.PAREN_OPEN);
                this.write(ASEmitterTokens.THIS);
                this.writeToken(ASEmitterTokens.COMMA);
                this.write(ASEmitterTokens.SINGLE_QUOTE);
                this.writeGetSetPrefix(!isAssignment);
                this.write(this.parseQualifiedName(nodeDef));
                this.write(ASEmitterTokens.SINGLE_QUOTE);
                if (isAssignment) {
                    this.writeToken(ASEmitterTokens.COMMA);
                }
            } else if (node instanceof NonResolvingIdentifierNode) {
                this.write(node.getName());
            } else {
                this.writeGetSetPrefix(!isAssignment);
                this.write(node.getName());
                this.write(ASEmitterTokens.PAREN_OPEN);
            }
            if (anode != null && isAssignment) {
                this.getWalker().walk((IASNode)((BinaryOperatorAssignmentNode)anode).getRightOperandNode());
            }
            if (!(node instanceof NonResolvingIdentifierNode)) {
                this.write(ASEmitterTokens.PAREN_CLOSE);
            }
        } else if (emitName) {
            if (nodeDef != null) {
                this.write(this.parseQualifiedName(nodeDef));
            } else {
                this.write(node.getName());
            }
        }
    }

    private boolean isSuperCallForOverride(IIdentifierNode node) {
        IFunctionNode pfnode = (IFunctionNode)node.getAncestorOfType(FunctionNode.class);
        if (pfnode == null) {
            return false;
        }
        return pfnode.getName().equals(node.getName());
    }

    @Override
    protected void emitSuperCall(IASNode node, String type) {
        BinaryOperatorAssignmentNode bnode;
        IFunctionNode pnode;
        FunctionCallNode fcnode;
        IFunctionNode fnode = node instanceof IFunctionNode ? (IFunctionNode)node : null;
        FunctionCallNode functionCallNode = fcnode = node instanceof IFunctionCallNode ? (FunctionCallNode)node : null;
        if (type == "emptyConstructor") {
            this.indentPush();
            this.writeNewline();
            this.indentPop();
        } else if (type == "replaceSuperFunction" && fnode == null) {
            fnode = (IFunctionNode)fcnode.getAncestorOfType(IFunctionNode.class);
        }
        if (fnode != null && fnode.isConstructor() && !this.hasSuperClass((IDefinitionNode)fnode)) {
            return;
        }
        IClassNode cnode = (IClassNode)node.getAncestorOfType(IClassNode.class);
        if (cnode == null) {
            return;
        }
        boolean isCallToOtherSuperMethod = false;
        try {
            IExpressionNode d = fcnode.getNameNode();
            if (d != null && d instanceof IMemberAccessExpressionNode) {
                IIdentifierNode b = (IIdentifierNode)((IMemberAccessExpressionNode)d).getRightOperandNode();
                isCallToOtherSuperMethod = b != null && !b.getName().equals(fnode.getName());
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (isCallToOtherSuperMethod) {
            this.write(ASEmitterTokens.THIS);
            this.write(ASEmitterTokens.MEMBER_ACCESS);
            this.write(JSGoogEmitterTokens.SUPERCLASS);
            this.write(ASEmitterTokens.MEMBER_ACCESS);
        } else {
            this.write(this.parseQualifiedName((IDefinitionNode)cnode));
            this.write(ASEmitterTokens.MEMBER_ACCESS);
            this.write(JSGoogEmitterTokens.GOOG_BASE);
            this.write(ASEmitterTokens.PAREN_OPEN);
            this.write(ASEmitterTokens.THIS);
        }
        if (fnode != null && fnode.isConstructor()) {
            this.writeToken(ASEmitterTokens.COMMA);
            this.write(ASEmitterTokens.SINGLE_QUOTE);
            this.write(JSGoogEmitterTokens.GOOG_CONSTRUCTOR);
            this.write(ASEmitterTokens.SINGLE_QUOTE);
        }
        if (fnode != null && !fnode.isConstructor()) {
            if (!isCallToOtherSuperMethod) {
                this.writeToken(ASEmitterTokens.COMMA);
                this.write(ASEmitterTokens.SINGLE_QUOTE);
            }
            if (fnode.getNodeID() == ASTNodeID.GetterID || fnode.getNodeID() == ASTNodeID.SetterID) {
                this.writeGetSetPrefix(fnode.getNodeID() == ASTNodeID.GetterID);
            }
            IMemberAccessExpressionNode aenode = (IMemberAccessExpressionNode)fcnode.getNameNode();
            this.write(((IIdentifierNode)aenode.getRightOperandNode()).getName());
            if (!isCallToOtherSuperMethod) {
                this.write(ASEmitterTokens.SINGLE_QUOTE);
            } else {
                this.write(ASEmitterTokens.MEMBER_ACCESS);
                this.write(JSGoogEmitterTokens.GOOG_CALL);
                this.write(ASEmitterTokens.PAREN_OPEN);
                this.write(ASEmitterTokens.THIS);
            }
        }
        IExpressionNode[] anodes = null;
        boolean writeArguments = false;
        if (fcnode != null) {
            anodes = fcnode.getArgumentNodes();
            writeArguments = anodes.length > 0;
        } else if (fnode != null && fnode.isConstructor()) {
            anodes = fnode.getParameterNodes();
            writeArguments = anodes != null && anodes.length > 0;
        } else if (fnode == null && node instanceof BinaryOperatorAssignmentNode && (pnode = (IFunctionNode)(bnode = (BinaryOperatorAssignmentNode)node).getAncestorOfType(IFunctionNode.class)).getNodeID() == ASTNodeID.SetterID) {
            this.writeToken(ASEmitterTokens.COMMA);
            this.write(ASEmitterTokens.SINGLE_QUOTE);
            this.writeGetSetPrefix(false);
            this.getWalker().walk((IASNode)bnode.getLeftOperandNode());
            this.write(ASEmitterTokens.SINGLE_QUOTE);
            this.writeToken(ASEmitterTokens.COMMA);
            this.getWalker().walk((IASNode)bnode.getRightOperandNode());
        }
        if (writeArguments) {
            int len = anodes.length;
            for (int i = 0; i < len; ++i) {
                this.writeToken(ASEmitterTokens.COMMA);
                this.getWalker().walk((IASNode)anodes[i]);
            }
        }
        this.write(ASEmitterTokens.PAREN_CLOSE);
        if (type == "fullConstructor") {
            this.write(ASEmitterTokens.SEMICOLON);
            this.writeNewline();
        } else if (type == "emptyConstructor") {
            this.write(ASEmitterTokens.SEMICOLON);
        }
    }

    @Override
    protected void emitDefaultParameterCodeBlock(IFunctionNode node) {
        IParameterNode[] pnodes = node.getParameterNodes();
        if (pnodes.length == 0) {
            return;
        }
        Map<Integer, IParameterNode> defaults = EmitterUtils.getDefaults(pnodes);
        if (defaults != null) {
            StringBuilder code = new StringBuilder();
            if (!EmitterUtils.hasBody(node)) {
                this.indentPush();
                this.write(JSFlexJSEmitterTokens.INDENT);
            }
            ArrayList<IParameterNode> parameters = new ArrayList<IParameterNode>(defaults.values());
            int n = parameters.size();
            for (int i = 0; i < n; ++i) {
                IParameterNode pnode = (IParameterNode)parameters.get(i);
                if (pnode == null) continue;
                code.setLength(0);
                code.append(pnode.getName());
                code.append(ASEmitterTokens.SPACE.getToken());
                code.append(ASEmitterTokens.EQUAL.getToken());
                code.append(ASEmitterTokens.SPACE.getToken());
                code.append(ASEmitterTokens.TYPEOF.getToken());
                code.append(ASEmitterTokens.SPACE.getToken());
                code.append(pnode.getName());
                code.append(ASEmitterTokens.SPACE.getToken());
                code.append(ASEmitterTokens.STRICT_NOT_EQUAL.getToken());
                code.append(ASEmitterTokens.SPACE.getToken());
                code.append(ASEmitterTokens.SINGLE_QUOTE.getToken());
                code.append(ASEmitterTokens.UNDEFINED.getToken());
                code.append(ASEmitterTokens.SINGLE_QUOTE.getToken());
                code.append(ASEmitterTokens.SPACE.getToken());
                code.append(ASEmitterTokens.TERNARY.getToken());
                code.append(ASEmitterTokens.SPACE.getToken());
                code.append(pnode.getName());
                code.append(ASEmitterTokens.SPACE.getToken());
                code.append(ASEmitterTokens.COLON.getToken());
                code.append(ASEmitterTokens.SPACE.getToken());
                code.append(pnode.getDefaultValue());
                code.append(ASEmitterTokens.SEMICOLON.getToken());
                this.write(code.toString());
                if (i == n - 1 && !EmitterUtils.hasBody(node)) {
                    this.indentPop();
                }
                this.writeNewline();
            }
        }
    }

    @Override
    public void emitBinaryOperator(IBinaryOperatorNode node) {
        ASTNodeID id = node.getNodeID();
        if (id == ASTNodeID.Op_InID || id == ASTNodeID.Op_LogicalAndAssignID || id == ASTNodeID.Op_LogicalOrAssignID) {
            super.emitBinaryOperator(node);
        } else if (id == ASTNodeID.Op_IsID || id == ASTNodeID.Op_AsID) {
            this.emitIsAs(node.getLeftOperandNode(), node.getRightOperandNode(), id, false);
        } else if (id == ASTNodeID.Op_InstanceOfID) {
            this.getWalker().walk((IASNode)node.getLeftOperandNode());
            this.write(ASEmitterTokens.SPACE);
            this.writeToken(ASEmitterTokens.INSTANCEOF);
            IDefinition dnode = node.getRightOperandNode().resolve(this.project);
            if (dnode != null) {
                this.write(this.parseQualifiedName(dnode));
            } else {
                this.getWalker().walk((IASNode)node.getRightOperandNode());
            }
        } else {
            String op;
            boolean isAssignment;
            IASNode childNode;
            IExpressionNode leftSide = node.getLeftOperandNode();
            IExpressionNode property = null;
            int leftSideChildCount = leftSide.getChildCount();
            property = leftSideChildCount > 0 ? ((childNode = leftSide.getChild(leftSideChildCount - 1)) instanceof IExpressionNode ? (IExpressionNode)childNode : leftSide) : leftSide;
            IDefinition def = null;
            if (property instanceof IIdentifierNode) {
                def = ((IIdentifierNode)property).resolve(this.getWalker().getProject());
            }
            boolean isSuper = false;
            if (leftSide.getNodeID() == ASTNodeID.MemberAccessExpressionID) {
                IASNode cnode = leftSide.getChild(0);
                ASTNodeID cId = cnode.getNodeID();
                isSuper = cId == ASTNodeID.SuperID;
            }
            boolean bl = isAssignment = !(op = node.getOperator().getOperatorText()).contains("==") && op.contains("=");
            if (def instanceof AccessorDefinition && isAssignment) {
                this.getWalker().walk((IASNode)leftSide);
            } else if (isSuper) {
                this.emitSuperCall((IASNode)node, "");
            } else {
                if (ASNodeUtils.hasParenOpen((IOperatorNode)node)) {
                    this.write(ASEmitterTokens.PAREN_OPEN);
                }
                this.getWalker().walk((IASNode)leftSide);
                if (node.getNodeID() != ASTNodeID.Op_CommaID) {
                    this.write(ASEmitterTokens.SPACE);
                }
                this.writeToken(node.getOperator().getOperatorText());
                this.getWalker().walk((IASNode)node.getRightOperandNode());
                if (ASNodeUtils.hasParenClose((IOperatorNode)node)) {
                    this.write(ASEmitterTokens.PAREN_CLOSE);
                }
            }
        }
    }

    private void emitIsAs(IExpressionNode left, IExpressionNode right, ASTNodeID id, boolean coercion) {
        this.write(JSFlexJSEmitterTokens.LANGUAGE_QNAME);
        this.write(ASEmitterTokens.MEMBER_ACCESS);
        if (id == ASTNodeID.Op_IsID) {
            this.write(ASEmitterTokens.IS);
        } else {
            this.write(ASEmitterTokens.AS);
        }
        this.write(ASEmitterTokens.PAREN_OPEN);
        this.getWalker().walk((IASNode)left);
        this.writeToken(ASEmitterTokens.COMMA);
        IDefinition dnode = right.resolve(this.project);
        if (dnode != null) {
            this.write(this.parseQualifiedName(dnode));
        } else {
            this.getWalker().walk((IASNode)right);
        }
        if (coercion) {
            this.writeToken(ASEmitterTokens.COMMA);
            this.write(ASEmitterTokens.TRUE);
        }
        this.write(ASEmitterTokens.PAREN_CLOSE);
    }

    @Override
    public void emitMemberAccessExpression(IMemberAccessExpressionNode node) {
        IExpressionNode leftNode = node.getLeftOperandNode();
        IExpressionNode rightNode = node.getRightOperandNode();
        if (this.project == null) {
            this.project = this.getWalker().getProject();
        }
        IDefinition def = node.resolve(this.project);
        boolean isStatic = false;
        if (def != null && def.isStatic()) {
            isStatic = true;
        }
        boolean continueWalk = true;
        if (!isStatic) {
            if (!(leftNode instanceof ILanguageIdentifierNode) || ((ILanguageIdentifierNode)leftNode).getKind() != ILanguageIdentifierNode.LanguageIdentifierKind.THIS) {
                if (rightNode instanceof UnaryOperatorAtNode) {
                    this.write(ASEmitterTokens.THIS);
                    this.write(ASEmitterTokens.MEMBER_ACCESS);
                    this.getWalker().walk((IASNode)node.getLeftOperandNode());
                    this.write(ASEmitterTokens.SQUARE_OPEN);
                    this.write(ASEmitterTokens.SINGLE_QUOTE);
                    this.write("E4XOperator");
                    this.write(ASEmitterTokens.SINGLE_QUOTE);
                    this.write(ASEmitterTokens.SQUARE_CLOSE);
                    continueWalk = false;
                } else if (node.getNodeID() == ASTNodeID.Op_DescendantsID) {
                    this.write(ASEmitterTokens.THIS);
                    this.write(ASEmitterTokens.MEMBER_ACCESS);
                    this.getWalker().walk((IASNode)node.getLeftOperandNode());
                    this.write(ASEmitterTokens.SQUARE_OPEN);
                    this.write(ASEmitterTokens.SINGLE_QUOTE);
                    this.write("E4XSelector");
                    this.write(ASEmitterTokens.SINGLE_QUOTE);
                    this.write(ASEmitterTokens.SQUARE_CLOSE);
                    continueWalk = false;
                } else if (leftNode.getNodeID() != ASTNodeID.SuperID) {
                    this.getWalker().walk((IASNode)node.getLeftOperandNode());
                    this.write(node.getOperator().getOperatorText());
                }
            } else {
                this.write(ASEmitterTokens.THIS);
                this.write(node.getOperator().getOperatorText());
            }
        }
        if (continueWalk) {
            this.getWalker().walk((IASNode)node.getRightOperandNode());
        }
    }

    private static ITypeDefinition getTypeDefinition(IDefinitionNode node) {
        ITypeNode tnode = (ITypeNode)node.getAncestorOfType(ITypeNode.class);
        return (ITypeDefinition)tnode.getDefinition();
    }

    private static IClassDefinition getSuperClassDefinition(IDefinitionNode node, ICompilerProject project) {
        IClassDefinition parent = (IClassDefinition)node.getDefinition().getParent();
        IClassDefinition superClass = parent.resolveBaseClass(project);
        return superClass;
    }

    @Override
    protected void emitObjectDefineProperty(IAccessorNode node) {
        FunctionNode fn = (FunctionNode)node;
        fn.parseFunctionBody(this.getProblems());
        IFunctionDefinition definition = node.getDefinition();
        ITypeDefinition type = (ITypeDefinition)definition.getParent();
        if (type == null) {
            return;
        }
        if (this.project == null) {
            this.project = this.getWalker().getProject();
        }
        this.getDocEmitter().emitMethodDoc((IFunctionNode)fn, this.project);
        this.write(this.parseQualifiedName((IDefinition)type));
        if (!node.hasModifier(ASModifier.STATIC)) {
            this.write(ASEmitterTokens.MEMBER_ACCESS);
            this.write(JSEmitterTokens.PROTOTYPE);
        }
        this.write(ASEmitterTokens.MEMBER_ACCESS);
        this.writeGetSetPrefix(node instanceof IGetterNode);
        this.writeToken(node.getName());
        this.writeToken(ASEmitterTokens.EQUAL);
        this.write(ASEmitterTokens.FUNCTION);
        this.emitParameters(node.getParametersContainerNode());
        this.emitMethodScope(node.getScopedNode());
    }

    private void writeGetSetPrefix(boolean isGet) {
        if (isGet) {
            this.write(ASEmitterTokens.GET);
        } else {
            this.write(ASEmitterTokens.SET);
        }
        this.write("_");
    }

    @Override
    public IJSGoogDocEmitter getDocEmitter() {
        return new JSVF2JSDocEmitter(this);
    }

    @Override
    public void emitPackageHeader(IPackageDefinition definition) {
        IASScope containedScope = definition.getContainedScope();
        ITypeDefinition type = this.findType(containedScope.getAllLocalDefinitions());
        if (type == null) {
            return;
        }
        this.writeNewline("/**");
        this.writeNewline(" * " + this.parseQualifiedName((IDefinition)type));
        this.writeNewline(" *");
        this.writeNewline(" * @fileoverview");
        this.writeNewline(" *");
        this.writeNewline(" * @suppress {checkTypes}");
        this.writeNewline(" */");
        this.writeNewline();
        this.write(JSGoogEmitterTokens.GOOG_PROVIDE);
        this.write(ASEmitterTokens.PAREN_OPEN);
        this.write(ASEmitterTokens.SINGLE_QUOTE);
        this.write(this.parseQualifiedName((IDefinition)type));
        this.write(ASEmitterTokens.SINGLE_QUOTE);
        this.write(ASEmitterTokens.PAREN_CLOSE);
        this.writeNewline(ASEmitterTokens.SEMICOLON);
        this.writeNewline();
    }

    @Override
    public void emitPackageHeaderContents(IPackageDefinition definition) {
        boolean isMainCU;
        PackageScope containedScope = (PackageScope)definition.getContainedScope();
        ITypeDefinition type = this.findType(containedScope.getAllLocalDefinitions());
        if (type == null) {
            return;
        }
        if (this.project == null) {
            this.project = this.getWalker().getProject();
        }
        FlexJSProject flexProject = (FlexJSProject)this.project;
        ASProjectScope projectScope = flexProject.getScope();
        ICompilationUnit cu = projectScope.getCompilationUnitForDefinition((IDefinition)type);
        ArrayList<String> requiresList = flexProject.getRequires(cu);
        ArrayList<String> interfacesList = flexProject.getInterfaces(cu);
        String cname = this.parseQualifiedName((IDefinition)type);
        ArrayList<String> writtenInstances = new ArrayList<String>();
        writtenInstances.add(cname);
        boolean emitsRequires = false;
        if (requiresList != null) {
            Collections.sort(requiresList);
            for (String imp : requiresList) {
                if (imp.indexOf(JSGoogEmitterTokens.AS3.getToken()) != -1 || imp.equals(cname) || NativeUtils.isNative(imp) || writtenInstances.indexOf(imp) != -1) continue;
                this.write(JSGoogEmitterTokens.GOOG_REQUIRE);
                this.write(ASEmitterTokens.PAREN_OPEN);
                this.write(ASEmitterTokens.SINGLE_QUOTE);
                this.write(imp);
                this.write(ASEmitterTokens.SINGLE_QUOTE);
                this.write(ASEmitterTokens.PAREN_CLOSE);
                this.writeNewline(ASEmitterTokens.SEMICOLON);
                writtenInstances.add(imp);
                emitsRequires = true;
            }
        }
        boolean emitsInterfaces = false;
        if (interfacesList != null) {
            Collections.sort(interfacesList);
            for (String imp : interfacesList) {
                this.write(JSGoogEmitterTokens.GOOG_REQUIRE);
                this.write(ASEmitterTokens.PAREN_OPEN);
                this.write(ASEmitterTokens.SINGLE_QUOTE);
                this.write(imp);
                this.write(ASEmitterTokens.SINGLE_QUOTE);
                this.write(ASEmitterTokens.PAREN_CLOSE);
                this.writeNewline(ASEmitterTokens.SEMICOLON);
                emitsInterfaces = true;
            }
        }
        boolean bl = isMainCU = flexProject.mainCU != null && cu.getName().equals(flexProject.mainCU.getName());
        if (isMainCU) {
            this.write(JSGoogEmitterTokens.GOOG_REQUIRE);
            this.write(ASEmitterTokens.PAREN_OPEN);
            this.write(ASEmitterTokens.SINGLE_QUOTE);
            this.write(JSFlexJSEmitterTokens.LANGUAGE_QNAME);
            this.write(ASEmitterTokens.SINGLE_QUOTE);
            this.write(ASEmitterTokens.PAREN_CLOSE);
            this.writeNewline(ASEmitterTokens.SEMICOLON);
        }
        if (emitsRequires || emitsInterfaces || isMainCU) {
            this.writeNewline();
        }
        this.writeNewline();
        this.writeNewline();
    }

    @Override
    public void emitPackageFooter(IPackageDefinition definition) {
        IASScope containedScope = definition.getContainedScope();
        ITypeDefinition type = this.findType(containedScope.getAllLocalDefinitions());
        if (type == null) {
            return;
        }
        ITypeNode tnode = this.findTypeNode(definition.getNode());
        if (tnode != null) {
            this.writeNewline();
            this.writeNewline();
            this.writeNewline();
            this.getDocEmitter().begin();
            this.writeNewline(" * Metadata");
            this.writeNewline(" *");
            this.writeNewline(" * @type {Object.<string, Array.<Object>>}");
            this.getDocEmitter().end();
            this.write(this.parseQualifiedName((IDefinition)type));
            this.write(ASEmitterTokens.MEMBER_ACCESS);
            this.write(JSEmitterTokens.PROTOTYPE);
            this.write(ASEmitterTokens.MEMBER_ACCESS);
            this.writeToken(JSFlexJSEmitterTokens.FLEXJS_CLASS_INFO);
            this.writeToken(ASEmitterTokens.EQUAL);
            this.writeToken(ASEmitterTokens.BLOCK_OPEN);
            this.write(JSFlexJSEmitterTokens.NAMES);
            this.writeToken(ASEmitterTokens.COLON);
            this.write(ASEmitterTokens.SQUARE_OPEN);
            this.writeToken(ASEmitterTokens.BLOCK_OPEN);
            this.write(JSFlexJSEmitterTokens.NAME);
            this.writeToken(ASEmitterTokens.COLON);
            this.write(ASEmitterTokens.SINGLE_QUOTE);
            this.write(tnode.getName());
            this.write(ASEmitterTokens.SINGLE_QUOTE);
            this.writeToken(ASEmitterTokens.COMMA);
            this.write(JSFlexJSEmitterTokens.QNAME);
            this.writeToken(ASEmitterTokens.COLON);
            this.write(ASEmitterTokens.SINGLE_QUOTE);
            this.write(this.parseQualifiedName((IDefinitionNode)tnode));
            this.write(ASEmitterTokens.SINGLE_QUOTE);
            this.write(ASEmitterTokens.BLOCK_CLOSE);
            this.write(ASEmitterTokens.SQUARE_CLOSE);
            IExpressionNode[] enodes = tnode instanceof IClassNode ? ((IClassNode)tnode).getImplementedInterfaceNodes() : ((IInterfaceNode)tnode).getExtendedInterfaceNodes();
            if (enodes.length > 0) {
                this.writeToken(ASEmitterTokens.COMMA);
                this.write(JSFlexJSEmitterTokens.INTERFACES);
                this.writeToken(ASEmitterTokens.COLON);
                this.write(ASEmitterTokens.SQUARE_OPEN);
                int i = 0;
                for (IExpressionNode enode : enodes) {
                    this.write(this.parseQualifiedName(enode.resolve(this.project)));
                    if (i < enodes.length - 1) {
                        this.writeToken(ASEmitterTokens.COMMA);
                    }
                    ++i;
                }
                this.write(ASEmitterTokens.SQUARE_CLOSE);
            }
            this.write(ASEmitterTokens.SPACE);
            this.write(ASEmitterTokens.BLOCK_CLOSE);
            this.writeNewline(ASEmitterTokens.SEMICOLON);
        }
    }

    @Override
    public void emitForEachLoop(IForLoopNode node) {
        IBinaryOperatorNode bnode = (IBinaryOperatorNode)node.getConditionalsContainerNode().getChild(0);
        IASNode childNode = bnode.getChild(0);
        String iterName = "foreachiter" + new Integer(this.foreachLoopCounter).toString();
        ++this.foreachLoopCounter;
        this.write(ASEmitterTokens.FOR);
        this.write(ASEmitterTokens.SPACE);
        this.write(ASEmitterTokens.PAREN_OPEN);
        this.write(ASEmitterTokens.VAR);
        this.write(ASEmitterTokens.SPACE);
        this.write(iterName);
        this.write(ASEmitterTokens.SPACE);
        this.write(ASEmitterTokens.IN);
        this.write(ASEmitterTokens.SPACE);
        this.getWalker().walk(bnode.getChild(1));
        this.writeToken(ASEmitterTokens.PAREN_CLOSE);
        this.writeNewline();
        this.write(ASEmitterTokens.BLOCK_OPEN);
        this.writeNewline();
        if (childNode instanceof IVariableExpressionNode) {
            this.write(ASEmitterTokens.VAR);
            this.write(ASEmitterTokens.SPACE);
            this.write(((IVariableNode)childNode.getChild(0)).getName());
        } else {
            this.write(((IIdentifierNode)childNode).getName());
        }
        this.write(ASEmitterTokens.SPACE);
        this.write(ASEmitterTokens.EQUAL);
        this.write(ASEmitterTokens.SPACE);
        this.getWalker().walk(bnode.getChild(1));
        this.write(ASEmitterTokens.SQUARE_OPEN);
        this.write(iterName);
        this.write(ASEmitterTokens.SQUARE_CLOSE);
        this.write(ASEmitterTokens.SEMICOLON);
        this.writeNewline();
        this.getWalker().walk(node.getStatementContentsNode());
        this.write(ASEmitterTokens.BLOCK_CLOSE);
        this.writeNewline();
    }

    @Override
    public void emitTypedExpression(ITypedExpressionNode node) {
        this.write(JSGoogEmitterTokens.ARRAY);
    }

    @Override
    public void emitLiteral(ILiteralNode node) {
        boolean isWritten = false;
        String s = node.getValue(true);
        if (!(node instanceof RegExpLiteralNode)) {
            if (node.getLiteralType() == ILiteralNode.LiteralType.XML) {
                this.write("'" + s + "'");
                isWritten = true;
            }
            s = s.replaceAll("\n", "__NEWLINE_PLACEHOLDER__");
            s = s.replaceAll("\r", "__CR_PLACEHOLDER__");
            s = s.replaceAll("\t", "__TAB_PLACEHOLDER__");
            s = s.replaceAll("\f", "__FORMFEED_PLACEHOLDER__");
            s = s.replaceAll("\b", "__BACKSPACE_PLACEHOLDER__");
            s = s.replaceAll("\\\\\"", "__QUOTE_PLACEHOLDER__");
            s = s.replaceAll("\\\\", "__ESCAPE_PLACEHOLDER__");
            s = s.replaceAll("__ESCAPE_PLACEHOLDER__", "\\\\\\\\");
            s = s.replaceAll("__QUOTE_PLACEHOLDER__", "\\\\\"");
            s = s.replaceAll("__BACKSPACE_PLACEHOLDER__", "\\\\b");
            s = s.replaceAll("__FORMFEED_PLACEHOLDER__", "\\\\f");
            s = s.replaceAll("__TAB_PLACEHOLDER__", "\\\\t");
            s = s.replaceAll("__CR_PLACEHOLDER__", "\\\\r");
            Character c = Character.valueOf((s = s.replaceAll("__NEWLINE_PLACEHOLDER__", "\\\\n")).charAt(0));
            if (c.equals(Character.valueOf('\"'))) {
                s = s.substring(1, s.length() - 1);
                s = s.replaceAll("\"", "\\\\\"");
                s = "\"" + s + "\"";
            }
            if (s.length() == 3 && (c = Character.valueOf(s.charAt(1))).equals(Character.valueOf('\\'))) {
                s = "\"\\\\\"";
            }
        }
        if (!isWritten) {
            this.write(s);
        }
    }

    @Override
    public void emitE4XFilter(IMemberAccessExpressionNode node) {
        this.write(ASEmitterTokens.SINGLE_QUOTE);
        this.write("E4XFilter");
        this.write(ASEmitterTokens.SINGLE_QUOTE);
    }

    @Override
    public void emitContainer(IContainerNode node) {
        int nodeCount = node.getChildCount();
        for (int i = 0; i < nodeCount; ++i) {
            this.getWalker().walk(node.getChild(i));
            if (i >= nodeCount - 1) continue;
            this.writeToken(ASEmitterTokens.COMMA);
        }
    }

    private String parseQualifiedName(IDefinitionNode def) {
        return this.parseQualifiedNameString(def.getQualifiedName());
    }

    private String parseQualifiedName(IDefinition def) {
        return this.parseQualifiedNameString(def.getQualifiedName());
    }

    private String parseQualifiedNameString(String qNameString) {
        if (qNameString.equals("int")) {
            qNameString = qNameString.toUpperCase();
        }
        if (qNameString.equals("byte")) {
            qNameString = "$" + qNameString;
        }
        return qNameString;
    }
}

