/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.codegen.js.vf2js;

import org.apache.flex.compiler.asdoc.flexjs.ASDocComment;
import org.apache.flex.compiler.clients.MXMLJSC;
import org.apache.flex.compiler.codegen.js.IJSEmitter;
import org.apache.flex.compiler.common.ASModifier;
import org.apache.flex.compiler.common.DependencyType;
import org.apache.flex.compiler.definitions.IClassDefinition;
import org.apache.flex.compiler.definitions.IDefinition;
import org.apache.flex.compiler.definitions.IFunctionDefinition;
import org.apache.flex.compiler.definitions.ITypeDefinition;
import org.apache.flex.compiler.definitions.references.IReference;
import org.apache.flex.compiler.internal.codegen.as.ASEmitterTokens;
import org.apache.flex.compiler.internal.codegen.js.JSEmitterTokens;
import org.apache.flex.compiler.internal.codegen.js.goog.JSGoogDocEmitter;
import org.apache.flex.compiler.internal.codegen.js.vf2js.JSVF2JSEmitter;
import org.apache.flex.compiler.internal.definitions.InterfaceDefinition;
import org.apache.flex.compiler.internal.scopes.ASScope;
import org.apache.flex.compiler.projects.ICompilerProject;
import org.apache.flex.compiler.tree.as.IASNode;
import org.apache.flex.compiler.tree.as.IDefinitionNode;
import org.apache.flex.compiler.tree.as.IExpressionNode;
import org.apache.flex.compiler.tree.as.IFunctionNode;
import org.apache.flex.compiler.tree.as.IParameterNode;
import org.apache.flex.compiler.tree.as.IVariableNode;

public class JSVF2JSDocEmitter
extends JSGoogDocEmitter {
    public JSVF2JSDocEmitter(IJSEmitter emitter) {
        super(emitter);
    }

    @Override
    public void emitMethodDoc(IFunctionNode node, ICompilerProject project) {
        IClassDefinition classDefinition = this.resolveClassDefinition(node);
        ASDocComment asDoc = (ASDocComment)node.getASDocComment();
        if (node instanceof IFunctionNode) {
            IParameterNode[] parameters;
            boolean hasDoc = false;
            if (node.isConstructor()) {
                IReference[] references;
                String qname;
                if (asDoc != null && MXMLJSC.keepASDoc) {
                    this.write(asDoc.commentNoEnd());
                } else {
                    this.begin();
                }
                hasDoc = true;
                this.emitJSDocLine(JSEmitterTokens.CONSTRUCTOR);
                IClassDefinition parent = (IClassDefinition)node.getDefinition().getParent();
                IClassDefinition superClass = parent.resolveBaseClass(project);
                String string = qname = superClass != null ? superClass.getQualifiedName() : null;
                if (superClass != null && !qname.equals("Object")) {
                    this.emitExtends(superClass, superClass.getPackageName());
                }
                for (IReference iReference : references = classDefinition.getImplementedInterfaceReferences()) {
                    ITypeDefinition type = (ITypeDefinition)iReference.resolve(project, (ASScope)classDefinition.getContainingScope(), DependencyType.INHERITANCE, true);
                    if (type == null) {
                        System.out.println(iReference.getDisplayString() + " not resolved in " + classDefinition.getQualifiedName());
                    }
                    this.emitImplements(type, type.getPackageName());
                }
            } else {
                String ns = node.getNamespace();
                if (ns != null) {
                    if (asDoc != null && MXMLJSC.keepASDoc) {
                        this.write(asDoc.commentNoEnd());
                    } else {
                        this.begin();
                    }
                    this.emitMethodAccess(node);
                    hasDoc = true;
                }
            }
            for (IParameterNode pnode : parameters = node.getParameterNodes()) {
                IExpressionNode enode;
                ITypeDefinition tdef;
                if (!hasDoc) {
                    if (asDoc != null && MXMLJSC.keepASDoc) {
                        this.write(asDoc.commentNoEnd());
                    } else {
                        this.begin();
                    }
                    this.emitMethodAccess(node);
                    hasDoc = true;
                }
                if ((tdef = (enode = pnode.getNameExpressionNode()).resolveType(project)) == null) continue;
                this.emitParam(pnode, tdef.getPackageName());
            }
            if (!node.isConstructor()) {
                Boolean override;
                String returnType = node.getReturnType();
                if (returnType != "" && returnType != ASEmitterTokens.VOID.getToken()) {
                    if (!hasDoc) {
                        if (asDoc != null && MXMLJSC.keepASDoc) {
                            this.write(asDoc.commentNoEnd());
                        } else {
                            this.begin();
                        }
                        this.emitMethodAccess(node);
                        hasDoc = true;
                    }
                    ITypeDefinition tdef = node.getDefinition().resolveReturnType(project);
                    String packageName = "";
                    packageName = tdef instanceof InterfaceDefinition ? tdef.getPackageName() : node.getPackageName();
                    this.emitReturn(node, packageName);
                }
                if ((override = Boolean.valueOf(node.hasModifier(ASModifier.OVERRIDE))).booleanValue()) {
                    if (!hasDoc) {
                        if (asDoc != null && MXMLJSC.keepASDoc) {
                            this.write(asDoc.commentNoEnd());
                        } else {
                            this.begin();
                        }
                        this.emitMethodAccess(node);
                        hasDoc = true;
                    }
                    this.emitOverride(node);
                }
            }
            if (hasDoc) {
                this.end();
            }
        }
    }

    @Override
    public void emitVarDoc(IVariableNode node, IDefinition def, ICompilerProject project) {
        String packageName = "";
        if (def != null) {
            packageName = def.getPackageName();
        }
        if (!node.isConst()) {
            IDefinition ndef = node.getDefinition();
            if (this.emitter != null && this.emitter instanceof JSVF2JSEmitter && project != null) {
                packageName = ndef.resolveType(project).getPackageName();
            }
        }
        this.emitTypeShort((IASNode)node, packageName);
    }

    @Override
    public void emitInterfaceMemberDoc(IDefinitionNode node, ICompilerProject project) {
        IParameterNode[] parameters;
        boolean hasDoc = false;
        ASDocComment asDoc = (ASDocComment)((IFunctionNode)node).getASDocComment();
        String returnType = ((IFunctionNode)node).getReturnType();
        if (returnType != "" && returnType != ASEmitterTokens.VOID.getToken()) {
            if (asDoc != null && MXMLJSC.keepASDoc) {
                this.write(asDoc.commentNoEnd());
            } else {
                this.begin();
            }
            hasDoc = true;
            ITypeDefinition tdef = ((IFunctionDefinition)node.getDefinition()).resolveReturnType(project);
            this.emitReturn((IFunctionNode)node, tdef.getPackageName());
        }
        for (IParameterNode pnode : parameters = ((IFunctionNode)node).getParameterNodes()) {
            if (!hasDoc) {
                if (asDoc != null && MXMLJSC.keepASDoc) {
                    this.write(asDoc.commentNoEnd());
                } else {
                    this.begin();
                }
                hasDoc = true;
            }
            IExpressionNode enode = pnode.getNameExpressionNode();
            this.emitParam(pnode, enode.resolveType(project).getPackageName());
        }
        if (hasDoc) {
            this.end();
        }
    }

    @Override
    public void emitMethodAccess(IFunctionNode node) {
        String ns = node.getNamespace();
        if (ns == "private") {
            this.emitPrivate((IASNode)node);
        } else if (ns == "protected") {
            this.emitProtected((IASNode)node);
        } else if (ns == "public") {
            this.emitPublic((IASNode)node);
        }
    }
}

