/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.codegen.js.jx;

import org.apache.flex.compiler.clients.MXMLJSC;
import org.apache.flex.compiler.codegen.js.IJSEmitter;
import org.apache.flex.compiler.definitions.IClassDefinition;
import org.apache.flex.compiler.internal.codegen.as.ASEmitterTokens;
import org.apache.flex.compiler.internal.codegen.js.JSSubEmitter;
import org.apache.flex.compiler.internal.codegen.js.flexjs.JSFlexJSEmitter;
import org.apache.flex.compiler.internal.codegen.js.flexjs.JSFlexJSEmitterTokens;
import org.apache.flex.compiler.internal.codegen.js.goog.JSGoogEmitterTokens;
import org.apache.flex.compiler.internal.codegen.js.utils.EmitterUtils;
import org.apache.flex.compiler.internal.projects.FlexJSProject;
import org.apache.flex.compiler.internal.tree.as.BinaryOperatorAssignmentNode;
import org.apache.flex.compiler.internal.tree.as.FunctionCallNode;
import org.apache.flex.compiler.internal.tree.as.IdentifierNode;
import org.apache.flex.compiler.internal.tree.as.MemberAccessExpressionNode;
import org.apache.flex.compiler.projects.ICompilerProject;
import org.apache.flex.compiler.tree.ASTNodeID;
import org.apache.flex.compiler.tree.as.IASNode;
import org.apache.flex.compiler.tree.as.IClassNode;
import org.apache.flex.compiler.tree.as.IDefinitionNode;
import org.apache.flex.compiler.tree.as.IExpressionNode;
import org.apache.flex.compiler.tree.as.IFunctionCallNode;
import org.apache.flex.compiler.tree.as.IFunctionNode;

public class SuperCallEmitter
extends JSSubEmitter {
    public SuperCallEmitter(IJSEmitter emitter) {
        super(emitter);
    }

    public void emit(IASNode node, String type) {
        IFunctionNode fnode = node instanceof IFunctionNode ? (IFunctionNode)node : null;
        FunctionCallNode fcnode = node instanceof IFunctionCallNode ? (FunctionCallNode)node : null;
        IClassDefinition thisClass = this.getModel().getCurrentClass();
        if (type == "replaceSuperFunction") {
            if (fnode == null) {
                fnode = (IFunctionNode)fcnode.getAncestorOfType(IFunctionNode.class);
            }
            if (fnode != null && fnode.isConstructor() && !EmitterUtils.hasSuperClass(this.getProject(), (IDefinitionNode)fnode)) {
                return;
            }
            IClassNode cnode = (IClassNode)node.getAncestorOfType(IClassNode.class);
            if (cnode == null && MXMLJSC.jsOutputType == MXMLJSC.JSOutputType.VF2JS) {
                return;
            }
            if (fnode != null && (fnode.getNodeID() == ASTNodeID.GetterID || fnode.getNodeID() == ASTNodeID.SetterID)) {
                BinaryOperatorAssignmentNode bnode;
                IFunctionNode pnode;
                ICompilerProject project = this.getProject();
                if (project instanceof FlexJSProject) {
                    ((FlexJSProject)project).needLanguage = true;
                }
                this.write(JSFlexJSEmitterTokens.LANGUAGE_QNAME);
                this.write(ASEmitterTokens.MEMBER_ACCESS);
                if (fnode.getNodeID() == ASTNodeID.GetterID) {
                    this.write(JSFlexJSEmitterTokens.SUPERGETTER);
                } else {
                    this.write(JSFlexJSEmitterTokens.SUPERSETTER);
                }
                this.write(ASEmitterTokens.PAREN_OPEN);
                if (cnode == null && thisClass != null) {
                    this.write(this.getEmitter().formatQualifiedName(thisClass.getQualifiedName()));
                } else {
                    this.write(this.getEmitter().formatQualifiedName(cnode.getQualifiedName()));
                }
                this.writeToken(ASEmitterTokens.COMMA);
                this.write(ASEmitterTokens.THIS);
                this.writeToken(ASEmitterTokens.COMMA);
                this.write(ASEmitterTokens.SINGLE_QUOTE);
                this.write(fnode.getName());
                this.write(ASEmitterTokens.SINGLE_QUOTE);
                IExpressionNode[] anodes = null;
                boolean writeArguments = false;
                if (fcnode != null) {
                    anodes = fcnode.getArgumentNodes();
                    writeArguments = anodes.length > 0;
                } else if (fnode != null && fnode.isConstructor()) {
                    anodes = fnode.getParameterNodes();
                    writeArguments = anodes != null && anodes.length > 0;
                } else if (node instanceof IFunctionNode && node instanceof BinaryOperatorAssignmentNode && (pnode = (IFunctionNode)(bnode = (BinaryOperatorAssignmentNode)node).getAncestorOfType(IFunctionNode.class)).getNodeID() == ASTNodeID.SetterID) {
                    this.writeToken(ASEmitterTokens.COMMA);
                    this.getWalker().walk((IASNode)bnode.getRightOperandNode());
                }
                if (writeArguments) {
                    int len = anodes.length;
                    for (int i = 0; i < len; ++i) {
                        this.writeToken(ASEmitterTokens.COMMA);
                        this.getWalker().walk((IASNode)anodes[i]);
                    }
                }
                this.write(ASEmitterTokens.PAREN_CLOSE);
                return;
            }
        }
        this.super_emitSuperCall(node, type);
    }

    protected void super_emitSuperCall(IASNode node, String type) {
        FunctionCallNode fcnode;
        JSFlexJSEmitter fjs = (JSFlexJSEmitter)this.getEmitter();
        IFunctionNode fnode = node instanceof IFunctionNode ? (IFunctionNode)node : null;
        FunctionCallNode functionCallNode = fcnode = node instanceof IFunctionCallNode ? (FunctionCallNode)node : null;
        if (type == "emptyConstructor") {
            this.indentPush();
            this.writeNewline();
            this.indentPop();
        } else if (type == "replaceSuperFunction" && fnode == null) {
            fnode = (IFunctionNode)fcnode.getAncestorOfType(IFunctionNode.class);
        }
        if (fnode.isConstructor() && !EmitterUtils.hasSuperClass(this.getProject(), (IDefinitionNode)fnode)) {
            return;
        }
        IClassNode cnode = (IClassNode)node.getAncestorOfType(IClassNode.class);
        if (cnode == null) {
            IClassDefinition cdef = this.getModel().getCurrentClass();
            this.write(fjs.formatQualifiedName(cdef.getQualifiedName()));
        } else {
            this.write(fjs.formatQualifiedName(cnode.getQualifiedName()));
        }
        this.write(ASEmitterTokens.MEMBER_ACCESS);
        this.write(JSGoogEmitterTokens.GOOG_BASE);
        this.write(ASEmitterTokens.PAREN_OPEN);
        this.write(ASEmitterTokens.THIS);
        if (fnode.isConstructor()) {
            this.writeToken(ASEmitterTokens.COMMA);
            this.write(ASEmitterTokens.SINGLE_QUOTE);
            this.write(JSGoogEmitterTokens.GOOG_CONSTRUCTOR);
            this.write(ASEmitterTokens.SINGLE_QUOTE);
        }
        if (fnode != null && !fnode.isConstructor()) {
            this.writeToken(ASEmitterTokens.COMMA);
            this.write(ASEmitterTokens.SINGLE_QUOTE);
            IExpressionNode namenode = fcnode.getNameNode();
            String superName = fnode.getName();
            if (namenode instanceof MemberAccessExpressionNode && (namenode = ((MemberAccessExpressionNode)namenode).getRightOperandNode()) instanceof IdentifierNode) {
                superName = ((IdentifierNode)namenode).getName();
            }
            this.write(superName);
            this.write(ASEmitterTokens.SINGLE_QUOTE);
        }
        IExpressionNode[] anodes = null;
        boolean writeArguments = false;
        if (fcnode != null) {
            anodes = fcnode.getArgumentNodes();
            writeArguments = anodes.length > 0;
        } else if (fnode.isConstructor()) {
            // empty if block
        }
        if (writeArguments) {
            int len = anodes.length;
            for (int i = 0; i < len; ++i) {
                this.writeToken(ASEmitterTokens.COMMA);
                this.getWalker().walk((IASNode)anodes[i]);
            }
        }
        this.write(ASEmitterTokens.PAREN_CLOSE);
        if (type == "fullConstructor") {
            this.write(ASEmitterTokens.SEMICOLON);
            this.writeNewline();
        } else if (type == "emptyConstructor") {
            this.write(ASEmitterTokens.SEMICOLON);
        }
    }
}

