/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.codegen.js.jx;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.flex.compiler.asdoc.flexjs.ASDocComment;
import org.apache.flex.compiler.codegen.ISubEmitter;
import org.apache.flex.compiler.codegen.js.IJSEmitter;
import org.apache.flex.compiler.common.ISourceLocation;
import org.apache.flex.compiler.definitions.IDefinition;
import org.apache.flex.compiler.definitions.IFunctionDefinition;
import org.apache.flex.compiler.definitions.IPackageDefinition;
import org.apache.flex.compiler.definitions.ITypeDefinition;
import org.apache.flex.compiler.definitions.IVariableDefinition;
import org.apache.flex.compiler.internal.codegen.as.ASEmitterTokens;
import org.apache.flex.compiler.internal.codegen.js.JSSubEmitter;
import org.apache.flex.compiler.internal.codegen.js.flexjs.JSFlexJSEmitter;
import org.apache.flex.compiler.internal.codegen.js.flexjs.JSFlexJSEmitterTokens;
import org.apache.flex.compiler.internal.codegen.js.goog.JSGoogEmitterTokens;
import org.apache.flex.compiler.internal.codegen.js.node.NodeEmitterTokens;
import org.apache.flex.compiler.internal.codegen.js.utils.EmitterUtils;
import org.apache.flex.compiler.internal.projects.FlexJSProject;
import org.apache.flex.compiler.internal.scopes.ASProjectScope;
import org.apache.flex.compiler.internal.scopes.PackageScope;
import org.apache.flex.compiler.internal.tree.as.ClassNode;
import org.apache.flex.compiler.projects.ICompilerProject;
import org.apache.flex.compiler.scopes.IASScope;
import org.apache.flex.compiler.targets.ITarget;
import org.apache.flex.compiler.tree.as.ITypeNode;
import org.apache.flex.compiler.units.ICompilationUnit;
import org.apache.flex.compiler.utils.NativeUtils;

public class PackageHeaderEmitter
extends JSSubEmitter
implements ISubEmitter<IPackageDefinition> {
    public PackageHeaderEmitter(IJSEmitter emitter) {
        super(emitter);
    }

    @Override
    public void emit(IPackageDefinition definition) {
        IVariableDefinition variable;
        IFunctionDefinition fn;
        IASScope containedScope = definition.getContainedScope();
        ITypeDefinition type = EmitterUtils.findType(containedScope.getAllLocalDefinitions());
        String qname = null;
        if (type != null) {
            qname = type.getQualifiedName();
        }
        if (qname == null && (fn = EmitterUtils.findFunction(containedScope.getAllLocalDefinitions())) != null) {
            qname = fn.getQualifiedName();
        }
        if (qname == null && (variable = EmitterUtils.findVariable(containedScope.getAllLocalDefinitions())) != null) {
            qname = variable.getQualifiedName();
        }
        if (qname == null) {
            return;
        }
        FlexJSProject project = (FlexJSProject)this.getProject();
        List sourcePaths = project.getSourcePath();
        String sourceName = definition.getSourcePath();
        for (File sourcePath : sourcePaths) {
            if (!sourceName.startsWith(sourcePath.getAbsolutePath())) continue;
            sourceName = sourceName.substring(sourcePath.getAbsolutePath().length() + 1);
        }
        this.writeNewline("/**");
        this.writeNewline(" * Generated by Apache Flex Cross-Compiler from " + sourceName);
        this.writeNewline(" * " + qname);
        this.writeNewline(" *");
        this.writeNewline(" * @fileoverview");
        this.writeNewline(" *");
        this.writeNewline(" * @suppress {checkTypes|accessControls}");
        this.writeNewline(" */");
        this.writeNewline();
        this.write(JSGoogEmitterTokens.GOOG_PROVIDE);
        this.write(ASEmitterTokens.PAREN_OPEN);
        this.write(ASEmitterTokens.SINGLE_QUOTE);
        this.write(this.getEmitter().formatQualifiedName(qname));
        this.write(ASEmitterTokens.SINGLE_QUOTE);
        this.write(ASEmitterTokens.PAREN_CLOSE);
        this.writeNewline(ASEmitterTokens.SEMICOLON);
        this.writeNewline();
    }

    public void emitContents(IPackageDefinition definition) {
        ICompilerProject project;
        boolean isMainCU;
        JSFlexJSEmitter fjs = (JSFlexJSEmitter)this.getEmitter();
        this.getEmitter().pushSourceMapName((ISourceLocation)definition.getNode());
        PackageScope containedScope = (PackageScope)definition.getContainedScope();
        ArrayList<String> writtenRequires = new ArrayList<String>();
        Collection localDefinitions = containedScope.getAllLocalDefinitions();
        ITypeDefinition type = EmitterUtils.findType(localDefinitions);
        IDefinition otherMainDefinition = null;
        if (type == null) {
            if (localDefinitions.isEmpty()) {
                return;
            }
            otherMainDefinition = (IDefinition)localDefinitions.iterator().next();
        } else {
            ClassNode classNode;
            ASDocComment asDoc;
            ITypeNode typeNode = type.getNode();
            if (typeNode instanceof ClassNode && (asDoc = (ASDocComment)(classNode = (ClassNode)typeNode).getASDocComment()) != null) {
                String asDocString = asDoc.commentNoEnd();
                String ignoreToken = JSFlexJSEmitterTokens.IGNORE_IMPORT.getToken();
                int ignoreIndex = asDocString.indexOf(ignoreToken);
                while (ignoreIndex != -1) {
                    String ignorable = asDocString.substring(ignoreIndex + ignoreToken.length());
                    int endIndex = ignorable.indexOf("\n");
                    ignorable = ignorable.substring(0, endIndex);
                    ignorable = ignorable.trim();
                    writtenRequires.add(ignorable);
                    ignoreIndex = asDocString.indexOf(ignoreToken, ignoreIndex + ignoreToken.length());
                }
            }
        }
        FlexJSProject flexProject = (FlexJSProject)this.getProject();
        ASProjectScope projectScope = flexProject.getScope();
        ICompilationUnit cu = projectScope.getCompilationUnitForDefinition((IDefinition)(type != null ? type : otherMainDefinition));
        ArrayList<String> requiresList = flexProject.getRequires(cu);
        ArrayList<String> interfacesList = flexProject.getInterfaces(cu);
        ArrayList<String> externalRequiresList = flexProject.getExternalRequires(cu);
        String cname = type != null ? type.getQualifiedName() : otherMainDefinition.getQualifiedName();
        writtenRequires.add(cname);
        boolean emitsRequires = this.emitRequires(requiresList, writtenRequires, cname);
        boolean emitsInterfaces = this.emitInterfaces(interfacesList, writtenRequires);
        boolean makingSWC = flexProject.getSWFTarget() != null && flexProject.getSWFTarget().getTargetType() == ITarget.TargetType.SWC;
        boolean bl = isMainCU = flexProject.mainCU != null && cu.getName().equals(flexProject.mainCU.getName());
        if ((isMainCU || makingSWC) && (project = this.getProject()) instanceof FlexJSProject && ((FlexJSProject)project).needLanguage) {
            this.write(JSGoogEmitterTokens.GOOG_REQUIRE);
            this.write(ASEmitterTokens.PAREN_OPEN);
            this.write(ASEmitterTokens.SINGLE_QUOTE);
            this.write(JSFlexJSEmitterTokens.LANGUAGE_QNAME);
            this.write(ASEmitterTokens.SINGLE_QUOTE);
            this.write(ASEmitterTokens.PAREN_CLOSE);
            this.writeNewline(ASEmitterTokens.SEMICOLON);
        }
        boolean emitsExternalRequires = this.emitExternalRequires(externalRequiresList, writtenRequires);
        if (emitsRequires || emitsInterfaces || emitsExternalRequires || isMainCU) {
            this.writeNewline();
        }
        this.writeNewline();
        this.writeNewline();
    }

    private boolean emitRequires(List<String> requiresList, List<String> writtenRequires, String cname) {
        boolean emitsRequires = false;
        if (requiresList != null) {
            Collections.sort(requiresList);
            for (String imp : requiresList) {
                if (imp.contains(JSGoogEmitterTokens.AS3.getToken()) || imp.equals(JSGoogEmitterTokens.GOOG_BIND.getToken()) || imp.equals(cname) || NativeUtils.isNative(imp) && !imp.equals("QName") && !imp.equals("Namespace") && !imp.equals("XML") && !imp.equals("XMLList") || writtenRequires.indexOf(imp) != -1) continue;
                this.write(JSGoogEmitterTokens.GOOG_REQUIRE);
                this.write(ASEmitterTokens.PAREN_OPEN);
                this.write(ASEmitterTokens.SINGLE_QUOTE);
                this.write(this.getEmitter().formatQualifiedName(imp));
                this.write(ASEmitterTokens.SINGLE_QUOTE);
                this.write(ASEmitterTokens.PAREN_CLOSE);
                this.writeNewline(ASEmitterTokens.SEMICOLON);
                writtenRequires.add(imp);
                emitsRequires = true;
            }
        }
        return emitsRequires;
    }

    private boolean emitInterfaces(List<String> interfacesList, List<String> writtenRequires) {
        boolean emitsInterfaces = false;
        if (interfacesList != null) {
            Collections.sort(interfacesList);
            for (String imp : interfacesList) {
                if (writtenRequires.indexOf(imp) != -1) continue;
                this.write(JSGoogEmitterTokens.GOOG_REQUIRE);
                this.write(ASEmitterTokens.PAREN_OPEN);
                this.write(ASEmitterTokens.SINGLE_QUOTE);
                this.write(this.getEmitter().formatQualifiedName(imp));
                this.write(ASEmitterTokens.SINGLE_QUOTE);
                this.write(ASEmitterTokens.PAREN_CLOSE);
                this.writeNewline(ASEmitterTokens.SEMICOLON);
                emitsInterfaces = true;
            }
        }
        return emitsInterfaces;
    }

    private boolean emitExternalRequires(List<String> externalRequiresList, List<String> writtenRequires) {
        boolean emitsExternalRequires = false;
        if (externalRequiresList != null) {
            Collections.sort(externalRequiresList);
            for (String imp : externalRequiresList) {
                if (writtenRequires.indexOf(imp) != -1) continue;
                this.write(ASEmitterTokens.VAR);
                this.write(ASEmitterTokens.SPACE);
                this.write(imp);
                this.write(ASEmitterTokens.SPACE);
                this.write(ASEmitterTokens.EQUAL);
                this.write(ASEmitterTokens.SPACE);
                this.write(NodeEmitterTokens.REQUIRE);
                this.write(ASEmitterTokens.PAREN_OPEN);
                this.write(ASEmitterTokens.SINGLE_QUOTE);
                this.write(imp);
                this.write(ASEmitterTokens.SINGLE_QUOTE);
                this.write(ASEmitterTokens.PAREN_CLOSE);
                this.writeNewline(ASEmitterTokens.SEMICOLON);
                writtenRequires.add(imp);
                emitsExternalRequires = true;
            }
        }
        return emitsExternalRequires;
    }
}

