/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.codegen.js.jx;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.flex.compiler.codegen.ISubEmitter;
import org.apache.flex.compiler.codegen.js.IJSEmitter;
import org.apache.flex.compiler.common.ASModifier;
import org.apache.flex.compiler.common.ModifiersSet;
import org.apache.flex.compiler.definitions.IDefinition;
import org.apache.flex.compiler.definitions.IPackageDefinition;
import org.apache.flex.compiler.definitions.ITypeDefinition;
import org.apache.flex.compiler.definitions.metadata.IMetaTagAttribute;
import org.apache.flex.compiler.internal.codegen.as.ASEmitterTokens;
import org.apache.flex.compiler.internal.codegen.js.JSEmitterTokens;
import org.apache.flex.compiler.internal.codegen.js.JSSubEmitter;
import org.apache.flex.compiler.internal.codegen.js.flexjs.JSFlexJSDocEmitter;
import org.apache.flex.compiler.internal.codegen.js.flexjs.JSFlexJSEmitterTokens;
import org.apache.flex.compiler.internal.codegen.js.utils.EmitterUtils;
import org.apache.flex.compiler.internal.driver.js.goog.JSGoogConfiguration;
import org.apache.flex.compiler.internal.projects.FlexJSProject;
import org.apache.flex.compiler.internal.tree.as.SetterNode;
import org.apache.flex.compiler.scopes.IASScope;
import org.apache.flex.compiler.tree.ASTNodeID;
import org.apache.flex.compiler.tree.as.IClassNode;
import org.apache.flex.compiler.tree.as.IDefinitionNode;
import org.apache.flex.compiler.tree.as.IExpressionNode;
import org.apache.flex.compiler.tree.as.IFunctionNode;
import org.apache.flex.compiler.tree.as.IInterfaceNode;
import org.apache.flex.compiler.tree.as.ITypeNode;
import org.apache.flex.compiler.tree.as.IVariableNode;
import org.apache.flex.compiler.tree.metadata.IMetaTagNode;
import org.apache.flex.compiler.tree.metadata.IMetaTagsNode;

public class PackageFooterEmitter
extends JSSubEmitter
implements ISubEmitter<IPackageDefinition> {
    private ArrayList<VariableData> varData;
    private ArrayList<MethodData> accessorData;
    private ArrayList<MethodData> methodData;

    public PackageFooterEmitter(IJSEmitter emitter) {
        super(emitter);
    }

    @Override
    public void emit(IPackageDefinition definition) {
        this.getEmitter().popSourceMapName();
        IASScope containedScope = definition.getContainedScope();
        ITypeDefinition type = EmitterUtils.findType(containedScope.getAllLocalDefinitions());
        if (type == null) {
            return;
        }
        this.getEmitter().emitSourceMapDirective(type.getNode());
    }

    public void emitClassInfo(ITypeNode tnode) {
        JSFlexJSDocEmitter doc = (JSFlexJSDocEmitter)this.getEmitter().getDocEmitter();
        this.writeNewline();
        this.writeNewline();
        this.writeNewline();
        doc.begin();
        this.writeNewline(" * Metadata");
        this.writeNewline(" *");
        this.writeNewline(" * @type {Object.<string, Array.<Object>>}");
        doc.end();
        this.write(this.getEmitter().formatQualifiedName(tnode.getQualifiedName()));
        this.write(ASEmitterTokens.MEMBER_ACCESS);
        this.write(JSEmitterTokens.PROTOTYPE);
        this.write(ASEmitterTokens.MEMBER_ACCESS);
        this.writeToken(JSFlexJSEmitterTokens.FLEXJS_CLASS_INFO);
        this.writeToken(ASEmitterTokens.EQUAL);
        this.writeToken(ASEmitterTokens.BLOCK_OPEN);
        this.write(JSFlexJSEmitterTokens.NAMES);
        this.writeToken(ASEmitterTokens.COLON);
        this.write(ASEmitterTokens.SQUARE_OPEN);
        this.writeToken(ASEmitterTokens.BLOCK_OPEN);
        this.write(JSFlexJSEmitterTokens.NAME);
        this.writeToken(ASEmitterTokens.COLON);
        this.write(ASEmitterTokens.SINGLE_QUOTE);
        this.write(tnode.getName());
        this.write(ASEmitterTokens.SINGLE_QUOTE);
        this.writeToken(ASEmitterTokens.COMMA);
        this.write(JSFlexJSEmitterTokens.QNAME);
        this.writeToken(ASEmitterTokens.COLON);
        this.write(ASEmitterTokens.SINGLE_QUOTE);
        this.write(this.getEmitter().formatQualifiedName(tnode.getQualifiedName()));
        this.write(ASEmitterTokens.SINGLE_QUOTE);
        this.write(ASEmitterTokens.BLOCK_CLOSE);
        this.write(ASEmitterTokens.SQUARE_CLOSE);
        IExpressionNode[] enodes = tnode instanceof IClassNode ? ((IClassNode)tnode).getImplementedInterfaceNodes() : ((IInterfaceNode)tnode).getExtendedInterfaceNodes();
        if (enodes.length > 0) {
            this.writeToken(ASEmitterTokens.COMMA);
            this.write(JSFlexJSEmitterTokens.INTERFACES);
            this.writeToken(ASEmitterTokens.COLON);
            this.write(ASEmitterTokens.SQUARE_OPEN);
            int i = 0;
            for (IExpressionNode enode : enodes) {
                IDefinition edef = enode.resolve(this.getProject());
                if (edef == null) continue;
                this.write(this.getEmitter().formatQualifiedName(edef.getQualifiedName()));
                if (i < enodes.length - 1) {
                    this.writeToken(ASEmitterTokens.COMMA);
                }
                ++i;
            }
            this.write(ASEmitterTokens.SQUARE_CLOSE);
        }
        this.write(ASEmitterTokens.SPACE);
        this.write(ASEmitterTokens.BLOCK_CLOSE);
        this.write(ASEmitterTokens.SEMICOLON);
        if (!(tnode instanceof IInterfaceNode)) {
            this.writeNewline();
            this.writeNewline();
            this.writeNewline();
            doc.begin();
            this.writeNewline(" * Prevent renaming of class. Needed for reflection.");
            doc.end();
            this.write(JSFlexJSEmitterTokens.GOOG_EXPORT_SYMBOL);
            this.write(ASEmitterTokens.PAREN_OPEN);
            this.write(ASEmitterTokens.SINGLE_QUOTE);
            this.write(this.getEmitter().formatQualifiedName(tnode.getQualifiedName()));
            this.write(ASEmitterTokens.SINGLE_QUOTE);
            this.write(ASEmitterTokens.COMMA);
            this.write(ASEmitterTokens.SPACE);
            this.write(this.getEmitter().formatQualifiedName(tnode.getQualifiedName()));
            this.write(ASEmitterTokens.PAREN_CLOSE);
            this.write(ASEmitterTokens.SEMICOLON);
        }
        this.collectReflectionData(tnode);
        IMetaTagNode[] metadata = null;
        IMetaTagsNode metadataTags = tnode.getMetaTags();
        if (metadataTags != null) {
            metadata = metadataTags.getAllTags();
        }
        this.emitReflectionData(this.getEmitter().formatQualifiedName(tnode.getQualifiedName()), this.varData, this.accessorData, this.methodData, metadata);
    }

    public void collectReflectionData(ITypeNode tnode) {
        IMetaTagNode[] tags;
        IMetaTagsNode metaData;
        String declarant;
        Object declarer;
        MethodData data;
        IFunctionNode fnNode;
        String ns;
        this.varData = new ArrayList();
        this.accessorData = new ArrayList();
        this.methodData = new ArrayList();
        boolean isInterface = tnode instanceof IInterfaceNode;
        IDefinitionNode[] dnodes = !isInterface ? ((IClassNode)tnode).getAllMemberNodes() : ((IInterfaceNode)tnode).getAllMemberDefinitionNodes();
        for (IDefinitionNode dnode : dnodes) {
            IMetaTagNode[] tags2;
            IVariableNode varNode;
            String ns2;
            boolean isStatic;
            ModifiersSet modifierSet = dnode.getDefinition().getModifiers();
            boolean bl = isStatic = modifierSet != null && modifierSet.hasModifier(ASModifier.STATIC);
            if (isStatic || dnode.getNodeID() != ASTNodeID.VariableID && dnode.getNodeID() != ASTNodeID.BindableVariableID || (ns2 = (varNode = (IVariableNode)dnode).getNamespace()) != "public" && !isInterface) continue;
            VariableData data2 = new VariableData();
            this.varData.add(data2);
            data2.name = varNode.getName();
            data2.type = this.getEmitter().formatQualifiedName(varNode.getVariableType());
            IMetaTagsNode metaData2 = varNode.getMetaTags();
            if (metaData2 == null || (tags2 = metaData2.getAllTags()).length <= 0) continue;
            data2.metaData = tags2;
        }
        HashMap<String, MethodData> accessorMap = new HashMap<String, MethodData>();
        for (IDefinitionNode dnode : dnodes) {
            boolean isStatic;
            ModifiersSet modifierSet = dnode.getDefinition().getModifiers();
            boolean bl = isStatic = modifierSet != null && modifierSet.hasModifier(ASModifier.STATIC);
            if (isStatic || dnode.getNodeID() != ASTNodeID.GetterID && dnode.getNodeID() != ASTNodeID.SetterID || (ns = (fnNode = (IFunctionNode)dnode).getNamespace()) != "public" && !isInterface) continue;
            data = new MethodData();
            data.name = fnNode.getName();
            if (accessorMap.containsKey(data.name)) continue;
            this.accessorData.add(data);
            data.type = dnode.getNodeID() == ASTNodeID.GetterID ? fnNode.getReturnType() : ((SetterNode)fnNode).getVariableType();
            accessorMap.put(data.name, data);
            data.type = this.getEmitter().formatQualifiedName(data.type);
            declarer = (IClassNode)fnNode.getAncestorOfType(IClassNode.class);
            declarant = this.getEmitter().formatQualifiedName(tnode.getQualifiedName());
            if (declarer != null) {
                declarant = this.getEmitter().formatQualifiedName(declarer.getQualifiedName());
            }
            data.declaredBy = declarant;
            metaData = fnNode.getMetaTags();
            if (metaData == null || (tags = metaData.getAllTags()).length <= 0) continue;
            data.metaData = tags;
        }
        for (IDefinitionNode dnode : dnodes) {
            boolean isStatic;
            ModifiersSet modifierSet = dnode.getDefinition().getModifiers();
            boolean bl = isStatic = modifierSet != null && modifierSet.hasModifier(ASModifier.STATIC);
            if (dnode.getNodeID() != ASTNodeID.FunctionID || isStatic || (ns = (fnNode = (IFunctionNode)dnode).getNamespace()) != "public" && !isInterface) continue;
            data = new MethodData();
            this.methodData.add(data);
            data.name = fnNode.getName();
            data.type = this.getEmitter().formatQualifiedName(fnNode.getReturnType());
            declarer = isInterface ? (IInterfaceNode)fnNode.getAncestorOfType(IInterfaceNode.class) : (IClassNode)fnNode.getAncestorOfType(IClassNode.class);
            declarant = this.getEmitter().formatQualifiedName(tnode.getQualifiedName());
            if (declarer != null) {
                declarant = this.getEmitter().formatQualifiedName(declarer.getQualifiedName());
            }
            data.declaredBy = declarant;
            metaData = fnNode.getMetaTags();
            if (metaData == null || (tags = metaData.getAllTags()).length <= 0) continue;
            data.metaData = tags;
        }
    }

    public void emitReflectionData(String typeName, List<VariableData> varData, List<MethodData> accessorData, List<MethodData> methodData, IMetaTagNode[] metaData) {
        IMetaTagNode[] tags;
        JSFlexJSDocEmitter doc = (JSFlexJSDocEmitter)this.getEmitter().getDocEmitter();
        this.writeNewline();
        this.writeNewline();
        this.writeNewline();
        this.writeNewline();
        doc.begin();
        this.writeNewline(" * Reflection");
        this.writeNewline(" *");
        this.writeNewline(" * @return {Object.<string, Function>}");
        doc.end();
        this.write(typeName);
        this.write(ASEmitterTokens.MEMBER_ACCESS);
        this.write(JSEmitterTokens.PROTOTYPE);
        this.write(ASEmitterTokens.MEMBER_ACCESS);
        this.writeToken(JSFlexJSEmitterTokens.FLEXJS_REFLECTION_INFO);
        this.writeToken(ASEmitterTokens.EQUAL);
        this.writeToken(ASEmitterTokens.FUNCTION);
        this.write(ASEmitterTokens.PAREN_OPEN);
        this.writeToken(ASEmitterTokens.PAREN_CLOSE);
        this.write(ASEmitterTokens.BLOCK_OPEN);
        this.indentPush();
        this.writeNewline();
        this.writeToken(ASEmitterTokens.RETURN);
        this.write(ASEmitterTokens.BLOCK_OPEN);
        this.indentPush();
        this.writeNewline();
        this.write("variables");
        this.writeToken(ASEmitterTokens.COLON);
        this.writeToken(ASEmitterTokens.FUNCTION);
        this.write(ASEmitterTokens.PAREN_OPEN);
        this.writeToken(ASEmitterTokens.PAREN_CLOSE);
        this.write(ASEmitterTokens.BLOCK_OPEN);
        this.indentPush();
        this.writeNewline();
        this.writeToken(ASEmitterTokens.RETURN);
        this.write(ASEmitterTokens.BLOCK_OPEN);
        this.indentPush();
        int count = 0;
        for (VariableData var : varData) {
            if (count > 0) {
                this.write(ASEmitterTokens.COMMA);
            }
            this.writeNewline();
            ++count;
            this.write(ASEmitterTokens.SINGLE_QUOTE);
            this.write(var.name);
            this.write(ASEmitterTokens.SINGLE_QUOTE);
            this.writeToken(ASEmitterTokens.COLON);
            this.writeToken(ASEmitterTokens.BLOCK_OPEN);
            this.write("type");
            this.writeToken(ASEmitterTokens.COLON);
            this.write(ASEmitterTokens.SINGLE_QUOTE);
            this.write(var.type);
            this.write(ASEmitterTokens.SINGLE_QUOTE);
            tags = var.metaData;
            if (tags != null) {
                this.writeToken(ASEmitterTokens.COMMA);
                this.writeMetaData(tags);
            }
            this.write(ASEmitterTokens.BLOCK_CLOSE);
        }
        this.indentPop();
        this.writeNewline();
        this.write(ASEmitterTokens.BLOCK_CLOSE);
        this.write(ASEmitterTokens.SEMICOLON);
        this.indentPop();
        this.writeNewline();
        this.write(ASEmitterTokens.BLOCK_CLOSE);
        this.write(ASEmitterTokens.COMMA);
        this.writeNewline();
        this.write("accessors");
        this.writeToken(ASEmitterTokens.COLON);
        this.writeToken(ASEmitterTokens.FUNCTION);
        this.write(ASEmitterTokens.PAREN_OPEN);
        this.writeToken(ASEmitterTokens.PAREN_CLOSE);
        this.write(ASEmitterTokens.BLOCK_OPEN);
        this.indentPush();
        this.writeNewline();
        this.writeToken(ASEmitterTokens.RETURN);
        this.write(ASEmitterTokens.BLOCK_OPEN);
        this.indentPush();
        count = 0;
        for (MethodData accessor : accessorData) {
            if (count > 0) {
                this.write(ASEmitterTokens.COMMA);
            }
            this.writeNewline();
            ++count;
            this.write(ASEmitterTokens.SINGLE_QUOTE);
            this.write(accessor.name);
            this.write(ASEmitterTokens.SINGLE_QUOTE);
            this.writeToken(ASEmitterTokens.COLON);
            this.writeToken(ASEmitterTokens.BLOCK_OPEN);
            this.write("type");
            this.writeToken(ASEmitterTokens.COLON);
            this.write(ASEmitterTokens.SINGLE_QUOTE);
            this.write(accessor.type);
            this.write(ASEmitterTokens.SINGLE_QUOTE);
            this.writeToken(ASEmitterTokens.COMMA);
            this.write("declaredBy");
            this.writeToken(ASEmitterTokens.COLON);
            this.write(ASEmitterTokens.SINGLE_QUOTE);
            this.write(accessor.declaredBy);
            this.write(ASEmitterTokens.SINGLE_QUOTE);
            tags = accessor.metaData;
            if (tags != null) {
                this.writeToken(ASEmitterTokens.COMMA);
                this.writeMetaData(tags);
            }
            this.write(ASEmitterTokens.BLOCK_CLOSE);
        }
        this.indentPop();
        this.writeNewline();
        this.write(ASEmitterTokens.BLOCK_CLOSE);
        this.write(ASEmitterTokens.SEMICOLON);
        this.indentPop();
        this.writeNewline();
        this.write(ASEmitterTokens.BLOCK_CLOSE);
        this.write(ASEmitterTokens.COMMA);
        this.writeNewline();
        this.write("methods");
        this.writeToken(ASEmitterTokens.COLON);
        this.writeToken(ASEmitterTokens.FUNCTION);
        this.write(ASEmitterTokens.PAREN_OPEN);
        this.writeToken(ASEmitterTokens.PAREN_CLOSE);
        this.write(ASEmitterTokens.BLOCK_OPEN);
        this.indentPush();
        this.writeNewline();
        this.writeToken(ASEmitterTokens.RETURN);
        this.write(ASEmitterTokens.BLOCK_OPEN);
        this.indentPush();
        count = 0;
        for (MethodData method : methodData) {
            if (count > 0) {
                this.write(ASEmitterTokens.COMMA);
            }
            this.writeNewline();
            ++count;
            this.write(ASEmitterTokens.SINGLE_QUOTE);
            this.write(method.name);
            this.write(ASEmitterTokens.SINGLE_QUOTE);
            this.writeToken(ASEmitterTokens.COLON);
            this.writeToken(ASEmitterTokens.BLOCK_OPEN);
            this.write("type");
            this.writeToken(ASEmitterTokens.COLON);
            this.write(ASEmitterTokens.SINGLE_QUOTE);
            this.write(method.type);
            this.write(ASEmitterTokens.SINGLE_QUOTE);
            this.writeToken(ASEmitterTokens.COMMA);
            this.write("declaredBy");
            this.writeToken(ASEmitterTokens.COLON);
            this.write(ASEmitterTokens.SINGLE_QUOTE);
            this.write(method.declaredBy);
            this.write(ASEmitterTokens.SINGLE_QUOTE);
            tags = method.metaData;
            if (tags != null) {
                this.writeToken(ASEmitterTokens.COMMA);
                this.writeMetaData(tags);
            }
            this.write(ASEmitterTokens.BLOCK_CLOSE);
        }
        this.indentPop();
        this.writeNewline();
        this.write(ASEmitterTokens.BLOCK_CLOSE);
        this.write(ASEmitterTokens.SEMICOLON);
        this.indentPop();
        this.writeNewline();
        this.write(ASEmitterTokens.BLOCK_CLOSE);
        if (metaData != null && metaData.length > 0) {
            this.write(ASEmitterTokens.COMMA);
            this.writeNewline();
            this.writeMetaData(metaData);
        }
        this.indentPop();
        this.writeNewline();
        this.write(ASEmitterTokens.BLOCK_CLOSE);
        this.write(ASEmitterTokens.SEMICOLON);
        this.indentPop();
        this.writeNewline();
        this.write(ASEmitterTokens.BLOCK_CLOSE);
        this.writeNewline(ASEmitterTokens.SEMICOLON);
    }

    private void writeMetaData(IMetaTagNode[] tags) {
        JSGoogConfiguration config = ((FlexJSProject)this.getWalker().getProject()).config;
        Set allowedNames = config.getCompilerKeepAs3Metadata();
        this.write("metadata");
        this.writeToken(ASEmitterTokens.COLON);
        this.writeToken(ASEmitterTokens.FUNCTION);
        this.write(ASEmitterTokens.PAREN_OPEN);
        this.writeToken(ASEmitterTokens.PAREN_CLOSE);
        this.writeToken(ASEmitterTokens.BLOCK_OPEN);
        this.writeToken(ASEmitterTokens.RETURN);
        this.writeToken(ASEmitterTokens.SQUARE_OPEN);
        int count = 0;
        for (int i = 0; i < tags.length; ++i) {
            IMetaTagNode tag = tags[i];
            if (count > 0) {
                this.writeToken(ASEmitterTokens.COMMA);
            }
            if (!allowedNames.contains(tag.getTagName())) continue;
            ++count;
            this.writeToken(ASEmitterTokens.BLOCK_OPEN);
            this.write("name");
            this.writeToken(ASEmitterTokens.COLON);
            this.write(ASEmitterTokens.SINGLE_QUOTE);
            this.write(tag.getTagName());
            this.write(ASEmitterTokens.SINGLE_QUOTE);
            IMetaTagAttribute[] args = tag.getAllAttributes();
            if (args.length > 0) {
                this.writeToken(ASEmitterTokens.COMMA);
                this.write("args");
                this.writeToken(ASEmitterTokens.COLON);
                this.writeToken(ASEmitterTokens.SQUARE_OPEN);
                for (int j = 0; j < args.length; ++j) {
                    if (j > 0) {
                        this.writeToken(ASEmitterTokens.COMMA);
                    }
                    IMetaTagAttribute arg = args[j];
                    this.writeToken(ASEmitterTokens.BLOCK_OPEN);
                    this.write("key");
                    this.writeToken(ASEmitterTokens.COLON);
                    this.write(ASEmitterTokens.SINGLE_QUOTE);
                    String key = arg.getKey();
                    this.write(key == null ? "" : key);
                    this.write(ASEmitterTokens.SINGLE_QUOTE);
                    this.writeToken(ASEmitterTokens.COMMA);
                    this.write("value");
                    this.writeToken(ASEmitterTokens.COLON);
                    this.write(ASEmitterTokens.SINGLE_QUOTE);
                    this.write(arg.getValue());
                    this.write(ASEmitterTokens.SINGLE_QUOTE);
                    this.write(ASEmitterTokens.BLOCK_CLOSE);
                }
                this.write(ASEmitterTokens.SQUARE_CLOSE);
            }
            this.write(ASEmitterTokens.BLOCK_CLOSE);
        }
        this.write(ASEmitterTokens.SQUARE_CLOSE);
        this.writeToken(ASEmitterTokens.SEMICOLON);
        this.write(ASEmitterTokens.BLOCK_CLOSE);
    }

    public class MethodData {
        public String name;
        public String type;
        public String declaredBy;
        public IMetaTagNode[] metaData;
    }

    public class VariableData {
        public String name;
        public String type;
        public IMetaTagNode[] metaData;
    }
}

