/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.codegen.js.jx;

import org.apache.flex.compiler.codegen.ISubEmitter;
import org.apache.flex.compiler.codegen.js.IJSEmitter;
import org.apache.flex.compiler.common.ISourceLocation;
import org.apache.flex.compiler.definitions.IDefinition;
import org.apache.flex.compiler.definitions.ITypeDefinition;
import org.apache.flex.compiler.internal.codegen.as.ASEmitterTokens;
import org.apache.flex.compiler.internal.codegen.js.JSSubEmitter;
import org.apache.flex.compiler.internal.codegen.js.flexjs.JSFlexJSEmitter;
import org.apache.flex.compiler.internal.codegen.js.flexjs.JSFlexJSEmitterTokens;
import org.apache.flex.compiler.internal.codegen.js.utils.EmitterUtils;
import org.apache.flex.compiler.internal.definitions.AppliedVectorDefinition;
import org.apache.flex.compiler.internal.definitions.ClassDefinition;
import org.apache.flex.compiler.internal.definitions.InterfaceDefinition;
import org.apache.flex.compiler.internal.projects.FlexJSProject;
import org.apache.flex.compiler.internal.tree.as.ContainerNode;
import org.apache.flex.compiler.internal.tree.as.VectorLiteralNode;
import org.apache.flex.compiler.projects.ICompilerProject;
import org.apache.flex.compiler.tree.ASTNodeID;
import org.apache.flex.compiler.tree.as.IASNode;
import org.apache.flex.compiler.tree.as.IContainerNode;
import org.apache.flex.compiler.tree.as.IExpressionNode;
import org.apache.flex.compiler.tree.as.IFunctionCallNode;
import org.apache.flex.compiler.utils.NativeUtils;

public class FunctionCallEmitter
extends JSSubEmitter
implements ISubEmitter<IFunctionCallNode> {
    public FunctionCallEmitter(IJSEmitter emitter) {
        super(emitter);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void emit(IFunctionCallNode node) {
        boolean isClassCast;
        IDefinition def;
        IASNode cnode;
        JSFlexJSEmitter fjs;
        block31: {
            ASTNodeID id;
            fjs = (JSFlexJSEmitter)this.getEmitter();
            cnode = node.getChild(0);
            if (cnode.getNodeID() == ASTNodeID.MemberAccessExpressionID) {
                cnode = cnode.getChild(0);
            }
            if ((id = cnode.getNodeID()) == ASTNodeID.SuperID) {
                fjs.emitSuperCall((IASNode)node, "replaceSuperFunction");
                return;
            }
            def = null;
            isClassCast = false;
            if (node.isNewExpression()) {
                if (!(node.getChild(1) instanceof VectorLiteralNode)) {
                    this.startMapping((ISourceLocation)node.getNewKeywordNode());
                    this.writeToken(ASEmitterTokens.NEW);
                    this.endMapping((ISourceLocation)node.getNewKeywordNode());
                    break block31;
                } else {
                    VectorLiteralNode vectorLiteralNode = (VectorLiteralNode)node.getChild(1);
                    this.write("[");
                    ContainerNode contentsNode = vectorLiteralNode.getContentsNode();
                    int len = contentsNode.getChildCount();
                    int i = 0;
                    while (true) {
                        if (i >= len) {
                            this.write("]");
                            return;
                        }
                        this.getWalker().walk(contentsNode.getChild(i));
                        if (i < len - 1) {
                            this.writeToken(ASEmitterTokens.COMMA);
                        }
                        ++i;
                    }
                }
            }
            def = node.getNameNode().resolve(this.getProject());
            boolean bl = isClassCast = (def instanceof ClassDefinition || def instanceof InterfaceDefinition) && !NativeUtils.isJSNative(def.getBaseName()) && !def.getBaseName().equals("XML") && !def.getBaseName().equals("XMLList");
        }
        if (node.isNewExpression()) {
            def = node.resolveCalledExpression(this.getProject());
            IExpressionNode nameNode = node.getNameNode();
            if (def instanceof ClassDefinition) {
                this.startMapping((ISourceLocation)nameNode);
                this.write(this.getEmitter().formatQualifiedName(def.getQualifiedName()));
                this.endMapping((ISourceLocation)nameNode);
            } else {
                if (nameNode.hasParenthesis()) {
                    this.write(ASEmitterTokens.PAREN_OPEN);
                }
                this.getEmitter().getWalker().walk((IASNode)nameNode);
                if (nameNode.hasParenthesis()) {
                    this.write(ASEmitterTokens.PAREN_CLOSE);
                }
            }
            this.getEmitter().emitArguments((IContainerNode)node.getArgumentsNode());
            return;
        }
        if (isClassCast) {
            fjs.emitIsAs((IExpressionNode)node, node.getArgumentNodes()[0], node.getNameNode(), ASTNodeID.Op_AsID, true);
            return;
        }
        if (def != null) {
            boolean isInt = def.getBaseName().equals("int");
            if (isInt || def.getBaseName().equals("trace") || def.getBaseName().equals("uint")) {
                ICompilerProject project = this.getProject();
                if (project instanceof FlexJSProject) {
                    ((FlexJSProject)project).needLanguage = true;
                }
                this.startMapping((ISourceLocation)node.getNameNode());
                this.write(JSFlexJSEmitterTokens.LANGUAGE_QNAME);
                this.write(ASEmitterTokens.MEMBER_ACCESS);
                if (isInt) {
                    this.write(JSFlexJSEmitterTokens.UNDERSCORE);
                }
                this.endMapping((ISourceLocation)node.getNameNode());
            } else if (def.getBaseName().equals("sortOn")) {
                if (def.getParent() != null && def.getParent().getQualifiedName().equals("Array")) {
                    ICompilerProject project = this.getProject();
                    if (project instanceof FlexJSProject) {
                        ((FlexJSProject)project).needLanguage = true;
                    }
                    this.write(JSFlexJSEmitterTokens.LANGUAGE_QNAME);
                    this.write(ASEmitterTokens.MEMBER_ACCESS);
                    this.write("sortOn");
                    IContainerNode newArgs = EmitterUtils.insertArgumentsBefore((IContainerNode)node.getArgumentsNode(), cnode);
                    fjs.emitArguments(newArgs);
                    return;
                }
            } else if (def.getBaseName().equals("sort")) {
                ICompilerProject project;
                IExpressionNode param1;
                ITypeDefinition paramDef1;
                IExpressionNode[] args;
                if (def.getParent() != null && def.getParent().getQualifiedName().equals("Array") && (args = node.getArgumentNodes()).length > 0 && (paramDef1 = (param1 = args[0]).resolveType(project = this.getProject())).getBaseName().equals("int")) {
                    if (project instanceof FlexJSProject) {
                        ((FlexJSProject)project).needLanguage = true;
                    }
                    this.write(JSFlexJSEmitterTokens.LANGUAGE_QNAME);
                    this.write(ASEmitterTokens.MEMBER_ACCESS);
                    this.write("sort");
                    IContainerNode newArgs = EmitterUtils.insertArgumentsBefore((IContainerNode)node.getArgumentsNode(), cnode);
                    fjs.emitArguments(newArgs);
                    return;
                }
            } else if (def instanceof AppliedVectorDefinition) {
                IExpressionNode[] argumentNodes = node.getArgumentNodes();
                int len = argumentNodes.length;
                int i = 0;
                while (true) {
                    if (i >= len) {
                        this.write(".slice()");
                        return;
                    }
                    IExpressionNode argumentNode = argumentNodes[i];
                    this.getWalker().walk((IASNode)argumentNode);
                    if (i < len - 1) {
                        this.write(", ");
                    }
                    ++i;
                }
            }
        }
        this.getWalker().walk((IASNode)node.getNameNode());
        this.getEmitter().emitArguments((IContainerNode)node.getArgumentsNode());
    }
}

