/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.codegen.js.jx;

import org.apache.flex.compiler.codegen.ISubEmitter;
import org.apache.flex.compiler.codegen.js.IJSEmitter;
import org.apache.flex.compiler.codegen.js.goog.IJSGoogDocEmitter;
import org.apache.flex.compiler.common.ASModifier;
import org.apache.flex.compiler.common.ISourceLocation;
import org.apache.flex.compiler.common.ModifiersSet;
import org.apache.flex.compiler.definitions.IClassDefinition;
import org.apache.flex.compiler.definitions.IDefinition;
import org.apache.flex.compiler.definitions.ITypeDefinition;
import org.apache.flex.compiler.definitions.IVariableDefinition;
import org.apache.flex.compiler.internal.codegen.as.ASEmitterTokens;
import org.apache.flex.compiler.internal.codegen.js.JSEmitterTokens;
import org.apache.flex.compiler.internal.codegen.js.JSSubEmitter;
import org.apache.flex.compiler.internal.codegen.js.utils.EmitterUtils;
import org.apache.flex.compiler.internal.tree.as.ChainedVariableNode;
import org.apache.flex.compiler.tree.ASTNodeID;
import org.apache.flex.compiler.tree.as.IASNode;
import org.apache.flex.compiler.tree.as.IDefinitionNode;
import org.apache.flex.compiler.tree.as.IExpressionNode;
import org.apache.flex.compiler.tree.as.IVariableNode;

public class FieldEmitter
extends JSSubEmitter
implements ISubEmitter<IVariableNode> {
    public FieldEmitter(IJSEmitter emitter) {
        super(emitter);
    }

    @Override
    public void emit(IVariableNode node) {
        IExpressionNode vnode;
        boolean isPackageOrFileMember;
        IClassDefinition definition = EmitterUtils.getClassDefinition((IDefinitionNode)node);
        ITypeDefinition def = null;
        IExpressionNode enode = node.getVariableTypeNode();
        if (enode != null) {
            def = enode.resolveType(this.getProject());
        }
        if (this.getEmitter().getDocEmitter() instanceof IJSGoogDocEmitter) {
            ((IJSGoogDocEmitter)this.getEmitter().getDocEmitter()).emitFieldDoc(node, (IDefinition)def, this.getProject());
        }
        IDefinition ndef = node.getDefinition();
        String root = "";
        IVariableDefinition.VariableClassification classification = node.getVariableClassification();
        boolean bl = isPackageOrFileMember = classification == IVariableDefinition.VariableClassification.PACKAGE_MEMBER || classification == IVariableDefinition.VariableClassification.FILE_MEMBER;
        if (isPackageOrFileMember) {
            this.write(this.getEmitter().formatQualifiedName(node.getQualifiedName()));
        } else {
            ModifiersSet modifierSet = ndef.getModifiers();
            if (modifierSet != null && !modifierSet.hasModifier(ASModifier.STATIC)) {
                root = JSEmitterTokens.PROTOTYPE.getToken();
                root = root + ASEmitterTokens.MEMBER_ACCESS.getToken();
            }
            if (definition == null) {
                definition = ndef.getContainingScope().getDefinition();
            }
            this.startMapping((ISourceLocation)node.getNameExpressionNode());
            this.write(this.getEmitter().formatQualifiedName(definition.getQualifiedName()) + ASEmitterTokens.MEMBER_ACCESS.getToken() + root);
            this.write(node.getName());
            this.endMapping((ISourceLocation)node.getNameExpressionNode());
        }
        if (node.getNodeID() == ASTNodeID.BindableVariableID) {
            this.write("_");
        }
        if ((vnode = node.getAssignedValueNode()) != null && (ndef.isStatic() || EmitterUtils.isScalar(vnode) || isPackageOrFileMember)) {
            this.startMapping((ISourceLocation)node);
            this.write(ASEmitterTokens.SPACE);
            this.writeToken(ASEmitterTokens.EQUAL);
            this.endMapping((ISourceLocation)node);
            this.getEmitter().getWalker().walk((IASNode)vnode);
        }
        if (!(node instanceof ChainedVariableNode)) {
            int len = node.getChildCount();
            for (int i = 0; i < len; ++i) {
                IASNode child = node.getChild(i);
                if (!(child instanceof ChainedVariableNode)) continue;
                this.writeNewline(ASEmitterTokens.SEMICOLON);
                this.writeNewline();
                this.getEmitter().emitField((IVariableNode)child);
            }
        }
        if (node.getNodeID() == ASTNodeID.BindableVariableID) {
            this.getModel().getBindableVars().add(node.getName());
        }
    }
}

