/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.codegen.js.jx;

import org.apache.flex.compiler.asdoc.flexjs.ASDocComment;
import org.apache.flex.compiler.clients.MXMLJSC;
import org.apache.flex.compiler.codegen.ISubEmitter;
import org.apache.flex.compiler.codegen.js.IJSEmitter;
import org.apache.flex.compiler.common.ISourceLocation;
import org.apache.flex.compiler.definitions.IClassDefinition;
import org.apache.flex.compiler.definitions.IFunctionDefinition;
import org.apache.flex.compiler.internal.codegen.as.ASEmitterTokens;
import org.apache.flex.compiler.internal.codegen.js.JSSubEmitter;
import org.apache.flex.compiler.internal.codegen.js.flexjs.JSFlexJSEmitter;
import org.apache.flex.compiler.internal.codegen.js.utils.DocEmitterUtils;
import org.apache.flex.compiler.internal.codegen.js.utils.EmitterUtils;
import org.apache.flex.compiler.tree.ASTNodeID;
import org.apache.flex.compiler.tree.as.IASNode;
import org.apache.flex.compiler.tree.as.IAccessorNode;
import org.apache.flex.compiler.tree.as.IClassNode;
import org.apache.flex.compiler.tree.as.IDefinitionNode;
import org.apache.flex.compiler.tree.as.IExpressionNode;
import org.apache.flex.compiler.tree.as.IFunctionNode;
import org.apache.flex.compiler.tree.as.ITypeNode;
import org.apache.flex.compiler.tree.as.IVariableNode;

public class ClassEmitter
extends JSSubEmitter
implements ISubEmitter<IClassNode> {
    public ClassEmitter(IJSEmitter emitter) {
        super(emitter);
    }

    @Override
    public void emit(IClassNode node) {
        IDefinitionNode[] dnodes;
        IClassDefinition definition;
        IFunctionDefinition ctorDefinition;
        this.getModel().pushClass(node.getDefinition());
        JSFlexJSEmitter fjs = (JSFlexJSEmitter)this.getEmitter();
        this.getEmitter().pushSourceMapName((ISourceLocation)node);
        ASDocComment asDoc = (ASDocComment)node.getASDocComment();
        if (asDoc != null && MXMLJSC.keepASDoc) {
            DocEmitterUtils.loadImportIgnores(fjs, asDoc.commentNoEnd());
        }
        if ((ctorDefinition = (definition = node.getDefinition()).getConstructor()) != null) {
            IFunctionNode ctorNode = (IFunctionNode)ctorDefinition.getNode();
            if (ctorNode != null) {
                this.getEmitter().emitMethod(ctorNode);
                this.write(ASEmitterTokens.SEMICOLON);
            } else {
                String qname = definition.getQualifiedName();
                if (qname != null && !qname.equals("")) {
                    this.write(this.getEmitter().formatQualifiedName(qname));
                    this.write(ASEmitterTokens.SPACE);
                    this.writeToken(ASEmitterTokens.EQUAL);
                    this.write(ASEmitterTokens.FUNCTION);
                    this.write(ASEmitterTokens.PAREN_OPEN);
                    this.write(ASEmitterTokens.PAREN_CLOSE);
                    this.write(ASEmitterTokens.SPACE);
                    this.write(ASEmitterTokens.BLOCK_OPEN);
                    this.writeNewline();
                    fjs.emitComplexInitializers(node);
                    this.write(ASEmitterTokens.BLOCK_CLOSE);
                    this.write(ASEmitterTokens.SEMICOLON);
                }
            }
        }
        for (IDefinitionNode dnode : dnodes = node.getAllMemberNodes()) {
            if (dnode.getNodeID() == ASTNodeID.VariableID) {
                this.writeNewline();
                this.writeNewline();
                this.writeNewline();
                this.getEmitter().emitField((IVariableNode)dnode);
                this.startMapping((ISourceLocation)dnode, (ISourceLocation)dnode);
                this.write(ASEmitterTokens.SEMICOLON);
                this.endMapping((ISourceLocation)dnode);
                continue;
            }
            if (dnode.getNodeID() == ASTNodeID.FunctionID) {
                if (((IFunctionNode)dnode).isConstructor()) continue;
                this.writeNewline();
                this.writeNewline();
                this.writeNewline();
                this.getEmitter().emitMethod((IFunctionNode)dnode);
                this.write(ASEmitterTokens.SEMICOLON);
                continue;
            }
            if (dnode.getNodeID() == ASTNodeID.GetterID || dnode.getNodeID() == ASTNodeID.SetterID) {
                fjs.emitAccessors((IAccessorNode)dnode);
                continue;
            }
            if (dnode.getNodeID() != ASTNodeID.BindableVariableID) continue;
            this.writeNewline();
            this.writeNewline();
            this.writeNewline();
            this.getEmitter().emitField((IVariableNode)dnode);
            this.startMapping((ISourceLocation)dnode, (ISourceLocation)dnode);
            this.write(ASEmitterTokens.SEMICOLON);
            this.endMapping((ISourceLocation)dnode);
        }
        fjs.getBindableEmitter().emit(definition);
        fjs.getAccessorEmitter().emit(definition);
        fjs.getPackageFooterEmitter().emitClassInfo((ITypeNode)node);
        this.getEmitter().popSourceMapName();
        this.getModel().popClass();
    }

    public void emitComplexInitializers(IClassNode node) {
        IDefinitionNode[] dnodes;
        boolean wroteOne = false;
        for (IDefinitionNode dnode : dnodes = node.getAllMemberNodes()) {
            IVariableNode varnode;
            IExpressionNode vnode;
            if (dnode.getNodeID() != ASTNodeID.VariableID || (vnode = (varnode = (IVariableNode)dnode).getAssignedValueNode()) == null || dnode.getDefinition().isStatic() || EmitterUtils.isScalar(vnode)) continue;
            this.writeNewline();
            this.write(ASEmitterTokens.THIS);
            this.write(ASEmitterTokens.MEMBER_ACCESS);
            this.write(dnode.getName());
            this.write(ASEmitterTokens.SPACE);
            this.writeToken(ASEmitterTokens.EQUAL);
            this.getEmitter().getWalker().walk((IASNode)vnode);
            this.write(ASEmitterTokens.SEMICOLON);
            wroteOne = true;
        }
        if (wroteOne) {
            this.writeNewline();
        }
    }
}

