/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.codegen.js.jx;

import org.apache.flex.compiler.codegen.ISubEmitter;
import org.apache.flex.compiler.codegen.js.IJSEmitter;
import org.apache.flex.compiler.definitions.IClassDefinition;
import org.apache.flex.compiler.internal.codegen.as.ASEmitterTokens;
import org.apache.flex.compiler.internal.codegen.js.JSEmitterTokens;
import org.apache.flex.compiler.internal.codegen.js.JSSubEmitter;
import org.apache.flex.compiler.internal.codegen.js.flexjs.JSFlexJSEmitter;
import org.apache.flex.compiler.internal.codegen.js.goog.JSGoogEmitterTokens;

public class BindableEmitter
extends JSSubEmitter
implements ISubEmitter<IClassDefinition> {
    public BindableEmitter(IJSEmitter emitter) {
        super(emitter);
    }

    @Override
    public void emit(IClassDefinition definition) {
        if (this.getModel().hasBindableVars()) {
            this.write(JSGoogEmitterTokens.OBJECT);
            this.write(ASEmitterTokens.MEMBER_ACCESS);
            this.write(JSEmitterTokens.DEFINE_PROPERTIES);
            this.write(ASEmitterTokens.PAREN_OPEN);
            String qname = definition.getQualifiedName();
            this.write(this.getEmitter().formatQualifiedName(qname));
            this.write(ASEmitterTokens.MEMBER_ACCESS);
            this.write(JSEmitterTokens.PROTOTYPE);
            this.write(ASEmitterTokens.COMMA);
            this.write(ASEmitterTokens.SPACE);
            this.write("/** @lends {" + this.getEmitter().formatQualifiedName(qname) + ".prototype} */ ");
            this.writeNewline(ASEmitterTokens.BLOCK_OPEN);
            boolean firstTime = true;
            for (String varName : this.getModel().getBindableVars()) {
                if (firstTime) {
                    firstTime = false;
                } else {
                    this.write(ASEmitterTokens.COMMA);
                }
                this.emitBindableVarDefineProperty(varName, definition);
            }
            this.writeNewline(ASEmitterTokens.BLOCK_CLOSE);
            this.write(ASEmitterTokens.PAREN_CLOSE);
            this.write(ASEmitterTokens.SEMICOLON);
        }
    }

    private void emitBindableVarDefineProperty(String name, IClassDefinition cdef) {
        JSFlexJSEmitter fjs = (JSFlexJSEmitter)this.getEmitter();
        this.writeNewline("/** @export */");
        this.writeNewline(name + ASEmitterTokens.COLON.getToken() + ASEmitterTokens.SPACE.getToken() + ASEmitterTokens.BLOCK_OPEN.getToken());
        this.indentPush();
        this.writeNewline("/** @this {" + fjs.formatQualifiedName(cdef.getQualifiedName()) + "} */");
        this.writeNewline(ASEmitterTokens.GET.getToken() + ASEmitterTokens.COLON.getToken() + ASEmitterTokens.SPACE.getToken() + ASEmitterTokens.FUNCTION.getToken() + ASEmitterTokens.PAREN_OPEN.getToken() + ASEmitterTokens.PAREN_CLOSE.getToken() + ASEmitterTokens.SPACE.getToken() + ASEmitterTokens.BLOCK_OPEN.getToken());
        this.writeNewline(ASEmitterTokens.RETURN.getToken() + ASEmitterTokens.SPACE.getToken() + ASEmitterTokens.THIS.getToken() + ASEmitterTokens.MEMBER_ACCESS.getToken() + name + "_" + ASEmitterTokens.SEMICOLON.getToken());
        this.indentPop();
        this.writeNewline(ASEmitterTokens.BLOCK_CLOSE.getToken() + ASEmitterTokens.COMMA.getToken());
        this.writeNewline();
        this.writeNewline("/** @this {" + fjs.formatQualifiedName(cdef.getQualifiedName()) + "} */");
        this.writeNewline(ASEmitterTokens.SET.getToken() + ASEmitterTokens.COLON.getToken() + ASEmitterTokens.SPACE.getToken() + ASEmitterTokens.FUNCTION.getToken() + ASEmitterTokens.PAREN_OPEN.getToken() + "value" + ASEmitterTokens.PAREN_CLOSE.getToken() + ASEmitterTokens.SPACE.getToken() + ASEmitterTokens.BLOCK_OPEN.getToken());
        this.writeNewline("if (value != " + ASEmitterTokens.THIS.getToken() + ASEmitterTokens.MEMBER_ACCESS.getToken() + name + "_) {");
        this.writeNewline("    var oldValue = " + ASEmitterTokens.THIS.getToken() + ASEmitterTokens.MEMBER_ACCESS.getToken() + name + "_" + ASEmitterTokens.SEMICOLON.getToken());
        this.writeNewline("    " + ASEmitterTokens.THIS.getToken() + ASEmitterTokens.MEMBER_ACCESS.getToken() + name + "_ = value;");
        this.writeNewline("    this.dispatchEvent(org.apache.flex.events.ValueChangeEvent.createUpdateEvent(");
        this.writeNewline("         this, \"" + name + "\", oldValue, value));");
        this.writeNewline("}");
        this.write(ASEmitterTokens.BLOCK_CLOSE.getToken());
        this.write(ASEmitterTokens.BLOCK_CLOSE.getToken());
    }
}

