/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.codegen.js.jx;

import org.apache.flex.compiler.codegen.ISubEmitter;
import org.apache.flex.compiler.codegen.js.IJSEmitter;
import org.apache.flex.compiler.common.ISourceLocation;
import org.apache.flex.compiler.definitions.IDefinition;
import org.apache.flex.compiler.definitions.ITypeDefinition;
import org.apache.flex.compiler.internal.codegen.as.ASEmitterTokens;
import org.apache.flex.compiler.internal.codegen.js.JSSubEmitter;
import org.apache.flex.compiler.internal.codegen.js.flexjs.JSFlexJSDocEmitter;
import org.apache.flex.compiler.internal.codegen.js.flexjs.JSFlexJSEmitter;
import org.apache.flex.compiler.internal.codegen.js.flexjs.JSFlexJSEmitterTokens;
import org.apache.flex.compiler.internal.definitions.AccessorDefinition;
import org.apache.flex.compiler.internal.projects.FlexJSProject;
import org.apache.flex.compiler.internal.tree.as.ExpressionNodeBase;
import org.apache.flex.compiler.internal.tree.as.FunctionCallNode;
import org.apache.flex.compiler.internal.tree.as.IdentifierNode;
import org.apache.flex.compiler.internal.tree.as.MemberAccessExpressionNode;
import org.apache.flex.compiler.internal.tree.as.UnaryOperatorAtNode;
import org.apache.flex.compiler.projects.ICompilerProject;
import org.apache.flex.compiler.tree.ASTNodeID;
import org.apache.flex.compiler.tree.as.IASNode;
import org.apache.flex.compiler.tree.as.IBinaryOperatorNode;
import org.apache.flex.compiler.tree.as.IClassNode;
import org.apache.flex.compiler.tree.as.IExpressionNode;
import org.apache.flex.compiler.tree.as.IIdentifierNode;
import org.apache.flex.compiler.tree.as.IOperatorNode;
import org.apache.flex.compiler.utils.ASNodeUtils;

public class BinaryOperatorEmitter
extends JSSubEmitter
implements ISubEmitter<IBinaryOperatorNode> {
    public BinaryOperatorEmitter(IJSEmitter emitter) {
        super(emitter);
    }

    @Override
    public void emit(IBinaryOperatorNode node) {
        JSFlexJSEmitter fjs = (JSFlexJSEmitter)this.getEmitter();
        String op = node.getOperator().getOperatorText();
        boolean isAssignment = op.contains("=") && !op.contains("==") && !op.startsWith("<") && !op.startsWith(">") && !op.startsWith("!");
        ASTNodeID id = node.getNodeID();
        if (id == ASTNodeID.Op_IsID || id == ASTNodeID.Op_AsID) {
            fjs.emitIsAs((IExpressionNode)node, node.getLeftOperandNode(), node.getRightOperandNode(), id, false);
        } else if (id == ASTNodeID.Op_InstanceOfID) {
            this.getWalker().walk((IASNode)node.getLeftOperandNode());
            this.startMapping((ISourceLocation)node, (ISourceLocation)node.getLeftOperandNode());
            this.write(ASEmitterTokens.SPACE);
            this.writeToken(ASEmitterTokens.INSTANCEOF);
            this.endMapping((ISourceLocation)node);
            IDefinition dnode = node.getRightOperandNode().resolve(this.getProject());
            if (dnode != null) {
                this.write(this.getEmitter().formatQualifiedName(dnode.getQualifiedName()));
            } else {
                this.getWalker().walk((IASNode)node.getRightOperandNode());
            }
        } else {
            String coercion;
            ExpressionNodeBase fnNameNode;
            boolean rightIsNumber;
            IExpressionNode leftSide = node.getLeftOperandNode();
            ITypeDefinition leftDef = leftSide.resolveType(this.getWalker().getProject());
            if (leftSide.getNodeID() == ASTNodeID.MemberAccessExpressionID) {
                IDefinition rnodeDef;
                IASNode lnode = leftSide.getChild(0);
                IASNode rnode = leftSide.getChild(1);
                IDefinition iDefinition = rnodeDef = rnode instanceof IIdentifierNode ? ((IIdentifierNode)rnode).resolve(this.getWalker().getProject()) : null;
                if (lnode.getNodeID() == ASTNodeID.SuperID && rnodeDef instanceof AccessorDefinition) {
                    if (isAssignment) {
                        ICompilerProject project = this.getProject();
                        if (project instanceof FlexJSProject) {
                            ((FlexJSProject)project).needLanguage = true;
                        }
                        this.write(JSFlexJSEmitterTokens.LANGUAGE_QNAME);
                        this.write(ASEmitterTokens.MEMBER_ACCESS);
                        this.write(JSFlexJSEmitterTokens.SUPERSETTER);
                        this.write(ASEmitterTokens.PAREN_OPEN);
                        IClassNode cnode = (IClassNode)node.getAncestorOfType(IClassNode.class);
                        if (cnode != null) {
                            this.write(this.getEmitter().formatQualifiedName(cnode.getQualifiedName()));
                        } else {
                            this.write(this.getEmitter().formatQualifiedName(this.getModel().getCurrentClass().getQualifiedName()));
                        }
                        this.writeToken(ASEmitterTokens.COMMA);
                        this.write(ASEmitterTokens.THIS);
                        this.writeToken(ASEmitterTokens.COMMA);
                        this.write(ASEmitterTokens.SINGLE_QUOTE);
                        this.write(rnodeDef.getBaseName());
                        this.write(ASEmitterTokens.SINGLE_QUOTE);
                        this.writeToken(ASEmitterTokens.COMMA);
                        if (op.length() > 1) {
                            this.write(JSFlexJSEmitterTokens.LANGUAGE_QNAME);
                            this.write(ASEmitterTokens.MEMBER_ACCESS);
                            this.write(JSFlexJSEmitterTokens.SUPERSETTER);
                            this.write(ASEmitterTokens.PAREN_OPEN);
                            this.write(this.getEmitter().formatQualifiedName(cnode.getQualifiedName()));
                            this.writeToken(ASEmitterTokens.COMMA);
                            this.write(ASEmitterTokens.THIS);
                            this.writeToken(ASEmitterTokens.COMMA);
                            this.write(ASEmitterTokens.SINGLE_QUOTE);
                            this.write(rnodeDef.getBaseName());
                            this.write(ASEmitterTokens.SINGLE_QUOTE);
                            this.write(ASEmitterTokens.PAREN_CLOSE);
                            this.write(op.substring(0, 1));
                        }
                        this.getWalker().walk((IASNode)node.getRightOperandNode());
                        this.write(ASEmitterTokens.PAREN_CLOSE);
                        return;
                    }
                } else if (((JSFlexJSEmitter)this.getEmitter()).isXMLList((MemberAccessExpressionNode)leftSide)) {
                    MemberAccessExpressionNode xmlNode = (MemberAccessExpressionNode)leftSide;
                    if (node.getNodeID() == ASTNodeID.Op_AssignId) {
                        this.getWalker().walk((IASNode)xmlNode.getLeftOperandNode());
                        IExpressionNode rightSide = xmlNode.getRightOperandNode();
                        if (rightSide instanceof UnaryOperatorAtNode) {
                            this.write(".setAttribute('");
                            this.getWalker().walk(((UnaryOperatorAtNode)rightSide).getChild(0));
                        } else {
                            this.write(".setChild('");
                            this.getWalker().walk((IASNode)rightSide);
                        }
                        this.write("', ");
                        this.getWalker().walk((IASNode)node.getRightOperandNode());
                        this.write(ASEmitterTokens.PAREN_CLOSE);
                        return;
                    }
                    if (node.getNodeID() == ASTNodeID.Op_AddAssignID) {
                        this.getWalker().walk((IASNode)xmlNode.getLeftOperandNode());
                        IExpressionNode rightSide = xmlNode.getRightOperandNode();
                        if (rightSide instanceof UnaryOperatorAtNode) {
                            this.write(".setAttribute('");
                            this.getWalker().walk(((UnaryOperatorAtNode)rightSide).getChild(0));
                        } else {
                            this.write(".setChild('");
                            this.getWalker().walk((IASNode)rightSide);
                        }
                        this.write("', ");
                        this.getWalker().walk((IASNode)node.getLeftOperandNode());
                        this.write(".plus(");
                        this.getWalker().walk((IASNode)node.getRightOperandNode());
                        this.write(ASEmitterTokens.PAREN_CLOSE);
                        this.write(ASEmitterTokens.PAREN_CLOSE);
                        return;
                    }
                    if (node.getNodeID() == ASTNodeID.Op_AddID) {
                        this.getWalker().walk((IASNode)xmlNode);
                        this.write(".plus(");
                        this.getWalker().walk((IASNode)node.getRightOperandNode());
                        this.write(ASEmitterTokens.PAREN_CLOSE);
                        return;
                    }
                } else if (((JSFlexJSEmitter)this.getEmitter()).isProxy((IExpressionNode)((MemberAccessExpressionNode)leftSide))) {
                    MemberAccessExpressionNode proxyNode = (MemberAccessExpressionNode)leftSide;
                    if (node.getNodeID() == ASTNodeID.Op_AssignId) {
                        this.getWalker().walk((IASNode)proxyNode.getLeftOperandNode());
                        IExpressionNode rightSide = proxyNode.getRightOperandNode();
                        this.write(".setProperty('");
                        this.getWalker().walk((IASNode)rightSide);
                        this.write("', ");
                        this.getWalker().walk((IASNode)node.getRightOperandNode());
                        this.write(ASEmitterTokens.PAREN_CLOSE);
                        return;
                    }
                    if (node.getNodeID() == ASTNodeID.Op_AddAssignID) {
                        IExpressionNode rightSide = proxyNode.getRightOperandNode();
                        this.getWalker().walk((IASNode)proxyNode.getLeftOperandNode());
                        this.write(".setProperty('");
                        this.getWalker().walk((IASNode)rightSide);
                        this.write("', ");
                        this.getWalker().walk((IASNode)proxyNode.getLeftOperandNode());
                        this.write(".getProperty(");
                        this.write(ASEmitterTokens.SINGLE_QUOTE);
                        this.getWalker().walk((IASNode)rightSide);
                        this.write(ASEmitterTokens.SINGLE_QUOTE);
                        this.write(ASEmitterTokens.PAREN_CLOSE);
                        this.write(" + ");
                        this.getWalker().walk((IASNode)node.getRightOperandNode());
                        this.write(ASEmitterTokens.PAREN_CLOSE);
                        return;
                    }
                } else if (((JSFlexJSEmitter)this.getEmitter()).isDateProperty((IExpressionNode)((MemberAccessExpressionNode)leftSide))) {
                    this.specialCaseDate(node, (MemberAccessExpressionNode)leftSide);
                    return;
                }
            } else if (leftSide.getNodeID() == ASTNodeID.IdentifierID && leftDef != null && IdentifierNode.isXMLish((IDefinition)leftDef, (ICompilerProject)this.getWalker().getProject()) && node.getNodeID() == ASTNodeID.Op_AddAssignID) {
                this.getWalker().walk((IASNode)leftSide);
                this.write(" = ");
                this.getWalker().walk((IASNode)leftSide);
                this.write(".plus(");
                this.getWalker().walk((IASNode)node.getRightOperandNode());
                this.write(ASEmitterTokens.PAREN_CLOSE);
                return;
            }
            boolean leftIsNumber = leftDef != null && (leftDef.getQualifiedName().equals("Number") || leftDef.getQualifiedName().equals("int") || leftDef.getQualifiedName().equals("uint"));
            IExpressionNode rNode = node.getRightOperandNode();
            ITypeDefinition rightDef = rNode.resolveType(this.getWalker().getProject());
            boolean bl = rightIsNumber = rightDef != null && (rightDef.getQualifiedName().equals("Number") || rightDef.getQualifiedName().equals("int") || rightDef.getQualifiedName().equals("uint"));
            if (leftIsNumber && !rightIsNumber && (rightDef == null || rightDef.getQualifiedName().equals("*")) && rNode.getNodeID() == ASTNodeID.FunctionCallID && (fnNameNode = ((FunctionCallNode)rNode).getNameNode()).getNodeID() == ASTNodeID.MemberAccessExpressionID) {
                MemberAccessExpressionNode mae = (MemberAccessExpressionNode)fnNameNode;
                IExpressionNode rightNode = mae.getRightOperandNode();
                rightIsNumber = rightNode.getNodeID() == ASTNodeID.IdentifierID && ((IdentifierNode)rightNode).getName().equals("length") && fjs.isXMLList(mae);
            }
            String string = coercion = leftIsNumber && !rightIsNumber && isAssignment ? "Number(" : "";
            if (!(!isAssignment || leftDef == null || !leftDef.getQualifiedName().equals("String") || rNode.getNodeID() == ASTNodeID.LiteralStringID || rNode.getNodeID() == ASTNodeID.LiteralNullID || rightDef != null && (rightDef.getQualifiedName().equals("String") || rightDef.getQualifiedName().equals("*") && rNode.getNodeID() == ASTNodeID.FunctionCallID && this.isToString((IASNode)rNode) || !isAssignment && rightIsNumber || rightDef.getQualifiedName().equals("Null")))) {
                JSFlexJSDocEmitter docEmitter = (JSFlexJSDocEmitter)this.getEmitter().getDocEmitter();
                if (docEmitter.emitStringConversions) {
                    coercion = "org.apache.flex.utils.Language.string(";
                }
            }
            this.super_emitBinaryOperator(node, coercion);
            if (coercion.length() > 0) {
                this.write(")");
            }
        }
    }

    private boolean isToString(IASNode rNode) {
        ExpressionNodeBase fnNameNode = ((FunctionCallNode)rNode).getNameNode();
        if (fnNameNode.getNodeID() == ASTNodeID.MemberAccessExpressionID) {
            MemberAccessExpressionNode mae = (MemberAccessExpressionNode)fnNameNode;
            IExpressionNode rightNode = mae.getRightOperandNode();
            return rightNode.getNodeID() == ASTNodeID.IdentifierID && ((IdentifierNode)rightNode).getName().equals("toString");
        }
        return false;
    }

    private void super_emitBinaryOperator(IBinaryOperatorNode node, String coercion) {
        ASTNodeID id;
        if (ASNodeUtils.hasParenOpen((IOperatorNode)node)) {
            this.write(ASEmitterTokens.PAREN_OPEN);
        }
        if ((id = node.getNodeID()) == ASTNodeID.Op_IsID) {
            this.write(ASEmitterTokens.IS);
            this.write(ASEmitterTokens.PAREN_OPEN);
            this.getWalker().walk((IASNode)node.getLeftOperandNode());
            this.writeToken(ASEmitterTokens.COMMA);
            this.getWalker().walk((IASNode)node.getRightOperandNode());
            this.write(ASEmitterTokens.PAREN_CLOSE);
        } else if (id == ASTNodeID.Op_AsID) {
            this.write(ASEmitterTokens.PAREN_OPEN);
            this.write(ASEmitterTokens.IS);
            this.write(ASEmitterTokens.PAREN_OPEN);
            this.getWalker().walk((IASNode)node.getLeftOperandNode());
            this.writeToken(ASEmitterTokens.COMMA);
            this.getWalker().walk((IASNode)node.getRightOperandNode());
            this.writeToken(ASEmitterTokens.PAREN_CLOSE);
            this.writeToken(ASEmitterTokens.TERNARY);
            this.getWalker().walk((IASNode)node.getLeftOperandNode());
            this.write(ASEmitterTokens.SPACE);
            this.writeToken(ASEmitterTokens.COLON);
            this.write(ASEmitterTokens.NULL);
            this.write(ASEmitterTokens.PAREN_CLOSE);
        } else {
            this.getWalker().walk((IASNode)node.getLeftOperandNode());
            this.startMapping((ISourceLocation)node, (ISourceLocation)node.getLeftOperandNode());
            if (id != ASTNodeID.Op_CommaID) {
                this.write(ASEmitterTokens.SPACE);
            }
            if (id == ASTNodeID.Op_LogicalAndAssignID || id == ASTNodeID.Op_LogicalOrAssignID) {
                IIdentifierNode lnode = (IIdentifierNode)node.getLeftOperandNode();
                this.writeToken(ASEmitterTokens.EQUAL);
                this.endMapping((ISourceLocation)node);
                this.startMapping((ISourceLocation)node);
                this.write(lnode.getName());
                this.endMapping((ISourceLocation)node);
                this.startMapping((ISourceLocation)node, (ISourceLocation)node.getLeftOperandNode());
                this.write(ASEmitterTokens.SPACE);
                this.write(id == ASTNodeID.Op_LogicalAndAssignID ? ASEmitterTokens.LOGICAL_AND : ASEmitterTokens.LOGICAL_OR);
            } else {
                this.write(node.getOperator().getOperatorText());
            }
            this.write(ASEmitterTokens.SPACE);
            this.endMapping((ISourceLocation)node);
            this.write(coercion);
            this.getWalker().walk((IASNode)node.getRightOperandNode());
            if (node.getNodeID() == ASTNodeID.Op_InID && ((JSFlexJSEmitter)this.getEmitter()).isXML(node.getRightOperandNode())) {
                this.write(".elementNames()");
            } else if (node.getNodeID() == ASTNodeID.Op_InID && ((JSFlexJSEmitter)this.getEmitter()).isProxy(node.getRightOperandNode())) {
                this.write(".propertyNames()");
            }
        }
        if (ASNodeUtils.hasParenOpen((IOperatorNode)node)) {
            this.write(ASEmitterTokens.PAREN_CLOSE);
        }
    }

    void specialCaseDate(IBinaryOperatorNode node, MemberAccessExpressionNode leftSide) {
        MemberAccessExpressionNode dateNode = leftSide;
        IIdentifierNode rightSide = (IIdentifierNode)dateNode.getRightOperandNode();
        this.getWalker().walk((IASNode)dateNode.getLeftOperandNode());
        String rightName = rightSide.getName();
        DateProperties prop = DateProperties.valueOf(rightName.toUpperCase());
        this.write(ASEmitterTokens.MEMBER_ACCESS);
        this.write(prop.getFunctionName());
        this.write(ASEmitterTokens.PAREN_OPEN);
        this.getWalker().walk((IASNode)node.getRightOperandNode());
        switch (prop) {
            case FULLYEAR: {
                this.write(ASEmitterTokens.COMMA);
                this.write(ASEmitterTokens.SPACE);
                this.getWalker().walk((IASNode)dateNode.getLeftOperandNode());
                this.write(ASEmitterTokens.MEMBER_ACCESS);
                this.write("getMonth()");
            }
            case MONTH: {
                this.write(ASEmitterTokens.COMMA);
                this.write(ASEmitterTokens.SPACE);
                this.getWalker().walk((IASNode)dateNode.getLeftOperandNode());
                this.write(ASEmitterTokens.MEMBER_ACCESS);
                this.write("getDate()");
                break;
            }
            case FULLYEARUTC: {
                this.write(ASEmitterTokens.COMMA);
                this.write(ASEmitterTokens.SPACE);
                this.getWalker().walk((IASNode)dateNode.getLeftOperandNode());
                this.write(ASEmitterTokens.MEMBER_ACCESS);
                this.write("getMonthUTC()");
            }
            case MONTHUTC: {
                this.write(ASEmitterTokens.COMMA);
                this.write(ASEmitterTokens.SPACE);
                this.getWalker().walk((IASNode)dateNode.getLeftOperandNode());
                this.write(ASEmitterTokens.MEMBER_ACCESS);
                this.write("getDateUTC()");
                break;
            }
            case HOURS: {
                this.write(ASEmitterTokens.COMMA);
                this.write(ASEmitterTokens.SPACE);
                this.getWalker().walk((IASNode)dateNode.getLeftOperandNode());
                this.write(ASEmitterTokens.MEMBER_ACCESS);
                this.write("getMinutes()");
            }
            case MINUTES: {
                this.write(ASEmitterTokens.COMMA);
                this.write(ASEmitterTokens.SPACE);
                this.getWalker().walk((IASNode)dateNode.getLeftOperandNode());
                this.write(ASEmitterTokens.MEMBER_ACCESS);
                this.write("getSeconds()");
            }
            case SECONDS: {
                this.write(ASEmitterTokens.COMMA);
                this.write(ASEmitterTokens.SPACE);
                this.getWalker().walk((IASNode)dateNode.getLeftOperandNode());
                this.write(ASEmitterTokens.MEMBER_ACCESS);
                this.write("getMilliseconds()");
                break;
            }
            case HOURSUTC: {
                this.write(ASEmitterTokens.COMMA);
                this.write(ASEmitterTokens.SPACE);
                this.getWalker().walk((IASNode)dateNode.getLeftOperandNode());
                this.write(ASEmitterTokens.MEMBER_ACCESS);
                this.write("getUTCMinutes()");
            }
            case MINUTESUTC: {
                this.write(ASEmitterTokens.COMMA);
                this.write(ASEmitterTokens.SPACE);
                this.getWalker().walk((IASNode)dateNode.getLeftOperandNode());
                this.write(ASEmitterTokens.MEMBER_ACCESS);
                this.write("getUTCSeconds()");
            }
            case SECONDSUTC: {
                this.write(ASEmitterTokens.COMMA);
                this.write(ASEmitterTokens.SPACE);
                this.getWalker().walk((IASNode)dateNode.getLeftOperandNode());
                this.write(ASEmitterTokens.MEMBER_ACCESS);
                this.write("getUTCMilliseconds()");
            }
        }
        this.write(ASEmitterTokens.PAREN_CLOSE);
    }

    private static enum DateProperties {
        FULLYEAR("fullYear", "setFullYear"),
        MONTH("month", "setMonth"),
        DATE("date", "setDate"),
        FULLYEARUTC("fullYearUTC", "setUTCFullYear"),
        MONTHUTC("monthUTC", "setUTCMonth"),
        DATEUTC("dateUTC", "setUTCDate"),
        HOURS("hours", "setHours"),
        MINUTES("minutes", "setMinutes"),
        SECONDS("seconds", "setSeconds"),
        MILLISECONDS("milliseconds", "setMilliseconds"),
        HOURSUTC("hoursUTC", "setUTCHours"),
        MINUTESUTC("minutesUTC", "setUTCMinutes"),
        SECONDSUTC("secondsUTC", "setUTCSeconds"),
        MILLISECONDSUTC("millisecondsUTC", "setUTCMilliseconds");

        private String value;
        private String functionName;

        private DateProperties(String value, String functionName) {
            this.value = value;
            this.functionName = functionName;
        }

        public String getFunctionName() {
            return this.functionName;
        }
    }
}

