/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.codegen.js.jx;

import java.util.HashMap;
import java.util.Set;
import org.apache.flex.compiler.codegen.ISubEmitter;
import org.apache.flex.compiler.codegen.js.IJSEmitter;
import org.apache.flex.compiler.common.ASModifier;
import org.apache.flex.compiler.common.IMetaInfo;
import org.apache.flex.compiler.common.ISourceLocation;
import org.apache.flex.compiler.common.ModifiersSet;
import org.apache.flex.compiler.definitions.IAccessorDefinition;
import org.apache.flex.compiler.definitions.IClassDefinition;
import org.apache.flex.compiler.definitions.IDefinition;
import org.apache.flex.compiler.definitions.IFunctionDefinition;
import org.apache.flex.compiler.definitions.ITypeDefinition;
import org.apache.flex.compiler.internal.codegen.as.ASEmitterTokens;
import org.apache.flex.compiler.internal.codegen.js.JSDocEmitterTokens;
import org.apache.flex.compiler.internal.codegen.js.JSEmitterTokens;
import org.apache.flex.compiler.internal.codegen.js.JSSessionModel;
import org.apache.flex.compiler.internal.codegen.js.JSSubEmitter;
import org.apache.flex.compiler.internal.codegen.js.flexjs.JSFlexJSDocEmitter;
import org.apache.flex.compiler.internal.codegen.js.flexjs.JSFlexJSEmitter;
import org.apache.flex.compiler.internal.codegen.js.flexjs.JSFlexJSEmitterTokens;
import org.apache.flex.compiler.internal.codegen.js.goog.JSGoogEmitterTokens;
import org.apache.flex.compiler.internal.projects.FlexJSProject;
import org.apache.flex.compiler.internal.semantics.SemanticUtils;
import org.apache.flex.compiler.internal.tree.as.FunctionNode;
import org.apache.flex.compiler.internal.tree.as.SetterNode;
import org.apache.flex.compiler.projects.ICompilerProject;
import org.apache.flex.compiler.tree.ASTNodeID;
import org.apache.flex.compiler.tree.as.IAccessorNode;
import org.apache.flex.compiler.tree.as.IFunctionNode;
import org.apache.flex.compiler.tree.as.IGetterNode;
import org.apache.flex.compiler.tree.as.ISetterNode;

public class AccessorEmitter
extends JSSubEmitter
implements ISubEmitter<IAccessorNode> {
    public AccessorEmitter(IJSEmitter emitter) {
        super(emitter);
    }

    @Override
    public void emit(IAccessorNode node) {
        if (node.getNodeID() == ASTNodeID.GetterID) {
            this.emitGet((IGetterNode)node);
        } else if (node.getNodeID() == ASTNodeID.SetterID) {
            this.emitSet((ISetterNode)node);
        }
    }

    @Override
    public void emit(IClassDefinition definition) {
        boolean firstTime;
        Set<String> propertyNames;
        String qname;
        JSFlexJSEmitter fjs = (JSFlexJSEmitter)this.getEmitter();
        if (!this.getModel().getPropertyMap().isEmpty()) {
            this.writeNewline();
            this.writeNewline();
            this.writeNewline();
            this.write(JSGoogEmitterTokens.OBJECT);
            this.write(ASEmitterTokens.MEMBER_ACCESS);
            this.write(JSEmitterTokens.DEFINE_PROPERTIES);
            this.write(ASEmitterTokens.PAREN_OPEN);
            qname = definition.getQualifiedName();
            this.write(this.getEmitter().formatQualifiedName(qname));
            this.write(ASEmitterTokens.MEMBER_ACCESS);
            this.write(JSEmitterTokens.PROTOTYPE);
            this.write(ASEmitterTokens.COMMA);
            this.write(ASEmitterTokens.SPACE);
            this.write("/** @lends {" + this.getEmitter().formatQualifiedName(qname) + ".prototype} */ ");
            this.writeNewline(ASEmitterTokens.BLOCK_OPEN);
            propertyNames = this.getModel().getPropertyMap().keySet();
            firstTime = true;
            for (String propName : propertyNames) {
                ICompilerProject project;
                IAccessorDefinition other;
                if (firstTime) {
                    firstTime = false;
                } else {
                    this.writeNewline(ASEmitterTokens.COMMA);
                }
                boolean wroteGetter = false;
                JSSessionModel.PropertyNodes p = this.getModel().getPropertyMap().get(propName);
                IGetterNode getterNode = p.getter;
                ISetterNode setterNode = p.setter;
                this.writeNewline("/** @export */");
                if (getterNode != null) {
                    this.startMapping((ISourceLocation)getterNode);
                } else {
                    this.startMapping((ISourceLocation)setterNode);
                }
                this.write(propName);
                this.write(ASEmitterTokens.COLON);
                this.write(ASEmitterTokens.SPACE);
                this.write(ASEmitterTokens.BLOCK_OPEN);
                if (getterNode != null) {
                    this.endMapping((ISourceLocation)getterNode);
                } else {
                    this.endMapping((ISourceLocation)setterNode);
                }
                this.writeNewline();
                if (getterNode != null) {
                    this.startMapping((ISourceLocation)getterNode);
                    this.write(ASEmitterTokens.GET);
                    this.write(ASEmitterTokens.COLON);
                    this.write(ASEmitterTokens.SPACE);
                    this.write(JSDocEmitterTokens.JSDOC_OPEN);
                    this.write(ASEmitterTokens.SPACE);
                    this.write(ASEmitterTokens.ATSIGN);
                    this.write(ASEmitterTokens.THIS);
                    this.write(ASEmitterTokens.SPACE);
                    this.write(ASEmitterTokens.BLOCK_OPEN);
                    this.write(this.getEmitter().formatQualifiedName(qname));
                    this.write(ASEmitterTokens.BLOCK_CLOSE);
                    this.write(ASEmitterTokens.SPACE);
                    this.write(JSDocEmitterTokens.JSDOC_CLOSE);
                    this.write(ASEmitterTokens.SPACE);
                    this.write(ASEmitterTokens.FUNCTION);
                    this.endMapping((ISourceLocation)getterNode);
                    fjs.emitParameters(getterNode.getParametersContainerNode());
                    fjs.emitDefinePropertyFunction((IAccessorNode)getterNode);
                    wroteGetter = true;
                } else if (setterNode != null && setterNode.getDefinition().isOverride() && (other = (IAccessorDefinition)SemanticUtils.resolveCorrespondingAccessor((IDefinition)p.setter.getDefinition(), (ICompilerProject)this.getProject())) != null) {
                    this.write(ASEmitterTokens.GET);
                    this.write(ASEmitterTokens.COLON);
                    this.write(ASEmitterTokens.SPACE);
                    this.write(JSDocEmitterTokens.JSDOC_OPEN);
                    this.write(ASEmitterTokens.SPACE);
                    this.write(ASEmitterTokens.ATSIGN);
                    this.write(ASEmitterTokens.THIS);
                    this.write(ASEmitterTokens.SPACE);
                    this.write(ASEmitterTokens.BLOCK_OPEN);
                    this.write(this.getEmitter().formatQualifiedName(qname));
                    this.write(ASEmitterTokens.BLOCK_CLOSE);
                    this.write(ASEmitterTokens.SPACE);
                    this.write(JSDocEmitterTokens.JSDOC_CLOSE);
                    this.write(ASEmitterTokens.SPACE);
                    this.write(ASEmitterTokens.FUNCTION);
                    this.write(ASEmitterTokens.PAREN_OPEN);
                    this.write(ASEmitterTokens.PAREN_CLOSE);
                    this.write(ASEmitterTokens.SPACE);
                    this.writeNewline(ASEmitterTokens.BLOCK_OPEN);
                    project = this.getProject();
                    if (project instanceof FlexJSProject) {
                        ((FlexJSProject)project).needLanguage = true;
                    }
                    this.write(ASEmitterTokens.RETURN);
                    this.write(ASEmitterTokens.SPACE);
                    this.write(JSFlexJSEmitterTokens.LANGUAGE_QNAME);
                    this.write(ASEmitterTokens.MEMBER_ACCESS);
                    this.write(JSFlexJSEmitterTokens.SUPERGETTER);
                    this.write(ASEmitterTokens.PAREN_OPEN);
                    this.write(this.getEmitter().formatQualifiedName(qname));
                    this.writeToken(ASEmitterTokens.COMMA);
                    this.write(ASEmitterTokens.THIS);
                    this.writeToken(ASEmitterTokens.COMMA);
                    this.write(ASEmitterTokens.SINGLE_QUOTE);
                    this.write(propName);
                    this.write(ASEmitterTokens.SINGLE_QUOTE);
                    this.write(ASEmitterTokens.PAREN_CLOSE);
                    this.writeNewline(ASEmitterTokens.SEMICOLON);
                    this.write(ASEmitterTokens.BLOCK_CLOSE);
                    wroteGetter = true;
                }
                if (setterNode != null) {
                    if (wroteGetter) {
                        this.writeNewline(ASEmitterTokens.COMMA);
                    }
                    this.startMapping((ISourceLocation)setterNode);
                    this.write(ASEmitterTokens.SET);
                    this.write(ASEmitterTokens.COLON);
                    this.write(ASEmitterTokens.SPACE);
                    this.write(JSDocEmitterTokens.JSDOC_OPEN);
                    this.write(ASEmitterTokens.SPACE);
                    this.write(ASEmitterTokens.ATSIGN);
                    this.write(ASEmitterTokens.THIS);
                    this.write(ASEmitterTokens.SPACE);
                    this.write(ASEmitterTokens.BLOCK_OPEN);
                    this.write(this.getEmitter().formatQualifiedName(qname));
                    this.write(ASEmitterTokens.BLOCK_CLOSE);
                    this.write(ASEmitterTokens.SPACE);
                    this.write(JSDocEmitterTokens.JSDOC_CLOSE);
                    this.write(ASEmitterTokens.SPACE);
                    this.write(ASEmitterTokens.FUNCTION);
                    this.endMapping((ISourceLocation)setterNode);
                    fjs.emitParameters(setterNode.getParametersContainerNode());
                    fjs.emitDefinePropertyFunction((IAccessorNode)setterNode);
                } else if (getterNode != null && getterNode.getDefinition().isOverride() && (other = (IAccessorDefinition)SemanticUtils.resolveCorrespondingAccessor((IDefinition)p.getter.getDefinition(), (ICompilerProject)this.getProject())) != null) {
                    if (wroteGetter) {
                        this.writeNewline(ASEmitterTokens.COMMA);
                    }
                    this.write(ASEmitterTokens.SET);
                    this.write(ASEmitterTokens.COLON);
                    this.write(ASEmitterTokens.SPACE);
                    this.write(JSDocEmitterTokens.JSDOC_OPEN);
                    this.write(ASEmitterTokens.SPACE);
                    this.write(ASEmitterTokens.ATSIGN);
                    this.write(ASEmitterTokens.THIS);
                    this.write(ASEmitterTokens.SPACE);
                    this.write(ASEmitterTokens.BLOCK_OPEN);
                    this.write(this.getEmitter().formatQualifiedName(qname));
                    this.write(ASEmitterTokens.BLOCK_CLOSE);
                    this.write(ASEmitterTokens.SPACE);
                    this.write(JSDocEmitterTokens.JSDOC_CLOSE);
                    this.write(ASEmitterTokens.SPACE);
                    this.write(ASEmitterTokens.FUNCTION);
                    this.write(ASEmitterTokens.PAREN_OPEN);
                    this.write("value");
                    this.write(ASEmitterTokens.PAREN_CLOSE);
                    this.write(ASEmitterTokens.SPACE);
                    this.writeNewline(ASEmitterTokens.BLOCK_OPEN);
                    project = this.getProject();
                    if (project instanceof FlexJSProject) {
                        ((FlexJSProject)project).needLanguage = true;
                    }
                    this.write(JSFlexJSEmitterTokens.LANGUAGE_QNAME);
                    this.write(ASEmitterTokens.MEMBER_ACCESS);
                    this.write(JSFlexJSEmitterTokens.SUPERSETTER);
                    this.write(ASEmitterTokens.PAREN_OPEN);
                    this.write(this.getEmitter().formatQualifiedName(qname));
                    this.writeToken(ASEmitterTokens.COMMA);
                    this.write(ASEmitterTokens.THIS);
                    this.writeToken(ASEmitterTokens.COMMA);
                    this.write(ASEmitterTokens.SINGLE_QUOTE);
                    this.write(propName);
                    this.write(ASEmitterTokens.SINGLE_QUOTE);
                    this.writeToken(ASEmitterTokens.COMMA);
                    this.write("value");
                    this.write(ASEmitterTokens.PAREN_CLOSE);
                    this.writeNewline(ASEmitterTokens.SEMICOLON);
                    this.write(ASEmitterTokens.BLOCK_CLOSE);
                }
                if (getterNode != null) {
                    this.startMapping((ISourceLocation)getterNode);
                } else {
                    this.startMapping((ISourceLocation)setterNode);
                }
                this.write(ASEmitterTokens.BLOCK_CLOSE);
                if (getterNode != null) {
                    this.endMapping((ISourceLocation)getterNode);
                    continue;
                }
                this.endMapping((ISourceLocation)setterNode);
            }
            this.writeNewline(ASEmitterTokens.BLOCK_CLOSE);
            this.write(ASEmitterTokens.PAREN_CLOSE);
            this.write(ASEmitterTokens.SEMICOLON);
        }
        if (!this.getModel().getStaticPropertyMap().isEmpty()) {
            this.write(JSGoogEmitterTokens.OBJECT);
            this.write(ASEmitterTokens.MEMBER_ACCESS);
            this.write(JSEmitterTokens.DEFINE_PROPERTIES);
            this.write(ASEmitterTokens.PAREN_OPEN);
            qname = definition.getQualifiedName();
            this.write(this.getEmitter().formatQualifiedName(qname));
            this.write(ASEmitterTokens.COMMA);
            this.write(ASEmitterTokens.SPACE);
            this.write("/** @lends {" + this.getEmitter().formatQualifiedName(qname) + "} */ ");
            this.writeNewline(ASEmitterTokens.BLOCK_OPEN);
            propertyNames = this.getModel().getStaticPropertyMap().keySet();
            firstTime = true;
            for (String propName : propertyNames) {
                if (firstTime) {
                    firstTime = false;
                } else {
                    this.writeNewline(ASEmitterTokens.COMMA);
                }
                JSSessionModel.PropertyNodes p = this.getModel().getStaticPropertyMap().get(propName);
                IGetterNode getterNode = p.getter;
                ISetterNode setterNode = p.setter;
                this.writeNewline("/** @expose */");
                if (getterNode != null) {
                    this.startMapping((ISourceLocation)getterNode);
                } else {
                    this.startMapping((ISourceLocation)setterNode);
                }
                this.write(propName);
                this.write(ASEmitterTokens.COLON);
                this.write(ASEmitterTokens.SPACE);
                this.write(ASEmitterTokens.BLOCK_OPEN);
                if (getterNode != null) {
                    this.endMapping((ISourceLocation)getterNode);
                } else {
                    this.endMapping((ISourceLocation)setterNode);
                }
                this.writeNewline();
                if (getterNode != null) {
                    this.startMapping((ISourceLocation)getterNode);
                    this.write(ASEmitterTokens.GET);
                    this.write(ASEmitterTokens.COLON);
                    this.write(ASEmitterTokens.SPACE);
                    this.write(ASEmitterTokens.FUNCTION);
                    this.endMapping((ISourceLocation)getterNode);
                    fjs.emitParameters(getterNode.getParametersContainerNode());
                    fjs.emitDefinePropertyFunction((IAccessorNode)getterNode);
                }
                if (setterNode != null) {
                    if (p.getter != null) {
                        this.writeNewline(ASEmitterTokens.COMMA);
                    }
                    this.startMapping((ISourceLocation)setterNode);
                    this.write(ASEmitterTokens.SET);
                    this.write(ASEmitterTokens.COLON);
                    this.write(ASEmitterTokens.SPACE);
                    this.write(ASEmitterTokens.FUNCTION);
                    this.endMapping((ISourceLocation)setterNode);
                    fjs.emitParameters(setterNode.getParametersContainerNode());
                    fjs.emitDefinePropertyFunction((IAccessorNode)setterNode);
                }
                if (getterNode != null) {
                    this.startMapping((ISourceLocation)getterNode);
                } else {
                    this.startMapping((ISourceLocation)setterNode);
                }
                this.write(ASEmitterTokens.BLOCK_CLOSE);
                if (getterNode != null) {
                    this.endMapping((ISourceLocation)getterNode);
                    continue;
                }
                this.endMapping((ISourceLocation)setterNode);
            }
            this.writeNewline(ASEmitterTokens.BLOCK_CLOSE);
            this.write(ASEmitterTokens.PAREN_CLOSE);
            this.write(ASEmitterTokens.SEMICOLON);
        }
    }

    public void emitGet(IGetterNode node) {
        String name;
        JSFlexJSEmitter fjs = (JSFlexJSEmitter)this.getEmitter();
        ModifiersSet modifierSet = node.getDefinition().getModifiers();
        boolean isStatic = modifierSet != null && modifierSet.hasModifier(ASModifier.STATIC);
        HashMap<String, JSSessionModel.PropertyNodes> map = isStatic ? this.getModel().getStaticPropertyMap() : this.getModel().getPropertyMap();
        JSSessionModel.PropertyNodes p = map.get(name = node.getName());
        if (p == null) {
            p = new JSSessionModel.PropertyNodes();
            map.put(name, p);
        }
        p.getter = node;
        FunctionNode fn = (FunctionNode)node;
        fn.parseFunctionBody(fjs.getProblems());
    }

    public void emitSet(ISetterNode node) {
        String name;
        JSFlexJSEmitter fjs = (JSFlexJSEmitter)this.getEmitter();
        JSFlexJSDocEmitter doc = (JSFlexJSDocEmitter)fjs.getDocEmitter();
        ModifiersSet modifierSet = node.getDefinition().getModifiers();
        boolean isStatic = modifierSet != null && modifierSet.hasModifier(ASModifier.STATIC);
        HashMap<String, JSSessionModel.PropertyNodes> map = isStatic ? this.getModel().getStaticPropertyMap() : this.getModel().getPropertyMap();
        JSSessionModel.PropertyNodes p = map.get(name = node.getName());
        if (p == null) {
            p = new JSSessionModel.PropertyNodes();
            map.put(name, p);
        }
        p.setter = node;
        FunctionNode fn = (FunctionNode)node;
        fn.parseFunctionBody(fjs.getProblems());
        boolean isBindableSetter = false;
        if (node instanceof SetterNode) {
            IMetaInfo[] metaInfos = null;
            for (IMetaInfo metaInfo : metaInfos = node.getMetaInfos()) {
                name = metaInfo.getTagName();
                if (!name.equals("Bindable") || metaInfo.getAllAttributes().length != 0) continue;
                isBindableSetter = true;
                break;
            }
        }
        if (isBindableSetter) {
            IFunctionDefinition definition = node.getDefinition();
            ITypeDefinition type = (ITypeDefinition)definition.getParent();
            doc.emitMethodDoc((IFunctionNode)fn, this.getProject());
            this.write(fjs.formatQualifiedName(type.getQualifiedName()));
            if (!node.hasModifier(ASModifier.STATIC)) {
                this.write(ASEmitterTokens.MEMBER_ACCESS);
                this.write(JSEmitterTokens.PROTOTYPE);
            }
            this.write(ASEmitterTokens.MEMBER_ACCESS);
            this.write("__bindingWrappedSetter__");
            this.writeToken(node.getName());
            this.writeToken(ASEmitterTokens.EQUAL);
            this.write(ASEmitterTokens.FUNCTION);
            fjs.emitParameters(node.getParametersContainerNode());
            fjs.emitMethodScope(node.getScopedNode());
        }
    }
}

