/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.codegen.js.goog;

import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.ErrorManager;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.SourceFile;
import com.google.javascript.jscomp.SourceMap;
import com.google.javascript.jscomp.deps.DepsGenerator;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.RegexFileFilter;
import org.apache.flex.compiler.clients.JSConfiguration;
import org.apache.flex.compiler.clients.MXMLJSC;
import org.apache.flex.compiler.clients.problems.ProblemQuery;
import org.apache.flex.compiler.codegen.js.IJSPublisher;
import org.apache.flex.compiler.config.Configuration;
import org.apache.flex.compiler.internal.codegen.js.JSPublisher;
import org.apache.flex.compiler.internal.codegen.js.JSSharedData;
import org.apache.flex.compiler.internal.driver.js.goog.JSGoogConfiguration;
import org.apache.flex.compiler.utils.JSClosureCompilerUtil;

public class JSGoogPublisher
extends JSPublisher
implements IJSPublisher {
    public static final String GOOG_INTERMEDIATE_DIR_NAME = "js-intermediate";
    public static final String GOOG_RELEASE_DIR_NAME = "js-release";

    public JSGoogPublisher(Configuration config) {
        super(config);
    }

    @Override
    public File getOutputFolder() {
        this.outputParentFolder = new File(this.configuration.getTargetFileDirectory()).getParentFile();
        this.outputFolder = new File(this.outputParentFolder, GOOG_INTERMEDIATE_DIR_NAME);
        this.setupOutputFolder();
        return this.outputFolder;
    }

    @Override
    public boolean publish(ProblemQuery problems) throws IOException {
        String intermediateDirPath = this.getOutputFolder().getPath();
        String projectName = FilenameUtils.getBaseName((String)this.configuration.getTargetFile());
        String outputFileName = projectName + "." + JSSharedData.OUTPUT_EXTENSION;
        File releaseDir = new File(new File(intermediateDirPath).getParentFile(), GOOG_RELEASE_DIR_NAME);
        String releaseDirPath = releaseDir.getPath();
        if (releaseDir.exists()) {
            FileUtils.deleteQuietly((File)releaseDir);
        }
        releaseDir.mkdir();
        String closureLibDirPath = ((JSGoogConfiguration)this.configuration).getClosureLib();
        String closureGoogSrcLibDirPath = closureLibDirPath + "/closure/goog/";
        String closureGoogTgtLibDirPath = intermediateDirPath + "/library/closure/goog";
        String closureTPSrcLibDirPath = closureLibDirPath + "/third_party/closure/goog/";
        String closureTPTgtLibDirPath = intermediateDirPath + "/library/third_party/closure/goog";
        List<String> vanillaSDKSrcLibDirPath = ((JSGoogConfiguration)this.configuration).getSDKJSLib();
        String vanillaSDKTgtLibDirPath = intermediateDirPath + "/VanillaSDK";
        String depsSrcFilePath = intermediateDirPath + "/library/closure/goog/deps.js";
        String depsTgtFilePath = intermediateDirPath + "/deps.js";
        String projectIntermediateJSFilePath = intermediateDirPath + File.separator + outputFileName;
        String projectReleaseJSFilePath = releaseDirPath + File.separator + outputFileName;
        this.appendExportSymbol(projectIntermediateJSFilePath, projectName);
        this.copyFile(vanillaSDKSrcLibDirPath.get(0), vanillaSDKTgtLibDirPath);
        ArrayList<SourceFile> inputs = new ArrayList<SourceFile>();
        Collection files = FileUtils.listFiles((File)new File(intermediateDirPath), (IOFileFilter)new RegexFileFilter("^.*(\\.js)"), (IOFileFilter)DirectoryFileFilter.DIRECTORY);
        for (File file : files) {
            inputs.add(SourceFile.fromFile((File)file));
        }
        this.copyFile(closureGoogSrcLibDirPath, closureGoogTgtLibDirPath);
        this.copyFile(closureTPSrcLibDirPath, closureTPTgtLibDirPath);
        File srcDeps = new File(depsSrcFilePath);
        ArrayList<SourceFile> deps = new ArrayList<SourceFile>();
        deps.add(SourceFile.fromFile((File)srcDeps));
        JSGoogErrorManager errorManager = new JSGoogErrorManager();
        DepsGenerator depsGenerator = new DepsGenerator(deps, inputs, DepsGenerator.InclusionStrategy.ALWAYS, closureGoogTgtLibDirPath, (ErrorManager)errorManager);
        this.writeFile(depsTgtFilePath, depsGenerator.computeDependencyCalls(), false);
        FileUtils.deleteQuietly((File)srcDeps);
        FileUtils.moveFile((File)new File(depsTgtFilePath), (File)srcDeps);
        String outputType = ((JSConfiguration)this.configuration).getJSOutputType();
        if (!outputType.equals(MXMLJSC.JSOutputType.JSC.getText())) {
            this.writeHTML("intermediate", projectName, intermediateDirPath);
            this.writeHTML("release", projectName, releaseDirPath);
        }
        ArrayList<String> optionList = new ArrayList<String>();
        files = FileUtils.listFiles((File)new File(intermediateDirPath), (IOFileFilter)new RegexFileFilter("^.*(\\.js)"), (IOFileFilter)DirectoryFileFilter.DIRECTORY);
        for (File file : files) {
            optionList.add("--js=" + file.getCanonicalPath());
        }
        optionList.add("--closure_entry_point=" + projectName);
        optionList.add("--only_closure_dependencies");
        optionList.add("--compilation_level=ADVANCED_OPTIMIZATIONS");
        optionList.add("--js_output_file=" + projectReleaseJSFilePath);
        optionList.add("--output_manifest=" + releaseDirPath + File.separator + "manifest.txt");
        optionList.add("--create_source_map=" + projectReleaseJSFilePath + ".map");
        optionList.add("--source_map_format=" + SourceMap.Format.V3);
        String[] options = optionList.toArray(new String[0]);
        JSClosureCompilerUtil.run(options);
        this.appendSourceMapLocation(projectReleaseJSFilePath, projectName);
        System.out.println("The project '" + projectName + "' has been successfully compiled and optimized.");
        return true;
    }

    private void appendExportSymbol(String path, String projectName) throws IOException {
        StringBuilder appendString = new StringBuilder();
        appendString.append("\n\n// Ensures the symbol will be visible after compiler renaming.\n");
        appendString.append("goog.exportSymbol('");
        appendString.append(projectName);
        appendString.append("', ");
        appendString.append(projectName);
        appendString.append(");\n");
        this.writeFile(path, appendString.toString(), true);
    }

    protected void appendSourceMapLocation(String path, String projectName) throws IOException {
        StringBuilder appendString = new StringBuilder();
        appendString.append("\n//# sourceMappingURL=./" + projectName + ".js.map");
        this.writeFile(path, appendString.toString(), true);
    }

    protected void copyFile(String srcPath, String tgtPath) throws IOException {
        File srcFile = new File(srcPath);
        if (srcFile.isDirectory()) {
            FileUtils.copyDirectory((File)srcFile, (File)new File(tgtPath));
        } else {
            FileUtils.copyFile((File)srcFile, (File)new File(tgtPath));
        }
    }

    protected void writeHTML(String type, String projectName, String dirPath) throws IOException {
        StringBuilder htmlFile = new StringBuilder();
        htmlFile.append("<!DOCTYPE html>\n");
        htmlFile.append("<html>\n");
        htmlFile.append("<head>\n");
        htmlFile.append("\t<meta http-equiv=\"X-UA-Compatible\" content=\"IE=edge,chrome=1\">\n");
        htmlFile.append("\t<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\">\n");
        if (type == "intermediate") {
            htmlFile.append("\t<script type=\"text/javascript\" src=\"./library/closure/goog/base.js\"></script>\n");
            htmlFile.append("\t<script type=\"text/javascript\">\n");
            htmlFile.append("\t\tgoog.require(\"");
            htmlFile.append(projectName);
            htmlFile.append("\");\n");
            htmlFile.append("\t</script>\n");
        } else {
            htmlFile.append("\t<script type=\"text/javascript\" src=\"./");
            htmlFile.append(projectName);
            htmlFile.append(".js\"></script>\n");
        }
        htmlFile.append("</head>\n");
        htmlFile.append("<body>\n");
        htmlFile.append("\t<script type=\"text/javascript\">\n");
        htmlFile.append("\t\tnew ");
        htmlFile.append(projectName);
        htmlFile.append("();\n");
        htmlFile.append("\t</script>\n");
        htmlFile.append("</body>\n");
        htmlFile.append("</html>");
        this.writeFile(dirPath + File.separator + "index.html", htmlFile.toString(), false);
    }

    protected void writeFile(String path, String content, boolean append) throws IOException {
        File tgtFile = new File(path);
        if (!tgtFile.exists()) {
            tgtFile.createNewFile();
        }
        FileWriter fw = new FileWriter(tgtFile, append);
        fw.write(content);
        fw.close();
    }

    protected void dumpJar(File jarFile, File outputDir) throws IOException {
        JarFile jar = new JarFile(jarFile);
        Enumeration<JarEntry> jarEntries = jar.entries();
        while (jarEntries.hasMoreElements()) {
            JarEntry jarEntry = jarEntries.nextElement();
            if (jarEntry.getName().endsWith("/")) continue;
            File file = new File(outputDir, jarEntry.getName());
            File dir = file.getParentFile();
            if (!dir.exists() && !dir.mkdirs()) {
                throw new IOException("Unable to create directory " + dir.getAbsolutePath());
            }
            InputStream is = jar.getInputStream(jarEntry);
            FileOutputStream fos = new FileOutputStream(file);
            while (is.available() > 0) {
                fos.write(is.read());
            }
            fos.close();
            is.close();
        }
        jar.close();
    }

    public class JSGoogErrorManager
    implements ErrorManager {
        public void setTypedPercent(double arg0) {
        }

        public void report(CheckLevel arg0, JSError arg1) {
        }

        public JSError[] getWarnings() {
            return null;
        }

        public int getWarningCount() {
            return 0;
        }

        public double getTypedPercent() {
            return 0.0;
        }

        public JSError[] getErrors() {
            return null;
        }

        public int getErrorCount() {
            return 0;
        }

        public void generateReport() {
        }
    }
}

