/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.codegen.js.flexjs;

import com.google.common.base.Joiner;
import java.io.FilterWriter;
import java.util.ArrayList;
import java.util.List;
import org.apache.flex.compiler.codegen.js.flexjs.IJSFlexJSEmitter;
import org.apache.flex.compiler.codegen.js.goog.IJSGoogDocEmitter;
import org.apache.flex.compiler.definitions.IClassDefinition;
import org.apache.flex.compiler.definitions.IDefinition;
import org.apache.flex.compiler.definitions.IPackageDefinition;
import org.apache.flex.compiler.definitions.ITypeDefinition;
import org.apache.flex.compiler.internal.codegen.as.ASEmitterTokens;
import org.apache.flex.compiler.internal.codegen.js.flexjs.JSFlexJSDocEmitter;
import org.apache.flex.compiler.internal.codegen.js.flexjs.JSFlexJSEmitterTokens;
import org.apache.flex.compiler.internal.codegen.js.goog.JSGoogEmitter;
import org.apache.flex.compiler.internal.codegen.js.goog.JSGoogEmitterTokens;
import org.apache.flex.compiler.internal.codegen.js.jx.AccessorEmitter;
import org.apache.flex.compiler.internal.codegen.js.jx.AsIsEmitter;
import org.apache.flex.compiler.internal.codegen.js.jx.BinaryOperatorEmitter;
import org.apache.flex.compiler.internal.codegen.js.jx.BindableEmitter;
import org.apache.flex.compiler.internal.codegen.js.jx.ClassEmitter;
import org.apache.flex.compiler.internal.codegen.js.jx.DefinePropertyFunctionEmitter;
import org.apache.flex.compiler.internal.codegen.js.jx.FieldEmitter;
import org.apache.flex.compiler.internal.codegen.js.jx.ForEachEmitter;
import org.apache.flex.compiler.internal.codegen.js.jx.FunctionCallEmitter;
import org.apache.flex.compiler.internal.codegen.js.jx.IdentifierEmitter;
import org.apache.flex.compiler.internal.codegen.js.jx.InterfaceEmitter;
import org.apache.flex.compiler.internal.codegen.js.jx.LiteralEmitter;
import org.apache.flex.compiler.internal.codegen.js.jx.MemberAccessEmitter;
import org.apache.flex.compiler.internal.codegen.js.jx.MethodEmitter;
import org.apache.flex.compiler.internal.codegen.js.jx.ObjectDefinePropertyEmitter;
import org.apache.flex.compiler.internal.codegen.js.jx.PackageFooterEmitter;
import org.apache.flex.compiler.internal.codegen.js.jx.PackageHeaderEmitter;
import org.apache.flex.compiler.internal.codegen.js.jx.SelfReferenceEmitter;
import org.apache.flex.compiler.internal.codegen.js.jx.SuperCallEmitter;
import org.apache.flex.compiler.internal.codegen.js.jx.VarDeclarationEmitter;
import org.apache.flex.compiler.internal.codegen.js.utils.EmitterUtils;
import org.apache.flex.compiler.internal.codegen.mxml.flexjs.MXMLFlexJSEmitter;
import org.apache.flex.compiler.internal.definitions.AccessorDefinition;
import org.apache.flex.compiler.internal.projects.FlexJSProject;
import org.apache.flex.compiler.internal.projects.FlexProject;
import org.apache.flex.compiler.internal.tree.as.BinaryOperatorAsNode;
import org.apache.flex.compiler.internal.tree.as.BlockNode;
import org.apache.flex.compiler.internal.tree.as.DynamicAccessNode;
import org.apache.flex.compiler.internal.tree.as.FunctionCallNode;
import org.apache.flex.compiler.internal.tree.as.IdentifierNode;
import org.apache.flex.compiler.internal.tree.as.LabeledStatementNode;
import org.apache.flex.compiler.internal.tree.as.MemberAccessExpressionNode;
import org.apache.flex.compiler.internal.tree.as.NumericLiteralNode;
import org.apache.flex.compiler.projects.ICompilerProject;
import org.apache.flex.compiler.tree.ASTNodeID;
import org.apache.flex.compiler.tree.as.IASNode;
import org.apache.flex.compiler.tree.as.IAccessorNode;
import org.apache.flex.compiler.tree.as.IBinaryOperatorNode;
import org.apache.flex.compiler.tree.as.IClassNode;
import org.apache.flex.compiler.tree.as.IContainerNode;
import org.apache.flex.compiler.tree.as.IDefinitionNode;
import org.apache.flex.compiler.tree.as.IExpressionNode;
import org.apache.flex.compiler.tree.as.IFileNode;
import org.apache.flex.compiler.tree.as.IForLoopNode;
import org.apache.flex.compiler.tree.as.IFunctionCallNode;
import org.apache.flex.compiler.tree.as.IFunctionNode;
import org.apache.flex.compiler.tree.as.IFunctionObjectNode;
import org.apache.flex.compiler.tree.as.IGetterNode;
import org.apache.flex.compiler.tree.as.IIdentifierNode;
import org.apache.flex.compiler.tree.as.IInterfaceNode;
import org.apache.flex.compiler.tree.as.ILiteralNode;
import org.apache.flex.compiler.tree.as.IMemberAccessExpressionNode;
import org.apache.flex.compiler.tree.as.INamespaceNode;
import org.apache.flex.compiler.tree.as.IOperatorNode;
import org.apache.flex.compiler.tree.as.IPackageNode;
import org.apache.flex.compiler.tree.as.IScopedNode;
import org.apache.flex.compiler.tree.as.ISetterNode;
import org.apache.flex.compiler.tree.as.IUnaryOperatorNode;
import org.apache.flex.compiler.tree.as.IVariableNode;
import org.apache.flex.compiler.utils.ASNodeUtils;

public class JSFlexJSEmitter
extends JSGoogEmitter
implements IJSFlexJSEmitter {
    private JSFlexJSDocEmitter docEmitter = null;
    private PackageHeaderEmitter packageHeaderEmitter;
    public PackageFooterEmitter packageFooterEmitter;
    private BindableEmitter bindableEmitter;
    private ClassEmitter classEmitter;
    private InterfaceEmitter interfaceEmitter;
    private FieldEmitter fieldEmitter;
    public VarDeclarationEmitter varDeclarationEmitter;
    public AccessorEmitter accessorEmitter;
    public MethodEmitter methodEmitter;
    private FunctionCallEmitter functionCallEmitter;
    private SuperCallEmitter superCallEmitter;
    private ForEachEmitter forEachEmitter;
    private MemberAccessEmitter memberAccessEmitter;
    private BinaryOperatorEmitter binaryOperatorEmitter;
    private IdentifierEmitter identifierEmitter;
    private LiteralEmitter literalEmitter;
    private AsIsEmitter asIsEmitter;
    private SelfReferenceEmitter selfReferenceEmitter;
    private ObjectDefinePropertyEmitter objectDefinePropertyEmitter;
    private DefinePropertyFunctionEmitter definePropertyFunctionEmitter;
    public ArrayList<String> usedNames = new ArrayList();
    public MXMLFlexJSEmitter mxmlEmitter = null;

    @Override
    public String postProcess(String output) {
        output = super.postProcess(output);
        String[] lines = output.split("\n");
        ArrayList<String> finalLines = new ArrayList<String>();
        boolean foundLanguage = false;
        boolean foundXML = false;
        boolean sawRequires = false;
        boolean stillSearching = true;
        int addIndex = -1;
        int len = lines.length;
        for (int i = 0; i < len; ++i) {
            String line = lines[i];
            if (stillSearching) {
                int c = line.indexOf(JSGoogEmitterTokens.GOOG_PROVIDE.getToken());
                if (c != -1) {
                    addIndex = i + 1;
                }
                if ((c = line.indexOf(JSGoogEmitterTokens.GOOG_REQUIRE.getToken())) != -1) {
                    addIndex = -1;
                    int c2 = line.indexOf(")");
                    String s = line.substring(c + 14, c2 - 1);
                    if (s.equals(JSFlexJSEmitterTokens.LANGUAGE_QNAME.getToken())) {
                        foundLanguage = true;
                    } else if (s.equals("XML")) {
                        foundXML = true;
                    }
                    sawRequires = true;
                    if (!this.usedNames.contains(s)) {
                        this.removeLineFromMappings(i);
                        continue;
                    }
                } else if (sawRequires || i == len - 1) {
                    stillSearching = false;
                    ICompilerProject project = this.getWalker().getProject();
                    if (project instanceof FlexJSProject) {
                        boolean needXML;
                        FlexJSProject flexJSProject = (FlexJSProject)project;
                        boolean needLanguage = flexJSProject.needLanguage;
                        if (needLanguage && !foundLanguage) {
                            StringBuilder appendString = new StringBuilder();
                            appendString.append(JSGoogEmitterTokens.GOOG_REQUIRE.getToken());
                            appendString.append(ASEmitterTokens.PAREN_OPEN.getToken());
                            appendString.append(ASEmitterTokens.SINGLE_QUOTE.getToken());
                            appendString.append(JSFlexJSEmitterTokens.LANGUAGE_QNAME.getToken());
                            appendString.append(ASEmitterTokens.SINGLE_QUOTE.getToken());
                            appendString.append(ASEmitterTokens.PAREN_CLOSE.getToken());
                            appendString.append(ASEmitterTokens.SEMICOLON.getToken());
                            if (addIndex != -1) {
                                finalLines.add(addIndex, appendString.toString());
                                this.addLineToMappings(addIndex);
                            } else {
                                finalLines.add(appendString.toString());
                                this.addLineToMappings(i);
                            }
                        }
                        if ((needXML = flexJSProject.needXML) && !foundXML) {
                            StringBuilder appendString = new StringBuilder();
                            appendString.append(JSGoogEmitterTokens.GOOG_REQUIRE.getToken());
                            appendString.append(ASEmitterTokens.PAREN_OPEN.getToken());
                            appendString.append(ASEmitterTokens.SINGLE_QUOTE.getToken());
                            appendString.append("XML");
                            appendString.append(ASEmitterTokens.SINGLE_QUOTE.getToken());
                            appendString.append(ASEmitterTokens.PAREN_CLOSE.getToken());
                            appendString.append(ASEmitterTokens.SEMICOLON.getToken());
                            if (addIndex != -1) {
                                finalLines.add(addIndex, appendString.toString());
                                this.addLineToMappings(addIndex);
                            } else {
                                finalLines.add(appendString.toString());
                                this.addLineToMappings(i);
                            }
                        }
                    }
                }
            }
            finalLines.add(line);
        }
        return Joiner.on((String)"\n").join(finalLines);
    }

    public BindableEmitter getBindableEmitter() {
        return this.bindableEmitter;
    }

    public ClassEmitter getClassEmiter() {
        return this.classEmitter;
    }

    public AccessorEmitter getAccessorEmitter() {
        return this.accessorEmitter;
    }

    public PackageFooterEmitter getPackageFooterEmitter() {
        return this.packageFooterEmitter;
    }

    @Override
    public IJSGoogDocEmitter getDocEmitter() {
        if (this.docEmitter == null) {
            this.docEmitter = new JSFlexJSDocEmitter(this);
        }
        return this.docEmitter;
    }

    public JSFlexJSEmitter(FilterWriter out) {
        super(out);
        this.packageHeaderEmitter = new PackageHeaderEmitter(this);
        this.packageFooterEmitter = new PackageFooterEmitter(this);
        this.bindableEmitter = new BindableEmitter(this);
        this.classEmitter = new ClassEmitter(this);
        this.interfaceEmitter = new InterfaceEmitter(this);
        this.fieldEmitter = new FieldEmitter(this);
        this.varDeclarationEmitter = new VarDeclarationEmitter(this);
        this.accessorEmitter = new AccessorEmitter(this);
        this.methodEmitter = new MethodEmitter(this);
        this.functionCallEmitter = new FunctionCallEmitter(this);
        this.superCallEmitter = new SuperCallEmitter(this);
        this.forEachEmitter = new ForEachEmitter(this);
        this.memberAccessEmitter = new MemberAccessEmitter(this);
        this.binaryOperatorEmitter = new BinaryOperatorEmitter(this);
        this.identifierEmitter = new IdentifierEmitter(this);
        this.literalEmitter = new LiteralEmitter(this);
        this.asIsEmitter = new AsIsEmitter(this);
        this.selfReferenceEmitter = new SelfReferenceEmitter(this);
        this.objectDefinePropertyEmitter = new ObjectDefinePropertyEmitter(this);
        this.definePropertyFunctionEmitter = new DefinePropertyFunctionEmitter(this);
    }

    @Override
    protected void writeIndent() {
        this.write(JSFlexJSEmitterTokens.INDENT);
    }

    @Override
    protected String getIndent(int numIndent) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < numIndent; ++i) {
            sb.append(JSFlexJSEmitterTokens.INDENT.getToken());
        }
        return sb.toString();
    }

    @Override
    public void emitLocalNamedFunction(IFunctionNode node) {
        IFunctionNode fnNode = (IFunctionNode)node.getAncestorOfType(IFunctionNode.class);
        if (fnNode.getEmittingLocalFunctions()) {
            super.emitLocalNamedFunction(node);
        }
    }

    @Override
    public void emitFunctionBlockHeader(IFunctionNode node) {
        node.setEmittingLocalFunctions(true);
        super.emitFunctionBlockHeader(node);
        if (node.isConstructor()) {
            IClassNode cnode = (IClassNode)node.getAncestorOfType(IClassNode.class);
            this.emitComplexInitializers(cnode);
        }
        if (node.containsLocalFunctions()) {
            List anonFns = node.getLocalFunctions();
            int n = anonFns.size();
            for (int i = 0; i < n; ++i) {
                IFunctionNode anonFn = (IFunctionNode)anonFns.get(i);
                if (anonFn.getParent().getNodeID() == ASTNodeID.AnonymousFunctionID) {
                    this.write("var /** @type {Function} */ __localFn" + Integer.toString(i) + "__ = ");
                    this.getWalker().walk(anonFn.getParent());
                } else {
                    this.getWalker().walk((IASNode)anonFn);
                    this.write(ASEmitterTokens.SEMICOLON);
                }
                this.writeNewline();
            }
        }
        node.setEmittingLocalFunctions(false);
    }

    @Override
    public void emitFunctionObject(IFunctionObjectNode node) {
        IFunctionNode fnNode = (IFunctionNode)node.getAncestorOfType(IFunctionNode.class);
        if (fnNode == null || fnNode.getEmittingLocalFunctions()) {
            super.emitFunctionObject(node);
        } else {
            List anonFns = fnNode.getLocalFunctions();
            int i = anonFns.indexOf(node.getFunctionNode());
            if (i < 0) {
                System.out.println("missing index for " + node.toString());
            } else {
                this.write("__localFn" + Integer.toString(i) + "__");
            }
        }
    }

    @Override
    public void emitNamespace(INamespaceNode node) {
        this.write(this.formatQualifiedName(node.getName()));
        this.write(ASEmitterTokens.SPACE);
        this.writeToken(ASEmitterTokens.EQUAL);
        this.writeToken(ASEmitterTokens.NEW);
        this.write("Namespace");
        this.write(ASEmitterTokens.PAREN_OPEN);
        this.getWalker().walk((IASNode)node.getNamespaceURINode());
        this.write(ASEmitterTokens.PAREN_CLOSE);
        this.write(ASEmitterTokens.SEMICOLON);
    }

    @Override
    public void emitMemberName(IDefinitionNode node) {
        this.write(node.getName());
    }

    @Override
    public String formatQualifiedName(String name) {
        return this.formatQualifiedName(name, false);
    }

    public String formatQualifiedName(String name, boolean isDoc) {
        if (this.mxmlEmitter != null) {
            name = this.mxmlEmitter.formatQualifiedName(name);
        }
        if (this.getModel().isInternalClass(name)) {
            return this.getModel().getInternalClasses().get(name);
        }
        if (name.startsWith("window.")) {
            name = name.substring(7);
        } else if (!isDoc && !this.usedNames.contains(name)) {
            this.usedNames.add(name);
        }
        return name;
    }

    public String convertASTypeToJS(String name) {
        String result = name;
        if (name.equals("")) {
            result = "Object";
        } else if (name.equals("Class")) {
            result = "Object";
        } else if (name.equals("int") || name.equals("uint")) {
            result = "Number";
        }
        boolean isBuiltinFunction = name.matches("Vector\\.<.*>");
        if (isBuiltinFunction) {
            result = "Array";
        }
        return result;
    }

    @Override
    public void emitPackageHeader(IPackageDefinition definition) {
        IPackageNode packageNode = definition.getNode();
        IFileNode fileNode = (IFileNode)packageNode.getAncestorOfType(IFileNode.class);
        int nodeCount = fileNode.getChildCount();
        String mainClassName = null;
        block0: for (int i = 0; i < nodeCount; ++i) {
            String className;
            IASNode pnode = fileNode.getChild(i);
            if (pnode instanceof IPackageNode) {
                IScopedNode snode = ((IPackageNode)pnode).getScopedNode();
                int snodeCount = snode.getChildCount();
                for (int j = 0; j < snodeCount; ++j) {
                    IASNode cnode = snode.getChild(j);
                    if (!(cnode instanceof IClassNode)) continue;
                    mainClassName = ((IClassNode)cnode).getQualifiedName();
                    continue block0;
                }
                continue;
            }
            if (pnode instanceof IClassNode) {
                className = ((IClassNode)pnode).getQualifiedName();
                this.getModel().getInternalClasses().put(className, mainClassName + "." + className);
                continue;
            }
            if (pnode instanceof IInterfaceNode) {
                className = ((IInterfaceNode)pnode).getQualifiedName();
                this.getModel().getInternalClasses().put(className, mainClassName + "." + className);
                continue;
            }
            if (pnode instanceof IFunctionNode) {
                className = ((IFunctionNode)pnode).getQualifiedName();
                this.getModel().getInternalClasses().put(className, mainClassName + "." + className);
                continue;
            }
            if (pnode instanceof INamespaceNode) {
                className = ((INamespaceNode)pnode).getQualifiedName();
                this.getModel().getInternalClasses().put(className, mainClassName + "." + className);
                continue;
            }
            if (!(pnode instanceof IVariableNode)) continue;
            className = ((IVariableNode)pnode).getQualifiedName();
            this.getModel().getInternalClasses().put(className, mainClassName + "." + className);
        }
        this.packageHeaderEmitter.emit(definition);
    }

    @Override
    public void emitPackageHeaderContents(IPackageDefinition definition) {
        this.packageHeaderEmitter.emitContents(definition);
        this.usedNames.clear();
    }

    @Override
    public void emitPackageFooter(IPackageDefinition definition) {
        this.packageFooterEmitter.emit(definition);
    }

    @Override
    public void emitClass(IClassNode node) {
        this.classEmitter.emit(node);
    }

    @Override
    public void emitInterface(IInterfaceNode node) {
        this.interfaceEmitter.emit(node);
    }

    @Override
    public void emitField(IVariableNode node) {
        this.fieldEmitter.emit(node);
    }

    @Override
    public void emitVarDeclaration(IVariableNode node) {
        this.varDeclarationEmitter.emit(node);
    }

    @Override
    public void emitAccessors(IAccessorNode node) {
        this.accessorEmitter.emit(node);
    }

    @Override
    public void emitGetAccessor(IGetterNode node) {
        this.accessorEmitter.emitGet(node);
    }

    @Override
    public void emitSetAccessor(ISetterNode node) {
        this.accessorEmitter.emitSet(node);
    }

    @Override
    public void emitMethod(IFunctionNode node) {
        this.methodEmitter.emit(node);
    }

    public void emitComplexInitializers(IClassNode node) {
        this.classEmitter.emitComplexInitializers(node);
    }

    @Override
    public void emitFunctionCall(IFunctionCallNode node) {
        this.functionCallEmitter.emit(node);
    }

    @Override
    public void emitForEachLoop(IForLoopNode node) {
        this.forEachEmitter.emit(node);
    }

    @Override
    public void emitSuperCall(IASNode node, String type) {
        this.superCallEmitter.emit(node, type);
    }

    @Override
    public void emitMemberAccessExpression(IMemberAccessExpressionNode node) {
        this.memberAccessEmitter.emit(node);
    }

    @Override
    public void emitArguments(IContainerNode node) {
        IDefinition def;
        IExpressionNode nameNode;
        IFunctionCallNode fcNode;
        ICompilerProject project;
        IContainerNode newNode = node;
        int len = node.getChildCount();
        if (len == 2) {
            project = this.getWalker().getProject();
            fcNode = (IFunctionCallNode)node.getParent();
            nameNode = fcNode.getNameNode();
            def = nameNode.resolve(project);
            if (def != null && def.getBaseName().equals("insertAt") && def.getParent() != null && def.getParent().getQualifiedName().equals("Array") && nameNode instanceof MemberAccessExpressionNode) {
                newNode = EmitterUtils.insertArgumentsAt(node, 1, new IASNode[]{new NumericLiteralNode("0")});
            }
        }
        if (len == 1) {
            IDefinition parentDef;
            project = this.getWalker().getProject();
            fcNode = (IFunctionCallNode)node.getParent();
            nameNode = fcNode.getNameNode();
            def = nameNode.resolve(project);
            if (def != null && def.getBaseName().equals("removeAt")) {
                if (def.getParent() != null && def.getParent().getQualifiedName().equals("Array") && nameNode instanceof MemberAccessExpressionNode) {
                    newNode = EmitterUtils.insertArgumentsAfter(node, new IASNode[]{new NumericLiteralNode("1")});
                }
            } else if (def != null && def.getBaseName().equals("parseInt") && (parentDef = def.getParent()) == null && nameNode instanceof IdentifierNode) {
                newNode = EmitterUtils.insertArgumentsAfter(node, new IASNode[]{new NumericLiteralNode("10")});
            }
        }
        super.emitArguments(newNode);
    }

    @Override
    public void emitE4XFilter(IMemberAccessExpressionNode node) {
        this.getModel().inE4xFilter = true;
        this.getWalker().walk((IASNode)node.getLeftOperandNode());
        this.write(".filter(function(node){return (node.");
        String s = this.stringifyNode((IASNode)node.getRightOperandNode());
        if (s.startsWith("(") && s.endsWith(")")) {
            s = s.substring(1, s.length() - 1);
        }
        this.write(s);
        this.write(")})");
        this.getModel().inE4xFilter = false;
    }

    @Override
    public void emitBinaryOperator(IBinaryOperatorNode node) {
        this.binaryOperatorEmitter.emit(node);
    }

    @Override
    public void emitIdentifier(IIdentifierNode node) {
        this.identifierEmitter.emit(node);
    }

    @Override
    public void emitLiteral(ILiteralNode node) {
        this.literalEmitter.emit(node);
    }

    public void emitIsAs(IExpressionNode node, IExpressionNode left, IExpressionNode right, ASTNodeID id, boolean coercion) {
        this.asIsEmitter.emitIsAs(node, left, right, id, coercion);
    }

    @Override
    protected void emitSelfReference(IFunctionNode node) {
        this.selfReferenceEmitter.emit(node);
    }

    @Override
    protected void emitObjectDefineProperty(IAccessorNode node) {
        this.objectDefinePropertyEmitter.emit(node);
    }

    @Override
    public void emitDefinePropertyFunction(IAccessorNode node) {
        this.definePropertyFunctionEmitter.emit(node);
    }

    public String stringifyDefineProperties(IClassDefinition cdef) {
        this.setBufferWrite(true);
        this.accessorEmitter.emit(cdef);
        String result = this.getBuilder().toString();
        this.getBuilder().setLength(0);
        this.setBufferWrite(false);
        return result;
    }

    @Override
    public void emitClosureStart() {
        ICompilerProject project = this.getWalker().getProject();
        if (project instanceof FlexJSProject) {
            ((FlexJSProject)project).needLanguage = true;
        }
        this.write(JSFlexJSEmitterTokens.CLOSURE_FUNCTION_NAME);
        this.write(ASEmitterTokens.PAREN_OPEN);
    }

    @Override
    public void emitClosureEnd(IASNode node) {
        this.write(ASEmitterTokens.COMMA);
        this.write(ASEmitterTokens.SPACE);
        this.write(ASEmitterTokens.SINGLE_QUOTE);
        if (node.getNodeID() == ASTNodeID.IdentifierID) {
            this.write(((IIdentifierNode)node).getName());
        } else if (node.getNodeID() == ASTNodeID.MemberAccessExpressionID) {
            this.writeChainName(node);
        } else {
            System.out.println("unexpected node in emitClosureEnd");
        }
        this.write(ASEmitterTokens.SINGLE_QUOTE);
        this.write(ASEmitterTokens.PAREN_CLOSE);
    }

    @Override
    public void emitStatement(IASNode node) {
        if (node.getNodeID() == ASTNodeID.FunctionID) {
            return;
        }
        super.emitStatement(node);
    }

    private void writeChainName(IASNode node) {
        while (node.getNodeID() == ASTNodeID.MemberAccessExpressionID) {
            node = ((IMemberAccessExpressionNode)node).getRightOperandNode();
        }
        if (node.getNodeID() == ASTNodeID.IdentifierID) {
            this.write(((IdentifierNode)node).getName());
        } else {
            System.out.println("unexpected node in emitClosureEnd");
        }
    }

    @Override
    public void emitUnaryOperator(IUnaryOperatorNode node) {
        if (node.getNodeID() == ASTNodeID.Op_DeleteID) {
            MemberAccessExpressionNode obj;
            if (node.getChild(0).getNodeID() == ASTNodeID.ArrayIndexExpressionID) {
                if (node.getChild(0).getChild(0).getNodeID() == ASTNodeID.MemberAccessExpressionID) {
                    MemberAccessExpressionNode obj2 = (MemberAccessExpressionNode)node.getChild(0).getChild(0);
                    if (this.isXMLList(obj2)) {
                        if (ASNodeUtils.hasParenOpen((IOperatorNode)node)) {
                            this.write(ASEmitterTokens.PAREN_OPEN);
                        }
                        this.getWalker().walk((IASNode)obj2);
                        DynamicAccessNode dan = (DynamicAccessNode)node.getChild(0);
                        IASNode indexNode = dan.getChild(1);
                        this.write(".removeChildAt(");
                        this.getWalker().walk(indexNode);
                        this.write(")");
                        if (ASNodeUtils.hasParenClose((IOperatorNode)node)) {
                            this.write(ASEmitterTokens.PAREN_CLOSE);
                        }
                        return;
                    }
                } else if (node.getChild(0).getChild(0).getNodeID() == ASTNodeID.IdentifierID) {
                    if (this.isXML((IExpressionNode)((IdentifierNode)node.getChild(0).getChild(0)))) {
                        if (ASNodeUtils.hasParenOpen((IOperatorNode)node)) {
                            this.write(ASEmitterTokens.PAREN_OPEN);
                        }
                        this.getWalker().walk(node.getChild(0).getChild(0));
                        DynamicAccessNode dan = (DynamicAccessNode)node.getChild(0);
                        IASNode indexNode = dan.getChild(1);
                        this.write(".removeChild(");
                        this.getWalker().walk(indexNode);
                        this.write(")");
                        if (ASNodeUtils.hasParenClose((IOperatorNode)node)) {
                            this.write(ASEmitterTokens.PAREN_CLOSE);
                        }
                        return;
                    }
                    if (this.isProxy((IExpressionNode)((IdentifierNode)node.getChild(0).getChild(0)))) {
                        if (ASNodeUtils.hasParenOpen((IOperatorNode)node)) {
                            this.write(ASEmitterTokens.PAREN_OPEN);
                        }
                        this.getWalker().walk(node.getChild(0).getChild(0));
                        DynamicAccessNode dan = (DynamicAccessNode)node.getChild(0);
                        IASNode indexNode = dan.getChild(1);
                        this.write(".deleteProperty(");
                        this.getWalker().walk(indexNode);
                        this.write(")");
                        if (ASNodeUtils.hasParenClose((IOperatorNode)node)) {
                            this.write(ASEmitterTokens.PAREN_CLOSE);
                        }
                        return;
                    }
                }
            } else if (node.getChild(0).getNodeID() == ASTNodeID.MemberAccessExpressionID && this.isXMLList(obj = (MemberAccessExpressionNode)node.getChild(0))) {
                if (ASNodeUtils.hasParenOpen((IOperatorNode)node)) {
                    this.write(ASEmitterTokens.PAREN_OPEN);
                }
                String s = this.stringifyNode((IASNode)obj.getLeftOperandNode());
                this.write(s);
                this.write(".removeChild('");
                s = this.stringifyNode((IASNode)obj.getRightOperandNode());
                this.write(s);
                this.write("')");
                if (ASNodeUtils.hasParenClose((IOperatorNode)node)) {
                    this.write(ASEmitterTokens.PAREN_CLOSE);
                }
                return;
            }
        } else if (node.getNodeID() == ASTNodeID.Op_AtID) {
            this.write("attribute('");
            this.getWalker().walk((IASNode)node.getOperandNode());
            this.write("')");
            return;
        }
        super.emitUnaryOperator(node);
    }

    public boolean isXMLList(MemberAccessExpressionNode obj) {
        IExpressionNode leftNode = obj.getLeftOperandNode();
        IExpressionNode rightNode = obj.getRightOperandNode();
        ASTNodeID rightID = rightNode.getNodeID();
        if (rightID == ASTNodeID.IdentifierID) {
            ITypeDefinition rightDef = rightNode.resolveType(this.getWalker().getProject());
            if (rightDef != null) {
                if (IdentifierNode.isXMLish((IDefinition)rightDef, (ICompilerProject)this.getWalker().getProject())) {
                    return this.isLeftNodeXMLish(leftNode);
                }
                return false;
            }
            return this.isLeftNodeXMLish(leftNode);
        }
        return rightID == ASTNodeID.Op_AtID;
    }

    public boolean isLeftNodeXMLish(IExpressionNode leftNode) {
        ASTNodeID leftID = leftNode.getNodeID();
        if (leftID == ASTNodeID.IdentifierID) {
            ITypeDefinition leftDef = leftNode.resolveType(this.getWalker().getProject());
            if (leftDef != null) {
                return IdentifierNode.isXMLish((IDefinition)leftDef, (ICompilerProject)this.getWalker().getProject());
            }
        } else {
            if (leftID == ASTNodeID.MemberAccessExpressionID) {
                ITypeDefinition rightDef;
                MemberAccessExpressionNode maen = (MemberAccessExpressionNode)leftNode;
                IExpressionNode rightNode = maen.getRightOperandNode();
                ASTNodeID rightID = rightNode.getNodeID();
                if (rightID == ASTNodeID.IdentifierID && (rightDef = rightNode.resolveType(this.getWalker().getProject())) != null) {
                    return IdentifierNode.isXMLish((IDefinition)rightDef, (ICompilerProject)this.getWalker().getProject());
                }
                leftNode = maen.getLeftOperandNode();
                return this.isLeftNodeXMLish(leftNode);
            }
            if (leftID == ASTNodeID.FunctionCallID) {
                FunctionCallNode fcn = (FunctionCallNode)leftNode;
                String fname = fcn.getFunctionName();
                if (fname.equals("XML") || fname.equals("XMLList")) {
                    return true;
                }
            } else if (leftID == ASTNodeID.Op_AsID) {
                BinaryOperatorAsNode boan = (BinaryOperatorAsNode)leftNode;
                String fname = ((IdentifierNode)boan.getChild(1)).getName();
                if (fname.equals("XML") || fname.equals("XMLList")) {
                    return true;
                }
            } else if (leftID == ASTNodeID.ArrayIndexExpressionID) {
                ITypeDefinition leftDef = (leftNode = (IExpressionNode)leftNode.getChild(0)).resolveType(this.getWalker().getProject());
                if (leftDef != null) {
                    return IdentifierNode.isXMLish((IDefinition)leftDef, (ICompilerProject)this.getWalker().getProject());
                }
            } else if (leftID == ASTNodeID.E4XFilterID) {
                return true;
            }
        }
        return false;
    }

    public boolean isProxy(IExpressionNode obj) {
        FlexProject project = (FlexProject)this.getWalker().getProject();
        ITypeDefinition leftDef = obj.resolveType((ICompilerProject)project);
        if (leftDef == null) {
            if (obj.getNodeID() == ASTNodeID.MemberAccessExpressionID) {
                IExpressionNode leftNode = ((MemberAccessExpressionNode)obj).getLeftOperandNode();
                leftDef = leftNode.resolveType((ICompilerProject)project);
                if (leftDef != null && leftDef.isInstanceOf(project.getProxyBaseClass(), (ICompilerProject)project)) {
                    return true;
                }
                while (leftNode.getNodeID() == ASTNodeID.MemberAccessExpressionID) {
                    leftDef = (leftNode = ((MemberAccessExpressionNode)leftNode).getLeftOperandNode()).resolveType((ICompilerProject)project);
                    if (leftDef == null || !leftDef.isInstanceOf(project.getProxyBaseClass(), (ICompilerProject)project)) continue;
                    return true;
                }
            }
            return false;
        }
        return leftDef.isInstanceOf(project.getProxyBaseClass(), (ICompilerProject)project);
    }

    public boolean isDateProperty(IExpressionNode obj) {
        FlexProject project = (FlexProject)this.getWalker().getProject();
        if (obj.getNodeID() == ASTNodeID.MemberAccessExpressionID) {
            IExpressionNode leftNode = ((MemberAccessExpressionNode)obj).getLeftOperandNode();
            IExpressionNode rightNode = ((MemberAccessExpressionNode)obj).getRightOperandNode();
            ITypeDefinition leftDef = leftNode.resolveType((ICompilerProject)project);
            IDefinition rightDef = rightNode.resolve((ICompilerProject)project);
            if (leftDef != null && leftDef.getQualifiedName().equals("Date") && rightDef instanceof AccessorDefinition) {
                return true;
            }
        }
        return false;
    }

    public boolean isXML(IExpressionNode obj) {
        ITypeDefinition leftDef = obj.resolveType(this.getWalker().getProject());
        return IdentifierNode.isXMLish((IDefinition)leftDef, (ICompilerProject)this.getWalker().getProject());
    }

    public MemberAccessExpressionNode getLastMAEInChain(MemberAccessExpressionNode node) {
        while (node.getRightOperandNode() instanceof MemberAccessExpressionNode) {
            node = (MemberAccessExpressionNode)node.getRightOperandNode();
        }
        return node;
    }

    @Override
    public void emitLabelStatement(LabeledStatementNode node) {
        BlockNode innerBlock = node.getLabeledStatement();
        if (innerBlock.getChildCount() == 1 && innerBlock.getChild(0).getNodeID() == ASTNodeID.ForEachLoopID) {
            this.getWalker().walk((IASNode)node.getLabeledStatement());
            return;
        }
        super.emitLabelStatement(node);
    }
}

