/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.codegen.js;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Stack;
import org.apache.flex.compiler.codegen.ISourceMapEmitter;
import org.apache.flex.compiler.codegen.js.IJSEmitter;
import org.apache.flex.compiler.codegen.js.IJSWriter;
import org.apache.flex.compiler.driver.js.IJSBackend;
import org.apache.flex.compiler.internal.codegen.js.JSFilterWriter;
import org.apache.flex.compiler.internal.codegen.js.JSSharedData;
import org.apache.flex.compiler.problems.ICompilerProblem;
import org.apache.flex.compiler.projects.IASProject;
import org.apache.flex.compiler.units.ICompilationUnit;
import org.apache.flex.compiler.visitor.as.IASBlockWalker;

public class JSWriter
implements IJSWriter {
    protected IASProject project;
    protected List<ICompilerProblem> problems;
    protected ICompilationUnit compilationUnit;
    private boolean enableDebug;

    public JSWriter(IASProject project, List<ICompilerProblem> problems, ICompilationUnit compilationUnit, boolean enableDebug) {
        this.project = project;
        this.problems = problems;
        this.compilationUnit = compilationUnit;
        this.enableDebug = enableDebug;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void writeTo(OutputStream out) {
        this.writeTo(out, null);
    }

    @Override
    public int writeTo(File out) throws FileNotFoundException, IOException {
        return 0;
    }

    @Override
    public void writeTo(OutputStream jsOut, File sourceMapOut) {
        IJSBackend backend = (IJSBackend)JSSharedData.backend;
        JSFilterWriter writer = (JSFilterWriter)backend.createWriterBuffer(this.project);
        IJSEmitter emitter = (IJSEmitter)backend.createEmitter(writer);
        IASBlockWalker walker = backend.createWalker(this.project, this.problems, emitter);
        walker.visitCompilationUnit(this.compilationUnit);
        try {
            jsOut.write(emitter.postProcess(writer.toString()).getBytes());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (sourceMapOut != null) {
            this.convertMappingSourcePathsToRelative(emitter, sourceMapOut);
            File compilationUnitFile = new File(this.compilationUnit.getAbsoluteFilename());
            ISourceMapEmitter sourceMapEmitter = backend.createSourceMapEmitter(emitter);
            try {
                String fileName = compilationUnitFile.getName();
                fileName = fileName.replace(".as", ".js");
                String sourceMap = sourceMapEmitter.emitSourceMap(fileName, sourceMapOut.getAbsolutePath(), null);
                BufferedOutputStream outStream = new BufferedOutputStream(new FileOutputStream(sourceMapOut));
                outStream.write(sourceMap.getBytes());
                outStream.flush();
                outStream.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected void convertMappingSourcePathsToRelative(IJSEmitter emitter, File relativeToFile) {
        List<IJSEmitter.SourceMapMapping> mappings = emitter.getSourceMapMappings();
        for (IJSEmitter.SourceMapMapping mapping : mappings) {
            mapping.sourcePath = this.relativePath(mapping.sourcePath, relativeToFile.getAbsolutePath());
        }
    }

    private String relativePath(String filePath, String relativeToFilePath) {
        File currentFile = new File(filePath);
        Stack<String> stack = new Stack<String>();
        stack.push(currentFile.getName());
        for (currentFile = currentFile.getParentFile(); currentFile != null; currentFile = currentFile.getParentFile()) {
            String absoluteCurrentFile = currentFile.getAbsolutePath() + File.separator;
            if (relativeToFilePath.startsWith(absoluteCurrentFile)) {
                String relativeRelativeToFile = relativeToFilePath.substring(absoluteCurrentFile.length());
                String result = "";
                for (int separatorCount = relativeRelativeToFile.length() - relativeRelativeToFile.replace(File.separator, "").length(); separatorCount > 0; --separatorCount) {
                    result = result + ".." + File.separator;
                }
                while (stack.size() > 0) {
                    result = result + (String)stack.pop();
                }
                return result;
            }
            stack.push(currentFile.getName() + File.separator);
        }
        return null;
    }
}

