/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.codegen.js;

import com.google.debugging.sourcemap.SourceMapGeneratorV3;
import java.io.IOException;
import java.util.List;
import org.apache.flex.compiler.codegen.ISourceMapEmitter;
import org.apache.flex.compiler.codegen.js.IJSEmitter;

public class JSSourceMapEmitter
implements ISourceMapEmitter {
    private IJSEmitter emitter;
    private SourceMapGeneratorV3 sourceMapGenerator;

    public JSSourceMapEmitter(IJSEmitter emitter) {
        this.emitter = emitter;
        this.sourceMapGenerator = new SourceMapGeneratorV3();
    }

    @Override
    public String emitSourceMap(String fileName, String sourceMapPath, String sourceRoot) {
        List<IJSEmitter.SourceMapMapping> mappings = this.emitter.getSourceMapMappings();
        for (IJSEmitter.SourceMapMapping mapping : mappings) {
            this.sourceMapGenerator.addMapping(mapping.sourcePath, mapping.name, mapping.sourceStartPosition, mapping.destStartPosition, mapping.destEndPosition);
        }
        if (sourceRoot != null) {
            this.sourceMapGenerator.setSourceRoot(sourceRoot);
        }
        StringBuilder builder = new StringBuilder();
        try {
            this.sourceMapGenerator.appendTo((Appendable)builder, fileName);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return builder.toString();
    }
}

