/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.codegen.js;

import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.flex.compiler.driver.IBackend;
import org.apache.flex.compiler.internal.workspaces.Workspace;

public class JSSharedData {
    public static final String COMPILER_NAME = "MXMLJSC";
    public static final boolean OUTPUT_TIMESTAMPS = true;
    public static final String COMPILER_VERSION = "329449.1";
    public static final JSSharedData instance = new JSSharedData();
    public static IBackend backend;
    public static String OUTPUT_EXTENSION;
    public static Workspace workspace;
    public static PrintStream STDOUT;
    public static PrintStream STDERR;
    private Boolean m_verbose = false;
    private final ReadWriteLock m_verboseLock = new ReentrantReadWriteLock();
    private Object m_codeGenMonitor = new Object();
    private long m_codeGenCounter = 0L;
    private final ReadWriteLock m_codeGenCounterLock = new ReentrantReadWriteLock();

    public static String now() {
        String DATE_FORMAT_NOW = "yyyy-MM-dd HH:mm:ss";
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf.format(cal.getTime());
    }

    public void stdout(String s) {
        if (STDOUT != null) {
            this.m_verboseLock.writeLock().lock();
            STDOUT.println(s);
            this.m_verboseLock.writeLock().unlock();
        }
    }

    public void stderr(String s) {
        if (STDERR != null) {
            this.m_verboseLock.writeLock().lock();
            STDERR.println(s);
            this.m_verboseLock.writeLock().unlock();
        }
    }

    public void beginCodeGen() {
        this.m_codeGenCounterLock.writeLock().lock();
        ++this.m_codeGenCounter;
        this.m_codeGenCounterLock.writeLock().unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endCodeGen() {
        this.m_codeGenCounterLock.writeLock().lock();
        long currentCounter = --this.m_codeGenCounter;
        this.m_codeGenCounterLock.writeLock().unlock();
        if (currentCounter == 0L) {
            Object object = this.m_codeGenMonitor;
            synchronized (object) {
                this.m_codeGenMonitor.notifyAll();
            }
        }
    }

    public static String getTimeStampString() {
        return "CROSS-COMPILED BY MXMLJSC (329449.1) ON " + JSSharedData.now() + "\n";
    }

    static {
        STDOUT = System.out;
        STDERR = System.err;
    }
}

