/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.codegen.js;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Stack;
import org.apache.flex.compiler.definitions.IClassDefinition;
import org.apache.flex.compiler.tree.as.IFunctionNode;
import org.apache.flex.compiler.tree.as.IGetterNode;
import org.apache.flex.compiler.tree.as.ISetterNode;
import org.apache.flex.compiler.tree.as.IVariableNode;

public class JSSessionModel {
    public static final String CONSTRUCTOR_EMPTY = "emptyConstructor";
    public static final String CONSTRUCTOR_FULL = "fullConstructor";
    public static final String SUPER_FUNCTION_CALL = "replaceSuperFunction";
    private IClassDefinition currentClass;
    private Stack<Context> stack = new Stack();
    public boolean inE4xFilter = false;
    private LinkedHashMap<String, PropertyNodes> propertyMap = new LinkedHashMap();
    private List<String> interfacePropertyMap = new ArrayList<String>();
    private LinkedHashMap<String, PropertyNodes> staticPropertyMap = new LinkedHashMap();
    private ArrayList<String> bindableVars = new ArrayList();
    private ArrayList<IVariableNode> vars = new ArrayList();
    private ArrayList<IFunctionNode> methods = new ArrayList();
    private HashMap<String, String> internalClasses;
    private int foreachLoopCount = 0;

    public IClassDefinition getCurrentClass() {
        return this.currentClass;
    }

    public void setCurrentClass(IClassDefinition currentClass) {
        this.currentClass = currentClass;
    }

    public void pushClass(IClassDefinition currentClass) {
        Context context = new Context();
        context.bindableVars = this.bindableVars;
        context.interfacePropertyMap = this.interfacePropertyMap;
        context.propertyMap = this.propertyMap;
        context.staticPropertyMap = this.staticPropertyMap;
        context.classDefinition = this.currentClass;
        context.vars = this.vars;
        context.methods = this.methods;
        this.stack.push(context);
        this.currentClass = currentClass;
        this.bindableVars = new ArrayList();
        this.staticPropertyMap = new LinkedHashMap();
        this.interfacePropertyMap = new ArrayList<String>();
        this.propertyMap = new LinkedHashMap();
        this.vars = new ArrayList();
        this.methods = new ArrayList();
    }

    public void popClass() {
        Context context = this.stack.pop();
        this.currentClass = context.classDefinition;
        this.bindableVars = context.bindableVars;
        this.staticPropertyMap = context.staticPropertyMap;
        this.propertyMap = context.propertyMap;
        this.interfacePropertyMap = context.interfacePropertyMap;
        this.vars = context.vars;
        this.methods = context.methods;
    }

    public HashMap<String, PropertyNodes> getPropertyMap() {
        return this.propertyMap;
    }

    public List<String> getInterfacePropertyMap() {
        return this.interfacePropertyMap;
    }

    public HashMap<String, PropertyNodes> getStaticPropertyMap() {
        return this.staticPropertyMap;
    }

    public boolean hasBindableVars() {
        return this.bindableVars.size() > 0;
    }

    public List<String> getBindableVars() {
        return this.bindableVars;
    }

    public List<IVariableNode> getVars() {
        return this.vars;
    }

    public List<IFunctionNode> getMethods() {
        return this.methods;
    }

    public HashMap<String, String> getInternalClasses() {
        if (this.internalClasses == null) {
            this.internalClasses = new HashMap();
        }
        return this.internalClasses;
    }

    public boolean isInternalClass(String className) {
        if (this.internalClasses == null) {
            return false;
        }
        return this.internalClasses.containsKey(className);
    }

    public final void incForeachLoopCount() {
        ++this.foreachLoopCount;
    }

    public String getCurrentForeachName() {
        return "foreachiter" + Integer.toString(this.foreachLoopCount);
    }

    private static class Context {
        public LinkedHashMap<String, PropertyNodes> propertyMap;
        public List<String> interfacePropertyMap;
        public LinkedHashMap<String, PropertyNodes> staticPropertyMap;
        public ArrayList<String> bindableVars;
        public ArrayList<IVariableNode> vars;
        public ArrayList<IFunctionNode> methods;
        public IClassDefinition classDefinition;

        private Context() {
        }
    }

    public static class PropertyNodes {
        public IGetterNode getter;
        public ISetterNode setter;
    }
}

