/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.codegen.js;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.flex.compiler.clients.problems.ProblemQuery;
import org.apache.flex.compiler.codegen.js.IJSPublisher;
import org.apache.flex.compiler.config.Configuration;
import org.apache.flex.compiler.internal.codegen.js.JSSharedData;

public class JSPublisher
implements IJSPublisher {
    protected File outputFolder;
    protected File outputParentFolder;
    protected Configuration configuration;

    public JSPublisher(Configuration config) {
        this.configuration = config;
    }

    @Override
    public File getOutputFolder() {
        this.outputFolder = new File(this.getOutputFilePath());
        if (!this.outputFolder.isDirectory()) {
            this.outputFolder = this.outputFolder.getParentFile();
        }
        this.outputParentFolder = this.outputFolder;
        this.setupOutputFolder();
        return this.outputFolder;
    }

    protected void setupOutputFolder() {
        if (this.outputParentFolder.exists()) {
            FileUtils.deleteQuietly((File)this.outputParentFolder);
        }
        if (!this.outputFolder.exists()) {
            this.outputFolder.mkdirs();
        }
    }

    private String getOutputFilePath() {
        if (this.configuration.getOutput() == null) {
            String extension = "." + JSSharedData.OUTPUT_EXTENSION;
            return FilenameUtils.removeExtension((String)this.configuration.getTargetFile()).concat(extension);
        }
        return this.configuration.getOutput();
    }

    @Override
    public boolean publish(ProblemQuery problems) throws IOException {
        System.out.println("The project has been successfully compiled and optimized.");
        return true;
    }
}

