/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.clients;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.flex.compiler.config.Configuration;
import org.apache.flex.compiler.config.ConfigurationValue;
import org.apache.flex.compiler.exceptions.ConfigurationException;
import org.apache.flex.compiler.internal.codegen.externals.pass.ReferenceCompiler;
import org.apache.flex.compiler.internal.codegen.externals.reference.BaseReference;
import org.apache.flex.compiler.internal.codegen.externals.reference.ClassReference;
import org.apache.flex.compiler.internal.codegen.externals.reference.FieldReference;
import org.apache.flex.compiler.internal.codegen.externals.reference.MemberReference;
import org.apache.flex.compiler.internal.config.annotations.Arguments;
import org.apache.flex.compiler.internal.config.annotations.Config;
import org.apache.flex.compiler.internal.config.annotations.InfiniteArguments;
import org.apache.flex.compiler.internal.config.annotations.Mapping;
import org.apache.flex.utils.FilenameNormalization;

public class ExternCConfiguration
extends Configuration {
    private File jsRoot;
    private File asRoot;
    private File asClassRoot;
    private File asInterfaceRoot;
    private File asFunctionRoot;
    private File asConstantRoot;
    private File asTypeDefRoot;
    private File asDuplicatesRoot;
    private List<ReferenceCompiler.ExternalFile> externals = new ArrayList<ReferenceCompiler.ExternalFile>();
    private List<ReferenceCompiler.ExternalFile> externalExterns = new ArrayList<ReferenceCompiler.ExternalFile>();
    private List<String> namedModules = new ArrayList<String>();
    private List<String> classToFunctions = new ArrayList<String>();
    private List<ExcludedMember> excludesClass = new ArrayList<ExcludedMember>();
    private List<ExcludedMember> excludesField = new ArrayList<ExcludedMember>();
    private List<ExcludedMember> excludes = new ArrayList<ExcludedMember>();

    public File getAsRoot() {
        return this.asRoot;
    }

    @Config
    @Mapping(value={"as-root"})
    public void setASRoot(ConfigurationValue cfgval, String filename) throws ConfigurationException.CannotOpen {
        this.setASRoot(new File(FilenameNormalization.normalize((String)this.getOutputPath(cfgval, filename))));
    }

    public void setASRoot(File file) {
        this.asRoot = file;
        this.asClassRoot = new File(this.asRoot, "classes");
        this.asInterfaceRoot = new File(this.asRoot, "interfaces");
        this.asFunctionRoot = new File(this.asRoot, "functions");
        this.asConstantRoot = new File(this.asRoot, "constants");
        this.asTypeDefRoot = new File(this.asRoot, "typedefs");
        this.asDuplicatesRoot = new File(this.asRoot, "duplicates");
    }

    public File getAsClassRoot() {
        return this.asClassRoot;
    }

    public File getAsInterfaceRoot() {
        return this.asInterfaceRoot;
    }

    public File getAsFunctionRoot() {
        return this.asFunctionRoot;
    }

    public File getAsConstantRoot() {
        return this.asConstantRoot;
    }

    public File getAsTypeDefRoot() {
        return this.asTypeDefRoot;
    }

    public File getAsDuplicatesRoot() {
        return this.asDuplicatesRoot;
    }

    public Collection<ReferenceCompiler.ExternalFile> getExternals() {
        return this.externals;
    }

    public Collection<ReferenceCompiler.ExternalFile> getExternalExterns() {
        return this.externalExterns;
    }

    public boolean isClassToFunctions(String className) {
        return this.classToFunctions.contains(className);
    }

    public void addClassToFunction(String className) {
        this.classToFunctions.add(className);
    }

    public void addExternal(File file) throws IOException {
        if (!file.exists()) {
            throw new IOException(file.getAbsolutePath() + " does not exist.");
        }
        this.externals.add(new ReferenceCompiler.ExternalFile(file));
    }

    public void addExternal(String externalFile) throws IOException {
        this.addExternal(new File(FilenameNormalization.normalize((String)externalFile)));
    }

    public void addExternalExtern(File file) throws IOException {
        if (!file.exists()) {
            throw new IOException(file.getAbsolutePath() + " does not exist.");
        }
        this.externalExterns.add(new ReferenceCompiler.ExternalFile(file));
    }

    public void addExternalExtern(String externalFile) throws IOException {
        this.addExternalExtern(new File(FilenameNormalization.normalize((String)externalFile)));
    }

    @Config(allowMultiple=true)
    @Mapping(value={"class-to-function"})
    @Arguments(value={"class"})
    public void setClassToFunctions(ConfigurationValue cfgval, List<String> values) throws ConfigurationException.IncorrectArgumentCount {
        this.addClassToFunction(values.get(0));
    }

    @Config(allowMultiple=true, isPath=true)
    @Mapping(value={"external"})
    @Arguments(value={"path-element"})
    @InfiniteArguments
    public void setExternal(ConfigurationValue cfgval, String[] vals) throws IOException, ConfigurationException.CannotOpen {
        for (String val : vals) {
            this.addExternal(this.resolvePathStrict(val, cfgval));
        }
    }

    @Config(allowMultiple=true, isPath=true)
    @Mapping(value={"external-externs"})
    @Arguments(value={"path-element"})
    @InfiniteArguments
    public void setExternalExterns(ConfigurationValue cfgval, String[] vals) throws IOException, ConfigurationException.CannotOpen {
        for (String val : vals) {
            this.addExternalExtern(this.resolvePathStrict(val, cfgval));
        }
    }

    public boolean isExternalExtern(BaseReference reference) {
        String sourceFileName = reference.getNode().getSourceFileName();
        for (ReferenceCompiler.ExternalFile file : this.externalExterns) {
            if (!sourceFileName.equals("[" + file.getName() + "]")) continue;
            return true;
        }
        return false;
    }

    public ExcludedMember isExcludedClass(ClassReference classReference) {
        for (ExcludedMember memeber : this.excludesClass) {
            if (!memeber.isExcluded(classReference, null)) continue;
            return memeber;
        }
        return null;
    }

    public ExcludedMember isExcludedMember(ClassReference classReference, MemberReference memberReference) {
        if (memberReference instanceof FieldReference) {
            for (ExcludedMember memeber : this.excludesField) {
                if (!memeber.isExcluded(classReference, memberReference)) continue;
                return memeber;
            }
        }
        for (ExcludedMember memeber : this.excludes) {
            if (!memeber.isExcluded(classReference, memberReference)) continue;
            return memeber;
        }
        return null;
    }

    @Config(allowMultiple=true)
    @Mapping(value={"exclude"})
    @Arguments(value={"class", "name"})
    public void setExcludes(ConfigurationValue cfgval, List<String> values) throws ConfigurationException.IncorrectArgumentCount {
        int size = values.size();
        if (size % 2 != 0) {
            throw new ConfigurationException.IncorrectArgumentCount(size + 1, size, cfgval.getVar(), cfgval.getSource(), cfgval.getLine());
        }
        for (int nameIndex = 0; nameIndex < size - 1; nameIndex += 2) {
            String className = values.get(nameIndex);
            String name = values.get(nameIndex + 1);
            this.addExclude(className, name);
        }
    }

    public void addExclude(String className, String name) {
        this.excludes.add(new ExcludedMember(className, name));
    }

    public void addExclude(String className, String name, String description) {
        this.excludes.add(new ExcludedMember(className, name, description));
    }

    @Config(allowMultiple=true)
    @Mapping(value={"field-exclude"})
    @Arguments(value={"class", "field"})
    public void setFieldExcludes(ConfigurationValue cfgval, List<String> values) throws ConfigurationException.IncorrectArgumentCount {
        int size = values.size();
        if (size % 2 != 0) {
            throw new ConfigurationException.IncorrectArgumentCount(size + 1, size, cfgval.getVar(), cfgval.getSource(), cfgval.getLine());
        }
        for (int nameIndex = 0; nameIndex < size - 1; nameIndex += 2) {
            String className = values.get(nameIndex);
            String fieldName = values.get(nameIndex + 1);
            this.addFieldExclude(className, fieldName);
        }
    }

    public void addFieldExclude(String className, String fieldName) {
        this.excludesField.add(new ExcludedMember(className, fieldName, ""));
    }

    @Config(allowMultiple=true)
    @Mapping(value={"class-exclude"})
    @Arguments(value={"class"})
    public void setClassExcludes(ConfigurationValue cfgval, List<String> values) {
        for (String className : values) {
            this.addClassExclude(className);
        }
    }

    public void addClassExclude(String className) {
        this.excludesClass.add(new ExcludedMember(className, null, ""));
    }

    @Config(allowMultiple=true)
    @Mapping(value={"named-module"})
    @Arguments(value={"module"})
    @InfiniteArguments
    public void setNamedModules(ConfigurationValue cfgval, List<String> values) {
        for (String moduleName : values) {
            this.addNamedModule(moduleName);
        }
    }

    public void addNamedModule(String moduleName) {
        this.namedModules.add(moduleName);
    }

    public String isNamedModule(ClassReference classReference) {
        String basePackageName = classReference.getPackageName();
        int packageIndex = basePackageName.indexOf(".");
        if (packageIndex != -1) {
            basePackageName = basePackageName.substring(0, packageIndex);
        }
        Iterator<String> i$ = this.namedModules.iterator();
        while (i$.hasNext()) {
            String module;
            String camelCaseModule = module = i$.next();
            int moduleIndex = camelCaseModule.indexOf("-");
            while (moduleIndex != -1 && moduleIndex < camelCaseModule.length() - 1) {
                camelCaseModule = camelCaseModule.substring(0, moduleIndex) + camelCaseModule.substring(moduleIndex + 1, moduleIndex + 2).toUpperCase() + camelCaseModule.substring(moduleIndex + 2);
                moduleIndex = camelCaseModule.indexOf("-");
            }
            if (!(basePackageName.length() == 0 ? classReference.getBaseName().equals(camelCaseModule) : basePackageName.equals(camelCaseModule))) continue;
            return module;
        }
        return null;
    }

    public File getJsRoot() {
        return this.jsRoot;
    }

    @Config
    @Mapping(value={"js-root"})
    public void setJSRoot(ConfigurationValue cfgval, String filename) throws ConfigurationException.CannotOpen {
        this.jsRoot = new File(filename);
    }

    public static class ExcludedMember {
        private String className;
        private String name;
        private String description;

        public String getClassName() {
            return this.className;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public ExcludedMember(String className, String name) {
            this.className = className;
            this.name = name;
        }

        public ExcludedMember(String className, String name, String description) {
            this.className = className;
            this.name = name;
            this.description = description;
        }

        public boolean isExcluded(ClassReference classReference, MemberReference memberReference) {
            if (memberReference == null) {
                return classReference.getQualifiedName().equals(this.className);
            }
            return classReference.getQualifiedName().equals(this.className) && memberReference.getQualifiedName().equals(this.name);
        }

        public void print(StringBuilder sb) {
            if (this.description != null) {
                sb.append("// " + this.description + "\n");
            }
            sb.append("//");
        }
    }
}

