/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.clients;

import com.google.javascript.jscomp.Result;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.flex.compiler.clients.ExternCConfiguration;
import org.apache.flex.compiler.config.Configurator;
import org.apache.flex.compiler.internal.codegen.externals.emit.ReferenceEmitter;
import org.apache.flex.compiler.internal.codegen.externals.pass.ReferenceCompiler;
import org.apache.flex.compiler.internal.codegen.externals.reference.ReferenceModel;
import org.apache.flex.compiler.internal.codegen.js.JSSharedData;
import org.apache.flex.compiler.problems.ICompilerProblem;
import org.apache.flex.compiler.targets.ITarget;
import org.apache.flex.tools.FlexTool;

public class EXTERNC
implements FlexTool {
    protected Configurator projectConfigurator;
    private ExternCConfiguration configuration;
    private ReferenceModel model;
    private ReferenceCompiler compiler;
    private ReferenceEmitter emitter;

    public ReferenceModel getModel() {
        return this.model;
    }

    public ReferenceCompiler getCompiler() {
        return this.compiler;
    }

    public ReferenceEmitter getEmitter() {
        return this.emitter;
    }

    public EXTERNC() {
    }

    public EXTERNC(ExternCConfiguration configuration) {
        this.configure(configuration);
    }

    public void configure(String[] args) {
        this.projectConfigurator = this.createConfigurator();
        this.projectConfigurator.setConfiguration(args, "external", false);
        this.projectConfigurator.getTargetSettings(ITarget.TargetType.SWC);
        this.configure((ExternCConfiguration)this.projectConfigurator.getConfiguration());
    }

    public void configure(ExternCConfiguration configuration) {
        this.configuration = configuration;
        this.model = new ReferenceModel(configuration);
        this.compiler = new ReferenceCompiler(this.model);
        this.emitter = new ReferenceEmitter(this.model);
    }

    protected Configurator createConfigurator() {
        return new Configurator(ExternCConfiguration.class);
    }

    public static void main(String[] args) {
        int exitCode = EXTERNC.staticMainNoExit(args);
        System.exit(exitCode);
    }

    public static int staticMainNoExit(String[] args) {
        long startTime = System.nanoTime();
        EXTERNC compiler = new EXTERNC();
        compiler.configure(args);
        HashSet<ICompilerProblem> problems = new HashSet<ICompilerProblem>();
        int exitCode = compiler.mainNoExit(args, problems, true);
        long endTime = System.nanoTime();
        JSSharedData.instance.stdout((double)(endTime - startTime) / 1.0E9 + " seconds");
        return exitCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int mainNoExit(String[] args, Set<ICompilerProblem> problems, Boolean printProblems) {
        int exitCode = -1;
        try {
            this.cleanOutput();
            this.compile();
            this.emit();
        }
        catch (IOException e) {
            JSSharedData.instance.stderr(e.toString());
        }
        finally {
            if (problems == null || problems.isEmpty() || printProblems.booleanValue()) {
                // empty if block
            }
        }
        return exitCode;
    }

    public void cleanOutput() throws IOException {
        FileUtils.deleteDirectory((File)this.configuration.getAsRoot());
    }

    public void emit() throws IOException {
        this.emitter.emit();
    }

    public Result compile() throws IOException {
        return this.compiler.compile();
    }

    public String getName() {
        return "EXTERNC";
    }

    public int execute(String[] args) {
        EXTERNC generator = new EXTERNC();
        generator.configure(args);
        try {
            generator.cleanOutput();
            generator.compile();
            generator.emit();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return 0;
    }

    static enum ExitCode {
        SUCCESS(0),
        PRINT_HELP(1),
        FAILED_WITH_PROBLEMS(2),
        FAILED_WITH_EXCEPTIONS(3),
        FAILED_WITH_CONFIG_PROBLEMS(4);

        final int code;

        private ExitCode(int code) {
            this.code = code;
        }
    }
}

