/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.clients;

import com.google.common.collect.ImmutableList;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.apache.flex.compiler.clients.MXMLJSC;
import org.apache.flex.compiler.codegen.as.IASWriter;
import org.apache.flex.compiler.driver.IBackend;
import org.apache.flex.compiler.driver.js.IJSApplication;
import org.apache.flex.compiler.exceptions.ConfigurationException;
import org.apache.flex.compiler.internal.codegen.js.JSSharedData;
import org.apache.flex.compiler.internal.driver.as.ASBackend;
import org.apache.flex.compiler.internal.driver.js.amd.AMDBackend;
import org.apache.flex.compiler.internal.driver.js.goog.GoogBackend;
import org.apache.flex.compiler.internal.driver.mxml.flexjs.MXMLFlexJSSWCBackend;
import org.apache.flex.compiler.internal.driver.mxml.jsc.MXMLJSCJSSWCBackend;
import org.apache.flex.compiler.internal.driver.mxml.vf2js.MXMLVF2JSSWCBackend;
import org.apache.flex.compiler.internal.projects.CompilerProject;
import org.apache.flex.compiler.internal.targets.FlexJSSWCTarget;
import org.apache.flex.compiler.internal.targets.JSTarget;
import org.apache.flex.compiler.problems.ICompilerProblem;
import org.apache.flex.compiler.problems.InternalCompilerProblem;
import org.apache.flex.compiler.problems.UnableToBuildSWFProblem;
import org.apache.flex.compiler.projects.IASProject;
import org.apache.flex.compiler.targets.ITarget;
import org.apache.flex.compiler.targets.ITargetSettings;
import org.apache.flex.compiler.units.ICompilationUnit;

public class COMPJSC
extends MXMLJSC {
    @Override
    public String getName() {
        return "COMPC";
    }

    @Override
    public int execute(String[] args) {
        return COMPJSC.staticMainNoExit(args);
    }

    public static void main(String[] args) {
        int exitCode = COMPJSC.staticMainNoExit(args);
        System.exit(exitCode);
    }

    public static int staticMainNoExit(String[] args) {
        long startTime = System.nanoTime();
        IBackend backend = new ASBackend();
        block7: for (String s : args) {
            if (!s.contains("-js-output-type")) continue;
            jsOutputType = MXMLJSC.JSOutputType.fromString(s.split("=")[1]);
            switch (jsOutputType) {
                case AMD: {
                    backend = new AMDBackend();
                    continue block7;
                }
                case JSC: {
                    backend = new MXMLJSCJSSWCBackend();
                    continue block7;
                }
                case FLEXJS: 
                case FLEXJS_DUAL: {
                    backend = new MXMLFlexJSSWCBackend();
                    continue block7;
                }
                case GOOG: {
                    backend = new GoogBackend();
                    continue block7;
                }
                case VF2JS: {
                    backend = new MXMLVF2JSSWCBackend();
                    continue block7;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
        }
        COMPJSC mxmlc = new COMPJSC(backend);
        ArrayList<ICompilerProblem> problems = new ArrayList<ICompilerProblem>();
        int exitCode = mxmlc.mainNoExit(args, problems, true);
        long endTime = System.nanoTime();
        JSSharedData.instance.stdout((double)(endTime - startTime) / 1.0E9 + " seconds");
        return exitCode;
    }

    public COMPJSC(IBackend backend) {
        super(backend);
    }

    @Override
    protected boolean compile() {
        boolean compilationSuccess = false;
        try {
            this.project.getSourceCompilationUnitFactory().addHandler(this.asFileHandler);
            if (this.setupTargetFile()) {
                this.buildArtifact();
            }
            if (this.jsTarget != null) {
                ArrayList errors = new ArrayList();
                ArrayList warnings = new ArrayList();
                if (!this.config.getCreateTargetWithErrors()) {
                    this.problems.getErrorsAndWarnings(errors, warnings);
                    if (errors.size() > 0) {
                        return false;
                    }
                }
                File outputFolder = new File(this.getOutputFilePath());
                Set externs = this.config.getExterns();
                ImmutableList roots = ((FlexJSSWCTarget)this.target).getReachableCompilationUnits(errors);
                List reachableCompilationUnits = this.project.getReachableCompilationUnitsInSWFOrder((Collection)roots);
                for (ICompilationUnit cu : reachableCompilationUnits) {
                    String symbol;
                    ICompilationUnit.UnitType cuType = cu.getCompilationUnitType();
                    if (cuType != ICompilationUnit.UnitType.AS_UNIT && cuType != ICompilationUnit.UnitType.MXML_UNIT || externs.contains(symbol = (String)cu.getQualifiedNames().get(0))) continue;
                    File outputClassFile = this.getOutputClassFile((String)cu.getQualifiedNames().get(0), outputFolder);
                    System.out.println("Compiling file: " + outputClassFile);
                    ICompilationUnit unit = cu;
                    IASWriter writer = cuType == ICompilationUnit.UnitType.AS_UNIT ? JSSharedData.backend.createWriter((IASProject)this.project, errors, unit, false) : JSSharedData.backend.createMXMLWriter((IASProject)this.project, errors, unit, false);
                    this.problems.addAll(errors);
                    BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(outputClassFile));
                    writer.writeTo(out);
                    out.flush();
                    out.close();
                    writer.close();
                }
                compilationSuccess = true;
            }
        }
        catch (Exception e) {
            InternalCompilerProblem problem = new InternalCompilerProblem(e);
            this.problems.add((ICompilerProblem)problem);
        }
        return compilationSuccess;
    }

    @Override
    protected void buildArtifact() throws InterruptedException, IOException, ConfigurationException {
        this.jsTarget = this.buildJSTarget();
    }

    private IJSApplication buildJSTarget() throws InterruptedException, FileNotFoundException, ConfigurationException {
        ArrayList<ICompilerProblem> problemsBuildingSWF = new ArrayList<ICompilerProblem>();
        IJSApplication app = this.buildApplication((CompilerProject)this.project, this.config.getMainDefinition(), null, problemsBuildingSWF);
        this.problems.addAll(problemsBuildingSWF);
        if (app == null) {
            UnableToBuildSWFProblem problem = new UnableToBuildSWFProblem(this.getOutputFilePath());
            this.problems.add((ICompilerProblem)problem);
        }
        return app;
    }

    private IJSApplication buildApplication(CompilerProject applicationProject, String rootClassName, ICompilationUnit mainCU, Collection<ICompilerProblem> problems) throws InterruptedException, ConfigurationException, FileNotFoundException {
        Collection fatalProblems = applicationProject.getFatalProblems();
        if (!fatalProblems.isEmpty()) {
            problems.addAll(fatalProblems);
            return null;
        }
        return ((JSTarget)this.target).build(mainCU, problems);
    }

    private String getOutputFilePath() {
        if (this.config.getOutput() == null) {
            String extension = "." + JSSharedData.OUTPUT_EXTENSION;
            return FilenameUtils.removeExtension((String)this.config.getTargetFile()).concat(extension);
        }
        String outputFolderName = this.config.getOutput();
        if (outputFolderName.endsWith(".swc")) {
            File outputFolder = new File(outputFolderName);
            outputFolderName = outputFolder.getParent();
        }
        return outputFolderName;
    }

    private File getOutputClassFile(String qname, File outputFolder) {
        String[] cname = qname.split("\\.");
        String sdirPath = outputFolder + File.separator;
        if (cname.length > 0) {
            int n = cname.length - 1;
            for (int i = 0; i < n; ++i) {
                sdirPath = sdirPath + cname[i] + File.separator;
            }
            File sdir = new File(sdirPath);
            if (!sdir.exists()) {
                sdir.mkdirs();
            }
            qname = cname[cname.length - 1];
        }
        return new File(sdirPath + qname + "." + JSSharedData.OUTPUT_EXTENSION);
    }

    @Override
    protected boolean setupTargetFile() throws InterruptedException {
        this.config.getTargetFile();
        ITargetSettings settings = this.getTargetSettings();
        if (settings == null) {
            return false;
        }
        this.project.setTargetSettings(settings);
        this.target = JSSharedData.backend.createTarget((IASProject)this.project, this.getTargetSettings(), null);
        return true;
    }

    private ITargetSettings getTargetSettings() {
        if (this.targetSettings == null) {
            this.targetSettings = this.projectConfigurator.getTargetSettings(this.getTargetType());
        }
        if (this.targetSettings == null) {
            this.problems.addAll((Iterable)this.projectConfigurator.getConfigurationProblems());
        }
        return this.targetSettings;
    }

    @Override
    protected void validateTargetFile() throws ConfigurationException {
    }

    protected String getProgramName() {
        return "compc";
    }

    protected boolean isCompc() {
        return true;
    }

    @Override
    protected ITarget.TargetType getTargetType() {
        return ITarget.TargetType.SWC;
    }

    static enum ExitCode {
        SUCCESS(0),
        PRINT_HELP(1),
        FAILED_WITH_PROBLEMS(2),
        FAILED_WITH_EXCEPTIONS(3),
        FAILED_WITH_CONFIG_PROBLEMS(4);

        final int code;

        private ExitCode(int code) {
            this.code = code;
        }
    }
}

