/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.swf.io;

import com.google.common.collect.ImmutableList;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.flex.abc.ABCParser;
import org.apache.flex.abc.print.ABCDumpVisitor;
import org.apache.flex.compiler.clients.problems.CompilerProblemCategorizer;
import org.apache.flex.compiler.clients.problems.ProblemPrinter;
import org.apache.flex.compiler.clients.problems.ProblemQuery;
import org.apache.flex.compiler.clients.problems.WorkspaceProblemFormatter;
import org.apache.flex.compiler.common.VersionInfo;
import org.apache.flex.compiler.internal.workspaces.Workspace;
import org.apache.flex.compiler.problems.ICompilerProblem;
import org.apache.flex.swf.Header;
import org.apache.flex.swf.SWF;
import org.apache.flex.swf.SWFFrame;
import org.apache.flex.swf.TagType;
import org.apache.flex.swf.io.SWFReader;
import org.apache.flex.swf.io.SWFWriter;
import org.apache.flex.swf.tags.CSMTextSettingsTag;
import org.apache.flex.swf.tags.DefineBinaryDataTag;
import org.apache.flex.swf.tags.DefineBitsJPEG3Tag;
import org.apache.flex.swf.tags.DefineBitsLossless2Tag;
import org.apache.flex.swf.tags.DefineBitsLosslessTag;
import org.apache.flex.swf.tags.DefineBitsTag;
import org.apache.flex.swf.tags.DefineButton2Tag;
import org.apache.flex.swf.tags.DefineButtonCxformTag;
import org.apache.flex.swf.tags.DefineButtonSoundTag;
import org.apache.flex.swf.tags.DefineButtonTag;
import org.apache.flex.swf.tags.DefineEditTextTag;
import org.apache.flex.swf.tags.DefineFont2Tag;
import org.apache.flex.swf.tags.DefineFont3Tag;
import org.apache.flex.swf.tags.DefineFont4Tag;
import org.apache.flex.swf.tags.DefineFontAlignZonesTag;
import org.apache.flex.swf.tags.DefineFontInfoTag;
import org.apache.flex.swf.tags.DefineFontNameTag;
import org.apache.flex.swf.tags.DefineFontTag;
import org.apache.flex.swf.tags.DefineMorphShape2Tag;
import org.apache.flex.swf.tags.DefineMorphShapeTag;
import org.apache.flex.swf.tags.DefineScalingGridTag;
import org.apache.flex.swf.tags.DefineShape3Tag;
import org.apache.flex.swf.tags.DefineShape4Tag;
import org.apache.flex.swf.tags.DefineShapeTag;
import org.apache.flex.swf.tags.DefineSoundTag;
import org.apache.flex.swf.tags.DefineSpriteTag;
import org.apache.flex.swf.tags.DefineTextTag;
import org.apache.flex.swf.tags.DefineVideoStreamTag;
import org.apache.flex.swf.tags.DoABCTag;
import org.apache.flex.swf.tags.EnableDebugger2Tag;
import org.apache.flex.swf.tags.EnableTelemetryTag;
import org.apache.flex.swf.tags.ExportAssetsTag;
import org.apache.flex.swf.tags.FileAttributesTag;
import org.apache.flex.swf.tags.FrameLabelTag;
import org.apache.flex.swf.tags.ICharacterTag;
import org.apache.flex.swf.tags.ITag;
import org.apache.flex.swf.tags.MetadataTag;
import org.apache.flex.swf.tags.PlaceObject2Tag;
import org.apache.flex.swf.tags.PlaceObject3Tag;
import org.apache.flex.swf.tags.PlaceObjectTag;
import org.apache.flex.swf.tags.ProductInfoTag;
import org.apache.flex.swf.tags.RawTag;
import org.apache.flex.swf.tags.RemoveObject2Tag;
import org.apache.flex.swf.tags.RemoveObjectTag;
import org.apache.flex.swf.tags.ScriptLimitsTag;
import org.apache.flex.swf.tags.SetBackgroundColorTag;
import org.apache.flex.swf.tags.SetTabIndexTag;
import org.apache.flex.swf.tags.ShowFrameTag;
import org.apache.flex.swf.tags.SoundStreamBlockTag;
import org.apache.flex.swf.tags.SoundStreamHeadTag;
import org.apache.flex.swf.tags.StartSoundTag;
import org.apache.flex.swf.tags.SymbolClassTag;
import org.apache.flex.swf.tags.Tag;
import org.apache.flex.swf.tags.VideoFrameTag;
import org.apache.flex.swf.types.ButtonRecord;
import org.apache.flex.swf.types.CurvedEdgeRecord;
import org.apache.flex.swf.types.EdgeRecord;
import org.apache.flex.swf.types.FillStyle;
import org.apache.flex.swf.types.FillStyleArray;
import org.apache.flex.swf.types.Filter;
import org.apache.flex.swf.types.FocalGradient;
import org.apache.flex.swf.types.GlyphEntry;
import org.apache.flex.swf.types.GradRecord;
import org.apache.flex.swf.types.IFillStyle;
import org.apache.flex.swf.types.ILineStyle;
import org.apache.flex.swf.types.KerningRecord;
import org.apache.flex.swf.types.LineStyle;
import org.apache.flex.swf.types.LineStyle2;
import org.apache.flex.swf.types.LineStyleArray;
import org.apache.flex.swf.types.MorphFillStyle;
import org.apache.flex.swf.types.MorphGradRecord;
import org.apache.flex.swf.types.MorphLineStyle;
import org.apache.flex.swf.types.RGB;
import org.apache.flex.swf.types.RGBA;
import org.apache.flex.swf.types.Shape;
import org.apache.flex.swf.types.ShapeRecord;
import org.apache.flex.swf.types.ShapeWithStyle;
import org.apache.flex.swf.types.SoundEnvelope;
import org.apache.flex.swf.types.SoundInfo;
import org.apache.flex.swf.types.StraightEdgeRecord;
import org.apache.flex.swf.types.StyleChangeRecord;
import org.apache.flex.swf.types.Styles;
import org.apache.flex.swf.types.TextRecord;
import org.apache.flex.swf.types.ZoneRecord;
import org.apache.flex.utils.Base64;
import org.apache.flex.utils.Trace;

public final class SWFDump {
    private Integer swfVersion = null;
    private boolean abc = false;
    private boolean showActions = true;
    private boolean showOffset = false;
    private boolean showByteCode = false;
    private boolean showDebugSource = false;
    private boolean glyphs = true;
    private boolean external = false;
    private String externalPrefix = null;
    private String externalDirectory = null;
    private boolean decompile;
    private boolean defunc;
    private int indent = 0;
    private boolean tabbedGlyphs = true;
    private SWF swf;
    private final PrintWriter out;
    private SWFFrame currentFrame;
    private int currentFrameIndex;
    static final char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    static boolean abcOption = false;
    static boolean encodeOption = false;
    static boolean showActionsOption = true;
    static boolean showOffsetOption = false;
    static boolean showByteCodeOption = false;
    static boolean showDebugSourceOption = false;
    static boolean glyphsOption = true;
    static boolean externalOption = false;
    static boolean decompileOption = true;
    static boolean defuncOption = true;
    static boolean saveOption = false;
    static boolean tabbedGlyphsOption = true;
    static boolean uncompressOption = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(URL url) throws IOException {
        SWFReader swfReader = new SWFReader();
        String path = url.getPath();
        try {
            this.swf = (SWF)swfReader.readFrom(new BufferedInputStream(url.openStream()), path);
            ProblemQuery problemQuery = new ProblemQuery();
            problemQuery.addAll(swfReader.getProblems());
            if (!problemQuery.hasErrors()) {
                this.dumpHeader(this.swf.getHeader());
                ImmutableList tags = ImmutableList.copyOf(swfReader.iterator());
                this.currentFrameIndex = 0;
                if (this.swf.getFrameCount() > 0) {
                    this.currentFrame = this.swf.getFrameAt(0);
                }
                for (ITag tag : tags) {
                    this.dumpTag(tag);
                    if (tag.getTagType() != TagType.ShowFrame) continue;
                    ++this.currentFrameIndex;
                    if (this.currentFrameIndex >= this.swf.getFrameCount()) continue;
                    this.currentFrame = this.swf.getFrameAt(this.currentFrameIndex);
                }
                this.finish();
            }
            this.printProblems(swfReader.getProblems());
        }
        finally {
            IOUtils.closeQuietly((Closeable)swfReader);
        }
    }

    private void printProblems(Collection<ICompilerProblem> problems) {
        CompilerProblemCategorizer categorizer = new CompilerProblemCategorizer();
        WorkspaceProblemFormatter formatter = new WorkspaceProblemFormatter(new Workspace(), categorizer);
        ProblemPrinter printer = new ProblemPrinter(formatter, System.err);
        printer.printProblems(problems);
    }

    private void dumpTag(ITag tag) {
        TagType type = tag.getTagType();
        switch (type) {
            case CSMTextSettings: {
                this.dumpCSMTextSettings((CSMTextSettingsTag)tag);
                break;
            }
            case DoABC: {
                this.dumpDoABC((DoABCTag)tag);
                break;
            }
            case DefineBinaryData: {
                this.dumpDefineBinaryData((DefineBinaryDataTag)tag);
                break;
            }
            case DefineBits: {
                this.dumpDefineBits((DefineBitsTag)tag);
                break;
            }
            case DefineBitsJPEG2: {
                this.dumpDefineBitsJPEG2((DefineBitsTag)tag);
                break;
            }
            case DefineBitsJPEG3: {
                this.dumpDefineBitsJPEG3((DefineBitsJPEG3Tag)tag);
                break;
            }
            case DefineBitsLossless: {
                this.dumpDefineBitsLossless((DefineBitsLosslessTag)tag);
                break;
            }
            case DefineBitsLossless2: {
                this.dumpDefineBitsLossless2((DefineBitsLossless2Tag)tag);
                break;
            }
            case DefineScalingGrid: {
                this.dumpDefineScalingGrid((DefineScalingGridTag)tag);
                break;
            }
            case DefineShape: {
                this.dumpDefineShape((DefineShapeTag)tag);
                break;
            }
            case DefineShape2: {
                this.dumpDefineShape2((DefineShapeTag)tag);
                break;
            }
            case DefineShape3: {
                this.dumpDefineShape3((DefineShape3Tag)tag);
                break;
            }
            case DefineShape4: {
                this.dumpDefineShape4((DefineShape4Tag)tag);
                break;
            }
            case DefineSprite: {
                this.dumpDefineSprite((DefineSpriteTag)tag);
                break;
            }
            case DefineSound: {
                this.dumpDefineSound((DefineSoundTag)tag);
                break;
            }
            case StartSound: {
                this.dumpStartSound((StartSoundTag)tag);
                break;
            }
            case StartSound2: {
                break;
            }
            case SoundStreamHead: {
                this.dumpSoundStreamHead((SoundStreamHeadTag)tag);
                break;
            }
            case SoundStreamHead2: {
                this.dumpSoundStreamHead2((SoundStreamHeadTag)tag);
                break;
            }
            case SoundStreamBlock: {
                this.dumpSoundStreamBlock((SoundStreamBlockTag)tag);
                break;
            }
            case DefineMorphShape: {
                this.dumpDefineMorphShape((DefineMorphShapeTag)tag);
                break;
            }
            case DefineMorphShape2: {
                this.dumpDefineMorphShape2((DefineMorphShapeTag)tag);
                break;
            }
            case DefineSceneAndFrameLabelData: {
                break;
            }
            case DefineFont: {
                this.dumpDefineFont((DefineFontTag)tag);
                break;
            }
            case DefineFontInfo: {
                this.dumpDefineFontInfo((DefineFontInfoTag)tag);
                break;
            }
            case DefineFont2: {
                this.dumpDefineFont2((DefineFont2Tag)tag);
                break;
            }
            case DefineFont3: {
                this.dumpDefineFont3((DefineFont3Tag)tag);
                break;
            }
            case DefineFont4: {
                this.dumpDefineFont4((DefineFont4Tag)tag);
                break;
            }
            case DefineFontAlignZones: {
                this.dumpDefineFontAlignZones((DefineFontAlignZonesTag)tag);
                break;
            }
            case DefineFontName: {
                this.dumpDefineFontName((DefineFontNameTag)tag);
                break;
            }
            case DefineText: {
                this.dumpDefineText((DefineTextTag)tag);
                break;
            }
            case DefineText2: {
                this.dumpDefineText((DefineTextTag)tag);
                break;
            }
            case DefineEditText: {
                this.dumpDefineEditText((DefineEditTextTag)tag);
                break;
            }
            case DefineButton: {
                this.dumpDefineButton((DefineButtonTag)tag);
                break;
            }
            case DefineButton2: {
                this.dumpDefineButton2((DefineButton2Tag)tag);
                break;
            }
            case DefineButtonSound: {
                this.dumpDefineButtonSound((DefineButtonSoundTag)tag);
                break;
            }
            case DefineVideoStream: {
                this.dumpDefineVideoStream((DefineVideoStreamTag)tag);
                break;
            }
            case VideoFrame: {
                this.dumpVideoFrame((VideoFrameTag)tag);
                break;
            }
            case End: {
                break;
            }
            case EnableDebugger2: {
                this.dumpEnableDebugger2((EnableDebugger2Tag)tag);
                break;
            }
            case ExportAssets: {
                this.dumpExportAssets((ExportAssetsTag)tag);
                break;
            }
            case FileAttributes: {
                this.dumpFileAttributes((FileAttributesTag)tag);
                break;
            }
            case FrameLabel: {
                this.dumpFrameLabel((FrameLabelTag)tag);
                break;
            }
            case JPEGTables: {
                break;
            }
            case Metadata: {
                this.dumpMetadata((MetadataTag)tag);
                break;
            }
            case ProductInfo: {
                this.dumpProductInfo((ProductInfoTag)tag);
                break;
            }
            case PlaceObject: {
                this.dumpPlaceObject((PlaceObjectTag)tag);
                break;
            }
            case PlaceObject2: {
                this.dumpPlaceObject2((PlaceObjectTag)tag);
                break;
            }
            case PlaceObject3: {
                this.dumpPlaceObject3((PlaceObjectTag)tag);
                break;
            }
            case RemoveObject: {
                this.dumpRemoveObject((RemoveObjectTag)tag);
                break;
            }
            case RemoveObject2: {
                this.dumpRemoveObject2((RemoveObject2Tag)tag);
                break;
            }
            case ScriptLimits: {
                this.dumpScriptLimits((ScriptLimitsTag)tag);
                break;
            }
            case SetBackgroundColor: {
                this.dumpSetBackgroundColor((SetBackgroundColorTag)tag);
                break;
            }
            case SetTabIndex: {
                this.dumpSetTabIndex((SetTabIndexTag)tag);
                break;
            }
            case ShowFrame: {
                this.dumpShowFrame((ShowFrameTag)tag);
                break;
            }
            case SymbolClass: {
                this.dumpSymbolClass((SymbolClassTag)tag);
                break;
            }
            case EnableTelemetry: {
                this.dumpEnableTelemetry((EnableTelemetryTag)tag);
                break;
            }
            default: {
                assert (tag instanceof RawTag);
                if (!(tag instanceof RawTag)) break;
                this.dumpRawTag((RawTag)tag);
            }
        }
    }

    public SWFDump(PrintWriter out) {
        this.out = out;
    }

    private void setExternal(boolean b, String path) {
        this.external = b;
        if (this.external) {
            if (path != null) {
                this.externalPrefix = SWFDump.baseName(path);
                this.externalDirectory = SWFDump.dirName(path);
            }
            this.externalPrefix = this.externalPrefix == null ? "" : this.externalPrefix + "-";
            if (this.externalDirectory == null) {
                this.externalDirectory = "";
            }
        }
    }

    private void indent() {
        for (int i = 0; i < this.indent; ++i) {
            this.out.print("  ");
        }
    }

    public void dumpHeader(Header h) {
        this.swfVersion = h.getVersion();
        this.out.println("<swf xmlns=\"http://macromedia/2003/swfx\" version=\"" + h.getVersion() + "\"" + " framerate=\"" + h.getFrameRate() + "\"" + " size=\"" + h.getFrameSize().getWidth() + "x" + h.getFrameSize().getHeight() + "\"" + " compressed=\"" + (h.getCompression() != Header.Compression.NONE) + "\"" + " >");
        ++this.indent;
        this.indent();
        this.out.println("<!-- framecount=" + h.getFrameCount() + " length=" + h.getLength() + " -->");
    }

    public void dumpProductInfo(ProductInfoTag productInfo) {
        this.open(productInfo);
        this.out.print(" product=\"" + (Object)((Object)productInfo.getProduct()) + "\"");
        this.out.print(" edition=\"" + (Object)((Object)productInfo.getEdition()) + "\"");
        this.out.print(" version=\"" + productInfo.getMajorVersion() + "." + productInfo.getMinorVersion() + "\"");
        this.out.print(" build=\"" + productInfo.getBuild() + "\"");
        this.out.print(" compileDate=\"" + DateFormat.getInstance().format(new Date(productInfo.getCompileDate())) + "\"");
        this.close();
    }

    public void dumpMetadata(MetadataTag tag) {
        this.open(tag);
        this.end();
        this.indent();
        this.openCDATA();
        this.out.println(tag.getMetadata());
        this.closeCDATA();
        this.close(tag);
    }

    public void dumpFileAttributes(FileAttributesTag tag) {
        this.open(tag);
        this.out.print(" useDirectBlit=\"" + tag.isUseDirectBlit() + "\"");
        this.out.print(" useGPU=\"" + tag.isUseGPU() + "\"");
        this.out.print(" hasMetadata=\"" + tag.isHasMetadata() + "\"");
        this.out.print(" actionScript3=\"" + tag.isAS3() + "\"");
        this.out.print(" suppressCrossDomainCaching=\"" + tag.isSuppressCrossDomainCaching() + "\"");
        this.out.print(" swfRelativeUrls=\"" + tag.isSWFRelativeURLs() + "\"");
        this.out.print(" useNetwork=\"" + tag.isUseNetwork() + "\"");
        this.close();
    }

    public String id(ICharacterTag tag) {
        return String.valueOf(tag.getCharacterID());
    }

    public void setOffsetAndSize(int offset, int size) {
        if (this.showOffset) {
            this.indent();
            this.out.println("<!-- offset=" + offset + " size=" + size + " -->");
        }
    }

    private void open(ITag tag) {
        this.indent();
        this.out.print("<" + tag.getTagType().toString());
    }

    private void end() {
        this.out.println(">");
        ++this.indent;
    }

    private void openCDATA() {
        this.indent();
        this.out.print("<![CDATA[");
    }

    private void closeCDATA() {
        this.out.println("]]>");
    }

    private void close() {
        this.out.println("/>");
    }

    private void close(Tag tag) {
        --this.indent;
        this.indent();
        this.out.println("</" + tag.getTagType().toString() + ">");
    }

    public void error(String s) {
        this.indent();
        this.out.println("<!-- error: " + s + " -->");
    }

    public void dumpRawTag(RawTag tag) {
        this.indent();
        this.out.println("<!-- unknown tag=" + tag.getTagType().getValue() + " length=" + (tag.getTagBody() != null ? tag.getTagBody().length : 0) + " -->");
    }

    public void dumpShowFrame(ShowFrameTag tag) {
        this.open(tag);
        this.close();
    }

    public void dumpDefineShape(DefineShapeTag tag) {
        this.printDefineShape(tag);
    }

    private void printDefineShape(DefineShapeTag tag) {
        this.open(tag);
        this.out.print(" id=\"" + this.id(tag) + "\"");
        this.out.print(" bounds=\"" + tag.getShapeBounds() + "\"");
        if (tag.getTagType() == TagType.DefineShape4) {
            DefineShape4Tag shape4Tag = (DefineShape4Tag)tag;
            this.out.print(" edgebounds=\"" + shape4Tag.getEdgeBounds() + "\"");
            this.out.print(" usesNonScalingStrokes=\"" + shape4Tag.isUsesNonScalingStrokes() + "\"");
            this.out.print(" usesScalingStrokes=\"" + shape4Tag.isUsesScalingStrokes() + "\"");
        }
        this.end();
        this.printShapeWithStyles(tag.getShapes());
        this.close(tag);
    }

    public String printColor(RGB color) {
        StringBuilder b = new StringBuilder();
        b.append('#');
        short red = color.getRed();
        b.append(digits[red >> 4 & 0xF]);
        b.append(digits[red & 0xF]);
        short green = color.getGreen();
        b.append(digits[green >> 4 & 0xF]);
        b.append(digits[green & 0xF]);
        short blue = color.getBlue();
        b.append(digits[blue >> 4 & 0xF]);
        b.append(digits[blue & 0xF]);
        if (color instanceof RGBA) {
            short alpha = ((RGBA)color).getAlpha();
            b.append(digits[alpha >> 4 & 0xF]);
            b.append(digits[alpha & 0xF]);
        }
        return b.toString();
    }

    public void dumpPlaceObject(PlaceObjectTag tag) {
        this.open(tag);
        this.out.print(" idref=\"" + this.idRef(tag.getCharacter()) + "\"");
        this.out.print(" depth=\"" + tag.getDepth() + "\"");
        this.out.print(" matrix=\"" + tag.getMatrix() + "\"");
        if (tag.getColorTransform() != null) {
            this.out.print(" colorXform=\"" + tag.getColorTransform() + "\"");
        }
        this.close();
    }

    public void dumpRemoveObject(RemoveObjectTag tag) {
        this.open(tag);
        this.out.print(" idref=\"" + this.idRef(tag.getCharacter()) + "\"");
        this.close();
    }

    public void outputBase64(byte[] data) {
        int block;
        Base64.Encoder e = new Base64.Encoder(1024);
        this.indent();
        for (int remain = data.length; remain > 0; remain -= block) {
            block = 1024;
            if (block > remain) {
                block = remain;
            }
            e.encode(data, data.length - remain, block);
            this.out.print(e.drain());
        }
        this.out.println(e.flush());
    }

    public void dumpDefineBits(DefineBitsTag tag) {
        if (tag.getData() == null) {
            this.out.println("<!-- warning: no JPEG table tag found. -->");
        }
        this.open(tag);
        this.out.print(" id=\"" + this.id(tag) + "\"");
        this.out.print(" encoding=\"base64\"");
        this.end();
        this.outputBase64(tag.getData());
        this.close(tag);
    }

    public void dumpDefineButton(DefineButtonTag tag) {
        this.open(tag);
        this.out.print(" id=\"" + this.id(tag) + "\"");
        this.end();
        if (this.showActions) {
            this.openCDATA();
            this.outputBase64(tag.getActions());
            this.closeCDATA();
        }
        this.close(tag);
    }

    public void dumpSetBackgroundColor(SetBackgroundColorTag tag) {
        this.open(tag);
        this.out.print(" color=\"" + this.printColor(tag.getColor()) + "\"");
        this.close();
    }

    public void dumpDefineFont(DefineFontTag tag) {
        this.open(tag);
        this.out.print(" id=\"" + this.id(tag) + "\"");
        this.end();
        if (this.glyphs) {
            for (int i = 0; i < tag.getGlyphShapeTable().length; ++i) {
                this.indent();
                this.out.println("<glyph>");
                Shape shape = tag.getGlyphShapeTable()[i];
                ++this.indent;
                this.printShapeWithTabs(shape);
                --this.indent;
                this.indent();
                this.out.println("</glyph>");
            }
        }
        this.close(tag);
    }

    public void dumpDefineText(DefineTextTag tag) {
        this.open(tag);
        this.out.print(" id=\"" + this.id(tag) + "\"");
        this.out.print(" bounds=\"" + tag.getTextBounds() + "\"");
        this.out.print(" matrix=\"" + tag.getTextMatrix() + "\"");
        this.end();
        for (TextRecord tr : tag.getTextRecords()) {
            this.printTextRecord(tr, tag.getTagType().getValue());
        }
        this.close(tag);
    }

    public void dumpDefineFontInfo(DefineFontInfoTag tag) {
        this.open(tag);
        this.out.print(" idref=\"" + this.idRef(tag.getFontTag()) + "\"");
        this.out.print(" ansi=\"" + tag.isFontFlagsANSI() + "\"");
        this.out.print(" italic=\"" + tag.isFontFlagsItalic() + "\"");
        this.out.print(" bold=\"" + tag.isFontFlagsBold() + "\"");
        this.out.print(" wideCodes=\"" + tag.isFontFlagsWideCodes() + "\"");
        this.out.print(" smallText=\"" + tag.isFontFlagsSmallText() + "\"");
        this.out.print(" name=\"" + this.escape(tag.getFontName()) + "\"");
        this.out.print(" shiftJIS=\"" + tag.isFontFlagsShiftJIS() + "\"");
        this.end();
        this.indent();
        int[] codeTable = tag.getCodeTable();
        for (int i = 0; i < codeTable.length; ++i) {
            this.out.print(codeTable[i]);
            if ((i + 1) % 16 == 0) {
                this.out.println();
                this.indent();
                continue;
            }
            this.out.print(' ');
        }
        if (codeTable.length % 16 != 0) {
            this.out.println();
            this.indent();
        }
        this.close(tag);
    }

    public void dumpDefineSound(DefineSoundTag tag) {
        this.open(tag);
        this.out.print(" id=\"" + this.id(tag) + "\"");
        this.out.print(" format=\"" + tag.getSoundFormat() + "\"");
        this.out.print(" rate=\"" + tag.getSoundRate() + "\"");
        this.out.print(" size=\"" + tag.getSoundSize() + "\"");
        this.out.print(" type=\"" + tag.getSoundType() + "\"");
        this.out.print(" sampleCount=\"" + tag.getSoundSampleCount() + "\"");
        this.out.print(" soundDataSize=\"" + tag.getSoundData().length + "\"");
        this.end();
        this.openCDATA();
        this.outputBase64(tag.getSoundData());
        this.closeCDATA();
        this.close(tag);
    }

    public void dumpStartSound(StartSoundTag tag) {
        this.open(tag);
        this.out.print(" soundid=\"" + this.idRef(tag.getSoundTag()) + "\"");
        this.printSoundInfo(tag.getSoundInfo());
        this.close(tag);
    }

    private void printSoundInfo(SoundInfo info) {
        this.out.print(" syncStop=\"" + info.isSyncStop() + "\"");
        this.out.print(" syncNoMultiple=\"" + info.isSyncNoMultiple() + "\"");
        if (info.getInPoint() != 0L) {
            this.out.print(" inPoint=\"" + info.getInPoint() + "\"");
        }
        if (info.getOutPoint() != 0L) {
            this.out.print(" outPoint=\"" + info.getOutPoint() + "\"");
        }
        if (info.getLoopCount() != 0) {
            this.out.print(" loopCount=\"" + info.getLoopCount() + "\"");
        }
        this.end();
        SoundEnvelope[] envelopes = info.getEnvelopeRecords();
        if (envelopes != null && envelopes.length > 0) {
            this.openCDATA();
            for (int i = 0; i < envelopes.length; ++i) {
                this.out.println("pos44      =\"" + envelopes[i].getPos44() + "\"");
                this.out.println("left level =\"" + envelopes[i].getLeftLevel() + "\"");
                this.out.println("right level=\"" + envelopes[i].getRightLevel() + "\"");
            }
            this.closeCDATA();
        }
    }

    public void dumpDefineButtonSound(DefineButtonSoundTag tag) {
        this.open(tag);
        this.out.print(" buttonId=\"" + this.idRef(tag.getButtonTag()) + "\"");
        this.close();
    }

    public void dumpSoundStreamHead(SoundStreamHeadTag tag) {
        this.open(tag);
        this.close();
    }

    public void dumpSoundStreamBlock(SoundStreamBlockTag tag) {
        this.open(tag);
        this.close();
    }

    public void dumpDefineBinaryData(DefineBinaryDataTag tag) {
        this.open(tag);
        this.out.println(" id=\"" + this.id(tag) + "\" length=\"" + tag.getData().length + "\" />");
    }

    public void dumpDefineBitsLossless(DefineBitsLosslessTag tag) {
        this.open(tag);
        this.out.print(" id=\"" + this.id(tag) + "\" width=\"" + tag.getBitmapWidth() + "\" height=\"" + tag.getBitmapHeight() + "\"");
        if (this.external) {
            String path = this.externalDirectory + this.externalPrefix + "image" + this.id(tag) + ".bitmap";
            this.out.println(" src=\"" + path + "\" />");
            try {
                FileOutputStream image = new FileOutputStream(path, false);
                image.write(tag.getData());
                image.close();
            }
            catch (IOException e) {
                this.out.println("<!-- error: unable to write external asset file " + path + "-->");
            }
        } else {
            this.out.print(" encoding=\"base64\"");
            this.end();
            this.outputBase64(tag.getData());
            this.close(tag);
        }
    }

    public void dumpDefineBitsJPEG2(DefineBitsTag tag) {
        this.open(tag);
        this.out.print(" id=\"" + this.id(tag) + "\"");
        if (this.external) {
            String path = this.externalDirectory + this.externalPrefix + "image" + this.id(tag) + ".jpg";
            this.out.println(" src=\"" + path + "\" />");
            try {
                FileOutputStream image = new FileOutputStream(path, false);
                image.write(tag.getData());
                image.close();
            }
            catch (IOException e) {
                this.out.println("<!-- error: unable to write external asset file " + path + "-->");
            }
        } else {
            this.out.print(" encoding=\"base64\"");
            this.end();
            this.outputBase64(tag.getData());
            this.close(tag);
        }
    }

    public void dumpDefineShape2(DefineShapeTag tag) {
        this.printDefineShape(tag);
    }

    public void dumpDefineButtonCxform(DefineButtonCxformTag tag) {
        this.open(tag);
        this.out.print(" buttonId=\"" + this.idRef(tag.getButtonTag()) + "\"");
        this.close();
    }

    public void dumpPlaceObject2(PlaceObjectTag tag) {
        this.dumpPlaceObject23(tag);
    }

    public void dumpPlaceObject3(PlaceObjectTag tag) {
        this.dumpPlaceObject23(tag);
    }

    public void dumpPlaceObject23(PlaceObjectTag tag) {
        PlaceObject3Tag tag3;
        PlaceObject2Tag tag2 = tag instanceof PlaceObject2Tag ? (PlaceObject2Tag)tag : null;
        PlaceObject3Tag placeObject3Tag = tag3 = tag instanceof PlaceObject3Tag ? (PlaceObject3Tag)tag : null;
        if ((tag != null || tag2 != null && tag2.isHasCharacter()) && tag.getCharacter() != null && this.currentFrame != null && this.currentFrame.getSymbolName(tag.getCharacter()) != null) {
            this.indent();
            this.out.println("<!-- instance of " + this.idRef(tag.getCharacter()) + " -->");
        }
        this.open(tag);
        if (tag3 != null && tag3.isHasClassName()) {
            this.out.print(" className=\"" + tag3.getClassName() + "\"");
        }
        if (tag3 != null && tag3.isHasImage()) {
            this.out.print(" hasImage=\"true\" ");
        }
        if (tag != null || tag2 != null && tag2.isHasCharacter()) {
            this.out.print(" idref=\"" + this.idRef(tag.getCharacter()) + "\"");
        }
        if (tag2 != null && tag2.isHasName()) {
            this.out.print(" name=\"" + tag2.getName() + "\"");
        }
        this.out.print(" depth=\"" + tag.getDepth() + "\"");
        if (tag2 != null && tag2.isHasClipDepth()) {
            this.out.print(" clipDepth=\"" + tag2.getClipDepth() + "\"");
        }
        if (tag3 != null && tag3.isHasCacheAsBitmap()) {
            this.out.print(" cacheAsBitmap=\"true\"");
        }
        if (tag2 != null && tag2.isHasRatio()) {
            this.out.print(" ratio=\"" + tag2.getRatio() + "\"");
        }
        if (tag2 != null && tag2.isHasColorTransform()) {
            this.out.print(" cxform=\"" + tag2.getColorTransform() + "\"");
        } else if (tag.getColorTransform() != null) {
            this.out.print(" cxform=\"" + tag.getColorTransform() + "\"");
        }
        if (tag.getMatrix() != null || tag2 != null && tag2.isHasMatrix()) {
            this.out.print(" matrix=\"" + tag.getMatrix() + "\"");
        }
        if (tag3 != null && tag3.isHasBlendMode()) {
            this.out.print(" blendmode=\"" + tag3.getBlendMode() + "\"");
        }
        if (tag3 != null && tag3.isHasFilterList()) {
            this.out.print(" filters=\"");
            for (Filter filter : tag3.getSurfaceFilterList()) {
                this.out.print(filter.getFilterID() + " ");
            }
            this.out.print("\"");
        }
        this.close();
    }

    public void dumpRemoveObject2(RemoveObject2Tag tag) {
        this.open(tag);
        this.out.print(" depth=\"" + tag.getDepth() + "\"");
        this.close();
    }

    public void dumpDefineShape3(DefineShape3Tag tag) {
        this.printDefineShape(tag);
    }

    public void dumpDefineShape4(DefineShape4Tag tag) {
        this.printDefineShape(tag);
    }

    private void printShapeWithStyles(ShapeWithStyle shapes) {
        this.printFillStyles(shapes.getFillStyles());
        this.printLineStyles(shapes.getLineStyles());
        this.printShape(shapes);
    }

    private void printMorphLineStyles(MorphLineStyle[] lineStyles) {
        for (int i = 0; i < lineStyles.length; ++i) {
            MorphLineStyle lineStyle = lineStyles[i];
            this.indent();
            this.out.print("<linestyle ");
            this.out.print("startColor=\"" + this.printColor(lineStyle.getStartColor()) + "\" ");
            this.out.print("endColor=\"" + this.printColor(lineStyle.getStartColor()) + "\" ");
            this.out.print("startWidth=\"" + lineStyle.getStartWidth() + "\" ");
            this.out.print("endWidth=\"" + lineStyle.getEndWidth() + "\" ");
            this.out.println("/>");
        }
    }

    private void printLineStyles(LineStyleArray linestyles) {
        for (ILineStyle lineStyle : linestyles) {
            this.indent();
            this.out.print("<linestyle ");
            if (lineStyle instanceof LineStyle) {
                LineStyle ls = (LineStyle)lineStyle;
                String color = this.printColor(ls.getColor());
                this.out.print("color=\"" + color + "\" ");
                this.out.print("width=\"" + ls.getWidth() + "\" ");
            }
            if (lineStyle instanceof LineStyle2) {
                LineStyle2 lineStyle2 = (LineStyle2)lineStyle;
                if (lineStyle2.getJoinStyle() == 2) {
                    this.out.print("miterLimit=\"" + lineStyle2.getMiterLimitFactor() + "\" ");
                }
                if (lineStyle2.isHasFillFlag()) {
                    this.out.println(">");
                    this.indent();
                    FillStyleArray fillStyles = new FillStyleArray(1);
                    fillStyles.add(lineStyle2.getFillType());
                    this.printFillStyles(fillStyles);
                    this.indent();
                    this.out.println("</linestyle>");
                    continue;
                }
                this.out.println("/>");
                continue;
            }
            this.out.println("/>");
        }
    }

    private void printFillStyles(FillStyleArray fillstyles) {
        for (IFillStyle iFillStyle : fillstyles) {
            this.indent();
            this.out.print("<fillstyle");
            FillStyle fillStyle = (FillStyle)iFillStyle;
            int fillStyleType = fillStyle.getFillStyleType();
            this.out.print(" type=\"" + fillStyleType + "\"");
            if (fillStyleType == 0) {
                this.out.print(" color=\"" + this.printColor(fillStyle.getColor()) + "\"");
            }
            if ((fillStyleType & 0x10) != 0) {
                if (fillStyleType == 18) {
                    this.out.print(" typeName=\"radial\"");
                } else if (fillStyleType == 19) {
                    this.out.print(" typeName=\"focal\" focalPoint=\"" + ((FocalGradient)fillStyle.getGradient()).getFocalPoint() + "\"");
                }
                this.out.print(" gradient=\"" + this.formatGradient(fillStyle.getGradient().getGradientRecords()) + "\"");
                this.out.print(" matrix=\"" + fillStyle.getGradientMatrix() + "\"");
            }
            if ((fillStyleType & 0x40) != 0) {
                this.out.print(" idref=\"" + this.idRef(fillStyle.getBitmapCharacter()) + "\"");
                this.out.print(" matrix=\"" + fillStyle.getBitmapMatrix() + "\"");
            }
            this.out.println(" />");
        }
    }

    private void printMorphFillStyles(MorphFillStyle[] fillStyles) {
        for (int i = 0; i < fillStyles.length; ++i) {
            MorphFillStyle fillStyle = fillStyles[i];
            this.indent();
            this.out.print("<fillstyle");
            this.out.print(" type=\"" + fillStyle.getFillStyleType() + "\"");
            if (fillStyle.getFillStyleType() == 0) {
                this.out.print(" startColor=\"" + this.printColor(fillStyle.getStartColor()) + "\"");
                this.out.print(" endColor=\"" + this.printColor(fillStyle.getEndColor()) + "\"");
            }
            if ((fillStyle.getFillStyleType() & 0x10) != 0) {
                this.out.print(" gradient=\"" + this.formatMorphGradient(fillStyle.getGradient().toArray(new MorphGradRecord[0])) + "\"");
                this.out.print(" startMatrix=\"" + fillStyle.getStartGradientMatrix() + "\"");
                this.out.print(" endMatrix=\"" + fillStyle.getEndGradientMatrix() + "\"");
                if (fillStyle.getFillStyleType() == 19) {
                    this.out.print(" ratio1 =\"" + fillStyle.getRatio1());
                    this.out.print(" ratio2 =\"" + fillStyle.getRatio2());
                }
            }
            if ((fillStyle.getFillStyleType() & 0x40) != 0) {
                this.out.print(" idref=\"" + this.idRef(fillStyle.getBitmap()) + "\"");
                this.out.print(" startMatrix=\"" + fillStyle.getStartBitmapMatrix() + "\"");
                this.out.print(" endMatrix=\"" + fillStyle.getEndBitmapMatrix() + "\"");
            }
            this.out.println(" />");
        }
    }

    private String formatGradient(List<GradRecord> records) {
        StringBuilder b = new StringBuilder();
        int i = 0;
        for (GradRecord record : records) {
            b.append(record.getRatio());
            b.append(' ');
            b.append(this.printColor(record.getColor()));
            if (i + 1 < records.size()) {
                b.append(' ');
            }
            ++i;
        }
        return b.toString();
    }

    private String formatMorphGradient(MorphGradRecord[] records) {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < records.length; ++i) {
            b.append(records[i].getStartRatio());
            b.append(',');
            b.append(records[i].getEndRatio());
            b.append(' ');
            b.append(this.printColor(records[i].getStartColor()));
            b.append(',');
            b.append(this.printColor(records[i].getEndColor()));
            if (i + 1 >= records.length) continue;
            b.append(' ');
        }
        return b.toString();
    }

    private void printShape(Shape shapes) {
        if (shapes == null) {
            return;
        }
        Styles styles = null;
        if (shapes instanceof ShapeWithStyle) {
            styles = new Styles(((ShapeWithStyle)shapes).getFillStyles(), ((ShapeWithStyle)shapes).getLineStyles());
        }
        for (ShapeRecord shape : shapes.getShapeRecords()) {
            this.indent();
            if (shape instanceof StyleChangeRecord) {
                StyleChangeRecord styleChange = (StyleChangeRecord)shape;
                this.out.print("<styleChange ");
                if (styleChange.isStateMoveTo()) {
                    this.out.print("dx=\"" + styleChange.getMoveDeltaX() + "\" dy=\"" + styleChange.getMoveDeltaY() + "\" ");
                }
                if (styleChange.isStateFillStyle0()) {
                    this.out.print("fillStyle0=\"" + (styles.getFillStyles().indexOf(styleChange.getFillstyle0()) + 1) + "\" ");
                }
                if (styleChange.isStateFillStyle1()) {
                    this.out.print("fillStyle1=\"" + (styles.getFillStyles().indexOf(styleChange.getFillstyle1()) + 1) + "\" ");
                }
                if (styleChange.isStateLineStyle()) {
                    this.out.print("lineStyle=\"" + (styles.getFillStyles().indexOf(styleChange.getLinestyle()) + 1) + "\" ");
                }
                if (styleChange.isStateNewStyles()) {
                    this.out.println(">");
                    ++this.indent;
                    this.printFillStyles(styleChange.getStyles().getFillStyles());
                    this.printLineStyles(styleChange.getStyles().getLineStyles());
                    --this.indent;
                    this.indent();
                    this.out.println("</styleChange>");
                    styles = styleChange.getStyles();
                    continue;
                }
                this.out.println("/>");
                continue;
            }
            EdgeRecord edge = (EdgeRecord)shape;
            if (edge instanceof StraightEdgeRecord) {
                StraightEdgeRecord straightEdge = (StraightEdgeRecord)edge;
                this.out.println("<line dx=\"" + straightEdge.getDeltaX() + "\" dy=\"" + straightEdge.getDeltaY() + "\" />");
                continue;
            }
            CurvedEdgeRecord curvedEdge = (CurvedEdgeRecord)edge;
            this.out.print("<curve ");
            this.out.print("cdx=\"" + curvedEdge.getControlDeltaX() + "\" cdy=\"" + curvedEdge.getControlDeltaY() + "\" ");
            this.out.print("dx=\"" + curvedEdge.getAnchorDeltaX() + "\" dy=\"" + curvedEdge.getAnchorDeltaY() + "\" ");
            this.out.println("/>");
        }
    }

    private void printShapeWithTabs(Shape shapes) {
        if (shapes == null) {
            return;
        }
        int startX = 0;
        int startY = 0;
        int x = 0;
        int y = 0;
        for (ShapeRecord shape : shapes.getShapeRecords()) {
            this.indent();
            if (shape instanceof StyleChangeRecord) {
                StyleChangeRecord styleChange = (StyleChangeRecord)shape;
                this.out.print("SCR\t");
                if (styleChange.isStateMoveTo()) {
                    this.out.print(styleChange.getMoveDeltaX() + "\t" + styleChange.getMoveDeltaY());
                    if (startX == 0 && startY == 0) {
                        startX = styleChange.getMoveDeltaX();
                        startY = styleChange.getMoveDeltaY();
                    }
                    x = styleChange.getMoveDeltaX();
                    y = styleChange.getMoveDeltaY();
                    this.out.print("\t\t");
                }
            } else {
                EdgeRecord edge = (EdgeRecord)shape;
                if (edge instanceof StraightEdgeRecord) {
                    StraightEdgeRecord straightEdge = (StraightEdgeRecord)edge;
                    this.out.print("SER\t");
                    this.out.print(straightEdge.getDeltaX() + "\t" + straightEdge.getDeltaY());
                    x += straightEdge.getDeltaX();
                    y += straightEdge.getDeltaY();
                    this.out.print("\t\t");
                } else {
                    CurvedEdgeRecord curvedEdge = (CurvedEdgeRecord)edge;
                    this.out.print("CER\t");
                    this.out.print(curvedEdge.getControlDeltaX() + "\t" + curvedEdge.getControlDeltaY() + "\t");
                    this.out.print(curvedEdge.getAnchorDeltaX() + "\t" + curvedEdge.getAnchorDeltaY());
                    x += curvedEdge.getControlDeltaX() + curvedEdge.getAnchorDeltaX();
                    y += curvedEdge.getControlDeltaY() + curvedEdge.getAnchorDeltaY();
                }
            }
            this.out.println("\t\t" + x + "\t" + y);
        }
    }

    public void defineText2(DefineTextTag tag) {
        this.open(tag);
        this.out.print(" id=\"" + this.id(tag) + "\"");
        this.end();
        for (TextRecord tr : tag.getTextRecords()) {
            this.printTextRecord(tr, tag.getTagType().getValue());
        }
        this.close(tag);
    }

    public void printTextRecord(TextRecord tr, int tagCode) {
        this.indent();
        this.out.print("<textRecord ");
        if (tr.isStyleFlagsHasFont()) {
            this.out.print(" font=\"" + this.id(tr.getFontTag()) + "\"");
            this.out.print(" height=\"" + tr.getTextHeight() + "\"");
        }
        if (tr.isStyleFlagsHasXOffset()) {
            this.out.print(" xOffset=\"" + tr.getxOffset() + "\"");
        }
        if (tr.isStyleFlagsHasYOffset()) {
            this.out.print(" yOffset=\"" + tr.getyOffset() + "\"");
        }
        if (tr.isStyleFlagsHasColor()) {
            this.out.print(" color=\"" + this.printColor(tr.getTextColor()) + "\"");
        }
        this.out.println(">");
        ++this.indent;
        this.printGlyphEntries(tr);
        --this.indent;
        this.indent();
        this.out.println("</textRecord>");
    }

    private void printGlyphEntries(TextRecord tr) {
        this.indent();
        GlyphEntry[] entries = tr.getGlyphEntries();
        for (int i = 0; i < entries.length; ++i) {
            GlyphEntry ge = entries[i];
            this.out.print(ge.getGlyphIndex());
            if (ge.getGlyphAdvance() >= 0) {
                this.out.print('+');
            }
            this.out.print(ge.getGlyphAdvance());
            this.out.print(' ');
            if ((i + 1) % 10 != 0) continue;
            this.out.println();
            this.indent();
        }
        if (entries.length % 10 != 0) {
            this.out.println();
        }
    }

    public void dumpDefineButton2(DefineButton2Tag tag) {
        this.open(tag);
        this.out.print(" id=\"" + this.id(tag) + "\"");
        this.out.print(" trackAsMenu=\"" + tag.isTrackAsMenu() + "\"");
        this.end();
        for (int i = 0; i < tag.getCharacters().length; ++i) {
            ButtonRecord record = tag.getCharacters()[i];
            this.indent();
            this.out.println("<buttonRecord idref=\"" + record.getCharacterID() + "\" " + "depth=\"" + record.getPlaceDepth() + "\" " + "matrix=\"" + record.getPlaceMatrix() + "\" " + "stateHitTest=\"" + record.isStateHitTest() + "\" " + "stateDown=\"" + record.isStateDown() + "\" " + "stateOver=\"" + record.isStateOver() + "\" " + "stateUp=\"" + record.isStateUp() + "\" " + "/>");
        }
        this.close(tag);
    }

    public void dumpDefineBitsJPEG3(DefineBitsJPEG3Tag tag) {
        this.open(tag);
        this.out.print(" id=\"" + this.id(tag) + "\"");
        this.out.print(" encoding=\"base64\"");
        this.end();
        this.outputBase64(tag.getData());
        this.close(tag);
    }

    public void dumpDefineBitsLossless2(DefineBitsLossless2Tag tag) {
        this.open(tag);
        this.out.print(" id=\"" + this.id(tag) + "\"");
        if (this.external) {
            String path = this.externalDirectory + this.externalPrefix + "image" + this.id(tag) + ".bitmap";
            this.out.println(" src=\"" + path + "\" />");
            try {
                FileOutputStream image = new FileOutputStream(path, false);
                image.write(tag.getData());
                image.close();
            }
            catch (IOException e) {
                this.out.println("<!-- error: unable to write external asset file " + path + "-->");
            }
        } else {
            this.out.print(" encoding=\"base64\"");
            this.end();
            this.outputBase64(tag.getData());
            this.close(tag);
        }
    }

    String escape(String s) {
        if (s == null) {
            return null;
        }
        StringBuilder b = new StringBuilder(s.length());
        block6: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '<': {
                    b.append("&lt;");
                    continue block6;
                }
                case '>': {
                    b.append("&gt;");
                    continue block6;
                }
                case '&': {
                    b.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    b.append("&quot;");
                    continue block6;
                }
                default: {
                    if (c >= '\u0000' && c <= '\b' || c >= '\u000b' && c <= '\f' || c >= '\u000e' && c <= '\u001f') {
                        b.append("?");
                        continue block6;
                    }
                    b.append(c);
                }
            }
        }
        return b.toString();
    }

    public void dumpDefineEditText(DefineEditTextTag tag) {
        this.open(tag);
        this.out.print(" id=\"" + this.id(tag) + "\"");
        if (tag.isHasFont()) {
            this.out.print(" fontId=\"" + this.id(tag.getFontTag()) + "\"");
            this.out.print(" fontName=\"" + this.escape(this.idRef(tag.getFontTag())) + "\"");
            this.out.print(" fontHeight=\"" + tag.getFontHeight() + "\"");
        } else if (tag.isHasFontClass()) {
            this.out.print(" fontClass=\"" + tag.getFontClass() + "\"");
            this.out.print(" fontHeight=\"" + tag.getFontHeight() + "\"");
        }
        this.out.print(" bounds=\"" + tag.getBounds() + "\"");
        if (tag.isHasTextColor()) {
            this.out.print(" color=\"" + this.printColor(tag.getTextColor()) + "\"");
        }
        this.out.print(" html=\"" + tag.isHtml() + "\"");
        this.out.print(" autoSize=\"" + tag.isAutoSize() + "\"");
        this.out.print(" border=\"" + tag.isBorder() + "\"");
        if (tag.isHasMaxLength()) {
            this.out.print(" maxLength=\"" + tag.getMaxLength() + "\"");
        }
        this.out.print(" multiline=\"" + tag.isMultiline() + "\"");
        this.out.print(" noSelect=\"" + tag.isNoSelect() + "\"");
        this.out.print(" password=\"" + tag.isPassword() + "\"");
        this.out.print(" readOnly=\"" + tag.isReadOnly() + "\"");
        this.out.print(" useOutlines=\"" + tag.isUseOutlines() + "\"");
        this.out.print(" varName=\"" + this.escape(tag.getVariableName()) + "\"");
        this.out.print(" wordWrap=\"" + tag.isWordWrap() + "\"");
        if (tag.isHasLayout()) {
            this.out.print(" align=\"" + tag.getAlign() + "\"");
            this.out.print(" indent=\"" + tag.getIndent() + "\"");
            this.out.print(" leading=\"" + tag.getLeading() + "\"");
            this.out.print(" leftMargin=\"" + tag.getLeftMargin() + "\"");
            this.out.print(" rightMargin=\"" + tag.getRightMargin() + "\"");
        }
        this.end();
        if (tag.isHasText()) {
            this.indent();
            this.out.println("<text>");
            this.openCDATA();
            this.out.print(tag.getInitialText());
            this.closeCDATA();
            this.indent();
            this.out.println("</text>");
        }
        this.close(tag);
    }

    public void dumpDefineSprite(DefineSpriteTag tag) {
        this.open(tag);
        this.out.print(" id=\"" + this.id(tag) + "\"");
        this.end();
        this.indent();
        this.out.println("<!-- sprite framecount=" + tag.getFrameCount() + " -->");
        for (ITag controlTag : tag.getControlTags()) {
            this.dumpTag(controlTag);
        }
        this.close(tag);
    }

    public void finish() {
        --this.indent;
        this.indent();
        this.out.println("</swf>");
    }

    public void dumpFrameLabel(FrameLabelTag tag) {
        this.open(tag);
        this.out.print(" label=\"" + tag.getName() + "\"");
        if (tag.isNamedAnchorTag()) {
            this.out.print(" anchor=\"true\"");
        }
        this.close();
    }

    public void dumpSoundStreamHead2(SoundStreamHeadTag tag) {
        this.open(tag);
        this.out.print(" playbackRate=\"" + tag.getPlaybackSoundRate() + "\"");
        this.out.print(" playbackSize=\"" + tag.getPlaybackSoundSize() + "\"");
        this.out.print(" playbackType=\"" + tag.getPlaybackSoundType() + "\"");
        this.out.print(" compression=\"" + tag.getStreamSoundCompression() + "\"");
        this.out.print(" streamRate=\"" + tag.getStreamSoundRate() + "\"");
        this.out.print(" streamSize=\"" + tag.getStreamSoundSize() + "\"");
        this.out.print(" streamType=\"" + tag.getStreamSoundRate() + "\"");
        this.out.print(" streamSampleCount=\"" + tag.getStreamSoundSampleCount() + "\"");
        if (tag.getStreamSoundCompression() == 2) {
            this.out.print(" latencySeek=\"" + tag.getLatencySeek() + "\"");
        }
        this.close();
    }

    public void dumpDefineScalingGrid(DefineScalingGridTag tag) {
        this.open(tag);
        this.out.print(" idref=\"" + this.id(tag.getCharacter()) + "\"");
        this.out.print(" grid=\"" + tag.getSplitter() + "\"");
        this.close();
    }

    public void dumpDefineMorphShape(DefineMorphShapeTag tag) {
        this.dumpDefineMorphShape2(tag);
    }

    public void dumpDefineMorphShape2(DefineMorphShapeTag tag) {
        this.open(tag);
        this.out.print(" id=\"" + this.id(tag) + "\"");
        this.out.print(" startBounds=\"" + tag.getStartBounds() + "\"");
        this.out.print(" endBounds=\"" + tag.getEndBounds() + "\"");
        if (tag.getTagType() == TagType.DefineMorphShape2) {
            DefineMorphShape2Tag tag2 = (DefineMorphShape2Tag)tag;
            this.out.print(" startEdgeBounds=\"" + tag2.getStartEdgeBounds() + "\"");
            this.out.print(" endEdgeBounds=\"" + tag2.getEndEdgeBounds() + "\"");
            this.out.print(" usesNonScalingStrokes=\"" + tag2.isUsesNonScalingStrokes() + "\"");
            this.out.print(" usesScalingStrokes=\"" + tag2.isUsesScalingStrokes() + "\"");
        }
        this.end();
        this.indent();
        this.out.println("<start>");
        ++this.indent;
        this.printShape(tag.getStartEdges());
        --this.indent;
        this.indent();
        this.out.println("</start>");
        this.indent();
        this.out.println("<end>");
        ++this.indent;
        this.printShape(tag.getEndEdges());
        --this.indent;
        this.indent();
        this.out.println("</end>");
        this.close(tag);
    }

    public void dumpDefineFont2(DefineFont2Tag tag) {
        this.open(tag);
        this.out.print(" id=\"" + this.id(tag) + "\"");
        this.out.print(" font=\"" + this.escape(tag.getFontName()) + "\"");
        this.out.print(" numGlyphs=\"" + tag.getNumGlyphs() + "\"");
        this.out.print(" italic=\"" + tag.isFontFlagsItalic() + "\"");
        this.out.print(" bold=\"" + tag.isFontFlagsBold() + "\"");
        this.out.print(" ansi=\"" + tag.isFontFlagsANSI() + "\"");
        this.out.print(" wideOffsets=\"" + tag.isFontFlagsWideCodes() + "\"");
        this.out.print(" wideCodes=\"" + tag.isFontFlagsWideCodes() + "\"");
        this.out.print(" shiftJIS=\"" + tag.isFontFlagsShiftJIS() + "\"");
        this.out.print(" langCode=\"" + tag.getLanguageCode() + "\"");
        this.out.print(" hasLayout=\"" + tag.isFontFlagsHasLayout() + "\"");
        this.out.print(" ascent=\"" + tag.getFontAscent() + "\"");
        this.out.print(" descent=\"" + tag.getFontDescent() + "\"");
        this.out.print(" leading=\"" + tag.getFontLeading() + "\"");
        this.out.print(" kerningCount=\"" + tag.getKerningCount() + "\"");
        this.out.print(" codepointCount=\"" + tag.getCodeTable().length + "\"");
        if (tag.isFontFlagsHasLayout()) {
            this.out.print(" advanceCount=\"" + tag.getFontAdvanceTable().length + "\"");
            this.out.print(" boundsCount=\"" + tag.getFontBoundsTable().length + "\"");
        }
        this.end();
        if (this.glyphs && tag.isFontFlagsHasLayout()) {
            int i;
            for (i = 0; i < tag.getFontKerningTable().length; ++i) {
                KerningRecord rec = tag.getFontKerningTable()[i];
                this.indent();
                this.out.println("<kerningRecord adjustment=\"" + rec.getAdjustment() + "\" code1=\"" + rec.getCode1() + "\" code2=\"" + rec.getCode2() + "\" />");
            }
            for (i = 0; i < tag.getGlyphShapeTable().length; ++i) {
                this.indent();
                this.out.print("<glyph");
                this.out.print(" codepoint=\"" + tag.getCodeTable()[i] + (this.isPrintable((char)tag.getCodeTable()[i]) ? this.escape("(" + (char)tag.getCodeTable()[i] + ")") : "(?)") + "\"");
                if (tag.isFontFlagsHasLayout()) {
                    this.out.print(" advance=\"" + tag.getFontAdvanceTable()[i] + "\"");
                    this.out.print(" bounds=\"" + tag.getFontBoundsTable()[i] + "\"");
                }
                this.out.println(">");
                Shape shape = tag.getGlyphShapeTable()[i];
                ++this.indent;
                if (this.tabbedGlyphs) {
                    this.printShapeWithTabs(shape);
                } else {
                    this.printShape(shape);
                }
                --this.indent;
                this.indent();
                this.out.println("</glyph>");
            }
        }
        this.close(tag);
    }

    public void dumpDefineFont3(DefineFont3Tag tag) {
        this.dumpDefineFont2(tag);
    }

    public void dumpDefineFont4(DefineFont4Tag tag) {
        this.open(tag);
        this.out.print(" id=\"" + this.id(tag) + "\"");
        this.out.print(" font=\"" + this.escape(tag.getFontName()) + "\"");
        this.out.print(" hasFontData=\"" + tag.isFontFlagsHasFontData() + "\"");
        this.out.print(" italic=\"" + tag.isFontFlagsItalic() + "\"");
        this.out.print(" bold=\"" + tag.isFontFlagsBold() + "\"");
        this.end();
        if (this.glyphs && tag.isFontFlagsHasFontData()) {
            this.outputBase64(tag.getFontData());
        }
        this.close(tag);
    }

    public void dumpDefineFontAlignZones(DefineFontAlignZonesTag tag) {
        this.open(tag);
        this.out.print(" fontID=\"" + this.id(tag.getFontTag()) + "\"");
        this.out.print(" CSMTableHint=\"" + tag.getCsmTableHint() + "\"");
        this.out.println(">");
        ++this.indent;
        this.indent();
        this.out.println("<ZoneTable length=\"" + tag.getZoneTable().length + "\">");
        ++this.indent;
        if (this.glyphs) {
            for (int i = 0; i < tag.getZoneTable().length; ++i) {
                ZoneRecord record = tag.getZoneTable()[i];
                this.indent();
                this.out.print("<ZoneRecord num=\"" + record.getNumZoneData() + "\" maskX=\"" + record.isZoneMaskX() + "\" maskY=\"" + record.isZoneMaskY() + "\">");
                this.out.print(record.getZoneData0().getData() + " " + record.getZoneData1().getData() + " ");
                this.out.println("</ZoneRecord>");
            }
        }
        --this.indent;
        this.indent();
        this.out.println("</ZoneTable>");
        this.close(tag);
    }

    public void dumpCSMTextSettings(CSMTextSettingsTag tag) {
        this.open(tag);
        String textID = tag.getTextTag() == null ? "0" : this.id(tag.getTextTag());
        this.out.print(" textID=\"" + textID + "\"");
        this.out.print(" useFlashType=\"" + tag.getUseFlashType() + "\"");
        this.out.print(" gridFitType=\"" + tag.getGridFit() + "\"");
        this.out.print(" thickness=\"" + tag.getThickness() + "\"");
        this.out.print(" sharpness=\"" + tag.getSharpness() + "\"");
        this.close();
    }

    public void dumpDefineFontName(DefineFontNameTag tag) {
        this.open(tag);
        this.out.print(" fontID=\"" + this.id(tag.getFontTag()) + "\"");
        if (tag.getFontName() != null) {
            this.out.print(" name=\"" + tag.getFontName() + "\"");
        }
        if (tag.getFontCopyright() != null) {
            this.out.print(" copyright=\"" + this.escape(tag.getFontCopyright()) + "\"");
        }
        this.close();
    }

    private boolean isPrintable(char c) {
        int i = c & 0xFFFF;
        return i >= 32 && i != 60 && i != 38 && i != 39;
    }

    public void dumpExportAssets(ExportAssetsTag tag) {
        this.open(tag);
        this.end();
        for (String name : tag.getCharacterNames()) {
            this.indent();
            this.out.println("<Export idref=\"" + tag.getCharacterTagByName(name).getCharacterID() + "\" name=\"" + name + "\" />");
        }
        this.close(tag);
    }

    public void dumpSymbolClass(SymbolClassTag tag) {
        this.open(tag);
        this.end();
        for (String symbolName : tag.getSymbolNames()) {
            this.indent();
            this.out.println("<Symbol idref=\"" + tag.getSymbol(symbolName).getCharacterID() + "\" className=\"" + symbolName + "\" />");
        }
        if (this.currentFrameIndex == 0 && this.swf.getTopLevelClass() != null) {
            this.indent();
            this.out.println("<Symbol idref=\"0\" className=\"" + this.swf.getTopLevelClass() + "\" />");
        }
        this.close(tag);
    }

    public void dumpEnableDebugger(EnableDebugger2Tag tag) {
        this.open(tag);
        this.out.print(" password=\"" + tag.getPassword() + "\"");
        this.close();
    }

    public void dumpEnableTelemetry(EnableTelemetryTag tag) {
        this.open(tag);
        this.out.print(" password=\"" + tag.getPassword() + "\"");
        this.close();
    }

    private String idRef(ICharacterTag tag) {
        if (tag == null) {
            return "-1";
        }
        if (this.currentFrame == null || this.currentFrame.getSymbolName(tag) == null) {
            return String.valueOf(this.id(tag));
        }
        return this.currentFrame.getSymbolName(tag);
    }

    public void dumpDefineVideoStream(DefineVideoStreamTag tag) {
        this.open(tag);
        this.out.print(" id=\"" + this.id(tag) + "\"");
        this.close();
    }

    public void dumpVideoFrame(VideoFrameTag tag) {
        this.open(tag);
        this.out.print(" streamId=\"" + this.idRef(tag.getStreamTag()) + "\"");
        this.out.print(" frame=\"" + tag.getFrameNum() + "\"");
        this.close();
    }

    public void dumpDefineFontInfo2(DefineFontInfoTag tag) {
        this.dumpDefineFontInfo(tag);
    }

    public void dumpEnableDebugger2(EnableDebugger2Tag tag) {
        this.open(tag);
        this.out.print(" password=\"" + tag.getPassword() + "\"");
        this.out.print(" reserved=\"0x" + Integer.toHexString(6517) + "\"");
        this.close();
    }

    public void dumpScriptLimits(ScriptLimitsTag tag) {
        this.open(tag);
        this.out.print(" scriptRecursionLimit=\"" + tag.getMaxRecursionDepth() + "\"" + " scriptTimeLimit=\"" + tag.getScriptTimeoutSeconds() + "\"");
        this.close();
    }

    public void dumpSetTabIndex(SetTabIndexTag tag) {
        this.open(tag);
        this.out.print(" depth=\"" + tag.getDepth() + "\"");
        this.out.print(" index=\"" + tag.getTabIndex() + "\"");
        this.close();
    }

    public void dumpDoABC(DoABCTag tag) {
        if (this.abc) {
            this.open(tag);
            this.end();
            ABCParser parser = new ABCParser(tag.getABCData());
            ABCDumpVisitor printer = new ABCDumpVisitor(this.out);
            parser.parseABC(printer);
            this.close(tag);
        } else {
            this.open(tag);
            if (tag.getTagType() == TagType.DoABC) {
                this.out.print(" name=\"" + tag.getName() + "\"");
            }
            this.close();
        }
    }

    private String hexify(byte[] id) {
        StringBuilder b = new StringBuilder(id.length * 2);
        for (int i = 0; i < id.length; ++i) {
            b.append(Character.forDigit(id[i] >> 4 & 0xF, 16));
            b.append(Character.forDigit(id[i] & 0xF, 16));
        }
        return b.toString().toUpperCase();
    }

    public static String baseName(String path) {
        int start = path.lastIndexOf(File.separatorChar);
        if (File.separatorChar != '/') {
            int altstart = path.lastIndexOf(47);
            if (start == -1 || altstart > start) {
                start = altstart;
            }
        }
        start = start == -1 ? 0 : ++start;
        int end = path.lastIndexOf(46);
        if (end == -1) {
            end = path.length();
        }
        if (start > end) {
            end = path.length();
        }
        return path.substring(start, end);
    }

    public static String dirName(String path) {
        int end = path.lastIndexOf(File.pathSeparatorChar);
        if (File.pathSeparatorChar != '/') {
            int altend = path.lastIndexOf(47);
            if (end == -1 || altend < end) {
                end = altend;
            }
        }
        if (end == -1) {
            return "";
        }
        return path.substring(0, ++end);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        System.err.println("Apache Flex SWF Dump Utility");
        System.err.println(VersionInfo.buildMessage());
        System.err.println("");
        if (args.length == 0) {
            System.err.println("Usage: swfdump [-abc] file1.swf");
            System.exit(1);
        }
        int index = 0;
        PrintWriter out = null;
        String outfile = null;
        while (index < args.length && args[index].startsWith("-")) {
            if (args[index].equals("-encode")) {
                encodeOption = true;
                ++index;
                continue;
            }
            if (args[index].equals("-save")) {
                saveOption = true;
                int n = ++index;
                ++index;
                outfile = args[n];
                continue;
            }
            if (args[index].equals("-uncompress")) {
                uncompressOption = true;
                int n = ++index;
                ++index;
                outfile = args[n];
                continue;
            }
            if (args[index].equals("-decompile")) {
                decompileOption = true;
                ++index;
                continue;
            }
            if (args[index].equals("-nofunctions")) {
                defuncOption = false;
                ++index;
                continue;
            }
            if (args[index].equals("-asm")) {
                decompileOption = false;
                ++index;
                continue;
            }
            if (args[index].equals("-abc")) {
                abcOption = true;
                ++index;
                continue;
            }
            if (args[index].equals("-noactions")) {
                showActionsOption = false;
                ++index;
                continue;
            }
            if (args[index].equals("-showoffset")) {
                showOffsetOption = true;
                ++index;
                continue;
            }
            if (args[index].equals("-showbytecode")) {
                showByteCodeOption = true;
                ++index;
                continue;
            }
            if (args[index].equals("-showdebugsource")) {
                showDebugSourceOption = true;
                ++index;
                continue;
            }
            if (args[index].equals("-noglyphs")) {
                glyphsOption = false;
                ++index;
                continue;
            }
            if (args[index].equals("-out")) {
                if (index + 1 == args.length) {
                    System.err.println("-out requires a filename or - for stdout");
                    System.exit(1);
                }
                if (!args[index + 1].equals("-")) {
                    outfile = args[index + 1];
                    out = new PrintWriter(outfile, "UTF-8");
                }
                index += 2;
                continue;
            }
            if (args[index].equals("-external")) {
                externalOption = true;
                ++index;
                continue;
            }
            if (args[index].equalsIgnoreCase("-tabbedGlyphs")) {
                tabbedGlyphsOption = true;
                ++index;
                continue;
            }
            System.err.println("unknown argument " + args[index]);
            ++index;
        }
        if (out == null) {
            out = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)System.out, "UTF-8"), true);
        }
        File f = new File(args[index]);
        URL[] urls = new URL[]{};
        File currentFile = f;
        try {
            if (!f.exists()) {
                urls = new URL[]{new URL(args[index])};
            } else if (f.isDirectory()) {
                File[] list = SWFDump.listFiles(f);
                urls = new URL[list.length];
                for (int i = 0; i < list.length; ++i) {
                    currentFile = list[i];
                    urls[i] = SWFDump.toURL(list[i]);
                }
            } else {
                urls = new URL[]{SWFDump.toURL(f)};
            }
        }
        catch (MalformedURLException e) {
            System.err.println("Unable to open " + currentFile);
        }
        for (int i = 0; i < urls.length; ++i) {
            try {
                URL url = urls[i];
                if (saveOption) {
                    BufferedInputStream in = new BufferedInputStream(url.openStream());
                    try {
                        BufferedOutputStream fileOut = new BufferedOutputStream(new FileOutputStream(outfile));
                        try {
                            int c;
                            while ((c = ((InputStream)in).read()) != -1) {
                                ((OutputStream)fileOut).write(c);
                            }
                        }
                        finally {
                            ((OutputStream)fileOut).close();
                        }
                    }
                    finally {
                        ((InputStream)in).close();
                    }
                }
                if (uncompressOption) {
                    SWFReader swfReader = new SWFReader();
                    String path = url.getPath();
                    try {
                        SWF swf = (SWF)swfReader.readFrom(new BufferedInputStream(url.openStream()), path);
                        ProblemQuery problemQuery = new ProblemQuery();
                        problemQuery.addAll(swfReader.getProblems());
                        if (!problemQuery.hasErrors()) {
                            BufferedOutputStream fileOut = new BufferedOutputStream(new FileOutputStream(outfile));
                            SWFWriter swfWriter = new SWFWriter(swf, Header.Compression.NONE);
                            swfWriter.writeTo(fileOut);
                            swfWriter.close();
                        }
                    }
                    finally {
                        IOUtils.closeQuietly((Closeable)swfReader);
                    }
                }
                if (!uncompressOption) {
                    SWFDump.dumpSwf(out, url, outfile);
                }
                out.flush();
                continue;
            }
            catch (Error e) {
                if (Trace.error) {
                    e.printStackTrace();
                }
                System.err.println("");
                System.err.println("An unrecoverable error occurred.  The given file " + urls[i] + " may not be");
                System.err.println("a valid swf.");
                continue;
            }
            catch (FileNotFoundException e) {
                System.err.println("Error: " + e.getMessage());
                System.exit(1);
            }
        }
    }

    public static void dumpSwf(PrintWriter out, URL url, String outfile) throws IOException {
        out.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        out.println("<!-- Parsing swf " + url + " -->");
        SWFDump swfDump = new SWFDump(out);
        swfDump.abc = abcOption;
        swfDump.dump(url);
    }

    public static URL toURL(File f) throws MalformedURLException {
        String s = f.getAbsolutePath();
        if (File.separatorChar != '/') {
            s = s.replace(File.separatorChar, '/');
        }
        if (!s.startsWith("/")) {
            s = "/" + s;
        }
        if (!s.endsWith("/") && f.isDirectory()) {
            s = s + "/";
        }
        return new URL("file", "", s);
    }

    public static File[] listFiles(File dir) {
        String[] fileNames = dir.list();
        if (fileNames == null) {
            return null;
        }
        File[] fileList = new File[fileNames.length];
        for (int i = 0; i < fileNames.length; ++i) {
            fileList[i] = new File(dir.getPath(), fileNames[i]);
        }
        return fileList;
    }
}

