/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.swc.io;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.flex.compiler.asdoc.IPackageDITAParser;
import org.apache.flex.compiler.problems.FileInLibraryIOProblem;
import org.apache.flex.compiler.problems.FileInLibraryNotFoundProblem;
import org.apache.flex.compiler.problems.LibraryNotFoundProblem;
import org.apache.flex.swc.ISWC;
import org.apache.flex.swc.SWC;
import org.apache.flex.swc.catalog.StAXCatalogReader;
import org.apache.flex.swc.dita.IDITAList;
import org.apache.flex.swc.io.ISWCReader;

public class SWCReader
implements ISWCReader {
    public static final String CATALOG_XML = "catalog.xml";
    private static final String DITA_MANIFEST = "docs/packages.dita";
    private static final String ANE_EXTENSION_XML = "META-INF/AIR/extension.xml";
    private final File swcFile;
    private StAXCatalogReader catalogReader;
    private final SWC swc;

    public SWCReader(String filename) {
        this(new File(filename), IPackageDITAParser.NIL_PARSER);
    }

    public SWCReader(File swcFile) {
        this(swcFile, IPackageDITAParser.NIL_PARSER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SWCReader(File swcFile, IPackageDITAParser packageDitaParser) {
        InputStream catalogInputStream;
        ZipFile zipFile;
        block28: {
            this.swcFile = swcFile;
            this.swc = new SWC(swcFile);
            if (!swcFile.exists() || !swcFile.isFile()) {
                this.swc.addProblem(new LibraryNotFoundProblem(swcFile.getAbsolutePath()));
                return;
            }
            zipFile = null;
            this.catalogReader = null;
            zipFile = new ZipFile(swcFile, 1);
            catalogInputStream = SWCReader.getInputStream(zipFile, CATALOG_XML);
            if (catalogInputStream != null) break block28;
            this.swc.addProblem(new FileInLibraryNotFoundProblem(swcFile.getAbsolutePath(), CATALOG_XML));
            try {
                if (this.catalogReader != null) {
                    this.catalogReader.close();
                }
                if (zipFile != null) {
                    zipFile.close();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            return;
        }
        try {
            block29: {
                try {
                    this.catalogReader = new StAXCatalogReader(new BufferedInputStream(catalogInputStream), this.swc);
                    this.catalogReader.parse();
                    this.catalogReader.close();
                    this.catalogReader = null;
                }
                catch (Exception e) {
                    this.swc.addProblem(new FileInLibraryIOProblem(CATALOG_XML, swcFile.getAbsolutePath(), e.getLocalizedMessage()));
                    try {
                        if (this.catalogReader != null) {
                            this.catalogReader.close();
                        }
                        if (zipFile != null) {
                            zipFile.close();
                        }
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                    return;
                }
                try {
                    InputStream ditaInputStream = SWCReader.getInputStream(zipFile, DITA_MANIFEST);
                    if (ditaInputStream == null) break block29;
                    try {
                        IDITAList list = packageDitaParser.parse(swcFile.getAbsolutePath(), ditaInputStream);
                        if (list != null) {
                            this.swc.setDITAList(list);
                        }
                    }
                    finally {
                        ditaInputStream.close();
                    }
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            this.swc.setIsANE(zipFile.getEntry(ANE_EXTENSION_XML) != null);
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            try {
                if (this.catalogReader != null) {
                    this.catalogReader.close();
                }
                if (zipFile != null) {
                    zipFile.close();
                }
            }
            catch (Exception e) {}
        }
    }

    @Override
    public File getFile() {
        return this.swcFile;
    }

    @Override
    public ISWC getSWC() {
        return this.swc;
    }

    public static InputStream getInputStream(ZipFile zipFile, String filename) throws IOException {
        ZipEntry zipEntry = null;
        Enumeration<? extends ZipEntry> entryEnum = zipFile.entries();
        while (entryEnum.hasMoreElements()) {
            ZipEntry entry = entryEnum.nextElement();
            if (!entry.getName().equals(filename)) continue;
            zipEntry = entry;
            break;
        }
        if (zipEntry == null) {
            return null;
        }
        return zipFile.getInputStream(zipEntry);
    }

    public static String getReportingPath(String swcPath, String libraryPath) {
        assert (swcPath != null && libraryPath != null);
        StringBuilder sb = new StringBuilder();
        sb.append(swcPath).append("(").append(libraryPath).append(")");
        return sb.toString();
    }
}

