/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.units;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.flex.compiler.projects.ICompilerProject;
import org.apache.flex.compiler.units.ICompilationUnit;

public final class StringToCompilationUnitMap {
    private static final Object PRESENT = new Object();
    private static final Map<String, Object> EMPTY_MAP = Collections.emptyMap();
    private final Lock readLock;
    private final Lock writeLock;
    private Map<String, Object> map;

    public StringToCompilationUnitMap() {
        this(EMPTY_MAP);
    }

    private StringToCompilationUnitMap(Map<String, Object> map) {
        this.map = map;
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.readLock = lock.readLock();
        this.writeLock = lock.writeLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<WeakReference<ICompilationUnit>> getInvisible(String sortKey) {
        this.readLock.lock();
        try {
            Collection<WeakReference<ICompilationUnit>> collection = StringToCompilationUnitMap.valueToCollection(this.map.get(sortKey), null, Visibility.INVISIBLE_ONLY);
            return collection;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<WeakReference<ICompilationUnit>> getVisibleAndInvisible(String sortKey) {
        this.readLock.lock();
        try {
            Collection<WeakReference<ICompilationUnit>> collection = StringToCompilationUnitMap.valueToCollection(this.map.get(sortKey), null, Visibility.ALL);
            return collection;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<WeakReference<ICompilationUnit>> get(String sortKey) {
        this.readLock.lock();
        try {
            Collection<WeakReference<ICompilationUnit>> collection = StringToCompilationUnitMap.valueToCollection(this.map.get(sortKey), null, Visibility.VISIBLE_ONLY);
            return collection;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<WeakReference<ICompilationUnit>> get(String sortKey, ICompilerProject project) {
        this.readLock.lock();
        try {
            Collection<WeakReference<ICompilationUnit>> collection = StringToCompilationUnitMap.valueToCollection(this.map.get(sortKey), project, Visibility.VISIBLE_ONLY);
            return collection;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<WeakReference<ICompilationUnit>> getInvisible(String sortKey, ICompilerProject project) {
        this.readLock.lock();
        try {
            Collection<WeakReference<ICompilationUnit>> collection = StringToCompilationUnitMap.valueToCollection(this.map.get(sortKey), project, Visibility.INVISIBLE_ONLY);
            return collection;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(String[] files, ICompilationUnit cu) {
        this.writeLock.lock();
        try {
            for (String file : files) {
                this.add(file, cu);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(String sortKey, ICompilationUnit cu) {
        this.writeLock.lock();
        try {
            Object existing;
            if (this.map == EMPTY_MAP) {
                this.map = new HashMap<String, Object>();
            }
            if ((existing = this.map.get(sortKey)) == null) {
                this.map.put(sortKey, new WeakReference<ICompilationUnit>(cu));
            } else if (existing instanceof WeakHashMap) {
                WeakHashMap collection = (WeakHashMap)existing;
                collection.put(cu, PRESENT);
            } else {
                assert (existing instanceof WeakReference);
                WeakHashMap<Object, Object> collection = new WeakHashMap<Object, Object>(2);
                collection.put(((WeakReference)existing).get(), PRESENT);
                collection.put(cu, PRESENT);
                this.map.put(sortKey, collection);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(String sortKey) {
        this.writeLock.lock();
        try {
            this.map.remove(sortKey);
            if (this.map.isEmpty()) {
                this.map = EMPTY_MAP;
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<ICompilationUnit> remove(String sortKey, ICompilerProject project) {
        assert (project != null);
        this.writeLock.lock();
        try {
            Object mapValue = this.map.remove(sortKey);
            if (mapValue == null) {
                List<ICompilationUnit> list = Collections.emptyList();
                return list;
            }
            if (mapValue instanceof WeakHashMap) {
                WeakHashMap collection = (WeakHashMap)mapValue;
                ArrayList<ICompilationUnit> result = new ArrayList<ICompilationUnit>(collection.size());
                Iterator iter = collection.entrySet().iterator();
                while (iter.hasNext()) {
                    ICompilerProject projFromCU;
                    ICompilationUnit compilationUnit = (ICompilationUnit)iter.next().getKey();
                    if (compilationUnit == null || (projFromCU = compilationUnit.getProject()) == null || projFromCU != project) continue;
                    result.add(compilationUnit);
                    iter.remove();
                }
                if (!collection.isEmpty()) {
                    this.map.put(sortKey, collection);
                }
                List<ICompilationUnit> list = Collections.unmodifiableList(result);
                return list;
            }
            ICompilationUnit compilationUnit = (ICompilationUnit)((WeakReference)mapValue).get();
            if (compilationUnit == null) {
                List<ICompilationUnit> list = Collections.emptyList();
                return list;
            }
            if (compilationUnit != null && compilationUnit.getProject() == project) {
                List<ICompilationUnit> list = Collections.singletonList(compilationUnit);
                return list;
            }
            this.map.put(sortKey, mapValue);
            List<ICompilationUnit> list = Collections.emptyList();
            return list;
        }
        finally {
            if (this.map.isEmpty()) {
                this.map = EMPTY_MAP;
            }
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<ICompilationUnit> remove(String sortKey, ICompilationUnit cuToRemove) {
        assert (cuToRemove != null);
        this.writeLock.lock();
        try {
            Object mapValue = this.map.remove(sortKey);
            if (mapValue == null) {
                List<ICompilationUnit> list = Collections.emptyList();
                return list;
            }
            if (mapValue instanceof WeakHashMap) {
                WeakHashMap collection = (WeakHashMap)mapValue;
                ArrayList<ICompilationUnit> result = new ArrayList<ICompilationUnit>(collection.size());
                Iterator iter = collection.entrySet().iterator();
                while (iter.hasNext()) {
                    ICompilationUnit compilationUnit = (ICompilationUnit)iter.next().getKey();
                    if (compilationUnit == null || compilationUnit != cuToRemove) continue;
                    result.add(compilationUnit);
                    iter.remove();
                }
                if (!collection.isEmpty()) {
                    this.map.put(sortKey, collection);
                }
                List<ICompilationUnit> list = Collections.unmodifiableList(result);
                return list;
            }
            ICompilationUnit compilationUnit = (ICompilationUnit)((WeakReference)mapValue).get();
            if (compilationUnit == null) {
                List<ICompilationUnit> list = Collections.emptyList();
                return list;
            }
            if (compilationUnit != null && compilationUnit == cuToRemove) {
                List<ICompilationUnit> list = Collections.singletonList(compilationUnit);
                return list;
            }
            this.map.put(sortKey, mapValue);
            List<ICompilationUnit> list = Collections.emptyList();
            return list;
        }
        finally {
            if (this.map.isEmpty()) {
                this.map = EMPTY_MAP;
            }
            this.writeLock.unlock();
        }
    }

    private static Collection<WeakReference<ICompilationUnit>> valueToCollection(Object value, ICompilerProject project, Visibility visibility) {
        if (value instanceof WeakHashMap) {
            WeakHashMap collection = (WeakHashMap)value;
            ArrayList<WeakReference<ICompilationUnit>> result = new ArrayList<WeakReference<ICompilationUnit>>(collection.size());
            for (ICompilationUnit compilationUnit : collection.keySet()) {
                ICompilerProject projFromCU;
                if (compilationUnit == null || (projFromCU = compilationUnit.getProject()) == null || project != null && projFromCU != project || !visibility.match(compilationUnit)) continue;
                result.add(new WeakReference<ICompilationUnit>(compilationUnit));
            }
            return Collections.unmodifiableList(result);
        }
        if (value != null) {
            assert (value instanceof WeakReference);
            WeakReference cuRef = (WeakReference)value;
            ICompilationUnit compilationUnit = (ICompilationUnit)cuRef.get();
            if (compilationUnit != null && (project == null || compilationUnit.getProject() == project) && visibility.match(compilationUnit)) {
                return Collections.singletonList(cuRef);
            }
            return Collections.emptyList();
        }
        return Collections.emptyList();
    }

    private static final class Visibility
    extends Enum<Visibility> {
        public static final /* enum */ Visibility INVISIBLE_ONLY = new Visibility();
        public static final /* enum */ Visibility VISIBLE_ONLY = new Visibility();
        public static final /* enum */ Visibility ALL = new Visibility();
        private static final /* synthetic */ Visibility[] $VALUES;

        public static Visibility[] values() {
            return (Visibility[])$VALUES.clone();
        }

        public static Visibility valueOf(String name) {
            return Enum.valueOf(Visibility.class, name);
        }

        private boolean match(ICompilationUnit cu) {
            switch (this) {
                case INVISIBLE_ONLY: {
                    return cu.isInvisible();
                }
                case VISIBLE_ONLY: {
                    return !cu.isInvisible();
                }
                case ALL: {
                    return true;
                }
            }
            assert (false) : "Unhandled visibility!";
            return false;
        }

        static {
            $VALUES = new Visibility[]{INVISIBLE_ONLY, VISIBLE_ONLY, ALL};
        }
    }
}

