/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.units;

import com.google.common.collect.SetMultimap;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.flex.compiler.common.DependencyType;
import org.apache.flex.compiler.common.DependencyTypeSet;
import org.apache.flex.compiler.common.Multiname;
import org.apache.flex.compiler.definitions.IDefinition;
import org.apache.flex.compiler.definitions.metadata.IMetaTag;
import org.apache.flex.compiler.internal.caches.AssetTagCache;
import org.apache.flex.compiler.internal.caches.FileScopeCache;
import org.apache.flex.compiler.internal.caches.SWFCache;
import org.apache.flex.compiler.internal.graph.LinkReportWriter;
import org.apache.flex.compiler.internal.projects.CompilerProject;
import org.apache.flex.compiler.internal.projects.DefinitionPriority;
import org.apache.flex.compiler.internal.projects.FlexProject;
import org.apache.flex.compiler.internal.resourcebundles.ResourceBundleUtils;
import org.apache.flex.compiler.internal.scopes.ASProjectScope;
import org.apache.flex.compiler.internal.targets.TagSorter;
import org.apache.flex.compiler.internal.units.CompilationUnitBase;
import org.apache.flex.compiler.internal.units.requests.ABCBytesRequestResult;
import org.apache.flex.compiler.internal.units.requests.ABCFileScopeRequestResult;
import org.apache.flex.compiler.internal.units.requests.SyntaxTreeRequestResult;
import org.apache.flex.compiler.problems.ICompilerProblem;
import org.apache.flex.compiler.problems.InternalCompilerProblem;
import org.apache.flex.compiler.problems.InvalidABCByteCodeProblem;
import org.apache.flex.compiler.problems.NoDefinitionForSWCDependencyProblem;
import org.apache.flex.compiler.problems.NoScopesInABCCompilationUnitProblem;
import org.apache.flex.compiler.projects.ICompilerProject;
import org.apache.flex.compiler.units.ICompilationUnit;
import org.apache.flex.compiler.units.requests.IABCBytesRequestResult;
import org.apache.flex.compiler.units.requests.IFileScopeRequestResult;
import org.apache.flex.compiler.units.requests.IOutgoingDependenciesRequestResult;
import org.apache.flex.compiler.units.requests.ISWFTagsRequestResult;
import org.apache.flex.compiler.units.requests.ISyntaxTreeRequestResult;
import org.apache.flex.swc.ISWC;
import org.apache.flex.swc.ISWCLibrary;
import org.apache.flex.swc.ISWCScript;
import org.apache.flex.swf.ITagContainer;
import org.apache.flex.swf.SWFFrame;
import org.apache.flex.swf.tags.DoABCTag;
import org.apache.flex.swf.tags.ICharacterTag;
import org.apache.flex.swf.tags.ITag;
import org.apache.flex.swf.tags.SymbolClassTag;

public class SWCCompilationUnit
extends CompilationUnitBase {
    private final ISWC swc;
    private final ISWCLibrary library;
    private final ISWCScript script;
    private final Set<String> resourceBundles;
    private final String name;

    public SWCCompilationUnit(CompilerProject project, ISWC swc, ISWCLibrary library, ISWCScript script, List<String> qnames, int order) {
        super(project, swc.getSWCFile().getPath(), DefinitionPriority.BasePriority.LIBRARY_PATH, qnames);
        this.swc = swc;
        this.library = library;
        this.script = script;
        this.resourceBundles = new HashSet<String>();
        DefinitionPriority dp = (DefinitionPriority)this.getDefinitionPriority();
        dp.setTimestamp(script.getLastModified());
        dp.setOrder(order);
        this.name = this.computeName();
    }

    @Override
    public ICompilationUnit.UnitType getCompilationUnitType() {
        return ICompilationUnit.UnitType.SWC_UNIT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ISyntaxTreeRequestResult handleSyntaxTreeRequest() throws InterruptedException {
        IFileScopeRequestResult fileResult = this.getFileScopeRequest().get();
        this.startProfile(ICompilationUnit.Operation.GET_SYNTAX_TREE);
        try {
            List noProblems = Collections.emptyList();
            boolean isFlex = false;
            CompilerProject project = this.getProject();
            if (project instanceof FlexProject && ((FlexProject)project).isFlex()) {
                isFlex = true;
            }
            if (isFlex) {
                for (IDefinition definition : fileResult.getExternallyVisibleDefinitions()) {
                    for (IMetaTag rbTag : definition.getMetaTagsByName("ResourceBundle")) {
                        this.resourceBundles.add(rbTag.getAllAttributes()[0].getValue());
                    }
                }
            }
            SyntaxTreeRequestResult syntaxTreeRequestResult = new SyntaxTreeRequestResult(this.script.getLastModified(), noProblems){

                @Override
                public Set<String> getRequiredResourceBundles() {
                    return SWCCompilationUnit.this.resourceBundles;
                }
            };
            return syntaxTreeRequestResult;
        }
        finally {
            this.stopProfile(ICompilationUnit.Operation.GET_SYNTAX_TREE);
        }
    }

    @Override
    protected IFileScopeRequestResult handleFileScopeRequest() throws InterruptedException {
        this.startProfile(ICompilationUnit.Operation.GET_FILESCOPE);
        this.getProject().clearScopeCacheForCompilationUnit(this);
        HashSet<ICompilerProblem> problems = new HashSet<ICompilerProblem>();
        Collection scopeList = null;
        try {
            FileScopeCache fsCache = this.getProject().getWorkspace().getSWCManager().getFileScopeCache();
            FileScopeCache.FileScopeCacheKey key = FileScopeCache.createKey(this.swc, this.library.getPath(), this.script);
            scopeList = (Collection)fsCache.get(key);
            if (scopeList.isEmpty()) {
                NoScopesInABCCompilationUnitProblem problem = new NoScopesInABCCompilationUnitProblem(this.getRootFileSpecification().getPath());
                problems.add(problem);
            }
        }
        catch (Exception e) {
            InvalidABCByteCodeProblem problem = new InvalidABCByteCodeProblem(this.getRootFileSpecification().getPath());
            problems.add(problem);
        }
        ABCFileScopeRequestResult result = new ABCFileScopeRequestResult((Collection<ICompilerProblem>)problems, scopeList);
        this.stopProfile(ICompilationUnit.Operation.GET_FILESCOPE);
        return result;
    }

    @Override
    protected IABCBytesRequestResult handleABCBytesRequest() throws InterruptedException {
        byte[] abcBytes = null;
        ArrayList<InternalCompilerProblem> problems = new ArrayList<InternalCompilerProblem>();
        SWFCache.SWFInSWCCacheKey key = SWFCache.createKey(this.swc, this.library.getPath());
        ITagContainer tags = (ITagContainer)this.getProject().getWorkspace().getSWCManager().getSWFCache().get(key);
        this.startProfile(ICompilationUnit.Operation.GET_ABC_BYTES);
        DoABCTag doABC = SWFCache.findDoABCTagByName(tags, this.script.getName());
        if (doABC == null) {
            problems.add(new InternalCompilerProblem(new RuntimeException("can't find ABC bytes for : " + this.script.getName())));
        } else {
            abcBytes = doABC.getABCData();
        }
        ABCBytesRequestResult result = new ABCBytesRequestResult(abcBytes);
        this.stopProfile(ICompilationUnit.Operation.GET_ABC_BYTES);
        return result;
    }

    @Override
    protected ISWFTagsRequestResult handleSWFTagsRequest() throws InterruptedException {
        final ArrayList problems = new ArrayList();
        ArrayList<ITag> linkingTags = new ArrayList<ITag>();
        SWFCache.SWFInSWCCacheKey key = SWFCache.createKey(this.swc, this.library.getPath());
        ITagContainer tags = (ITagContainer)this.getProject().getWorkspace().getSWCManager().getSWFCache().get(key);
        DoABCTag doABC = SWFCache.findDoABCTagByName(tags, this.script.getName());
        if (doABC == null) {
            throw new NullPointerException("can not find DoABC tag: " + this.script.getName());
        }
        this.startProfile(ICompilationUnit.Operation.GET_SWF_TAGS);
        linkingTags.add(doABC);
        final LinkedHashMap<String, ICharacterTag> assetTags = new LinkedHashMap<String, ICharacterTag>();
        for (String defQName : this.script.getDefinitions()) {
            AssetTagCache.AssetTagCacheKey assetCacheKey = AssetTagCache.createKey(this.swc, this.library.getPath(), this.script, defQName);
            AssetTagCache.AssetTagCacheValue assetCacheValue = (AssetTagCache.AssetTagCacheValue)this.getProject().getWorkspace().getSWCManager().getAssetTagCache().get(assetCacheKey);
            if (assetCacheValue.assetTag == null) continue;
            linkingTags.add(assetCacheValue.assetTag);
            linkingTags.addAll(assetCacheValue.referredTags);
            assetTags.put(defQName, assetCacheValue.assetTag);
        }
        final List<ITag> sortedTags = TagSorter.sortFullGraph(linkingTags);
        ISWFTagsRequestResult result = new ISWFTagsRequestResult(){

            @Override
            public boolean addToFrame(SWFFrame frame) {
                for (ITag iTag : sortedTags) {
                    frame.addTag(iTag);
                }
                for (Map.Entry entry : assetTags.entrySet()) {
                    frame.defineSymbol((ICharacterTag)entry.getValue(), (String)entry.getKey());
                }
                return true;
            }

            @Override
            public ICompilerProblem[] getProblems() {
                return problems.toArray(new ICompilerProblem[0]);
            }

            @Override
            public String getDoABCTagName() {
                return SWCCompilationUnit.this.script.getName();
            }
        };
        this.stopProfile(ICompilationUnit.Operation.GET_SWF_TAGS);
        return result;
    }

    @Override
    protected IOutgoingDependenciesRequestResult handleOutgoingDependenciesRequest() throws InterruptedException {
        this.getSyntaxTreeRequest().get();
        this.startProfile(ICompilationUnit.Operation.GET_SEMANTIC_PROBLEMS);
        SetMultimap<String, DependencyType> dependencies = this.script.getDependencies();
        this.addAssetTagDependencies(dependencies);
        ASProjectScope projectScope = this.getProject().getScope();
        final LinkedList<ICompilerProblem> problems = new LinkedList<ICompilerProblem>();
        for (Map.Entry dependencyEntry : dependencies.asMap().entrySet()) {
            IDefinition[] defs = projectScope.findAllDefinitionsByName(Multiname.crackDottedQName(this.getProject(), (String)dependencyEntry.getKey(), true));
            if (defs == null || defs.length == 0) {
                NoDefinitionForSWCDependencyProblem problem = new NoDefinitionForSWCDependencyProblem(this.getRootFileSpecification().getPath(), this.getAbsoluteFilename(), (String)dependencyEntry.getKey(), this.script.getDefinitions().iterator().next());
                problems.add(problem);
                continue;
            }
            assert (defs != null && defs.length <= 1) : "Lookups using a fully qualified name should find at most 1 definition";
            ICompilationUnit referencedCU = projectScope.getCompilationUnitForScope(defs[0].getContainingScope());
            DependencyTypeSet dependencyTypes = DependencyTypeSet.copyOf((Collection)dependencyEntry.getValue());
            this.getProject().addDependency((ICompilationUnit)this, referencedCU, dependencyTypes, defs[0].getQualifiedName());
        }
        for (String bundleName : this.resourceBundles) {
            ResourceBundleUtils.resolveDependencies(bundleName, this, this.getProject(), null, problems);
        }
        IOutgoingDependenciesRequestResult result = new IOutgoingDependenciesRequestResult(){

            @Override
            public ICompilerProblem[] getProblems() {
                return problems.toArray(new ICompilerProblem[problems.size()]);
            }
        };
        this.stopProfile(ICompilationUnit.Operation.GET_SEMANTIC_PROBLEMS);
        return result;
    }

    private void addAssetTagDependencies(SetMultimap<String, DependencyType> dependencies) {
        SWFCache.SWFInSWCCacheKey key = SWFCache.createKey(this.swc, this.library.getPath());
        ITagContainer swfTags = (ITagContainer)this.getProject().getWorkspace().getSWCManager().getSWFCache().get(key);
        Collection<SymbolClassTag> symbolTags = SWFCache.findAllSymbolClassTags(swfTags);
        for (String defQName : this.script.getDefinitions()) {
            AssetTagCache.AssetTagCacheKey assetCacheKey = AssetTagCache.createKey(this.swc, this.library.getPath(), this.script, defQName);
            AssetTagCache.AssetTagCacheValue assetCacheValue = (AssetTagCache.AssetTagCacheValue)this.getProject().getWorkspace().getSWCManager().getAssetTagCache().get(assetCacheKey);
            if (assetCacheValue.referredTags == null) continue;
            for (ITag referredTag : assetCacheValue.referredTags) {
                if (!(referredTag instanceof ICharacterTag)) continue;
                for (SymbolClassTag symbolTag : symbolTags) {
                    String symbol = symbolTag.getSymbolName((ICharacterTag)referredTag);
                    if (symbol == null) continue;
                    dependencies.put((Object)symbol, (Object)DependencyType.EXPRESSION);
                }
            }
        }
    }

    public boolean isANE() {
        return this.swc.isANE();
    }

    @Override
    public String getName() {
        assert (this.name.equals(this.computeName()));
        return this.name;
    }

    private String computeName() {
        return SWCCompilationUnit.getLinkReportName(this);
    }

    @Override
    protected void handleClean(boolean cleanFileScope, Map<ICompilerProject, Set<File>> invalidatedSWCFiles) {
        if (!cleanFileScope) {
            return;
        }
        File swcFile = this.swc.getSWCFile();
        this.addInvalidatedSWCtoList(invalidatedSWCFiles, swcFile, this.getProject());
    }

    private void addInvalidatedSWCtoList(Map<ICompilerProject, Set<File>> invalidatedSWCFiles, File swcFile, CompilerProject project) {
        if (invalidatedSWCFiles == null) {
            return;
        }
        Set<File> swcsInProject = invalidatedSWCFiles.get(project);
        if (swcsInProject == null) {
            swcsInProject = new HashSet<File>();
            invalidatedSWCFiles.put(project, swcsInProject);
        }
        swcsInProject.add(swcFile);
    }

    protected static String getLinkReportName(ICompilationUnit cu) {
        StringBuilder reportBuilder = new StringBuilder(cu.getAbsoluteFilename());
        reportBuilder.append('(');
        ArrayList<String> definitionQnames = new ArrayList<String>(cu.getDefinitionPromises().size());
        for (IDefinition definition : cu.getDefinitionPromises()) {
            definitionQnames.add(definition.getQualifiedName());
        }
        Collections.sort(definitionQnames, new LinkReportWriter.QNameComparator());
        for (String qname : definitionQnames) {
            int lastOccurence = qname.lastIndexOf(46);
            String xmlStyleScriptName = qname;
            if (lastOccurence > -1) {
                xmlStyleScriptName = qname.substring(0, lastOccurence) + ":" + qname.substring(lastOccurence + 1, qname.length());
            }
            reportBuilder.append(xmlStyleScriptName);
            reportBuilder.append(", ");
        }
        reportBuilder.delete(reportBuilder.length() - 2, reportBuilder.length());
        reportBuilder.append(')');
        return reportBuilder.toString();
    }

    @Override
    public String toString() {
        return "SWC: " + this.getDefinitionPromises().toString();
    }
}

