/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.units;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.flex.abc.ABCEmitter;
import org.apache.flex.abc.instructionlist.InstructionList;
import org.apache.flex.abc.semantics.Name;
import org.apache.flex.compiler.common.DependencyType;
import org.apache.flex.compiler.common.Multiname;
import org.apache.flex.compiler.definitions.IDefinition;
import org.apache.flex.compiler.definitions.INamespaceDefinition;
import org.apache.flex.compiler.definitions.references.INamespaceReference;
import org.apache.flex.compiler.definitions.references.IResolvedQualifiersReference;
import org.apache.flex.compiler.definitions.references.ReferenceFactory;
import org.apache.flex.compiler.internal.abc.ClassGeneratorHelper;
import org.apache.flex.compiler.internal.definitions.ClassDefinition;
import org.apache.flex.compiler.internal.embedding.EmbedData;
import org.apache.flex.compiler.internal.projects.CompilerProject;
import org.apache.flex.compiler.internal.projects.DefinitionPriority;
import org.apache.flex.compiler.internal.projects.FlexProject;
import org.apache.flex.compiler.internal.scopes.ASFileScope;
import org.apache.flex.compiler.internal.scopes.ASProjectScope;
import org.apache.flex.compiler.internal.units.CompilationUnitBase;
import org.apache.flex.compiler.internal.units.requests.ABCBytesRequestResult;
import org.apache.flex.compiler.internal.units.requests.FileScopeRequestResultBase;
import org.apache.flex.compiler.internal.units.requests.SWFTagsRequestResult;
import org.apache.flex.compiler.internal.units.requests.SyntaxTreeRequestResult;
import org.apache.flex.compiler.problems.ICompilerProblem;
import org.apache.flex.compiler.problems.InternalCompilerProblem;
import org.apache.flex.compiler.scopes.IASScope;
import org.apache.flex.compiler.units.ICompilationUnit;
import org.apache.flex.compiler.units.requests.IABCBytesRequestResult;
import org.apache.flex.compiler.units.requests.IFileScopeRequestResult;
import org.apache.flex.compiler.units.requests.IOutgoingDependenciesRequestResult;
import org.apache.flex.compiler.units.requests.ISWFTagsRequestResult;
import org.apache.flex.compiler.units.requests.ISyntaxTreeRequestResult;

public class ResourceModuleCompilationUnit
extends CompilationUnitBase {
    private final String qname;
    private final Collection<ICompilationUnit> resourceBundleCompUnits;

    public ResourceModuleCompilationUnit(CompilerProject project, String qname, Collection<ICompilationUnit> resourceBundleCompUnits, DefinitionPriority.BasePriority basePriority) {
        super(project, null, basePriority, qname);
        this.resourceBundleCompUnits = resourceBundleCompUnits;
        this.qname = qname;
    }

    @Override
    public ICompilationUnit.UnitType getCompilationUnitType() {
        return ICompilationUnit.UnitType.RESOURCE_UNIT;
    }

    @Override
    protected ISyntaxTreeRequestResult handleSyntaxTreeRequest() throws InterruptedException {
        return new SyntaxTreeRequestResult(-1L, Collections.<ICompilerProblem>emptyList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IFileScopeRequestResult handleFileScopeRequest() throws InterruptedException {
        this.startProfile(ICompilationUnit.Operation.GET_FILESCOPE);
        try {
            ASFileScope fileScope = new ASFileScope(this.getProject().getWorkspace(), null);
            Multiname mname = Multiname.crackDottedQName(this.getProject(), this.qname);
            INamespaceDefinition packageNS = (INamespaceDefinition)Iterables.getOnlyElement(mname.getNamespaceSet());
            ClassDefinition classDefinition = new ClassDefinition(mname.getBaseName(), (INamespaceReference)((Object)packageNS));
            fileScope.addDefinition(classDefinition);
            FileScopeRequestResultBase fileScopeRequestResultBase = new FileScopeRequestResultBase(Collections.<ICompilerProblem>emptySet(), (Collection<? extends IASScope>)ImmutableSet.of((Object)fileScope));
            return fileScopeRequestResultBase;
        }
        finally {
            this.stopProfile(ICompilationUnit.Operation.GET_FILESCOPE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IOutgoingDependenciesRequestResult handleOutgoingDependenciesRequest() throws InterruptedException {
        this.startProfile(ICompilationUnit.Operation.GET_SEMANTIC_PROBLEMS);
        final List problems = Collections.emptyList();
        try {
            FlexProject flexProject = (FlexProject)this.getProject();
            ASProjectScope scope = flexProject.getScope();
            IDefinition def = scope.findDefinitionByName(flexProject.getResourceModuleBaseClass());
            ICompilationUnit resourceModuleBaseCompUnit = scope.getCompilationUnitForDefinition(def);
            flexProject.addDependency((ICompilationUnit)this, resourceModuleBaseCompUnit, DependencyType.INHERITANCE, def.getQualifiedName());
            for (ICompilationUnit compUnit : this.resourceBundleCompUnits) {
                flexProject.addDependency(this, compUnit, DependencyType.EXPRESSION);
            }
        }
        catch (Exception t) {
            problems.add(new InternalCompilerProblem(t));
        }
        finally {
            this.stopProfile(ICompilationUnit.Operation.GET_SEMANTIC_PROBLEMS);
        }
        return new IOutgoingDependenciesRequestResult(){

            @Override
            public ICompilerProblem[] getProblems() {
                return problems.toArray(new ICompilerProblem[0]);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IABCBytesRequestResult handleABCBytesRequest() throws InterruptedException {
        this.startProfile(ICompilationUnit.Operation.GET_ABC_BYTES);
        try {
            FlexProject flexProject = (FlexProject)this.getProject();
            LinkedList<InternalCompilerProblem> problems = new LinkedList<InternalCompilerProblem>();
            ABCEmitter emitter = new ABCEmitter();
            byte[] generatedBytes = null;
            try {
                IResolvedQualifiersReference resourceModuleBaseRef = ReferenceFactory.packageQualifiedReference(flexProject.getWorkspace(), flexProject.getResourceModuleBaseClass());
                InstructionList constructorInstructionList = new InstructionList();
                constructorInstructionList.addInstruction(208);
                constructorInstructionList.addInstruction(48);
                int resourceBundleCount = 0;
                for (ICompilationUnit compUnit : this.resourceBundleCompUnits) {
                    for (IDefinition def : compUnit.getDefinitionPromises()) {
                        constructorInstructionList.addInstruction(44, def.getQualifiedName());
                        ++resourceBundleCount;
                    }
                }
                constructorInstructionList.addInstruction(86, resourceBundleCount);
                constructorInstructionList.addInstruction(73, 1);
                constructorInstructionList.addInstruction(71);
                ClassGeneratorHelper classGen = new ClassGeneratorHelper(flexProject, emitter, new Name(this.qname), (ClassDefinition)resourceModuleBaseRef.resolve(flexProject), Collections.<Name>emptyList(), constructorInstructionList);
                classGen.finishScript();
                generatedBytes = emitter.emit();
            }
            catch (Exception ex) {
                problems.add(new InternalCompilerProblem(ex));
            }
            ABCBytesRequestResult aBCBytesRequestResult = new ABCBytesRequestResult(generatedBytes, problems.toArray(new ICompilerProblem[0]), Collections.<EmbedData>emptySet());
            return aBCBytesRequestResult;
        }
        finally {
            this.stopProfile(ICompilationUnit.Operation.GET_ABC_BYTES);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ISWFTagsRequestResult handleSWFTagsRequest() throws InterruptedException {
        this.startProfile(ICompilationUnit.Operation.GET_SWF_TAGS);
        try {
            IABCBytesRequestResult abcResult = this.getABCBytesRequest().get();
            SWFTagsRequestResult sWFTagsRequestResult = new SWFTagsRequestResult(abcResult.getABCBytes(), this.qname);
            return sWFTagsRequestResult;
        }
        finally {
            this.stopProfile(ICompilationUnit.Operation.GET_SWF_TAGS);
        }
    }
}

