/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.units;

import com.google.common.base.FinalizableReferenceQueue;
import com.google.common.base.FinalizableWeakReference;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.io.FilenameUtils;
import org.apache.flex.compiler.common.DependencyType;
import org.apache.flex.compiler.common.IDefinitionPriority;
import org.apache.flex.compiler.common.IEmbedResolver;
import org.apache.flex.compiler.common.IFileSpecificationGetter;
import org.apache.flex.compiler.css.ICSSDocument;
import org.apache.flex.compiler.css.ICSSRule;
import org.apache.flex.compiler.css.ICSSSelector;
import org.apache.flex.compiler.definitions.IClassDefinition;
import org.apache.flex.compiler.definitions.IDefinition;
import org.apache.flex.compiler.filespecs.IFileSpecification;
import org.apache.flex.compiler.internal.css.CSSFunctionCallPropertyValue;
import org.apache.flex.compiler.internal.css.codegen.CSSCompilationSession;
import org.apache.flex.compiler.internal.css.semantics.CSSSemanticAnalyzer;
import org.apache.flex.compiler.internal.embedding.EmbedAttribute;
import org.apache.flex.compiler.internal.embedding.EmbedData;
import org.apache.flex.compiler.internal.graph.LinkReportWriter;
import org.apache.flex.compiler.internal.projects.ASProject;
import org.apache.flex.compiler.internal.projects.CompilerProject;
import org.apache.flex.compiler.internal.projects.DefinitionPriority;
import org.apache.flex.compiler.internal.scopes.ASFileScope;
import org.apache.flex.compiler.internal.scopes.ASProjectScope;
import org.apache.flex.compiler.internal.tree.as.NodeBase;
import org.apache.flex.compiler.internal.units.ASCompilationUnit;
import org.apache.flex.compiler.internal.units.EmbedCompilationUnit;
import org.apache.flex.compiler.internal.units.InvisibleCompilationUnit;
import org.apache.flex.compiler.internal.units.MXMLCompilationUnit;
import org.apache.flex.compiler.internal.units.requests.ABCBytesRequestResult;
import org.apache.flex.compiler.internal.units.requests.FileScopeRequestResultBase;
import org.apache.flex.compiler.internal.units.requests.RequestMaker;
import org.apache.flex.compiler.internal.units.requests.SyntaxTreeRequestResult;
import org.apache.flex.compiler.mxml.IXMLNameResolver;
import org.apache.flex.compiler.problems.ICompilerProblem;
import org.apache.flex.compiler.problems.InternalCompilerProblem2;
import org.apache.flex.compiler.projects.ICompilerProject;
import org.apache.flex.compiler.projects.IFlexProject;
import org.apache.flex.compiler.targets.ITarget;
import org.apache.flex.compiler.tree.as.IASNode;
import org.apache.flex.compiler.tree.as.IFileNodeAccumulator;
import org.apache.flex.compiler.tree.as.IImportNode;
import org.apache.flex.compiler.units.ICompilationUnit;
import org.apache.flex.compiler.units.requests.IABCBytesRequestResult;
import org.apache.flex.compiler.units.requests.IFileScopeRequestResult;
import org.apache.flex.compiler.units.requests.IOutgoingDependenciesRequestResult;
import org.apache.flex.compiler.units.requests.IRequest;
import org.apache.flex.compiler.units.requests.ISWFTagsRequestResult;
import org.apache.flex.compiler.units.requests.ISyntaxTreeRequestResult;
import org.apache.flex.compiler.workspaces.IWorkspaceProfilingDelegate;
import org.apache.flex.swf.SWFFrame;
import org.apache.flex.utils.FilenameNormalization;
import org.apache.flex.utils.StringEncoder;

public abstract class CompilationUnitBase
implements ICompilationUnit {
    protected static final String DEFAULT_DO_ABC_TAG_NAME = "script";
    private CompilerProject project;
    private final String absoluteFilename;
    private List<IDefinition> definitionPromises;
    private final DefinitionPriority definitionPriority;
    protected final AtomicReference<IRequest<ISyntaxTreeRequestResult, ICompilationUnit>> syntaxTreeRequest;
    protected final AtomicReference<IRequest<IFileScopeRequestResult, ICompilationUnit>> fileScopeRequest;
    protected final AtomicReference<IRequest<IABCBytesRequestResult, ICompilationUnit>> abc;
    private final AtomicReference<IRequest<ISWFTagsRequestResult, ICompilationUnit>> tags;
    protected final AtomicReference<IRequest<IOutgoingDependenciesRequestResult, ICompilationUnit>> problems;
    private final Set<ICompilationUnit> embedCompilationUnits;
    private IFileSpecificationGetter fileSpecificationGetter;
    private InvisibleCompilationUnitRef invisibleCURef;
    private final AtomicInteger state;
    private String name;
    private final boolean scopeBuiltFromSyntaxTree;
    private static final RequestMaker<ISyntaxTreeRequestResult, ICompilationUnit, CompilationUnitBase> syntaxTreeRequestMaker = new RequestMaker<ISyntaxTreeRequestResult, ICompilationUnit, CompilationUnitBase>(){

        @Override
        protected Callable<ISyntaxTreeRequestResult> getCallable(final CompilationUnitBase u) {
            return new Callable<ISyntaxTreeRequestResult>(){

                @Override
                public ISyntaxTreeRequestResult call() throws InterruptedException {
                    return u.processSyntaxTreeRequest();
                }
            };
        }

        @Override
        protected ISyntaxTreeRequestResult getResultForThrowable(CompilationUnitBase u, Throwable throwable) {
            InternalCompilerProblem2 prob = new InternalCompilerProblem2(u.getRootFileSpecification().getPath(), throwable, "syntax tree request");
            return new SyntaxTreeRequestResult(u.getRootFileSpecification().getLastModified(), Collections.singleton(prob));
        }
    };
    private static final RequestMaker<IFileScopeRequestResult, ICompilationUnit, CompilationUnitBase> fileScopeRequestMaker = new RequestMaker<IFileScopeRequestResult, ICompilationUnit, CompilationUnitBase>(){

        @Override
        protected Callable<IFileScopeRequestResult> getCallable(final CompilationUnitBase u) {
            return new Callable<IFileScopeRequestResult>(){

                @Override
                public IFileScopeRequestResult call() throws InterruptedException {
                    return u.processFileScopeRequest();
                }
            };
        }

        @Override
        protected IFileScopeRequestResult getResultForThrowable(CompilationUnitBase u, Throwable throwable) {
            InternalCompilerProblem2 prob = new InternalCompilerProblem2(u.getRootFileSpecification().getPath(), throwable, "file scope builder");
            return new FileScopeRequestResultBase(Collections.singleton(prob), null);
        }
    };
    private static final RequestMaker<IABCBytesRequestResult, ICompilationUnit, CompilationUnitBase> abcBytesRequestMaker = new RequestMaker<IABCBytesRequestResult, ICompilationUnit, CompilationUnitBase>(){

        @Override
        protected Callable<IABCBytesRequestResult> getCallable(final CompilationUnitBase u) {
            return new Callable<IABCBytesRequestResult>(){

                @Override
                public IABCBytesRequestResult call() throws Exception {
                    return u.processABCBytesRequest();
                }
            };
        }

        @Override
        protected IABCBytesRequestResult getResultForThrowable(CompilationUnitBase u, Throwable throwable) {
            return new ABCBytesRequestResult(new ICompilerProblem[]{new InternalCompilerProblem2(u.getAbsoluteFilename(), throwable, "ABC generator")});
        }
    };
    private static final RequestMaker<ISWFTagsRequestResult, ICompilationUnit, CompilationUnitBase> swfTagsRequestMaker = new RequestMaker<ISWFTagsRequestResult, ICompilationUnit, CompilationUnitBase>(){

        @Override
        protected Callable<ISWFTagsRequestResult> getCallable(final CompilationUnitBase u) {
            return new Callable<ISWFTagsRequestResult>(){

                @Override
                public ISWFTagsRequestResult call() throws Exception {
                    return u.processSWFTTagsRequest();
                }
            };
        }

        @Override
        protected ISWFTagsRequestResult getResultForThrowable(CompilationUnitBase u, Throwable throwable) {
            final InternalCompilerProblem2 prob = new InternalCompilerProblem2(u.getRootFileSpecification().getPath(), throwable, "SWFTags");
            return new ISWFTagsRequestResult(){

                @Override
                public ICompilerProblem[] getProblems() {
                    return new ICompilerProblem[]{prob};
                }

                @Override
                public boolean addToFrame(SWFFrame f) {
                    return false;
                }

                @Override
                public String getDoABCTagName() {
                    return "";
                }
            };
        }
    };
    private static final RequestMaker<IOutgoingDependenciesRequestResult, ICompilationUnit, CompilationUnitBase> outgoingDependenciesRequestMaker = new RequestMaker<IOutgoingDependenciesRequestResult, ICompilationUnit, CompilationUnitBase>(){

        @Override
        protected Callable<IOutgoingDependenciesRequestResult> getCallable(final CompilationUnitBase u) {
            return new Callable<IOutgoingDependenciesRequestResult>(){

                @Override
                public IOutgoingDependenciesRequestResult call() throws Exception {
                    return u.processOutgoingDependenciesRequest();
                }
            };
        }

        @Override
        protected IOutgoingDependenciesRequestResult getResultForThrowable(CompilationUnitBase u, Throwable throwable) {
            final InternalCompilerProblem2 prob = new InternalCompilerProblem2(u.getRootFileSpecification().getPath(), throwable, "outgoing dependency");
            return new IOutgoingDependenciesRequestResult(){

                @Override
                public ICompilerProblem[] getProblems() {
                    return new ICompilerProblem[]{prob};
                }
            };
        }
    };

    protected void updateStyleCompilationUnitDependencies(CSSCompilationSession cssCompilationSession, IXMLNameResolver xmlNameResolver, Iterable<ICSSDocument> cssDocuments, Collection<ICompilerProblem> problems) {
        LinkedHashSet<IClassDefinition> classReferences = new LinkedHashSet<IClassDefinition>();
        LinkedHashSet<EmbedCompilationUnit> dependentEmbedCompilationUnits = new LinkedHashSet<EmbedCompilationUnit>();
        for (ICSSDocument cssDocument : cssDocuments) {
            boolean isFlex3CSS = ((IFlexProject)((Object)this.project)).getCSSManager().isFlex3CSS();
            ImmutableMap<ICSSSelector, String> resolvedSelectors = CSSSemanticAnalyzer.resolveSelectors(xmlNameResolver, cssDocument, problems, isFlex3CSS);
            cssCompilationSession.resolvedSelectors.putAll((Map<ICSSSelector, String>)resolvedSelectors);
            for (ICSSRule cssRule : cssDocument.getRules()) {
                HashMap<CSSFunctionCallPropertyValue, EmbedCompilationUnit> resolvedEmbedProperties = new HashMap<CSSFunctionCallPropertyValue, EmbedCompilationUnit>();
                CSSSemanticAnalyzer.resolveDependencies(resolvedEmbedProperties, cssRule, this.project, classReferences, dependentEmbedCompilationUnits, problems);
                cssCompilationSession.resolvedEmbedProperties.putAll(resolvedEmbedProperties);
            }
        }
        Function<IClassDefinition, ICompilationUnit> findCompilationUnitForClass = new Function<IClassDefinition, ICompilationUnit>(){

            public ICompilationUnit apply(IClassDefinition classDefinition) {
                return CompilationUnitBase.this.project.getScope().getCompilationUnitForDefinition(classDefinition);
            }
        };
        Collection classReferenceCompilationUnits = Collections2.transform(classReferences, (Function)findCompilationUnitForClass);
        ImmutableSet dependencies = new ImmutableSet.Builder().addAll((Iterable)classReferenceCompilationUnits).addAll(dependentEmbedCompilationUnits).build();
        for (ICompilationUnit dependee : dependencies) {
            this.project.getDependencyGraph().addDependency(this, dependee, DependencyType.EXPRESSION);
        }
    }

    private CompilationUnitBase(CompilerProject project, String path, DefinitionPriority.BasePriority basePriority, boolean doInitDefinitionPromises, boolean scopeBuiltFromSyntaxTree) {
        this.project = project;
        this.absoluteFilename = FilenameNormalization.normalize(path);
        this.definitionPriority = new DefinitionPriority(basePriority, 0L);
        this.syntaxTreeRequest = new AtomicReference();
        this.fileScopeRequest = new AtomicReference();
        this.abc = new AtomicReference();
        this.tags = new AtomicReference();
        this.problems = new AtomicReference();
        this.embedCompilationUnits = new HashSet<ICompilationUnit>();
        this.fileSpecificationGetter = project.getWorkspace();
        this.state = new AtomicInteger();
        if (doInitDefinitionPromises) {
            this.definitionPromises = Collections.emptyList();
            this.name = this.computeName();
        }
        this.scopeBuiltFromSyntaxTree = scopeBuiltFromSyntaxTree;
    }

    protected CompilationUnitBase(CompilerProject project, String path, DefinitionPriority.BasePriority basePriority, Collection<String> qnamesOfDefinitions) {
        this(project, path, basePriority, false, qnamesOfDefinitions.isEmpty());
        this.definitionPromises = CompilationUnitBase.createDefinitionPromisesFromQnames(qnamesOfDefinitions, this);
        this.name = this.computeName();
    }

    protected CompilationUnitBase(CompilerProject project, String path, DefinitionPriority.BasePriority basePriority, boolean scopeBuiltFromSytaxTree) {
        this(project, path, basePriority, true, scopeBuiltFromSytaxTree);
    }

    protected CompilationUnitBase(CompilerProject project, String path, DefinitionPriority.BasePriority basePriority, String qnameOfDefinition) {
        this(project, path, basePriority, qnameOfDefinition == null ? Collections.emptyList() : Collections.singletonList(qnameOfDefinition));
    }

    private static List<IDefinition> createDefinitionPromisesFromQnames(Collection<String> qnames, ICompilationUnit cu) {
        ArrayList<IDefinition> ret = new ArrayList<IDefinition>();
        for (String qname : qnames) {
            if (qname == null) continue;
            ret.add(ASProjectScope.createDefinitionPromise(qname, cu));
        }
        return ret;
    }

    private final void operationComplete(ICompilationUnit.Operation operation) {
        int newState;
        int currentState;
        boolean done = false;
        while (!(done = this.state.compareAndSet(currentState = this.state.get(), newState = currentState | operation.mask))) {
        }
    }

    protected final boolean operationsCompleted(EnumSet<ICompilationUnit.Operation> operations) {
        int currentState = this.state.get();
        for (ICompilationUnit.Operation operation : operations) {
            if ((currentState & operation.mask) != 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public List<IDefinition> getDefinitionPromises() {
        return this.definitionPromises;
    }

    @Override
    public CompilerProject getProject() {
        return this.project;
    }

    protected abstract ISyntaxTreeRequestResult handleSyntaxTreeRequest() throws InterruptedException;

    protected abstract IFileScopeRequestResult handleFileScopeRequest() throws InterruptedException;

    protected abstract IABCBytesRequestResult handleABCBytesRequest() throws InterruptedException;

    protected abstract ISWFTagsRequestResult handleSWFTagsRequest() throws InterruptedException;

    protected abstract IOutgoingDependenciesRequestResult handleOutgoingDependenciesRequest() throws InterruptedException;

    @Override
    public IRequest<ISyntaxTreeRequestResult, ICompilationUnit> getSyntaxTreeRequest() {
        return syntaxTreeRequestMaker.getRequest(this, this.syntaxTreeRequest, this.project.getWorkspace(), this.scopeBuiltFromSyntaxTree);
    }

    @Override
    public IRequest<IFileScopeRequestResult, ICompilationUnit> getFileScopeRequest() {
        return fileScopeRequestMaker.getRequest(this, this.fileScopeRequest, this.project.getWorkspace(), true);
    }

    @Override
    public IRequest<IABCBytesRequestResult, ICompilationUnit> getABCBytesRequest() {
        return abcBytesRequestMaker.getRequest(this, this.abc, this.project.getWorkspace(), false);
    }

    @Override
    public IRequest<ISWFTagsRequestResult, ICompilationUnit> getSWFTagsRequest() {
        return swfTagsRequestMaker.getRequest(this, this.tags, this.project.getWorkspace(), false);
    }

    @Override
    public IRequest<IOutgoingDependenciesRequestResult, ICompilationUnit> getOutgoingDependenciesRequest() {
        return outgoingDependenciesRequestMaker.getRequest(this, this.problems, this.project.getWorkspace(), false);
    }

    private Collection<IDefinition> getAllDefinitions() throws InterruptedException {
        Collection<IDefinition> definitions;
        if (this.definitionPromises.isEmpty()) {
            IFileScopeRequestResult fileScopeRequestResult = this.getFileScopeRequest().get();
            definitions = fileScopeRequestResult.getExternallyVisibleDefinitions();
        } else {
            definitions = this.definitionPromises;
        }
        return definitions;
    }

    @Override
    public List<String> getShortNames() throws InterruptedException {
        Collection<IDefinition> definitions = this.getAllDefinitions();
        ArrayList<String> shortNames = new ArrayList<String>(definitions.size());
        for (IDefinition definition : definitions) {
            shortNames.add(definition.getBaseName());
        }
        return shortNames;
    }

    @Override
    public List<String> getQualifiedNames() throws InterruptedException {
        Collection<IDefinition> definitions = this.getAllDefinitions();
        ArrayList<String> qualifiedNames = new ArrayList<String>(definitions.size());
        for (IDefinition definition : definitions) {
            qualifiedNames.add(definition.getQualifiedName());
        }
        return qualifiedNames;
    }

    @Override
    public final String getAbsoluteFilename() {
        return this.absoluteFilename;
    }

    protected final String getFilenameNoPath() {
        return FilenameUtils.getName((String)this.absoluteFilename);
    }

    protected IFileSpecification getRootFileSpecification() {
        String fileName = this.getAbsoluteFilename();
        return this.fileSpecificationGetter.getFileSpecification(fileName);
    }

    protected IFileSpecificationGetter getFileSpecificationGetter() {
        return this.fileSpecificationGetter;
    }

    @Override
    public boolean clean(Map<ICompilerProject, Set<File>> invalidatedSWCFiles, Map<ICompilerProject, Set<ICompilationUnit>> cusToUpdate, boolean clearFileScope) {
        IWorkspaceProfilingDelegate profilingDelegate = this.project.getWorkspace().getProfilingDelegate();
        if (profilingDelegate != null) {
            profilingDelegate.operationStarted(this, ICompilationUnit.Operation.INVALIDATE_CU);
        }
        this.project.removeDependencies(Collections.singletonList(this));
        if (clearFileScope) {
            this.clearIncludedFilesFromWorkspace();
            if (!this.isInvisible()) {
                this.project.getScope().removeCompilationUnits(Collections.singletonList(this));
            }
            this.fileScopeRequest.set(null);
            this.syntaxTreeRequest.set(null);
            this.project.removeAnyUnfoundDependencies(this);
        }
        this.abc.set(null);
        this.tags.set(null);
        this.problems.set(null);
        this.embedCompilationUnits.clear();
        this.project.resetScopeCacheForCompilationUnit(this);
        if (clearFileScope) {
            this.updateDefinitions(cusToUpdate);
        }
        this.handleClean(clearFileScope, invalidatedSWCFiles);
        if (profilingDelegate != null) {
            profilingDelegate.operationCompleted(this, ICompilationUnit.Operation.INVALIDATE_CU);
        }
        return true;
    }

    public void clearIncludedFilesFromWorkspace() {
        try {
            IRequest<ISyntaxTreeRequestResult, ICompilationUnit> req = this.syntaxTreeRequest.get();
            if (req != null && req.isDone()) {
                this.project.getWorkspace().removeIncludedFilesToCompilationUnit(this, (Collection<String>)req.get().getIncludedFiles());
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected void handleClean(boolean clearFileScope, Map<ICompilerProject, Set<File>> invalidatedSWCFiles) {
    }

    private void updateDefinitions(Map<ICompilerProject, Set<ICompilationUnit>> cusToUpdate) {
        if (this.isInvisible()) {
            return;
        }
        if (this.definitionPromises.isEmpty()) {
            Set<ICompilationUnit> cus = cusToUpdate.get(this.getProject());
            if (cus == null) {
                cus = new HashSet<ICompilationUnit>();
                cusToUpdate.put(this.getProject(), cus);
            }
            cus.add(this);
        } else {
            for (IDefinition definitionPromise : this.definitionPromises) {
                if (definitionPromise instanceof ASProjectScope.DefinitionPromise) {
                    ((ASProjectScope.DefinitionPromise)definitionPromise).clean();
                }
                this.project.getScope().addDefinition(definitionPromise);
            }
        }
    }

    protected final void startProfile(ICompilationUnit.Operation operation) {
        IWorkspaceProfilingDelegate profilingDelegate = this.project.getWorkspace().getProfilingDelegate();
        if (profilingDelegate == null) {
            return;
        }
        profilingDelegate.operationStarted(this, operation);
    }

    protected final void stopProfile(ICompilationUnit.Operation operation) {
        IWorkspaceProfilingDelegate profilingDelegate = this.project.getWorkspace().getProfilingDelegate();
        if (profilingDelegate == null) {
            return;
        }
        profilingDelegate.operationCompleted(this, operation);
    }

    private ISyntaxTreeRequestResult processSyntaxTreeRequest() throws InterruptedException {
        ISyntaxTreeRequestResult result = this.handleSyntaxTreeRequest();
        IASNode ast = result.getAST();
        this.verifyAST(ast);
        this.operationComplete(ICompilationUnit.Operation.GET_SYNTAX_TREE);
        return result;
    }

    protected void verifyAST(IASNode ast) {
        if (ast != null) assert (((NodeBase)ast).verify()) : "AST failed verification";
    }

    protected final void addScopeToProjectScope(ASFileScope[] scopes) {
        ASProjectScope projectScope = this.project.getScope();
        for (ASFileScope scope : scopes) {
            assert (scope.verify()) : "Scope failed verification";
            projectScope.addScopeForCompilationUnit(this, scope);
        }
    }

    private IFileScopeRequestResult processFileScopeRequest() throws InterruptedException {
        FileScopeRequestResultBase result = (FileScopeRequestResultBase)this.handleFileScopeRequest();
        ASFileScope[] scopes = result.getFileScopes();
        this.addScopeToProjectScope(scopes);
        this.operationComplete(ICompilationUnit.Operation.GET_FILESCOPE);
        return result;
    }

    private IABCBytesRequestResult processABCBytesRequest() throws InterruptedException {
        IABCBytesRequestResult result = this.handleABCBytesRequest();
        this.operationComplete(ICompilationUnit.Operation.GET_ABC_BYTES);
        this.removeAST();
        return result;
    }

    private ISWFTagsRequestResult processSWFTTagsRequest() throws InterruptedException {
        ISWFTagsRequestResult result = this.handleSWFTagsRequest();
        this.operationComplete(ICompilationUnit.Operation.GET_SWF_TAGS);
        return result;
    }

    private IOutgoingDependenciesRequestResult processOutgoingDependenciesRequest() throws InterruptedException {
        IOutgoingDependenciesRequestResult result = this.handleOutgoingDependenciesRequest();
        this.operationComplete(ICompilationUnit.Operation.GET_SEMANTIC_PROBLEMS);
        this.removeAST();
        return result;
    }

    protected void startParsingImports(IFileNodeAccumulator fna) {
        ASProjectScope projectScope = this.getProject().getScope();
        List<IImportNode> importNodes = fna.getImportNodes();
        HashSet<ICompilationUnit> compilationUnits = new HashSet<ICompilationUnit>();
        for (IImportNode importNode : importNodes) {
            String importName;
            int index;
            if (importNode.isWildcardImport() || (index = (importName = importNode.getImportName()).lastIndexOf(46)) == -1) continue;
            String className = importName.substring(index + 1);
            compilationUnits.addAll(projectScope.getCompilationUnitsByDefinitionName(className));
        }
        for (ICompilationUnit compilationUnit : compilationUnits) {
            compilationUnit.startBuildAsync(ITarget.TargetType.SWF);
        }
    }

    protected void updateEmbedCompilationUnitDependencies(List<IEmbedResolver> embedNodes, Collection<ICompilerProblem> problems) throws InterruptedException {
        HashSet<ICompilationUnit> previousEmbedCompilationUnits = new HashSet<ICompilationUnit>(this.embedCompilationUnits);
        this.embedCompilationUnits.clear();
        CompilerProject project = this.getProject();
        for (IEmbedResolver embedNode : embedNodes) {
            ICompilationUnit cu = embedNode.resolveCompilationUnit(project);
            if (cu == null) continue;
            if (!previousEmbedCompilationUnits.remove(cu)) {
                project.addDependency((ICompilationUnit)this, cu, DependencyType.EXPRESSION, cu.getQualifiedNames().get(0));
            }
            this.embedCompilationUnits.add(cu);
        }
        project.removeCompilationUnits(previousEmbedCompilationUnits);
    }

    @Override
    public Collection<String> getEmbeddedFilenames() {
        if (this.embedCompilationUnits.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<String> filenames = new HashSet<String>();
        for (ICompilationUnit cu : this.embedCompilationUnits) {
            EmbedData data = ((EmbedCompilationUnit)cu).getEmbedData();
            String sourcePath = (String)data.getAttribute(EmbedAttribute.SOURCE);
            if (sourcePath == null || sourcePath.isEmpty()) continue;
            filenames.add(sourcePath);
        }
        return filenames;
    }

    protected void removeAST() {
    }

    @Override
    public String getName() {
        assert (this.name.equals(this.computeName()));
        return this.name;
    }

    private String computeName() {
        String filename = FilenameUtils.getName((String)this.getAbsoluteFilename()).replace('.', '_');
        String encodedAbsolutePath = StringEncoder.stringToHashCodeString(this.getAbsoluteFilename());
        String encodedName = encodedAbsolutePath + ":" + filename;
        if (this.definitionPromises.isEmpty()) {
            return encodedName;
        }
        try {
            List<String> qualifiedNames = this.getQualifiedNames();
            Collections.sort(qualifiedNames, new LinkReportWriter.QNameComparator());
            return encodedName + ":" + Joiner.on((char)' ').join(qualifiedNames);
        }
        catch (InterruptedException e) {
            assert (false) : "Should not get here, because we should be able to compute qnames for def promises without getting interrupted!";
            return null;
        }
    }

    public String toString() {
        return this.getAbsoluteFilename();
    }

    @Override
    public IDefinitionPriority getDefinitionPriority() {
        return this.definitionPriority;
    }

    @Override
    public void clearProject() {
        this.project = null;
    }

    @Override
    public void waitForBuildFinish(Collection<ICompilerProblem> problems, ITarget.TargetType targetType) throws InterruptedException {
        assert (problems != null) : "Expected 'problems'. Do not ignore problems.";
        Collections.addAll(problems, this.getSyntaxTreeRequest().get().getProblems());
        Collections.addAll(problems, this.getFileScopeRequest().get().getProblems());
        Collections.addAll(problems, this.getOutgoingDependenciesRequest().get().getProblems());
        Collections.addAll(problems, this.getABCBytesRequest().get().getProblems());
        Collections.addAll(problems, this.getSWFTagsRequest().get().getProblems());
    }

    @Override
    public void startBuildAsync(ITarget.TargetType targetType) {
        boolean onlyDoOutgoing = false;
        if (!onlyDoOutgoing) {
            this.getSyntaxTreeRequest();
            this.getFileScopeRequest();
        }
        this.getOutgoingDependenciesRequest();
        if (!onlyDoOutgoing) {
            this.getABCBytesRequest();
            this.getSWFTagsRequest();
        }
    }

    public void setFileSpecificationGetter(IFileSpecificationGetter getter) {
        this.fileSpecificationGetter = getter;
    }

    public void makeInvisible(InvisibleCompilationUnit invisibleCU) {
        assert (this.invisibleCURef == null) : "makeInvisible should called exactly once or not at all";
        this.invisibleCURef = new InvisibleCompilationUnitRef(this, invisibleCU, this.getProject().getWorkspace().getInvisibleCompilationUnitReferenceQueue());
    }

    @Override
    public final boolean isInvisible() {
        return this.invisibleCURef != null;
    }

    protected Map<String, String> getEncodedDebugFiles() throws InterruptedException {
        File sourceFile;
        assert (this instanceof ASCompilationUnit || this instanceof MXMLCompilationUnit) : "getEncodedDebugFiles should only be called by AS or MXML compilation units";
        if (!(this.getProject() instanceof ASProject)) {
            return Collections.emptyMap();
        }
        ASProject asProject = (ASProject)this.getProject();
        if (!asProject.isFileOnSourcePath(sourceFile = new File(this.getAbsoluteFilename()))) {
            return Collections.emptyMap();
        }
        IDefinition def = (IDefinition)Iterables.getOnlyElement(this.getAllDefinitions());
        String packagePath = def.getPackageName().replace('.', File.separatorChar);
        String filenameNoPath = this.getFilenameNoPath();
        String rootPath = packagePath.isEmpty() ? this.getAbsoluteFilename().replace(File.separatorChar + filenameNoPath, "") : this.getAbsoluteFilename().replace(File.separatorChar + packagePath + File.separatorChar + filenameNoPath, "");
        String encodedPath = rootPath + ';' + packagePath + ';' + this.getFilenameNoPath();
        HashMap<String, String> encodedDebugFiles = new HashMap<String, String>(1);
        encodedDebugFiles.put(this.getAbsoluteFilename(), encodedPath);
        return encodedDebugFiles;
    }

    private static class InvisibleCompilationUnitRef
    extends FinalizableWeakReference<InvisibleCompilationUnit> {
        private final CompilationUnitBase delegate;

        protected InvisibleCompilationUnitRef(CompilationUnitBase delegate, InvisibleCompilationUnit referent, FinalizableReferenceQueue queue) {
            super((Object)referent, queue);
            this.delegate = delegate;
        }

        public void finalizeReferent() {
            CompilerProject project = this.delegate.getProject();
            if (project == null) {
                return;
            }
            project.removeCompilationUnit(this.delegate);
        }
    }
}

