/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.tree.mxml;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.flex.compiler.common.ISourceLocation;
import org.apache.flex.compiler.internal.mxml.MXMLDialect;
import org.apache.flex.compiler.internal.parsing.ISourceFragment;
import org.apache.flex.compiler.internal.parsing.SourceFragment;
import org.apache.flex.compiler.internal.parsing.SourceFragmentsReader;
import org.apache.flex.compiler.internal.parsing.as.ASParser;
import org.apache.flex.compiler.internal.parsing.as.IProjectConfigVariables;
import org.apache.flex.compiler.internal.projects.FlexProject;
import org.apache.flex.compiler.internal.tree.as.ExpressionNodeBase;
import org.apache.flex.compiler.internal.tree.as.LiteralNode;
import org.apache.flex.compiler.internal.tree.as.NodeBase;
import org.apache.flex.compiler.internal.tree.mxml.MXMLConcatenatedDataBindingNode;
import org.apache.flex.compiler.internal.tree.mxml.MXMLSingleDataBindingNode;
import org.apache.flex.compiler.internal.workspaces.Workspace;
import org.apache.flex.compiler.problems.ICompilerProblem;
import org.apache.flex.compiler.projects.ICompilerProject;
import org.apache.flex.compiler.tree.as.IASNode;
import org.apache.flex.compiler.tree.as.ILiteralNode;
import org.apache.flex.compiler.tree.mxml.IMXMLNode;
import org.apache.flex.compiler.tree.mxml.IMXMLSingleDataBindingNode;

class MXMLDataBindingParser {
    private static final char LEFT_BRACE = '{';
    private static final char RIGHT_BRACE = '}';
    private static final char BACKSLASH = '\\';

    MXMLDataBindingParser() {
    }

    public static Object parse(IMXMLNode parent, ISourceLocation sourceLocation, ISourceFragment[] fragments, Collection<ICompilerProblem> problems, Workspace workspace, MXMLDialect mxmlDialect, ICompilerProject project) {
        assert (fragments != null) : "Expected an array of source fragments";
        ListMultimap<ISourceFragment, Integer> scanResult = MXMLDataBindingParser.scan(fragments);
        if (scanResult == null) {
            return SourceFragmentsReader.concatLogicalText(fragments);
        }
        List<FragmentList> splitResult = MXMLDataBindingParser.split(fragments, scanResult);
        return MXMLDataBindingParser.createNode(parent, sourceLocation, splitResult, problems, workspace, mxmlDialect, project);
    }

    private static ListMultimap<ISourceFragment, Integer> scan(ISourceFragment[] fragments) {
        LinkedListMultimap result = null;
        int nesting = 0;
        ISourceFragment leftBraceFragment = null;
        int leftBraceCharIndex = -1;
        boolean escape = false;
        for (ISourceFragment fragment : fragments) {
            String text = fragment.getLogicalText();
            int n = text.length();
            block6: for (int i = 0; i < n; ++i) {
                switch (text.charAt(i)) {
                    default: {
                        escape = false;
                        continue block6;
                    }
                    case '{': {
                        if (nesting == 0 & !escape) {
                            leftBraceFragment = fragment;
                            leftBraceCharIndex = i;
                        }
                        ++nesting;
                        escape = false;
                        continue block6;
                    }
                    case '}': {
                        if (--nesting == 0) {
                            if (result == null) {
                                result = LinkedListMultimap.create();
                            }
                            result.put((Object)leftBraceFragment, (Object)leftBraceCharIndex);
                            result.put((Object)fragment, (Object)i);
                        }
                        escape = false;
                        continue block6;
                    }
                    case '\\': {
                        escape = true;
                    }
                }
            }
        }
        return result;
    }

    private static List<FragmentList> split(ISourceFragment[] fragments, ListMultimap<ISourceFragment, Integer> scanResult) {
        ArrayList<FragmentList> result = new ArrayList<FragmentList>();
        boolean inDataBinding = false;
        ArrayList currentList = null;
        for (ISourceFragment fragment : fragments) {
            List braceIndices = scanResult.get((Object)fragment);
            if (braceIndices == null) {
                if (currentList == null) {
                    currentList = MXMLDataBindingParser.newFragmentList(result, inDataBinding);
                }
                currentList.add(fragment);
                continue;
            }
            braceIndices.add(fragment.getLogicalText().length());
            int beginIndex = 0;
            Iterator i$ = braceIndices.iterator();
            while (i$.hasNext()) {
                int braceIndex = (Integer)i$.next();
                ISourceFragment subfragment = ((SourceFragment)fragment).subfragment(beginIndex, braceIndex);
                if (subfragment != null) {
                    currentList = MXMLDataBindingParser.newFragmentList(result, inDataBinding);
                    currentList.add(subfragment);
                }
                beginIndex = braceIndex + 1;
                inDataBinding = !inDataBinding;
            }
        }
        return result;
    }

    private static FragmentList newFragmentList(List<FragmentList> result, boolean inDataBinding) {
        FragmentList list = inDataBinding ? new DataBindingFragmentList() : new NonDataBindingFragmentList();
        result.add(list);
        return list;
    }

    private static IASNode createNode(IMXMLNode parent, ISourceLocation sourceLocation, List<FragmentList> listOfFragmentLists, Collection<ICompilerProblem> problems, Workspace workspace, MXMLDialect mxmlDialect, ICompilerProject project) {
        IASNode child;
        MXMLConcatenatedDataBindingNode node = new MXMLConcatenatedDataBindingNode((NodeBase)((Object)parent));
        node.setLocation(sourceLocation.getSourcePath(), sourceLocation.getAbsoluteStart(), sourceLocation.getAbsoluteEnd(), sourceLocation.getLine(), sourceLocation.getColumn());
        ArrayList<IASNode> children = new ArrayList<IASNode>();
        for (List list : listOfFragmentLists) {
            if (list instanceof DataBindingFragmentList) {
                children.add(MXMLDataBindingParser.createDataBindingNode(node, sourceLocation, list, problems, workspace, project));
                continue;
            }
            if (!(list instanceof NonDataBindingFragmentList)) continue;
            children.add(MXMLDataBindingParser.createStringLiteralNode(node, sourceLocation, list));
        }
        if (children.isEmpty()) {
            assert (listOfFragmentLists.isEmpty());
            children.add(MXMLDataBindingParser.createEmptyDatabindingNode(node, sourceLocation));
        }
        MXMLDataBindingParser.trim(children, mxmlDialect);
        node.setChildren(children.toArray(new IASNode[0]));
        if (node.getChildCount() == 1 && (child = node.getChild(0)) instanceof IMXMLSingleDataBindingNode) {
            return child;
        }
        return node;
    }

    private static ILiteralNode createStringLiteralNode(MXMLConcatenatedDataBindingNode parent, ISourceLocation sourceLocation, List<ISourceFragment> fragmentList) {
        ISourceFragment[] fragments = fragmentList.toArray(new ISourceFragment[0]);
        String text = SourceFragmentsReader.concatLogicalText(fragments);
        LiteralNode stringLiteralNode = new LiteralNode(ILiteralNode.LiteralType.STRING, text);
        stringLiteralNode.setParent(parent);
        ISourceFragment firstFragment = fragments[0];
        ISourceFragment lastFragment = fragments[fragments.length - 1];
        stringLiteralNode.setSourcePath(sourceLocation.getSourcePath());
        stringLiteralNode.setStart(firstFragment.getPhysicalStart());
        stringLiteralNode.setEnd(lastFragment.getPhysicalStart() + lastFragment.getPhysicalText().length());
        stringLiteralNode.setLine(firstFragment.getPhysicalLine());
        stringLiteralNode.setColumn(firstFragment.getPhysicalColumn());
        return stringLiteralNode;
    }

    private static IMXMLSingleDataBindingNode createDataBindingNode(IMXMLNode parent, ISourceLocation sourceLocation, List<ISourceFragment> fragments, Collection<ICompilerProblem> problems, Workspace workspace, ICompilerProject project) {
        MXMLSingleDataBindingNode result = new MXMLSingleDataBindingNode((NodeBase)((Object)parent));
        ISourceFragment firstFragment = fragments.get(0);
        ISourceFragment lastFragment = fragments.get(fragments.size() - 1);
        result.setSourcePath(sourceLocation.getSourcePath());
        result.setStart(firstFragment.getPhysicalStart() - 1);
        result.setEnd(lastFragment.getPhysicalStart() + lastFragment.getPhysicalText().length() + 1);
        result.setLine(firstFragment.getPhysicalLine());
        result.setColumn(firstFragment.getPhysicalColumn() - 1);
        SourceFragmentsReader reader = new SourceFragmentsReader(sourceLocation.getSourcePath(), fragments.toArray(new ISourceFragment[0]));
        IProjectConfigVariables projectConfigVariables = ((FlexProject)project).getProjectConfigVariables();
        ExpressionNodeBase expressionNode = ASParser.parseExpression(workspace, reader, problems, projectConfigVariables, sourceLocation);
        if (expressionNode == null) {
            expressionNode = new LiteralNode(ILiteralNode.LiteralType.STRING, "");
        }
        expressionNode.setParent(result);
        result.setExpressionNode(expressionNode);
        MXMLDataBindingParser.validateParents(expressionNode);
        return result;
    }

    private static void validateParents(NodeBase expressionNode) {
        for (int i = 0; i < expressionNode.getChildCount(); ++i) {
            IASNode child = expressionNode.getChild(i);
            if (!(child instanceof NodeBase)) continue;
            if (child.getParent() == null) {
                ((NodeBase)child).setParent((ExpressionNodeBase)expressionNode);
            }
            MXMLDataBindingParser.validateParents((NodeBase)child);
        }
    }

    private static IMXMLSingleDataBindingNode createEmptyDatabindingNode(IMXMLNode parent, ISourceLocation sourceLocation) {
        MXMLSingleDataBindingNode result = new MXMLSingleDataBindingNode((NodeBase)((Object)parent));
        result.setSourceLocation((NodeBase)((Object)parent));
        LiteralNode expressionNode = new LiteralNode(ILiteralNode.LiteralType.STRING, "");
        ((ExpressionNodeBase)expressionNode).setParent(result);
        result.setExpressionNode(expressionNode);
        return result;
    }

    private static void trim(List<IASNode> children, MXMLDialect mxmlDialect) {
        assert (children != null && !children.isEmpty());
        IASNode firstChild = children.get(0);
        MXMLDataBindingParser.removeIfWhitespace(children, firstChild, mxmlDialect);
        int n = children.size();
        IASNode lastChild = children.get(n - 1);
        MXMLDataBindingParser.removeIfWhitespace(children, lastChild, mxmlDialect);
    }

    private static void removeIfWhitespace(List<IASNode> children, IASNode child, MXMLDialect mxmlDialect) {
        String text;
        if (child instanceof ILiteralNode && mxmlDialect.isWhitespace(text = ((ILiteralNode)child).getValue())) {
            children.remove(child);
        }
        assert (!children.isEmpty());
    }

    private static class NonDataBindingFragmentList
    extends FragmentList {
        private NonDataBindingFragmentList() {
        }
    }

    private static class DataBindingFragmentList
    extends FragmentList {
        private DataBindingFragmentList() {
        }
    }

    private static abstract class FragmentList
    extends ArrayList<ISourceFragment> {
        private FragmentList() {
        }
    }
}

