/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.tree.as;

import java.util.Collection;
import java.util.EnumSet;
import org.apache.flex.compiler.constants.IASLanguageConstants;
import org.apache.flex.compiler.definitions.ITypeDefinition;
import org.apache.flex.compiler.internal.scopes.ASScope;
import org.apache.flex.compiler.internal.semantics.PostProcessStep;
import org.apache.flex.compiler.internal.tree.as.ExpressionNodeBase;
import org.apache.flex.compiler.internal.tree.as.FunctionNode;
import org.apache.flex.compiler.problems.ICompilerProblem;
import org.apache.flex.compiler.projects.ICompilerProject;
import org.apache.flex.compiler.tree.ASTNodeID;
import org.apache.flex.compiler.tree.as.IASNode;
import org.apache.flex.compiler.tree.as.IFunctionObjectNode;

public class FunctionObjectNode
extends ExpressionNodeBase
implements IFunctionObjectNode {
    private final FunctionNode functionNode;

    public FunctionObjectNode(FunctionNode functionNode) {
        if (functionNode == null) {
            throw new NullPointerException("function node can't be null");
        }
        this.functionNode = functionNode;
        this.functionNode.parent = this;
    }

    @Override
    public ASTNodeID getNodeID() {
        if (this.functionNode.getName().isEmpty()) {
            return ASTNodeID.AnonymousFunctionID;
        }
        return ASTNodeID.FunctionObjectID;
    }

    @Override
    public int getChildCount() {
        return 1;
    }

    @Override
    public IASNode getChild(int i) {
        return i == 0 ? this.functionNode : null;
    }

    @Override
    protected void setChildren(boolean fillInOffsets) {
        if (this.functionNode != null) {
            this.functionNode.setParent(this);
        }
    }

    @Override
    protected void analyze(EnumSet<PostProcessStep> set, ASScope scope, Collection<ICompilerProblem> problems) {
        EnumSet<PostProcessStep> stepsToRunOnChildren;
        if (set.contains((Object)PostProcessStep.RECONNECT_DEFINITIONS)) {
            stepsToRunOnChildren = EnumSet.copyOf(set);
            stepsToRunOnChildren.remove((Object)PostProcessStep.RECONNECT_DEFINITIONS);
            stepsToRunOnChildren.add(PostProcessStep.POPULATE_SCOPE);
        } else {
            stepsToRunOnChildren = set;
        }
        super.analyze(stepsToRunOnChildren, scope, problems);
    }

    @Override
    public ITypeDefinition resolveType(ICompilerProject project) {
        return project.getBuiltinType(IASLanguageConstants.BuiltinType.FUNCTION);
    }

    @Override
    protected FunctionObjectNode copy() {
        return null;
    }

    @Override
    public boolean isDynamicExpression(ICompilerProject project) {
        return true;
    }

    @Override
    public FunctionNode getFunctionNode() {
        return this.functionNode;
    }
}

