/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.tree.as;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.flex.compiler.common.IEmbedResolver;
import org.apache.flex.compiler.definitions.ITypeDefinition;
import org.apache.flex.compiler.definitions.metadata.IMetaTagAttribute;
import org.apache.flex.compiler.internal.projects.CompilerProject;
import org.apache.flex.compiler.internal.tree.as.ExpressionNodeBase;
import org.apache.flex.compiler.internal.units.EmbedCompilationUnit;
import org.apache.flex.compiler.internal.units.EmbedCompilationUnitFactory;
import org.apache.flex.compiler.problems.ICompilerProblem;
import org.apache.flex.compiler.projects.ICompilerProject;
import org.apache.flex.compiler.tree.ASTNodeID;
import org.apache.flex.compiler.tree.as.IEmbedNode;
import org.apache.flex.compiler.tree.as.IFileNodeAccumulator;
import org.apache.flex.compiler.tree.metadata.IMetaTagNode;
import org.apache.flex.compiler.units.ICompilationUnit;
import org.apache.flex.utils.FilenameNormalization;

public class EmbedNode
extends ExpressionNodeBase
implements IEmbedNode,
IEmbedResolver {
    private final String containingSourceFilename;
    private final IMetaTagNode metaData;

    public EmbedNode(String containingFilePath, IMetaTagNode metaData, IFileNodeAccumulator fileNodeAccumulator) {
        this.containingSourceFilename = FilenameNormalization.normalize(containingFilePath);
        this.metaData = metaData;
        assert (metaData != null && metaData.getAllAttributes() != null);
        if (fileNodeAccumulator != null) {
            fileNodeAccumulator.addEmbedNode(this);
        }
    }

    @Override
    public ASTNodeID getNodeID() {
        return ASTNodeID.EmbedID;
    }

    @Override
    public ITypeDefinition resolveType(ICompilerProject project) {
        return null;
    }

    @Override
    protected EmbedNode copy() {
        return null;
    }

    @Override
    public IMetaTagAttribute[] getAttributes() {
        return this.metaData.getAllAttributes();
    }

    @Override
    public EmbedCompilationUnit resolveCompilationUnit(ICompilerProject project, Collection<ICompilerProblem> problems) throws InterruptedException {
        assert (project instanceof CompilerProject);
        return EmbedCompilationUnitFactory.getCompilationUnit((CompilerProject)project, this.containingSourceFilename, this.metaData, this.metaData.getAllAttributes(), problems);
    }

    @Override
    public EmbedCompilationUnit resolveCompilationUnit(ICompilerProject project) throws InterruptedException {
        ArrayList ignoredProblems = new ArrayList();
        return this.resolveCompilationUnit(project, (Collection)ignoredProblems);
    }

    public String getName(ICompilerProject project, Collection<ICompilerProblem> problems) throws InterruptedException {
        ICompilationUnit cu = this.resolveCompilationUnit(project, (Collection)problems);
        if (cu == null) {
            return new String();
        }
        return ((EmbedCompilationUnit)cu).getName();
    }
}

