/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.targets;

import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.flex.abc.ABCLinker;
import org.apache.flex.compiler.config.RSLSettings;
import org.apache.flex.compiler.definitions.IDefinition;
import org.apache.flex.compiler.definitions.references.IResolvedQualifiersReference;
import org.apache.flex.compiler.definitions.references.ReferenceFactory;
import org.apache.flex.compiler.exceptions.BuildCanceledException;
import org.apache.flex.compiler.internal.definitions.ClassDefinition;
import org.apache.flex.compiler.internal.projects.CompilerProject;
import org.apache.flex.compiler.internal.projects.FlexProject;
import org.apache.flex.compiler.internal.scopes.ASProjectScope;
import org.apache.flex.compiler.internal.targets.ITargetAttributes;
import org.apache.flex.compiler.internal.targets.Target;
import org.apache.flex.compiler.internal.targets.TargetReport;
import org.apache.flex.compiler.internal.units.SWCCompilationUnit;
import org.apache.flex.compiler.problems.ICompilerProblem;
import org.apache.flex.compiler.targets.ISWFTarget;
import org.apache.flex.compiler.targets.ITarget;
import org.apache.flex.compiler.targets.ITargetProgressMonitor;
import org.apache.flex.compiler.targets.ITargetReport;
import org.apache.flex.compiler.targets.ITargetSettings;
import org.apache.flex.compiler.units.ICompilationUnit;
import org.apache.flex.swc.ISWC;
import org.apache.flex.swc.ISWCLibrary;
import org.apache.flex.swf.ISWF;
import org.apache.flex.swf.SWF;
import org.apache.flex.swf.SWFFrame;
import org.apache.flex.swf.tags.DoABCTag;
import org.apache.flex.swf.tags.IManagedTag;
import org.apache.flex.swf.tags.ITag;
import org.apache.flex.swf.tags.ScriptLimitsTag;
import org.apache.flex.swf.tags.SymbolClassTag;
import org.apache.flex.swf.types.RGB;
import org.apache.flex.swf.types.Rect;

public abstract class SWFTarget
extends Target
implements ISWFTarget {
    private Collection<ICompilerProblem> problemCollection;
    private Target.RootedCompilationUnits rootedCompilationUnits;
    protected Set<String> metadataDonators = new HashSet<String>();
    private List<ICompilationUnit> rootedCompilationUnitsAndDependenciesInSWFOrder;
    private FramesInformation framesInformation;
    private RGB swfBackgroundColor;
    private ITargetAttributes _targetAttributes;
    private String pathContainingObject;

    public SWFTarget(CompilerProject project, ITargetSettings targetSettings, ITargetProgressMonitor progressMonitor) {
        super(project, targetSettings, progressMonitor);
    }

    @Override
    public Target.RootedCompilationUnits getRootedCompilationUnits() throws InterruptedException {
        if (this.rootedCompilationUnits == null) {
            this.rootedCompilationUnits = this.computeRootedCompilationUnits();
        }
        return this.rootedCompilationUnits;
    }

    List<ICompilationUnit> getReachableCompilationUnitsInSWFOrder(Collection<ICompilationUnit> roots) throws InterruptedException {
        List<ICompilationUnit> ret = null;
        Target.RootedCompilationUnits rootedCompilationUnits = this.getRootedCompilationUnits();
        boolean passedInRootedCompilationUnits = false;
        if (roots.size() == rootedCompilationUnits.getUnits().size()) {
            passedInRootedCompilationUnits = true;
            for (ICompilationUnit cu : roots) {
                if (rootedCompilationUnits.getUnits().contains(cu)) continue;
                passedInRootedCompilationUnits = false;
            }
        }
        if (passedInRootedCompilationUnits) {
            if (this.rootedCompilationUnitsAndDependenciesInSWFOrder == null) {
                this.rootedCompilationUnitsAndDependenciesInSWFOrder = this.project.getReachableCompilationUnitsInSWFOrder(roots);
            }
            ret = this.rootedCompilationUnitsAndDependenciesInSWFOrder;
        } else {
            ret = this.project.getReachableCompilationUnitsInSWFOrder(roots);
        }
        assert (ret != null);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ISWF build(Collection<ICompilerProblem> problems) {
        ISWF iSWF;
        this.buildStarted();
        try {
            Iterable<ICompilerProblem> fatalProblems = this.getFatalProblems();
            if (!Iterables.isEmpty(fatalProblems)) {
                Iterables.addAll(problems, fatalProblems);
                ISWF iSWF2 = null;
                return iSWF2;
            }
            HashSet<ICompilationUnit> compilationUnitSet = new HashSet<ICompilationUnit>();
            Target.RootedCompilationUnits rootedCompilationUnits = this.getRootedCompilationUnits();
            if (rootedCompilationUnits.getUnits().isEmpty()) {
                SWF sWF = this.buildEmptySWF();
                return sWF;
            }
            compilationUnitSet.addAll(rootedCompilationUnits.getUnits());
            this.problemCollection = problems;
            FramesInformation frames = this.getFramesInformation();
            Target.BuiltCompilationUnitSet builtCompilationUnits = this.getBuiltCompilationUnitSet();
            Iterables.addAll(problems, builtCompilationUnits.problems);
            this.doPostBuildWork(builtCompilationUnits.compilationUnits, problems);
            ISWF swf = this.initializeSWF(this.getReachableCompilationUnitsInSWFOrder(rootedCompilationUnits.getUnits()));
            HashSet<ICompilationUnit> emittedCompilationUnits = new HashSet<ICompilationUnit>();
            frames.createFrames(this, swf, builtCompilationUnits.compilationUnits, emittedCompilationUnits, problems);
            this.createLinkReport(problems);
            ISWF iSWF3 = this.linkSWF(swf);
            return iSWF3;
        }
        catch (BuildCanceledException bce) {
            iSWF = null;
            return iSWF;
        }
        catch (InterruptedException ie) {
            iSWF = null;
            return iSWF;
        }
        finally {
            this.buildFinished();
        }
    }

    @Override
    public ITarget.TargetType getTargetType() {
        return ITarget.TargetType.SWF;
    }

    protected final ITargetAttributes getTargetAttributes() throws InterruptedException {
        if (this._targetAttributes == null) {
            this._targetAttributes = this.computeTargetAttributes();
        }
        return this._targetAttributes;
    }

    protected abstract ITargetAttributes computeTargetAttributes() throws InterruptedException;

    protected abstract FramesInformation computeFramesInformation() throws InterruptedException;

    protected final FramesInformation getFramesInformation() throws InterruptedException {
        if (this.framesInformation != null) {
            return this.framesInformation;
        }
        this.framesInformation = this.computeFramesInformation();
        return this.framesInformation;
    }

    protected void doPostBuildWork(ImmutableSet<ICompilationUnit> compilationUnits, Collection<ICompilerProblem> problems) throws InterruptedException {
    }

    protected SWF buildEmptySWF() {
        return new SWF();
    }

    protected void reportProblem(ICompilerProblem problem) {
        assert (this.problemCollection != null);
        this.problemCollection.add(problem);
    }

    protected SWFFrame createWithClassesAndItsDependencies(SWFFrame frame, Collection<ClassDefinition> frameRootClasses, ASProjectScope projectScope, boolean allowExternals, Set<ICompilationUnit> emittedCompilationUnits) throws InterruptedException {
        LinkedList<ICompilationUnit> rootedUnitsForFrame = new LinkedList<ICompilationUnit>();
        for (ClassDefinition frameRootClass : frameRootClasses) {
            Collection<IDefinition> extraDefinitions = frameRootClass.resolveExtraClasses(this.project);
            ICompilationUnit frameFactoryClassCompilationUnit = projectScope.getCompilationUnitForDefinition(frameRootClass);
            assert (frameFactoryClassCompilationUnit != null);
            rootedUnitsForFrame.add(frameFactoryClassCompilationUnit);
            for (IDefinition extraDef : extraDefinitions) {
                if (extraDef.isImplicit()) continue;
                ICompilationUnit extraDefCompilationUnit = projectScope.getCompilationUnitForDefinition(extraDef);
                assert (extraDefCompilationUnit != null);
                rootedUnitsForFrame.add(extraDefCompilationUnit);
            }
        }
        if (frame == null) {
            frame = new SWFFrame();
        }
        if (!this.addCompilationUnitsAndDependenciesToFrame(frame, rootedUnitsForFrame, allowExternals, emittedCompilationUnits)) {
            return null;
        }
        return frame;
    }

    protected boolean addCompilationUnitsAndDependenciesToFrame(SWFFrame frame, Collection<ICompilationUnit> rootedUnitsForFrame, boolean allowExternals, Set<ICompilationUnit> emittedCompilationUnits) throws InterruptedException {
        List<ICompilationUnit> unitsForFrame = this.getReachableCompilationUnitsInSWFOrder(rootedUnitsForFrame);
        for (ICompilationUnit cu : unitsForFrame) {
            boolean tagsAdded;
            if (!emittedCompilationUnits.add(cu)) continue;
            boolean includeCu = this.testCompilationUnitLinkage(cu, allowExternals);
            this.doAddMetadataNamesToTarget(cu, includeCu);
            if (!includeCu || (tagsAdded = cu.getSWFTagsRequest().get().addToFrame(frame))) continue;
            return false;
        }
        return true;
    }

    protected void doAddMetadataNamesToTarget(ICompilationUnit cu, boolean linkedIn) {
        if (this.shouldAddMetadataNamesToTarget(cu, linkedIn) && this.metadataDonators.add(cu.getAbsoluteFilename())) {
            ISWC swc = this.project.getWorkspace().getSWCManager().get(new File(cu.getAbsoluteFilename()));
            for (ISWCLibrary library : swc.getLibraries()) {
                this.addASMetadataNames(library.getKeepAS3MetadataSet());
            }
        }
    }

    protected boolean shouldAddMetadataNamesToTarget(ICompilationUnit cu, boolean linkedIn) {
        return cu.getCompilationUnitType() == ICompilationUnit.UnitType.SWC_UNIT && !this.isLinkageAlwaysExternal(cu);
    }

    protected boolean testCompilationUnitLinkage(ICompilationUnit cu, boolean allowExternals) throws InterruptedException {
        boolean includeCu = true;
        if (!allowExternals) {
            includeCu = !this.isLinkageAlwaysExternal(cu);
        } else if (this.isLinkageExternal(cu, this.targetSettings)) {
            includeCu = false;
        }
        return includeCu;
    }

    private boolean isLinkageAlwaysExternal(ICompilationUnit cu) {
        if (cu.getCompilationUnitType() != ICompilationUnit.UnitType.SWC_UNIT) {
            return false;
        }
        if (this.pathContainingObject == null) {
            IResolvedQualifiersReference objectReference = ReferenceFactory.packageQualifiedReference(this.project.getWorkspace(), "Object");
            Set<ICompilationUnit> units = this.project.getScope().getCompilationUnitsForReferences(Collections.singletonList(objectReference));
            assert (units.size() == 1);
            this.pathContainingObject = units.iterator().next().getAbsoluteFilename();
            assert (this.pathContainingObject != null);
        }
        if (this.pathContainingObject.equals(cu.getAbsoluteFilename())) {
            return true;
        }
        if (cu instanceof SWCCompilationUnit) {
            return ((SWCCompilationUnit)cu).isANE();
        }
        return false;
    }

    protected abstract void addLinkedABCToFrame(SWFFrame var1, Iterable<DoABCTag> var2, ABCLinker.ABCLinkerSettings var3) throws Exception;

    protected abstract void setKeepAS3MetadataLinkerSetting(ABCLinker.ABCLinkerSettings var1);

    protected ISWF linkSWF(ISWF unLinked) {
        SWF result = new SWF();
        if (unLinked.getBackgroundColor() != null) {
            result.setBackgroundColor(unLinked.getBackgroundColor());
        }
        result.setEnableDebugger2(unLinked.getEnableDebugger2());
        result.setFrameRate(unLinked.getFrameRate());
        result.setFrameSize(unLinked.getFrameSize());
        result.setMetadata(unLinked.getMetadata());
        ScriptLimitsTag scriptLimits = unLinked.getScriptLimits();
        if (scriptLimits != null) {
            result.setScriptLimits(scriptLimits.getMaxRecursionDepth(), scriptLimits.getScriptTimeoutSeconds());
        }
        result.setTopLevelClass(unLinked.getTopLevelClass());
        result.setUseAS3(unLinked.getUseAS3());
        result.setUseDirectBlit(unLinked.getUseDirectBlit());
        result.setUseGPU(unLinked.getUseGPU());
        result.setUseNetwork(unLinked.getUseNetwork());
        result.setVersion(unLinked.getVersion());
        result.setProductInfo(unLinked.getProductInfo());
        ITargetSettings settings = this.getTargetSettings();
        ABCLinker.ABCLinkerSettings linkSettings = new ABCLinker.ABCLinkerSettings();
        linkSettings.setOptimize(settings.isOptimized());
        linkSettings.setEnableInlining(this.project.isInliningEnabled());
        linkSettings.setStripDebugOpcodes(!settings.isDebugEnabled());
        linkSettings.setStripGotoDefinitionHelp(!settings.isDebugEnabled());
        linkSettings.setStripFileAttributeFromGotoDefinitionHelp(settings.isOptimized());
        linkSettings.setProblemsCollection(this.problemCollection);
        linkSettings.setRemoveDeadCode(settings.getRemoveDeadCode());
        Collection<String> metadataNames = this.getASMetadataNames();
        if (settings.isDebugEnabled() && metadataNames != null) {
            ArrayList<String> names = new ArrayList<String>(metadataNames);
            names.add("__go_to_definition_help");
            names.add("__go_to_ctor_definition_help");
            metadataNames = names;
        }
        this.setKeepAS3MetadataLinkerSetting(linkSettings);
        for (int i = 0; i < unLinked.getFrameCount(); ++i) {
            SWFFrame unlinkedFrame = unLinked.getFrameAt(i);
            SWFFrame resultFrame = new SWFFrame();
            if (unlinkedFrame.getName() != null) {
                resultFrame.setName(unlinkedFrame.getName(), unlinkedFrame.hasNamedAnchor());
            }
            LinkedList<DoABCTag> accumulatedABC = new LinkedList<DoABCTag>();
            for (ITag unlinkedTag : unlinkedFrame) {
                if (unlinkedTag instanceof DoABCTag) {
                    DoABCTag abcTag = (DoABCTag)unlinkedTag;
                    accumulatedABC.add(abcTag);
                    continue;
                }
                if (!accumulatedABC.isEmpty()) {
                    try {
                        this.addLinkedABCToFrame(resultFrame, accumulatedABC, linkSettings);
                    }
                    catch (Exception e) {
                        return unLinked;
                    }
                    accumulatedABC.clear();
                }
                if (!(unlinkedTag instanceof IManagedTag)) {
                    resultFrame.addTag(unlinkedTag);
                    continue;
                }
                if (!(unlinkedTag instanceof SymbolClassTag)) continue;
                SymbolClassTag s = (SymbolClassTag)unlinkedTag;
                for (String symbol_name : s.getSymbolNames()) {
                    resultFrame.defineSymbol(s.getSymbol(symbol_name), symbol_name);
                }
            }
            if (!accumulatedABC.isEmpty()) {
                try {
                    this.addLinkedABCToFrame(resultFrame, accumulatedABC, linkSettings);
                }
                catch (Exception e) {
                    return unLinked;
                }
                accumulatedABC.clear();
            }
            result.addFrame(resultFrame);
        }
        return result;
    }

    @Override
    protected Target.RootedCompilationUnits computeRootedCompilationUnits() throws InterruptedException {
        FramesInformation framesInfo = this.getFramesInformation();
        Target.RootedCompilationUnits rootedCompilationUnits = new Target.RootedCompilationUnits((Set<ICompilationUnit>)ImmutableSet.copyOf(framesInfo.getAllCompilationUnits()), framesInfo.getProblems());
        return rootedCompilationUnits;
    }

    protected ISWF initializeSWF(List<ICompilationUnit> reachableCompilationUnits) throws InterruptedException {
        int swfVersion = this.targetSettings.getSWFVersion();
        int swfWidth = this.targetSettings.getDefaultWidth();
        ITargetAttributes targetAttributes = this.getTargetAttributes();
        Float attrWidth = targetAttributes.getWidth();
        if (attrWidth != null) {
            swfWidth = attrWidth.intValue();
        }
        int swfHeight = this.targetSettings.getDefaultHeight();
        Float attrHeight = targetAttributes.getHeight();
        if (attrHeight != null) {
            swfHeight = attrHeight.intValue();
        }
        Rect swfFrameSize = new Rect(20 * swfWidth, 20 * swfHeight);
        float swfFrameRate = this.targetSettings.getDefaultFrameRate();
        Float attrFrameRate = targetAttributes.getFrameRate();
        if (attrFrameRate != null) {
            swfFrameRate = attrFrameRate.floatValue();
        }
        boolean swfUseDirectBlit = this.targetSettings.useDirectBlit();
        Boolean attrUseDirectBlit = targetAttributes.getUseDirectBlit();
        if (attrUseDirectBlit != null) {
            swfUseDirectBlit = attrUseDirectBlit;
        }
        boolean swfUseGPU = this.targetSettings.useGPU();
        Boolean attrUseGPU = targetAttributes.getUseGPU();
        if (attrUseGPU != null) {
            swfUseGPU = attrUseGPU;
        }
        RGB swfBackgroundColorRGB = this.getBackgroundColor();
        SWF swf = new SWF();
        swf.setVersion(swfVersion);
        swf.setFrameSize(swfFrameSize);
        swf.setFrameRate(swfFrameRate);
        swf.setUseDirectBlit(swfUseDirectBlit);
        swf.setUseGPU(swfUseGPU);
        swf.setBackgroundColor(swfBackgroundColorRGB);
        swf.setUseAS3(swfVersion >= 9);
        swf.setUseNetwork(this.targetSettings.useNetwork());
        swf.setMetadata(this.targetSettings.getSWFMetadata());
        Integer attrScriptRecursionLimit = targetAttributes.getScriptRecursionLimit();
        Integer attrScriptTimeLimit = targetAttributes.getScriptTimeLimit();
        if (this.targetSettings.areDefaultScriptLimitsSet() || attrScriptRecursionLimit != null || attrScriptTimeLimit != null) {
            int swfMaxRecursionDepth = this.targetSettings.getDefaultScriptRecursionLimit();
            if (attrScriptRecursionLimit != null) {
                swfMaxRecursionDepth = attrScriptRecursionLimit;
            }
            int swfScriptTimeoutSeconds = this.targetSettings.getDefaultScriptTimeLimit();
            if (attrScriptTimeLimit != null) {
                swfScriptTimeoutSeconds = attrScriptTimeLimit;
            }
            swf.setScriptLimits(swfMaxRecursionDepth, swfScriptTimeoutSeconds);
        }
        return swf;
    }

    protected final RGB getBackgroundColor() throws InterruptedException {
        if (this.swfBackgroundColor != null) {
            return this.swfBackgroundColor;
        }
        int swfBackgroundColorInt = this.targetSettings.getDefaultBackgroundColor();
        String attrBackgroundColorString = this.getTargetAttributes().getBackgroundColor();
        if (!Strings.isNullOrEmpty((String)attrBackgroundColorString)) {
            swfBackgroundColorInt = this.project instanceof FlexProject ? ((FlexProject)this.project).getColorAsInt(attrBackgroundColorString) : Integer.decode(attrBackgroundColorString).intValue();
        }
        this.swfBackgroundColor = new RGB(swfBackgroundColorInt);
        return this.swfBackgroundColor;
    }

    @Override
    protected ITargetReport computeTargetReport() throws InterruptedException {
        Target.BuiltCompilationUnitSet builtCompilationUnits = this.getBuiltCompilationUnitSet();
        return new TargetReport(this.project, builtCompilationUnits.compilationUnits, Collections.<RSLSettings>emptyList(), this.getBackgroundColor(), this.targetSettings, this.getTargetAttributes(), this.getLinkageChecker());
    }

    protected static class FramesInformation {
        public final Iterable<SWFFrameInfo> frameInfos;

        public FramesInformation(Iterable<SWFFrameInfo> frameInfos) {
            this.frameInfos = frameInfos;
        }

        final Iterable<ICompilerProblem> getProblems() {
            Iterable problemIterables = Iterables.transform(this.frameInfos, (Function)new Function<SWFFrameInfo, Iterable<ICompilerProblem>>(){

                public Iterable<ICompilerProblem> apply(SWFFrameInfo frame) {
                    return frame.problems;
                }
            });
            return Iterables.concat((Iterable)problemIterables);
        }

        final Iterable<ICompilationUnit> getAllCompilationUnits() {
            Iterable compilationUnitIterables = Iterables.transform(this.frameInfos, (Function)new Function<SWFFrameInfo, Iterable<ICompilationUnit>>(){

                public Iterable<ICompilationUnit> apply(SWFFrameInfo frame) {
                    return frame.rootedUnits;
                }
            });
            return Iterables.concat((Iterable)compilationUnitIterables);
        }

        protected final SWFFrame createFrame(SWFTarget swfTarget, SWFFrameInfo frameInfo, ImmutableSet<ICompilationUnit> builtCompilationUnits, Set<ICompilationUnit> emittedCompilationUnits, Collection<ICompilerProblem> problems) throws InterruptedException {
            Iterables.addAll(problems, frameInfo.problems);
            SWFFrame swfFrame = new SWFFrame();
            if (frameInfo.frameLabel != null) {
                swfFrame.setName(frameInfo.frameLabel, true);
            }
            assert (Sets.difference(frameInfo.rootedUnits, builtCompilationUnits).isEmpty()) : "All compilation units to emit on this frame should have been built!";
            if (!swfTarget.addCompilationUnitsAndDependenciesToFrame(swfFrame, frameInfo.rootedUnits, frameInfo.allowExternals, emittedCompilationUnits)) {
                return null;
            }
            return swfFrame;
        }

        protected void createFrames(SWFTarget swfTarget, ISWF swf, ImmutableSet<ICompilationUnit> builtCompilationUnits, Set<ICompilationUnit> emittedCompilationUnits, Collection<ICompilerProblem> problems) throws InterruptedException {
            for (SWFFrameInfo frameInfo : this.frameInfos) {
                SWFFrame swfFrame = this.createFrame(swfTarget, frameInfo, builtCompilationUnits, emittedCompilationUnits, problems);
                swf.addFrame(swfFrame);
            }
        }
    }

    protected static final class SWFFrameInfo {
        public static final boolean EXTERNS_ALLOWED = true;
        public static final boolean EXTERNS_DISALLOWED = false;
        public final String frameLabel;
        public final boolean allowExternals;
        public final Set<ICompilationUnit> rootedUnits;
        public final Iterable<ICompilerProblem> problems;

        public SWFFrameInfo(String frameLabel, boolean allowExternals, Set<ICompilationUnit> rootedUnits, Iterable<ICompilerProblem> problems) {
            this.frameLabel = frameLabel != null ? frameLabel.replaceAll("[^A-Za-z0-9]", "_") : null;
            this.allowExternals = allowExternals;
            this.rootedUnits = rootedUnits;
            this.problems = problems;
        }

        public SWFFrameInfo(Set<ICompilationUnit> rootedUnits, Iterable<ICompilerProblem> problems) {
            this(null, true, rootedUnits, problems);
        }
    }
}

